<?php
$items = isset($this->items) ? $this->items : array();
if (empty($items) || !is_array($items)) {
    echo '<tr><td colspan="5" class="text-muted">No hay ítems en el pedido.</td></tr>';
    return;
}
$moneda = Session::get('moneda');
foreach ($items as $item):
    $prod = isset($item->Producto) ? $item->Producto : null;
    $nombre = $prod ? (isset($prod->pro_nom) ? $prod->pro_nom : '') : '';
    $presentacion = $prod ? (isset($prod->pro_pre) ? $prod->pro_pre : '') : '';
    $cant = isset($item->cantidad) ? (int)$item->cantidad : 0;
    $precio = isset($item->precio) ? $item->precio : 0;
    $total = $cant * (float)$precio;
    $id_pres = (int)(isset($item->id_pres) ? $item->id_pres : 0);
    $toppings_raw = isset($item->toppings_raw) ? $item->toppings_raw : '';
    $item_key = $id_pres . '_' . str_replace(',', '.', (string)$precio) . '_' . md5($toppings_raw);
?>
<tr class="item-precuenta" data-id_pres="<?php echo $id_pres; ?>" data-precio="<?php echo htmlspecialchars($precio); ?>" data-toppings_raw="<?php echo htmlspecialchars($toppings_raw); ?>" data-itemkey="<?php echo htmlspecialchars($item_key); ?>" data-producto="<?php echo htmlspecialchars($nombre); ?>" data-presentacion="<?php echo htmlspecialchars($presentacion); ?>" data-cantidad="<?php echo $cant; ?>" data-total="<?php echo number_format($total, 2); ?>">
    <td><?php echo htmlspecialchars($nombre); ?> <span class="label label-warning"><?php echo htmlspecialchars($presentacion); ?></span></td>
    <td class="text-center"><?php echo $cant; ?></td>
    <td class="text-right"><?php echo $moneda; ?> <?php echo number_format((float)$precio, 2); ?></td>
    <td class="text-right"><?php echo $moneda; ?> <?php echo number_format($total, 2); ?></td>
    <td>
        <select class="form-control form-control-sm asignar-precuenta" name="asignar_<?php echo $item_key; ?>">
            <option value="">Sin asignar</option>
        </select>
    </td>
</tr>
<?php endforeach; ?>
