/* LEYENDA ESTADO DE LOS PLATOS
a = solicitado
b = preparacion
c = preparado
d = entregado
z = anulado
*/

$(function() {
	nropedidosMesa();
	setInterval(nropedidosMesa, 10000);
	nropedidosMostrador();
	setInterval(nropedidosMostrador, 10000);
	nropedidosDelivery();
	setInterval(nropedidosDelivery, 10000);
	listarKanban();
	setInterval(listarKanban, 10000);
	// atendido_pedidos();
	// setInterval(atendido_pedidos, 40000);
	$('#area-p').addClass("active");
	$('.container-fluid').addClass('p-10');
});


/* Mostrar todos los pedidos realizados en las mesas */
var contMe = 0;
var nropedidosMesa = function(){
	$.ajax({
        type: "post",
        dataType: "json",
        url: $('#url').val()+'produccion/mesas_list',
        success: function (data){
        	if(data.length == 0){
        		$('#cant_pedidos_mesa').text('');
        		pedidosMesa();
        		contMe = 0;
        	}
	        $.each(data, function(i, item) {
				var nroPedMe = parseInt(item.Total.nro_p);
				$('#cant_pedidos_mesa').text(nroPedMe);
	    		if(parseInt(nroPedMe) !== contMe){
	    			contMe = 0;
	    			pedidosMesa();
	    			var sound = new buzz.sound("public/sound/ding_ding", {
						formats: [ "ogg", "mp3", "aac" ]
					});
					sound.play();
					contMe = nroPedMe + contMe;
	    		}
	    		//console.log('contMe = '+contMe+' <> NroPedMe = '+nroPedMe);
			});
		}
	})
}

var pedidosMesa = function(){
	moment.locale('es');
	$('#list_pedidos_mesa').html('<tr><td colspan="6"><div class="m-t-40 m-b-40 text-center"><div class="spinner-border" role="status"><span class="sr-only">Loading...</span></div></div></td></tr>');
	$.ajax({
        type: "post",
        dataType: "json",
        url: $('#url').val()+'produccion/mesas_list',
        success: function (data){
        $('#list_pedidos_mesa').empty();
        $.each(data, function(i, item) {
    		var horaPedido = moment(item.fecha_pedido).fromNow();
    		if (item.id_tipo == 2){
				probar = 'success';
				nombar = 'EN ESPERA';
				accion = 'atendido';
    		} else if(item.id_tipo == 1){
    			if(item.estado == 'a'){
					probar = 'success';
					nombar = 'EN ESPERA';
					accion = 'preparacion';
	    		} else if(item.estado == 'b'){
					probar = 'warning';
					nombar = 'EN PREPARACION';
					accion = 'atendido';
	    		}
    		}

    		var comentario = (item.comentario !== '') ? '<small class="text-uppercase font-14"><i class="fa fa-comment"></i> '+item.comentario+'</small>' : '';
			var toppings_formatted = (item.toppings_formatted !== '') ? '<small class="text-uppercase font-12 text-primary"><i class="fa fa-plus-circle"></i> Toppings: '+item.toppings_formatted+'</small><br>' : '';

    		$('#list_pedidos_mesa')
	            .append(
	                $('<tr class="tr-left-2"/>')
	                .append(
	                    $('<td/>')
	                    .html('<h5 class="m-b-0">N° '+item.nro_mesa+'</h5><h6 class="text-muted">'+item.desc_salon+'</h6>')
	                )
	                .append(
	                    $('<td/>')
	                    .html('<h6 class="m-b-0"><label class="font-bold m-b-0 text-danger">'+item.cantidad+' UNI</label> '+item.nombre_prod+' <br><span class="label label-info">'+item.pres_prod+'</span>'
	                    	+'&nbsp;<span class="label label-warning">'+item.Producto.pro_cat+'</span></h6>'
	                    	+(toppings_formatted)
	                    	+comentario)
	                )
	                .append(
	                    $('<td/>')
	                    .html('<span class="font-12 font-bold">'+horaPedido+'</span>')
	                )
	                .append(
	                    $('<td/>')
	                    .html('<span class="label label-'+probar+' font-8 p-10">'+nombar+'</span>')
	                )
	                .append(
	                    $('<td/>')
	                    .html(item.nombres+' '+item.ape_paterno)
	                )
	                .append(
	                    $('<td class="text-right"/>')
	                    .html('<a onclick="'+accion+'('+item.id_pedido+','+item.id_pres+',\''+item.fecha_pedido+'\');">'
	                    	+'<button type="button" class="btn btn-circle btn-lg btn-success"><i class="ti-check"></i></button></a>')
	                )
	            );
    		})
        }
    });
}

/* Mostrar todos los pedidos realizados en el mostrador o para llevar */
var contMo = 0;
var nropedidosMostrador = function(){
	$.ajax({
        type: "post",
        dataType: "json",
        url: $('#url').val()+'produccion/mostrador_list',
        success: function (data){
        	//console.log('A:'+data);
        	if(data.length == 0){
        		$('#cant_pedidos_most').text('');
        		pedidosMostrador();
        		contMo = 0;
        	}
        	$.each(data, function(i, item) {
        		//console.log('B:'+item);
				var nroPedMo = parseInt(item.Total.nro_p);
				$('#cant_pedidos_most').text(nroPedMo);
				//console.log('C:'+nroPedMo);
	    		if(parseInt(nroPedMo) !== contMo){
	    			contMo = 0;
	    			pedidosMostrador();
	    			var sound = new buzz.sound("public/sound/ding_ding", {
						formats: [ "ogg", "mp3", "aac" ]
					});
					sound.play();
					contMo = nroPedMo + contMo;
					//console.log('D:'+contMo);
	    		}
	    		//console.log('contMo = '+contMo+' <> NroPedMo = '+nroPedMo);
			})
		}
	})
}

var pedidosMostrador = function(){
	moment.locale('es');
	$('#list_pedidos_most').html('<tr><td colspan="6"><div class="m-t-40 m-b-40 text-center"><div class="spinner-border" role="status"><span class="sr-only">Loading...</span></div></div></td></tr>');
	$.ajax({
        type: "post",
        dataType: "json",
        url: $('#url').val()+'produccion/mostrador_list',
        success: function (data){
        $('#list_pedidos_most').empty();
        $.each(data, function(i, item) {
    		var horaPedido = moment(item.fecha_pedido).fromNow();
    		if (item.id_tipo == 2){
    			probar = 'success';
    			nombar = 'EN ESPERA';
    			accion = 'atendido';
    		} else if(item.id_tipo == 1){
    			if(item.estado == 'a'){
		    		probar = 'success';
		    		nombar = 'EN ESPERA';
		    		accion = 'preparacion';
	    		} else if(item.estado == 'b'){
    				probar = 'warning';
    				nombar = 'EN PREPARACION';
    				accion = 'atendido';
	    		}
    		}

    		var comentario = (item.comentario !== '') ? '<small class="text-uppercase font-14"><i class="fa fa-comment"></i> '+item.comentario+'</small>' : '';
			var toppings_formatted = (item.toppings_formatted !== '') ? '<small class="text-uppercase font-12 text-primary"><i class="fa fa-plus-circle"></i> Toppings: '+item.toppings_formatted+'</small><br>' : '';

    		$('#list_pedidos_most')
	            .append(
	                $('<tr class="tr-left-2"/>')
	                .append(
	                    $('<td/>')
	                    .html('<h5 class="m-b-0">'+item.nro_mesa+'</h5><h6 class="text-muted">N&uacute;mero</h6>')
	                )
	                .append(
	                    $('<td/>')
	                    .html('<h4 class="m-b-0"><label class="font-bold m-b-0 text-danger">'+item.cantidad+' UNI</label> '+item.nombre_prod+' <br><span class="label label-info">'+item.pres_prod+'</span>'
	                    	+'&nbsp;<span class="label label-warning">'+item.Producto.pro_cat+'</span></h4>'
	                    	+(toppings_formatted)
	                    	+comentario)
	                )
	                .append(
	                    $('<td/>')
	                    .html('<span class="font-12 font-bold">'+horaPedido+'</span>')
	                )
	                .append(
	                    $('<td/>')
	                    .html('<span class="label label-'+probar+' font-12 p-10">'+nombar+'</span>')
	                )
	                .append(
	                    $('<td/>')
	                    .html(item.nombres+' '+item.ape_paterno)
	                )
	                .append(
	                    $('<td class="text-right"/>')
	                    .html('<a onclick="'+accion+'('+item.id_pedido+','+item.id_pres+',\''+item.fecha_pedido+'\');">'
	                    	+'<button type="button" class="btn btn-circle btn-lg btn-success"><i class="ti-check"></i></button></a>')
	                )
	            );
    		})
        }
    });
}

/* Mostrar todos los pedidos realizados en el mostrador o para llevar */
var contDe = 0;
var nropedidosDelivery = function(){
	$.ajax({
        type: "post",
        dataType: "json",
        url: $('#url').val()+'produccion/delivery_list',
        success: function (data){
        	if(data.length == 0){
        		$('#cant_pedidos_del').text('');
        		pedidosDelivery();
        		contDe = 0;
        	}
	        $.each(data, function(i, item) {
				var nroPedDe = parseInt(item.Total.nro_p);
				$('#cant_pedidos_del').text(nroPedDe);
	    		if(parseInt(nroPedDe) !== contDe){
	    			contDe = 0;
	    			pedidosDelivery();
	    			var sound = new buzz.sound("public/sound/ding_ding", {
						formats: [ "ogg", "mp3", "aac" ]
					});
					sound.play();
					contDe = nroPedDe + contDe;
	    		}
	    		//console.log('contDe = '+contDe+' <> NroPedDe = '+nroPedDe);
			})
		}
	})
}

var pedidosDelivery = function(){
	moment.locale('es');
	$('#list_pedidos_del').html('<tr><td colspan="6"><div class="m-t-40 m-b-40 text-center"><div class="spinner-border" role="status"><span class="sr-only">Loading...</span></div></div></td></tr>');
	$.ajax({
        type: "post",
        dataType: "json",
        url: $('#url').val()+'produccion/delivery_list',
        success: function (data){
        $('#list_pedidos_del').empty();
        $.each(data, function(i, item) {
    		var horaPedido = moment(item.fecha_pedido).fromNow();
    		$('#cant_pedidos_del').text(item.Total.nro_p);
    		if (item.id_tipo == 2){
	    		probar = 'success';
	    		nombar = 'EN ESPERA';
	    		accion = 'atendido';
    		} else if(item.id_tipo == 1){
    			if(item.estado == 'a'){
	    			probar = 'success';
	    			nombar = 'EN ESPERA';
	    			accion = 'preparacion';
	    		} else if(item.estado == 'b'){
	    			probar = 'warning';
	    			nombar = 'EN PREPARACION';
	    			accion = 'atendido';
	    		}
    		}

    		var comentario = (item.comentario !== '') ? '<small class="text-uppercase font-14"><i class="fa fa-comment"></i> '+item.comentario+'</small>' : '';
			var toppings_formatted = (item.toppings_formatted !== '') ? '<small class="text-uppercase font-12 text-primary"><i class="fa fa-plus-circle"></i> Toppings: '+item.toppings_formatted+'</small><br>' : '';

    		$('#list_pedidos_del')
	            .append(
	                $('<tr class="tr-left-2"/>')
	                .append(
	                    $('<td/>')
	                    .html('<h5 class="m-b-0">'+item.nro_mesa+'</h5><h6 class="text-muted">N&uacute;mero</h6>')
	                )
	                .append(
	                    $('<td/>')
	                    .html('<h4 class="m-b-0"><label class="font-bold m-b-0 text-danger">'+item.cantidad+' UNI</label> '+item.nombre_prod+' <br><span class="label label-info">'+item.pres_prod+'</span>'
	                    	+'&nbsp;<span class="label label-warning">'+item.Producto.pro_cat+'</span></h4>'
	                    	+(toppings_formatted)
	                    	+comentario)
	                )
	                .append(
	                    $('<td/>')
	                    .html('<span class="font-12 font-bold">'+horaPedido+'</span>')
	                )
	                .append(
	                    $('<td/>')
	                    .html('<span class="label label-'+probar+' font-12 p-10">'+nombar+'</span>')
	                )
	                .append(
	                    $('<td/>')
	                    .html(item.nombres+' '+item.ape_paterno)
	                )
	                .append(
	                    $('<td class="text-right"/>')
	                    .html('<a onclick="'+accion+'('+item.id_pedido+','+item.id_pres+',\''+item.fecha_pedido+'\');">'
	                    	+'<button type="button" class="btn btn-circle btn-lg btn-success"><i class="ti-check"></i></button></a>')
	                )
	            );
    		})
        }
    });
}

var listarKanban = function(){
	let en_espera_items = ''
	let en_preparacion_items = ''
	let preparados_items = ''
	$.ajax({
		type: "post",
		dataType: "json",
		url: $('#url').val()+'produccion/kanban_detalle',
		success: function (data){
			if(data.length == 0){
				$('#cant_pedidos_kanban').text('');
				contDe = 0;
			}else{
				$('#cant_pedidos_kanban').text(data.length);
			}
			$.each(data, function(i, item) {
				let comentario = ''
				let tipo_atencion = ''
				let cambiar_estado = ''
				if(item.comentario != ''){
					comentario = `<i class="fa fa-comment-dots" aria-hidden="true"></i> ${item.comentario}`
				}
				if(item.tipo_atencion == 1){
					tipo_atencion = `<span class="badge badge-dark">MESA</span>`
				}
				if(item.tipo_atencion == 2){
					tipo_atencion = `<span class="badge badge-dark">MOSTRADOR</span>`
				}
				if(item.tipo_atencion == 3){
					tipo_atencion = `<span class="badge badge-dark">DELIVERY</span>`
				}
				if(item.estado == 'a'){
					cambiar_estado = `<a href="javascript:void(0)" class="btn btn-sm btn-warning" onclick="preparacion('${item.id_pedido}','${item.id_pres}','${item.fecha_pedido}')">Preparar</a>`
				}
				if(item.estado == 'b'){
					cambiar_estado = `<a href="javascript:void(0)" class="btn btn-sm btn-success" onclick="atendido('${item.id_pedido}','${item.id_pres}','${item.fecha_pedido}')">Preparado</a>`
				}
				let toppings_display = item.toppings_formatted ? `<div class="text-primary font-12"><i class="fa fa-plus-circle"></i> Toppings: ${item.toppings_formatted}</div>` : '';
				let itemTemplate = `
					<div class="card shadow-sm">
						<div class="card-body p-2">
							<div class="card-title">
								<div class="float-left">
									${tipo_atencion}
									<span class="badge badge-warning">${item.Producto.pro_cat}</span>
								</div>
								<div class="float-right text-info">
									<i class="fa fa-clock" aria-hidden="true"></i>  ${moment(item.fecha_pedido).fromNow()}
								</div>
								<div class="clearfix"></div>
							</div>
							<div class="clearfix"></div>
							<div class="p-10">
								<div class="text-xl-left text-uppercase">
									<div class="float-left">
										<span class="text-danger">${item.cantidad} UND</span> <span class="font-bold">${item.nombre_prod} ${item.pres_prod}</span>
									</div>
									<div class="float-right">
										${cambiar_estado}
									</div>
									<div class="clearfix"></div>
								</div>
								<div class="clearfix"></div>
								${toppings_display}
								<div>
									<span class="text-muted">VENDEDOR: ${item.nombres} ${item.ape_paterno}</span>
									<br>
									<br>
								</div>
								<div>
									<div class="float-left text-info">
										${comentario}
									</div>
									<div class="float-right">
										<span class="text-dark">N&deg; ${item.nro_mesa} - ${item.desc_salon}</span>
									</div>
									<div class="clearfix"></div>
								</div>
								<div class="clearfix"></div>
							</div>						
						</div>
					</div>`;
				if(item.estado == 'a'){
					en_espera_items += itemTemplate
				}
				if(item.estado == 'b'){
					en_preparacion_items += itemTemplate
				}
				if(item.estado == 'c'){
					preparados_items += itemTemplate
				}
			})
			$('#en_espera_items').html(en_espera_items)
			$('#en_preparacion_items').html(en_preparacion_items)
			$('#preparados_items').html(preparados_items)
		}
	})
}

var agrupacion_platos_list = function(){
	moment.locale('es');
	$('#agrupacion_platos_list').empty();
	$('#agrupacion_platos_list').html('<div class="col-lg-6 m-t-40 m-b-40 text-center"><div class="spinner-border" role="status"><span class="sr-only">Loading...</span></div></div>');
	$.ajax({
        //async: false,
        type: "post",
        dataType: "json",
        url: $('#url').val()+'produccion/agrupacion_platos_list',
        success: function (data){
        $('#agrupacion_platos_list').empty();

        $.each(data, function(i, item) {

			if (item.estado == 'a'){
				cssbtn = 'btn-success';
				accion_ped = 'platos_preparacion_pedidos';
			} else if(item.estado == 'b'){
				cssbtn = 'btn-warning';
				accion_ped = 'platos_atendido_pedidos';
			}

    		$('#agrupacion_platos_list')
    			.append(
	                $('<div class="col-lg-6"/>')
	                .html('<div class="card">'
	                	+'<div class="card-body p-0">'
	                	+'<div class="d-flex flex-wrap p-20 p-b-10 justify-center" style="background: #8196ac;"><div><h2 class="font-bold text-white">'+item.nombre_prod+' <span class="label label-danger p-10">'+item.pres_prod+'</span></h2></div><div class="ml-auto align-self-center"><label class="font-bold font-30 m-b-0" style="color: #fff947 !important;"><span class="total'+i+'"></span> UNI</label>'
						+'<a onclick="'+accion_ped+'('+item.id_pres+');" class="ml-3">'
						+'<button type="button" class="btn btn-lg '+cssbtn+'"><i class="ti-check"></i></button></a>'
						+'</div></div>'
						+'<div class="table-responsive">'
	                	+'<table class="table stylish-table b-t" id="table'+i+'">'
	                		+'<thead class="table-head">'
		                        +'<tr><th width="10%">Atención</th><th width="40%">Cantidad/Producto</th><th width="15%">Tiempo</th><th width="15%">Estado</th><th width="10%">Mozo/Cajero</th><th width="10%" class="text-right">Acci&oacute;n</th></tr>'
		                    +'</thead>'
		                    +'<tbody class="tb-st listdetalle'+i+'">')
	            );
	        	$.ajax({
					async: false,
			        type: "post",
			        dataType: "json",
			        url: $('#url').val()+'produccion/agrupacion_platos_detalle',
			        data: {
			        	nombre_prod : item.nombre_prod,
			        	pres_prod : item.pres_prod
			        },
			        success: function (dato){
			        var total_cantidad = 0;
			        $.each(dato, function(index, value) {
						var horaPedido = moment(value.fecha_pedido).fromNow();
						var tipo_atencion = (value.tipo_atencion == 1) ? '<h5 class="m-b-0">MESA: '+value.nro_mesa+'</h5><h6 class="text-muted">'+value.desc_salon+'</h6>' : '<h5 class="m-b-0">Nro: '+value.nro_mesa+'</h5><h6 class="text-muted">'+value.desc_salon+'</h6>';
			    		total_cantidad += parseFloat(value.cantidad);
			    		if (value.id_tipo == 2){
				    		probar = 'success';
				    		nombar = 'EN ESPERA';
				    		accion = 'atendido';
			    		} else if(value.id_tipo == 1){
			    			if(value.estado == 'a'){
				    			probar = 'success';
				    			nombar = 'EN ESPERA';
				    			accion = 'preparacion';
				    		} else if(value.estado == 'b'){
				    			probar = 'warning';
				    			nombar = 'EN PREPARACION';
				    			accion = 'atendido';
				    		}
			    		}

			    		var comentario = (value.comentario !== '') ? '<small class="text-uppercase font-14"><i class="fa fa-comment"></i> '+value.comentario+'</small>' : '';
						var toppings_formatted = (value.toppings_formatted !== '') ? '<small class="text-uppercase font-12 text-primary"><i class="fa fa-plus-circle"></i> Toppings: '+value.toppings_formatted+'</small><br>' : '';
						

			        	$('.listdetalle'+i)
				            .append(
				                $('<tr class="tr-left"/>')
				                .append(
				                    $('<td/>')
				                    .html(tipo_atencion)
				                )
				                .append(
				                    $('<td/>')
	                    .html('<h4 class="m-b-0"><label class="font-bold m-b-0 text-danger">'+value.cantidad+' UNI</label> '+value.nombre_prod+' <br><span class="label label-info">'+value.pres_prod+'</span>'
	                    	+'&nbsp;<span class="label label-warning">'+value.Producto.pro_cat+'</span></h4>'
	                    	+(toppings_formatted)
	                    	+comentario)
				                )
				                .append(
				                    $('<td/>')
				                    .html('<span class="font-12 font-bold">'+horaPedido+'</span>')
				                )
				                .append(
				                    $('<td/>')
				                    .html('<span class="label label-'+probar+' font-8 p-10">'+nombar+'</span>')
				                )
				                .append(
				                    $('<td/>')
				                    .html(value.nombres+' '+value.ape_paterno)
				                )
				                .append(
				                    $('<td class="text-right"/>')
				                    .html('<a onclick="'+accion+'('+value.id_pedido+','+value.id_pres+',\''+value.fecha_pedido+'\');">'
				                    	+'<button type="button" class="btn btn-circle btn-lg btn-success"><i class="ti-check"></i></button></a>')
				                )
				            );
			    		});
			        	$('.total'+i).text(total_cantidad);
			        }
			    });
    		});
        }
    });
}

var agrupacion_pedidos_list = function(){
	moment.locale('es');
	$('#agrupacion_pedidos_list').html('<div class="col-lg-6 m-t-10 m-b-10 text-center"><div class="spinner-border" role="status"><span class="sr-only">Loading...</span></div></div>');
	$.ajax({
        //async: false,
        type: "post",
        dataType: "json",
        url: $('#url').val()+'produccion/agrupacion_pedidos_list',
        success: function (data){
        $('#agrupacion_pedidos_list').empty();
        $.each(data, function(i, item) {
        	var tipoatencion = (item.tipo_atencion == 1)  ? 'MESA: ' : 'Nro: ';
			if (item.estado == 'a'){
				cssbtn = 'btn-success';
				accion_ped = 'preparacion_pedidos';
			} else if(item.estado == 'b'){
				cssbtn = 'btn-warning';
				accion_ped = 'atendido_pedidos';
			}

    		$('#agrupacion_pedidos_list')
    			.append(
	                $('<div class="col-lg-6"/>')
	                .html('<div class="card">'
	                	+'<div class="card-body p-0">'
	                	+'<div class="d-flex flex-wrap p-8 p-b-8 justify-center" style="background: #8196ac;"><div><h3 class="font-bold text-white">'+tipoatencion+''+item.nro_mesa+'</h3><h4 class="text-white">'+item.desc_salon+'</h4></div><div class="ml-auto align-self-center"><label class="font-bold font-15 m-b-0" style="color: #fff947 !important;"><span class="total'+i+'"></span> UNI</label>'
						+'<a onclick="'+accion_ped+'('+item.id_pedido+');" class="ml-3">'
						+'<button type="button" class="btn btn-lg '+cssbtn+'"><i class="ti-check"></i></button></a>'
						+'</div></div>'
						+'<div class="table-responsive">'
	                	+'<table class="table stylish-table b-t" id="table'+i+'">'
	                		+'<thead class="table-head">'
		                        +'<tr><th width="2%">Atención</th><th width="2%">Cantidad/Producto</th><th width="2%">Tiempo</th><th width="2%">Estado</th><th width="2%">Mozo/Cajero</th><th width="2%" class="text-right">Acci&oacute;n</th></tr>'
		                    +'</thead>'
		                    +'<tbody class="tb-st listdetalle'+i+'">')
	            );
	        	$.ajax({
					async: false,
			        type: "post",
			        dataType: "json",
			        url: $('#url').val()+'produccion/agrupacion_pedidos_detalle',
			        data: {
			        	id_pedido : item.id_pedido
			        },
			        success: function (dato){
			        var total_cantidad = 0;
			        $.each(dato, function(index, value) {
						var horaPedido = moment(value.fecha_pedido).fromNow();
						var tipo_atencion = (value.tipo_atencion == 1) ? '<h5 class="m-b-0">MESA: '+value.nro_mesa+'</h5><h6 class="text-muted">'+value.desc_salon+'</h6>' : '<h5 class="m-b-0">Nro: '+value.nro_mesa+'</h5><h6 class="text-muted">'+value.desc_salon+'</h6>';
			    		total_cantidad += parseFloat(value.cantidad);
			    		if (value.id_tipo == 2){
				    		probar = 'success';
				    		nombar = 'EN ESPERA';
				    		accion = 'atendido';
			    		} else if(value.id_tipo == 1){
			    			if(value.estado == 'a'){
				    			probar = 'success';
				    			nombar = 'EN ESPERA';
				    			accion = 'preparacion';
				    		} else if(value.estado == 'b'){
				    			probar = 'warning';
				    			nombar = 'EN PREPARACION';
				    			accion = 'atendido';
				    		}
			    		}

			    		var comentario = (value.comentario !== '') ? '<small class="text-uppercase font-14"><i class="fa fa-comment"></i> '+value.comentario+'</small>' : '';
						var toppings_formatted = (value.toppings_formatted !== '') ? '<small class="text-uppercase font-12 text-primary"><i class="fa fa-plus-circle"></i> Toppings: '+value.toppings_formatted+'</small><br>' : '';

			        	$('.listdetalle'+i)
				            .append(
				                $('<tr class="tr-left"/>')
				                .append(
				                    $('<td/>')
				                    .html(tipo_atencion)
				                )
				                .append(
				                    $('<td/>')
				                    .html('<h4 class="m-b-0"><label class="font-bold m-b-0 text-danger">'+value.cantidad+' UNI</label> '+value.nombre_prod+' <br><span class="label label-info">'+value.pres_prod+'</span>'
				                    	+'&nbsp;<span class="label label-warning">'+value.Producto.pro_cat+'</span></h4>'
				                    	+(toppings_formatted)
				                    	+comentario)
				                )
				                .append(
				                    $('<td/>')
				                    .html('<span class="font-12 font-bold">'+horaPedido+'</span>')
				                )
				                .append(
				                    $('<td/>')
				                    .html('<span class="label label-'+probar+' font-8 p-10">'+nombar+'</span>')
				                )
				                .append(
				                    $('<td/>')
				                    .html(value.nombres+' '+value.ape_paterno)
				                )
				                .append(
				                    $('<td class="text-right"/>')
				                    .html('<a onclick="'+accion+'('+value.id_pedido+','+value.id_pres+',\''+value.fecha_pedido+'\');">'
				                    	+'<button type="button" class="btn btn-circle btn-lg btn-success"><i class="ti-check"></i></button></a>')
				                )
				            );
			    		});
			        	$('.total'+i).text(total_cantidad);
			        }
			    });
    		});
        }
    });
}

var agruparPlatos = function(){
	$('.display-agrupacion-platos').css('display','block');
	$('.display-agrupacion-pedidos').css('display','none');
	$('.display-lista').css('display','none');
	$('.display-kanban').css('display','none');
	$('#tipo_atencion').val('4');
	//$('#condicion').val('1');
	agrupacion_platos_list();
}

var agruparPedidos = function(){
	// agruparPedidos();
	// setInterval(agruparPedidos, 10000);
	$('.display-agrupacion-platos').css('display','none');
	$('.display-agrupacion-pedidos').css('display','block');
	$('.display-lista').css('display','none');
	$('.display-kanban').css('display','none');
	$('#tipo_atencion').val('5');


	agrupacion_pedidos_list();
}

var agruparkanban = function(){
	// agruparPedidos();
	// setInterval(agruparPedidos, 10000);
	$('.display-agrupacion-platos').css('display','none');
	$('.display-agrupacion-pedidos').css('display','none');
	$('.display-lista').css('display','none');
	$('.display-kanban').css('display','flex');
	$('#tipo_atencion').val('7');
	listarKanban();
}

var listarPedidos = function(){
	$('#tipo_atencion').val($('#tipo_atencion_opcional').val());
	$('.display-agrupacion-platos').css('display','none');
	$('.display-agrupacion-pedidos').css('display','none');
	$('.display-kanban').css('display','none');
	$('.display-lista').css('display','block');
	if($('#tipo_atencion_opcional').val() == 1){
		nropedidosMesa();
		pedidosMesa();
	} else if($('#tipo_atencion_opcional').val() == 2){
		nropedidosMostrador();
		pedidosMostrador();
		//console.log('BOTON POR ORDEN DE LLEGADA, OPCION MOSTRADOR');
	} else if($('#tipo_atencion_opcional').val() == 3){
		nropedidosDelivery();
		pedidosDelivery();
	}
}

$('#tab1').on('click', function() {
	$('#tipo_atencion').val('1');
	$('#tipo_atencion_opcional').val('1');
	nropedidosMesa();
	pedidosMesa();
});

$('#tab2').on('click', function() {
	$('#tipo_atencion').val('2');
	$('#tipo_atencion_opcional').val('2');
	nropedidosMostrador();
	pedidosMostrador();
});

$('#tab3').on('click', function() {
	$('#tipo_atencion').val('3');
	$('#tipo_atencion_opcional').val('3');
	nropedidosDelivery();
	pedidosDelivery();
});

var preparacion = function(cod_ped,cod_prod,fecha_p){
	$.ajax({
		dataType: 'JSON',
		type: 'POST',
		url: $('#url').val()+'produccion/preparacion',
		data: {
	      	cod_ped: cod_ped,
	      	cod_prod: cod_prod,
	      	fecha_p: fecha_p
      	},
      	success: function (datos) {
      		if($('#tipo_atencion').val() == 1){
      			$('#cant_pedidos_mesa').text('');
	      		nropedidosMesa();
	      		pedidosMesa();
      		} else if($('#tipo_atencion').val() == 2){
      			nropedidosMostrador();
				pedidosMostrador();
      		} else if($('#tipo_atencion').val() == 3){
      			nropedidosDelivery();
	      		pedidosDelivery();
      		} else if($('#tipo_atencion').val() == 4) {
      			agrupacion_platos_list();
      		} else if($('#tipo_atencion').val() == 5) {
      			agrupacion_pedidos_list();
      		} else if($('#tipo_atencion').val() == 7) {
				listarKanban();
			}
      	},
      	error: function(jqXHR, textStatus, errorThrown){
        	console.log(errorThrown + ' ' + textStatus);
      	}
  	});
}

var atendido = function(cod_ped,cod_prod,fecha_p){
	$.ajax({
		dataType: 'JSON',
		type: 'POST',
		url: $('#url').val()+'produccion/atendido',
		data: {
      		cod_ped: cod_ped,
      		cod_prod: cod_prod,
      		fecha_p: fecha_p
      	},
      	success: function (datos) {
      		if($('#tipo_atencion').val() == 1){
      			nropedidosMesa();
	      		pedidosMesa();
	      		$('#cant_pedidos_mesa').text('');
				contMe = contMe - 1;
      		} else if($('#tipo_atencion').val() == 2){
      			nropedidosMostrador();
	      		pedidosMostrador();
	      		$('#cant_pedidos_most').text('');
				contMo = contMo - 1;
      		} else if($('#tipo_atencion').val() == 3){
      			nropedidosDelivery();
				pedidosDelivery();
				$('#cant_pedidos_del').text('');
				contDe = contDe - 1;
      		} else if($('#tipo_atencion').val() == 4) {
      			agrupacion_platos_list();
      			if($('#cant_pedidos_mesa').text() == 1){
      				$('#cant_pedidos_mesa').text('');
	    			contMe = 0;
	    		} else if($('#cant_pedidos_most').text() == 2) {
	    			$('#cant_pedidos_most').text('');
					contMo = 0;
	    		} else if($('#cant_pedidos_del').text() == 3) {
	    			$('#cant_pedidos_del').text('');
					contDe = 0;
	    		}
      		} else if($('#tipo_atencion').val() == 5) {
      			agrupacion_pedidos_list();
      			if($('#cant_pedidos_mesa').text() == 1){
      				$('#cant_pedidos_mesa').text('');
	    			contMe = 0;
	    		} else if($('#cant_pedidos_most').text() == 2) {
	    			$('#cant_pedidos_most').text('');
					contMo = 0;
	    		} else if($('#cant_pedidos_del').text() == 3) {
	    			$('#cant_pedidos_del').text('');
					contDe = 0;
	    		}
      		}else if($('#tipo_atencion').val() == 7) {
				listarKanban();
				if($('#cant_pedidos_mesa').text() == 1){
					$('#cant_pedidos_mesa').text('');
				  contMe = 0;
				} else if($('#cant_pedidos_most').text() == 2) {
					$('#cant_pedidos_most').text('');
					contMo = 0;
				} else if($('#cant_pedidos_del').text() == 3) {
					$('#cant_pedidos_del').text('');
					contDe = 0;
				}
			}
      		/*
      		else {
      			agrupacion_platos_list();
      			if($('#cant_pedidos_mesa').text() == 1){
      				$('#cant_pedidos_mesa').text('');
	    			contMe = 0;
	    		} else if($('#cant_pedidos_most').text() == 2) {
	    			$('#cant_pedidos_most').text('');
					contMo = 0;
	    		} else if($('#cant_pedidos_del').text() == 3) {
	    			$('#cant_pedidos_del').text('');
					contDe = 0;
	    		}
      		}
      		*/
      	},
      	error: function(jqXHR, textStatus, errorThrown){
        	console.log(errorThrown + ' ' + textStatus);
      	}
  	});
}


var preparacion_pedidos = function(cod_ped){
	$.ajax({
		dataType: 'JSON',
		type: 'POST',
		url: $('#url').val()+'produccion/preparacion_pedidos',
		data: {
	      	cod_ped: cod_ped,
			estado: 'a'
	 	},
      	success: function (datos) {
      		if($('#tipo_atencion').val() == 1){
      			$('#cant_pedidos_mesa').text('');
	      		nropedidosMesa();
	      		pedidosMesa();
      		} else if($('#tipo_atencion').val() == 2){
      			nropedidosMostrador();
				pedidosMostrador();
      		} else if($('#tipo_atencion').val() == 3){
      			nropedidosDelivery();
	      		pedidosDelivery();
      		} else if($('#tipo_atencion').val() == 4) {
      			agrupacion_platos_list();
      		} else if($('#tipo_atencion').val() == 5) {
      			agrupacion_pedidos_list();
      		} else if($('#tipo_atencion').val() == 7) {
				listarKanban();
			}
      	},
      	error: function(jqXHR, textStatus, errorThrown){
        	console.log(errorThrown + ' ' + textStatus);
      	}
  	});
}

var atendido_pedidos = function(cod_ped){
	$.ajax({
		dataType: 'JSON',
		type: 'POST',
		url: $('#url').val()+'produccion/atendido_pedidos',
		data: {
      		cod_ped: cod_ped,
      		estado: 'b'
      	},
      	success: function (datos) {
      		if($('#tipo_atencion').val() == 1){
      			nropedidosMesa();
	      		pedidosMesa();
	      		$('#cant_pedidos_mesa').text('');
				contMe = contMe - 1;
      		} else if($('#tipo_atencion').val() == 2){
      			nropedidosMostrador();
	      		pedidosMostrador();
	      		$('#cant_pedidos_most').text('');
				contMo = contMo - 1;
      		} else if($('#tipo_atencion').val() == 3){
      			nropedidosDelivery();
				pedidosDelivery();
				$('#cant_pedidos_del').text('');
				contDe = contDe - 1;
      		} else if($('#tipo_atencion').val() == 4) {
      			agrupacion_platos_list();
      			if($('#cant_pedidos_mesa').text() == 1){
      				$('#cant_pedidos_mesa').text('');
	    			contMe = 0;
	    		} else if($('#cant_pedidos_most').text() == 2) {
	    			$('#cant_pedidos_most').text('');
					contMo = 0;
	    		} else if($('#cant_pedidos_del').text() == 3) {
	    			$('#cant_pedidos_del').text('');
					contDe = 0;
	    		}
      		} else if($('#tipo_atencion').val() == 5) {
      			agrupacion_pedidos_list();
      			if($('#cant_pedidos_mesa').text() == 1){
      				$('#cant_pedidos_mesa').text('');
	    			contMe = 0;
	    		} else if($('#cant_pedidos_most').text() == 2) {
	    			$('#cant_pedidos_most').text('');
					contMo = 0;
	    		} else if($('#cant_pedidos_del').text() == 3) {
	    			$('#cant_pedidos_del').text('');
					contDe = 0;
	    		}
      		} else if($('#tipo_atencion').val() == 7) {
				listarKanban();
				if($('#cant_pedidos_mesa').text() == 1){
					$('#cant_pedidos_mesa').text('');
				  contMe = 0;
				} else if($('#cant_pedidos_most').text() == 2) {
					$('#cant_pedidos_most').text('');
					contMo = 0;
				} else if($('#cant_pedidos_del').text() == 3) {
					$('#cant_pedidos_del').text('');
					contDe = 0;
				}
			}
      	},
      	error: function(jqXHR, textStatus, errorThrown){
        	console.log(errorThrown + ' ' + textStatus);
      	}
  	});
}

var platos_preparacion_pedidos = function(a){
	$.ajax({
		dataType: 'JSON',
		type: 'POST',
		url: $('#url').val()+'produccion/platos_preparacion_pedidos',
		data: {
	      	a: a,
			b: 'a'
	 	},
      	success: function (datos) {
      		if($('#tipo_atencion').val() == 1){
      			$('#cant_pedidos_mesa').text('');
	      		nropedidosMesa();
	      		pedidosMesa();
      		} else if($('#tipo_atencion').val() == 2){
      			nropedidosMostrador();
				pedidosMostrador();
      		} else if($('#tipo_atencion').val() == 3){
      			nropedidosDelivery();
	      		pedidosDelivery();
      		} else if($('#tipo_atencion').val() == 4) {
      			agrupacion_platos_list();
      		} else if($('#tipo_atencion').val() == 5) {
      			agrupacion_pedidos_list();
      		} else if($('#tipo_atencion').val() == 7) {
				listarKanban();
			}
      	},
      	error: function(jqXHR, textStatus, errorThrown){
        	console.log(errorThrown + ' ' + textStatus);
      	}
  	});
}

var platos_atendido_pedidos = function(a){
	$.ajax({
		dataType: 'JSON',
		type: 'POST',
		url: $('#url').val()+'produccion/platos_atendido_pedidos',
		data: {
			a: a,
			b: 'b'
      	},
      	success: function (datos) {
      		if($('#tipo_atencion').val() == 1){
      			nropedidosMesa();
	      		pedidosMesa();
	      		$('#cant_pedidos_mesa').text('');
				contMe = contMe - 1;
      		} else if($('#tipo_atencion').val() == 2){
      			nropedidosMostrador();
	      		pedidosMostrador();
	      		$('#cant_pedidos_most').text('');
				contMo = contMo - 1;
      		} else if($('#tipo_atencion').val() == 3){
      			nropedidosDelivery();
				pedidosDelivery();
				$('#cant_pedidos_del').text('');
				contDe = contDe - 1;
      		} else if($('#tipo_atencion').val() == 4) {
      			agrupacion_platos_list();
      			if($('#cant_pedidos_mesa').text() == 1){
      				$('#cant_pedidos_mesa').text('');
	    			contMe = 0;
	    		} else if($('#cant_pedidos_most').text() == 2) {
	    			$('#cant_pedidos_most').text('');
					contMo = 0;
	    		} else if($('#cant_pedidos_del').text() == 3) {
	    			$('#cant_pedidos_del').text('');
					contDe = 0;
	    		}
      		} else if($('#tipo_atencion').val() == 5) {
      			agrupacion_pedidos_list();
      			if($('#cant_pedidos_mesa').text() == 1){
      				$('#cant_pedidos_mesa').text('');
	    			contMe = 0;
	    		} else if($('#cant_pedidos_most').text() == 2) {
	    			$('#cant_pedidos_most').text('');
					contMo = 0;
	    		} else if($('#cant_pedidos_del').text() == 3) {
	    			$('#cant_pedidos_del').text('');
					contDe = 0;
	    		}
      		} else if($('#tipo_atencion').val() == 7) {
				listarKanban();
				if($('#cant_pedidos_mesa').text() == 1){
					$('#cant_pedidos_mesa').text('');
				  contMe = 0;
				} else if($('#cant_pedidos_most').text() == 2) {
					$('#cant_pedidos_most').text('');
					contMo = 0;
				} else if($('#cant_pedidos_del').text() == 3) {
					$('#cant_pedidos_del').text('');
					contDe = 0;
				}
			}
      	},
      	error: function(jqXHR, textStatus, errorThrown){
        	console.log(errorThrown + ' ' + textStatus);
      	}
  	});
}