$(function() {
    moment.locale('es');
    listar();
    $('#inventario').addClass("active");
    $('#i-stock').addClass("active");

    /* BOTON DATATABLES */
    var org_buildButton = $.fn.DataTable.Buttons.prototype._buildButton;
    $.fn.DataTable.Buttons.prototype._buildButton = function(config, collectionButton) {
    var button = org_buildButton.apply(this, arguments);
    $(document).one('init.dt', function(e, settings, json) {
        if (config.container && $(config.container).length) {
           $(button.inserter[0]).detach().appendTo(config.container)
        }
    })    
    return button;
    }
});

$('#filtro_tipo_ins, #filtro_tipo_cat').change( function() {
    listar();
});

var decimalInsumoStock = 3;
if($("#decimal_stock").val() == 1){
    decimalInsumoStock = 6;
}

// Obtener el valor del input para mostar solo el nombre de la presentacion
var valor_solo_pres = $('#activar_solo_pres').val();
console.log(valor_solo_pres);

var listar = function(){
    function filterGlobal () {
        $('#table').DataTable().search( 
            $('#global_filter').val()
        ).draw();
    }

    var stock_min = 0,
        stock_real = 0,
        table =	$('#table')
	    .DataTable({
            buttons: [
                {
                    extend: 'excel', title: 'Inventario de insumos y productos', className: 'dropdown-item p-t-0 p-b-0', text: '<i class="fas fa-file-excel"></i> Descargar en excel', titleAttr: 'Descargar Excel',
                    container: '#excel', exportOptions: { columns: ':visible' }
                },
                {
                    extend: 'pdf', title: 'Inventario de insumos y productos', className: 'dropdown-item p-t-0 p-b-0', text: '<i class="fas fa-file-pdf"></i> Descargar en pdf', titleAttr: 'Descargar Pdf',
                    container: '#pdf', exportOptions: { columns: ':visible' }, orientation: 'landscape'
                }
            ],
            "destroy": true,
            "responsive": true,
            "dom": "tip",
            "bSort": true,
    		"ajax":{
        		"method": "POST",
        		"url": $('#url').val()+"inventario/stock_list",
                "data": {
                    tipo_ins: $('#filtro_tipo_ins').val(),
                    stock_min: $("input[name='filtro_stock_minimo']").val(),
                    tipo_cat: $('#filtro_tipo_cat').val()
                }
    		},
            "columns":[
                {"data": null, "render": function ( data, type, row) {
                        if(data.id_tipo_ins == 1){
                            return '<span class="label label-warning">INSUMO</span>';
                        } else if(data.id_tipo_ins == 2){
                            return '<span class="label label-success">PRODUCTO</span>';
                        }
                }},

                {"data": "Producto.ins_cod"},
                {"data": "Producto.ins_cat"},
                
                {"data": null, "render": function ( data, type, row) {
                    if(valor_solo_pres == 1){
                        if(data.id_tipo_ins == 1){
                            return '<div class="text-left">'+data.Producto.ins_nom+'</div>';
                        } else if(data.id_tipo_ins == 2){
                            return '<div class="text-left">'+data.Producto.pro_pre+'</div>';
                        }                        
                    }else{
                        if(data.id_tipo_ins == 1){
                            return '<div class="text-left">'+data.Producto.ins_nom+'</div>';
                        } else if(data.id_tipo_ins == 2){
                            return '<div class="text-left">'+data.Producto.pro_nom+' | '+data.Producto.pro_pre+'</div>';
                        }
                    }
                }},                

                {"data": "Producto.ins_med"},
                
                {"data": null,"render": function ( data, type, row ) {
                    stock_min = data.Producto.ins_sto - 0;
                    return '<div class="text-warning text-right">'+stock_min.toFixed(decimalInsumoStock)+'</div>';
                }},
                {"data": null,"render": function ( data, type, row ) {
                    stock_real = data.ent-data.sal;
                    return '<div style="font-weight: 600;" class="text-success text-right">'+stock_real.toFixed(decimalInsumoStock)+'</div>';
                }},
                //Precio de venta
                {"data": null, "render": function (data, type, row){
                    const pro_precio_venta = data.Producto.pro_cos ? data.Producto.pro_cos : "0.00";
                    return '<div class="text-right">'+parseFloat(pro_precio_venta).toFixed(2)+'</div>';
                }},
                //Costo Unitario
                {"data": null, "render": function (data, type, row){
                    const pro_cos_unitario = data.Producto.ins_cos ? data.Producto.ins_cos : "0.00";
                    return '<div class="text-right">'+parseFloat(pro_cos_unitario).toFixed(2)+'</div>';
                }},
                //Ganancia unitario
                {"data": null, "render": function (data, type, row){
                    const pro_precio_venta = data.Producto.pro_cos ? data.Producto.pro_cos : "0.00";
                    const pro_cos_unitario = data.Producto.ins_cos ? data.Producto.ins_cos : "0.00";
                    var ganancia_unitario = pro_precio_venta - pro_cos_unitario;
                    ganancia_unitario = data.id_tipo_ins == 1 ? "0.00" : ganancia_unitario;
                    var styGanUnitario = ganancia_unitario > 0 ? "text-success" : (ganancia_unitario < 0 ? "text-danger" : "text-warning");
                    
                    return '<div class="'+styGanUnitario+' text-right">'+parseFloat(ganancia_unitario).toFixed(2)+'</div>';
                }},
                //Ventas valor total
                {"data": null, "render": function (data, type, row){
                    const stock_real = data.ent - data.sal;
                    const pro_precio_venta = data.Producto.pro_cos ? data.Producto.pro_cos : "0.00";
                    const pre_total = stock_real * pro_precio_venta;

                    return '<div class="text-right">'+pre_total.toFixed(2)+'</div>';
                }},
                //Costo valor total
                {"data": null, "render": function (data, type, row){
                    const stock_real = data.ent - data.sal;
                    const pro_cos_unitario = data.Producto.ins_cos;
                    const pre_costo_total = stock_real * pro_cos_unitario;
                    
                    return '<div class="text-right">'+pre_costo_total.toFixed(2)+'</div>';
                }},
                //Ganancia total
                {"data": null, "render": function (data, type, row){
                    const stock_real = data.ent - data.sal;
                    const pro_cos_unitario = data.Producto.ins_cos;
                    const pro_precio_venta = data.Producto.pro_cos;
                    const pre_total = stock_real * pro_precio_venta;
                    const pre_costo_total = stock_real * pro_cos_unitario;
                    var ganancia_total = pre_total - pre_costo_total;
                    ganancia_total = data.id_tipo_ins == 1 ? "0.00" : ganancia_total;
                    var styGanTotal = ganancia_total > 0 ? "text-success" : (ganancia_total < 0 ? "text-danger" : "text-warning");

                    return '<div class="'+styGanTotal+' text-right">'+parseFloat(ganancia_total).toFixed(2)+'</div>';
                }},                 
                
                {"data": null,"render": function ( data, type, row ) {
                    // stock_real = data.ent-data.sal;

                    var stock_min = data.Producto.ins_sto - 0; //stock minimo

                    var stock_real = data.ent-data.sal; // stock real 


                    if (stock_real <= stock_min && stock_real > 0) {
                        var ss = '<span class="label label-warning">Pocas unidades</span>';
                    }
                    else if(stock_real <= 0) {
                        var ss = '<span class="label label-danger">Agotado</span>';
                    }else{
                        var ss = '<span class="label label-success">Disponible</span>';
                    }
                    return '<div class="text-right">'+ss+'</div>';

                  }}          
            ],
            
            "columnDefs": [
                // {
                //     "targets": [ 2 ],
                //     "visible": false
                // },
            ],
            "footerCallback": function ( row, data, start, end, display ) {
                var api = this.api(), data;

                var intVal = function ( i ) {
                    return typeof i === 'string' ?
                        i.replace(/[\$,]/g, '')*1 :
                        typeof i === 'number' ?
                            i : 0;
                };

                total_venta = api
                .column( 10/*, { search: 'applied', page: 'current'} */)
                .data()
                .reduce( function (a, b) {      
                    const stock_real = b.ent - b.sal;
                    const pro_precio_venta = b.Producto.pro_cos;
                    const pre_total = stock_real * pro_precio_venta;

                    return (intVal(a) + intVal(pre_total)).toFixed(2);
                }, 0 );

                total_compra = api
                .column( 11/*, { search: 'applied', page: 'current'} */)
                .data()
                .reduce( function (a, b) {      
                    const stock_real = b.ent - b.sal;
                    const pro_cos_unitario = b.Producto.ins_cos;
                    const pre_costo_total = stock_real * pro_cos_unitario;

                    return (intVal(a) + intVal(pre_costo_total)).toFixed(2);
                }, 0 );
                
                ganancia_compra = api
                .column( 12/*, { search: 'applied', page: 'current'} */)
                .data()
                .reduce( function (a, b) {
                    const stock_real = b.ent - b.sal;
                    const pro_cos_unitario = b.id_tipo_ins == 2 ? b.Producto.ins_cos : "0.00";
                    const pro_precio_venta = b.Producto.pro_cos;
                    const pre_total = stock_real * pro_precio_venta;
                    const pre_costo_total = stock_real * pro_cos_unitario;
                    const ganancia_total = pre_total - pre_costo_total;
                    // console.log(ganancia_total);

                    return (intVal(a) + intVal(ganancia_total)).toFixed(2);
                }, 0 );



                operaciones = api
                .rows()
                .data()
                .count();


                // $('.number_product').text(operaciones);
                $('.ventas-total').text(total_venta);
                $('.compras-total').text(total_compra);
                $('.ganancia-total').text(ganancia_compra);
            }            
            
	});

    $('input.global_filter').on( 'keyup click', function () {
        filterGlobal();
    });
};

$('#filtro_stock_minimo').on('click', function(event){
    if( $(this).is(':checked') ) {
        $('#filtro_stock_minimo').val('0');
        listar();
    } else {
        $('#filtro_stock_minimo').val('%');
        listar();
    }
});

$('#downticket').on('click', function(event){
    window.open($('#url').val()+"inventario/impresion_stock?tipo_ins="+$('#filtro_tipo_ins').val()+"&stock_min="+$("input[name='filtro_stock_minimo']").val()+"&tipo_cat="+$('#filtro_tipo_cat').val(),'_blank');
});
