<?php
require_once ('public/lib/pdf/cellfit.php');

class FPDF_CellFiti extends FPDF_CellFit
{
	function AutoPrint($dialog=false)
	{
		//Open the print dialog or start printing immediately on the standard printer
		$param=($dialog ? 'true' : 'false');
		$script="print($param);";
		$this->IncludeJS($script);
	}

	function AutoPrintToPrinter($server, $printer, $dialog=false)
	{
		//Print on a shared printer (requires at least Acrobat 6)
		$script = "var pp = getPrintParams();";
		if($dialog)
			$script .= "pp.interactive = pp.constants.interactionLevel.full;";
		else
			$script .= "pp.interactive = pp.constants.interactionLevel.automatic;";
		$script .= "pp.printerName = '\\\\\\\\".$server."\\\\".$printer."';";
		$script .= "print(pp);";
		$this->IncludeJS($script);
	}
}

define('EURO',chr(128));
$pdf = new FPDF_CellFiti('P','mm',array(80,800));
$pdf->AddPage();
$pdf->SetMargins(0,0,0,0);

// CABECERA
$pdf->SetFont('Helvetica','',6);
$pdf->Cell(72,4,'',0,1,'C');
$pdf->SetFont('Helvetica','B',13);
$pdf->Cell(72,4,'TICKET',0,1,'C');
$pdf->ln(2);
$pdf->Cell(72,4,'ANULACION DE PEDIDOS',0,1,'C');
$pdf->Ln(3);

$pdf->Cell(72,0,'','T');
   
foreach($this->dato as $d){
    $pdf->Ln(1);
    $pdf->SetFont('Helvetica', 'B', 9);
    $pdf->Cell(72,4,'PRODUCTO',0,1,'L');
    // $pdf->Ln(2);
    $pdf->SetFont('Helvetica', '', 9);
    $pdf->MultiCell(72,3,'- '.utf8_decode($d->Producto->pro_nom).' '.utf8_decode($d->Producto->pro_pre),0,'L'); 
    $pdf->Ln(1);
    $pdf->SetFont('Helvetica', '', 7);
    $pdf->Cell(72, 3,'   Fecha: '.date('d-m-Y',strtotime($d->fecha_pedido)).'    Hora: '.date('h:i A',strtotime($d->fecha_pedido)),0,1,'L');
    $pdf->Cell(72, 3,'   Cantidad: '.$d->cant.' unds.',0,1,'L');
    $pdf->Cell(72, 3,'   Responsable: '.$d->Personal->nombres,0,1,'L');
    $pdf->MultiCell(72,3,'   Motivo: '.(($d->TipoPedido->estado == 'z') ? $d->TipoPedido->motivo : $d->comentario),0,'L'); 

}
$pdf->Ln(6); 
$pdf->Cell(72,0,'','T');
$pdf->Ln(6); 
$pdf->Cell(72,4,'DATOS DE IMPRESION',0,1,'');
$pdf->Cell(72,4,'USUARIO: '.Session::get('nombres').' '.Session::get('apellidos'),0,1,'');
date_default_timezone_set($_SESSION["zona_horaria"]);
setlocale(LC_ALL,"es_ES@euro","es_ES","esp");
$pdf->Cell(72,4,'FECHA: '.date("d-m-Y h:i A"),0,1,'');
$pdf->Ln(8);
$pdf->Cell(72,4,'___________________________________',0,1,'C');
$pdf->Cell(72,4,utf8_decode(Session::get('nombres').' '.Session::get('apellidos')),0,1,'C');

$pdf->Output('ticket.pdf','I');
?>