$(function() {
    $('#informes').addClass("active");
	listar();
    
    $('#start').bootstrapMaterialDatePicker({
        time: ($("#fecha_report").val() == '0')? false : true,
        format: ($("#fecha_report").val() == '0')? 'DD-MM-YYYY' : 'DD-MM-YYYY LT',
        shortTime: ($("#fecha_report").val() == '0')? false : true,
        lang: 'es-do',
        cancelText: 'Cancelar',
        okText: 'Aceptar'
    });

    $('#end').bootstrapMaterialDatePicker({
        time: ($("#fecha_report").val() == '0')? false : true,
        format: ($("#fecha_report").val() == '0')? 'DD-MM-YYYY' : 'DD-MM-YYYY LT',
        shortTime: ($("#fecha_report").val() == '0')? false : true,
        lang: 'es-do',
        cancelText: 'Cancelar',
        okText: 'Aceptar'
    });

    $('#start,#end').change( function() {
        listar();

    });

    /* BOTON DATATABLES */
    var org_buildButton = $.fn.DataTable.Buttons.prototype._buildButton;
    $.fn.DataTable.Buttons.prototype._buildButton = function(config, collectionButton) {
    var button = org_buildButton.apply(this, arguments);
    $(document).one('init.dt', function(e, settings, json) {
        if (config.container && $(config.container).length) {
           $(button.inserter[0]).detach().appendTo(config.container)
        }
    })    
    return button;
    }
});

var listar = function(){

    $("#chart-ventas-productos").empty();
    var moneda = $("#moneda").val();
	ifecha = $("#start").val();
    ffecha = $("#end").val();
    $.ajax({
        url: $('#url').val()+"informe/oper_cont_comensal_graphic",
        method: "POST",
        data: {
            ifecha: ifecha,
            ffecha: ffecha,
        },
        dataType: "json", //parse the response data as JSON automatically
        success: function(data) {
            if(data['data'].length > 0){
                Morris.Area({
                    element: 'chart-ventas-productos',
                    data: data['data'],
                    xkey: 'y',
                    ykeys: ['a'],
                    labels: ['cantidad'],
                    fillOpacity: 0.4,
                    hideHover: 'auto',
                    behaveLikeLine: true,
                    resize: true,
                    xLabelFormat: function (y) {
                       return ("0" + y.getDate()).slice(-2) + '-' + ("0" + (y.getMonth() + 1)).slice(-2) + '-' + y.getFullYear();
                    },
                    xLabels: 'day',
                    xLabelAngle: 45,
                    pointFillColors: ['#ffffff'],
                    pointStrokeColors: ['black'],
                    lineColors: ['#009efb']
                });
            }
        }
    });

	var	table =	$('#table')
	.DataTable({
        buttons: [
            {
                extend: 'excel', sheetName: 'Mes: ' +  $('#start').val() + ' al ' + $('#end').val(), title: 'rep_comensales', text:'Excel', className: 'btn btn-circle btn-lg btn-success waves-effect waves-dark', text: '<i class="mdi mdi-file-excel display-6" style="line-height: 10px;"></i>', titleAttr: 'Descargar Excel',
                container: '#btn-excel'
            }
        ],
		"destroy": true,
		"dom": "tip",
		"bSort": true,
		"ajax":{
			"method": "POST",
			"url": $('#url').val()+"informe/oper_cont_comensal_list",
			"data": {
                ifecha: ifecha,
                ffecha: ffecha,
            }
		},
		"columns":[
            {"data":"fecha_inicio","render": function ( data, type, row ) {
                return '<i class="ti-calendar"></i> '+moment(data).format('DD-MM-Y')
                +'<br><span class="font-12"><i class="ti-time"></i> '+moment(data).format('h:mm A')+'</span>';
            }},
            {
                "data": "comensales",
                "render": function ( data, type, row) {
                    return '<div class="text-left">'+(data).toUpperCase()+'</div>';
                }
            },

            {
                "data": "time_promedio",
                "render": function ( data, type, row) {
                    return '<div class="text-right">'+time_conv(data)+'</div>';
                }
            },
		],
        "footerCallback": function ( row, data, start, end, display ) {
            var api = this.api(), data;
            var intVal = function ( i ) {
                return typeof i === 'string' ?
                    i.replace(/[\$,]/g, '')*1 :
                    typeof i === 'number' ?
                        i : 0;
            };

            cantidad = api
                .column( 1 /*, { search: 'applied', page: 'current'} */)
                .data()
                .reduce( function (a, b) {
                    return intVal(a) + intVal(b);
                }, 0 );
 
            total = api
                .column( 2 /*, { search: 'applied', page: 'current'} */)
                .data()
                .reduce( function (a, b) {
                    return intVal(a) + intVal(b);
                }, 0 );

            operaciones = api
                .rows()
                .data()
                .count();
            var total_data = intVal(data.length);
            $('.productos-total').text(time_conv((total/total_data).toFixed()));
            $('.productos-operaciones').text(cantidad);
        }
	});
}

var time_conv = function(seconds) {
    var hour = Math.floor(seconds / 3600);
    hour = (hour < 10)? '0' + hour : hour;
    var minute = Math.floor((seconds / 60) % 60);
    minute = (minute < 10)? '0' + minute : minute;
    var second = seconds % 60;
    second = (second < 10)? '0' + second : second;
    return hour + ':' + minute + ':' + second;
}