$(function() {
    $('#informes').addClass("active");
	listar();
    
    $('#filtro_mes').change( function() {
        listar();

    });

    /* BOTON DATATABLES */
    var org_buildButton = $.fn.DataTable.Buttons.prototype._buildButton;
    $.fn.DataTable.Buttons.prototype._buildButton = function(config, collectionButton) {
    var button = org_buildButton.apply(this, arguments);
    $(document).one('init.dt', function(e, settings, json) {
        if (config.container && $(config.container).length) {
           $(button.inserter[0]).detach().appendTo(config.container)
        }
    })    
    return button;
    }
});

var listar = function(){
    function filterGlobal () {
        $('#table').DataTable().search( 
            $('#global_filter').val()
        ).draw();
    }

    mes = $("#filtro_mes").selectpicker('val');

	var	table =	$('#table')
	.DataTable({
        buttons: [
            {
                extend: 'excel', sheetName: 'Mes: ' +  $('#filtro_mes').val(), title: 'Reporte de clientes cumpleaños', className: 'dropdown-item p-t-0 p-b-0', text: '<i class="fas fa-file-excel"></i> Descargar en excel', titleAttr: 'Descargar Excel',
                container: '#excel', exportOptions: { columns: [0,1,2,3,4] }
            },
            {
                extend: 'pdf', title: 'Reporte de clientes cumpleaños', className: 'dropdown-item p-t-0 p-b-0', text: '<i class="fas fa-file-pdf"></i> Descargar en pdf', titleAttr: 'Descargar Pdf',
                container: '#pdf', exportOptions: { columns: [0,1,2,3,4] }, orientation: 'landscape', 
                customize : function(doc){ 
                    doc.styles.tableHeader.alignment = 'left'; 
                    doc.content[1].table.widths = [60,'*','*','*','*'];
                }
            }
        ],        
        // buttons: [
        //     {
        //         extend: 'excel', title: 'rep_compras', text:'Excel', className: 'btn btn-circle btn-lg btn-success waves-effect waves-dark', text: '<i class="mdi mdi-file-excel display-6" style="line-height: 10px;"></i>', titleAttr: 'Descargar Excel',
        //         container: '#btn-excel'
        //     }
        // ],
		"destroy": true,
		"dom": "tip",
		"bSort": true,
		"ajax":{
			"method": "POST",
			"url": $('#url').val()+"informe/clientes_birthday_list",
			"data": {
                mes: mes
            }
		},
		"columns":[
            {"data":"dni"},
            {"data":"nombre"},
            // {"data":"fecha_nac"},
            {"data":"fecha_nac","render": function ( data, type, row ) {
                        return moment(data).format('DD-MM-Y'); }},            
            {"data":"telefono"},
            {"data":"direccion"},
		], 
        // .format('dd-m-yy')
        "footerCallback": function ( row, data, start, end, display ) {
            var api = this.api(), data;
            var intVal = function ( i ) {
                return typeof i === 'string' ?
                    i.replace(/[\$,]/g, '')*1 :
                    typeof i === 'number' ?
                        i : 0;
            };

            operaciones = api
                .rows()
                .data()
                .count();
            $('.productos-operaciones').text(operaciones);
        }
	});
    $('input.global_filter').on( 'keyup click', function () {
        filterGlobal();
    });
}

var time_conv = function(seconds) {
    var hour = Math.floor(seconds / 3600);
    hour = (hour < 10)? '0' + hour : hour;
    var minute = Math.floor((seconds / 60) % 60);
    minute = (minute < 10)? '0' + minute : minute;
    var second = seconds % 60;
    second = (second < 10)? '0' + second : second;
    return hour + ':' + minute + ':' + second;
}