var moneda = $("#moneda").val();
$(function() {
    listar(1);
    $('#clientes').addClass("active");
    $('#form').formValidation({
        framework: 'bootstrap',
        excluded: ':disabled',
        fields: {
            dni: {
                validators: {
                    stringLength: {
                        message: 'El '+$(".c-dni").text()+' debe tener '+$("#dni").attr("maxlength")+' digitos'
                    }
                }
            },
            ruc: {
                validators: {
                    stringLength: {
                        message: 'El '+$(".c-ruc").text()+' debe tener '+$("#ruc").attr("maxlength")+' digitos'
                    }
                }
            }
        }
    })
    .on('success.form.fv', function(e) {
        // Prevent form submission
        e.preventDefault();
        var $form = $(e.target),
        fv = $form.data('formValidation');

        var rucRaw = $("input[name='ruc']").val();
        var ruc = rucRaw;
        if (rucRaw && rucRaw.indexOf(' DV:') !== -1) {
            ruc = rucRaw.replace(/\s*DV:\s*\S+$/, '').trim();
        }
        var dv = $('#dv_cliente').val() || '';
        var ubicacion = $('#ubicacion').length ? $('#ubicacion').val() : '';
        var tipo_ruc = $('#tipo_ruc_cliente').length ? $('#tipo_ruc_cliente').val() : '';
        
        var parametros = {
            "id_cliente" : $("input[name='id_cliente']").val(),
            "tipo_cliente" : $("input[name='tipo_cliente']").val(),
            "dni" : $("input[name='dni']").val(),
            "ruc" : ruc,
            "dv" : dv,
            "nombres" : $("input[name='nombres']").val(),
            "fecha_nac" : $("input[name='fecha_nac']").val(),
            "telefono" : $("input[name='telefono']").val(),
            "correo" : $("input[name='correo']").val(),
            "razon_social" : $("input[name='razon_social']").val(),
            "direccion" : $("input[name='direccion']").val(),
            "referencia" : $("input[name='referencia']").val(),
            "ubicacion" : ubicacion,
            "tipo_ruc" : tipo_ruc
        };

        if($("input[name='id_cliente']").val() != ''){
            var text = 'actualizará';
        } else{
            var text = 'registrará';
        }

        var html_confirm = '<div>Se '+text+' los datos del cliente:<br> '+$("input[name='razon_social']").val()+''+$("input[name='nombres']").val()+'</div><br>\
        <div><span class="text-success" style="font-size: 17px;">¿Está Usted de Acuerdo?</span></div>';

        Swal.fire({
            title: 'Necesitamos de tu Confirmación',
            html: html_confirm,
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#34d16e',
            confirmButtonText: 'Si, Adelante!',
            cancelButtonText: "No!",
            showLoaderOnConfirm: true,
            preConfirm: function() {
              return new Promise(function(resolve) {
                 $.ajax({
                    url: $('#url').val()+'cliente/cliente_crud',
                    type: 'POST',
                    data: parametros,
                    dataType: 'json'
                 })
                 .done(function(response){
                    $('#modal').modal('hide');
                    if(response==1){
                        var title = 'Proceso Terminado';
                        var text = 'Datos registrados correctamente';
                        var type = 'success';
                        listar($('#filtro_tipo_cliente').val());
                    }else if(response==2){
                        var title = 'Proceso Terminado';
                        var text = 'Datos actualizados correctamente';
                        var type = 'success';
                        listar($('#filtro_tipo_cliente').val());
                    }else if(response==0){
                        var title = 'Proceso No Culminado';
                        var text = 'Datos duplicados';
                        var type = 'error';                        
                    }
                    Swal.fire({
                        title: title,
                        text: text,
                        icon: type,
                        confirmButtonColor: "#34d16e",   
                        confirmButtonText: "Aceptar"
                    });               
                    listar($('#filtro_tipo_cliente').val());
                    $('.display-one').css('display','block');
                    $('.display-two').css('display','none');
                 })
                 .fail(function(){
                    Swal.fire('Oops...', 'Problemas con la conexión a internet!', 'error');
                 });
              });
            },
            allowOutsideClick: false              
        });  
    });
});

$('.list-personas').click( function() {
    $('#filtro_tipo_cliente').val('1');
    $('.display-one').css('display','block');
    $('.display-two').css('display','none');
    listar(1);
});

$('.list-empresas').click( function() {
    $('#filtro_tipo_cliente').val('2');
    $('.display-one').css('display','block');
    $('.display-two').css('display','none');
    listar(2);
});

var listar = function(tipo_cliente){

    //tipo_cliente = $('#filtro_tipo_cliente').selectpicker('val');
    function filterGlobal () {
        $('#table').DataTable().search( 
            $('#global_filter').val()
        ).draw();
    }

    var table = $('#table')
    .DataTable({
        "destroy": true,
        "dom": "tip",
        "bSort": true,
        "ajax":{
            "method": "POST",
            "url": $('#url').val()+"cliente/cliente_list",
            "data": {
                tipo_cliente: tipo_cliente
            }
        },        
        "columns":[
            {
                "data":null,
                "render": function ( data, type, row ) {
                var tipo = (data.tipo_cliente == 1) ? $('#diAcr').val() : $('#tribAcr').val();
                return '<h6 style="white-space: normal;"><a href="javascript::void(0)" class="link" onclick="venta_list('+data.id_cliente+',\''+data.nombre+'\');">'+data.nombre+'</a></h6><small class="text-muted font-13"><span class="text-muted">'+tipo+':</span> '+data.dni+''+data.ruc+'</small>';
            }},
            {"data":null,"render": function ( data, type, row ) {
                if(data.estado == 'a'){
                    return '<div class="text-center"><a href="javascript::void(0)" onclick="estado('+data.id_cliente+',\''+data.estado+'\',\''+data.nombre+'\''+');"><span class="label label-success">ACTIVO</span></a></div>';
                }else if(data.estado == 'i'){
                    return '<div class="text-center"><a href="javascript::void(0)" onclick="estado('+data.id_cliente+',\''+data.estado+'\',\''+data.nombre+'\''+');"><span class="label label-inverse">INACTIVO</span></a></div>';
                }
            }},
            {"data":null,"render": function ( data, type, row ) {
                return '<div class="text-right"><a href="javascript:void(0)" class="btn btn-info btn-sm" onclick="editar('+data.id_cliente+');"><i class="fas fa-eye"></i></a>'
                    +'&nbsp;<a href="javascript:void(0)" class="btn btn-danger btn-sm delete ms-2" onclick="anular('+data.id_cliente+',\''+data.nombre+'\''+');"><i class="fas fa-trash"></i></a></div>';
            }}
        ],
        "footerCallback": function ( row, data, start, end, display ) {
            var api = this.api(), data;

            total = api
                .rows()
                .data()
                .count();

            $('.clientes-total').text(total);
        }
    });
    
    $('input.global_filter').on( 'keyup click', function () {
        filterGlobal();
    });

    $('#table').DataTable().on("draw", function(){
        feather.replace();
    });
};

var venta_list = function(id_cliente,nombre_cliente){
    $('.display-one').css('display','none');
    $('.display-two').css('display','block');
    $('.cliente-nombre').text(nombre_cliente);
    var count = 1;
    var table = $('#table-ventas')
    .DataTable({
        "destroy": true,
        "dom": "tp",
        "bSort": true,
        "order": [[0,"desc"]],
        "ajax":{
            "method": "POST",
            "url": $('#url').val()+"cliente/cliente_ventas",
            "data": {
                id_cliente: id_cliente
            }
        },
        "columns":[
            {"data":"fec_ven","render": function ( data, type, row ) {
                return '<i class="ti-calendar"></i> '+moment(data).format('DD-MM-Y')
                +'<br><span class="font-12"><i class="ti-time"></i> '+moment(data).format('h:mm A')+'</span>';
            }},
            {"data":null,"render": function ( data, type, row ) {
                return data.desc_td
                +'<br><span class="font-12">'+data.ser_doc+'-'+data.nro_doc+'</span>';
            }},
            {"data":"desc_monto","render": function ( data, type, row ) {
                return '<div class="text-right">'+formatNumber(data)+'</div>';
            }},
            {"data":"monto_total","render": function ( data, type, row ) {
                return '<div class="text-right">'+formatNumber(data)+'</div>';
            }}
        ],
        "footerCallback": function ( row, data, start, end, display ) {
            var api = this.api(), data;

            var intVal = function ( i ) {
                return typeof i === 'string' ?
                    i.replace(/[\$,]/g, '')*1 :
                    typeof i === 'number' ?
                        i : 0;
            };
 
            descuento = api
                .column( 2 /*, { search: 'applied', page: 'current'} */)
                .data()
                .reduce( function (a, b) {
                    return intVal(a) + intVal(b);
                }, 0 );

            total = api
                .column( 3 /*, { search: 'applied', page: 'current'} */)
                .data()
                .reduce( function (a, b) {
                    return intVal(a) + intVal(b);
                }, 0 );

            operaciones = api
                .rows()
                .data()
                .count();

            $('.ventas-total').text(moneda+' '+formatNumber(total));
            $('.ventas-descuentos').text(moneda+' '+formatNumber(descuento));
            $('.ventas-operaciones').text(operaciones);
        }
    });
    $('.dataTables_wrapper').addClass('p-0');
}

/* Estado del cliente Activo - Inactivo */
var estado = function(id_cliente,estado,nombres){

    if(estado == 'a'){
        var esta = 'INACTIVO';
        var est = 'i';
    }else{
        var esta = 'ACTIVO';
        var est = 'a';
    }

    var html_confirm = '<div>Se pondrá '+esta+' al cliente:<br> '+nombres+'</div><br>\
        <div><span class="text-success" style="font-size: 17px;">¿Está Usted de Acuerdo?</span></div>';

    Swal.fire({
        title: 'Necesitamos de tu Confirmación',
        html: html_confirm,
        icon: 'info',
        showCancelButton: true,
        confirmButtonColor: '#34d16e',
        confirmButtonText: 'Si, Adelante!',
        cancelButtonText: "No!",
        showLoaderOnConfirm: true,
        preConfirm: function() {
            return new Promise(function(resolve) {
                $.ajax({
                    url: $('#url').val()+'cliente/cliente_estado',
                    type: 'POST',
                    data: {
                        id_cliente: id_cliente,
                        estado: est
                    },
                    dataType: 'json'
                })
                .done(function(response){
                    Swal.fire({
                        title: 'Proceso Terminado',
                        text: 'Datos actualizados correctamente',
                        icon: 'success',
                        confirmButtonColor: "#34d16e",   
                        confirmButtonText: "Aceptar"
                    });
                    listar($('#filtro_tipo_cliente').val());
                    $('.display-one').css('display','block');
                    $('.display-two').css('display','none');
                })
                .fail(function(){
                    Swal.fire('Oops...', 'Problemas con la conexión a internet!', 'error');
                });
            });
        },
        allowOutsideClick: false              
    });
}

var anular = function(id_cliente,nombres){

    var html_confirm = '<div>Se anulará del sistema, al cliente:<br> '+nombres+'</div><br>\
        <div><span class="text-success" style="font-size: 17px;">¿Está Usted de Acuerdo?</span></div>';

    Swal.fire({
        title: 'Necesitamos de tu Confirmación',
        html: html_confirm,
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#34d16e',
        confirmButtonText: 'Si, Adelante!',
        cancelButtonText: "No!",
        showLoaderOnConfirm: true,
        preConfirm: function() {
          return new Promise(function(resolve) {
             $.ajax({
                url: $('#url').val()+'cliente/cliente_delete',
                type: 'POST',
                data: {id_cliente: id_cliente},
                dataType: 'json'
             })
             .done(function(response){
                if(response == 1){
                Swal.fire({
                    title: 'Proceso Terminado',
                    text: 'Datos eliminados correctamente',
                    icon: 'success',
                    confirmButtonColor: "#34d16e",   
                    confirmButtonText: "Aceptar"
                });
                }else{
                    Swal.fire({
                        title: 'Proceso No Culminado',
                        text: 'Datos protegidos',
                        icon: 'error',
                        confirmButtonColor: "#34d16e",   
                        confirmButtonText: "Aceptar"
                    });
                }
                listar($('#filtro_tipo_cliente').val());
                $('.display-one').css('display','block');
                $('.display-two').css('display','none');
             })
             .fail(function(){
                Swal.fire('Oops...', 'Problemas con la conexión a internet!', 'error');
             });
          });
        },
        allowOutsideClick: false              
    });
}

var editar = function(id_cliente){
    $.ajax({
        url: $('#url').val()+'cliente/cliente_datos',
        type: 'POST',
        data: {id_cliente: id_cliente},
        dataType: 'json'
    })
    .done(function(item){
        $.each(item.data, function(i, campo) {
            $('#id_cliente').val(campo.id_cliente);
            $('#tipo_cliente').val(campo.tipo_cliente);
            $('#dni').val(campo.dni);
            
            // Manejar RUC con DV si existe
            var rucVal = campo.ruc || '';
            if (campo.dv) {
                rucVal = (rucVal + ' DV:' + campo.dv).trim();
                $('#dv_cliente').val(campo.dv);
            } else {
                $('#dv_cliente').val('');
            }
            $('#ruc').val(rucVal);
            
            $('#nombres').val(campo.nombres);
            $('#ape_paterno').val(campo.ape_paterno);
            $('#ape_materno').val(campo.ape_materno);
            $('#fecha_nac').val(campo.fecha_nac);
            //$('#fecha_nac').val(moment(campo.fecha_nac).format('DD-MM-Y'));
            $('#telefono').val(campo.telefono);
            $('#correo').val(campo.correo);
            $('#razon_social').val(campo.razon_social);
            $('#direccion').val(campo.direccion);
            $('#referencia').val(campo.referencia);
            if ($('#ubicacion').length) $('#ubicacion').val(campo.ubicacion || '');
            if ($('#tipo_ruc_cliente').length) $('#tipo_ruc_cliente').val(campo.tipo_ruc || '');
            $('.modal-title').text('Editar Cliente');
            // Siempre mostrar campos de RUC (solo RUC disponible)
            $("#td_ruc").attr('checked', true);
            $(".dni").prop('disabled', true);
            $(".ruc").prop('disabled', false);
            $(".block01").css("display","none");
            $(".block02").css("display","block");
            $(".block03").css("display","block");
            $(".block04").css("display","block");
            $(".block05").css("display","block");
            $(".block06").css("display","block");
            $(".block07").css("display","block");
            // Si el cliente es tipo 1 (DNI), cambiar a tipo 2 (RUC) al editar
            if(campo.tipo_cliente == 1){
                $('#tipo_cliente').val(2);
            }
        });
        $('#modal').modal('show');
    })
    .fail(function(){
        swal('Oops...', 'Problemas con la conexión a internet!', 'error');
    });
}

$('.btn-nuevo').click( function() {
    $('#id_cliente').val('');
    $('#tipo_cliente').val(2);
    $('#dv_cliente').val("");
    if ($('#ubicacion').length) $('#ubicacion').val("");
    if ($('#tipo_ruc_cliente').length) $('#tipo_ruc_cliente').val("");
    $('.modal-title').text('Nuevo Cliente');
    $('#modal').modal('show');
    $("#td_ruc").attr('checked', true);
    $(".dni").prop('disabled', true);
    $(".ruc").prop('disabled', false);
    $(".block01").css("display","none");
    $(".block02").css("display","block");
    $(".block03").css("display","block");
    $(".block04").css("display","block");
    $(".block05").css("display","block");
    $(".block06").css("display","block");
    $(".block07").css("display","block");
});

// Solo RUC está disponible, no hay selector de DNI/RUC
$('input:radio[id=td_ruc]').on('click', function(event){
    $('#tipo_cliente').val(2);
    $("#td_ruc").attr('checked', true);
    $(".block01").css("display","none");
    $(".block02").css("display","block");
    $(".block03").css("display","block");
    $(".block04").css("display","block");
    $(".block05").css("display","block");
    $(".block06").css("display","block");
    $(".block07").css("display","block");
    $(".dni").prop('disabled', true);
    $(".ruc").prop('disabled', false);
    $('#dni').val("");
    $('#form').formValidation('resetForm', true);
});

$('#modal').on('hidden.bs.modal', function() {
    $(this).find('form')[0].reset();
    $('#dv_cliente').val("");
    if ($('#ubicacion').length) $('#ubicacion').val("");
    if ($('#tipo_ruc_cliente').length) $('#tipo_ruc_cliente').val("");
    $('#form').formValidation('resetForm', true);
});

/* Consultar DNI del nuevo cliente: primero en DB, si no existe usar API */
$("#dni").keyup(function(event) {
    var that = this,
    value = $(this).val().trim();
    if (value.length == $("#dni").attr("maxlength")) {
        var dniNum = value.replace(/\D/g, '');
        // 1) Buscar primero en la base de datos
        $.ajax({
            url: $('#url').val() + 'cliente/cliente_por_dni',
            type: 'POST',
            data: { dni: dniNum },
            dataType: 'json'
        })
        .done(function(response) {
            if (response && response.success && response.data) {
                var c = response.data;
                $('#id_cliente').val(c.id_cliente || '');
                $('#tipo_cliente').val(c.tipo_cliente != null ? c.tipo_cliente : 1);
                $("#dni").val(c.dni || '');
                $("#nombres").val(c.nombres || '');
                $("#fecha_nac").val(c.fecha_nac ? String(c.fecha_nac).substr(0, 10) : '');
                $("#telefono").val(c.telefono || '');
                $("#correo").val(c.correo || '');
                $("#direccion").val(c.direccion || '');
                $("#referencia").val(c.referencia || '');
                if ($('#ubicacion').length) $('#ubicacion').val(c.ubicacion || '');
                $('#form').formValidation('revalidateField', 'nombres');
                $('#form').formValidation('revalidateField', 'dni');
                Swal.fire({ title: 'Cliente encontrado', html: 'Se cargaron los datos desde la base de datos. Puede actualizar correo, dirección, ubicación, referencia y fecha de nacimiento antes de Aceptar.', icon: 'success', confirmButtonColor: '#34d16e', timer: 3000, showConfirmButton: true });
                return;
            }
            // 2) No existe en DB: consultar API externa
            $.getJSON($('#url').val() + "api/dni/" + encodeURIComponent(dniNum), { format: "json" })
            .done(function(data) {
                if (data == null || data.success == false) {
                    Swal.fire({ title: 'Advertencia', html: 'El número ingresado no existe', icon: "warning", confirmButtonColor: "#34d16e", confirmButtonText: "Aceptar" });
                    return;
                }
                $("#dni").val(data.dni);
                $("#nombres").val((data.nombres || '') + ' ' + (data.apellidoPaterno || '') + ' ' + (data.apellidoMaterno || ''));
                $("#fecha_nac").val(data.fechaNacimiento || '');
                $("#direccion").val(data.direccion || '');
                $('#form').formValidation('revalidateField', 'nombres');
                $('#form').formValidation('revalidateField', 'ape_paterno');
                $('#form').formValidation('revalidateField', 'ape_materno');
            })
            .fail(function() {
                Swal.fire({ title: 'Advertencia', html: 'El número ingresado no existe o no se pudo consultar.', icon: "warning", confirmButtonColor: "#34d16e", confirmButtonText: "Aceptar" });
            });
        })
        .fail(function() {
            $.getJSON($('#url').val() + "api/dni/" + encodeURIComponent(dniNum), { format: "json" })
            .done(function(data) {
                if (data == null || data.success == false) {
                    Swal.fire({ title: 'Advertencia', html: 'El número ingresado no existe', icon: "warning", confirmButtonColor: "#34d16e", confirmButtonText: "Aceptar" });
                    return;
                }
                $("#dni").val(data.dni);
                $("#nombres").val((data.nombres || '') + ' ' + (data.apellidoPaterno || '') + ' ' + (data.apellidoMaterno || ''));
                $("#fecha_nac").val(data.fechaNacimiento || '');
                $("#direccion").val(data.direccion || '');
                $('#form').formValidation('revalidateField', 'nombres');
            });
        });
    } else if($("#dni").val() == "") {
        $('#dni').val("");
        $('#ruc').val("");
        $('#dv_cliente').val("");
        $('#nombres').val("");
        $('#fecha_nac').val("");
        $('#telefono').val("");
        $('#correo').val("");
        $('#razon_social').val("");
        $('#direccion').val("");
        $('#referencia').val("");
        if ($('#ubicacion').length) $('#ubicacion').val("");
        if ($('#tipo_ruc_cliente').length) $('#tipo_ruc_cliente').val("");
        $('#form').formValidation('resetForm', true);
    }
});

/* Consultar RUC del nuevo cliente: solo con botón Buscar (no automático) */
$("#ruc").keyup(function() {
    var value = $(this).val();
    if (value == "") {
        $('#dni').val("");
        $('#ruc').val("");
        $('#dv_cliente').val("");
        $('#nombres').val("");
        $('#fecha_nac').val("");
        $('#telefono').val("");
        $('#correo').val("");
        $('#razon_social').val("");
        $('#direccion').val("");
        $('#referencia').val("");
        if ($('#ubicacion').length) $('#ubicacion').val("");
        if ($('#tipo_ruc_cliente').length) $('#tipo_ruc_cliente').val("");
        $('#form').formValidation('resetForm', true);
    }
});
$("#ruc").on("keypress", function(event) {
    if (event.which === 13) {
        event.preventDefault();
        $("#btn_buscar_ruc").click();
    }
});
$("#btn_buscar_ruc").on("click", function() {
    var value = $("#ruc").val().trim();
    if (!value || value.length < 5) {
        Swal.fire({
            title: 'Atención',
            html: 'Ingrese al menos 5 caracteres en el campo ' + $(".c-ruc").text() + ' para buscar.',
            icon: 'warning',
            confirmButtonColor: '#34d16e',
            confirmButtonText: 'Aceptar'
        });
        return;
    }
    // RUC limpio (sin " DV:xx") para buscar en DB
    var rucLimpio = value.indexOf(' DV:') !== -1 ? value.replace(/\s*DV:\s*\S+$/, '').trim() : value;
    buscarRucPanama(value, rucLimpio);
});

/* Función para buscar RUC: primero en DB; si no existe, consultar API externa */
function buscarRucPanama(rucDisplay, rucLimpio) {
    if (typeof rucLimpio === 'undefined') rucLimpio = rucDisplay.replace(/\s*DV:\s*\S+$/, '').trim();
    $("#razon_social").attr('placeholder', 'Buscando...');

    // 1) Buscar primero en la base de datos (enviamos RUC normalizado para coincidir con 8-829-2193 o 88292193)
    var rucParaDb = (rucLimpio || '').replace(/\s*DV:\s*\S+$/, '').trim().replace(/[^\d]/g, '');
    if (!rucParaDb) rucParaDb = rucLimpio;
    $.ajax({
        url: $('#url').val() + 'cliente/cliente_por_ruc',
        type: 'POST',
        data: { ruc: rucParaDb },
        dataType: 'json'
    })
    .done(function(response) {
        if (response && response.success && response.data) {
            $("#razon_social").attr('placeholder', '');
            var c = response.data;
            $('#id_cliente').val(c.id_cliente || '');
            $('#tipo_cliente').val(c.tipo_cliente != null ? c.tipo_cliente : 2);
            $('#dni').val(c.dni || '');
            var rucVal = c.ruc || '';
            if (c.dv) {
                rucVal = (rucVal + ' DV:' + c.dv).trim();
                $('#dv_cliente').val(c.dv);
            } else {
                $('#dv_cliente').val('');
            }
            $('#ruc').val(rucVal);
            $('#nombres').val(c.nombres || '');
            $('#razon_social').val(c.razon_social || '');
            $('#telefono').val(c.telefono || '');
            $('#correo').val(c.correo || '');
            $('#direccion').val(c.direccion || '');
            $('#referencia').val(c.referencia || '');
            if (c.fecha_nac) {
                var f = String(c.fecha_nac).substr(0, 10);
                $('#fecha_nac').val(f);
            } else {
                $('#fecha_nac').val('');
            }
            if ($('#ubicacion').length) $('#ubicacion').val(c.ubicacion || '');
            if ($('#tipo_ruc_cliente').length) $('#tipo_ruc_cliente').val(c.tipo_ruc != null ? c.tipo_ruc : '');
            $('#form').formValidation('revalidateField', 'razon_social');
            $('#form').formValidation('revalidateField', 'direccion');
            $('#form').formValidation('revalidateField', 'ruc');
            $('#form').formValidation('revalidateField', 'correo');
            Swal.fire({ title: 'Cliente encontrado', html: 'Se cargaron los datos desde la base de datos.', icon: 'success', confirmButtonColor: '#34d16e', timer: 2000, showConfirmButton: false });
            return;
        }
        // 2) No existe en DB: consultar API externa
        consultarApiRuc(rucDisplay);
    })
    .fail(function() {
        consultarApiRuc(rucDisplay);
    });
}

function consultarApiRuc(ruc) {
    $.getJSON($('#url').val() + "api/ruc/" + encodeURIComponent(ruc), { format: "json" })
    .done(function(data) {
        $("#razon_social").attr('placeholder', '');
        console.log('Respuesta API RUC:', data);
        if (data == null || data.success == false) {
            Swal.fire({ title: 'Advertencia', html: 'El número ingresado no existe', icon: "warning", confirmButtonColor: "#34d16e", confirmButtonText: "Aceptar" });
            return;
        }
        $('#id_cliente').val(''); // Cliente no está en DB: Aceptar creará uno nuevo
        if (data.ruc) {
            var rucCompleto = data.ruc;
            if (data.dv) {
                rucCompleto = data.ruc + ' DV:' + data.dv;
                $('#dv_cliente').val(data.dv);
            } else {
                $('#dv_cliente').val('');
            }
            $('#ruc').val(rucCompleto);
        }
        if (data.razonSocial) $('#razon_social').val(data.razonSocial);
        if (data.direccion) $('#direccion').val(data.direccion);
        if ($('#tipo_ruc_cliente').length && data.tipoRuc) $('#tipo_ruc_cliente').val(data.tipoRuc);
        $('#form').formValidation('revalidateField', 'razon_social');
        $('#form').formValidation('revalidateField', 'direccion');
        $('#form').formValidation('revalidateField', 'ruc');
    })
    .fail(function() {
        $("#razon_social").attr('placeholder', '');
        Swal.fire({ title: 'Error', html: 'Error al consultar el RUC. Intente nuevamente.', icon: "error", confirmButtonColor: "#34d16e", confirmButtonText: "Aceptar" });
    });
}