var moneda = $("#moneda").val();
$(function() {
    moment.locale('es');
    listar();
    stock_pollo();
    listar_cajas();
    $('#form-apertura').formValidation({
        framework: 'bootstrap',
        excluded: ':disabled',
        fields: {
        }
    }).on('success.form.fv', function(e) {
        // Prevent form submission
        e.preventDefault();
        var $form = $(e.target),
        fv = $form.data('formValidation');

        var parametros = {
            "id_apc" : '',
            "id_caja" : $('#id_caja').val(),
            "id_turno" : $('#id_turno').val(),
            "monto_aper" : $('#monto_aper').val()
        };

        var html_confirm = '<div>Se creará una apertura de caja con los siguientes datos:</div>\
            <br><div style="width: 100% !important; float: none !important;">\
            <table class="table m-b-0">\
            <tr><td class="text-left">Caja: </td><td class="text-right">'+$('select[name="id_caja"] option:selected').text()+'</td></tr>\
            <tr><td class="text-left">Turno: </td><td class="text-right">'+$('select[name="id_turno"] option:selected').text()+'</td></tr>\
            <tr><td class="text-left">Monto: </td><td class="text-right">'+moneda+' '+formatNumber($('#monto_aper').val())+'</td></tr>\
            </table>\
            </div><br>\
            <div><span class="text-success" style="font-size: 17px;">¿Está Usted de Acuerdo?</span></div>';

        Swal.fire({
            title: 'Necesitamos de tu Confirmación',
            html: html_confirm,
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#34d16e',
            confirmButtonText: 'Si, Adelante!',
            cancelButtonText: "No!",
            showLoaderOnConfirm: true,
            preConfirm: function() {
              return new Promise(function(resolve) {
                 $.ajax({
                    url: $('#url').val()+'caja/apercie_crud',
                    type: 'POST',
                    data: parametros,
                    dataType: 'json'
                 })
                 .done(function(response){
                    if(response == 1){
                    Swal.fire({
                        title: 'Proceso Terminado',
                        text: 'Datos registrados correctamente',
                        icon: 'success',
                        confirmButtonColor: "#34d16e",   
                        confirmButtonText: "Aceptar"
                    });
                    $("#modal-apertura").modal('hide');
                    }else{
                        Swal.fire({
                            title: 'Proceso No Culminado',
                            text: 'Datos duplicados',
                            icon: 'error',
                            confirmButtonColor: "#34d16e",   
                            confirmButtonText: "Aceptar"
                        });
                    }
                    listar();
                    listar_cajas();
                 })
                 .fail(function(){
                    Swal.fire('Oops...', 'Problemas con la conexión a internet!', 'error');
                 });
              });
            },
            allowOutsideClick: false              
        });
    });

    $('#form-cierre').formValidation({
        framework: 'bootstrap',
        excluded: ':disabled',
        fields: {
        }
    }).on('success.form.fv', function(e) {
        // Prevent form submission
        e.preventDefault();
        var $form = $(e.target);
        var fv = $form.data('formValidation');
        cierre();
    });

    $('#caja').addClass("active");
    $('#c-apc').addClass("active");
});

var listar = function(){
    $.ajax({
        url:   $('#url').val()+'caja/apercie_list',
        type:  'POST',
        dataType: 'json',
        success: function(data) {
            if(data == false){
                $('.display-apertura').css('display','block');
                $('.display-cierre').css('display','none');
            } else {
                $('.display-apertura').css('display','none');
                $('.display-cierre').css('display','block');
                $('#id_apc').val(data.id_apc);
                $('.fecha-apertura').text(moment(data.fecha_aper).format('[Abierto el día ]dddd, D [de] MMMM [a las] h:mm:ss a'));
                //$('.fecha-apertura').text(moment(data.fecha_aper).format('DD-MM-Y')+' | '+moment(data.fecha_aper).format('h:mm A'));
                monto_sistema(data.id_apc);
            }
        }
    });
}

var monto_sistema = function(id_apc){
    $.ajax({
        //async: false,
        data: { id_apc : id_apc },
        type:  'POST',
        dataType: 'json',
        url:   $('#url').val()+'caja/apercie_montosist',
        success: function(data) {
            if (data.total != '') {
                // var montoSist = (parseFloat(data.Apertura.monto_aper) + parseFloat(data.total) + parseFloat(data.Ingresos.total) - parseFloat(data.EgresosA.total) - parseFloat(data.EgresosB.total)).toFixed(2);
                //var montoSist = (parseFloat(data.Apertura.monto_aper) + parseFloat(data.pago_efe) + parseFloat(data.Ingresos.total) - parseFloat(data.EgresosA.total) - parseFloat(data.EgresosB.total)).toFixed(2);
                var montoSist = (parseFloat(data.Apertura.monto_aper) + parseFloat(data.pago_efe) + parseFloat(data.Ingresos.total) + parseFloat(data.EfectivoPropinas.total) - parseFloat(data.EgresosA.total) - parseFloat(data.EgresosB.total)).toFixed(2);
                console.log(montoSist)
                $("#monto_sistema").val(montoSist);
                console.log(montoSist);
            }
        }
    });
}

var cierre = function(){

    var parametros = {
        "id_apc" : $('#id_apc').val(),
        "monto_cierre" : $('#monto_cierre').val(),
        "monto_sistema" : $('#monto_sistema').val(),
        "stock_pollo" : $('#stock_pollo').val()
    };

    var html_confirm = '<div>Se cerrará el turno de caja con los siguientes datos:</div>\
        <br><div style="width: 100% !important; float: none !important;">\
        <table class="table">\
        <tr><td class="text-left">Importe: </td><td class="text-right">'+moneda+' '+formatNumber($('#monto_cierre').val())+'</td></tr>\
        </table>\
        </div>\
        <div><span class="text-success" style="font-size: 17px;">¿Está Usted de Acuerdo?</span></div>';

        var botomarqueo = '<div class="text-center"><a class="btn btn-outline-primary" href="'+$("#url").val()+'informe/finanza_arq_imp/'+$('#id_apc').val()+'" target="_blank"><i class="fi fi-rr-print font-20 mr-2"></i> Arqueo de caja</a></div>';
        if($("#caja_prod_sep").val() == 1){
        botomarqueo +='<div class="text-center mt-1"><a class="btn btn-outline-primary" href="'+$("#url").val()+'informe/finanza_arq_imp/'+$('#id_apc').val()+'/productos" target="_blank"><i class="fi fi-rr-print font-20 mr-2"></i> Productos vendidos</a></div>';
        }

    var html_print = '<div>El turno de caja ha sido cerrada.<br>Puede imprimir el arqueo de caja, para obtener el detalle de sus procesos.</div>\
        <br>'+botomarqueo+'<br>\ ';
    Swal.fire({
        title: 'Necesitamos de tu Confirmación',
        html: html_confirm,
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#34d16e',
        confirmButtonText: 'Si, Adelante!',
        cancelButtonText: "No!",
        showLoaderOnConfirm: true,
        preConfirm: function() {
          return new Promise(function(resolve) {
             $.ajax({
                url: $('#url').val()+'caja/apercie_crud',
                type: 'POST',
                data: parametros,
                dataType: 'json'
             })
             .done(function(response){
                Swal.fire({
                    title: 'Proceso Terminado',
                    html: html_print,
                    icon: 'success',
                    confirmButtonColor: "#34d16e",   
                    confirmButtonText: "Aceptar",
                    showLoaderOnConfirm: true,
                    showCancelButton: false,
                    preConfirm: function() {
                        
                        return new Promise(function(resolve) {
                            var html_optimizar = '<div>Para poder eliminar los datos, \
                            no deben existir pedidos aperturados en el sistema<br></div><br>\
                            <div>Ingrese código de seguridad</div><br>\
                            <form><input class="form-control text-center w-50" type="password" id="codigo_seguridad_" autocomplete="off"/></form><br>\
                            <label id="password_respuesta" class=""></label>\
                            <div><span class="text-success" style="font-size: 17px;">¿Está Usted de Acuerdo?</span></div>';
                            disable = true;   
                            Swal.fire({
                                customClass: {
                                    confirmButton: 'c-disabled',
                                },
                                title: '¿Deseas eliminar pedidos sin procesar?',
                                html: html_optimizar,
                                icon: 'warning',
                                showCancelButton: true,
                                confirmButtonColor: '#34d16e',
                                confirmButtonText: 'Si, Adelante!',
                                cancelButtonText: "No!",
                                showLoaderOnConfirm: true,
                                preConfirm: function() {
                                return new Promise(function(resolve) {

                                    $.ajax({
                                        url: $("#url").val()+'ajuste/optimizar_pedidos_caja',
                                        type: 'POST',
                                        dataType: 'json'
                                    })
                                    .done(function(response){
                                        if(response == 1){
                                            Swal.fire({
                                                title: 'Proceso Terminado',
                                                text: 'El sistema se ha optimizado correctamente',
                                                icon: 'success',
                                                confirmButtonColor: "#34d16e",   
                                                confirmButtonText: "Aceptar"
                                            });  
                                        }else{
                                            Swal.fire({
                                                title: 'Proceso No Culminado',
                                                text: 'Asegurese de no tener un pedido abierto',
                                                icon: 'error',
                                                confirmButtonColor: "#34d16e",   
                                                confirmButtonText: "Aceptar"
                                            });
                                        }               
                                    })
                                    .fail(function(){
                                        Swal.fire('Oops...', 'Problemas con la conexión a internet!', 'error');
                                    });

                                });
                                
                                },
                                allowOutsideClick: false              
                            });  
                            $('.c-disabled').attr('disabled', disable);
                            $('#codigo_seguridad_').on( 'keyup click', function () {
                                disableboton();
                            });
                        });
                    },
                });

                $("#modal-cierre").modal('hide');
                listar();
                listar_cajas();
             })
             .fail(function(){
                Swal.fire('Oops...', 'Problemas con la conexión a internet!', 'error');
             });
          });
        },
        allowOutsideClick: false              
    });
}

var disableboton = function(){
    if ($("#codigo_seguridad").val() == $('#codigo_seguridad_').val()) {
        $("#password_respuesta").text('Contraseña Correcta');
        $("#password_respuesta").addClass('text-success');
        $("#password_respuesta").removeClass('text-danger');
        $('.c-disabled').attr('disabled', false);  
    }else{
        $("#password_respuesta").addClass('text-danger');
        $("#password_respuesta").removeClass('text-success');
        $("#password_respuesta").text('Contraseña Incorrecta');
        $('.c-disabled').attr('disabled', true);
    }
}

$('.btn-aceptar-apertura').on('submit', function() {
    $('.s').addClass('focused');
});

var stock_pollo = function(){
    $.ajax({
        type:  'POST',
        dataType: 'json',
        url:   $('#url').val()+'caja/stock_pollo',
        success: function(data) {
            if (data.total != '') {
                $("#stock_pollo").val(data.total);
            }
        }
    }); 
}

var listar_cajas = function(){
   
    $('#lista_caja').empty();
    
    $.ajax({
        type: "POST",
        url: $('#url').val()+'caja/apercie_listcaja',
        dataType: "json",
        success: function(item){
            var moneda = $("#moneda").val();
            var rOL = $("#codRol").val();
            
            if(item.length > 0 ){
                // console.log(item);
                $.each(item, function(i, datu) {

                    var link = (rOL == '1' || rOL == '2') ? '<a href="' + $("#url").val() + 'ajuste/usuario">' + datu.desc_per + '</a>' : datu.desc_per;
                    
                    $('#lista_caja')
                      .append(
                        $('<tr/>')
                        .append(
                            $('<td/>')
                            .html(''+datu.desc_caja+'')
                        )
                        .append(
                            $('<td/>')
                            .html(datu.fecha_aper)
                        )
                        .append(
                            $('<td/>')
                            .html(link)
                        )
                        .append(
                            $('<td class="text-right"/>')
                            .html(moneda+' '+formatNumber(datu.monto_aper))
                        )
                    )
                });
            } else {
                $('#lista_caja').html("<tr style='border-left: 2px solid #fff !important; background: #fff !important;'><td colspan='5'><div class='text-center'><h4 class='m-t-40' style='color: #d3d3d3;'><i class='fas fa-filter display-3 m-t-10 m-b-10'></i><br>Aperture una caja<br><small>No se encontraron datos <br></small></h4></div></td></tr>");
            }
        }
      });
    }

/* Accion desde la fecha */
/*
$('#fecha_cierre').on('change', function(e) { 
    $.ajax({
        data: { id_apc : $("#id_apc").val() },
        type:  'POST',
        dataType: 'json',
        url:   $('#url').val()+'caja/apercie_montosist',
        success: function(data) {
            if (data.total != '') {
                // Se agrego parseFloat(data.pago_tar) para obtener monto de cierre en efectivo
                var montoSist = (parseFloat(data.Apertura.monto_aper) - parseFloat(data.pago_tar) + parseFloat(data.total) + parseFloat(data.Ingresos.total) - parseFloat(data.EgresosA.total) - parseFloat(data.EgresosB.total)).toFixed(2);
                $("#monto_sistema").val(montoSist);
            }
        }
    }); 
});
*/