<?php
// Obtener imp_val de la base de datos si no está en la sesión
$imp_val_session = Session::get('imp_val');
// Verificar si imp_val no está definido en la sesión (null, false, o string vacío)
// Pero permitir que sea '0' si realmente está configurado a 0
if($imp_val_session === null || $imp_val_session === false || $imp_val_session === ''){
    try {
        require_once 'libs/Database.php';
        $db_temp = new Database(DB_TYPE, DB_HOST, DB_NAME, DB_USER, DB_PASS, DB_CHARSET);
        $stm_config = $db_temp->prepare("SELECT imp_val FROM tm_configuracion WHERE id_cfg = 1");
        $stm_config->execute();
        $config_data = $stm_config->fetch(PDO::FETCH_ASSOC);
        if($config_data && isset($config_data['imp_val'])){
            $imp_val_session = $config_data['imp_val'];
            Session::set('imp_val', $imp_val_session); // Actualizar sesión para futuras referencias
        } else {
            // Si no hay valor en BD, calcular desde igv si existe
            $imp_val_session = Session::get('igv') ? (Session::get('igv') * 100) : '0';
        }
    } catch(Exception $e) {
        // Si hay error, calcular desde igv si existe
        $imp_val_session = Session::get('igv') ? (Session::get('igv') * 100) : '0';
    }
}
// Formatear el valor para mostrar (eliminar decimales innecesarios si es entero)
$imp_val_display = $imp_val_session;
if(is_numeric($imp_val_display)){
    $imp_val_display = floatval($imp_val_display);
    // Si es un número entero, mostrarlo sin decimales
    if($imp_val_display == intval($imp_val_display)){
        $imp_val_display = intval($imp_val_display);
    } else {
        $imp_val_display = number_format($imp_val_display, 2, '.', '');
    }
}
?>
<input type="hidden" id="url" value="<?php echo URL; ?>"/>
<input type="hidden" id="moneda" value="<?php echo Session::get('moneda'); ?>"/>
<input type="hidden" id="cod_ti" value="3"/>
<input type="hidden" id="impuesto_incluido_sistema" value="<?php echo Session::get('impuesto_incluido') ? Session::get('impuesto_incluido') : '0'; ?>"/>
<input type="hidden" id="impuesto_nombre_sistema" value="<?php echo Session::get('impAcr'); ?>"/>
<input type="hidden" id="impuesto_valor_sistema" value="<?php echo $imp_val_display; ?>"/>
<style>

.icon-service {
  width: 36px;   /* ajusta el tamaño */
  height: auto;
  filter: invert(34%) sepia(88%) saturate(1800%) hue-rotate(190deg) brightness(95%) contrast(95%);
}
.btn-abrir-exportar-producto { cursor: pointer; }
.btn-abrir-exportar-producto:hover { background-color: rgba(0,0,0,.04); }
.btn-abrir-exportar-producto:hover h5 { color: #28a745 !important; }


</style>

<div class="row page-titles">
    <div class="col-md-5 col-8 align-self-center">
        <h4 class="m-b-0 m-t-0">Ajustes</h4>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="<?php echo URL; ?>ajuste" class="link">Inicio</a></li>
            <li class="breadcrumb-item"><a href="<?php echo URL; ?>ajuste" class="link">Comercio</a></li>
            <li class="breadcrumb-item active">Productos</li>
        </ol>
    </div>
</div>
<div class="row">
    <div class="col-lg-3">
        <div class="card">         
            <div class="card-body">
                <div class="message-box contact-box">
                    <h4 class="card-title">Categorías</h4>
                    <h2 class="add-ct-btn" id="step1"><button type="button" class="btn btn-circle btn-lg btn-orange waves-effect waves-dark btn-categoria-nuevo"><i class="ti-plus"></i></button></h2>
                    <form id="form-categoria" method="post" enctype="multipart/form-data">
                    <input type="hidden" name="id_catg_categoria" id="id_catg_categoria">
                        <div id="display-categoria-nuevo" style="display: none">
                            <ul class="list-style-none">
                                <li class="divider"></li>
                            </ul>
                            <div class="row floating-labels m-t-40">
                                <div class="col-sm-12">
                                    <div class="ct-wizard-azzure" id="wizardProfile">
                                        <div class="picture-container">
                                            <div class="picture" style="width: 150px; height:150px">
                                                <img src="<?php echo URL; ?>public/images/productos/default.png" class="picture-src" id="wizardPicturePreview-2"/>
                                                <input type="hidden" name="imagen" id="imagen" value="default.png" />
                                                <input type="file" name="imagen" id="wizard-picture-2">
                                            </div>      
                                            <h6>Cambiar Imagen</h6>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-12">
                                    <div class="form-group f m-t-40 m-b-20 letNumMayMin">
                                        <input type="text" class="form-control input-mayus cbu ph-0" name="descripcion_categoria" id="descripcion_categoria" autocomplete="off" required>
                                        <span class="bar"></span>
                                        <label for="descripcion_categoria">Nombre</label>
                                    </div>
                                </div>
                                <div class="col-sm-12">
                                    <div class="form-group m-t-20 ent">
                                        <input type="text" class="form-control input-mayus cbu ph-0" name="orden_categoria" id="orden_categoria" autocomplete="off">
                                        <span class="bar"></span>
                                        <label for="orden_categoria">Orden</label>
                                    </div>
                                </div>
                                <div class="col-sm-12 m-t-20">
                                    <input type="hidden" name="hidden_estado_categoria" id="hidden_estado_categoria"/>
                                    <input type="checkbox" name="estado_categoria" id="estado_categoria" class="chk-col-green"/>
                                    <label for="estado_categoria">Activo</label>
                                </div>
                                <div class="col-sm-12 m-t-0">
                                    <input type="hidden" name="hidden_delivery_categoria" id="hidden_delivery_categoria"/>
                                    <input type="checkbox" name="delivery_categoria" id="delivery_categoria" class="chk-col-green"/>
                                    <label for="delivery_categoria">Delivery <i class="ti-info-alt text-warning font-10" data-original-title="¿Deseas mostrar esta presentación en tus deliverys?" data-toggle="tooltip" data-placement="top"></i></label>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-6 m-b-10">
                                    <a class="btn btn-secondary btn-block btn-categoria-cancelar">Cancelar</a>
                                </div>
                                <div class="col-6 m-b-10 text-right">
                                    <button type="submit" class="btn btn-block btn-success">Aceptar</button>
                                </div>
                            </div>
                        </div>
                    </form>
                    <ul class="list-style-none display-categoria-list">
                        <li class="box-label"><a href="javascript:void(0)" class="link" onclick="listarProductos('%')">Todos</a></li>
                    </ul>
                    <ul class="list-style-none display-categoria-list" style="font-size: 13px;">
                        <li class="divider"></li>
                        <div class="scroll_categoria" id="ul-cat"></div>
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <div class="col-lg-9">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header bg-light-inverse p-0">
                        <div class="row">
                            <div class="col-12">
                                <div class="social-widget">
                                    <div class="soc-content">
                                        <div class="col-3 b-r text-center">
                                            <h1>
                                                <img src="../public/images/servicio.png" class="icon-service" alt="Productos y Servicios">
                                            </h1>
                                            <h5 class="text-warning">Productos y Servicios</h5>
                                        </div>
                                        <div class="col-3 b-r">
                                            <a href="<?php echo URL; ?>ajuste/combo">
                                                <h1><i class="mdi mdi-food text-muted"></i></h1>
                                                <h5 class="text-muted">Combos</h5>
                                            </a>
                                        </div>
                                        <div class="col-3 b-r">
                                            <a href="<?php echo URL; ?>ajuste/insumo">
                                                <h1><i class="mdi mdi-food-variant text-muted"></i></h1>
                                                <h5 class="text-muted">Insumos</h5>
                                            </a>
                                        </div>
                                        <div class="col-3 text-center btn-abrir-exportar-producto" role="button" data-toggle="modal" data-target="#modal-exportar-producto" title="Exportar reporte a Excel">
                                            <h1><i class="mdi mdi-file-excel-box text-success"></i></h1>
                                            <h5 class="text-muted">Exportar</h5>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>                   
                    </div>
                    <div class="card-body p-t-0 p-b-0 floating-labels">
                        <div class="row" style="margin-left: -20px; margin-right: -20px">
                            <!-- Column -->
                            <div class="col-lg-7 p-0">
                                <div class="row p-20">
                                    <div class="col-lg-3 mb-3 mb-sm-0">
                                        <button class="btn btn-primary btn-block btn-importar-producto" id="step2">Importar</button>
                                    </div>
                                    <div class="col-lg-8">
                                        <button class="btn btn-success btn-block btn-nuevo-producto" id="step2"><i class="fas fa-plus-circle"></i> Nuevo producto</button>
                                    </div>
                                    <div class="col-lg-12 m-t-20" id="filter_global">
                                        <div class="form-group m-b-0">
                                            <input class="form-control global_filter" id="global_filter" type="text" placeholder="Buscar producto">
                                            <span class="bar"></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="table-responsive b-t m-b-10">
                                    <table class="table table-condensed table-hover stylish-table" width="100%" id="table-productos">
                                        <thead class="table-head">
                                            <th style="width: 60%;">Producto</th>
                                            <th style="width: 10%; text-align: right">¿Transformable?</th>
                                            <th style="width: 10%; text-align: right">¿Activo?</th>
                                            <th style="width: 20%;"></th>
                                        </thead>
                                        <tbody class="tb-st"></tbody>
                                    </table>
                                </div>
                            </div>
                            <!-- Column -->
                            <div class="col-lg-5 p-t-20 p-b-20 b-l" style="background: #fbfbfb;" id="step3">
                                <div id="head-p"></div>
                                <div id="body-c"></div>
                                <div id="body-p"></div>
                            </div>
                            <!-- Column -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="modal inmodal" id="modal-producto" tabindex="-1" role="dialog" aria-hidden="true" data-backdrop="static" data-keyboard="true">
    <div class="modal-dialog">
        <div class="modal-content animated bounceInTop">
        <form id="form-producto" method="post" enctype="multipart/form-data">
        <input type="hidden" name="id_prod_producto" id="id_prod_producto">
            <div class="modal-header">
                <h4 class="modal-title">Detalle del producto</h4>
                <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Cerrar</span></button>
            </div>
            <div class="modal-body">
                <div class="row floating-labels">
                    <div class="col-md-12">
                        <div class="form-group display-flex">
                            <input class="form-control input-lg input-mayus" type="text" autocomplete="off" placeholder="Nombre" name="nombre_producto" id="nombre_producto" required="required"/>
                            <span class="bar"></span>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <div class="btn-group btn-group-toggle w-100" data-toggle="buttons">
                            <label class="btn waves-effect waves-light btn-secondary" id="transf" data-original-title="Producto que debes PREPARAR ANTES DE VENDER, Ejm: Ceviches, parrillas o tragos" data-toggle="tooltip" data-placement="top">
                                <input type="radio" name="id_tipo" value="1" autocomplete="off"> Transformado
                            </label>
                            <label class="btn waves-effect waves-light btn-secondary" id="ntransf" data-original-title="Producto que has COMPRADO PARA VENDER, Ejm: Sodas, snacks" data-toggle="tooltip" data-placement="top">
                                <input type="radio" name="id_tipo" value="2" autocomplete="off"> No Transformado
                            </label>
                        </div>
                    </div>
                </div>
                <div class="row floating-labels m-t-40">
                    <div class="col-sm-12">
                        <div class="form-group m-b-40">
                            <select class="selectpicker form-control" name="id_areap_producto" id="id_areap_producto" data-style="form-control btn-default" data-live-search-style="begins" data-live-search="true" title="Seleccionar" data-size="5" required="required">
                                <?php foreach($this->AreaProduccion as $key => $value): ?>
                                    <option value="<?php echo $value['id_areap']; ?>"><?php echo $value['nombre']; ?></option>
                                <?php endforeach; ?> 
                            </select>
                            <span class="bar"></span>
                            <label for="id_areap_producto">&Aacute;rea de producci&oacute;n <i class="ti-info-alt text-warning font-10" data-original-title="Area donde se elabora el producto" data-toggle="tooltip" data-placement="top"></i></label>
                        </div>
                    </div>
                    <div class="col-sm-12" id="retornar-nota">
                        <div class="form-group mb-1  remove-nota">
                            <input name="notas_producto[]" id="notas_producto" class="form-control" data-role="tagsinput" placeholder="add">
                            <span class="bar"></span>
                            <label for="notas_producto">Notas <i class="ti-info-alt text-warning font-10" data-original-title="Escribe una o varias notas, Ejm: SIN SAL, POCA SAL" data-toggle="tooltip" data-placement="top"></i></label>
                        </div>
                        
                    </div>
                    <div class="col-sm-12">
                        <div id="notas_fields" class=""></div>
                    </div>
                    <div class="col-sm-12 text-right">
                    <button class="btn btn-link btn-sm  m-b-40" type="button" onclick="notas_fields();"><i class="fa fa-plus"></i> Agregar Grupo de notas</button>
                    </div>
                    <div class="col-sm-12">
                        <div class="form-group m-b-40 cbu">
                            <input type="hidden" id="categoria"/>
                            <select class="selectpicker form-control" name="id_catg_producto" id="id_catg_producto" data-style="form-control btn-default" data-live-search-style="begins" data-live-search="true" title="Seleccionar" data-size="5" required="required">  
                            </select>
                            <span class="bar"></span>
                            <label for="id_catg_producto">Categor&iacute;a <i class="ti-info-alt text-warning font-10" data-original-title="Categoría del producto" data-toggle="tooltip" data-placement="top"></i></label>
                        </div>
                    </div>
                    <div class="col-sm-12 m-t-10">
                        <input type="hidden" name="hidden_estado_producto" id="hidden_estado_producto"/>
                        <input type="checkbox" name="estado_producto" id="estado_producto" class="chk-col-green"/>
                        <label for="estado_producto">Activo</label>
                    </div>
                    <div class="col-sm-12 m-t-0">
                        <input type="hidden" name="hidden_delivery_producto" id="hidden_delivery_producto"/>
                        <input type="checkbox" name="delivery_producto" id="delivery_producto" class="chk-col-green"/>
                        <label for="delivery_producto">Delivery <i class="ti-info-alt text-warning font-10" data-original-title="¿Deseas mostrar esta presentación en tus deliverys?" data-toggle="tooltip" data-placement="top"></i></label>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
                <button type="submit" class="btn btn-success btn-guardar">Aceptar</button>
            </div>
        </form>
        </div>
    </div>
</div>

<div class="modal inmodal" id="modal-presentacion" tabindex="-1" role="dialog" aria-hidden="true" data-backdrop="static" data-keyboard="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content animated bounceInTop">
        <form id="form-presentacion" method="post" enctype="multipart/form-data">
        <input type="hidden" name="nombre_producto_presentacion" id="nombre_producto_presentacion">
        <input type="hidden" name="id_prod_presentacion" id="id_prod_presentacion">
        <input type="hidden" name="id_pres_presentacion" id="id_pres_presentacion">
            <div class="modal-header">
                <h4 class="modal-title">Presentaci&oacute;n del producto</h4>
                <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Cerrar</span></button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-sm-5 b-r">
                        <div class="row m-t-20 m-b-20">
                            <div class="col-sm-12">
                                <div class="ct-wizard-azzure" id="wizardProfile">
                                    <div class="picture-container">
                                        <div class="picture" style="width: 150px; height:150px">
                                            <img src="<?php echo URL; ?>public/images/productos/default.png" class="picture-src" id="wizardPicturePreview"/>
                                            <input type="hidden" name="imagen" id="imagen2" value="default.png" />
                                            <input type="file" name="imagen" id="wizard-picture">
                                        </div>      
                                        <h6>Cambiar Imagen</h6>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row floating-labels">
                            <div class="col-sm-6 m-t-40 m-b-20">
                                <input type="hidden" name="hidden_estado_presentacion" id="hidden_estado_presentacion"/>
                                <input type="checkbox" name="estado_presentacion" id="estado_presentacion" class="chk-col-green"/>
                                <label for="estado_presentacion">Activo</label>
                            </div>
                            <div class="col-sm-6 m-t-40 m-b-20" id="tp-1" style="display: none">
                                <input type="hidden" name="hidden_receta_presentacion" id="hidden_receta_presentacion" value=""/>
                                <input type="checkbox" name="receta_presentacion" id="receta_presentacion" class="chk-col-green" />
                                <label for="receta_presentacion">Tiene receta <i class="ti-info-alt text-warning font-10" data-original-title="¿Esta presentación requiere insumos o productos para su preparación?" data-toggle="tooltip" data-placement="top"></i></label>
                            </div>                
                            <div class="col-sm-6 m-b-20" id="tp-2" style="display: none">
                                <input type="checkbox" name="stock_presentacion" id="stock_presentacion" class="chk-col-green" />
                                <label for="stock_presentacion">Control Stock <i class="ti-info-alt text-warning font-10" data-original-title="¿Esta presentación requiere tener un control de entradas y salidas?" data-toggle="tooltip" data-placement="top"></i></label>
                            </div>
                            <div class="col-sm-6 m-b-20" id="">
                                <input type="hidden" name="hidden_impuesto_presentacion" id="hidden_impuesto_presentacion" value=""/>
                                <input type="hidden" name="igv_impuesto" id="igv_impuesto" value="<?php echo Session::get('igv'); ?>"/>
                                <input type="checkbox" name="impuesto_presentacion" id="impuesto_presentacion" class="chk-col-green"/>
                                <label for="impuesto_presentacion">Impuesto <?php echo Session::get('impAcr'); ?> <i class="ti-info-alt text-warning font-10" data-original-title="Esta opción te permite trabajar con productos exonerados a impuestos. La configuración 'Uso de ventas inafecta a impuestos' debe de estar inactiva" data-toggle="tooltip" data-placement="top"></i></label>
                            </div>
                            <div class="col-sm-6 m-b-20">
                                <input type="hidden" name="hidden_llevar_presentacion" id="hidden_llevar_presentacion"/>
                                <input type="checkbox" name="llevar_presentacion" id="llevar_presentacion" class="chk-col-green"/>
                                <label for="llevar_presentacion">Llevar <i class="ti-info-alt text-warning font-10" data-original-title="¿Deseas mostrar esta presentación en LLevar?" data-toggle="tooltip" data-placement="top"></i></label>
                            </div>   
                            <div class="col-sm-6 m-b-20">
                                <input type="hidden" name="hidden_delivery_presentacion" id="hidden_delivery_presentacion"/>
                                <input type="checkbox" name="delivery_presentacion" id="delivery_presentacion" class="chk-col-green"/>
                                <label for="delivery_presentacion">Delivery <i class="ti-info-alt text-warning font-10" data-original-title="¿Deseas mostrar esta presentación en tus deliverys?" data-toggle="tooltip" data-placement="top"></i></label>
                            </div>
                            <div class="col-sm-6 mb-4" id="tp-toppings" style="display: none">
                                <input type="hidden" name="hidden_toppings_presentacion" id="hidden_toppings_presentacion" value=""/>
                                <input class="material-inputs filled-in chk-col-red" type="checkbox" name="toppings_presentacion" id="toppings_presentacion">
                                <label for="toppings_presentacion">Toppings</label>
                            </div>             
                            <div class="col-sm-6 mb-4" id="tp-nota">
                                <input type="hidden" name="hidden_nota_presentacion" id="hidden_nota_presentacion" value=""/>
                                <input class="material-inputs filled-in chk-col-red" type="checkbox" name="nota_presentacion" id="nota_presentacion">
                                <label for="nota_presentacion">Notas</label>
                            </div>                           
                            <input type="hidden" name="hidden_insumo_principal_presentacion" id="hidden_insumo_principal_presentacion"/>
                            <?php if(Session::get('opc_02') == 1) { ?>
                            <div class="col-sm-6 m-t-0">
                                <input type="checkbox" name="insumo_principal_presentacion" id="insumo_principal_presentacion" class="chk-col-green"/>
                                <label for="insumo_principal_presentacion">Insumo Princ. <i class="ti-info-alt text-warning font-10" data-original-title="¿Esta presentación contiene un insumo principal para su control de entradas y salidas?" data-toggle="tooltip" data-placement="top"></i></label>
                            </div>
                            <?php } ?>
                        </div>
                    </div>
                    <div class="col-sm-7">
                        <div class="row floating-labels">
                            <div class="col-md-12">
                                <div class="form-group m-b-40">
                                    <input class="form-control input-lg input-mayus" type="text" autocomplete="off" name="presentacion_presentacion" id="presentacion_presentacion" placeholder="Nombre" required="required"/>
                                    <span class="bar"></span>
                                </div>
                            </div>
                            <div class="col-sm-12">
                                <div class="form-group m-b-40">
                                    <textarea name="descripcion_presentacion" id="descripcion_presentacion" class="form-control"></textarea>
                                    <span class="bar"></span>
                                    <label for="descripcion_presentacion">Descripci&oacute;n de la presentaci&oacute;n <i class="ti-info-alt text-warning font-10" data-original-title="Escribe una descripción breve de la presentación" data-toggle="tooltip" data-placement="top"></i></label>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="form-group f m-b-40 letNumMayMin">
                                    <input type="text" class="form-control input-mayus cbu" name="cod_prod_presentacion" id="cod_prod_presentacion" autocomplete="off">
                                    <span class="bar"></span>
                                    <label for="cod_prod_presentacion">C&oacute;digo</label>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="form-group f m-b-40 dec">
                                    <input type="text" class="form-control cbu" name="precio_presentacion" id="precio_presentacion" autocomplete="off" required>
                                    <span class="bar"></span>
                                    <label for="precio_presentacion">Precio venta - <?php echo Session::get('moneda'); ?></label>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="form-group f m-b-40 dec">
                                    <input type="text" class="form-control cbu" name="costounitario_presentacion" id="costounitario_presentacion" autocomplete="off">
                                    <span class="bar"></span>
                                    <label for="costounitario_presentacion">Costo unitario - <?php echo Session::get('moneda'); ?> <i class="ti-info-alt text-warning font-10" data-original-title="Costo monetario por la elaboración de esta presentación / Costo receta" data-toggle="tooltip" data-placement="top"></i></label>
                                </div>
                            </div>
                            <div class="col-sm-6" id="tp-5" style="display: none">
                                <div class="form-group f m-b-40 dec">
                                    <input type="text" class="form-control cbu" name="precio_llevar" id="precio_llevar" autocomplete="off">
                                    <span class="bar"></span>
                                    <label for="precio_llevar">Precio llevar - <?php echo Session::get('moneda'); ?> <i class="ti-info-alt text-warning font-10" data-original-title="Cantidad monetaria que se vende esta presentación solo para llevar" data-toggle="tooltip" data-placement="top"></i></label>
                                </div>
                            </div>                              
                            <div class="col-sm-6" id="tp-3" style="display: none">
                                <div class="form-group f m-b-40 dec">
                                    <input type="text" class="form-control cbu" name="precio_delivery" id="precio_delivery" autocomplete="off">
                                    <span class="bar"></span>
                                    <label for="precio_delivery">Precio delivery - <?php echo Session::get('moneda'); ?> <i class="ti-info-alt text-warning font-10" data-original-title="Cantidad monetaria que se vende esta presentación solo para deliverys" data-toggle="tooltip" data-placement="top"></i></label>
                                </div>
                            </div>
                            <div class="col-sm-6" id="tp-3-1" style="display: none">
                                <div class="form-group f m-b-40 dec">
                                    <input type="text" class="form-control cbu" name="precio_delivery_app" id="precio_delivery_app" autocomplete="off">
                                    <span class="bar"></span>
                                    <label for="precio_delivery_app">Precio delivery app - <?php echo Session::get('moneda'); ?> <i class="ti-info-alt text-warning font-10" data-original-title="Cantidad monetaria que se vende esta presentación solo para deliverys" data-toggle="tooltip" data-placement="top"></i></label>
                                </div>
                            </div>                          
                            <div class="col-sm-6" id="tp-4" style="display: none">
                                <div class="form-group m-b-40 ent">
                                    <input type="text" name="stock_min_presentacion" id="stock_min_presentacion" class="form-control cbu"autocomplete="off"/>
                                    <span class="bar"></span>
                                    <label for="stock_min_presentacion">Stock m&iacute;nimo <i class="ti-info-alt text-warning font-10" data-original-title="Considere este valor para el control de stock" data-toggle="tooltip" data-placement="top"></i></label>
                                </div>
                            </div>
                            <div class="col-sm-6" id="tp-4-1" style="display: none">
                                <div class="form-group m-b-40 ent">
                                    <input type="hidden" name="hidden_stock_limit" id="hidden_stock_limit"/>
                                    <input type="checkbox" name="stock_limit" id="stock_limit" class="chk-col-green"/>
                                    <label for="stock_limit">limitar venta <i class="ti-info-alt text-warning font-10" data-original-title="¿Deseas mostrar esta presentación en tus deliverys?" data-toggle="tooltip" data-placement="top"></i></label>
                                </div>
                            </div>   
                            <div class="col-sm-6" id="tp-grupo-maximo" style="display: none">
                                <div class="form-group m-b-40 ent">
                                    <input type="text" name="grupo_limit_max" id="grupo_limit_max" value="0" class="form-control cbu"autocomplete="off"/>
                                    <span class="bar"></span>
                                    <label for="grupo_limit_max">Grupos Maximo <i class="ti-info-alt text-warning font-10" data-original-title="Considere este valor para poder seleccionar grupos al momento de la venta" data-toggle="tooltip" data-placement="top"></i></label>
                                </div>
                            </div>                    
                        </div>
                        <div id="nota_presentacion_" class="row floating-labels" style="display:none;">
                            <div class="col-sm-12" id="retornar-nota-pre">
                                <div class="form-group mb-1  remove-nota-pre">
                                    <input name="notas_presentacion[]" id="notas_presentacion" class="form-control" data-role="tagsinput" placeholder="add">
                                    <span class="bar"></span>
                                    <label for="notas_presentacion">Notas <i class="ti-info-alt text-warning font-10" data-original-title="Escribe una o varias notas, Ejm: SIN SAL, POCA SAL" data-toggle="tooltip" data-placement="top"></i></label>
                                </div>
                            </div>
                            <div class="col-sm-12">
                                <div id="notas_fieldspre" class=""></div>                          
                            </div>
                            <div class="col-sm-12 text-right">
                                <button class="btn btn-link btn-sm  m-b-40" type="button" onclick="notas_fieldspre();"><i class="fa fa-plus"></i> Agregar Grupo de notas</button>
                            </div>                               
                        </div>
                        <div id="mensaje-ins" style="margin-bottom: 10px"></div>
                        <div id="mensaje-toppings" style="margin-bottom: 10px display:none"></div>
                    </div>
                </div>
                
                <!-- Sección de Configuración de Impuesto - Fuera del contenedor de columnas -->
                <div class="row m-t-30">
                    <div class="col-sm-12">
                        <div class="card" style="border: 1px solid #e0e0e0;">
                            <div class="card-body">
                                <h5 class="card-title"><i class="ti-calculator font-18"></i> Configuración de Impuesto</h5>
                                <h6 class="card-subtitle">Configure cómo se aplicará el impuesto para esta presentación</h6>
                                
                                <input type="hidden" name="usar_impuesto_sistema" id="usar_impuesto_sistema_hidden" value="1">
                                <input type="hidden" name="impuesto_incluido_personalizado" id="impuesto_incluido_personalizado_hidden" value="0">
                                <input type="hidden" name="impuesto_valor_sistema" id="impuesto_valor_sistema" value="<?php echo $imp_val_display; ?>">
                                <input type="hidden" name="impuesto_nombre_sistema" id="impuesto_nombre_sistema" value="<?php echo Session::get('impAcr'); ?>">
                                
                                <!-- Cards para seleccionar tipo de configuración -->
                                <div class="row m-t-20">
                                    <div class="col-md-6">
                                        <div class="card card-tipo-impuesto-pres" data-value="1" style="cursor: pointer; border: 2px solid #e0e0e0; transition: all 0.3s;">
                                            <div class="card-body text-center p-20">
                                                <div class="form-check m-b-10">
                                                    <input class="form-check-input" type="radio" name="tipo_impuesto_presentacion" id="usar_sistema_radio" value="1" checked>
                                                    <label class="form-check-label" for="usar_sistema_radio" style="cursor: pointer;">
                                                        <h5 class="card-title"><i class="ti-settings text-primary font-24"></i> Usar Sistema</h5>
                                                    </label>
                                                </div>
                                                <p class="text-muted mb-0">
                                                    Se aplicará la configuración de impuesto incluido/excluido establecida en Ajustes > Sistema<br>
                                                    <small><strong>Porcentaje:</strong> <?php echo Session::get('impAcr'); ?> <?php echo $imp_val_display; ?>%</small>
                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="card card-tipo-impuesto-pres" data-value="0" style="cursor: pointer; border: 2px solid #e0e0e0; transition: all 0.3s;">
                                            <div class="card-body text-center p-20">
                                                <div class="form-check m-b-10">
                                                    <input class="form-check-input" type="radio" name="tipo_impuesto_presentacion" id="personalizar_impuesto_radio" value="0">
                                                    <label class="form-check-label" for="personalizar_impuesto_radio" style="cursor: pointer;">
                                                        <h5 class="card-title"><i class="ti-pencil-alt text-warning font-24"></i> Personalizar</h5>
                                                    </label>
                                                </div>
                                                <p class="text-muted mb-0">
                                                    Configure específicamente el impuesto para este producto<br>
                                                    <small>Puede modificar el porcentaje y si está incluido o excluido</small>
                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Opciones de personalización (solo visible si se selecciona personalizar) -->
                                <div id="opciones_personalizacion_impuesto" style="display: none;">
                                    <hr class="m-t-30 m-b-30">
                                    <h6 class="m-b-20"><i class="ti-pencil-alt"></i> Personalización de Impuesto</h6>
                                    
                                    <!-- Campo para porcentaje personalizado -->
                                    <div class="row m-b-20">
                                        <div class="col-md-6">
                                            <div class="form-group f m-b-40 dec">
                                                        <input type="text" class="form-control cbu" name="impuesto_porcentaje_personalizado" id="impuesto_porcentaje_personalizado" autocomplete="off" placeholder="<?php echo $imp_val_display; ?>">
                                                <span class="bar"></span>
                                                <label for="impuesto_porcentaje_personalizado">Porcentaje de Impuesto (%) <i class="ti-info-alt text-warning font-10" data-original-title="Ingrese el porcentaje de impuesto personalizado para esta presentación" data-toggle="tooltip" data-placement="top"></i></label>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <!-- Cards para seleccionar si está incluido o excluido -->
                                    <div class="row m-t-20">
                                        <div class="col-md-6">
                                            <div class="card card-radio-impuesto-pres" data-value="1" style="cursor: pointer; border: 2px solid #e0e0e0; transition: all 0.3s;">
                                                <div class="card-body text-center p-15">
                                                    <div class="form-check m-b-10">
                                                        <input class="form-check-input" type="radio" name="impuesto_incluido_pres" id="impuesto_incluido_pres_radio" value="1">
                                                        <label class="form-check-label" for="impuesto_incluido_pres_radio" style="cursor: pointer;">
                                                            <h6 class="card-title"><i class="ti-check-box text-success font-18"></i> Impuesto Incluido</h6>
                                                        </label>
                                                    </div>
                                                    <p class="text-muted mb-0" style="font-size: 12px;">El impuesto ya está incluido en el precio</p>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="card card-radio-impuesto-pres" data-value="0" style="cursor: pointer; border: 2px solid #e0e0e0; transition: all 0.3s;">
                                                <div class="card-body text-center p-15">
                                                    <div class="form-check m-b-10">
                                                        <input class="form-check-input" type="radio" name="impuesto_incluido_pres" id="impuesto_excluido_pres_radio" value="0" checked>
                                                        <label class="form-check-label" for="impuesto_excluido_pres_radio" style="cursor: pointer;">
                                                            <h6 class="card-title"><i class="ti-close text-danger font-18"></i> Impuesto Excluido</h6>
                                                        </label>
                                                    </div>
                                                    <p class="text-muted mb-0" style="font-size: 12px;">El impuesto se suma al precio</p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Cálculo del precio -->
                                <div class="row m-t-20">
                                    <div class="col-md-12">
                                        <div class="alert alert-info" id="calculo_precio_impuesto">
                                            <h6><i class="ti-info-alt"></i> Cálculo del Precio</h6>
                                            <div id="detalle_calculo_precio">
                                                <p class="mb-1"><strong>Precio base:</strong> <span id="precio_base_calc">0.00</span> <?php echo Session::get('moneda'); ?></p>
                                                <p class="mb-1"><strong>Impuesto (<span id="impuesto_nombre_calc"><?php echo Session::get('impAcr'); ?></span> <span id="impuesto_porcentaje_calc"><?php echo $imp_val_display; ?></span>%):</strong> <span id="impuesto_calc">0.00</span> <?php echo Session::get('moneda'); ?></p>
                                                <p class="mb-0"><strong>Precio final:</strong> <span id="precio_final_calc" style="font-size: 18px; font-weight: bold;">0.00</span> <?php echo Session::get('moneda'); ?></p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
                <button type="submit" class="btn btn-success btn-guardar">Aceptar</button>
            </div>
        </form>
        </div>
    </div>
</div>

<div class="modal long-modal" id="modal-toppings" tabindex="-1" role="dialog" aria-labelledby="longmodal" aria-hidden="true" data-backdrop="static" data-keyboard="false">
    <div class="modal-dialog modal-lg">
        <div class="modal-content animated bounceInTop">
        <form id="form-toppings" method="post" class="form-toppings">
            <div class="modal-header">
                <h4 class="modal-title">Detalle de los toppings</h4>
            </div>
            <div class="modal-body" style="background:#f1f1f1;">
                <div class="row  m-t-0">
                    <div class="col-sm-12">
                        <div class="form-group m-b-0">
                            <input type="text" name="buscar_ingrediente2" id="buscar_ingrediente2" class="form-control bg-t" autocomplete="off" placeholder="B&uacute;squeda"/>
                            
                        </div>
                    </div>
                </div>
            </div>
            <div><hr class="m-t-0 m-b-0"></div>
            <div class="modal-body list-ingredientes" style="display: none">
                <ul class="list-group">
                    <li class="list-group-item" style="background:#f1f1f1; font-size: 14px;">
                        <label>Insumo:</label> <span id="insumo2"></span> - <label>Unidad de Medida:</label> <span class="label label-warning" id="medida2"></span>
                    </li>
                    <li class="list-group-item ">
                        <div class="row" style="margin-bottom: -14px">
                            <input type="hidden" name="id_pres_receta2" id="id_pres_receta2"/>
                            <input type="hidden" name="id_ins_receta2" id="id_ins_receta2"/>
                            <input type="hidden" name="id_tipo_ins_receta2" id="id_tipo_ins_receta2"/>
                            <div class="col-sm-12">
                                <div class="form-group m-b-0">
                                    <label for="">Descripcíon</label>
                                    <input type="text" name="descripcion_toppings" id="descripcion_toppings" class="form-control" autocomplete="off" />
                                </div>
                            </div>                            
                            <div class="col-sm-2 dec">
                                <div class="form-group m-b-0">
                                    <label for="">Cantidad</label>
                                    <input type="text" name="cant_receta2" id="cant_receta2" class="form-control" style="text-align: center;" autocomplete="off" />
                                </div>
                            </div>
                            <div class="col-sm-3">
                                <div class="form-group">
                                    <label for="">Medida</label>
                                    <select name="id_med_receta2" id="id_med_receta2" class="selectpicker form-control" data-live-search="true" autocomplete="off" data-size="5">
                                    </select>
                                </div>
                            </div>
                            <div class="col-sm-3">
                                <small>Equivale a:<br><strong><span id="valor_ing2">0</span> - <span id="desc_medida2"></span></strong></small>
                            </div>
                            <div class="col-sm-2 dec">
                                <div class="form-group m-b-0">
                                    <label for="">Precio</label>
                                    <input type="text" name="precio_toppings" id="precio_toppings" class="form-control" style="text-align: center;" autocomplete="off" />
                                </div>
                            </div>                            
                            <div class="col-sm-2">
                                <div class="text-right">
                                    <button type="submit" class="btn btn-sm btn-circle btn-orange"><i class="ti-plus"></i></button>
                                    <button type="button" class="btn btn-sm btn-danger btn-eliminar"><i class="fas fa-trash"></i></button>
                                </div>
                            </div>
                        </div> 
                    </li>
                </ul>
            </div>
            <div class="list-ingredientes" style="display: none"><hr class="m-t-0 m-b-0"></div>
        </form>
            <div class="modal-body p-0">
                <div class="table-responsive scroll_receta">   
                    <table class="table stylish-table m-l-0 m-r-0" width="100%">
                        <thead class="table-head">
                            <tr>
                                <th>Tipo</th>
                                <th>Categor&iacute;a</th>
                                <th>Nombre</th>                                    
                                <th>Cantidad</th>
                                <th>Unidad Medida</th>
                                <th>Precio</th>
                                <th class="text-right">Acciones</th>
                            </tr>
                        </thead>
                        <tbody class="tb-st" id="table-toppings"></tbody>
                    </table>   
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary btn-cerrar-receta">Aceptar</button>
            </div>
        </div>
    </div>
</div>

<div class="modal long-modal" id="modal-receta" tabindex="-1" role="dialog" aria-labelledby="longmodal" aria-hidden="true" data-backdrop="static" data-keyboard="false">
    <div class="modal-dialog modal-lg">
        <div class="modal-content animated bounceInTop">
        <form id="form-receta" method="post" class="form-receta">
            <div class="modal-header">
                <h4 class="modal-title">Detalle de la receta</h4>
            </div>
            <div class="modal-body" style="background:#f1f1f1;">
                <div class="row floating-labels m-t-0">
                    <div class="col-sm-12">
                        <div class="form-group m-b-0">
                            <input type="text" name="buscar_ingrediente" id="buscar_ingrediente" class="form-control bg-t" autocomplete="off" placeholder="B&uacute;squeda"/>
                            <span class="bar"></span>
                        </div>
                    </div>
                </div>
            </div>
            <div><hr class="m-t-0 m-b-0"></div>
            <div class="modal-body list-ingredientes" style="display: none">
                <ul class="list-group">
                    <li class="list-group-item" style="background:#f1f1f1; font-size: 14px;">
                        <label>Insumo:</label> <span id="insumo"></span> - <label>Unidad de Medida:</label> <span class="label label-warning" id="medida"></span>
                    </li>
                    <li class="list-group-item floating-labels">
                        <div class="row" style="margin-bottom: -14px">
                            <input type="hidden" name="id_pres_receta" id="id_pres_receta"/>
                            <input type="hidden" name="id_ins_receta" id="id_ins_receta"/>
                            <input type="hidden" name="id_tipo_ins_receta" id="id_tipo_ins_receta"/>
                            <div class="col-sm-2 dec">
                                <div class="form-group m-b-0">
                                    <input type="text" name="cant_receta" id="cant_receta" class="form-control" style="text-align: center;" autocomplete="off" />
                                    <span class="bar"></span>
                                </div>
                            </div>
                            <div class="col-sm-3">
                                <div class="form-group">
                                    <select name="id_med_receta" id="id_med_receta" class="selectpicker form-control" data-live-search="true" autocomplete="off" data-size="5">
                                    </select>
                                </div>
                            </div>
                            <div class="col-sm-4">
                                <small>Equivale a:<br><strong><span id="valor_ing">0</span> - <span id="desc_medida"></span></strong></small>
                            </div>
                            <div class="col-sm-3">
                                <div class="text-right">
                                    <button type="submit" class="btn btn-sm btn-circle btn-orange"><i class="ti-plus"></i></button>
                                    <button type="button" class="btn btn-sm btn-danger btn-eliminar"><i class="fas fa-trash"></i></button>
                                </div>
                            </div>
                        </div> 
                    </li>
                </ul>
            </div>
            <div class="list-ingredientes" style="display: none"><hr class="m-t-0 m-b-0"></div>
        </form>
            <div class="modal-body p-0">
                <div class="table-responsive scroll_receta">   
                    <table class="table stylish-table m-l-0 m-r-0" width="100%">
                        <thead class="table-head">
                            <tr>
                                <th>Tipo</th>
                                <th>Categor&iacute;a</th>
                                <th>Nombre</th>                                    
                                <th>Cantidad</th>
                                <th>Unidad Medida</th>
                                <th class="text-right">Acciones</th>
                            </tr>
                        </thead>
                        <tbody class="tb-st" id="table-receta"></tbody>
                    </table>   
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary btn-cerrar-receta">Aceptar</button>
            </div>
        </div>
    </div>
</div>

<!-- Modal Exportar a Excel -->
<div class="modal inmodal" id="modal-exportar-producto" tabindex="-1" role="dialog" aria-hidden="true" data-backdrop="static" data-keyboard="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content animated bounceInTop">
            <div class="modal-header">
                <h4 class="modal-title"><i class="mdi mdi-file-excel-box text-success"></i> Exportar reporte</h4>
                <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Cerrar</span></button>
            </div>
            <div class="modal-body">
                <p class="text-muted mb-3">Selecciona qué categorías incluir en el reporte Excel:</p>
                <form id="form-exportar-producto">
                    <div class="form-group mb-0">
                        <div class="custom-control custom-checkbox mb-2">
                            <input type="checkbox" class="custom-control-input" id="exp_productos_servicios" name="exportar[]" value="productos_servicios" checked>
                            <label class="custom-control-label" for="exp_productos_servicios">Productos y Servicios</label>
                        </div>
                        <div class="custom-control custom-checkbox mb-2">
                            <input type="checkbox" class="custom-control-input" id="exp_combos" name="exportar[]" value="combos">
                            <label class="custom-control-label" for="exp_combos">Combos</label>
                        </div>
                        <div class="custom-control custom-checkbox mb-2">
                            <input type="checkbox" class="custom-control-input" id="exp_insumos" name="exportar[]" value="insumos">
                            <label class="custom-control-label" for="exp_insumos">Insumos</label>
                        </div>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
                <button type="button" class="btn btn-success" id="btn-exportar-excel-producto"><i class="mdi mdi-file-excel-box"></i> Exportar a Excel</button>
            </div>
        </div>
    </div>
</div>

<!-- modal import -->

<div class="modal inmodal" id="modal-import" tabindex="-1" role="dialog" aria-hidden="true" data-backdrop="static" data-keyboard="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content animated bounceInTop">
        <form id="form-import" method="post" enctype="multipart/form-data">
        <input type="hidden" name="id_prod_producto" id="id_prod_producto">
            <div class="modal-header">
                <h4 class="modal-title">IMPORTAR PRODUCTOS</h4>
                <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span class="sr-only">Cerrar</span></button>
            </div>
            <div class="modal-body">
                <div class="row floating-labels">
                    <div class="col-md-12">
                        <span class="ont-12">
                            Desde aquí puedes importar nuevos productos:
                        </span>
                    </div>                    
                </div>
                <div class="row mt-3">
                    <div class="col-md-12">
                        <div id="yourBtn" onclick="getFile()">Seleccione un archivo (xlsx)</div>
                        <div style='height: 0px;width: 0px; overflow:hidden;'>
                        <!-- type="file" name="name"  id="name" -->
                            <input id="upfile" type="file" value="upload" onchange="sub(this) " accept=".xls,.xlsx" />
                        </div>
                    </div>
                </div>
                <div class="row mt-3">
                    <div class="col-12">
                    <a class="text-muted font-12 mr-auto" href="<?php echo URL; ?>/ajuste/descargar_plantilla_productos">Descargar formato de ejemplo para importar</a>

                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
                <button type="submit" class="btn btn-success btn-guardar">Aceptar</button>
            </div>
        </form>
        </div>
    </div>
</div>

<!--fin -->

<style>
    #yourBtn {
  position: relative;
  /* top: 150px; */
  font-family: calibri;
  /* width: 150px; */
  padding: 10px;
  -webkit-border-radius: 5px;
  -moz-border-radius: 5px;
  border: 1px dashed #BBB;
  text-align: center;
  /* background-color: #DDD; */
  cursor: pointer;
}
</style>

<script type="text/javascript">

function getFile() {
  document.getElementById("upfile").click();
}

function sub(obj) {
  var file = obj.value;
  var fileName = file.split("\\");
  document.getElementById("yourBtn").innerHTML = fileName[fileName.length - 1];
  document.myForm.submit();
  event.preventDefault();
}


$(function() {
    $('#config').addClass("active");
    function filterGlobal () {
    $('#table-productos').DataTable().search( 
        $('#global_filter').val()
    ).draw();
    }
    $('input.global_filter').on( 'keyup click', function () {
        filterGlobal();
    } );

    // Exportar a Excel: validar al menos una categoría y enviar formulario para descarga
    $('#btn-exportar-excel-producto').on('click', function() {
        var checked = $('#form-exportar-producto').find('input[name="exportar[]"]:checked');
        if (!checked.length) {
            alert('Selecciona al menos una categoría para exportar.');
            return;
        }
        var form = $('<form>').attr({ method: 'POST', action: $('#url').val() + 'ajuste/exportarProductosExcel', target: '_blank' });
        checked.each(function() {
            form.append($('<input>').attr({ type: 'hidden', name: 'exportar[]', value: $(this).val() }));
        });
        $('body').append(form);
        form.submit();
        form.remove();
        $('#modal-exportar-producto').modal('hide');
    });
});


</script>

</script>
