<?php
require 'config.php';

try {
    $db = new PDO('mysql:host='.DB_HOST.';dbname='.DB_NAME.';charset='.DB_CHARSET, DB_USER, DB_PASS);
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    // Buscar documento A001-0000000004
    $serie = 'A001';
    $numero = 4; // 0000000004 = 4
    
    echo "=== VERIFICACIÓN DE DOCUMENTO FE ===\n";
    echo "Serie: $serie\n";
    echo "Número: $numero\n\n";
    
    // Buscar documento
    $sql_doc = "SELECT d.*, s.serie as serie_electronica 
                FROM tm_facturacion_electronica_documentos d
                LEFT JOIN tm_series_documentos s ON d.id_serie_documento = s.id_serie
                WHERE s.serie = ? AND d.fd_number = ?";
    $stm_doc = $db->prepare($sql_doc);
    $stm_doc->execute(array($serie, $numero));
    $doc = $stm_doc->fetch(PDO::FETCH_ASSOC);
    
    if (!$doc) {
        echo "ERROR: Documento no encontrado\n";
        exit;
    }
    
    echo "=== DATOS DEL DOCUMENTO ===\n";
    echo "ID: " . $doc['id_documento_fe'] . "\n";
    echo "Total documento: " . $doc['total'] . "\n";
    echo "Serie: " . $doc['serie_electronica'] . "\n";
    echo "Número: " . $doc['fd_number'] . "\n\n";
    
    // Obtener items
    $sql_items = "SELECT * FROM tm_facturacion_electronica_items 
                  WHERE id_documento_fe = ? 
                  ORDER BY line";
    $stm_items = $db->prepare($sql_items);
    $stm_items->execute(array($doc['id_documento_fe']));
    $items = $stm_items->fetchAll(PDO::FETCH_ASSOC);
    
    echo "=== ITEMS DEL DOCUMENTO ===\n";
    $total_calculado = 0;
    $total_calculado_detallado = 0;
    
    foreach ($items as $item) {
        $precio = floatval($item['price']);
        $cantidad = floatval($item['quantity']);
        $descuento = floatval($item['discount']);
        $subtotal_bd = floatval($item['subtotal']);
        $impuestos_bd = floatval($item['total_taxes']);
        $total_item_bd = floatval($item['total_item']);
        
        // Calcular manualmente
        $subtotal_calc = ($precio * $cantidad) - $descuento;
        $total_item_calc = $subtotal_calc + $impuestos_bd;
        
        $total_calculado += $total_item_calc;
        $total_calculado_detallado += $total_item_bd;
        
        echo "\n--- Item Línea " . $item['line'] . " ---\n";
        echo "Descripción: " . $item['description'] . "\n";
        echo "Precio: $precio\n";
        echo "Cantidad: $cantidad\n";
        echo "Descuento: $descuento\n";
        echo "Subtotal (BD): $subtotal_bd\n";
        echo "Subtotal (Calculado): $subtotal_calc\n";
        echo "Impuestos (BD): $impuestos_bd\n";
        echo "Total item (BD): $total_item_bd\n";
        echo "Total item (Calculado): $total_item_calc\n";
        
        // Verificar diferencias
        if (abs($subtotal_bd - $subtotal_calc) > 0.01) {
            echo "⚠️ ERROR: Subtotal no coincide! Diferencia: " . abs($subtotal_bd - $subtotal_calc) . "\n";
        }
        if (abs($total_item_bd - $total_item_calc) > 0.01) {
            echo "⚠️ ERROR: Total item no coincide! Diferencia: " . abs($total_item_bd - $total_item_calc) . "\n";
        }
        
        // Obtener impuestos del item
        $sql_taxes = "SELECT * FROM tm_facturacion_electronica_item_taxes WHERE id_item_fe = ?";
        $stm_taxes = $db->prepare($sql_taxes);
        $stm_taxes->execute(array($item['id_item_fe']));
        $taxes = $stm_taxes->fetchAll(PDO::FETCH_ASSOC);
        
        echo "Impuestos detallados:\n";
        $suma_impuestos = 0;
        foreach ($taxes as $tax) {
            $amount = floatval($tax['amount']);
            $suma_impuestos += $amount;
            echo "  - Tipo: " . $tax['type'] . ", Código: " . $tax['code'] . ", Monto: $amount\n";
        }
        echo "Suma impuestos: $suma_impuestos\n";
        if (abs($impuestos_bd - $suma_impuestos) > 0.01) {
            echo "⚠️ ERROR: Impuestos no coinciden! Diferencia: " . abs($impuestos_bd - $suma_impuestos) . "\n";
        }
    }
    
    echo "\n=== RESUMEN DE TOTALES ===\n";
    echo "Total documento (BD): " . $doc['total'] . "\n";
    echo "Total items calculado (suma manual): " . number_format($total_calculado, 2, '.', '') . "\n";
    echo "Total items (suma de total_item BD): " . number_format($total_calculado_detallado, 2, '.', '') . "\n";
    
    $diferencia1 = abs(floatval($doc['total']) - $total_calculado);
    $diferencia2 = abs(floatval($doc['total']) - $total_calculado_detallado);
    
    echo "\nDiferencia con total documento (cálculo manual): " . number_format($diferencia1, 2, '.', '') . "\n";
    echo "Diferencia con total documento (suma BD): " . number_format($diferencia2, 2, '.', '') . "\n";
    
    if ($diferencia1 > 0.01 || $diferencia2 > 0.01) {
        echo "\n⚠️ ADVERTENCIA: Hay diferencias significativas!\n";
    } else {
        echo "\n✅ Los totales coinciden correctamente\n";
    }
    
} catch (Exception $e) {
    echo "ERROR: " . $e->getMessage() . "\n";
    echo $e->getTraceAsString();
}

