<?php
/**
 * Script de prueba para consultar orden y verificar divisiones e items
 * Uso: http://localhost/test_orden_dividida.php?id_pedido=8802
 */
error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once __DIR__ . '/config.php';
require_once __DIR__ . '/libs/Database.php';
require_once __DIR__ . '/libs/Session.php';

session_start();
Session::init();

$id_pedido = isset($_GET['id_pedido']) ? intval($_GET['id_pedido']) : 0;

if ($id_pedido <= 0) {
    die("Error: Proporcione id_pedido. Ejemplo: test_orden_dividida.php?id_pedido=8802");
}

echo "<h2>Análisis de Orden Dividida - ID Pedido: $id_pedido</h2>";

try {
    $db = new Database(DB_TYPE, DB_HOST, DB_NAME, DB_USER, DB_PASS, DB_CHARSET);
    
    // 1. Verificar si tiene precuentas divididas en tm_detalle_pedido
    echo "<h3>1. Items en tm_detalle_pedido agrupados por nombre_precuenta:</h3>";
    $stm_items = $db->prepare("SELECT nombre_precuenta, id_pres, SUM(cantidad) AS cantidad, precio, toppings 
        FROM tm_detalle_pedido 
        WHERE id_pedido = ? AND estado <> 'z' 
        GROUP BY nombre_precuenta, id_pres, precio, CASE WHEN toppings IS NOT NULL THEN toppings ELSE '' END
        ORDER BY nombre_precuenta, id_pres");
    $stm_items->execute(array($id_pedido));
    $items_pedido = $stm_items->fetchAll(PDO::FETCH_OBJ);
    
    $by_precuenta = array();
    foreach ($items_pedido as $item) {
        $prec = $item->nombre_precuenta ? $item->nombre_precuenta : '__SIN_ASIGNAR__';
        if (!isset($by_precuenta[$prec])) {
            $by_precuenta[$prec] = array();
        }
        $by_precuenta[$prec][] = $item;
    }
    
    echo "<p><strong>Total divisiones (precuentas):</strong> " . count($by_precuenta) . "</p>";
    
    foreach ($by_precuenta as $nombre_prec => $items) {
        echo "<h4>Precuenta: " . htmlspecialchars($nombre_prec) . " (" . count($items) . " items)</h4>";
        echo "<table border='1' cellpadding='5' style='border-collapse: collapse; margin-bottom: 20px;'>";
        echo "<tr><th>ID Pres</th><th>Cantidad</th><th>Precio</th><th>Toppings</th></tr>";
        foreach ($items as $item) {
            echo "<tr>";
            echo "<td>" . $item->id_pres . "</td>";
            echo "<td>" . $item->cantidad . "</td>";
            echo "<td>" . $item->precio . "</td>";
            echo "<td>" . htmlspecialchars($item->toppings ?: '') . "</td>";
            echo "</tr>";
        }
        echo "</table>";
    }
    
    // 2. Verificar precuentas en tm_pedido_precuenta_facturacion
    echo "<h3>2. Precuentas en tm_pedido_precuenta_facturacion:</h3>";
    $stm_prec = $db->prepare("SELECT * FROM tm_pedido_precuenta_facturacion WHERE id_pedido = ? ORDER BY nombre_precuenta");
    $stm_prec->execute(array($id_pedido));
    $precuentas = $stm_prec->fetchAll(PDO::FETCH_OBJ);
    
    echo "<p><strong>Total precuentas configuradas:</strong> " . count($precuentas) . "</p>";
    
    foreach ($precuentas as $prec) {
        echo "<h4>Precuenta: " . htmlspecialchars($prec->nombre_precuenta) . "</h4>";
        echo "<ul>";
        echo "<li><strong>ID Cliente:</strong> " . $prec->id_cliente . "</li>";
        echo "<li><strong>ID Tipo Doc:</strong> " . $prec->id_tipo_doc . "</li>";
        echo "<li><strong>ID Venta:</strong> " . ($prec->id_venta ?: 'NO CREADA') . "</li>";
        echo "<li><strong>Correlativo:</strong> " . ($prec->correlativo ?: 'NO ASIGNADO') . "</li>";
        echo "<li><strong>IDs Items (JSON):</strong> " . htmlspecialchars($prec->ids_items ?: '[]') . "</li>";
        echo "<li><strong>Descuentos Items (JSON):</strong> " . htmlspecialchars($prec->descuentos_items ?: '{}') . "</li>";
        echo "</ul>";
        
        // Si tiene id_venta, verificar items en tm_detalle_venta
        if ($prec->id_venta) {
            echo "<h5>Items en tm_detalle_venta para id_venta=" . $prec->id_venta . ":</h5>";
            $stm_det_venta = $db->prepare("SELECT id_prod, cantidad, precio, toppings FROM tm_detalle_venta WHERE id_venta = ?");
            $stm_det_venta->execute(array($prec->id_venta));
            $items_venta = $stm_det_venta->fetchAll(PDO::FETCH_OBJ);
            
            echo "<p><strong>Total items en venta:</strong> " . count($items_venta) . "</p>";
            if (count($items_venta) > 0) {
                echo "<table border='1' cellpadding='5' style='border-collapse: collapse;'>";
                echo "<tr><th>ID Prod</th><th>Cantidad</th><th>Precio</th><th>Toppings</th></tr>";
                foreach ($items_venta as $item) {
                    echo "<tr>";
                    echo "<td>" . $item->id_prod . "</td>";
                    echo "<td>" . $item->cantidad . "</td>";
                    echo "<td>" . $item->precio . "</td>";
                    echo "<td>" . htmlspecialchars($item->toppings ?: '') . "</td>";
                    echo "</tr>";
                }
                echo "</table>";
            }
            
            // Generar PDF de prueba
            echo "<p><a href='" . URL . "informe/venta_all_imp/" . $prec->id_venta . "' target='_blank' style='background: #007bff; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px; display: inline-block; margin-top: 10px;'>Generar PDF para esta precuenta</a></p>";
        }
    }
    
    // 3. Resumen
    echo "<h3>3. Resumen:</h3>";
    echo "<ul>";
    echo "<li><strong>Divisiones en tm_detalle_pedido:</strong> " . count($by_precuenta) . "</li>";
    echo "<li><strong>Precuentas configuradas:</strong> " . count($precuentas) . "</li>";
    $ventas_creadas = 0;
    foreach ($precuentas as $p) {
        if ($p->id_venta) $ventas_creadas++;
    }
    echo "<li><strong>Ventas creadas:</strong> " . $ventas_creadas . "</li>";
    echo "</ul>";
    
    // 4. Enlaces de prueba
    echo "<h3>4. Enlaces de Prueba:</h3>";
    echo "<ul>";
    echo "<li><a href='" . URL . "venta/orden/" . $id_pedido . "' target='_blank'>Ver orden completa</a></li>";
    foreach ($precuentas as $prec) {
        if ($prec->id_venta) {
            echo "<li><a href='" . URL . "test_pdf_dividida.php?id_venta=" . $prec->id_venta . "' target='_blank'>Test PDF Precuenta: " . htmlspecialchars($prec->nombre_precuenta) . " (ID Venta: " . $prec->id_venta . ")</a></li>";
        }
    }
    echo "</ul>";
    
} catch (Exception $e) {
    echo "<p style='color:red;'><strong>ERROR:</strong> " . $e->getMessage() . "</p>";
    echo "<pre>" . $e->getTraceAsString() . "</pre>";
}
