<?php Session::init(); ?>
<?php

class Informe_Model extends Model
{
    public function __construct()
    {
        parent::__construct();
    }

    public function TipoPedido()
    {
        try
        {      
            return $this->db->selectAll('SELECT * FROM tm_tipo_pedido');
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function Configuracion()
    {
        try
        {    
            // return $this->db->selectAll('SELECT * FROM tm_tipo_pedido');
            $stm = $this->db->prepare("SELECT * FROM tm_configuracion");
            $stm->execute();
            $c = $stm->fetch(PDO::FETCH_OBJ);
            return $c;
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }
    public function StateType($id = '%')
    {
        try
        {  
            if ($id == '%') {
                return $this->db->selectAll('SELECT * FROM `tm_state_type` WHERE id LIKE "'.$id.'"');
            } else {
                return $this->db->selectOne('SELECT * FROM `tm_state_type` WHERE id LIKE "'.$id.'"');
            }            
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }
    public function zonas_mesas()
    {
        try
        {      
            return $this->db->selectAll('SELECT * FROM `tm_salon` where estado = "a"');
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function zonas_mesas2($data)
    {
        try
        {
            $stm = $this->db->prepare("SELECT * FROM tm_mesa WHERE estado = 'a' and id_salon = ?");
            $stm->execute(array($data['cod']));
            $c = $stm->fetchAll(PDO::FETCH_OBJ);
            return $c;
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function Caja()
    {
        try
        {      
            return $this->db->selectAll('SELECT * FROM tm_caja');
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function Cliente()
    {
        try
        {      
            return $this->db->selectAll('SELECT id_cliente,nombre FROM v_clientes');
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function Categoria()
    {
        try
        {      
            return $this->db->selectAll('SELECT * FROM tm_producto_catg');
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function Producto()
    {
        try
        {      
            return $this->db->selectAll('SELECT * FROM tm_producto');
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function Presentacion()
    {
        try
        {      
            return $this->db->selectAll('SELECT * FROM tm_producto_pres');
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function Mozo()
    {
        try
        {      
            return $this->db->selectAll("SELECT id_usu,CONCAT(nombres,' ',ape_paterno,' ',ape_materno) AS nombre FROM v_usuarios WHERE id_rol = 5");
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function Proveedor()
    {
        try
        {      
            return $this->db->selectAll("SELECT * FROM tm_proveedor");
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function Cajero()
    {
        try
        {    
            return $this->db->selectAll("SELECT id_usu,ape_paterno,ape_materno,nombres FROM tm_usuario WHERE (id_rol = 1 OR id_rol = 2 OR id_rol = 3) AND id_usu <> 1 AND estado = 'a'");
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function Personal()
    {
        try
        {    
            return $this->db->selectAll("SELECT * FROM tm_usuario WHERE id_usu <> 1 AND estado = 'a' GROUP BY dni");
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function Repartidor()
    {
        try
        {    
            return $this->db->selectAll("SELECT * FROM tm_usuario WHERE id_rol = 6");
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function RepartidorGeneral()
    {
        try
        {   
            return $this->db->selectAll('SELECT * FROM tm_repartidor WHERE estado = "a"');
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function RepartidorApp()
    {
        try
        {   
            return $this->db->selectAll('SELECT * FROM tm_repartidor WHERE id_repartidor <> 1 AND id_repartidor <> 9999');
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    } 


    public function TipoDocumento()
    {
        try
        {   
            return $this->db->selectAll('SELECT * FROM tm_tipo_doc WHERE estado = "a"');
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function TipoPago()
    {
        try
        {   
            return $this->db->selectAll('SELECT * FROM tm_tipo_pago WHERE estado = "a"');
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function Empresa()
    {
        try
        {      
            return $this->db->selectOne("SELECT * FROM tm_empresa");
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    /* INICIO VENTAS */

    public function venta_all_list()
    {
        try
        {   

            if (Session::get('report_date') == '0') {
                $ifecha = date('Y-m-d',strtotime($_POST['ifecha']));
                $ffecha = date('Y-m-d',strtotime($_POST['ffecha']));
                $fechas = '(DATE(v.fec_ven) >= ? AND DATE(v.fec_ven) <= ?)';
            } else {
                $ifecha = date('Y-m-d H:i:s',strtotime($_POST['ifecha']));
                $ffecha = date('Y-m-d H:i:s',strtotime($_POST['ffecha']));
                $fechas = '(v.fec_ven >= ? AND v.fec_ven <= ?)';
            }

            $joinQuery = "";
            $joinCondition = "";
            $joinParameters = [];
            
            if ($_POST['id_salon'] !='%') {
                $joinQuery = "INNER JOIN tm_pedido_mesa AS pm ON pm.id_pedido = v.id_ped
                              INNER JOIN v_mesas AS vm ON pm.id_mesa = vm.id_mesa ";
                $joinCondition = "AND vm.id_salon = ?";
                $joinParameters[] = $_POST['id_salon'];
            }
            
            $stm = $this->db->prepare("SELECT v.id_ven,v.id_ped,v.id_tped,v.desc_monto,v.total AS stotal, v.fec_ven,v.desc_td,v.ser_doc,v.nro_doc,v.estado, v.state_type_id,
                        CASE WHEN v.state_type_id != '11' THEN v.comis_tar ELSE 0 END AS comis_tar,
                        CASE WHEN v.state_type_id != '11' THEN v.comis_rc ELSE 0 END AS comis_rc,
                        CASE WHEN v.state_type_id != '11' THEN v.comis_del ELSE 0 END AS comis_del,
                        CASE WHEN v.state_type_id != '11' THEN IF((v.desc_tipo = 1),0,v.total+v.comis_del+v.comis_tar) ELSE 0 END monto_total,
                        CASE WHEN v.state_type_id != '11' THEN IF((v.desc_tipo = 1),0,v.total) ELSE 0 END total, 
                        v.id_cli,v.igv,v.id_usu,v.desc_tipo,v.desc_personal,c.desc_caja, c.id_apc, v.motivo_anulacion 
                        FROM v_ventas_con AS v 
                        INNER JOIN v_caja_aper AS c ON v.id_apc = c.id_apc "
                        . $joinQuery .
                        "WHERE ".$fechas." AND v.id_tped LIKE ? 
                        AND v.id_tdoc LIKE ? 
                        AND v.id_cli LIKE ? 
                        AND v.state_type_id LIKE ? "
                        . $joinCondition .
                        "GROUP BY v.id_ven");
            
            $parameters = array($ifecha, $ffecha, $_POST['tped'], $_POST['tdoc'], $_POST['cliente'], $_POST['estado']);
            $parameters = array_merge($parameters, $joinParameters);
            
            $stm->execute($parameters);
            

            // $stm = $this->db->prepare("SELECT v.id_ven,v.id_ped,v.id_tped,v.desc_monto,v.total AS stotal, v.fec_ven,v.desc_td,v.ser_doc,v.nro_doc,v.estado, v.state_type_id,
            // CASE WHEN v.state_type_id != '11' THEN v.comis_tar ELSE 0 END AS comis_tar,
            // CASE WHEN v.state_type_id != '11' THEN v.comis_rc ELSE 0 END AS comis_rc,
            // CASE WHEN v.state_type_id != '11' THEN v.comis_del ELSE 0 END AS comis_del,
            // CASE WHEN v.state_type_id != '11' THEN IF((v.desc_tipo = 1),0,v.total+v.comis_del+v.comis_tar) ELSE 0 END monto_total,
            // CASE WHEN v.state_type_id != '11' THEN IF((v.desc_tipo = 1),0,v.total) ELSE 0 END total, 
            // v.id_cli,v.igv,v.id_usu,v.desc_tipo,v.desc_personal,c.desc_caja, c.id_apc, v.motivo_anulacion FROM v_ventas_con AS v INNER JOIN v_caja_aper AS c ON v.id_apc = c.id_apc WHERE (DATE(v.fec_ven) >= ? AND DATE(v.fec_ven) <= ?) AND v.id_tped like ? AND v.id_tdoc like ? AND v.id_cli like ? AND v.state_type_id like ? GROUP BY v.id_ven");

            // $stm->execute(array($ifecha,$ffecha,$_POST['tped'],$_POST['tdoc'],$_POST['cliente'],$_POST['estado']));
            $c = $stm->fetchAll(PDO::FETCH_OBJ);
                       
            foreach($c as $k => $d)
            {
                $c[$k]->{'Pedido'} = $this->db->query("SELECT vm.desc_salon, vm.nro_mesa FROM tm_pedido_mesa AS pm INNER JOIN v_mesas AS vm ON pm.id_mesa = vm.id_mesa WHERE pm.id_pedido = ".$d->id_ped)
                    ->fetch(PDO::FETCH_OBJ);

                $c[$k]->{'Cliente'} = $this->db->query("SELECT tipo_cliente, dni, ruc, nombre FROM v_clientes WHERE id_cliente = ".$d->id_cli)
                    ->fetch(PDO::FETCH_OBJ);

                $c[$k]->{'Personal'} = $this->db->query("SELECT CONCAT(nombres,' ',ape_paterno,' ',ape_materno) AS nombres FROM tm_usuario WHERE id_usu = ".$d->desc_personal)
                    ->fetch(PDO::FETCH_OBJ);

                $c[$k]->{'Tipopago'} = $this->db->query("SELECT tp.descripcion as nombre, tp.color AS color FROM tm_venta_pago AS vp INNER JOIN tm_venta AS v ON v.id_venta = vp.id_venta INNER JOIN tm_tipo_pago AS tp ON vp.id_pago = tp.id_tipo_pago WHERE vp.monto > 0 AND vp.id_venta = ".$d->id_ven)->fetchAll(PDO::FETCH_OBJ);  

                $c[$k]->{'State'} = $this->StateType($d->state_type_id);

            }
            $data = array("data" => $c);
            $json = json_encode($data);
            echo $json;       
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function venta_all_det($data)
    {
        try
        {
            $config->{'Configuracion'} = $this->db->query("SELECT * FROM tm_configuracion")->fetch(PDO::FETCH_OBJ);
            
            if ($config->{'Configuracion'}->activated_pres == '1'){
                $stm = $this->db->prepare("SELECT id_prod,SUM(cantidad) AS cantidad,precio FROM tm_detalle_venta WHERE id_venta = ? GROUP BY id_prod, precio");
                $stm->execute(array($data['id_venta']));
                $c = $stm->fetchAll(PDO::FETCH_OBJ);
                foreach($c as $k => $d)
                {
                    $c[$k]->{'Comision'} = $this->db->query("SELECT comision_delivery AS total FROM tm_venta WHERE id_venta = ".$data['id_venta'])
                        ->fetch(PDO::FETCH_OBJ);
               
                    $c[$k]->{'Descuento'} = $this->db->query("SELECT descuento_monto AS total FROM tm_venta WHERE id_venta = ".$data['id_venta'])
                        ->fetch(PDO::FETCH_OBJ);
            
                    $c[$k]->{'Producto'} = $this->db->query("SELECT pro_cat, pro_pre AS nom_pro_pre FROM v_productos WHERE id_pres = ".$d->id_prod)
                        ->fetch(PDO::FETCH_OBJ);
                }                
            }else{
                $stm = $this->db->prepare("SELECT id_prod,SUM(cantidad) AS cantidad,precio FROM tm_detalle_venta WHERE id_venta = ? GROUP BY id_prod, precio");
                $stm->execute(array($data['id_venta']));
                $c = $stm->fetchAll(PDO::FETCH_OBJ);
                foreach($c as $k => $d)
                {
                    $c[$k]->{'Comision'} = $this->db->query("SELECT comision_delivery AS total FROM tm_venta WHERE id_venta = ".$data['id_venta'])
                        ->fetch(PDO::FETCH_OBJ);
               
                    $c[$k]->{'Descuento'} = $this->db->query("SELECT descuento_monto AS total FROM tm_venta WHERE id_venta = ".$data['id_venta'])
                        ->fetch(PDO::FETCH_OBJ);
            
                    $c[$k]->{'Producto'} = $this->db->query("SELECT pro_cat, CONCAT(pro_nom, ' ' , pro_pre) AS nom_pro_pre FROM v_productos WHERE id_pres = ".$d->id_prod)
                        ->fetch(PDO::FETCH_OBJ);
                }                
            }

            return $c;
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function venta_delivery_list()
    {
        try
        {
            if (Session::get('report_date') == '0') {
                $ifecha = date('Y-m-d',strtotime($_POST['ifecha']));
                $ffecha = date('Y-m-d',strtotime($_POST['ffecha']));
                $fechas = '(DATE(v.fec_ven) >= ? AND DATE(v.fec_ven) <= ?)';
            } else {
                $ifecha = date('Y-m-d H:i:s',strtotime($_POST['ifecha']));
                $ffecha = date('Y-m-d H:i:s',strtotime($_POST['ffecha']));
                $fechas = '(v.fec_ven >= ? AND v.fec_ven <= ?)';
            }

            $stm = $this->db->prepare("SELECT v.id_ven,v.id_ped,v.id_cli,v.id_apc,v.desc_td,v.ser_doc,v.nro_doc, v.state_type_id, d.telefono_cliente,
            CASE WHEN v.state_type_id != '11' THEN IFNULL((v.comis_tar),0) ELSE 0 END AS comis_tar,
            CASE WHEN v.state_type_id != '11' THEN IFNULL((v.total),0) ELSE 0 END AS total,
            CASE WHEN v.state_type_id != '11' THEN IFNULL((v.total+v.comis_del+v.comis_tar),0) ELSE 0 END AS monto_total,
            CASE WHEN v.state_type_id != '11' THEN IFNULL((v.comis_del),0) ELSE 0 END AS comis_del,v.fec_ven,d.tipo_entrega,d.id_repartidor,d.desc_repartidor,v.estado FROM v_ventas_con AS v INNER JOIN v_pedido_delivery AS d ON v.id_ped = d.id_pedido WHERE ".$fechas." AND d.id_repartidor LIKE ? AND d.tipo_entrega LIKE ? AND v.state_type_id LIKE ? AND v.id_tped = 3");
            
            $stm->execute(array($ifecha,$ffecha,$_POST['id_repartidor'],$_POST['tipo_entrega'],$_POST['estado']));
            $c = $stm->fetchAll(PDO::FETCH_OBJ);

            foreach($c as $k => $d)
            {
                $c[$k]->{'Cliente'} = $this->db->query("SELECT nombre FROM v_clientes WHERE id_cliente = ".$d->id_cli)
                    ->fetch(PDO::FETCH_OBJ);

                $c[$k]->{'Caja'} = $this->db->query("SELECT desc_caja FROM v_caja_aper WHERE id_apc = ".$d->id_apc)
                    ->fetch(PDO::FETCH_OBJ);
                $c[$k]->{'State'} = $this->StateType($d->state_type_id); 
            }
            $data = array("data" => $c);
            $json = json_encode($data);
            echo $json;       
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function venta_deliveryapp_list()
    {
        try
        {
            $ifecha = date('Y-m-d',strtotime($_POST['ifecha']));
            $ffecha = date('Y-m-d',strtotime($_POST['ffecha']));
            $stm = $this->db->prepare("SELECT v.id_ven,v.id_ped,v.id_cli,v.id_apc,v.desc_td,v.ser_doc,v.nro_doc,IFNULL((v.total),0) AS total,v.comis_del, v.fec_ven,d.id_repartidor,d.desc_repartidor, TRUNCATE(IFNULL((v.total*(r.comision/100)),0),2) AS comision_app FROM v_ventas_con AS v INNER JOIN v_pedido_delivery AS d ON v.id_ped = d.id_pedido INNER JOIN tm_repartidor AS r ON d.id_repartidor = r.id_repartidor WHERE (DATE(v.fec_ven) >= ? AND DATE(v.fec_ven) <= ?) AND d.id_repartidor LIKE ? AND d.tipo_entrega LIKE '%' AND v.id_tped = 3");
            
            $stm->execute(array($ifecha,$ffecha,$_POST['id_repartidor']));
            $c = $stm->fetchAll(PDO::FETCH_OBJ);           
            foreach($c as $k => $d)
            {
                $c[$k]->{'Cliente'} = $this->db->query("SELECT nombre FROM v_clientes WHERE id_cliente = ".$d->id_cli)
                    ->fetch(PDO::FETCH_OBJ);

                $c[$k]->{'Caja'} = $this->db->query("SELECT desc_caja FROM v_caja_aper WHERE id_apc = ".$d->id_apc)
                    ->fetch(PDO::FETCH_OBJ);
            }
            $data = array("data" => $c);
            $json = json_encode($data);
            echo $json;       
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function venta_culqi_list()
    {
        try
        {
            $ifecha = date('Y-m-d',strtotime($_POST['ifecha']));
            $ffecha = date('Y-m-d',strtotime($_POST['ffecha']));
            $stm = $this->db->prepare("SELECT v.desc_td,v.ser_doc,v.nro_doc,v.total,v.igv,d.tipo_entrega,d.nombre_cliente,d.email_cliente,d.fecha_pedido FROM v_ventas_con AS v INNER JOIN v_pedido_delivery AS d ON v.id_ped = d.id_pedido WHERE d.tipo_pago = 4 AND (DATE(v.fec_ven) >= ? AND DATE(v.fec_ven) <= ?) AND d.tipo_entrega LIKE ?");
            $stm->execute(array($ifecha,$ffecha,$_POST['tipo_entrega']));
            $c = $stm->fetchAll(PDO::FETCH_OBJ);
            $data = array("data" => $c);
            $json = json_encode($data);
            echo $json;       
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function venta_prod_list($data)
    {
        try
        {
            if (Session::get('report_date') == '0') {
                $ifecha = date('Y-m-d',strtotime($data['ifecha']));
                $ffecha = date('Y-m-d',strtotime($data['ffecha']));
                $fechas = '(DATE(v.fecha_venta) >= ? AND DATE(v.fecha_venta) <= ?)';
            } else {
                $ifecha = date('Y-m-d H:i:s',strtotime($data['ifecha']));
                $ffecha = date('Y-m-d H:i:s',strtotime($data['ffecha']));
                $fechas = '(v.fecha_venta >= ? AND v.fecha_venta <= ?)';
            }         
            $stm = $this->db->prepare("SELECT dp.id_prod,
            SUM(dp.cantidad) AS cantidad_total,
            dp.precio,
            IFNULL((SUM(dp.cantidad)*dp.precio),0) AS total,v.fecha_venta 
            FROM tm_detalle_venta AS dp 
            INNER JOIN tm_venta AS v ON dp.id_venta = v.id_venta 
            INNER JOIN v_productos AS vp ON vp.id_pres = dp.id_prod 
            WHERE ".$fechas." AND vp.id_catg LIKE ?
            AND vp.id_prod LIKE ? AND vp.id_pres LIKE ? AND v.state_type_id != '11' GROUP BY dp.id_prod, dp.precio
            ORDER BY v.fecha_venta DESC, SUM(dp.cantidad) DESC;");

            $stm->execute(array($ifecha,$ffecha,$data['id_catg'],$data['id_prod'],$data['id_pres']));
            $c = $stm->fetchAll(PDO::FETCH_OBJ);
            foreach($c as $k => $d)
            {
                $c[$k]->{'Producto'} = $this->db->query("SELECT pro_nom,pro_pre,pro_cat FROM v_productos WHERE id_pres = ".$d->id_prod)
                    ->fetch(PDO::FETCH_OBJ);
            }

            $data = array("data" => $c);
            $json = json_encode($data);
            echo $json;
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }
    
    public function venta_prod_canal_list($data)
    {
        try
        {
            if (Session::get('report_date') == '0') {
                $ifecha = date('Y-m-d',strtotime($data['ifecha']));
                $ffecha = date('Y-m-d',strtotime($data['ffecha']));
                $fechas = '(DATE(v.fecha_venta) >= ? AND DATE(v.fecha_venta) <= ?)';
            } else {
                $ifecha = date('Y-m-d H:i:s',strtotime($data['ifecha']));
                $ffecha = date('Y-m-d H:i:s',strtotime($data['ffecha']));
                $fechas = '(v.fecha_venta >= ? AND v.fecha_venta <= ?)';
            }         
            $stm = $this->db->prepare("SELECT dp.id_prod,
            SUM(CASE WHEN v.id_tipo_pedido = 1 THEN dp.cantidad ELSE 0 END) AS cantidad_salon,
            SUM(CASE WHEN v.id_tipo_pedido = 2 THEN dp.cantidad ELSE 0 END) AS cantidad_mostrador,
            SUM(CASE WHEN v.id_tipo_pedido = 3 THEN dp.cantidad ELSE 0 END) AS cantidad_delivery,
            SUM(dp.cantidad) AS cantidad_total,dp.precio,IFNULL((SUM(dp.cantidad)*dp.precio),0) AS total,v.fecha_venta 
            FROM tm_detalle_venta AS dp 
            INNER JOIN tm_venta AS v ON dp.id_venta = v.id_venta 
            INNER JOIN v_productos AS vp ON vp.id_pres = dp.id_prod 
            WHERE ".$fechas." AND vp.id_catg LIKE ?
            AND vp.id_prod LIKE ? AND vp.id_pres LIKE ? AND v.state_type_id != '11' GROUP BY dp.id_prod, dp.precio
            ORDER BY v.fecha_venta DESC, SUM(dp.cantidad) DESC;");

            $stm->execute(array($ifecha,$ffecha,$data['id_catg'],$data['id_prod'],$data['id_pres']));
            $c = $stm->fetchAll(PDO::FETCH_OBJ);
            foreach($c as $k => $d)
            {
                $c[$k]->{'Producto'} = $this->db->query("SELECT pro_nom,pro_pre,pro_cat FROM v_productos WHERE id_pres = ".$d->id_prod)
                    ->fetch(PDO::FETCH_OBJ);
            }

            $data = array("data" => $c);
            $json = json_encode($data);
            echo $json;
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function venta_prod_kardex_list($data)
    {
        try
        {
            $config->{'Configuracion'} = $this->db->query("SELECT * FROM tm_configuracion")->fetch(PDO::FETCH_OBJ);
            
            if (Session::get('report_date') == '0') {
                $ifecha = date('Y-m-d',strtotime($data['ifecha']));
                $ffecha = date('Y-m-d',strtotime($data['ffecha']));
                $fechas = '(DATE(v.fec_ven) >= ? AND DATE(v.fec_ven) <= ?)';
            } else {
                $ifecha = date('Y-m-d H:i:s',strtotime($data['ifecha']));
                $ffecha = date('Y-m-d H:i:s',strtotime($data['ffecha']));
                $fechas = '(v.fec_ven >= ? AND v.fec_ven <= ?)';
            }      
            
            if ($config->{'Configuracion'}->activated_pres == '1'){
                $query = $this->db->prepare("SELECT v.fec_ven AS fecha_venta, v.desc_td AS documento_venta, CONCAT(v.ser_doc,'-',v.nro_doc) AS nro_documento, p.pro_pre AS producto_presentacion, p.pro_cat AS producto_categoria, dv.cantidad AS cantidad_vendida, dv.precio AS precio_venta, (dv.cantidad*dv.precio) AS total
                FROM tm_detalle_venta AS dv 
                INNER JOIN v_ventas_con AS v ON dv.id_venta = v.id_ven 
                INNER JOIN v_productos AS p ON p.id_pres = dv.id_prod 
                WHERE ".$fechas." AND p.id_catg = ?
                AND p.id_prod = ? AND p.id_pres = ? AND v.state_type_id != '11' ORDER BY v.fec_ven DESC;");
                $query->execute(array($ifecha,$ffecha,$data['id_catg'],$data['id_prod'],$data['id_pres']));
                $a = $query->fetchAll(PDO::FETCH_OBJ);                
            }else{
                $query = $this->db->prepare("SELECT v.fec_ven AS fecha_venta, v.desc_td AS documento_venta, CONCAT(v.ser_doc,'-',v.nro_doc) AS nro_documento, CONCAT(p.pro_nom,' - ',p.pro_pre) AS producto_presentacion, p.pro_cat AS producto_categoria, dv.cantidad AS cantidad_vendida, dv.precio AS precio_venta, (dv.cantidad*dv.precio) AS total
                FROM tm_detalle_venta AS dv 
                INNER JOIN v_ventas_con AS v ON dv.id_venta = v.id_ven 
                INNER JOIN v_productos AS p ON p.id_pres = dv.id_prod 
                WHERE ".$fechas." AND p.id_catg = ?
                AND p.id_prod = ? AND p.id_pres = ? AND v.state_type_id != '11' ORDER BY v.fec_ven DESC;");
                $query->execute(array($ifecha,$ffecha,$data['id_catg'],$data['id_prod'],$data['id_pres']));
                $a = $query->fetchAll(PDO::FETCH_OBJ);                
            }


            $data = array("data" => $a);
            $json = json_encode($data);
            echo $json;
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function venta_prod_kardex_graphic($data)
    {
        try
        {
            if (Session::get('report_date') == '0') {
                $ifecha = date('Y-m-d',strtotime($data['ifecha']));
                $ffecha = date('Y-m-d',strtotime($data['ffecha']));
                $fechas = '(DATE(v.fec_ven) >= ? AND DATE(v.fec_ven) <= ?)';
            } else {
                $ifecha = date('Y-m-d H:i:s',strtotime($data['ifecha']));
                $ffecha = date('Y-m-d H:i:s',strtotime($data['ffecha']));
                $fechas = '(v.fec_ven >= ? AND v.fec_ven <= ?)';
            }   

            $query = $this->db->prepare("SELECT DATE(v.fec_ven) AS y, SUM(dv.cantidad) AS a FROM tm_detalle_venta AS dv INNER JOIN v_ventas_con AS v ON dv.id_venta = v.id_ven INNER JOIN v_productos AS p ON p.id_pres = dv.id_prod WHERE ".$fechas." AND p.id_catg = ? AND p.id_prod = ? AND p.id_pres = ? AND v.state_type_id != '11' GROUP BY DATE(v.fec_ven) ORDER BY v.fec_ven DESC");
            $query->execute(array($ifecha,$ffecha,$data['id_catg'],$data['id_prod'],$data['id_pres']));
            $a = $query->fetchAll(PDO::FETCH_OBJ);

            $data = array('data' => $a);
            $json = json_encode($data);
            echo $json;
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    } 
    public function venta_prod_margen_list($data)
    {
        try
        {
            $config->{'Configuracion'} = $this->db->query("SELECT * FROM tm_configuracion")->fetch(PDO::FETCH_OBJ);
            
            if (Session::get('report_date') == '0') {
                $ifecha = date('Y-m-d',strtotime($data['ifecha']));
                $ffecha = date('Y-m-d',strtotime($data['ffecha']));
                $fechas = '(DATE(v.fecha_venta) >= ? AND DATE(v.fecha_venta) <= ?)';
            } else {
                $ifecha = date('Y-m-d H:i:s',strtotime($data['ifecha']));
                $ffecha = date('Y-m-d H:i:s',strtotime($data['ffecha']));
                $fechas = '(v.fecha_venta >= ? AND v.fecha_venta <= ?)';
            }
            
            if ($config->{'Configuracion'}->activated_pres == '1'){
                $stm = $this->db->prepare("SELECT p.pro_pre AS producto_presentacion, p.pro_cat AS producto_categoria, SUM(dv.cantidad) AS cantidad_vendida, dv.costo AS costo_unitario, (SUM(dv.cantidad)*dv.costo) AS costo_total, dv.precio AS precio_venta, (dv.precio-dv.costo) AS margen_unitario, ((SUM(dv.cantidad)*dv.precio) - (SUM(dv.cantidad)*dv.costo)) AS margen_total, (SUM(dv.cantidad)*dv.precio) AS total 
                    FROM tm_detalle_venta AS dv 
                    INNER JOIN tm_venta AS v ON v.id_venta = dv.id_venta
                    INNER JOIN v_productos AS p ON p.id_pres = dv.id_prod
                    WHERE ".$fechas." AND p.id_catg LIKE ? AND p.id_prod LIKE ? AND p.id_pres LIKE ? AND v.state_type_id != '11' GROUP BY dv.precio,dv.costo ORDER BY v.fecha_venta DESC;");
                $stm->execute(array($ifecha,$ffecha,$data['id_catg'],$data['id_prod'],$data['id_pres']));
                $c = $stm->fetchAll(PDO::FETCH_OBJ);                
            }else{
                $stm = $this->db->prepare("SELECT CONCAT(p.pro_nom,' - ',p.pro_pre) AS producto_presentacion, p.pro_cat AS producto_categoria, SUM(dv.cantidad) AS cantidad_vendida, dv.costo AS costo_unitario, (SUM(dv.cantidad)*dv.costo) AS costo_total, dv.precio AS precio_venta, (dv.precio-dv.costo) AS margen_unitario, ((SUM(dv.cantidad)*dv.precio) - (SUM(dv.cantidad)*dv.costo)) AS margen_total, (SUM(dv.cantidad)*dv.precio) AS total 
                    FROM tm_detalle_venta AS dv 
                    INNER JOIN tm_venta AS v ON v.id_venta = dv.id_venta
                    INNER JOIN v_productos AS p ON p.id_pres = dv.id_prod
                    WHERE ".$fechas." AND p.id_catg LIKE ? AND p.id_prod LIKE ? AND p.id_pres LIKE ? AND v.state_type_id != '11' GROUP BY dv.precio,dv.costo ORDER BY v.fecha_venta DESC;");
                $stm->execute(array($ifecha,$ffecha,$data['id_catg'],$data['id_prod'],$data['id_pres']));
                $c = $stm->fetchAll(PDO::FETCH_OBJ);                
            }

            $data = array("data" => $c);
            $json = json_encode($data);
            echo $json;
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }
    public function combPro($data)
    {
        try
        {
            $stm = $this->db->prepare("SELECT * FROM tm_producto WHERE id_catg = ?");
            $stm->execute(array($data['cod']));
            $c = $stm->fetchAll(PDO::FETCH_OBJ);
            return $c;
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }
    public function venta_cort_list($data)
    {
        try
        {
            
            if (Session::get('report_date') == '0') {
                $ifecha = date('Y-m-d',strtotime($data['ifecha']));
                $ffecha = date('Y-m-d',strtotime($data['ffecha']));
                $fechas = '(DATE(v.fec_ven) >= ? AND DATE(v.fec_ven) <= ?)';
            } else {
                $ifecha = date('Y-m-d H:i:s',strtotime($data['ifecha']));
                $ffecha = date('Y-m-d H:i:s',strtotime($data['ffecha']));
                $fechas = '(v.fec_ven >= ? AND v.fec_ven <= ?)';
            }
            
            $stm = $this->db->prepare("SELECT v.id_ven,v.id_ped,v.desc_monto,v.desc_tipo,v.desc_motivo,v.comis_tar,v.comis_del,v.total AS stotal,v.fec_ven,v.desc_td,CONCAT(v.ser_doc,'-',v.nro_doc) AS numero,IFNULL(SUM(v.desc_monto),0) AS total_descuento, v.total ,v.id_cli,v.igv,v.id_usu,c.desc_caja,v.desc_usu FROM v_ventas_con AS v INNER JOIN v_caja_aper AS c ON v.id_apc = c.id_apc WHERE (DATE(v.fec_ven) >= ? AND DATE(v.fec_ven) <= ?) AND v.state_type_id != '11' AND v.desc_tipo = 1 GROUP BY v.id_ven ORDER BY DATE(v.fec_ven) ASC");
            $stm->execute(array($ifecha,$ffecha));
            $c = $stm->fetchAll(PDO::FETCH_OBJ);
            /*        
            foreach($c as $k => $d)
            {
                $c[$k]->{'Cliente'} = $this->db->query("SELECT nombre FROM v_clientes WHERE id_cliente = ".$d->id_cli)
                    ->fetch(PDO::FETCH_OBJ);
            }
            */
            $data = array("data" => $c);
            $json = json_encode($data);
            echo $json;       
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }
    public function combPre($data)
    {
        try
        {
            $stm = $this->db->prepare("SELECT * FROM tm_producto_pres WHERE id_prod = ?");
            $stm->execute(array($data['cod']));
            $c = $stm->fetchAll(PDO::FETCH_OBJ);
            return $c;
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function venta_mozo_list($data)
    {
        try
        {
            if (Session::get('report_date') == '0') {
                $ifecha = date('Y-m-d',strtotime($data['ifecha']));
                $ffecha = date('Y-m-d',strtotime($data['ffecha']));
                $fechas = '(DATE(v.fec_ven) >= ? AND DATE(v.fec_ven) <= ?)';
            } else {
                $ifecha = date('Y-m-d H:i:s',strtotime($data['ifecha']));
                $ffecha = date('Y-m-d H:i:s',strtotime($data['ffecha']));
                $fechas = '(v.fec_ven >= ? AND v.fec_ven <= ?)';
            }

            $stm = $this->db->prepare("SELECT v.fec_ven,v.desc_td,CONCAT(v.ser_doc,'-',v.nro_doc) AS numero,IFNULL(SUM(v.total),0) AS total,v.id_cli,pm.id_mozo FROM v_ventas_con AS v INNER JOIN tm_pedido_mesa AS pm ON v.id_ped = pm.id_pedido WHERE ".$fechas." AND pm.id_mozo like ? AND v.state_type_id != '11' GROUP BY v.id_ven");
            $stm->execute(array($ifecha,$ffecha,$data['id_mozo']));
            $c = $stm->fetchAll(PDO::FETCH_OBJ);        
            foreach($c as $k => $d)
            {
                $c[$k]->{'Mozo'} = $this->db->query("SELECT CONCAT(nombres,' ',ape_paterno,' ',ape_materno) AS nombre FROM v_usuarios WHERE id_usu = ".$d->id_mozo)
                    ->fetch(PDO::FETCH_OBJ);

                $c[$k]->{'Cliente'} = $this->db->query("SELECT nombre FROM v_clientes WHERE id_cliente = ".$d->id_cli)
                    ->fetch(PDO::FETCH_OBJ);
            }
            $data = array("data" => $c);
            $json = json_encode($data);
            echo $json;  
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }


    public function venta_fpago_list($data)
    {
        try
        {
            if (Session::get('report_date') == '0') {
                $ifecha = date('Y-m-d',strtotime($data['ifecha']));
                $ffecha = date('Y-m-d',strtotime($data['ffecha']));
                $fechas = '(DATE(v.fec_ven) >= ? AND DATE(v.fec_ven) <= ?)';
            } else {
                $ifecha = date('Y-m-d H:i:s',strtotime($data['ifecha']));
                $ffecha = date('Y-m-d H:i:s',strtotime($data['ffecha']));
                $fechas = '(v.fec_ven >= ? AND v.fec_ven <= ?)';
            }       

            $stm = $this->db->prepare("SELECT v.id_ven,v.desc_monto,v.comis_tar,v.comis_del,
            v.total,
            CASE WHEN v.state_type_id != '11' THEN IF((v.desc_tipo = 1),0,v.total+v.comis_del+v.comis_tar) ELSE 0 END monto_total,
            v.fec_ven,v.desc_td,CONCAT(v.ser_doc,'-',v.nro_doc) AS numero,v.id_cli,v.igv,v.id_usu,c.desc_caja,v.estado, GROUP_CONCAT(vp.id_pago  SEPARATOR ', ') AS pagos FROM v_ventas_con AS v INNER JOIN v_caja_aper AS c ON v.id_apc = c.id_apc INNER JOIN tm_venta_pago AS vp ON v.id_ven = vp.id_venta WHERE ".$fechas." AND v.state_type_id != '11' AND vp.id_pago LIKE ? GROUP BY v.id_ven ORDER BY DATE(v.fec_ven) ASC");
            $stm->execute(array($ifecha,$ffecha,$data['id_tpag']));
            $c = $stm->fetchAll(PDO::FETCH_OBJ);
            
            foreach($c as $k => $d)
            {
                $c[$k]->{'Cliente'} = $this->db->query("SELECT nombre FROM v_clientes WHERE id_cliente = ".$d->id_cli)
                    ->fetch(PDO::FETCH_OBJ);
            }
            foreach($c as $k => $d)
            {
                $c[$k]->{'Tipopago'} = $this->db->query("SELECT tp.descripcion as nombre, tp.color AS color, vp.monto FROM tm_venta_pago AS vp INNER JOIN tm_venta AS v ON v.id_venta = vp.id_venta INNER JOIN tm_tipo_pago AS tp ON vp.id_pago = tp.id_tipo_pago WHERE vp.monto > 0 AND vp.id_venta =" . $d->id_ven)           
                    ->fetchAll(PDO::FETCH_OBJ);
            }

            $pago = $this->db->prepare("SELECT tp.descripcion AS nombre, COUNT(*) AS cantidad, SUM(vp.monto) AS monto FROM tm_venta_pago AS vp INNER JOIN tm_venta AS v ON v.id_venta = vp.id_venta INNER JOIN tm_tipo_pago AS tp ON vp.id_pago = tp.id_tipo_pago WHERE (DATE(v.fecha_venta) >= ? AND DATE(v.fecha_venta) <= ?) AND tp.id_tipo_pago LIKE ? AND vp.monto > 0 AND v.state_type_id != '11' GROUP BY tp.descripcion;");
            $pago->execute(array($ifecha,$ffecha,$data['id_tpag']));
            
            $cpago = $pago->fetchAll(PDO::FETCH_OBJ);
            $data = array("data" => $c, "pago" => $cpago);
            $json = json_encode($data);
            echo $json;       
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function venta_desc_list($data)
    {
        try
        {

            if (Session::get('report_date') == '0') {
                $ifecha = date('Y-m-d',strtotime($data['ifecha']));
                $ffecha = date('Y-m-d',strtotime($data['ffecha']));
                $fechas = '(DATE(v.fec_ven) >= ? AND DATE(v.fec_ven) <= ?)';
            } else {
                $ifecha = date('Y-m-d H:i:s',strtotime($data['ifecha']));
                $ffecha = date('Y-m-d H:i:s',strtotime($data['ffecha']));
                $fechas = '(v.fec_ven >= ? AND v.fec_ven <= ?)';
            }       

            $stm = $this->db->prepare("SELECT v.id_ven,v.id_ped,v.desc_monto,v.desc_tipo,v.desc_motivo,v.comis_tar,v.comis_del,v.total AS stotal,v.fec_ven,v.desc_td,CONCAT(v.ser_doc,'-',v.nro_doc) AS numero,IFNULL(SUM(v.total),0) AS total,v.id_cli,v.igv,v.id_usu,c.desc_caja,v.desc_usu FROM v_ventas_con AS v INNER JOIN v_caja_aper AS c ON v.id_apc = c.id_apc WHERE ".$fechas." AND v.desc_tipo = 2 AND v.desc_monto > 0 AND v.state_type_id != '11' GROUP BY v.id_ven ORDER BY DATE(v.fec_ven) ASC");
            $stm->execute(array($ifecha,$ffecha));
            $c = $stm->fetchAll(PDO::FETCH_OBJ);

            $data = array("data" => $c);
            $json = json_encode($data);
            echo $json;       
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function venta_all_imp_directa($data)
    {
        try
        {      
            $stm = $this->db->prepare("SELECT * FROM v_ventas_con WHERE id_ven = ?");
            $stm->execute(array($data));
            $c = $stm->fetch(PDO::FETCH_OBJ);
            $c->{'Empresa'} = $this->db->query("SELECT * FROM tm_empresa")
                ->fetch(PDO::FETCH_OBJ);
            $c->{'Configuracion'} = $this->db->query("SELECT * FROM tm_configuracion")
            ->fetch(PDO::FETCH_OBJ);
            $c->{'Cliente'} = $this->db->query("SELECT * FROM v_clientes WHERE id_cliente = " . $c->id_cli)
                ->fetch(PDO::FETCH_OBJ);
            $c->{'Pedido'} = $this->db->query("SELECT vm.desc_salon, vm.nro_mesa  FROM tm_pedido_mesa AS pm INNER JOIN v_mesas AS vm ON pm.id_mesa = vm.id_mesa WHERE pm.id_pedido = " . $c->id_ped)
                ->fetch(PDO::FETCH_OBJ);
            $c->{'Configuracion'} = $this->db->query("SELECT * FROM tm_configuracion")
                ->fetch(PDO::FETCH_OBJ);
                
            /* Traemos el detalle */
            if ($c->{'Configuracion'}->activated_pres == '1'){
                $c->{'Detalle'} = $this->db->query("SELECT v_productos.pro_cod AS codigo_producto, 
                v_productos.pro_pre AS nombre_producto, 
                IF(v_productos.pro_imp='1','10','20') AS codigo_afectacion, 
                CAST(tm_detalle_venta.cantidad AS DECIMAL(7,2)) AS cantidad, 
                IF(v_productos.pro_imp='1',ROUND((tm_detalle_venta.precio/(1 + {$c->igv})),2),tm_detalle_venta.precio) AS valor_unitario,
                tm_detalle_venta.precio AS precio_unitario,
                IF(v_productos.pro_imp='1',ROUND((tm_detalle_venta.precio/(1 + {$c->igv}))*tm_detalle_venta.cantidad,2),
                ROUND(tm_detalle_venta.precio*tm_detalle_venta.cantidad,2)) AS valor_venta,
                IF(v_productos.pro_imp='1',ROUND((tm_detalle_venta.precio/(1 + {$c->igv})*tm_detalle_venta.cantidad)*{$c->igv},2),0) AS total_igv,
                toppings
                FROM tm_detalle_venta 
                INNER JOIN tm_venta ON tm_detalle_venta.id_venta = tm_venta.id_venta 
                INNER JOIN v_productos ON tm_detalle_venta.id_prod = v_productos.id_pres 
                WHERE tm_venta.id_tipo_doc  IN ('1','2','3') AND tm_detalle_venta.precio > 0 AND tm_detalle_venta.id_venta = ".$data)->fetchAll(PDO::FETCH_OBJ);
            }else{
                $c->{'Detalle'} = $this->db->query("SELECT v_productos.pro_cod AS codigo_producto, 
                CONCAT(v_productos.pro_nom,' ',v_productos.pro_pre) AS nombre_producto, 
                IF(v_productos.pro_imp='1','10','20') AS codigo_afectacion, 
                CAST(tm_detalle_venta.cantidad AS DECIMAL(7,2)) AS cantidad, 
                IF(v_productos.pro_imp='1',ROUND((tm_detalle_venta.precio/(1 + {$c->igv})),2),tm_detalle_venta.precio) AS valor_unitario,
                tm_detalle_venta.precio AS precio_unitario,
                IF(v_productos.pro_imp='1',ROUND((tm_detalle_venta.precio/(1 + {$c->igv}))*tm_detalle_venta.cantidad,2),
                ROUND(tm_detalle_venta.precio*tm_detalle_venta.cantidad,2)) AS valor_venta,
                IF(v_productos.pro_imp='1',ROUND((tm_detalle_venta.precio/(1 + {$c->igv})*tm_detalle_venta.cantidad)*{$c->igv},2),0) AS total_igv,
                toppings
                FROM tm_detalle_venta 
                INNER JOIN tm_venta ON tm_detalle_venta.id_venta = tm_venta.id_venta 
                INNER JOIN v_productos ON tm_detalle_venta.id_prod = v_productos.id_pres 
                WHERE tm_venta.id_tipo_doc  IN ('1','2','3') AND tm_detalle_venta.precio > 0 AND tm_detalle_venta.id_venta = ".$data)->fetchAll(PDO::FETCH_OBJ);
            }

            $c->{'Pagos'} = $this->db->query("SELECT tp.descripcion AS nombre, COUNT(*) AS cantidad, SUM(vp.monto) AS monto FROM tm_venta_pago AS vp INNER JOIN tm_venta AS v ON v.id_venta = vp.id_venta INNER JOIN tm_tipo_pago AS tp ON vp.id_pago = tp.id_tipo_pago WHERE v.id_venta = {$data} AND vp.monto > 0 AND v.estado = 'a' GROUP BY tp.descripcion;")->fetchAll(PDO::FETCH_OBJ);                  
            
            if ($c->id_tped == 3) {

                $c->{'TicketReparto'} = $this->db->query("SELECT v.id_ven, v.id_apc,v.comis_del,  v.id_ped, d.id_cliente, v.fec_ven, v.pago_efe_none, v.pago_efe_vuelto, IFNULL((v.total),0) AS total, d.nro_pedido FROM v_ventas_con AS v INNER JOIN tm_pedido_delivery AS d ON v.id_ped = d.id_pedido WHERE id_ven = ".$data)
                ->fetch(PDO::FETCH_OBJ);

                $c->{'Repartidor'} = $this->db->query("SELECT desc_repartidor FROM v_pedido_delivery WHERE id_pedido = ".$c->id_ped)->fetch(PDO::FETCH_OBJ);
                
                $c->{'TicketRepartoDetalle'} = $this->db->query("SELECT id_prod,SUM(cantidad) AS cantidad, precio FROM tm_detalle_venta WHERE id_venta = " . $c->id_ven." GROUP BY id_prod, precio")
                ->fetchAll(PDO::FETCH_OBJ);
                foreach($c->TicketRepartoDetalle as $k => $d)
                {
                    $c->TicketRepartoDetalle[$k]->{'Producto'} = $this->db->query("SELECT pro_nom, pro_pre FROM v_productos WHERE id_pres = " . $d->id_prod)
                        ->fetch(PDO::FETCH_OBJ);
                }
        
            }
            $c->{'Impresora'} = $this->db->query("SELECT i.nombre FROM tm_aper_cierre AS ac INNER JOIN tm_caja AS ca ON ac.id_caja = ca.id_caja INNER JOIN tm_impresora AS i ON i.id_imp = ca.id_imp WHERE ac.id_apc = " . Session::get('apcid'))->fetch(PDO::FETCH_OBJ);
            $c->{'nombre_pc'} = Session::get('pc_name');     

            // Recuperar la URL de config.php de manera segura
            if (defined('URL')) {
                $url = URL;
            } else {
                $url = "https://alpharest.pe/";  // Valor predeterminado si no está definida la constante
            }
            $c->{'url_sistema'} = $url;
            
            return $c;
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function venta_all_imp_pdf($data)
    {
        try
        {      
            // imprimir directo 
            $stm = $this->db->prepare("SELECT * FROM v_ventas_con WHERE id_ven = ?");
            $stm->execute(array($data));
            $c = $stm->fetch(PDO::FETCH_OBJ);
            
            if (!$c) {
                throw new Exception("No se encontró la venta con ID: " . $data);
            }
            
            $c->{'Cliente'} = $this->db->query("SELECT * FROM v_clientes WHERE id_cliente = " . $c->id_cli)
                ->fetch(PDO::FETCH_OBJ);
            $c->{'Pedido'} = $this->db->query("SELECT vm.desc_salon, vm.nro_mesa  FROM tm_pedido_mesa AS pm INNER JOIN v_mesas AS vm ON pm.id_mesa = vm.id_mesa WHERE pm.id_pedido = " . $c->id_ped)
                ->fetch(PDO::FETCH_OBJ);
            $c->{'Configuracion'} = $this->db->query("SELECT * FROM tm_configuracion")
                ->fetch(PDO::FETCH_OBJ);
            // Verificar si la consulta retorna resultados
            //var_dump($c->{'Configuracion'}); 
            //var_dump($c->{'Configuracion'}->activated_pres); 

            if ($c->{'Configuracion'}->activated_pres == '1'){
                $c->{'Detalle'} = $this->db->query("SELECT v_productos.pro_cod AS codigo_producto, 
                    v_productos.pro_pre AS nombre_producto, 
                    IF(v_productos.pro_imp='1','10','20') AS codigo_afectacion, 
                    CAST(tm_detalle_venta.cantidad AS DECIMAL(7,2)) AS cantidad, 
                    IF(v_productos.pro_imp='1',ROUND((tm_detalle_venta.precio/(1 + {$c->igv})),2),tm_detalle_venta.precio) AS valor_unitario,
                    tm_detalle_venta.precio AS precio_unitario,
                    IF(v_productos.pro_imp='1',ROUND((tm_detalle_venta.precio/(1 + {$c->igv}))*tm_detalle_venta.cantidad,2),
                    ROUND(tm_detalle_venta.precio*tm_detalle_venta.cantidad,2)) AS valor_venta,
                    IF(v_productos.pro_imp='1',ROUND((tm_detalle_venta.precio/(1 + {$c->igv})*tm_detalle_venta.cantidad)*{$c->igv},2),0) AS total_igv,
                    COALESCE(tm_detalle_venta.desc_monto,0) AS descuento_item,
                    toppings
                    FROM tm_detalle_venta 
                    INNER JOIN tm_venta ON tm_detalle_venta.id_venta = tm_venta.id_venta 
                    INNER JOIN v_productos ON tm_detalle_venta.id_prod = v_productos.id_pres 
                    WHERE tm_venta.id_tipo_doc  IN ('1','2','3') AND tm_detalle_venta.precio > 0 AND tm_detalle_venta.id_venta = ".$data)
                    ->fetchAll(PDO::FETCH_OBJ);                
            }else{
                $c->{'Detalle'} = $this->db->query("SELECT v_productos.pro_cod AS codigo_producto, 
                    CONCAT(v_productos.pro_nom,' ',v_productos.pro_pre) AS nombre_producto, 
                    IF(v_productos.pro_imp='1','10','20') AS codigo_afectacion, 
                    CAST(tm_detalle_venta.cantidad AS DECIMAL(7,2)) AS cantidad, 
                    IF(v_productos.pro_imp='1',ROUND((tm_detalle_venta.precio/(1 + {$c->igv})),2),tm_detalle_venta.precio) AS valor_unitario,
                    tm_detalle_venta.precio AS precio_unitario,
                    IF(v_productos.pro_imp='1',ROUND((tm_detalle_venta.precio/(1 + {$c->igv}))*tm_detalle_venta.cantidad,2),
                    ROUND(tm_detalle_venta.precio*tm_detalle_venta.cantidad,2)) AS valor_venta,
                    IF(v_productos.pro_imp='1',ROUND((tm_detalle_venta.precio/(1 + {$c->igv})*tm_detalle_venta.cantidad)*{$c->igv},2),0) AS total_igv,
                    COALESCE(tm_detalle_venta.desc_monto,0) AS descuento_item,
                    toppings
                    FROM tm_detalle_venta 
                    INNER JOIN tm_venta ON tm_detalle_venta.id_venta = tm_venta.id_venta 
                    INNER JOIN v_productos ON tm_detalle_venta.id_prod = v_productos.id_pres 
                    WHERE tm_venta.id_tipo_doc  IN ('1','2','3') AND tm_detalle_venta.precio > 0 AND tm_detalle_venta.id_venta = ".$data)
                    ->fetchAll(PDO::FETCH_OBJ);      
            }

            $c->{'Pagos'} = $this->db->query("SELECT tp.descripcion AS nombre, COUNT(*) AS cantidad, SUM(vp.monto) AS monto FROM tm_venta_pago AS vp INNER JOIN tm_venta AS v ON v.id_venta = vp.id_venta INNER JOIN tm_tipo_pago AS tp ON vp.id_pago = tp.id_tipo_pago WHERE v.id_venta = {$data} AND vp.monto > 0 AND v.estado = 'a' GROUP BY tp.descripcion;")->fetchAll(PDO::FETCH_OBJ);     


            if($c->id_tped == '1'){  
            } elseif($c->id_tped == '2'){
                $c->{'Llevar'} = $this->db->query("SELECT * FROM v_pedido_llevar WHERE id_pedido = " . $c->id_ped)->fetch(PDO::FETCH_OBJ);   
            } elseif($c->id_tped == '3'){
                $c->{'Delivery'} = $this->db->query("SELECT * FROM v_pedido_delivery WHERE id_pedido = " . $c->id_ped)->fetch(PDO::FETCH_OBJ);   
            }

            // Obtener datos del documento de facturación electrónica si existe (con datos actualizados después del envío)
            $c->{'DocumentoFE'} = $this->db->query("SELECT d.*, 
                COALESCE(s.serie, td.serie) as serie_electronica
                FROM tm_facturacion_electronica_documentos d
                LEFT JOIN tm_series_documentos s ON d.id_serie_documento = s.id_serie
                LEFT JOIN tm_venta v ON d.id_venta = v.id_venta
                LEFT JOIN tm_tipo_doc td ON v.id_tipo_doc = td.id_tipo_doc AND d.id_serie_documento IS NULL
                WHERE d.id_venta = " . $data . " LIMIT 1")
                ->fetch(PDO::FETCH_OBJ);

            return $c;
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    /**
     * Obtener datos del PDF para facturación dividida (una precuenta específica)
     * Usa los datos guardados en tm_pedido_precuenta_facturacion para obtener items y descuentos correctos
     */
    public function venta_dividida_imp_pdf($id_venta)
    {
        try {
            // Obtener datos de la precuenta desde tm_pedido_precuenta_facturacion
            $stm_prec = $this->db->prepare("SELECT * FROM tm_pedido_precuenta_facturacion WHERE id_venta = ? LIMIT 1");
            $stm_prec->execute(array($id_venta));
            $prec_data = $stm_prec->fetch(PDO::FETCH_OBJ);
            
            if (!$prec_data) {
                throw new Exception("No se encontraron datos de precuenta para id_venta: " . $id_venta);
            }
            
            // Obtener datos básicos de la venta
            $stm = $this->db->prepare("SELECT * FROM v_ventas_con WHERE id_ven = ?");
            $stm->execute(array($id_venta));
            $c = $stm->fetch(PDO::FETCH_OBJ);
            
            if (!$c) {
                throw new Exception("No se encontró la venta con id_venta: " . $id_venta);
            }
            
            // Sobrescribir cliente con el de la precuenta (usando v_clientes como en el resto del sistema)
            $c->id_cli = $prec_data->id_cliente;
            $stm_cliente_prec = $this->db->prepare("SELECT * FROM v_clientes WHERE id_cliente = ?");
            $stm_cliente_prec->execute(array($prec_data->id_cliente));
            $cliente_prec = $stm_cliente_prec->fetch(PDO::FETCH_OBJ);
            
            if (!$cliente_prec) {
                @file_put_contents(__DIR__ . '/../log_venta_dividida_pdf.log', date('Y-m-d H:i:s') . " venta_dividida_imp_pdf: WARNING - Cliente ID " . $prec_data->id_cliente . " no encontrado en v_clientes para id_venta=" . $id_venta . "\n", FILE_APPEND);
                // Fallback: intentar obtener desde tm_cliente si existe
                $stm_cliente_fallback = $this->db->prepare("SELECT nombre AS nombre, ruc AS ruc, dni AS dni FROM tm_cliente WHERE id_cliente = ?");
                $stm_cliente_fallback->execute(array($prec_data->id_cliente));
                $cliente_prec = $stm_cliente_fallback->fetch(PDO::FETCH_OBJ);
                if (!$cliente_prec) {
                    @file_put_contents(__DIR__ . '/../log_venta_dividida_pdf.log', date('Y-m-d H:i:s') . " venta_dividida_imp_pdf: ERROR - Cliente ID " . $prec_data->id_cliente . " no encontrado ni en v_clientes ni en tm_cliente\n", FILE_APPEND);
                    // Crear objeto cliente vacío para evitar errores
                    $cliente_prec = (object) array('nombre' => 'Cliente no encontrado', 'ruc' => '', 'dni' => '');
                }
            }
            
            $c->{'Cliente'} = $cliente_prec;
            @file_put_contents(__DIR__ . '/../log_venta_dividida_pdf.log', date('Y-m-d H:i:s') . " venta_dividida_imp_pdf: id_venta=" . $id_venta . " cliente_id=" . $prec_data->id_cliente . " cliente_nombre=" . ($cliente_prec->nombre ?? 'N/A') . "\n", FILE_APPEND);
            
            // Sobrescribir correlativo si existe (usar el guardado en tm_pedido_precuenta_facturacion)
            if (!empty($prec_data->correlativo)) {
                $c->nro_doc = $prec_data->correlativo;
                @file_put_contents(__DIR__ . '/../log_venta_dividida_pdf.log', date('Y-m-d H:i:s') . " venta_dividida_imp_pdf: id_venta=" . $id_venta . " correlativo_guardado=" . $prec_data->correlativo . " correlativo_aplicado=" . $c->nro_doc . "\n", FILE_APPEND);
            } else {
                @file_put_contents(__DIR__ . '/../log_venta_dividida_pdf.log', date('Y-m-d H:i:s') . " venta_dividida_imp_pdf: id_venta=" . $id_venta . " WARNING: correlativo vacío en tm_pedido_precuenta_facturacion, usando nro_doc de venta=" . $c->nro_doc . "\n", FILE_APPEND);
            }
            
            // Obtener tipo de documento desde tm_pedido_precuenta_facturacion si está disponible
            if (!empty($prec_data->id_tipo_doc)) {
                $stm_td = $this->db->prepare("SELECT * FROM tm_tipo_doc WHERE id_tipo_doc = ?");
                $stm_td->execute(array($prec_data->id_tipo_doc));
                $tipo_doc = $stm_td->fetch(PDO::FETCH_OBJ);
                if ($tipo_doc) {
                    $c->id_tdoc = $prec_data->id_tipo_doc;
                    $c->desc_td = $tipo_doc->descripcion;
                    if (!empty($tipo_doc->serie)) {
                        $c->ser_doc = $tipo_doc->serie;
                    }
                }
            }
            
            $c->{'Pedido'} = $this->db->query("SELECT vm.desc_salon, vm.nro_mesa FROM tm_pedido_mesa AS pm INNER JOIN v_mesas AS vm ON pm.id_mesa = vm.id_mesa WHERE pm.id_pedido = " . $c->id_ped)
                ->fetch(PDO::FETCH_OBJ);
            $c->{'Configuracion'} = $this->db->query("SELECT * FROM tm_configuracion")
                ->fetch(PDO::FETCH_OBJ);
            
            // Obtener nombre_precuenta desde tm_pedido_precuenta_facturacion
            $nombre_precuenta = $prec_data->nombre_precuenta;
            $descuentos_items = json_decode($prec_data->descuentos_items, true);
            if (empty($descuentos_items) || !is_array($descuentos_items)) {
                $descuentos_items = array();
            }
            
            // Obtener items desde tm_detalle_pedido agrupados por nombre_precuenta
            // Luego mapearlos a tm_detalle_venta usando id_prod, precio y toppings
            $stm_items_pedido = $this->db->prepare("SELECT id_pres, SUM(cantidad) AS cantidad, precio, toppings 
                FROM tm_detalle_pedido 
                WHERE id_pedido = ? AND nombre_precuenta = ? AND estado <> 'z' 
                GROUP BY id_pres, precio, CASE WHEN toppings IS NOT NULL THEN toppings ELSE '' END");
            $stm_items_pedido->execute(array($c->id_ped, $nombre_precuenta));
            $items_pedido = $stm_items_pedido->fetchAll(PDO::FETCH_OBJ);
            
            @file_put_contents(__DIR__ . '/../log_venta_dividida_pdf.log', date('Y-m-d H:i:s') . " venta_dividida_imp_pdf: id_venta=" . $id_venta . " nombre_precuenta=" . $nombre_precuenta . " id_pedido=" . $c->id_ped . " items_pedido encontrados=" . count($items_pedido) . "\n", FILE_APPEND);
            
            // Construir condiciones para filtrar items en tm_detalle_venta
            $condiciones_items = array();
            foreach ($items_pedido as $item_ped) {
                $id_pres = intval($item_ped->id_pres);
                $precio = floatval($item_ped->precio);
                $toppings = ($item_ped->toppings === null || $item_ped->toppings === '') ? '' : $item_ped->toppings;
                // Escapar toppings para SQL (Database extiende PDO, así que tiene quote())
                $toppings_escaped = $this->db->quote($toppings);
                $condiciones_items[] = "(tm_detalle_venta.id_prod = {$id_pres} AND ABS(CAST(tm_detalle_venta.precio AS DECIMAL(10,2)) - CAST({$precio} AS DECIMAL(10,2))) < 0.01 AND (COALESCE(tm_detalle_venta.toppings,'') = {$toppings_escaped} OR (tm_detalle_venta.toppings IS NULL AND {$toppings_escaped} = '')))";
                @file_put_contents(__DIR__ . '/../log_venta_dividida_pdf.log', date('Y-m-d H:i:s') . " venta_dividida_imp_pdf: condición item id_pres=" . $id_pres . " precio=" . $precio . " toppings=" . $toppings . "\n", FILE_APPEND);
            }
            
            if (empty($condiciones_items)) {
                // Fallback: obtener todos los items de la venta si no hay items en pedido
                @file_put_contents(__DIR__ . '/../log_venta_dividida_pdf.log', date('Y-m-d H:i:s') . " venta_dividida_imp_pdf: WARNING - No hay items en pedido para precuenta, usando todos los items de la venta\n", FILE_APPEND);
                $condiciones_items[] = "1=1";
            }
            
            $condiciones_str = implode(' OR ', $condiciones_items);
            @file_put_contents(__DIR__ . '/../log_venta_dividida_pdf.log', date('Y-m-d H:i:s') . " venta_dividida_imp_pdf: condiciones_str=" . $condiciones_str . "\n", FILE_APPEND);
            
            // Asegurar que id_venta e igv sean valores numéricos válidos
            $id_venta_safe = intval($id_venta);
            $igv_safe = isset($c->igv) ? floatval($c->igv) : 0.10;
            
            if ($c->{'Configuracion'}->activated_pres == '1') {
                $detalle_query = "SELECT v_productos.pro_cod AS codigo_producto, 
                    v_productos.pro_pre AS nombre_producto, 
                    IF(v_productos.pro_imp='1','10','20') AS codigo_afectacion, 
                    CAST(tm_detalle_venta.cantidad AS DECIMAL(7,2)) AS cantidad, 
                    IF(v_productos.pro_imp='1',ROUND((tm_detalle_venta.precio/(1 + {$igv_safe})),2),tm_detalle_venta.precio) AS valor_unitario,
                    tm_detalle_venta.precio AS precio_unitario,
                    IF(v_productos.pro_imp='1',ROUND((tm_detalle_venta.precio/(1 + {$igv_safe}))*tm_detalle_venta.cantidad,2),
                    ROUND(tm_detalle_venta.precio*tm_detalle_venta.cantidad,2)) AS valor_venta,
                    IF(v_productos.pro_imp='1',ROUND((tm_detalle_venta.precio/(1 + {$igv_safe})*tm_detalle_venta.cantidad)*{$igv_safe},2),0) AS total_igv,
                    COALESCE(tm_detalle_venta.desc_monto,0) AS descuento_item,
                    tm_detalle_venta.toppings AS toppings
                    FROM tm_detalle_venta 
                    INNER JOIN tm_venta ON tm_detalle_venta.id_venta = tm_venta.id_venta 
                    INNER JOIN v_productos ON tm_detalle_venta.id_prod = v_productos.id_pres 
                    WHERE tm_venta.id_tipo_doc IN ('1','2','3') AND tm_detalle_venta.precio > 0 AND tm_detalle_venta.id_venta = {$id_venta_safe} AND ({$condiciones_str})";
            } else {
                $detalle_query = "SELECT v_productos.pro_cod AS codigo_producto, 
                    CONCAT(v_productos.pro_nom,' ',v_productos.pro_pre) AS nombre_producto, 
                    IF(v_productos.pro_imp='1','10','20') AS codigo_afectacion, 
                    CAST(tm_detalle_venta.cantidad AS DECIMAL(7,2)) AS cantidad, 
                    IF(v_productos.pro_imp='1',ROUND((tm_detalle_venta.precio/(1 + {$igv_safe})),2),tm_detalle_venta.precio) AS valor_unitario,
                    tm_detalle_venta.precio AS precio_unitario,
                    IF(v_productos.pro_imp='1',ROUND((tm_detalle_venta.precio/(1 + {$igv_safe}))*tm_detalle_venta.cantidad,2),
                    ROUND(tm_detalle_venta.precio*tm_detalle_venta.cantidad,2)) AS valor_venta,
                    IF(v_productos.pro_imp='1',ROUND((tm_detalle_venta.precio/(1 + {$igv_safe})*tm_detalle_venta.cantidad)*{$igv_safe},2),0) AS total_igv,
                    COALESCE(tm_detalle_venta.desc_monto,0) AS descuento_item,
                    tm_detalle_venta.toppings AS toppings
                    FROM tm_detalle_venta 
                    INNER JOIN tm_venta ON tm_detalle_venta.id_venta = tm_venta.id_venta 
                    INNER JOIN v_productos ON tm_detalle_venta.id_prod = v_productos.id_pres 
                    WHERE tm_venta.id_tipo_doc IN ('1','2','3') AND tm_detalle_venta.precio > 0 AND tm_detalle_venta.id_venta = {$id_venta_safe} AND ({$condiciones_str})";
            }
            
            @file_put_contents(__DIR__ . '/../log_venta_dividida_pdf.log', date('Y-m-d H:i:s') . " venta_dividida_imp_pdf: Ejecutando query detalle para id_venta=" . $id_venta . "\n", FILE_APPEND);
            @file_put_contents(__DIR__ . '/../log_venta_dividida_pdf.log', date('Y-m-d H:i:s') . " venta_dividida_imp_pdf: Query completo=" . $detalle_query . "\n", FILE_APPEND);
            
            try {
                $stmt = $this->db->query($detalle_query);
                if ($stmt === false) {
                    $error_info = $this->db->errorInfo();
                    @file_put_contents(__DIR__ . '/../log_venta_dividida_pdf.log', date('Y-m-d H:i:s') . " venta_dividida_imp_pdf: ERROR SQL: " . json_encode($error_info) . "\n", FILE_APPEND);
                    $detalle = array();
                } else {
                    $detalle = $stmt->fetchAll(PDO::FETCH_OBJ);
                }
                @file_put_contents(__DIR__ . '/../log_venta_dividida_pdf.log', date('Y-m-d H:i:s') . " venta_dividida_imp_pdf: id_venta=" . $id_venta . " items obtenidos de tm_detalle_venta=" . count($detalle) . "\n", FILE_APPEND);
                
                if (count($detalle) === 0) {
                    // Si no se encontraron items con las condiciones, intentar obtener todos los items de la venta para debug
                    $detalle_fallback = $this->db->query("SELECT tm_detalle_venta.id_prod, tm_detalle_venta.precio, tm_detalle_venta.cantidad, tm_detalle_venta.toppings FROM tm_detalle_venta WHERE tm_detalle_venta.id_venta = {$id_venta}")->fetchAll(PDO::FETCH_OBJ);
                    @file_put_contents(__DIR__ . '/../log_venta_dividida_pdf.log', date('Y-m-d H:i:s') . " venta_dividida_imp_pdf: WARNING - No items encontrados con condiciones. Items totales en venta=" . count($detalle_fallback) . " Items: " . json_encode($detalle_fallback) . "\n", FILE_APPEND);
                    
                    // Si hay items en la venta pero no coinciden con las condiciones, usar todos los items de la venta como fallback
                    if (count($detalle_fallback) > 0) {
                        @file_put_contents(__DIR__ . '/../log_venta_dividida_pdf.log', date('Y-m-d H:i:s') . " venta_dividida_imp_pdf: Usando FALLBACK - todos los items de la venta\n", FILE_APPEND);
                        // Reconstruir query sin condiciones para obtener todos los items
                        if ($c->{'Configuracion'}->activated_pres == '1') {
                            $detalle_query_fallback = "SELECT v_productos.pro_cod AS codigo_producto, 
                                v_productos.pro_pre AS nombre_producto, 
                                IF(v_productos.pro_imp='1','10','20') AS codigo_afectacion, 
                                CAST(tm_detalle_venta.cantidad AS DECIMAL(7,2)) AS cantidad, 
                                IF(v_productos.pro_imp='1',ROUND((tm_detalle_venta.precio/(1 + {$c->igv})),2),tm_detalle_venta.precio) AS valor_unitario,
                                tm_detalle_venta.precio AS precio_unitario,
                                IF(v_productos.pro_imp='1',ROUND((tm_detalle_venta.precio/(1 + {$c->igv}))*tm_detalle_venta.cantidad,2),
                                ROUND(tm_detalle_venta.precio*tm_detalle_venta.cantidad,2)) AS valor_venta,
                                IF(v_productos.pro_imp='1',ROUND((tm_detalle_venta.precio/(1 + {$c->igv})*tm_detalle_venta.cantidad)*{$c->igv},2),0) AS total_igv,
                                COALESCE(tm_detalle_venta.desc_monto,0) AS descuento_item,
                                tm_detalle_venta.toppings AS toppings
                                FROM tm_detalle_venta 
                                INNER JOIN tm_venta ON tm_detalle_venta.id_venta = tm_venta.id_venta 
                                INNER JOIN v_productos ON tm_detalle_venta.id_prod = v_productos.id_pres 
                                WHERE tm_venta.id_tipo_doc IN ('1','2','3') AND tm_detalle_venta.precio > 0 AND tm_detalle_venta.id_venta = {$id_venta}";
                        } else {
                            $detalle_query_fallback = "SELECT v_productos.pro_cod AS codigo_producto, 
                                CONCAT(v_productos.pro_nom,' ',v_productos.pro_pre) AS nombre_producto, 
                                IF(v_productos.pro_imp='1','10','20') AS codigo_afectacion, 
                                CAST(tm_detalle_venta.cantidad AS DECIMAL(7,2)) AS cantidad, 
                                IF(v_productos.pro_imp='1',ROUND((tm_detalle_venta.precio/(1 + {$c->igv})),2),tm_detalle_venta.precio) AS valor_unitario,
                                tm_detalle_venta.precio AS precio_unitario,
                                IF(v_productos.pro_imp='1',ROUND((tm_detalle_venta.precio/(1 + {$c->igv}))*tm_detalle_venta.cantidad,2),
                                ROUND(tm_detalle_venta.precio*tm_detalle_venta.cantidad,2)) AS valor_venta,
                                IF(v_productos.pro_imp='1',ROUND((tm_detalle_venta.precio/(1 + {$c->igv})*tm_detalle_venta.cantidad)*{$c->igv},2),0) AS total_igv,
                                COALESCE(tm_detalle_venta.desc_monto,0) AS descuento_item,
                                tm_detalle_venta.toppings AS toppings
                                FROM tm_detalle_venta 
                                INNER JOIN tm_venta ON tm_detalle_venta.id_venta = tm_venta.id_venta 
                                INNER JOIN v_productos ON tm_detalle_venta.id_prod = v_productos.id_pres 
                                WHERE tm_venta.id_tipo_doc IN ('1','2','3') AND tm_detalle_venta.precio > 0 AND tm_detalle_venta.id_venta = {$id_venta}";
                        }
                        $detalle = $this->db->query($detalle_query_fallback)->fetchAll(PDO::FETCH_OBJ);
                        @file_put_contents(__DIR__ . '/../log_venta_dividida_pdf.log', date('Y-m-d H:i:s') . " venta_dividida_imp_pdf: FALLBACK ejecutado, items obtenidos=" . count($detalle) . "\n", FILE_APPEND);
                    }
                } else {
                    @file_put_contents(__DIR__ . '/../log_venta_dividida_pdf.log', date('Y-m-d H:i:s') . " venta_dividida_imp_pdf: Items encontrados: " . json_encode(array_map(function($d){return array('codigo'=>$d->codigo_producto ?? 'N/A', 'cantidad'=>$d->cantidad ?? 0, 'precio'=>$d->precio_unitario ?? 0, 'nombre'=>$d->nombre_producto ?? 'N/A');}, array_slice($detalle, 0, 5))) . "\n", FILE_APPEND);
                }
            } catch (Exception $e) {
                @file_put_contents(__DIR__ . '/../log_venta_dividida_pdf.log', date('Y-m-d H:i:s') . " venta_dividida_imp_pdf: ERROR al ejecutar query: " . $e->getMessage() . "\n", FILE_APPEND);
                $detalle = array();
            }
            
            // Aplicar descuentos guardados por item
            foreach ($detalle as $k => $d) {
                $id_prod = isset($d->id_prod) ? $d->id_prod : null;
                if ($id_prod && isset($descuentos_items[$id_prod]) && floatval($descuentos_items[$id_prod]) > 0) {
                    $detalle[$k]->descuento_item = floatval($descuentos_items[$id_prod]);
                } else {
                    // El campo ya viene como descuento_item desde la consulta
                    $detalle[$k]->descuento_item = isset($d->descuento_item) ? floatval($d->descuento_item) : 0;
                }
            }
            
            $c->{'Detalle'} = $detalle;
            
            $c->{'Pagos'} = $this->db->query("SELECT tp.descripcion AS nombre, COUNT(*) AS cantidad, SUM(vp.monto) AS monto FROM tm_venta_pago AS vp INNER JOIN tm_venta AS v ON v.id_venta = vp.id_venta INNER JOIN tm_tipo_pago AS tp ON vp.id_pago = tp.id_tipo_pago WHERE v.id_venta = {$id_venta} AND vp.monto > 0 AND v.estado = 'a' GROUP BY tp.descripcion;")->fetchAll(PDO::FETCH_OBJ);
            
            if($c->id_tped == '1'){  
            } elseif($c->id_tped == '2'){
                $c->{'Llevar'} = $this->db->query("SELECT * FROM v_pedido_llevar WHERE id_pedido = " . $c->id_ped)->fetch(PDO::FETCH_OBJ);   
            } elseif($c->id_tped == '3'){
                $c->{'Delivery'} = $this->db->query("SELECT * FROM v_pedido_delivery WHERE id_pedido = " . $c->id_ped)->fetch(PDO::FETCH_OBJ);   
            }
            
            // Obtener datos del documento de facturación electrónica si existe
            $c->{'DocumentoFE'} = $this->db->query("SELECT d.*, 
                COALESCE(s.serie, td.serie) as serie_electronica
                FROM tm_facturacion_electronica_documentos d
                LEFT JOIN tm_series_documentos s ON d.id_serie_documento = s.id_serie
                LEFT JOIN tm_venta v ON d.id_venta = v.id_venta
                LEFT JOIN tm_tipo_doc td ON v.id_tipo_doc = td.id_tipo_doc AND d.id_serie_documento IS NULL
                WHERE d.id_venta = " . $id_venta . " LIMIT 1")
                ->fetch(PDO::FETCH_OBJ);
            
            return $c;
        } catch(Exception $e) {
            die($e->getMessage());
        }
    }

    // propinas
    public function venta_propina_list($data)
    {
        try
        {
            if (Session::get('report_date') == '0') {
                $ifecha = date('Y-m-d',strtotime($data['ifecha']));
                $ffecha = date('Y-m-d',strtotime($data['ffecha']));
                $fechas = '(DATE(v.fec_ven) >= ? AND DATE(v.fec_ven) <= ?)';
            } else {
                $ifecha = date('Y-m-d H:i:s',strtotime($data['ifecha']));
                $ffecha = date('Y-m-d H:i:s',strtotime($data['ffecha']));
                $fechas = '(v.fec_ven >= ? AND v.fec_ven <= ?)';
            }

            $stm = $this->db->prepare("SELECT v.id_ven, v.id_ped, v.desc_monto, v.comis_tar, v.comis_del, v.total,
            CASE WHEN v.state_type_id != '11' THEN IF((v.desc_tipo = 1), 0, v.total+v.comis_del+v.comis_tar) ELSE 0 END monto_total,
            v.fec_ven, v.desc_td, CONCAT(v.ser_doc,'-',v.nro_doc) AS numero, v.id_cli, v.igv, v.id_usu, c.desc_caja, v.estado,
            GROUP_CONCAT(vp.id_pago SEPARATOR ', ') AS pagos, v.propina
            FROM v_ventas_con AS v
            INNER JOIN v_caja_aper AS c ON v.id_apc = c.id_apc
            INNER JOIN tm_venta_propina AS vp ON v.id_ven = vp.id_venta
            INNER JOIN tm_pedido AS p ON v.id_ped = p.id_pedido
            INNER JOIN v_usuarios AS u ON p.id_usu = u.id_usu
            WHERE ".$fechas." AND v.state_type_id != '11'
                AND vp.id_pago LIKE ?
                AND v.propina > 0
                AND u.id_usu like ?
            GROUP BY v.id_ven
            ORDER BY DATE(v.fec_ven) ASC
            ");
            $stm->execute(array($ifecha,$ffecha,$data['id_tpag'],$data['id_usu']));
            $c = $stm->fetchAll(PDO::FETCH_OBJ);
            
            foreach($c as $k => $d)
            {
                $c[$k]->{'Cliente'} = $this->db->query("SELECT nombre FROM v_clientes WHERE id_cliente = ".$d->id_cli)->fetch(PDO::FETCH_OBJ);
                $c[$k]->{'Tipopago'} = $this->db->query("SELECT tp.descripcion as nombre, tp.color AS color, vp.monto FROM tm_venta_propina AS vp INNER JOIN tm_venta AS v ON v.id_venta = vp.id_venta INNER JOIN tm_tipo_pago AS tp ON vp.id_pago = tp.id_tipo_pago WHERE vp.monto > 0 AND vp.id_venta =" . $d->id_ven)->fetchAll(PDO::FETCH_OBJ);

                $c[$k]->{'Mozo'} = $this->db->query("SELECT CONCAT(nombres,' ',ape_paterno,' ',ape_materno) AS nombre FROM tm_pedido JOIN v_usuarios ON tm_pedido.id_usu = v_usuarios.id_usu WHERE tm_pedido.id_pedido = ".$d->id_ped)
                ->fetch(PDO::FETCH_OBJ);                

            }

            $pago = $this->db->prepare("SELECT tp.descripcion AS nombre, COUNT(*) AS cantidad, SUM(vp.monto) AS monto FROM tm_venta_pago AS vp INNER JOIN tm_venta AS v ON v.id_venta = vp.id_venta INNER JOIN tm_tipo_pago AS tp ON vp.id_pago = tp.id_tipo_pago WHERE (DATE(v.fecha_venta) >= ? AND DATE(v.fecha_venta) <= ?) AND tp.id_tipo_pago LIKE ? AND vp.monto > 0 AND v.state_type_id != '11' GROUP BY tp.descripcion;");
            $pago->execute(array($ifecha,$ffecha,$data['id_tpag']));
            
            $cpago = $pago->fetchAll(PDO::FETCH_OBJ);
            $data = array("data" => $c, "pago" => $cpago);
            $json = json_encode($data);
            echo $json;       
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    /* FIN MODULO VENTAS */

    /* INICIO MODULO COMPRAS */

    public function compra_all_list($data)
    {
        try
        {
            if (Session::get('report_date') == '0') {
                $ifecha = date('Y-m-d',strtotime($data['ifecha']));
                $ffecha = date('Y-m-d',strtotime($data['ffecha']));
                $fechas = '(DATE(fecha_c) >= ? AND DATE(fecha_c) <= ?)';
            } else {
                $ifecha = date('Y-m-d H:i:s',strtotime($data['ifecha']));
                $ffecha = date('Y-m-d H:i:s',strtotime($data['ffecha']));
                $fechas = '(fecha_c >= ? AND fecha_c <= ?)';
            } 

            $stm = $this->db->prepare("SELECT * FROM v_compras WHERE ".$fechas." AND id_prov LIKE ? AND id_tipo_compra LIKE ? AND id_tipo_doc LIKE ? AND estado LIKE ? GROUP BY id_compra");
            $stm->execute(array($ifecha,$ffecha,$data['id_prov'],$data['id_tipo_compra'],$data['id_tipo_doc'],$data['estado']));
            $c = $stm->fetchAll(PDO::FETCH_OBJ);
            $data = array("data" => $c);
            $json = json_encode($data);
            echo $json;
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function compra_all_det($data)
    {
        try
        {
            $config->{'Configuracion'} = $this->db->query("SELECT * FROM tm_configuracion")->fetch(PDO::FETCH_OBJ);
            
            if ($config->{'Configuracion'}->activated_pres == '1'){
                $stm = $this->db->prepare("SELECT * FROM tm_compra_detalle WHERE id_compra = ?");
                $stm->execute(array($data['id_compra']));
                $c = $stm->fetchAll(PDO::FETCH_OBJ);
                foreach($c as $k => $d)
                {
                    $c[$k]->{'Producto'} = $this->db->query("SELECT *, ins_nom AS nom_ins, pro_pre AS nom_pro_pre FROM v_insprod WHERE id_tipo_ins = ".$d->id_tp."  AND id_ins = ".$d->id_pres)
                        ->fetch(PDO::FETCH_OBJ);
                }
            }else{
                $stm = $this->db->prepare("SELECT * FROM tm_compra_detalle WHERE id_compra = ?");
                $stm->execute(array($data['id_compra']));
                $c = $stm->fetchAll(PDO::FETCH_OBJ);
                foreach($c as $k => $d)
                {
                    $c[$k]->{'Producto'} = $this->db->query("SELECT *, ins_nom AS nom_ins, CONCAT(pro_nom, ' ' , pro_pre) AS nom_pro_pre FROM v_insprod WHERE id_tipo_ins = ".$d->id_tp."  AND id_ins = ".$d->id_pres)
                        ->fetch(PDO::FETCH_OBJ);
                }                
            }

            return $c;
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function compra_all_det_cuota($data)
    {
        try
        {
            $stm = $this->db->prepare("SELECT * FROM tm_compra_credito WHERE id_compra = ?");
            $stm->execute(array($data['id_compra']));
            $c = $stm->fetchAll(PDO::FETCH_OBJ);
            return $c;
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function compra_all_det_subcuota($data)
    {
        try
        {
            $stm = $this->db->prepare("SELECT * FROM tm_credito_detalle WHERE id_credito = ?");
            $stm->execute(array($data['id_credito']));
            $c = $stm->fetchAll(PDO::FETCH_OBJ);
            foreach($c as $k => $d)
            {
                $c[$k]->{'Usuario'} = $this->db->query("SELECT CONCAT(ape_paterno,' ',ape_materno,' ',nombres) AS nombre FROM v_usuarios WHERE id_usu = ".$d->id_usu)
                    ->fetch(PDO::FETCH_OBJ);
            }
            return $c;
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    /* FIN MODULO COMPRAS */

    /* INICIO MODULO FINANZAS */

    public function finanza_arq_list($data)
    {
        try
        {
            if (Session::get('report_date') == '0') {
                $ifecha = date('Y-m-d',strtotime($data['ifecha']));
                $ffecha = date('Y-m-d',strtotime($data['ffecha']));
                $fechas = 'DATE(fecha_aper) >= ? AND DATE(fecha_aper) <= ?';
            } else {
                $ifecha = date('Y-m-d H:i:s',strtotime($data['ifecha']));
                $ffecha = date('Y-m-d H:i:s',strtotime($data['ffecha']));
                $fechas = 'fecha_aper >= ? AND fecha_aper <= ?';
            }

            $stm = $this->db->prepare("SELECT * FROM v_caja_aper WHERE ".$fechas." AND id_usu like ? ORDER BY id_apc DESC");
            $stm->execute(array($ifecha,$ffecha,$data['id_usu']));
            $c = $stm->fetchAll(PDO::FETCH_OBJ);
            $data = array("data" => $c);
            $json = json_encode($data);
            echo $json; 
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function finanza_arq_resumen_default($data)
    {
        try
        {    

            $stm = $this->db->prepare("SELECT v.id_apc,v.id_ped, IFNULL(SUM(v.desc_monto),0) AS descu, IFNULL(SUM(v.comis_tar),0) AS comis_tar, IFNULL(SUM(v.comis_del),0) AS comis_del, IFNULL(SUM(v.total),0) AS total, v.estado FROM v_ventas_con AS v LEFT JOIN tm_pedido_delivery AS d ON v.id_ped = d.id_pedido WHERE v.id_apc = ? AND v.state_type_id != '11' AND (d.id_repartidor IS NULL OR d.id_repartidor = 1 OR d.id_repartidor < 2000)");
            $stm->execute(array($data['cod_ape']));
            $c = $stm->fetch(PDO::FETCH_OBJ);
            $c->{'Apertura'} = $this->db->query("SELECT * FROM v_caja_aper WHERE id_apc = ".$data['cod_ape'])
            ->fetch(PDO::FETCH_OBJ);
            $c->{'Ingresos'} = $this->db->query("SELECT IFNULL(SUM(importe),0) AS total FROM tm_ingresos_adm WHERE id_apc = {$data['cod_ape']} AND estado='a'")->fetch(PDO::FETCH_OBJ);
            $c->{'EgresosA'} = $this->db->query("SELECT IFNULL(SUM(importe),0) AS total FROM v_gastosadm WHERE id_apc = {$data['cod_ape']} AND (id_tg = 1 OR id_tg = 2 OR id_tg = 3 OR id_tg = 5) AND estado='a'")
            ->fetch(PDO::FETCH_OBJ);
            $c->{'EgresosB'} = $this->db->query("SELECT IFNULL(SUM(importe),0) AS total FROM v_gastosadm WHERE id_apc = {$data['cod_ape']} AND id_tg = 4 AND estado='a'")
            ->fetch(PDO::FETCH_OBJ);
            $c->{'Pagos'} = $this->db->query("SELECT tp.descripcion AS nombre, COUNT(*) AS cantidad, SUM(vp.monto) AS monto FROM tm_venta_pago AS vp INNER JOIN tm_venta AS v ON v.id_venta = vp.id_venta INNER JOIN tm_tipo_pago AS tp ON vp.id_pago = tp.id_tipo_pago WHERE v.id_apc = {$data['cod_ape']} AND vp.monto > 0 AND v.state_type_id != '11' GROUP BY tp.descripcion;")
            ->fetchAll(PDO::FETCH_OBJ);  

            $c->{'pago_efe'} = $this->db->query("SELECT SUM(vp.monto) FROM tm_venta_pago AS vp INNER JOIN tm_venta AS v ON v.id_venta = vp.id_venta INNER JOIN tm_tipo_pago AS tp ON vp.id_pago = tp.id_tipo_pago WHERE v.id_apc = {$data['cod_ape']} AND vp.monto > 0 AND vp.id_pago = 1 AND v.state_type_id != '11' GROUP BY tp.descripcion;")->fetch(PDO::FETCH_COLUMN);             


            $c->{'Anulaciones'} = $this->db->query("SELECT COUNT(*) AS cant, SUM(total) total FROM tm_venta WHERE state_type_id = '11' AND id_apc =  {$data['cod_ape']}")
            ->fetch(PDO::FETCH_OBJ);     

            $c->{'RecargoConsumo'} = $this->db->query("SELECT SUM(IFNULL((comis_rc),0)) AS total, COUNT(*) AS cant FROM v_ventas_con  WHERE id_apc =  {$data['cod_ape']} AND state_type_id != '11' AND comis_rc > 0")
            ->fetch(PDO::FETCH_OBJ); 
            
            $c->{'EfectivoPropinas'} = $this->db->query("SELECT SUM(IFNULL((propina),0)) AS total FROM tm_venta  WHERE id_apc =  {$data['cod_ape']} AND state_type_id != '11'")
            ->fetch(PDO::FETCH_OBJ);    

            return $c;
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function finanza_arq_resumen_venta_list($data)
    {
        try
        {   
            if($data['cod_filtro'] == 1){
                $stm = $this->db->prepare("SELECT IFNULL((v.total),0) AS monto_total,v.estado,v.ser_doc,v.nro_doc,v.desc_td,v.desc_monto, v.state_type_id FROM v_ventas_con AS v LEFT JOIN tm_pedido_delivery AS d ON v.id_ped = d.id_pedido WHERE v.id_apc = ? AND v.state_type_id != '11' AND (d.id_repartidor IS NULL OR d.id_repartidor = 1 OR d.id_repartidor < 2000)");
            } else {
                $stm = $this->db->prepare("SELECT IFNULL((v.total),0) AS monto_total,v.estado,v.ser_doc,v.nro_doc,v.desc_td,v.desc_monto, v.state_type_id FROM v_ventas_con AS v LEFT JOIN tm_pedido_delivery AS d ON v.id_ped = d.id_pedido WHERE v.id_apc = ? AND v.state_type_id != '11' AND v.desc_monto <> '0.00' AND (d.id_repartidor IS NULL OR d.id_repartidor = 1 OR d.id_repartidor < 2000)");
            }
            $stm->execute(array($data['cod_ape']));
            $c = $stm->fetchAll(PDO::FETCH_OBJ);
            return $c;
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function finanza_arq_resumen_venta_delivery_list($data)
    {
        try
        {   
            $stm = $this->db->prepare("SELECT IFNULL((v.pago_efe+v.pago_tar),0) AS monto_total,v.estado,v.ser_doc,v.nro_doc,v.desc_td FROM v_ventas_con AS v INNER JOIN tm_pedido_delivery AS d ON v.id_ped = d.id_pedido WHERE v.id_apc = ? AND v.state_type_id != '11'");
            $stm->execute(array($data['cod_ape']));
            $c = $stm->fetchAll(PDO::FETCH_OBJ);
            return $c;
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function finanza_arq_resumen_caja_list_i($data)
    {
        try
        {   
            $stm = $this->db->prepare("SELECT * FROM tm_ingresos_adm WHERE id_apc = ? AND estado = ?");
            $stm->execute(array($data['id_apc'],$data['estado']));
            $c = $stm->fetchAll(PDO::FETCH_OBJ);
            return $c;
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function finanza_arq_resumen_caja_list_e($data)
    {
        try
        {   
            $stm = $this->db->prepare("SELECT * FROM v_gastosadm WHERE id_apc = ? AND estado = ?");
            $stm->execute(array($data['id_apc'],$data['estado']));
            $c = $stm->fetchAll(PDO::FETCH_OBJ);
            return $c;
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function finanza_arq_resumen_productos($data)
    {
        try
        {
            $stm = $this->db->prepare("SELECT d.id_prod,SUM(d.cantidad) AS cantidad, d.precio FROM tm_venta AS v INNER JOIN tm_detalle_venta AS d ON v.id_venta = d.id_venta WHERE v.id_apc = ? AND v.state_type_id != '11' GROUP BY d.id_prod, d.precio ORDER BY cantidad DESC");
            $stm->execute(array($data['id_apc']));
            $c = $stm->fetchAll(PDO::FETCH_OBJ);
            foreach($c as $k => $d)
            {
                $c[$k]->{'Producto'} = $this->db->query("SELECT pro_nom,pro_pre FROM v_productos WHERE id_pres = ".$d->id_prod)
                    ->fetch(PDO::FETCH_OBJ);
            }
            return $c;
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function finanza_arq_resumen_formas_pago($data)
    {
        try
        {    
            $stm = $this->db->query("SELECT tp.descripcion AS nombre, COUNT(*) AS cantidad, SUM(vp.monto) AS monto FROM tm_venta_pago AS vp INNER JOIN tm_venta AS v ON v.id_venta = vp.id_venta INNER JOIN tm_tipo_pago AS tp ON vp.id_pago = tp.id_tipo_pago WHERE v.id_apc = {$data['id_apc']} AND vp.monto > 0 AND v.state_type_id != '11' GROUP BY tp.descripcion;");
            $stm->execute();
            $c = $stm->fetchAll(PDO::FETCH_OBJ);
            return $c;
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }    

    public function finanza_arq_resumen_anulaciones($data)
    {
        try
        {
            $stm = $this->db->prepare("SELECT dp.cant, dp.precio, dp.id_pres FROM tm_detalle_pedido AS dp INNER JOIN tm_pedido AS p ON dp.id_pedido = p.id_pedido WHERE dp.estado = 'z' AND p.id_apc = ?");
            $stm->execute(array($data['cod_ape']));
            $c = $stm->fetchAll(PDO::FETCH_OBJ);
            foreach($c as $k => $d)
            {
                $c[$k]->{'Producto'} = $this->db->query("SELECT pro_nom,pro_pre FROM v_productos WHERE id_pres = ".$d->id_pres)
                    ->fetch(PDO::FETCH_OBJ);
            }
            return $c;
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function finanza_ing_list($data)
    {
        try
        {
            if (Session::get('report_date') == '0') {
                $ifecha = date('Y-m-d',strtotime($data['ifecha']));
                $ffecha = date('Y-m-d',strtotime($data['ffecha']));
                $fechas = '(DATE(fecha_reg) >= ? AND DATE(fecha_reg) <= ?)';
            } else {
                $ifecha = date('Y-m-d H:i:s',strtotime($data['ifecha']));
                $ffecha = date('Y-m-d H:i:s',strtotime($data['ffecha']));
                $fechas = '(fecha_reg >= ? AND fecha_reg <= ?)';
            }

            $stm = $this->db->prepare("SELECT * FROM tm_ingresos_adm WHERE ".$fechas." AND id_usu LIKE ? AND estado LIKE ?");
            $stm->execute(array($ifecha,$ffecha,$data['id_usu'],$data['estado']));
            $c = $stm->fetchAll(PDO::FETCH_OBJ);
            foreach($c as $k => $d)
            {
                $c[$k]->{'Caja'} = $this->db->query("SELECT desc_caja FROM v_caja_aper WHERE id_apc = ".$d->id_apc)
                    ->fetch(PDO::FETCH_OBJ);
            }
            foreach($c as $k => $d)
            {
                $c[$k]->{'Cajero'} = $this->db->query("SELECT CONCAT(nombres,' ',ape_paterno,' ',ape_materno) AS desc_usu FROM tm_usuario WHERE id_usu = ".$d->id_usu)
                    ->fetch(PDO::FETCH_OBJ);
            }
            $data = array("data" => $c);
            $json = json_encode($data);
            echo $json; 
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function finanza_egr_list($data)
    {
        try
        {
            if (Session::get('report_date') == '0') {
                $ifecha = date('Y-m-d',strtotime($data['ifecha']));
                $ffecha = date('Y-m-d',strtotime($data['ffecha']));
                $fechas = '(DATE(fecha_re) >= ? AND DATE(fecha_re) <= ?)';
            } else {
                $ifecha = date('Y-m-d H:i:s',strtotime($data['ifecha']));
                $ffecha = date('Y-m-d H:i:s',strtotime($data['ffecha']));
                $fechas = '(fecha_re >= ? AND fecha_re <= ?)';
            }     

            $stm = $this->db->prepare("SELECT * FROM v_gastosadm WHERE ".$fechas." AND id_tg LIKE ? AND id_usu LIKE ? AND estado LIKE ?");
            $stm->execute(array($ifecha,$ffecha,$data['tipo_gasto'],$data['id_usu'],$data['estado']));
            $c = $stm->fetchAll(PDO::FETCH_OBJ);
            foreach($c as $k => $d)
            {
                $c[$k]->{'Caja'} = $this->db->query("SELECT desc_caja FROM v_caja_aper WHERE id_apc = ".$d->id_apc)
                    ->fetch(PDO::FETCH_OBJ);
            }
            $data = array("data" => $c);
            $json = json_encode($data);
            echo $json; 
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function finanza_rem_list($data)
    {
        try
        {
            if (Session::get('report_date') == '0') {
                $ifecha = date('Y-m-d',strtotime($data['ifecha']));
                $ffecha = date('Y-m-d',strtotime($data['ffecha']));
                $fechas = '(DATE(fecha_re) >= ? AND DATE(fecha_re) <= ?)';
            } else {
                $ifecha = date('Y-m-d H:i:s',strtotime($data['ifecha']));
                $ffecha = date('Y-m-d H:i:s',strtotime($data['ffecha']));
                $fechas = '(fecha_re >= ? AND fecha_re <= ?)';
            } 

            $stm = $this->db->prepare("SELECT id_usu,fecha_re,id_apc,des_tg,desc_usu,desc_per,motivo,importe,estado FROM v_gastosadm WHERE id_tg = 3 AND ".$fechas." AND id_per LIKE ? AND estado LIKE ?");
            $stm->execute(array($ifecha,$ffecha,$data['id_per'],$data['estado']));
            $c = $stm->fetchAll(PDO::FETCH_OBJ);
            foreach($c as $k => $d)
            {
                $c[$k]->{'Caja'} = $this->db->query("SELECT desc_caja FROM v_caja_aper WHERE id_apc = ".$d->id_apc)
                    ->fetch(PDO::FETCH_OBJ);
            }
            $data = array("data" => $c);
            $json = json_encode($data);
            echo $json; 
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function finanza_arq_imp($data,$prod = false)
    {
        try
        {      
            $stm = $this->db->prepare("SELECT * FROM v_caja_aper WHERE id_apc = ?");
            $stm->execute(array($data));
            $c = $stm->fetch(PDO::FETCH_OBJ);

            $c->{'Principal'} = $this->db->query("SELECT v.id_apc,v.id_ped, IFNULL(SUM(v.desc_monto),0) AS descu, IFNULL(SUM(v.comis_tar),0) AS comis_tar, IFNULL(SUM(v.comis_del),0) AS comis_del, IFNULL(SUM(v.total+v.comis_del),0) AS total, v.estado , IFNULL(SUM(v.propina),0) AS propina FROM v_ventas_con AS v LEFT JOIN tm_pedido_delivery AS d ON v.id_ped = d.id_pedido WHERE v.id_apc = {$data} AND v.state_type_id NOT IN ('09', '11')")->fetch(PDO::FETCH_OBJ);

            $c->{'Efectivo'} = $this->db->query("SELECT IF(vp.id_pago = 1,SUM(vp.monto),0) AS total, COUNT(*) AS cant FROM tm_venta AS v INNER JOIN tm_venta_pago AS vp ON v.id_venta = vp.id_venta LEFT JOIN tm_pedido_delivery AS vd ON v.id_pedido = vd.id_pedido WHERE v.id_apc = {$data} AND v.state_type_id NOT IN ('09', '11') AND (vp.id_pago = 1)")->fetch(PDO::FETCH_OBJ);

            $c->{'EfectivoPropinas'} = $this->db->query("SELECT IF(vp.id_pago = 1,SUM(vp.monto),0) AS total, COUNT(*) AS cant FROM tm_venta AS v INNER JOIN tm_venta_propina AS vp ON v.id_venta = vp.id_venta  WHERE v.id_apc = {$data} AND v.state_type_id NOT IN ('09', '11') AND (vp.id_pago = 1)")->fetch(PDO::FETCH_OBJ);            


            $c->{'Pagos'} = $this->db->query("SELECT tp.descripcion AS nombre, COUNT(*) AS cantidad, SUM(vp.monto) AS monto FROM tm_venta_pago AS vp INNER JOIN tm_venta AS v ON v.id_venta = vp.id_venta INNER JOIN tm_tipo_pago AS tp ON vp.id_pago = tp.id_tipo_pago WHERE v.id_apc = {$data} AND vp.monto > 0 AND v.state_type_id NOT IN ('09', '11') GROUP BY tp.descripcion;")->fetchAll(PDO::FETCH_OBJ);  


            $c->{'Ingresos'} = $this->db->query("SELECT IFNULL(SUM(importe),0) AS total FROM tm_ingresos_adm WHERE id_apc = {$data} AND estado='a'")->fetch(PDO::FETCH_OBJ);
            
            $c->{'Egresos'} = $this->db->query("SELECT IFNULL(SUM(importe),0) AS total FROM v_gastosadm WHERE id_apc = {$data} AND (id_tg = 1 OR id_tg = 2 OR id_tg = 3 OR id_tg = 4 OR id_tg = 5) AND estado='a'")->fetch(PDO::FETCH_OBJ);

            $c->{'EgresosA'} = $this->db->query("SELECT IFNULL(SUM(importe),0) AS total FROM v_gastosadm WHERE id_apc = {$data} AND id_tg = 1 AND estado='a'")->fetch(PDO::FETCH_OBJ);

            $c->{'EgresosB'} = $this->db->query("SELECT IFNULL(SUM(importe),0) AS total FROM v_gastosadm WHERE id_apc = {$data} AND id_tg = 2 AND estado='a'")->fetch(PDO::FETCH_OBJ);

            $c->{'EgresosC'} = $this->db->query("SELECT IFNULL(SUM(importe),0) AS total FROM v_gastosadm WHERE id_apc = {$data} AND id_tg = 3 AND estado='a'")->fetch(PDO::FETCH_OBJ);

            $c->{'EgresosD'} = $this->db->query("SELECT IFNULL(SUM(importe),0) AS total FROM v_gastosadm WHERE id_apc = {$data} AND id_tg = 4 AND estado='a'")->fetch(PDO::FETCH_OBJ);

            $c->{'EgresosE'} = $this->db->query("SELECT IFNULL(SUM(importe),0) AS total FROM v_gastosadm WHERE id_apc = {$data} AND id_tg = 5 AND estado='a'")->fetch(PDO::FETCH_OBJ);

            $c->{'Descuentos'} = $this->db->query("SELECT COUNT(id_ven) AS cant, SUM(desc_monto) AS total FROM v_ventas_con WHERE id_apc = {$data} AND desc_monto > '0.00' AND desc_tipo = 2 AND state_type_id NOT IN ('09', '11')")->fetch(PDO::FETCH_OBJ);

            $c->{'Cortesias'} = $this->db->query("SELECT COUNT(id_ven) AS cant, SUM(desc_monto) total FROM v_ventas_con WHERE id_apc = {$data} AND desc_tipo = 1 AND state_type_id NOT IN ('09', '11')")->fetch(PDO::FETCH_OBJ);   

            $c->{'ComisionDelivery'} = $this->db->query("SELECT COUNT(id_ven) AS cant FROM v_ventas_con WHERE id_apc = {$data} AND id_tped = 3 AND state_type_id NOT IN ('09', '11')")->fetch(PDO::FETCH_OBJ);

            $c->{'CreditoPersonal'} = $this->db->query("SELECT COUNT(id_ven) AS cant, SUM(desc_monto) total FROM v_ventas_con WHERE id_apc = {$data} AND desc_tipo = 3 AND state_type_id NOT IN ('09', '11')")->fetch(PDO::FETCH_OBJ);            

            $c->{'Anulaciones'} = $this->db->query("SELECT COUNT(*) AS cant, SUM(total) total FROM tm_venta WHERE state_type_id = '11' AND id_apc = {$data}")->fetch(PDO::FETCH_OBJ); 

            $c->{'Rechazados'} = $this->db->query("SELECT COUNT(*) AS cant, SUM(total) total FROM tm_venta WHERE state_type_id = '09' AND id_apc = {$data}")->fetch(PDO::FETCH_OBJ);     

            $c->{'Deliverys'} = $this->db->query("SELECT SUM(IFNULL((v.total),0)) AS total, COUNT(*) AS cant FROM v_ventas_con AS v INNER JOIN tm_pedido_delivery AS d ON v.id_ped = d.id_pedido WHERE v.id_apc = {$data} AND v.state_type_id NOT IN ('09', '11')")->fetch(PDO::FETCH_OBJ);   

            $c->{'RecargoConsumo'} = $this->db->query("SELECT SUM(IFNULL((comis_rc),0)) AS total, COUNT(*) AS cant FROM v_ventas_con  WHERE id_apc = {$data} AND state_type_id NOT IN ('09', '11') AND comis_rc > 0")->fetch(PDO::FETCH_OBJ);     

            $c->{'ComisionTarjeta'} = $this->db->query("SELECT SUM(IFNULL((comis_tar),0)) AS total, COUNT(*) AS cant FROM v_ventas_con  WHERE id_apc = {$data} AND state_type_id NOT IN ('09', '11') AND id_tpag = '2' AND comis_tar > 0")->fetch(PDO::FETCH_OBJ);           

            $c->{'PollosVendidos'} = $this->db->query("SELECT p.id_pres,p.pro_nom,p.pro_pre,dv.precio,SUM(dv.cantidad) AS cantidad, i.cant FROM tm_detalle_venta AS dv INNER JOIN tm_venta AS v ON dv.id_venta = v.id_venta INNER JOIN v_productos AS p ON dv.id_prod = p.id_pres INNER JOIN tm_producto_ingr AS i ON dv.id_prod = i.id_pres WHERE v.id_apc = {$data} AND v.state_type_id != '11' AND i.id_ins = 1 AND p.pro_mar = 1 GROUP BY dv.id_prod, dv.precio ORDER BY total DESC")->fetchAll(PDO::FETCH_OBJ);

            $c->{'PolloStock'} = $this->db->query("SELECT (ent-sal) AS total FROM v_stock WHERE id_tipo_ins = 1 AND id_ins = 1")
            ->fetch(PDO::FETCH_OBJ);
                   
            $c->{'Configuracion'} = $this->db->query("SELECT * FROM tm_configuracion")
                ->fetch(PDO::FETCH_OBJ);
            // Verificar si la consulta retorna resultados
            //var_dump($c->{'Configuracion'}); 
            //var_dump($c->{'Configuracion'}->activated_pres);                   
                   
            $c->{'Detalle'} = $this->db->query("SELECT d.id_prod,SUM(d.cantidad) AS cantidad, d.precio FROM tm_venta AS v INNER JOIN tm_detalle_venta AS d ON v.id_venta = d.id_venta WHERE v.id_apc = {$data} AND state_type_id NOT IN ('09', '11') GROUP BY d.id_prod, d.precio ORDER BY 2 DESC")
                ->fetchAll(PDO::FETCH_OBJ);
                
            if ($c->{'Configuracion'}->activated_pres == '1'){
                foreach($c->Detalle as $k => $d)
                {
                    $c->Detalle[$k]->{'Producto'} = $this->db->query("SELECT pro_cat, pro_pre FROM v_productos WHERE id_pres = " . $d->id_prod)
                        ->fetch(PDO::FETCH_OBJ);
                }                
            }
            else{
                foreach($c->Detalle as $k => $d)
                {
                    $c->Detalle[$k]->{'Producto'} = $this->db->query("SELECT pro_cat, pro_nom, pro_pre FROM v_productos WHERE id_pres = " . $d->id_prod)
                        ->fetch(PDO::FETCH_OBJ);
                }                  
            }    

            
            $c->{'Prod'} = (Session::get('caja_prod_sep') == 1)?$prod : 'mostrar';  

            return $c;
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function finanza_adel_list_a($data)
    {
        try
        {
            if (Session::get('report_date') == '0') {
                $ifecha = date('Y-m-d',strtotime($data['ifecha']));
                $ffecha = date('Y-m-d',strtotime($data['ffecha']));
                $fechas = '(DATE(fecha_re) >= ? AND DATE(fecha_re) <= ?)';
            } else {
                $ifecha = date('Y-m-d H:i:s',strtotime($data['ifecha']));
                $ffecha = date('Y-m-d H:i:s',strtotime($data['ffecha']));
                $fechas = '(fecha_re >= ? AND fecha_re <= ?)';
            }
            $stm = $this->db->prepare("SELECT * FROM v_gastosadm WHERE ".$fechas." AND id_per = ? AND id_tg = 3 AND estado = 'a'");
            $stm->execute(array($ifecha,$ffecha,$data['id_personal']));
            $c = $stm->fetchAll(PDO::FETCH_OBJ);
            $data = array("data" => $c);
            $json = json_encode($data);
            echo $json; 
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function finanza_adel_list_b($data)
    {
        try
        {
            if (Session::get('report_date') == '0') {
                $ifecha = date('Y-m-d',strtotime($data['ifecha']));
                $ffecha = date('Y-m-d',strtotime($data['ffecha']));
                $fechas = '(DATE(fec_ven) >= ? AND DATE(fec_ven) <= ?)';
            } else {
                $ifecha = date('Y-m-d H:i:s',strtotime($data['ifecha']));
                $ffecha = date('Y-m-d H:i:s',strtotime($data['ffecha']));
                $fechas = '(fec_ven >= ? AND fec_ven <= ?)';
            }   

            $stm = $this->db->prepare("SELECT *, (total + comis_del - desc_monto) AS total_venta FROM v_ventas_con WHERE ".$fechas." AND desc_personal = ? AND desc_tipo = 3 AND state_type_id != '11'");
            $stm->execute(array($ifecha,$ffecha,$data['id_personal']));
            $c = $stm->fetchAll(PDO::FETCH_OBJ);
            $data = array("data" => $c);
            $json = json_encode($data);
            echo $json; 
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    /* FIN MODULO FINANZAS */
/* INICIO MODULO INVENTARIO */

    public function inventario_kardex_list()
    {
        try
        {
            $tipo_ip = $_POST['tipo_ip'];
            $id_ip = $_POST['id_ip'];

            if (Session::get('report_date') == '0') {
                $ifecha = date('Y-m-d',strtotime($_POST['ifecha']));
                $ffecha = date('Y-m-d',strtotime($_POST['ffecha']));
                $fechas = '(DATE(fecha_r) >= ? AND DATE(fecha_r) <= ?)';
            } else {
                $ifecha = date('Y-m-d H:i:s',strtotime($_POST['ifecha']));
                $ffecha = date('Y-m-d H:i:s',strtotime($_POST['ffecha']));
                $fechas = '(fecha_r >= ? AND fecha_r <= ?)';
            }          

            $stm = $this->db->prepare("SELECT id_inv,id_tipo_ope,id_ope,id_tipo_ins,id_ins,cos_uni,cant,fecha_r,estado,
                    IF(id_tipo_ope = 1 OR id_tipo_ope = 3,FORMAT(cant,6),0) AS cantidad_entrada, 
                    IF(id_tipo_ope = 1 OR id_tipo_ope = 3,cos_uni,0) AS costo_entrada, 
                    IF(id_tipo_ope = 1 OR id_tipo_ope = 3,(cant*cos_uni),0) AS total_entrada, 
                    IF(id_tipo_ope = 2 OR id_tipo_ope = 4,FORMAT(cant,6),0) AS cantidad_salida, 
                    IF(id_tipo_ope = 2 OR id_tipo_ope = 4,cos_uni,'-') AS costo_salida, 
                    IF(id_tipo_ope = 2 OR id_tipo_ope = 4,(cant*cos_uni),0) AS total_salida
                FROM tm_inventario WHERE id_tipo_ins = ? AND id_ins = ? AND ".$fechas." ");
            $stm->execute(array($tipo_ip,$id_ip,$ifecha,$ffecha));
            $c = $stm->fetchAll(PDO::FETCH_OBJ);
            foreach($c as $k => $d)
            {
                $c[$k]->{'Precio'} = $this->db->query("SELECT ROUND(AVG(cos_uni),2) AS cos_pro FROM tm_inventario WHERE id_tipo_ins = ".$d->id_tipo_ins." AND id_ins = ".$d->id_ins)
                    ->fetch(PDO::FETCH_OBJ);

                $c[$k]->{'Medida'} = $this->db->query("SELECT ins_med FROM v_insprod WHERE id_tipo_ins = ".$d->id_tipo_ins." AND id_ins = ".$d->id_ins)
                    ->fetch(PDO::FETCH_OBJ);

                $c[$k]->{'Stock'} = $this->db->query("SELECT SUM(ent - sal) AS total FROM v_stock WHERE id_tipo_ins = ".$tipo_ip." AND id_ins = ".$id_ip)
                    ->fetch(PDO::FETCH_OBJ);

                if($d->id_tipo_ope == 1){
                    $c[$k]->{'Comp'} = $this->db->query("SELECT serie_doc AS ser_doc,num_doc AS nro_doc,desc_td FROM v_compras WHERE id_compra = ".$d->id_ope)
                    ->fetch(PDO::FETCH_OBJ);
                } else if($d->id_tipo_ope == 2){
                    $c[$k]->{'Comp'} = $this->db->query("SELECT ser_doc,nro_doc,desc_td FROM v_ventas_con WHERE id_ven = ".$d->id_ope)
                    ->fetch(PDO::FETCH_OBJ);
                } else if($d->id_tipo_ope == 3 OR $d->id_tipo_ope == 4){
                    $c[$k]->{'Comp'} = $this->db->query("SELECT i.motivo, CONCAT(u.nombres,' ',u.ape_paterno,' ',u.ape_materno) AS responsable FROM tm_inventario_entsal AS i INNER JOIN tm_usuario AS u ON i.id_responsable = u.id_usu WHERE i.id_es = ".$d->id_ope)
                    ->fetch(PDO::FETCH_OBJ);
                }
            }
            
            $data = array("data" => $c);
            $json = json_encode($data);
            echo $json; 
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function inventario_ComboInsumoProducto($data)
    {
        try
        {   
            $config->{'Configuracion'} = $this->db->query("SELECT * FROM tm_configuracion")->fetch(PDO::FETCH_OBJ);

            $stmm = $this->db->prepare("SELECT *, id_ins,ins_cod,ins_nom,ins_cat,pro_nom, pro_pre FROM v_insprod WHERE id_tipo_ins = ? AND est_b = 'a' AND est_c = 'a'");
            $stmm->execute(array($data['id_tipo_ins']));
            $var = $stmm->fetchAll(PDO::FETCH_ASSOC);

            if ($config->{'Configuracion'}->activated_pres == '1'){
                foreach($var as $v){
                    $insNom = $v['ins_nom'] ?? $v['pro_pre']; // Si ins_nom es null, usa pro_pre
                    echo '<option value="'.$v['id_ins'].'">'.$v['ins_cod'].' | '.$v['ins_cat'].' | '.$insNom.'</option>';
                }                
            }else{
                foreach($var as $v){
                    if ($v['ins_nom'] === null) {
                        $insNom = ($v['pro_nom'] ?? '') . ' ' . ($v['pro_pre'] ?? ''); // Concatenar pro_nom y pro_pre
                    } else {
                        $insNom = $v['ins_nom'];
                    }
                    echo '<option value="'.$v['id_ins'].'">'.$v['ins_cod'].' | '.$v['ins_cat'].' | '.$insNom.'</option>';
                }                
            }
          
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }
    
    public function oper_cont_comensal_list($data)
    {
        try
        {
            // $ifecha = date('Y-m-d',strtotime($data['ifecha']));
            // $ffecha = date('Y-m-d',strtotime($data['ffecha']));

            if (Session::get('report_date') == '0') {
                $ifecha = date('Y-m-d',strtotime($_POST['ifecha']));
                $ffecha = date('Y-m-d',strtotime($_POST['ffecha']));
                $fechas = '(DATE(v.fecha_inicio) >= ? AND DATE(v.fecha_inicio) <= ?)';
            } else {
                $ifecha = date('Y-m-d H:i:s',strtotime($_POST['ifecha']));
                $ffecha = date('Y-m-d H:i:s',strtotime($_POST['ffecha']));
                $fechas = '(v.fecha_inicio >= ? AND v.fecha_inicio <= ?)';
            }          



            // $query = $this->db->prepare("SELECT DATE(cc.fecha_inicio) AS y, SUM(cc.nro_personas) AS a FROM tm_contador_comensales AS cc WHERE (DATE(cc.fecha_inicio) >= ? AND DATE(cc.fecha_inicio) <= ?) GROUP BY DATE(cc.fecha_inicio) ORDER BY cc.fecha_inicio DESC");

            $query = $this->db->prepare("SELECT v.fecha_inicio AS fecha_inicio,v.fecha_fin AS fecha_fin, v.nro_personas AS comensales, TIMESTAMPDIFF(SECOND, v.fecha_inicio, v.fecha_fin) AS time_promedio FROM tm_contador_comensales AS v WHERE ".$fechas." ORDER BY v.fecha_inicio DESC");
            $query->execute(array($ifecha,$ffecha));
            $a = $query->fetchAll(PDO::FETCH_OBJ);

            $data = array("data" => $a);
            $json = json_encode($data);
            echo $json;
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function oper_cont_comensal_graphic($data)
    {
        try
        {

            if (Session::get('report_date') == '0') {
                $ifecha = date('Y-m-d',strtotime($_POST['ifecha']));
                $ffecha = date('Y-m-d',strtotime($_POST['ffecha']));
                $fechas = '(DATE(cc.fecha_inicio) >= ? AND DATE(cc.fecha_inicio) <= ?)';
            } else {
                $ifecha = date('Y-m-d H:i:s',strtotime($_POST['ifecha']));
                $ffecha = date('Y-m-d H:i:s',strtotime($_POST['ffecha']));
                $fechas = '(cc.fecha_inicio >= ? AND cc.fecha_inicio <= ?)';
            }          

            // $ifecha = date('Y-m-d',strtotime($data['ifecha']));
            // $ffecha = date('Y-m-d',strtotime($data['ffecha']));

            $query = $this->db->prepare("SELECT DATE(cc.fecha_inicio) AS y, SUM(cc.nro_personas) AS a FROM tm_contador_comensales AS cc WHERE ".$fechas." GROUP BY DATE(cc.fecha_inicio) ORDER BY cc.fecha_inicio DESC");

            $query->execute(array($ifecha,$ffecha));
            $a = $query->fetchAll(PDO::FETCH_OBJ);

            $data = array('data' => $a);
            $json = json_encode($data);
            echo $json;
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    } 

    public function oper_anul_list($data)
    {
        try
        {
            // $ifecha = date('Y-m-d H:i:s',strtotime($data['ifecha']));
            // $ffecha = date('Y-m-d H:i:s',strtotime($data['ffecha']));
            $config->{'Configuracion'} = $this->db->query("SELECT * FROM tm_configuracion")->fetch(PDO::FETCH_OBJ);
            
            if (Session::get('report_date') == '0') {
                $ifecha = date('Y-m-d',strtotime($_POST['ifecha']));
                $ffecha = date('Y-m-d',strtotime($_POST['ffecha']));
                $fechas = '(DATE(fecha_pedido) >= ? AND DATE(fecha_pedido) <= ?)';
            } else {
                $ifecha = date('Y-m-d H:i:s',strtotime($_POST['ifecha']));
                $ffecha = date('Y-m-d H:i:s',strtotime($_POST['ffecha']));
                $fechas = '(fecha_pedido >= ? AND fecha_pedido <= ?)';
            }    
            
            if ($config->{'Configuracion'}->activated_pres == '1'){
                $stm = $this->db->prepare("SELECT *,(cant*precio) AS total  FROM tm_detalle_pedido WHERE ".$fechas." AND id_usu like ? AND estado = 'z'");
                $stm->execute(array($ifecha,$ffecha,$data['id_usu']));
                $c = $stm->fetchAll(PDO::FETCH_OBJ);
                foreach($c as $k => $d)
                {
                    $c[$k]->{'Personal'} = $this->db->query("SELECT id_usu,CONCAT(ape_paterno,' ',ape_materno,' ',nombres) AS nombres FROM tm_usuario WHERE id_usu = ".$d->id_usu)->fetch(PDO::FETCH_OBJ);
                    $c[$k]->{'TipoPedido'} = $this->db->query("SELECT * FROM tm_pedido WHERE id_pedido = ".$d->id_pedido)->fetch(PDO::FETCH_OBJ);
                    $c[$k]->{'Producto'} = $this->db->query("SELECT *, pro_pre AS nombre_producto FROM v_productos WHERE id_pres = ".$d->id_pres)->fetch(PDO::FETCH_OBJ);
    
                }                
            }else{
                $stm = $this->db->prepare("SELECT *,(cant*precio) AS total  FROM tm_detalle_pedido WHERE ".$fechas." AND id_usu like ? AND estado = 'z'");
                $stm->execute(array($ifecha,$ffecha,$data['id_usu']));
                $c = $stm->fetchAll(PDO::FETCH_OBJ);
                foreach($c as $k => $d)
                {
                    $c[$k]->{'Personal'} = $this->db->query("SELECT id_usu,CONCAT(ape_paterno,' ',ape_materno,' ',nombres) AS nombres FROM tm_usuario WHERE id_usu = ".$d->id_usu)->fetch(PDO::FETCH_OBJ);
                    $c[$k]->{'TipoPedido'} = $this->db->query("SELECT * FROM tm_pedido WHERE id_pedido = ".$d->id_pedido)->fetch(PDO::FETCH_OBJ);
                    $c[$k]->{'Producto'} = $this->db->query("SELECT *, CONCAT(pro_nom, ' ' , pro_pre) AS nombre_producto FROM v_productos WHERE id_pres = ".$d->id_pres)->fetch(PDO::FETCH_OBJ);
    
                }                
            }


            $data = array("data" => $c);
            $json = json_encode($data);
            echo $json;       
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function oper_anul_ticket($data)
    {
        try
        {
            // $ifecha = date('Y-m-d H:i:s',strtotime($data['ifecha']));
            // $ffecha = date('Y-m-d H:i:s',strtotime($data['ffecha']));
            
            $config->{'Configuracion'} = $this->db->query("SELECT * FROM tm_configuracion")->fetch(PDO::FETCH_OBJ);

            if (Session::get('report_date') == '0') {
                $ifecha = date('Y-m-d',strtotime($_POST['ifecha']));
                $ffecha = date('Y-m-d',strtotime($_POST['ffecha']));
                $fechas = '(DATE(fecha_pedido) >= ? AND DATE(fecha_pedido) <= ?)';
            } else {
                $ifecha = date('Y-m-d H:i:s',strtotime($_POST['ifecha']));
                $ffecha = date('Y-m-d H:i:s',strtotime($_POST['ffecha']));
                $fechas = '(fecha_pedido >= ? AND fecha_pedido <= ?)';
            }    

            if ($config->{'Configuracion'}->activated_pres == '1'){
                $stm = $this->db->prepare("SELECT *,(cant*precio) AS total  FROM tm_detalle_pedido WHERE ".$fechas." AND id_usu like ? AND estado = 'z'");
                $stm->execute(array($ifecha,$ffecha,$data['id_usu']));
                $c = $stm->fetchAll(PDO::FETCH_OBJ);
                foreach($c as $k => $d)
                {
                    $c[$k]->{'Personal'} = $this->db->query("SELECT id_usu,CONCAT(ape_paterno,' ',ape_materno,' ',nombres) AS nombres FROM tm_usuario WHERE id_usu = ".$d->id_usu)->fetch(PDO::FETCH_OBJ);
                    $c[$k]->{'TipoPedido'} = $this->db->query("SELECT * FROM tm_pedido WHERE id_pedido = ".$d->id_pedido)->fetch(PDO::FETCH_OBJ);
                    $c[$k]->{'Producto'} = $this->db->query("SELECT *, pro_pre AS nombre_producto FROM v_productos WHERE id_pres = ".$d->id_pres)->fetch(PDO::FETCH_OBJ);
    
                }                
            }else{
                $stm = $this->db->prepare("SELECT *,(cant*precio) AS total  FROM tm_detalle_pedido WHERE ".$fechas." AND id_usu like ? AND estado = 'z'");
                $stm->execute(array($ifecha,$ffecha,$data['id_usu']));
                $c = $stm->fetchAll(PDO::FETCH_OBJ);
                foreach($c as $k => $d)
                {
                    $c[$k]->{'Personal'} = $this->db->query("SELECT id_usu,CONCAT(ape_paterno,' ',ape_materno,' ',nombres) AS nombres FROM tm_usuario WHERE id_usu = ".$d->id_usu)->fetch(PDO::FETCH_OBJ);
                    $c[$k]->{'TipoPedido'} = $this->db->query("SELECT * FROM tm_pedido WHERE id_pedido = ".$d->id_pedido)->fetch(PDO::FETCH_OBJ);
                    $c[$k]->{'Producto'} = $this->db->query("SELECT *, CONCAT(pro_nom, ' ' , pro_pre) AS nombre_producto FROM v_productos WHERE id_pres = ".$d->id_pres)->fetch(PDO::FETCH_OBJ);
    
                }                
            }


            return  $c;       
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }    

    public function clientes_birthday_list($data)
    {
        try
        {
            $mes = $data['mes'];
            $search = ($data['mes'] == '%') ? 'WHERE tipo_cliente = 1': 'WHERE MONTH(fecha_nac) = ? and tipo_cliente = 1';

            $query = $this->db->prepare("SELECT * FROM v_clientes ".$search);
            $query->execute(array($mes));
            $a = $query->fetchAll(PDO::FETCH_OBJ);

            $data = array("data" => $a);
            $json = json_encode($data);
            echo $json;
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function reporte_mesas_salones_list($data)
    {
        try
        {
            // $ifecha = date('Y-m-d H:i:s',strtotime($_POST['ifecha']));
            // $ffecha = date('Y-m-d H:i:s',strtotime($_POST['ffecha']));

            if (Session::get('report_date') == '0') {
                $ifecha = date('Y-m-d',strtotime($_POST['ifecha']));
                $ffecha = date('Y-m-d',strtotime($_POST['ffecha']));
                $fechas = '(DATE(v_ventas_con.fec_ven) >= ? AND DATE(v_ventas_con.fec_ven) <= ?)';
            } else {
                $ifecha = date('Y-m-d H:i:s',strtotime($_POST['ifecha']));
                $ffecha = date('Y-m-d H:i:s',strtotime($_POST['ffecha']));
                $fechas = '(v_ventas_con.fec_ven >= ? AND v_ventas_con.fec_ven <= ?)';
            }    
            
            $query = $this->db->prepare("SELECT v_mesas.id_mesa, COUNT(tm_pedido_mesa.id_pedido) AS cantidad_ventas, SUM(CASE WHEN v_ventas_con.estado = 'a' THEN v_ventas_con.total ELSE 0 END) AS total_ventas, v_mesas.nro_mesa,v_mesas.desc_salon FROM v_mesas LEFT JOIN tm_pedido_mesa ON v_mesas.id_mesa = tm_pedido_mesa.id_mesa LEFT JOIN v_ventas_con ON tm_pedido_mesa.id_pedido = v_ventas_con.id_ped WHERE ".$fechas." AND v_mesas.id_salon LIKE ? and v_mesas.id_mesa LIKE ? GROUP BY v_mesas.id_mesa");
            $query->execute(array($ifecha, $ffecha, $_POST['filtro_zona'], $_POST['filtro_mesas']));
            $a = $query->fetchAll(PDO::FETCH_OBJ);

            $data = array("data" => $a);
            $json = json_encode($data);
            echo $json;
            
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }


}