<?php Session::init(); ?>
<?php

class Ajuste_Model extends Model
{
	public function __construct()
	{
		parent::__construct();
	}

    public function AreaProduccion()
    {
        try
        {      
            return $this->db->selectAll('SELECT * FROM tm_area_prod WHERE estado = "a"');
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function Rol()
    {
        try
        {      
            return $this->db->selectAll('SELECT * FROM tm_rol WHERE id_rol <> 1');
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function UnidadMedida()
    {
        try
        {      
            return $this->db->selectAll('SELECT * FROM tm_tipo_medida');
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function Impresora()
    {
        try
        {      
            return $this->db->selectAll('SELECT * FROM tm_impresora WHERE estado = "a"');
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }
    public function usuario_mozo()
    {
        try
        {      
            return $this->db->selectAll("SELECT * FROM `tm_usuario` WHERE `id_rol` = 5 AND estado = 'a';");
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }


    /* INICIO MODULO EMPRESA */

	public function datosempresa_data()
    {
        try
        {    
            $stm = $this->db->prepare("SELECT * FROM tm_empresa");
            $stm->execute();
            $c = $stm->fetch(PDO::FETCH_OBJ);
            return $c;
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    /** Provincias de Panamá (para ubicación PP-DD-CC) */
    public function getProvinciasPanama()
    {
        try {
            $stm = $this->db->query("SELECT id, codigo, nombre FROM tm_provincia_panama ORDER BY codigo");
            return $stm->fetchAll(PDO::FETCH_OBJ);
        } catch (Exception $e) {
            return array();
        }
    }

    /** Distritos por provincia */
    public function getDistritosPanama($id_provincia)
    {
        try {
            $stm = $this->db->prepare("SELECT id, codigo, nombre FROM tm_distrito_panama WHERE id_provincia = ? ORDER BY codigo");
            $stm->execute(array($id_provincia));
            return $stm->fetchAll(PDO::FETCH_OBJ);
        } catch (Exception $e) {
            return array();
        }
    }

    /** Corregimientos por distrito */
    public function getCorregimientosPanama($id_distrito)
    {
        try {
            $stm = $this->db->prepare("SELECT id, codigo, nombre FROM tm_corregimiento_panama WHERE id_distrito = ? ORDER BY codigo");
            $stm->execute(array($id_distrito));
            return $stm->fetchAll(PDO::FETCH_OBJ);
        } catch (Exception $e) {
            return array();
        }
    }

    public function datosempresa_crud($data)
    {
        try 
        {                 
            if($data['usuid'] == 1){

                if( !empty( $_FILES['imagen']['name'] ) ){
                    switch ($_FILES['imagen']['type']) 
                    { 
                        case 'image/jpeg': 
                        $ext = "jpg"; 
                        break;
                        case 'image/gif': 
                        $ext = "gif"; 
                        break; 
                        case 'image/png': 
                        $ext = "png"; 
                        break;
                    }
                    $imagen = $data['ruc'].'.'.$ext;
                    move_uploaded_file ($_FILES['imagen']['tmp_name'], 'public/images/'.$imagen);
                    $data['logo'] =  $imagen;
                } else {
                    $imagen = $data['imagen'];
    
                }

                $directoriobeta         = 'api_fact/UBL21/archivos_xml_sunat/certificados/beta/'.$data['ruc'];
                $directorioproduccion   = 'api_fact/UBL21/archivos_xml_sunat/certificados/produccion/'.$data['ruc'];
                $cpeproduccion          = 'api_fact/UBL21/archivos_xml_sunat/cpe_xml/produccion/'.$data['ruc'];
                $cpebeta                = 'api_fact/UBL21/archivos_xml_sunat/cpe_xml/beta/'.$data['ruc'];
                
                if (!file_exists($directorioproduccion)) mkdir($directorioproduccion, 0777, true);
                if (!file_exists($cpeproduccion)) mkdir($cpeproduccion, 0777, true); 
                if (!file_exists($directoriobeta)) mkdir($directoriobeta, 0777, true); 
                if (!file_exists($cpebeta)) mkdir($cpebeta, 0777, true);



        
                // subir certifico pfx 
                if(!empty( $_FILES['file_certificado']['name'] )){
    
                    $directoriobeta         = 'api_fact/UBL21/archivos_xml_sunat/certificados/beta/'.$data['ruc'];
                    $directorioproduccion   = 'api_fact/UBL21/archivos_xml_sunat/certificados/produccion/'.$data['ruc'];
    
                    if (file_exists($directorioproduccion)) {
                        // mkdir($directorioproduccion, 0777, true);
                        $urlsproduccion = 'api_fact/UBL21/archivos_xml_sunat/certificados/produccion/'.$data['ruc'].'/'.$data['ruc'].'.pfx';
                        if(move_uploaded_file($_FILES['file_certificado']['tmp_name'], $urlsproduccion)){
                            $cpeproduccion ='api_fact/UBL21/archivos_xml_sunat/cpe_xml/produccion/'.$data['ruc'];
                                // mkdir($cpeproduccion, 0777, true);
                                // mkdir($directoriobeta, 0777, true);
                            $urlsbeta         = 'api_fact/UBL21/archivos_xml_sunat/certificados/beta/'.$data['ruc'].'/'.$data['ruc'].'.pfx';
                            if(copy($urlsproduccion, $urlsbeta)){
                                $cpebeta ='api_fact/UBL21/archivos_xml_sunat/cpe_xml/beta/'.$data['ruc'];
                                // mkdir($cpebeta, 0777, true);
                            }
                        }
                    }   
                }

                $sql = "UPDATE tm_empresa SET ruc = ?,razon_social  = ?, nombre_comercial = ?, direccion_comercial = ?, direccion_fiscal = ?, celular = ?, ubigeo = ?, departamento = ?, provincia = ?, distrito = ?, usuariosol = ?, clavesol = ?, clavecertificado = ?, client_id = ?, client_secret = ?, logo = ?, sunat = ?, modo = ?, ose = ?, ose_url = ?, send_document_to_pse = ?, url_login_pse = ?, user_pse = ?, password_pse = ?, url_send_cdr_pse = ?, url_signature_pse = ?, pdf_logo = ?, pdf_rz = ?, pdf_nc = ?, pdf_dc = ?, pdf_ruc = ?, pdf_tel = ?";
                $this->db->prepare($sql)->execute(array(
                    $data['ruc'],
                    $data['razon_social'],
                    $data['nombre_comercial'],
                    $data['direccion_comercial'],
                    $data['direccion_fiscal'],
                    $data['celular'],
                    $data['ubigeo'],
                    $data['departamento'],
                    $data['provincia'],
                    $data['distrito'],
                    $data['usuariosol'],
                    $data['clavesol'],
                    $data['clavecertificado'],
                    $data['client_id'],
                    $data['client_secret'],
                    $imagen,
                    $data['sunat'],
                    $data['modo'],
                    $data['hidden_ose'],
                    $data['ose_url'],
                    $data['hidden_pse'],
                    $data['url_pse'],
                    $data['usuario_pse'],
                    $data['contra_pse'],
                    $data['cdr_pse'],
                    $data['xml_pse'],
                    $data['hidden_pdf_logo'],
                    $data['hidden_pdf_rz'],
                    $data['hidden_pdf_nc'],
                    $data['hidden_pdf_dc'],
                    $data['hidden_pdf_ruc'],
                    $data['hidden_pdf_tel']                    
                ));


                Session::set('sunat', $data['sunat']);
                Session::set('modo', $data['modo']);
                Session::set('ose', $data['hidden_ose']);
                Session::set('ose_url', $data['ose_url']);

            } else {
                $sql = "UPDATE tm_empresa SET ruc = ?,razon_social  = ?, nombre_comercial = ?, direccion_comercial = ?, celular = ?, pdf_rz = ?";
                $this->db->prepare($sql)->execute(array(
                    $data['ruc'],
                    $data['razon_social'],
                    $data['nombre_comercial'],
                    $data['direccion_comercial'],
                    $data['celular'],
                    $data['hidden_pdf_rz']
                ));
            }
            
            // Guardar datos de facturación electrónica siempre
            $this->facturacion_electronica_crud($data);

        } catch (Exception $e) 
        {
            die($e->getMessage());
        }
    }

    public function tipodoc_list()
    {
        try
        {      
            $stm = $this->db->prepare("SELECT * FROM tm_tipo_doc");
            $stm->execute();            
            $c = $stm->fetchAll(PDO::FETCH_OBJ);
            $data = array("data" => $c);
            $json = json_encode($data);
            echo $json; 
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function tipodoc_crud($data)
    {
        try 
        {

            if($data['defecto'] == '1'){
                $sql = "UPDATE tm_tipo_doc SET defecto = '0' WHERE defecto = '1'";
                $this->db->prepare($sql)->execute();
            }



            $sql = "UPDATE tm_tipo_doc SET serie = ?, numero = ?, estado = ?, defecto = ? WHERE id_tipo_doc = ?";
            $this->db->prepare($sql)->execute(array($data['serie'],$data['numero'],$data['estado'],$data['defecto'],$data['id_tipo_doc']));




        } catch (Exception $e) 
        {
            die($e->getMessage());
        }
    }

    public function tipodoc_data($data = array())
    {
        try 
        {
            $id_tipo_doc = isset($data['id_tipo_doc']) ? intval($data['id_tipo_doc']) : 0;
            
            if ($id_tipo_doc <= 0) {
                return array('success' => false, 'message' => 'ID de tipo de documento requerido', 'data' => null);
            }
            
            $sql = "SELECT 
                        id_tipo_doc,
                        descripcion,
                        serie,
                        pos,
                        numero,
                        numero_inicial,
                        numero_actual,
                        numero_final,
                        ambiente,
                        estado
                    FROM tm_tipo_doc 
                    WHERE id_tipo_doc = ? AND estado = 'a'";
            
            $stm = $this->db->prepare($sql);
            $stm->execute(array($id_tipo_doc));
            $result = $stm->fetch(PDO::FETCH_ASSOC);
            
            if ($result) {
                // Mapear tipo de documento a formato facturafacil (todos van como FAC)
                $tipo_documento_fe = 'FAC';
                
                // Obtener el último número usado desde tm_venta para este tipo de documento
                $sql_venta = "SELECT MAX(CAST(nro_doc AS UNSIGNED)) as ultimo_numero 
                              FROM tm_venta 
                              WHERE id_tipo_doc = ? AND serie_doc = ?";
                $stm_venta = $this->db->prepare($sql_venta);
                $stm_venta->execute(array($id_tipo_doc, $result['serie']));
                $venta_data = $stm_venta->fetch(PDO::FETCH_ASSOC);
                
                // Calcular el número actual
                $numero_actual = $result['numero_actual'];
                if (empty($numero_actual) || $numero_actual == 0) {
                    // Si numero_actual está vacío o es 0, intentar obtener desde numero (formato string con ceros)
                    if (!empty($result['numero'])) {
                        $numero_actual = intval($result['numero']);
                    } else {
                        // Si tampoco hay numero, usar numero_inicial
                        $numero_actual = $result['numero_inicial'] ?: 1;
                    }
                }
                
                // Si hay un último número usado en tm_venta y es mayor que numero_actual, usar ese + 1
                if ($venta_data && isset($venta_data['ultimo_numero']) && $venta_data['ultimo_numero'] > 0) {
                    $ultimo_numero_usado = intval($venta_data['ultimo_numero']);
                    // El siguiente número disponible es el último usado + 1
                    if ($ultimo_numero_usado >= $numero_actual) {
                        $numero_actual = $ultimo_numero_usado + 1;
                    }
                }
                
                return array(
                    'success' => true, 
                    'data' => array(
                        'id_tipo_doc' => $result['id_tipo_doc'],
                        'tipo_documento' => $tipo_documento_fe,
                        'descripcion' => $result['descripcion'],
                        'serie' => $result['serie'],
                        'pos' => $result['pos'] ?: '001',
                        'numero_inicial' => $result['numero_inicial'] ?: 1,
                        'numero_actual' => intval($numero_actual), // Asegurar que sea un entero
                        'numero_final' => $result['numero_final'] ?: 9999999999,
                        'ambiente' => $result['ambiente'] ?: 2
                    )
                );
            } else {
                return array('success' => false, 'message' => 'Tipo de documento no encontrado o inactivo', 'data' => null);
            }
        }
        catch(Exception $e)
        {
            return array('success' => false, 'message' => $e->getMessage(), 'data' => null);
        }
    }

    public function usuario_list()
    {
        try
        {
            $stm = $this->db->prepare("SELECT * FROM v_usuarios WHERE id_rol <> 1");
            $stm->execute();
            $c = $stm->fetchAll(PDO::FETCH_OBJ);

            foreach($c as $k => $d)
            {
                $c[$k]->{'caja'} = $this->db->query("SELECT * FROM v_caja_aper WHERE id_usu = ".$d->id_usu." AND estado = 'a' ")->fetch(PDO::FETCH_OBJ);
            }


            $data = array("data" => $c);
            $json = json_encode($data);
            echo $json;  
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function mozo_default($data)
    {
        try 
        {
            $this->db->selectOne("UPDATE `tm_usuario` SET `defaultid` = '0'");

            $d = $this->db->update('tm_usuario',array('defaultid' => '1'),'id_usu = '.$data['id_usu']);

            if(!$d){
                return 1;
            }
            return 0;

        } catch (Exception $e) 
        {
            die($e->getMessage());
        }
    }    

    public function usuario_data($id)
    {
        //return $this->db->selectOne('SELECT * FROM v_usuarios WHERE id_usu = :id_usu', 
        return $this->db->selectOne('SELECT vu.*, tmu.turno_ing, tmu.turno_sal FROM v_usuarios AS vu INNER JOIN tm_usuario AS tmu ON vu.id_usu = tmu.id_usu WHERE vu.id_usu = :id_usu', 
            array('id_usu' => $id));
    }

    public function usuario_crud_create($data)
    {
        try 
        {
            if( !empty( $_FILES['imagen']['name'] ) ){
                switch ($_FILES['imagen']['type']) 
                { 
                    case 'image/jpeg': 
                    $ext = "jpg"; 
                    break;
                    case 'image/gif': 
                    $ext = "gif"; 
                    break; 
                    case 'image/png': 
                    $ext = "png"; 
                    break;
                    case 'application/pdf':
                    $ext = "pdf";
                    break;
                }
                $imagen = date('ymdhis').'.'.$ext;
                move_uploaded_file ($_FILES['imagen']['tmp_name'], 'public/images/users/'.$imagen);
            } else {
                $imagen = $data['imagen'];
            }

            $area = (isset($data['id_areap'])) ? $data['id_areap'] : 0;

            $hidden_active_prod = (isset($data['hidden_active_prod'])) ? $data['hidden_active_prod'] : 0;
            $hidden_active_inventario = (isset($data['hidden_active_inventario'])) ? $data['hidden_active_inventario'] : 0;
            $hidden_active_ent_sal = (isset($data['hidden_active_ent_sal'])) ? $data['hidden_active_ent_sal'] : 0;
            $hidden_activated_clave_desc = (isset($data['hidden_activated_clave_desc'])) ? $data['hidden_activated_clave_desc'] : 0;
            $hidden_activated_informes = (isset($data['hidden_activated_informes'])) ? $data['hidden_activated_informes'] : 0;
            $hidden_activated_fechas = (isset($data['hidden_activated_fechas'])) ? $data['hidden_activated_fechas'] : 0;
            $hidden_activate_contable = (isset($data['hidden_activate_contable'])) ? $data['hidden_activate_contable'] : 0;
            
            $turno_ing = (isset($data['start'])) ? date('H:i:s',strtotime($data['start'])) : null;
            $turno_sal = (isset($data['end'])) ? date('H:i:s',strtotime($data['end'])) : null;

            $consulta = "call usp_configUsuario( 
                :flag,
                @a,
                :id_rol,
                :id_areap,
                :dni, 
                :ape_paterno, 
                :ape_materno, 
                :nombres, 
                :email, 
                :usuario, 
                :contrasena, 
                :imagen,
                :perm_edit_price, 
                :anular_ped_preparado, 
                :sonido, 
                :active_prod, 
                :active_inventario,
                :active_ent_sal,
                :activated_clave_desc,
                :activated_informes,
                :activated_fechas,
                :activate_contable,
                :turno_ing, 
                :turno_sal
                );";
            $arrayParam =  array(
                ':flag' => 1,
                ':id_rol' => $data['id_rol'],
                ':id_areap' => $area,
                ':dni' => $data['dni'],
                ':ape_paterno' => $data['ape_paterno'],
                ':ape_materno' => $data['ape_materno'],
                ':nombres' => $data['nombres'],
                ':email' => $data['email'],
                ':usuario' => $data['usuario'],
                ':contrasena' => base64_encode($data['contrasena']),
                ':imagen' => $imagen,
                ':perm_edit_price' => $data['hidden_perm_edit_price'],
                ':anular_ped_preparado' => $data['hidden_anular_ped_preparado'],
                ':sonido' => $data['hidden_sonido_llevar'],
                ':active_prod' => $hidden_active_prod,
                ':active_inventario' => $hidden_active_inventario,
                ':active_ent_sal' => $hidden_active_ent_sal,
                ':activated_clave_desc' => $hidden_activated_clave_desc,
                ':activated_informes' => $hidden_activated_informes,
                ':activated_fechas' => $hidden_activated_fechas,
                ':activate_contable' => $hidden_activate_contable,
                ':turno_ing' => $turno_ing,
                ':turno_sal' => $turno_sal                
            );
            $st = $this->db->prepare($consulta);
            $st->execute($arrayParam);
            $row = $st->fetch(PDO::FETCH_ASSOC);
            // Session::set('anular_ped_preparado', $data_u['hidden_anular_ped_preparado']);
            return $row;
        } catch (Exception $e) 
        {
            die($e->getMessage());
        }
    }

    public function usuario_crud_update($data)
    {
        try 
        {
            if( !empty( $_FILES['imagen']['name'] ) ){
                switch ($_FILES['imagen']['type']) 
                { 
                    case 'image/jpeg': 
                    $ext = "jpg"; 
                    break;
                    case 'image/gif': 
                    $ext = "gif"; 
                    break; 
                    case 'image/png': 
                    $ext = "png"; 
                    break;
                    case 'application/pdf':
                    $ext = "pdf";
                    break;
                }
                $imagen = date('ymdhis').'.'.$ext;
                move_uploaded_file ($_FILES['imagen']['tmp_name'], 'public/images/users/'.$imagen);
            } else {
                $imagen = $data['imagen'];
            }

            $area = (isset($data['id_areap'])) ? $data['id_areap'] : 0;
            
            $turno_ing = (isset($data['start'])) ? date('H:i:s',strtotime($data['start'])) : null;
            $turno_sal = (isset($data['end'])) ? date('H:i:s',strtotime($data['end'])) : null;            

            $consulta = "call usp_configUsuario( 
                :flag, 
                :id_usu, 
                :id_rol, 
                :id_areap, 
                :dni, 
                :ape_paterno, 
                :ape_materno, 
                :nombres, 
                :email, 
                :usuario, 
                :contrasena, 
                :imagen,
                :perm_edit_price,
                :anular_ped_preparado, 
                :sonido, 
                :active_prod, 
                :active_inventario,
                :active_ent_sal,
                :activated_clave_desc, 
                :activated_informes, 
                :activated_fechas,
                :activate_contable,
                :turno_ing, 
                :turno_sal
                );";
            $arrayParam =  array(
                ':flag' => 2,
                ':id_usu' => $data['id_usu'],
                ':id_rol' => $data['id_rol'],
                ':id_areap' => $area,
                ':dni' => $data['dni'],
                ':ape_paterno' => $data['ape_paterno'],
                ':ape_materno' => $data['ape_materno'],
                ':nombres' => $data['nombres'],
                ':email' => $data['email'],
                ':usuario' => $data['usuario'],
                ':contrasena' => base64_encode($data['contrasena']),
                ':imagen' => $imagen,
                ':perm_edit_price' => $data['hidden_perm_edit_price'],
                ':anular_ped_preparado' => $data['hidden_anular_ped_preparado'],
                ':sonido' => $data['hidden_sonido_llevar'],
                ':active_prod' => $data['hidden_active_prod'],
                ':active_inventario' => $data['hidden_active_inventario'],
                ':active_ent_sal' => $data['hidden_active_ent_sal'],
                ':activated_clave_desc' => $data['hidden_activated_clave_desc'],
                ':activated_informes' => $data['hidden_activated_informes'],
                ':activated_fechas' => $data['hidden_activated_fechas'],
                ':activate_contable' => $data['hidden_activate_contable'],
                ':turno_ing' => $turno_ing,
                ':turno_sal' => $turno_sal                   
            );
            $st = $this->db->prepare($consulta);
            $st->execute($arrayParam);
            // Session::set('anular_ped_preparado', $data_u['hidden_anular_ped_preparado']);
        } catch (Exception $e) 
        {
            die($e->getMessage());
        }
    }

    public function usuario_estado($data)
    {
        try 
        {
            $sql = "UPDATE tm_usuario SET estado = ? WHERE id_usu = ?";
            $this->db->prepare($sql)->execute(array($data['estado'],$data['id_usu']));
        } catch (Exception $e) 
        {
            die($e->getMessage());
        }
    }

    public function usuario_delete($data)
    {
        try 
        {
        if($data['id_rol'] == 1 OR $data['id_rol'] == 2){
            $consulta = "SELECT count(*) AS total FROM tm_pedido WHERE id_usu = ?";
        } else {
            $consulta = "SELECT count(*) AS total FROM tm_pedido_mesa WHERE id_mozo = ?";
        }
        $result = $this->db->prepare($consulta);
        $result->execute(array($data['id_usu']));
        $result->execute();
            if($result->fetchColumn()==0){
                $stm = $this->db->prepare("DELETE FROM tm_usuario WHERE id_usu = ?");          
                $stm->execute(array($data['id_usu']));
                return 1;
            }else{
                return 0;
            }
        } catch (Exception $e) 
        {
            die($e->getMessage());
        }
    }

    /* FIN MODULO EMPRESA */
    public function TipoPago()
    {
        try
        {      
            return $this->db->selectAll('SELECT * FROM tm_pago');
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }
    public function tipopago_list($data)
    {
        try
        {
            $stm = $this->db->prepare("SELECT * FROM tm_tipo_pago WHERE id_tipo_pago LIKE ?");
            $stm->execute(array($data['id_pago']));
            $c = $stm->fetchAll(PDO::FETCH_OBJ);
            foreach($c as $k => $d)
            {
                $c[$k]->{'Tipo'} = $this->db->query("SELECT descripcion AS nombre FROM tm_pago WHERE id_pago = ".$d->id_pago)
                    ->fetch(PDO::FETCH_OBJ);
            }
            $data = array("data" => $c);
            $json = json_encode($data);
            echo $json; 
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function tipopago_crud_create($data)
    {

        try
        {

            $sql = "INSERT INTO tm_tipo_pago SET id_pago = ? ,descripcion = ? ,estado = ?, delivery = ?, color = ?";
            $resultado = $this->db->prepare($sql)->execute(array($data['id_tipo_pago'],$data['nombre'],$data['estado'],$data['delivery'],$data['color']));


            if ($resultado){
                return '1';
            }
        } catch (Exception $e) 
        {
            die($e->getMessage());
        }
    }

    public function tipopago_crud_update($data)
    {
        try 
        {
            $sql = "UPDATE tm_tipo_pago SET id_pago = ?, descripcion = ?, estado = ? , delivery = ?, color = ? WHERE tm_tipo_pago.id_tipo_pago = ?";
            $resultado = $this->db->prepare($sql)->execute(array($data['id_tipo_pago'],$data['nombre'],$data['estado'],$data['delivery'] ,$data['color'] ,$data['id_pago']));

            if ($resultado){
                return '2';
            }
        } catch (Exception $e) 
        {
            die($e->getMessage());
        }
    }

    /* INICIO MODULO RESTAURANTE */

    public function caja_list()
    {
        try
        {
            $stm = $this->db->prepare("SELECT * FROM tm_caja");
            $stm->execute();
            $c = $stm->fetchAll(PDO::FETCH_OBJ);
            foreach($c as $k => $d)
            {
                $c[$k]->{'Impresora'} = $this->db->query("SELECT nombre FROM tm_impresora WHERE id_imp = ".$d->id_imp)->fetch(PDO::FETCH_OBJ);
            }            
            $data = array("data" => $c);
            $json = json_encode($data);
            echo $json; 
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function caja_crud_create($data)
    {
        try
        {
            $consulta = "call usp_configCajas( :flag, @a, :descripcion, :id_imp, :estado);";
            $arrayParam =  array(
                ':flag' => 1,
                ':descripcion' => $data['descripcion'],
                ':id_imp' => $data['id_imp'],
                ':estado' => $data['estado']
            );
            $st = $this->db->prepare($consulta);
            $st->execute($arrayParam);
            while ($row = $st->fetch(PDO::FETCH_ASSOC)) {
                return $row['cod'];
            }
        } catch (Exception $e) 
        {
            die($e->getMessage());
        }
    }

    public function caja_crud_update($data)
    {
        try 
        {
            $consulta = "call usp_configCajas( :flag, :id_caja, :descripcion, :id_imp, :estado);";
            $arrayParam =  array(
                ':flag' => 2,
                ':id_caja' => $data['id_caja'],
                ':descripcion' => $data['descripcion'],
                ':id_imp' => $data['id_imp'],
                ':estado' => $data['estado']
            );
            $st = $this->db->prepare($consulta);
            $st->execute($arrayParam);
            while ($row = $st->fetch(PDO::FETCH_ASSOC)) {
                return $row['cod'];
            }
        } catch (Exception $e) 
        {
            die($e->getMessage());
        }
    }

    public function areaprod_list($data)
    {
        try
        {
           
            $stm = $this->db->prepare("SELECT * FROM tm_area_prod WHERE id_areap like ?");
            $stm->execute(array($data['id_areap']));
            $c = $stm->fetchAll(PDO::FETCH_OBJ);
            foreach($c as $k => $d)
            {
                $c[$k]->{'Impresora'} = $this->db->query("SELECT nombre FROM tm_impresora WHERE id_imp = ".$d->id_imp)
                    ->fetch(PDO::FETCH_OBJ);
            }
            $data = array("data" => $c);
            $json = json_encode($data);
            echo $json; 
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function areaprod_crud_create($data)
    {
        try
        {
            $consulta = "call usp_configAreasProd( :flag, @a, :id_imp, :nombre, :estado);";
            $arrayParam =  array(
                ':flag' => 1,                
                ':id_imp' => $data['id_imp'],
                ':nombre' => $data['nombre'],
                ':estado' => $data['estado']
            );
            $st = $this->db->prepare($consulta);
            $st->execute($arrayParam);
            while ($row = $st->fetch(PDO::FETCH_ASSOC)) {
                return $row['cod'];
            }
        } catch (Exception $e) 
        {
            die($e->getMessage());
        }
    }

    public function areaprod_crud_update($data)
    {
        try 
        {
            $consulta = "call usp_configAreasProd( :flag, :id_areap, :id_imp, :nombre, :estado);";
            $arrayParam =  array(
                ':flag' => 2,
                ':id_areap' => $data['id_areap'],
                ':id_imp' => $data['id_imp'],
                ':nombre' => $data['nombre'],
                ':estado' => $data['estado']                
            );
            $st = $this->db->prepare($consulta);
            $st->execute($arrayParam);
            while ($row = $st->fetch(PDO::FETCH_ASSOC)) {
                return $row['cod'];
            }
        } catch (Exception $e) 
        {
            die($e->getMessage());
        }
    }

    public function salon_list()
    {
        try
        {
            $stm = $this->db->prepare("SELECT * FROM tm_salon ORDER BY id_salon ASC");
            $stm->execute();
            $c = $stm->fetchAll(PDO::FETCH_OBJ);
            foreach($c as $k => $d)
            {
                $c[$k]->{'Mesas'} = $this->db->query("SELECT COUNT(id_mesa) AS total FROM tm_mesa WHERE id_salon = ".$d->id_salon)
                ->fetch(PDO::FETCH_OBJ);
            }
            $data = array("data" => $c);
            $json = json_encode($data);
            echo $json; 
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function mesa_list()
    {
        try
        {
            $stm = $this->db->prepare("SELECT * FROM tm_mesa WHERE id_salon like ? ORDER BY nro_mesa ASC");
            $stm->execute(array($_POST['id_salon']));
            $c = $stm->fetchAll(PDO::FETCH_OBJ);
            foreach($c as $k => $d)
            {
                $c[$k]->{'Salon'} = $this->db->query("SELECT descripcion FROM tm_salon WHERE id_salon = ".$d->id_salon)
                ->fetch(PDO::FETCH_OBJ);
            }
            $data = array("data" => $c);
            $json = json_encode($data);
            echo $json; 
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function salon_crud_create($data)
    {
        try 
        {
            $consulta = "call usp_configSalones( :flag, @a, :descripcion, :estado);";
            $arrayParam =  array(
                ':flag' => 1,
                ':descripcion' => $data['descripcion'],
                ':estado' => $data['estado']
            );
            $st = $this->db->prepare($consulta);
            $st->execute($arrayParam);
            while ($row = $st->fetch(PDO::FETCH_ASSOC)) {
                return $row['cod'];
            }
        }
        catch (Exception $e) 
        {
            return false;
        }
    }

    public function salon_crud_update($data)
    {
        try 
        {
            $consulta = "call usp_configSalones( :flag, :id_salon, :descripcion, :estado);";
            $arrayParam =  array(
                ':flag' => 2,
                ':id_salon' => $data['id_salon'],
                ':descripcion' => $data['descripcion'],
                ':estado' => $data['estado']
            );
            $st = $this->db->prepare($consulta);
            $st->execute($arrayParam);
            while ($row = $st->fetch(PDO::FETCH_ASSOC)) {
                return $row['cod'];
            }
        }
        catch (Exception $e) 
        {
            return false;
        }
    }

    public function salon_crud_delete($data)
    {
        try 
        {
            $consulta = "call usp_configSalones( :flag, :id_salon, @a, @b);";
            $arrayParam =  array(
                ':flag' => 3,
                ':id_salon' => $data['id_salon']
            );
            $st = $this->db->prepare($consulta);
            $st->execute($arrayParam);
            while ($row = $st->fetch(PDO::FETCH_ASSOC)) {
                return $row['cod'];
            }
        } catch (Exception $e) 
        {
            die($e->getMessage());
        }
    }

    public function mesa_crud_create($data)
    {
        try 
        {
            $consulta = "call usp_configMesas( :flag, @a, :id_salon, :nro_mesa, :forma, @b);";
            $arrayParam =  array(
                ':flag' => 1,
                ':id_salon' => $data['id_salon'],
                ':nro_mesa' => $data['nro_mesa'],
                ':forma' => $data['forma'],
            );
            $st = $this->db->prepare($consulta);
            $st->execute($arrayParam);
            while ($row = $st->fetch(PDO::FETCH_ASSOC)) {
                return $row['cod'];
            }
        }
        catch (Exception $e) 
        {
            return false;
        }
    }

    public function mesa_crud_update($data)
    {
        try 
        {
            $consulta = "call usp_configMesas( :flag, :id_mesa, :id_salon, :nro_mesa, :forma, :estado);";
            $arrayParam =  array(
                ':flag' => 2,
                ':id_mesa' => $data['id_mesa'],
                ':id_salon' => $data['id_salon'],
                ':nro_mesa' => $data['nro_mesa'],
                ':forma' => $data['forma'],
                ':estado' => $data['estado']                        
            );
            $st = $this->db->prepare($consulta);
            $st->execute($arrayParam);
            while ($row = $st->fetch(PDO::FETCH_ASSOC)) {
                return $row['cod'];
            }
        }
        catch (Exception $e) 
        {
            return false;
        }
    }

    public function mesa_crud_delete($data)
    {
        try 
        {
            $consulta = "call usp_configMesas( :flag, :id_mesa, @a, @b, @c, @d);";
            $arrayParam =  array(
                ':flag' => 3,
                ':id_mesa' => $data['id_mesa']
            );
            $st = $this->db->prepare($consulta);
            $st->execute($arrayParam);
            while ($row = $st->fetch(PDO::FETCH_ASSOC)) {
                return $row['cod'];
            }
        } catch (Exception $e) 
        {
            die($e->getMessage());
        }
    }

    /*
    public function mesa_estado($data)
    {
        try 
        {
            $sql = "UPDATE tm_mesa SET estado = ? WHERE id_mesa = ?";
            $this->db->prepare($sql)->execute(array($data['est_mesa'],$data['codi_mesa']));    
        } catch (Exception $e) 
        {
            die($e->getMessage());
        }
    }
    */

    /* ===================================== PRODUCTO*/
    public function producto_list()
    {
        try
        {

            $stm = $this->db->prepare("SELECT tm_producto.* FROM tm_producto INNER JOIN tm_producto_catg ON tm_producto.id_catg = tm_producto_catg.id_catg WHERE tm_producto.id_prod like ? AND tm_producto.id_catg like ? AND tm_producto_catg.combos <> 1 ORDER BY tm_producto.id_prod DESC");
            $stm->execute(array($_POST['id_prod'],$_POST['id_catg']));
            $c = $stm->fetchAll(PDO::FETCH_OBJ);
            $data = array("data" => $c);
            $json = json_encode($data);
            echo $json; 
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function producto_pres_list()
    {
        try
        {
            // Consulta explícita incluyendo los campos de impuesto personalizado
            $stm = $this->db->prepare("SELECT 
                id_pres, id_prod, cod_prod, presentacion, descripcion, precio, 
                precio_delivery, precio_delivery_app, precio_llevar, costo_unitario, 
                receta, toppings, stock_min, crt_stock, impuesto, 
                usar_impuesto_sistema, impuesto_incluido_personalizado, impuesto_porcentaje_personalizado,
                delivery, llevar, nota, margen, igv, imagen, ordenins, estado, notas
                FROM tm_producto_pres WHERE id_prod LIKE ? AND id_pres LIKE ?");
            $stm->execute(array($_POST['id_prod'],$_POST['id_pres']));
            $c = $stm->fetchAll(PDO::FETCH_OBJ);
            foreach($c as $k => $d)
            {
                $c[$k]->{'TipoProd'} = $this->db->query("SELECT id_tipo FROM tm_producto WHERE id_prod = ".$d->id_prod)
                ->fetch(PDO::FETCH_OBJ);
                
                // Asegurar que los campos de impuesto personalizado tengan valores por defecto si son null
                if($c[$k]->usar_impuesto_sistema === null){
                    $c[$k]->usar_impuesto_sistema = 1;
                }
                if($c[$k]->impuesto_incluido_personalizado === null){
                    $c[$k]->impuesto_incluido_personalizado = 0;
                }
                // Convertir a string para evitar problemas con JSON
                $c[$k]->usar_impuesto_sistema = (string)$c[$k]->usar_impuesto_sistema;
                $c[$k]->impuesto_incluido_personalizado = (string)$c[$k]->impuesto_incluido_personalizado;
            }
            $data = array("data" => $c);
            $json = json_encode($data);
            echo $json; 
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function producto_cat_list()
    {
        try
        {
            $stm = $this->db->prepare("SELECT * FROM tm_producto_catg WHERE combos <> 1 ORDER BY orden ASC");
            $stm->execute();
            $c = $stm->fetchAll(PDO::FETCH_OBJ);
            $data = array("data" => $c);
            $json = json_encode($data);
            echo $json; 
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function producto_pres_ing($data)
    {
        try
        {
            $stm = $this->db->prepare("SELECT * FROM tm_producto_ingr WHERE id_pres = ?");
            $stm->execute(array($data['id_pres']));
            $c = $stm->fetchAll(PDO::FETCH_OBJ);
            foreach($c as $k => $d)
            {
                $c[$k]->{'Insumo'} = $this->db->query("SELECT ins_med,ins_nom,ins_cat FROM v_insprod WHERE id_tipo_ins = ".$d->id_tipo_ins." AND id_ins = ".$d->id_ins)
                ->fetch(PDO::FETCH_OBJ);
            }
            foreach($c as $k => $d)
            {
                $c[$k]->{'Medida'} = $this->db->query("SELECT descripcion FROM tm_tipo_medida WHERE id_med = ".$d->id_med)
                ->fetch(PDO::FETCH_OBJ);
            }
            return $c;
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function producto_buscar_ins($data)
    {
        try
        {        
            $config->{'Configuracion'} = $this->db->query("SELECT * FROM tm_configuracion")->fetch(PDO::FETCH_OBJ);
            
            if ($config->{'Configuracion'}->activated_pres == '1'){
                $cadena = $data['cadena'];
                $tipo = $data['tipo'];
                if ($tipo == '3'){
                    $sql_new = "id_tipo_ins <> 3 AND id_tipo_ins <> 2";
                }elseif ($tipo == '1'){
                    $sql_new = "id_tipo_ins <> 1";
                }
                $stm = $this->db->prepare("SELECT *, ins_nom AS nom_ins, pro_pre AS nom_pro_pre FROM v_insprod WHERE (ins_nom LIKE '%$cadena%' OR ins_cod LIKE '%$cadena%' OR pro_nom LIKE '%$cadena%' OR pro_pre LIKE '%$cadena%') AND est_b = 'a' AND est_c = 'a' AND ".$sql_new." ORDER BY ins_nom LIMIT 5");
                $stm->execute();
                return $stm->fetchAll(PDO::FETCH_OBJ);
            }else{
                $cadena = $data['cadena'];
                $tipo = $data['tipo'];
                if ($tipo == '3'){
                    $sql_new = "id_tipo_ins <> 3 AND id_tipo_ins <> 2";
                }elseif ($tipo == '1'){
                    $sql_new = "id_tipo_ins <> 1";
                }                
                $stm = $this->db->prepare("SELECT *, ins_nom AS nom_ins, CONCAT(pro_nom, ' ' , pro_pre) AS nom_pro_pre FROM v_insprod WHERE (ins_nom LIKE '%$cadena%' OR ins_cod LIKE '%$cadena%' OR pro_nom LIKE '%$cadena%' OR pro_pre LIKE '%$cadena%') AND est_b = 'a' AND est_c = 'a' AND ".$sql_new." ORDER BY ins_nom LIMIT 5");
                $stm->execute();
                return $stm->fetchAll(PDO::FETCH_OBJ);                
            }
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function producto_cat_crud_create($data)
    {
        try 
        {
            if( !empty( $_FILES['imagen']['name'] ) ){
                switch ($_FILES['imagen']['type']) 
                { 
                    case 'image/jpeg': 
                    $ext = "jpg"; 
                    break;
                    case 'image/gif': 
                    $ext = "gif"; 
                    break; 
                    case 'image/png': 
                    $ext = "png"; 
                    break;
                    case 'application/pdf':
                    $ext = "pdf";
                    break;
                }
                $imagen = date('ymdhis').'.'.$ext;
                move_uploaded_file ($_FILES['imagen']['tmp_name'], 'public/images/productos/'.$imagen);
            } else {
                $imagen = $data['imagen'];
            }
            $consulta = "call usp_configProductoCatgs( :flag, @a, :descripcion, :delivery, :orden, :imagen, :estado);";
            $arrayParam =  array(
                ':flag' => 1,
                ':descripcion' => $data['descripcion_categoria'],
                ':delivery' => $data['hidden_delivery_categoria'],
                ':orden' => 100,
                ':imagen' => $imagen,
                ':estado' => $data['hidden_estado_categoria']
            );
            $st = $this->db->prepare($consulta);
            $st->execute($arrayParam);
            while ($row = $st->fetch(PDO::FETCH_ASSOC)) {
                return $row['cod'];
            }
        }
        catch (Exception $e) 
        {
            return false;
        }
    }

    public function producto_cat_crud_update($data)
    {
        try 
        {
            if( !empty( $_FILES['imagen']['name'] ) ){
                switch ($_FILES['imagen']['type']) 
                { 
                    case 'image/jpeg': 
                    $ext = "jpg"; 
                    break;
                    case 'image/gif': 
                    $ext = "gif"; 
                    break; 
                    case 'image/png': 
                    $ext = "png"; 
                    break;
                    case 'application/pdf':
                    $ext = "pdf";
                    break;
                }
                $imagen = date('ymdhis').'.'.$ext;
                move_uploaded_file ($_FILES['imagen']['tmp_name'], 'public/images/productos/'.$imagen);
            } else {
                $imagen = $data['imagen'];
            }
            $consulta = "call usp_configProductoCatgs( :flag, :id_catg, :descripcion, :delivery, :orden, :imagen, :estado);";
            $arrayParam =  array(
                ':flag' => 2,
                ':id_catg' => $data['id_catg_categoria'],
                ':descripcion' => $data['descripcion_categoria'],
                ':delivery' => $data['hidden_delivery_categoria'],
                ':orden' => $data['orden_categoria'],
                ':imagen' => $imagen,
                ':estado' => $data['hidden_estado_categoria']
            );
            $st = $this->db->prepare($consulta);
            $st->execute($arrayParam);
            while ($row = $st->fetch(PDO::FETCH_ASSOC)) {
                return $row['cod'];
            }
        }
        catch (Exception $e) 
        {
            return false;
        }
    }

    public function producto_crud_create($data)
    {
        try
        {
            $datanota = $data['notas'][0];
            if ($data['grupo_notas'] != 0) {

                $grupnota = $data['grupo_notas'];
                $nota = $data['notas'];
                $jsonData = array();
                
                for($x = 0; $x < sizeof($nota); ++$x){
                    $jsonData[$grupnota[$x]] = $nota[$x];
                }
                
                $datanota = json_encode($jsonData);
            }

            $consulta = "call usp_configProducto( :flag, @a, :id_tipo, :id_catg, :id_areap, :nombre, :notas, :delivery, @b);";
            $arrayParam =  array(
                ':flag' => 1,
                ':id_tipo' => $data['id_tipo'],
                ':id_catg' => $data['id_catg'],
                ':id_areap' => $data['id_areap'],
                ':nombre' => $data['nombre'],
                ':notas' => $datanota,
                ':delivery' => $data['delivery']
            );
            $st = $this->db->prepare($consulta);
            $st->execute($arrayParam);
            while ($row = $st->fetch(PDO::FETCH_ASSOC)) {
                return $row['cod'];
            }
        } catch (Exception $e) 
        {
            die($e->getMessage());
        }
    }

    public function producto_crud_update($data)
    {
        try 
        {
            $datanota = $data['notas'][0];
            if ($data['grupo_notas'] != 0) {

                $grupnota = $data['grupo_notas'];
                $nota = $data['notas'];
                $jsonData = array();
                
                for($x = 0; $x < sizeof($nota); ++$x){
                    $jsonData[$grupnota[$x]] = $nota[$x];
                }
                
                $datanota = json_encode($jsonData);
            }

            $consulta = "call usp_configProducto( :flag, :id_prod, :id_tipo, :id_catg, :id_areap, :nombre, :notas, :delivery, :estado);";
            $arrayParam =  array(
                ':flag' => 2,
                ':id_prod' => $data['id_prod'],
                ':id_tipo' => $data['id_tipo'],
                ':id_catg' => $data['id_catg'],
                ':id_areap' => $data['id_areap'],
                ':nombre' => $data['nombre'],
                ':notas' => $datanota,
                ':delivery' => $data['delivery'],
                ':estado' => $data['estado']
            );
            $st = $this->db->prepare($consulta);
            $st->execute($arrayParam);
            while ($row = $st->fetch(PDO::FETCH_ASSOC)) {
                return $row['cod'];
            }
        } catch (Exception $e) 
        {
            die($e->getMessage());
        }
    }

    public function producto_pres_crud_create($data)
    {
        try 
        {           
            if( !empty( $_FILES['imagen']['name'] ) ){
                switch ($_FILES['imagen']['type']) 
                { 
                    case 'image/jpeg': 
                    $ext = "jpg"; 
                    break;
                    case 'image/gif': 
                    $ext = "gif"; 
                    break; 
                    case 'image/png': 
                    $ext = "png"; 
                    break;
                    case 'application/pdf':
                    $ext = "pdf";
                    break;
                }
                $imagen = date('ymdhis').'.'.$ext;
                move_uploaded_file ($_FILES['imagen']['tmp_name'], 'public/images/productos/'.$imagen);
            } else {
                $imagen = $data['imagen'];
            }

            $datanota = $data['notas_presentacion'][0];
            if (isset($data['grupo_nota_pre']) && $data['grupo_nota_pre'] != 0) {
                $grupnota = $data['grupo_nota_pre'];
                $nota = $data['notas_presentacion'];
                $cantidad_nota = $data['cantidad_nota'];
                $jsonData = array();

                for ($x = 0; $x < sizeof($nota); ++$x) {

                    $jsonData[] = array(
                        'grupo' => $grupnota[$x],
                        'notas' => $nota[$x],
                        'cant_nota' => $cantidad_nota[$x]

                    );
                }             
                
                $finalData = array(
                    'grupo_limit' => (isset($data['grupo_limit_max'])? $data['grupo_limit_max']: 0),
                    'grupo' => $jsonData
                );
            
                $datanota = json_encode($finalData);
            }

            // Preparar valores de impuesto personalizado
            $usar_impuesto_sistema = isset($data['usar_impuesto_sistema']) ? $data['usar_impuesto_sistema'] : '1';
            // Manejar string vacío como '0' (excluido por defecto)
            $impuesto_incluido_personalizado = isset($data['impuesto_incluido_personalizado']) && $data['impuesto_incluido_personalizado'] !== '' ? $data['impuesto_incluido_personalizado'] : '0';
            
            // Si está usando sistema (valor 1 o '1'), no guardar porcentaje personalizado
            if($usar_impuesto_sistema == '1' || $usar_impuesto_sistema == 1){
                $impuesto_porcentaje_personalizado = null;
            } else {
                // Si está personalizado (valor 0 o '0'), guardar el porcentaje
                $impuesto_porcentaje_personalizado = isset($data['impuesto_porcentaje_personalizado']) && $data['impuesto_porcentaje_personalizado'] != '' ? floatval($data['impuesto_porcentaje_personalizado']) : null;
            }
            
            // Convertir a tipos correctos para la base de datos
            $usar_impuesto_sistema_db = ($usar_impuesto_sistema == '1' || $usar_impuesto_sistema == 1) ? 1 : 0;
            $impuesto_incluido_db = ($impuesto_incluido_personalizado == '1' || $impuesto_incluido_personalizado == 1) ? 1 : 0;
            
            error_log("CREATE - Valores preparados para SP: usar_impuesto_sistema=" . $usar_impuesto_sistema_db . " | impuesto_incluido=" . $impuesto_incluido_db . " | porcentaje=" . ($impuesto_porcentaje_personalizado ?? 'null'), 3, 'C:\\xampp7433\\htdocs\\error_log');
            
            $consulta = "call usp_configProductoPres( :flag, @a, :id_prod, :cod_prod, :presentacion, :descripcion, :precio, :precio_delivery, :precio_delivery_app, :precio_llevar, :costo_unitario, :receta, :toppings, :stock_min,:stock_limit, :impuesto, :nota, :delivery, :llevar, :margen, :igv, :imagen, :ordenins, :estado, :notas, :usar_impuesto_sistema, :impuesto_incluido_personalizado, :impuesto_porcentaje_personalizado);";
            $arrayParam =  array(
                ':flag' => 1,
                ':id_prod' => $data['id_prod_presentacion'],
                ':cod_prod' => $data['cod_prod_presentacion'],
                ':presentacion' => $data['presentacion_presentacion'],
                ':descripcion' => $data['descripcion_presentacion'],
                ':precio' => $data['precio_presentacion'],
                ':precio_delivery' => $data['precio_delivery'],
                ':precio_delivery_app' => $data['precio_delivery_app'],
                ':precio_llevar' => $data['precio_llevar'],
                ':costo_unitario' => $data['costounitario_presentacion'],
                ':receta' => $data['hidden_receta_presentacion'],
                ':toppings' => $data['hidden_toppings_presentacion'],
                ':stock_min' => $data['stock_min_presentacion'],
                ':stock_limit' => ($data['hidden_stock_limit'])? $data['hidden_stock_limit']: '0',
                ':impuesto' => $data['hidden_impuesto_presentacion'],
                ':nota' => $data['hidden_nota_presentacion'],
                ':delivery' => $data['hidden_delivery_presentacion'],
                ':llevar' => $data['hidden_llevar_presentacion'],
                ':margen' => $data['hidden_insumo_principal_presentacion'],
                ':igv' => Session::get('igv'),
                ':imagen' => $imagen,
                ':ordenins' => $data['ordenins'] ? $data['ordenins'] : 1,
                ':estado' => $data['hidden_estado_presentacion'],
                ':notas' => $datanota,
                ':usar_impuesto_sistema' => $usar_impuesto_sistema_db,
                ':impuesto_incluido_personalizado' => $impuesto_incluido_db,
                ':impuesto_porcentaje_personalizado' => $impuesto_porcentaje_personalizado
            );
            $st = $this->db->prepare($consulta);
            $st->execute($arrayParam);
            $codigo_retorno = null;
            while ($row = $st->fetch(PDO::FETCH_ASSOC)) {
                $codigo_retorno = $row['cod'];
            }
            // Cerrar el cursor del stored procedure
            $st->closeCursor();
            
            if($codigo_retorno !== null){
                return $codigo_retorno;
            }
        }
        catch (Exception $e) 
        {
            return false;
        }
    }

    public function producto_pres_crud_update($data)
    {
        try 
        {

            if( !empty( $_FILES['imagen']['name'] ) ){
                switch ($_FILES['imagen']['type']) 
                { 
                    case 'image/jpeg': 
                    $ext = "jpg"; 
                    break;
                    case 'image/gif': 
                    $ext = "gif"; 
                    break; 
                    case 'image/png': 
                    $ext = "png"; 
                    break;
                    case 'application/pdf':
                    $ext = "pdf";
                    break;
                }
                $imagen = date('ymdhis').'.'.$ext;
                move_uploaded_file ($_FILES['imagen']['tmp_name'],'public/images/productos/'.$imagen);
            } else {
                $imagen = $data['imagen'];
            }

            $datanota = $data['notas_presentacion'][0];
            if (isset($data['grupo_nota_pre']) && $data['grupo_nota_pre'] != 0) {
                $grupnota = $data['grupo_nota_pre'];
                $nota = $data['notas_presentacion'];
                $cantidad_nota = $data['cantidad_nota'];
                $jsonData = array();

                for ($x = 0; $x < sizeof($nota); ++$x) {

                    $jsonData[] = array(
                        'grupo' => $grupnota[$x],
                        'notas' => $nota[$x],
                        'cant_nota' => $cantidad_nota[$x]

                    );
                }
                $finalData = array(
                    'grupo_limit' => (isset($data['grupo_limit_max'])? $data['grupo_limit_max']: 0),
                    'grupo' => $jsonData
                );
            
                $datanota = json_encode($finalData);
            }

            // Preparar valores de impuesto personalizado
            $usar_impuesto_sistema = isset($data['usar_impuesto_sistema']) ? $data['usar_impuesto_sistema'] : '1';
            // Manejar string vacío como '0' (excluido por defecto)
            $impuesto_incluido_personalizado = isset($data['impuesto_incluido_personalizado']) && $data['impuesto_incluido_personalizado'] !== '' ? $data['impuesto_incluido_personalizado'] : '0';
            
            // Si está usando sistema (valor 1 o '1'), no guardar porcentaje personalizado
            if($usar_impuesto_sistema == '1' || $usar_impuesto_sistema == 1){
                $impuesto_porcentaje_personalizado = null;
            } else {
                // Si está personalizado (valor 0 o '0'), guardar el porcentaje
                $impuesto_porcentaje_personalizado = isset($data['impuesto_porcentaje_personalizado']) && $data['impuesto_porcentaje_personalizado'] != '' ? floatval($data['impuesto_porcentaje_personalizado']) : null;
            }
            
            // Convertir a tipos correctos para la base de datos
            $usar_impuesto_sistema_db = ($usar_impuesto_sistema == '1' || $usar_impuesto_sistema == 1) ? 1 : 0;
            $impuesto_incluido_db = ($impuesto_incluido_personalizado == '1' || $impuesto_incluido_personalizado == 1) ? 1 : 0;
            
            error_log("UPDATE - Valores preparados para SP: usar_impuesto_sistema=" . $usar_impuesto_sistema_db . " | impuesto_incluido=" . $impuesto_incluido_db . " | porcentaje=" . ($impuesto_porcentaje_personalizado ?? 'null') . " | id_pres=" . $data['id_pres_presentacion'], 3, 'C:\\xampp7433\\htdocs\\error_log');
            
            $consulta = "call usp_configProductoPres( :flag, :id_pres, :id_prod, :cod_prod, :presentacion, :descripcion, :precio, :precio_delivery, :precio_delivery_app,:precio_llevar, :costo_unitario, :receta, :toppings, :stock_min,:stock_limit, :impuesto, :nota, :delivery, :llevar, :margen, :igv, :imagen, :ordenins, :estado, :notas, :usar_impuesto_sistema, :impuesto_incluido_personalizado, :impuesto_porcentaje_personalizado);";
            $arrayParam =  array(
                ':flag' => 2,
                ':id_pres' => $data['id_pres_presentacion'],
                ':id_prod' => $data['id_prod_presentacion'],
                ':cod_prod' => $data['cod_prod_presentacion'],
                ':presentacion' => $data['presentacion_presentacion'],
                ':descripcion' => $data['descripcion_presentacion'],
                ':precio' => $data['precio_presentacion'],
                ':precio_delivery' => $data['precio_delivery'],
                ':precio_delivery_app' => $data['precio_delivery_app'],
                ':precio_llevar' => $data['precio_llevar'],
                ':costo_unitario' => $data['costounitario_presentacion'],
                ':receta' => $data['hidden_receta_presentacion'],
                ':toppings' => $data['hidden_toppings_presentacion'],
                ':stock_min' => $data['stock_min_presentacion'],
                ':stock_limit' => ($data['hidden_stock_limit'])? $data['hidden_stock_limit']: '0',
                ':impuesto' => $data['hidden_impuesto_presentacion'],
                ':nota' => $data['hidden_nota_presentacion'],
                ':delivery' => $data['hidden_delivery_presentacion'],
                ':llevar' => $data['hidden_llevar_presentacion'],
                ':margen' => $data['hidden_insumo_principal_presentacion'],
                ':igv' => Session::get('igv'),
                ':imagen' => $imagen,
                ':ordenins' => $data['ordenins'] ? $data['ordenins'] : 1,
                ':estado' => $data['hidden_estado_presentacion'],
                ':notas' => $datanota,
                ':usar_impuesto_sistema' => $usar_impuesto_sistema_db,
                ':impuesto_incluido_personalizado' => $impuesto_incluido_db,
                ':impuesto_porcentaje_personalizado' => $impuesto_porcentaje_personalizado
            );
            
            $st = $this->db->prepare($consulta);
            $st->execute($arrayParam);
            $codigo_retorno = null;
            while ($row = $st->fetch(PDO::FETCH_ASSOC)) {
                $codigo_retorno = $row['cod'];
            }
            // Cerrar el cursor del stored procedure
            $st->closeCursor();
            
            // Verificar que se guardó correctamente
            if($codigo_retorno == 2){
                $verificar = $this->db->prepare("SELECT usar_impuesto_sistema, impuesto_incluido_personalizado, impuesto_porcentaje_personalizado FROM tm_producto_pres WHERE id_pres = ?");
                $verificar->execute(array($data['id_pres_presentacion']));
                $verificado = $verificar->fetch(PDO::FETCH_ASSOC);
                error_log("VERIFICACIÓN POST-SP: usar_impuesto_sistema=" . $verificado['usar_impuesto_sistema'] . " | impuesto_incluido=" . $verificado['impuesto_incluido_personalizado'] . " | porcentaje=" . ($verificado['impuesto_porcentaje_personalizado'] ?? 'null') . " | id_pres=" . $data['id_pres_presentacion'], 3, 'C:\\xampp7433\\htdocs\\error_log');
            }
            
            if($codigo_retorno !== null){
                error_log("RETORNO - producto_pres_crud_update retorna: " . $codigo_retorno . " | id_pres=" . (isset($data['id_pres_presentacion']) ? $data['id_pres_presentacion'] : 'N/A'), 3, 'C:\\xampp7433\\htdocs\\error_log');
                return $codigo_retorno;
            }
        }
        catch (Exception $e) 
        {
            return false;
        }
    }

    public function producto_otros($data)
    {
        try 
        {

            $consulta = "call usp_configProductoPres( :flag, @a, :id_prod, :cod_prod, :presentacion, :descripcion, :precio, :precio_delivery, :precio_delivery_app, :precio_llevar, :costo_unitario, :receta, :toppings, :stock_min,:stock_limit, :impuesto,:nota, :delivery, :llevar, :margen, :igv, :imagen, :ordenins, :estado, :notas, :usar_impuesto_sistema, :impuesto_incluido_personalizado, :impuesto_porcentaje_personalizado);";
            $arrayParam =  array(
                ':flag' => 1,
                ':id_prod' => '1000',
                ':cod_prod' => $data['cod_prod_presentacion'],
                ':presentacion' => $data['presentacion_presentacion'],
                ':descripcion' => '',
                ':precio' => $data['precio_presentacion'],
                ':precio_delivery' => $data['precio_delivery'],
                ':precio_delivery_app' => $data['precio_delivery'],
                ':precio_llevar' => $data['precio_llevar'],
                ':costo_unitario' => 0,
                ':receta' => 0,
                ':toppings' => 0,
                ':stock_min' => '',
                ':stock_limit' => '0',
                ':impuesto' => $data['hidden_impuesto_presentacion'],
                ':nota' => '',
                ':delivery' => 1,
                ':llevar' => 1,
                ':margen' => 0,
                ':igv' => Session::get('igv'),
                ':imagen' => 'default.png',
                ':ordenins' => 1,
                ':estado' => 'a',
                ':notas' => '',
                ':usar_impuesto_sistema' => 1, // Por defecto usar sistema
                ':impuesto_incluido_personalizado' => 0, // Por defecto excluido
                ':impuesto_porcentaje_personalizado' => null // NULL porque usa sistema
            );
            $st = $this->db->prepare($consulta);
            $st->execute($arrayParam);
            while ($row = $st->fetch(PDO::FETCH_ASSOC)) {

                // $stm = $this->db->prepare('SELECT * FROM `v_productos` WHERE pro_cod = '.$data['cod_prod_presentacion']);
                // $stm->execute();
                // $c = $stm->fetch(PDO::FETCH_OBJ);
                // return $c;


                // return $this->db->selectAll('SELECT * FROM `v_productos` WHERE pro_cod = '.$data['cod_prod_presentacion']);
                // SELECT * FROM `v_productos` WHERE pro_cod = 'H123';
                return $row['cod'];
            }
        }
        catch (Exception $e) 
        {
            return false;
        }
    }
    
    public function producto_combo_cat()
    {
        try
        {
            $stm = $this->db->prepare("SELECT * FROM tm_producto_catg WHERE id_catg <> 1");
            $stm->execute();
            $c = $stm->fetchAll(PDO::FETCH_OBJ);
            return $c;
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function producto_combo_unimed($data)
    {
        try
        {   
            $stmm = $this->db->prepare("SELECT * FROM tm_tipo_medida WHERE grupo = ? OR grupo = ?");
            $stmm->execute(array($data['va1'],$data['va2']));
            $var = $stmm->fetchAll(PDO::FETCH_ASSOC);
            foreach($var as $v){
                echo '<option value="'.$v['id_med'].'">'.$v['descripcion'].'</option>';
            }
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function producto_ingrediente_create($data)
    {
        try 
        {          
            $consulta = "call usp_configProductoIngrs( :flag, @a, :id_pres, :id_tipo_ins, :id_ins, :id_med, :cant);";
            $arrayParam =  array(
                ':flag' => 1,
                ':id_pres' => $data['id_pres'],
                ':id_tipo_ins' => $data['id_tipo_ins'],
                ':id_ins' => $data['id_ins'],
                ':id_med' => $data['id_med'],
                ':cant' => $data['cant']
            );
            $st = $this->db->prepare($consulta);
            $st->execute($arrayParam);
        }
        catch (Exception $e) 
        {
            return false;
        }
    }

    /*
    public function producto_ingrediente_update($data)
    {
        try 
        {
            $consulta = "call usp_configProductoIngrs( :flag, :idPres, :idIns, :cant, :idPi);";
            $arrayParam =  array(
                ':flag' => 2,
                ':idPres' => 1,
                ':idIns' => 1,
                ':cant' => $data['cant'],
                ':idPi' => $data['cod'],
            );
            $st = $this->db->prepare($consulta);
            $st->execute($arrayParam);
        }
        catch (Exception $e) 
        {
            return false;
        }
    }
    */

    public function producto_ingrediente_delete($data)
    {
        try 
        {
            $consulta = "call usp_configProductoIngrs( :flag, :id_pi, @a, @b, @c, @d, @e);";
            $arrayParam =  array(
                ':flag' => 3,
                ':id_pi' => $data['id_pi']
            );
            $st = $this->db->prepare($consulta);
            $st->execute($arrayParam);
        }
        catch (Exception $e) 
        {
            return false;
        }
    }

    public function producto_cat_delete($data)
    {
        try 
        {
            $consulta = "call usp_configEliminarCategoriaProd(:id_catg);";
            $arrayParam =  array(
                ':id_catg' => $data['id_catg']
            );
            $st = $this->db->prepare($consulta);
            $st->execute($arrayParam);
            while ($row = $st->fetch(PDO::FETCH_ASSOC)) {
                return $row['cod'];
            }
        } catch (Exception $e) 
        {
            die($e->getMessage());
        }
    }

    public function producto_prod_delete($data)
    {
        try 
        {
            $consulta = "DELETE FROM tm_producto WHERE id_prod = ?;";
            $st = $this->db->prepare($consulta);
            $st->execute(array($data['id_prod']));
            $st->fetch(PDO::FETCH_ASSOC);
            if($st->rowCount()){
                return 1;
            }else{
                return 0;
            }
        } catch (Exception $e) 
        {
            die($e->getMessage());
        }
    }

    public function producto_pres_delete($data)
    {
        try 
        {
            // DELETE FROM tm_producto_pres WHERE tm_producto_pres.id_pres = 2
            $consulta = "DELETE FROM tm_producto_pres WHERE id_pres = ?";
            $st = $this->db->prepare($consulta);
            $st->execute(array($data['id_pres']));
            $st->fetch(PDO::FETCH_ASSOC);
            if($st->rowCount()){
                return 1;
            }else{
                return 0;
            }
        } catch (Exception $e) 
        {
            die($e->getMessage());
        }
    }


    /* ======================= FIN PRODUCTO */

    public function toppings_producto_ingrediente_create($data)
    {
        try 
        {          
            $consulta = "call usp_configProductoToppings( :flag, @a, :id_pres, :id_tipo_ins, :id_ins, :id_med, :cant, :precio,:descripcion);";
            $arrayParam =  array(
                ':flag' => 1,
                ':id_pres' => $data['id_pres'],
                ':id_tipo_ins' => $data['id_tipo_ins'],
                ':id_ins' => $data['id_ins'],
                ':id_med' => $data['id_med'],
                ':cant' => $data['cant'],
                ':precio' => $data['precio'],
                ':descripcion' => $data['descripcion'],

            );
            $st = $this->db->prepare($consulta);
            $st->execute($arrayParam);
        }
        catch (Exception $e) 
        {
            return false;
        }
    }

    public function toppings_producto_ingrediente_delete($data)
    {
        try 
        {
            $consulta = "call usp_configProductoToppings( :flag, :id_pi, @a, @b, @c, @d, @e, @f,@g);";
            $arrayParam =  array(
                ':flag' => 3,
                ':id_pi' => $data['id_pi']
            );
            $st = $this->db->prepare($consulta);
            $st->execute($arrayParam);
        }
        catch (Exception $e) 
        {
            return false;
        }
    }

    public function toppings_producto_pres_ing($data)
    {
        try
        {
            $stm = $this->db->prepare("SELECT * FROM tm_producto_toppings WHERE id_pres = ?");
            $stm->execute(array($data['id_pres']));
            $c = $stm->fetchAll(PDO::FETCH_OBJ);
            foreach($c as $k => $d)
            {
                $c[$k]->{'Insumo'} = $this->db->query("SELECT ins_med,ins_nom,ins_cat FROM v_insprod WHERE id_tipo_ins = ".$d->id_tipo_ins." AND id_ins = ".$d->id_ins)
                ->fetch(PDO::FETCH_OBJ);
            }
            foreach($c as $k => $d)
            {
                $c[$k]->{'Medida'} = $this->db->query("SELECT descripcion FROM tm_tipo_medida WHERE id_med = ".$d->id_med)
                ->fetch(PDO::FETCH_OBJ);
            }
            return $c;
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    /* ======================= INCIO COMBO */

    public function producto_cat_list_combos()
    {
        try
        {
            $stm = $this->db->prepare("SELECT * FROM tm_producto_catg WHERE combos = 1 ORDER BY orden ASC");
            $stm->execute();
            $c = $stm->fetchAll(PDO::FETCH_OBJ);
            $data = array("data" => $c);
            $json = json_encode($data);
            echo $json; 
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }
    
    public function combo_list()
    {
        try
        {

            $stm = $this->db->prepare("SELECT * FROM tm_producto WHERE id_prod like ? AND id_catg like ?  ORDER BY id_prod DESC");
            $stm->execute(array($_POST['id_prod'],$_POST['id_catg']));


            // $stm = $this->db->prepare("SELECT * FROM tm_producto WHERE id_prod like ? AND id_catg = 1 ORDER BY id_prod DESC");
            // $stm->execute(array($_POST['id_prod']));
            $c = $stm->fetchAll(PDO::FETCH_OBJ);
            $data = array("data" => $c);
            $json = json_encode($data);
            echo $json; 
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function combo_cat_crud_create($data)
    {
        try 
        {
            if( !empty( $_FILES['imagen']['name'] ) ){
                switch ($_FILES['imagen']['type']) 
                { 
                    case 'image/jpeg': 
                    $ext = "jpg"; 
                    break;
                    case 'image/gif': 
                    $ext = "gif"; 
                    break; 
                    case 'image/png': 
                    $ext = "png"; 
                    break;
                    case 'application/pdf':
                    $ext = "pdf";
                    break;
                }
                $imagen = date('ymdhis').'.'.$ext;
                move_uploaded_file ($_FILES['imagen']['tmp_name'], 'public/images/productos/'.$imagen);
            } else {
                $imagen = $data['imagen'];
            }

            $consulta = "INSERT INTO tm_producto_catg (descripcion, delivery, orden, imagen, estado, combos) VALUES (:descripcion, :delivery, :orden, :imagen, :estado, '1')";
            $arrayParam =  array(
                ':descripcion' => $data['descripcion_categoria'],
                ':delivery' => $data['hidden_delivery_categoria'],
                ':orden' => 100,
                ':imagen' => $imagen,
                ':estado' => $data['hidden_estado_categoria']
            );
            $st = $this->db->prepare($consulta);
            $st->execute($arrayParam);
            $row = $st->fetch(PDO::FETCH_ASSOC);
            if (!$row) {
                return '1';
            }
        }
        catch (Exception $e) 
        {
            return false;
        }
    }

    public function combo_cat_crud_update($data)
    {
        try 
        {
            if( !empty( $_FILES['imagen']['name'] ) ){
                switch ($_FILES['imagen']['type']) 
                { 
                    case 'image/jpeg': 
                    $ext = "jpg"; 
                    break;
                    case 'image/gif': 
                    $ext = "gif"; 
                    break; 
                    case 'image/png': 
                    $ext = "png"; 
                    break;
                    case 'application/pdf':
                    $ext = "pdf";
                    break;
                }
                $imagen = date('ymdhis').'.'.$ext;
                move_uploaded_file ($_FILES['imagen']['tmp_name'], 'public/images/productos/'.$imagen);
            } else {
                $imagen = $data['imagen'];
            }

            $consulta = "UPDATE tm_producto_catg SET descripcion = :descripcion, delivery = :delivery, orden = :orden, imagen = :imagen, estado = :estado WHERE id_catg = :id_catg";
            $arrayParam =  array(
                ':descripcion' => $data['descripcion_categoria'],
                ':delivery' => $data['hidden_delivery_categoria'],
                ':orden' => $data['orden_categoria'],
                ':imagen' => $imagen,
                ':estado' => $data['hidden_estado_categoria'],
                ':id_catg' => $data['id_catg_categoria']
            );
            $st = $this->db->prepare($consulta);
            $st->execute($arrayParam);
            $row = $st->fetch(PDO::FETCH_ASSOC);

            if (!$row) {
                return '2';
            }
        }
        catch (Exception $e) 
        {
            return false;
        }
    }

    public function combo_combo_cat()
    {
        try
        {
            $stm = $this->db->prepare("SELECT * FROM tm_producto_catg WHERE combos = 1");
            $stm->execute();
            $c = $stm->fetchAll(PDO::FETCH_OBJ);
            return $c;
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }



    /* ======================= FIN COMBO */

    /* ======================= INICIO INSUMO */

    public function insumo_cat_list()
    {
        try
        {
            $stm = $this->db->prepare("SELECT * FROM tm_insumo_catg");
            $stm->execute();
            $c = $stm->fetchAll(PDO::FETCH_OBJ);
            $data = array("data" => $c);
            $json = json_encode($data);
            echo $json; 
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function insumo_list()
    {
        try
        {
            $stm = $this->db->prepare("SELECT * FROM v_insumos WHERE id_ins like ? AND id_catg like ? ORDER BY id_ins DESC");
            $stm->execute(array($_POST['id_ins'],$_POST['id_catg']));
            $c = $stm->fetchAll(PDO::FETCH_OBJ);
            $data = array("data" => $c);
            $json = json_encode($data);
            echo $json; 
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function insumo_combo_cat()
    {
        try
        {
            $stm = $this->db->prepare("SELECT * FROM tm_insumo_catg");
            $stm->execute();
            $c = $stm->fetchAll(PDO::FETCH_OBJ);
            return $c;
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function insumo_cat_crud_create($data)
    {
        try 
        {
            $consulta = "call usp_configInsumoCatgs( :flag, :descC, @a);";
            $arrayParam =  array(
                ':flag' => 1,
                ':descC' => $data['descripcion']
            );
            $st = $this->db->prepare($consulta);
            $st->execute($arrayParam);
            while ($row = $st->fetch(PDO::FETCH_ASSOC)) {
                return $row['cod'];
            }
        }
        catch (Exception $e) 
        {
            return false;
        }
    }

    public function insumo_cat_crud_update($data)
    {
        try 
        {
            $consulta = "call usp_configInsumoCatgs( :flag, :descC, :idCatg);";
            $arrayParam =  array(
                ':flag' => 2,
                ':descC' => $data['descripcion'],
                ':idCatg' => $data['id_catg']
            );
            $st = $this->db->prepare($consulta);
            $st->execute($arrayParam);
            while ($row = $st->fetch(PDO::FETCH_ASSOC)) {
                return $row['cod'];
            }
        }
        catch (Exception $e) 
        {
            return false;
        }
    }

    public function insumo_crud_create($data)
    {
        try
        {
            $consulta = "call usp_configInsumo( :flag, :idCatg, :idMed, :cod, :nombre, :stock, :costo, @a, @b);";
            $arrayParam =  array(
                ':flag' => 1,
                ':idCatg' => $data['id_catg'],
                ':idMed' => $data['id_med'],
                ':cod' => $data['cod_ins'],
                ':nombre' => $data['nomb_ins'],
                ':stock' => $data['stock_min'],
                ':costo' => $data['cos_uni']
            );
            $st = $this->db->prepare($consulta);
            $st->execute($arrayParam);
            while ($row = $st->fetch(PDO::FETCH_ASSOC)) {
                return $row['cod'];
            }
        } catch (Exception $e) 
        {
            die($e->getMessage());
        }
    }

    public function insumo_crud_update($data)
    {
        try 
        {
            $consulta = "call usp_configInsumo( :flag, :idCatg, :idMed, :cod, :nombre, :stock, :costo, :estado, :idIns);";
            $arrayParam =  array(
                ':flag' => 2,
                ':idCatg' => $data['id_catg'],
                ':idMed' => $data['id_med'],
                ':cod' => $data['cod_ins'],
                ':nombre' => $data['nomb_ins'],
                ':stock' => $data['stock_min'],
                ':costo' => $data['cos_uni'],
                ':estado' => $data['estado'],
                ':idIns' => $data['id_ins']
            );
            $st = $this->db->prepare($consulta);
            $st->execute($arrayParam);
            while ($row = $st->fetch(PDO::FETCH_ASSOC)) {
                return $row['cod'];
            }
        } catch (Exception $e) 
        {
            die($e->getMessage());
        }
    }

    public function insumo_cat_delete($data)
    {
        try 
        {
            $consulta = "call usp_configEliminarCategoriaIns(:id_catg);";
            $arrayParam =  array(
                ':id_catg' => $data['id_catg']
            );
            $st = $this->db->prepare($consulta);
            $st->execute($arrayParam);
            while ($row = $st->fetch(PDO::FETCH_ASSOC)) {
                return $row['cod'];
            }
        } catch (Exception $e) 
        {
            die($e->getMessage());
        }
    }

    public function print_list($data)
    {
        try
        {
           
            $stm = $this->db->prepare("SELECT * FROM tm_impresora WHERE id_imp <> 1 AND id_imp LIKE ?");
            $stm->execute(array($data['id_imp']));
            $c = $stm->fetchAll(PDO::FETCH_OBJ);
            $data = array("data" => $c);
            $json = json_encode($data);
            echo $json; 
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function print_crud_create($data)
    {
        try
        {
            $consulta = "call usp_configImpresoras( :flag, @a, :nombre, :estado);";
            $arrayParam =  array(
                ':flag' => 1,
                ':nombre' => $data['nombre'],
                ':estado' => $data['estado']
            );
            $st = $this->db->prepare($consulta);
            $st->execute($arrayParam);
            while ($row = $st->fetch(PDO::FETCH_ASSOC)) {
                return $row['cod'];
            }
        } catch (Exception $e) 
        {
            die($e->getMessage());
        }
    }

    public function print_crud_update($data)
    {
        try 
        {
            $consulta = "call usp_configImpresoras( :flag, :id_imp, :nombre, :estado);";
            $arrayParam =  array(
                ':flag' => 2,
                ':id_imp' => $data['id_imp'],
                ':nombre' => $data['nombre'],
                ':estado' => $data['estado']
            );
            $st = $this->db->prepare($consulta);
            $st->execute($arrayParam);
            while ($row = $st->fetch(PDO::FETCH_ASSOC)) {
                return $row['cod'];
            }
        } catch (Exception $e) 
        {
            die($e->getMessage());
        }
    }

    /* ======================= FIN INSUMO */

    /* FIN MODULO RESTAURANTE */

    public function optimizar_pedidos()
    {
        try
        {
            $consulta = "call usp_optPedidos(:flag);";
            $arrayParam =  array(
                ':flag' => 1
            );
            $st = $this->db->prepare($consulta);
            $st->execute($arrayParam);
            while ($row = $st->fetch(PDO::FETCH_ASSOC)) {
                // return $row;
                return $row['cod'];
            }
        } catch (Exception $e) 
        {
            die($e->getMessage());
        }
    }

    public function optimizar_pedidos_llevar()
    {
        try
        {
            $consulta = "call usp_optPedidos(:flag);";
            $arrayParam =  array(
                ':flag' => 9
            );
            $st = $this->db->prepare($consulta);
            $st->execute($arrayParam);
            while ($row = $st->fetch(PDO::FETCH_ASSOC)) {
                // return $row;
                return $row['cod'];
            }
        } catch (Exception $e) 
        {
            die($e->getMessage());
        }
    }    

    public function optimizar_ventas()
    {
        try
        {
            $consulta = "call usp_optPedidos(:flag);";
            $arrayParam =  array(
                ':flag' => 2
            );
            $st = $this->db->prepare($consulta);
            $st->execute($arrayParam);
            while ($row = $st->fetch(PDO::FETCH_ASSOC)) {
                return $row['cod'];
            }
        } catch (Exception $e) 
        {
            die($e->getMessage());
        }
    }

    public function optimizar_productos()
    {
        try
        {
            $consulta = "call usp_optPedidos(:flag);";
            $arrayParam =  array(
                ':flag' => 3
            );
            $st = $this->db->prepare($consulta);
            $st->execute($arrayParam);
            while ($row = $st->fetch(PDO::FETCH_ASSOC)) {
                return $row['cod'];
            }
        } catch (Exception $e) 
        {
            die($e->getMessage());
        }
    }

    public function optimizar_insumos()
    {
        try
        {
            $consulta = "call usp_optPedidos(:flag);";
            $arrayParam =  array(
                ':flag' => 4
            );
            $st = $this->db->prepare($consulta);
            $st->execute($arrayParam);
            while ($row = $st->fetch(PDO::FETCH_ASSOC)) {
                return $row['cod'];
            }
        } catch (Exception $e) 
        {
            die($e->getMessage());
        }
    }

    public function optimizar_clientes()
    {
        try
        {
            $consulta = "call usp_optPedidos(:flag);";
            $arrayParam =  array(
                ':flag' => 5
            );
            $st = $this->db->prepare($consulta);
            $st->execute($arrayParam);
            while ($row = $st->fetch(PDO::FETCH_ASSOC)) {
                return $row['cod'];
            }
        } catch (Exception $e) 
        {
            die($e->getMessage());
        }
    }

    public function optimizar_proveedores()
    {
        try
        {
            $consulta = "call usp_optPedidos(:flag);";
            $arrayParam =  array(
                ':flag' => 6
            );
            $st = $this->db->prepare($consulta);
            $st->execute($arrayParam);
            while ($row = $st->fetch(PDO::FETCH_ASSOC)) {
                return $row['cod'];
            }
        } catch (Exception $e) 
        {
            die($e->getMessage());
        }
    }

    public function optimizar_mesas()
    {
        try
        {
            $consulta = "call usp_optPedidos(:flag);";
            $arrayParam =  array(
                ':flag' => 7
            );
            $st = $this->db->prepare($consulta);
            $st->execute($arrayParam);
            while ($row = $st->fetch(PDO::FETCH_ASSOC)) {
                return $row['cod'];
            }
        } catch (Exception $e) 
        {
            die($e->getMessage());
        }
    }
    public function optimizar_pedidos_caja()
    {
        try
        {
            $consulta = "call usp_optPedidos(:flag);";
            $arrayParam =  array(
                ':flag' => 8
            );
            $st = $this->db->prepare($consulta);
            $st->execute($arrayParam);
            while ($row = $st->fetch(PDO::FETCH_ASSOC)) {
                // return $row;
                return $row['cod'];
            }
        } catch (Exception $e) 
        {
            die($e->getMessage());
        }
    }


    public function optimizar_comensales()
    {
        try
        {
            $consulta = "call usp_optPedidos(:flag);";
            $arrayParam =  array(
                ':flag' => 7
            );
            $st = $this->db->prepare($consulta);
            $st->execute($arrayParam);
            while ($row = $st->fetch(PDO::FETCH_ASSOC)) {
                return $row['cod'];
            }
        } catch (Exception $e) 
        {
            die($e->getMessage());
        }
    }
    
    public function optimizar_inventario()
    {
        try
        {
            $consulta = "call usp_optPedidos(:flag);";
            $arrayParam =  array(
                ':flag' => 18
            );
            $st = $this->db->prepare($consulta);
            $st->execute($arrayParam);
            while ($row = $st->fetch(PDO::FETCH_ASSOC)) {
                return $row['cod'];
            }
        } catch (Exception $e) 
        {
            die($e->getMessage());
        }
    } 
 
    public function optimizar_usuarios()
    {
        try
        {
            $consulta = "call usp_optPedidos(:flag);";
            $arrayParam =  array(
                ':flag' => 19
            );
            $st = $this->db->prepare($consulta);
            $st->execute($arrayParam);
            while ($row = $st->fetch(PDO::FETCH_ASSOC)) {
                return $row['cod'];
            }
        } catch (Exception $e) 
        {
            die($e->getMessage());
        }
    }    

    public function datosistema_data()
    {
        try
        {    
            $stm = $this->db->prepare("SELECT * FROM tm_configuracion");
            $stm->execute();
            $c = $stm->fetch(PDO::FETCH_OBJ);
            return $c;
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function datosistema_crud($data)
    {
        try 
        {

            $array = array(
                'zona_hora' => $data['zona_hora'],
                'trib_acr' => $data['trib_acr'],
                'trib_car' => $data['trib_car'],
                'di_acr' => $data['di_acr'],
                'di_car' => $data['di_car'],
                'imp_acr' => $data['imp_acr'],
                'imp_val' => $data['imp_val'],
                'impuesto_incluido' => isset($data['impuesto_incluido']) ? $data['impuesto_incluido'] : 0,
                'mon_acr' => $data['mon_acr'],
                'mon_val' => $data['mon_val'],
                'pc_name' => $data['pc_name'],
                'pc_ip' => $data['pc_ip'],
                'print_com' => $data['print_com'],
                'print_pre' => $data['print_pre'],
                'print_cpe' => $data['print_cpe'],
                'cod_seg' => $data['cod_seg'],
                'opc_01' => $data['opc_01'],
                'editprice' => '0',
                'multimozo' => $data['multimozo'],
                'print_com_combo' => $data['print_com_combo'],
                'com_delivery' => $data['com_delivery'],
                'com_rc' => $data['com_rc'],
                'com_rc_val' => $data['com_rc_val'],
                'com_tar' => $data['com_tar'],
                'com_tar_val' => $data['com_tar_val'],
                'nota_ind' => $data['nota_ind'],
                'anular_pedido_mesa' => $data['anular_pedido_mesa'],
                'anular_pedido_mesa_com' => $data['anular_pedido_mesa_com'],
                'anular_pedido_llevar' => $data['anular_pedido_llevar'],
                'anular_pedido_llevar_com' => $data['anular_pedido_llevar_com'],
                'anular_pedido_delivery' => $data['anular_pedido_delivery'],
                'anular_pedido_delivery_com' => $data['anular_pedido_delivery_com'],
                'print_com_re' => $data['print_com_re'],
                'prod_caja_sep' => $data['prod_caja_sep'],
                'mesa_ticket_desp' => $data['mesa_ticket_desp'],
                'llevar_ticket_desp' => $data['llevar_ticket_desp'],
                'delivery_ticket_desp' => $data['delivery_ticket_desp'],
                'pdf_logo_dim' => $data['pdf_logo_dim'],
                'pdf_logo_alt' => $data['pdf_logo_alt'],
                'pdf_logo_mg' => $data['pdf_logo_mg'],
                'printer_select' => $data['printer_select'],
                'report_date' => $data['report_date'],
                'activated_pres' => $data['activated_pres'],
                'activated_price_com' => $data['activated_price_com'],
                'activated_open_gaveta' => $data['activated_open_gaveta'],
                'activated_vista_pos_2' => $data['activated_vista_pos_2'],
                'sep_items' => $data['sep_items'],
                'desactivar_precuenta' => $data['desactivar_precuenta'],
                'actu_automatica_mesa' => $data['actu_automatica_mesa'],
                'decimal_stock' => $data['decimal_stock'],
                'cat_menu' => $data['cat_menu']
            );
            $this->db->update('tm_configuracion', $array, 'id_cfg = 1');

            /* ACTUALIZAR DATOS */
            Session::set('moneda', $data['mon_val']);
            Session::set('igv', $data['imp_val'] / 100);
            Session::set('imp_val', $data['imp_val']); // Porcentaje de impuesto (ej: 10 para 10%)
            Session::set('tribAcr', $data['trib_acr']);
            Session::set('tribCar', $data['trib_car']);
            Session::set('diAcr', $data['di_acr']);
            Session::set('diCar', $data['di_car']);
            Session::set('impAcr', $data['imp_acr']);
            Session::set('impuesto_incluido', isset($data['impuesto_incluido']) ? $data['impuesto_incluido'] : 0);
            Session::set('monAcr', $data['mon_acr']);
            Session::set('zona_hor', $data['zona_hora']);
            Session::set('pc_name', $data['pc_name']);
            Session::set('pc_ip', $data['pc_ip']);
            Session::set('print_com', $data['print_com']);
            Session::set('print_pre', $data['print_pre']);
            Session::set('print_cpe', $data['print_cpe']); //funcion impresion directa 
            Session::set('cod_seg', $data['cod_seg']); //funcion codigo de seguridad 
            Session::set('opc_01', $data['opc_01']); //funcion codigo de seguridad 
            // Session::set('editprice', $data['editprice']); //funcion editar precio venta vendedor
            Session::set('multimozo', $data['multimozo']); // quitar modal del multimozo 
            Session::set('print_com_combo', $data['print_com_combo']); // imprimir los platos de un combo  en sus respectivas areas 
            Session::set('com_delivery', $data['com_delivery']);

            Session::set('com_rc', $data['com_rc_val']);
            Session::set('com_tar', $data['com_tar_val']);
            Session::set('nota_ind', $data['nota_ind']);

            Session::set('anular_pedido_mesa', $data['anular_pedido_mesa']);
            Session::set('anular_pedido_mesa_com', $data['anular_pedido_mesa_com']);

            Session::set('anular_pedido_llevar', $data['anular_pedido_llevar']);
            Session::set('anular_pedido_llevar_com', $data['anular_pedido_llevar_com']);

            Session::set('anular_pedido_delivery', $data['anular_pedido_delivery']);
            Session::set('anular_pedido_delivery_com', $data['anular_pedido_delivery_com']);

            Session::set('print_com_re', $data['print_com_re']);
            Session::set('caja_prod_sep', $data['prod_caja_sep']);
            Session::set('report_date', $data['report_date']);
            Session::set('activated_pres', $data['activated_pres']);
            Session::set('activated_price_com', $data['activated_price_com']);
            Session::set('activated_open_gaveta', $data['activated_open_gaveta']);
            Session::set('activated_vista_pos_2', $data['activated_vista_pos_2']);
            Session::set('sep_items', $data['sep_items']);
            Session::set('desactivar_precuenta', $data['desactivar_precuenta']);
            Session::set('actu_automatica_mesa', $data['actu_automatica_mesa']);
            Session::set('decimal_stock', $data['decimal_stock']);
            Session::set('cat_menu', $data['cat_menu']);


        } catch (Exception $e) 
        {
            die($e->getMessage());
        }
    }

    public function facturacion_electronica_data()
    {
        try
        {    
            $stm = $this->db->prepare("SELECT * FROM tm_facturacion_electronica WHERE id_facturacion = 1");
            $stm->execute();
            $c = $stm->fetch(PDO::FETCH_OBJ);
            if (!$c) {
                // Si no existe registro, crear uno por defecto
                $stm_insert = $this->db->prepare("INSERT INTO tm_facturacion_electronica (id_facturacion, ff_company_uuid, ff_api_key, ff_branch, activo, envio_automatico) VALUES (1, NULL, NULL, NULL, 0, 0)");
                $stm_insert->execute();
                $c = (object)['id_facturacion' => 1, 'ff_company_uuid' => NULL, 'ff_api_key' => NULL, 'ff_branch' => NULL, 'activo' => 0];
            }
            return $c;
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function facturacion_electronica_crud($data)
    {
        try 
        {
            $array = array(
                'ff_company_uuid' => isset($data['ff_company_uuid']) ? trim($data['ff_company_uuid']) : null,
                'ff_api_key' => isset($data['ff_api_key']) ? trim($data['ff_api_key']) : null,
                'ff_branch' => isset($data['ff_branch']) ? trim($data['ff_branch']) : null,
                'branch_address' => isset($data['branch_address']) ? $data['branch_address'] : null,
                'branch_phone' => isset($data['branch_phone']) ? $data['branch_phone'] : null,
                'branch_location' => isset($data['branch_location']) ? $data['branch_location'] : null,
                'branch_coordinates' => isset($data['branch_coordinates']) ? $data['branch_coordinates'] : null,
                'branch_email' => isset($data['branch_email']) ? $data['branch_email'] : null,
                'activo' => isset($data['facturacion_activa']) ? $data['facturacion_activa'] : 0,
                'envio_automatico' => isset($data['envio_automatico']) ? (int)$data['envio_automatico'] : 0
            );
            
            // Verificar si existe el registro
            $stm_check = $this->db->prepare("SELECT id_facturacion FROM tm_facturacion_electronica WHERE id_facturacion = 1");
            $stm_check->execute();
            $exists = $stm_check->fetch(PDO::FETCH_OBJ);
            
            if ($exists) {
                $this->db->update('tm_facturacion_electronica', $array, 'id_facturacion = 1');
            } else {
                $array['id_facturacion'] = 1;
                $this->db->insert('tm_facturacion_electronica', $array);
            }

            return array('success' => true, 'message' => 'Configuración de facturación electrónica guardada correctamente');

        } catch (Exception $e) 
        {
            return array('success' => false, 'message' => $e->getMessage());
        }
    }

    /**
     * Actualizar solo el flag de envío automático (sin tocar el resto de la config)
     */
    public function facturacion_electronica_envio_automatico($valor)
    {
        try {
            $valor = (int)$valor;
            $stm = $this->db->prepare("UPDATE tm_facturacion_electronica SET envio_automatico = ? WHERE id_facturacion = 1");
            $stm->execute(array($valor));
            return array('success' => true, 'message' => 'Envío automático ' . ($valor ? 'activado' : 'desactivado'));
        } catch (Exception $e) {
            return array('success' => false, 'message' => $e->getMessage());
        }
    }

    public function series_documentos_list()
    {
        try
        {
            $stm = $this->db->prepare("SELECT * FROM tm_series_documentos ORDER BY tipo_documento, pos, ambiente");
            $stm->execute();
            $result = $stm->fetchAll(PDO::FETCH_ASSOC);
            
            header('Content-Type: application/json');
            echo json_encode(array(
                "data" => $result
            ));
        }
        catch(Exception $e)
        {
            header('Content-Type: application/json');
            echo json_encode(array(
                "data" => array(),
                "error" => $e->getMessage()
            ));
        }
    }

    public function series_documentos_data($data)
    {
        try
        {
            $stm = $this->db->prepare("SELECT * FROM tm_series_documentos WHERE id_serie = ?");
            $stm->execute(array($data['id_serie']));
            $result = $stm->fetch(PDO::FETCH_ASSOC);
            
            if ($result) {
                return array('success' => true, 'data' => $result);
            } else {
                return array('success' => false, 'message' => 'Serie no encontrada');
            }
        }
        catch(Exception $e)
        {
            return array('success' => false, 'message' => $e->getMessage());
        }
    }

    public function series_documentos_crud($data)
    {
        try 
        {
            // Validar que el POS tenga 3 dígitos
            $pos = str_pad($data['pos'], 3, '0', STR_PAD_LEFT);
            if (strlen($pos) != 3 || !is_numeric($pos)) {
                return array('success' => false, 'message' => 'El POS debe ser exactamente 3 dígitos numéricos');
            }

            // Validar números fiscales
            $numero_inicial = intval($data['numero_inicial']);
            $numero_actual = intval($data['numero_actual']);
            $numero_final = intval($data['numero_final']);

            if ($numero_inicial < 1 || $numero_inicial > 9999999999) {
                return array('success' => false, 'message' => 'El número inicial debe estar entre 1 y 9999999999');
            }

            if ($numero_actual < $numero_inicial) {
                return array('success' => false, 'message' => 'El número actual no puede ser menor al número inicial');
            }

            if ($numero_final < $numero_actual) {
                return array('success' => false, 'message' => 'El número final no puede ser menor al número actual');
            }

            $array = array(
                'tipo_documento' => $data['tipo_documento'],
                'serie' => isset($data['serie']) ? $data['serie'] : NULL,
                'pos' => $pos,
                'numero_inicial' => $numero_inicial,
                'numero_actual' => $numero_actual,
                'numero_final' => $numero_final,
                'ambiente' => $data['ambiente'],
                'activo' => isset($data['activo']) ? $data['activo'] : 1
            );

            if (isset($data['id_serie']) && !empty($data['id_serie'])) {
                // Actualizar
                $this->db->update('tm_series_documentos', $array, 'id_serie = ' . intval($data['id_serie']));
                return array('success' => true, 'message' => 'Serie actualizada correctamente');
            } else {
                // Verificar que no exista una serie con el mismo tipo, pos y ambiente
                $stm_check = $this->db->prepare("SELECT id_serie FROM tm_series_documentos WHERE tipo_documento = ? AND pos = ? AND ambiente = ?");
                $stm_check->execute(array($data['tipo_documento'], $pos, $data['ambiente']));
                $exists = $stm_check->fetch(PDO::FETCH_OBJ);
                
                if ($exists) {
                    return array('success' => false, 'message' => 'Ya existe una serie con este tipo de documento, POS y ambiente');
                }
                
                // Insertar
                $this->db->insert('tm_series_documentos', $array);
                return array('success' => true, 'message' => 'Serie creada correctamente');
            }

        } catch (Exception $e) 
        {
            return array('success' => false, 'message' => $e->getMessage());
        }
    }

    public function series_documentos_delete($data)
    {
        try 
        {
            $stm = $this->db->prepare("DELETE FROM tm_series_documentos WHERE id_serie = ?");
            $stm->execute(array($data['id_serie']));
            
            return array('success' => true, 'message' => 'Serie eliminada correctamente');
        } 
        catch (Exception $e) 
        {
            return array('success' => false, 'message' => $e->getMessage());
        }
    }

    public function series_documentos_activas($data = array())
    {
        try 
        {
            $where = "WHERE activo = 1";
            $params = array();
            
            // Si se especifica tipo de documento, filtrar
            if (isset($data['tipo_documento']) && !empty($data['tipo_documento'])) {
                // Si el tipo es FAC, NTC o NTD directamente, usarlo
                if (in_array($data['tipo_documento'], array('FAC', 'NTC', 'NTD'))) {
                    $where .= " AND tipo_documento = ?";
                    $params[] = $data['tipo_documento'];
                }
                // Si no es un tipo válido de facturafacil, no filtrar por tipo
            }
            
            // Si se especifica ambiente, filtrar
            if (isset($data['ambiente']) && !empty($data['ambiente'])) {
                $where .= " AND ambiente = ?";
                $params[] = $data['ambiente'];
            }
            // Si no se especifica ambiente, mostrar TODAS las series activas (producción y pruebas)
            
            $sql = "SELECT * FROM tm_series_documentos $where ORDER BY tipo_documento, pos";
            $stm = $this->db->prepare($sql);
            $stm->execute($params);
            $result = $stm->fetchAll(PDO::FETCH_ASSOC);
            
            return array('success' => true, 'data' => $result);
        }
        catch(Exception $e)
        {
            return array('success' => false, 'message' => $e->getMessage(), 'data' => array());
        }
    }

    public function anularlogo()
    {
        try
        {    
            $stm = $this->db->prepare("UPDATE tm_empresa SET logo = NULL WHERE tm_empresa.id_de = 1");
            $stm->execute();
            // return $c;
            if($stm){
                return '1';
            }
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function bloqueoplataforma($data)
    {
        try
        {    

            // id_bloqueo: 2109172516
            // UPDATE tm_configuracion SET bloqueo = '0' WHERE tm_configuracion.id_cfg = 1;
            // $sql = "UPDATE tm_configuracion SET zona_hora = ?,trib_acr = ?,trib_car = ?,di_acr = ?,di_car = ?,imp_acr = ?,imp_val = ?,mon_acr = ?,mon_val = ?,pc_name = ?,pc_ip = ?,print_com = ?,print_pre = ?,print_cpe = ?";
            // $this->db->prepare($sql)->execute();




            $stm = $this->db->prepare("UPDATE tm_configuracion SET bloqueo = ? WHERE id_cfg = '1' ");
            $stm->execute(array($data['tipo_bloqueo']));
            // return $c;
            if($stm){
                // Session::set('moneda', $data['mon_val']);
                Session::set('bloqueo_id', $data['tipo_bloqueo']); 
                return '1';
            }
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }
    // bloqueoplataforma
    public function limit($data)
    {
        try{
            if($data == 'user'){
                $usuarios   = $this->db->prepare('SELECT COUNT(*) total FROM tm_usuario WHERE id_rol != 1');
                $usuarios->execute();
                $plan       = $this->db->prepare('SELECT plan FROM tm_configuracion');
                $plan->execute();
                $plan           = json_decode($plan->fetch(PDO::FETCH_COLUMN));
                return [
                    'limits' => [
                        'total_users' => $plan->{'limit_users'},
                    ],
                    'current' => [
                        'total_users' => $usuarios->fetch(PDO::FETCH_COLUMN),
                    ],
                    'locked_users' => $plan->{'locked_users'},

                ];
            }elseif($data == 'invoices'){
                $plan       = $this->db->prepare('SELECT plan FROM tm_configuracion');
                $plan->execute();
                $plan           = json_decode($plan->fetch(PDO::FETCH_COLUMN));

                // $day_start_billing  = date('j', strtotime($plan->{'created_at'}));
                // $day_now            = (int)date('j');

                //     if($day_now <= $day_start_billing)
                //     {
                //         $init  = date('Y').'-'.((int)date('n') -1).'-'.$day_start_billing;
                //         $end   = date('Y-m-d');
                //     }
                //     else{

                //         $init   = date('Y').'-'.((int)date('n') ).'-'.$day_start_billing;
                //         $end    = date('Y-m-d');
                //     }   
                $date = date('Y-m-d', strtotime($plan->{'created_at'}));
                $day_start_billing  = date('d', strtotime($plan->{'created_at'}));
                $day_now            = (int)date('j');
                $end   = date('Y-m-d');
    
                $init   = date('Y').'-'.date('m').'-'.$day_start_billing;
                $end_date = date('Y-m-t', strtotime($date));
                if($day_now <= $day_start_billing){
                    if ($date == $end_date)
                    {
                        $init   = date('Y-m-t',strtotime("- 1 month"));	
                        $frist_date = date('Y-m-01', strtotime($init));
                        $last_date_nm = date('Y-m-t',strtotime($frist_date."+ 1 month")); 
                        // echo $init." hasta ".$last_date_nm;
                    }else {
                        $init   = date('Y').'-'.date('m').'-'.$day_start_billing;
                        $init	= date('Y-m-d',strtotime($init."- 1 month"));
                        $last_date_nm = date('Y-m-d',strtotime($init."+ 1 month")); 
                        // echo $init." hasta ".$last_date_nm;
                    }
                }else{
                    if ($date == $end_date)
                    {	
                        $init   = date('Y-m-t');	
                        $frist_date = date('Y-m-01', strtotime($init));
                        $last_date_nm = date('Y-m-t',strtotime($frist_date."+ 1 month")); 
                        // echo $init." hasta ".$last_date_nm;
                    }else {
                        $init   = date('Y').'-'.date('m').'-'.$day_start_billing;
                        $last_date_nm = date('Y-m-d',strtotime($init."+ 1 month")); 
                        // echo $init." hasta ".$last_date_nm;
                    }
                }

                $comprobantes = $this->db->prepare("SELECT COUNT(*) total_comprobantes FROM tm_venta WHERE id_tipo_doc != 3 AND (date(fecha_venta) BETWEEN ? AND ?);");
                $comprobantes->execute(array($init,$end)); 
                return [
                    'limits' => [
                        'total_invoices' => $plan->{'limit_documents'},
                    ],
                    'current' => [
                        'total_invoices'    => $comprobantes->fetch(PDO::FETCH_COLUMN),
                    ],
                    'locked_invoices' => $plan->{'locked_documents'},
                ];
                
            }/* elseif($data == 'bloqueo_pos'){
                $plan       = $this->db->prepare('SELECT plan FROM tm_configuracion');
                $plan->execute();
                $plan           = json_decode($plan->fetch(PDO::FETCH_COLUMN));
                return [
                    'activated_mesa' => $plan->{'activated_mesa'},
                    'activated_llevar' => $plan->{'activated_llevar'},
                    'activated_delivery' => $plan->{'activated_delivery'},
                    'activated_pdv_pos' => $plan->{'activated_pdv_pos'},
                    'activated_mod_compras' => $plan->{'activated_mod_compras'},
                    'activated_mod_inv' => $plan->{'activated_mod_inv'},
                    'activated_mod_ins_recet_topp' => $plan->{'activated_mod_ins_recet_topp'},
                ];                
            } */

        }catch(Exception $e)
        {
            die($e->getMessage());
        }
    }
    public function contadorplan()
    {
        try
        {    

            $empresa    = $this->db->selectOne('SELECT nombre_comercial,ruc,logo FROM tm_empresa');
            $usuarios   = $this->db->prepare('SELECT COUNT(*) total FROM tm_usuario WHERE id_rol != 1');
            $usuarios->execute();
            $plan       = $this->db->prepare('SELECT plan FROM tm_configuracion');
            $plan->execute();

            $c{'empresa'}   = $empresa;
            $plan           = json_decode($plan->fetch(PDO::FETCH_COLUMN));

            // $day_start_billing  = date('j', strtotime($plan->{'created_at'}));
            // $day_now            = (int)date('j');
            // $end   = date('Y-m-d');

            
            // if($day_now <= $day_start_billing)
            // {
            //     $init  = date('Y').'-'.((int)date('n') -1).'-'.$day_start_billing;
            //     $end   = date('Y-m-d');
            // }
            // else{

            //     $init   = date('Y').'-'.((int)date('n') ).'-'.$day_start_billing;
            //     $end    = date('Y-m-d');
            // }   
            $date = date('Y-m-d', strtotime($plan->{'created_at'}));
            $day_start_billing  = date('d', strtotime($plan->{'created_at'}));
            $day_now            = (int)date('j');
            $end   = date('Y-m-d');

            $init   = date('Y').'-'.date('m').'-'.$day_start_billing;
            $end_date = date('Y-m-t', strtotime($date));
            if($day_now <= $day_start_billing){
                if ($date == $end_date)
                {
                    $init   = date('Y-m-t',strtotime("- 1 month"));	
                    $frist_date = date('Y-m-01', strtotime($init));
                    $last_date_nm = date('Y-m-t',strtotime($frist_date."+ 1 month")); 
                    // echo $init." hasta ".$last_date_nm;
                }else {
                    $init   = date('Y').'-'.date('m').'-'.$day_start_billing;
                    $init	= date('Y-m-d',strtotime($init."- 1 month"));
                    $last_date_nm = date('Y-m-d',strtotime($init."+ 1 month")); 
                    // echo $init." hasta ".$last_date_nm;
                }
            }else{
                if ($date == $end_date)
                {	
                    $init   = date('Y-m-t');	
                    $frist_date = date('Y-m-01', strtotime($init));
                    $last_date_nm = date('Y-m-t',strtotime($frist_date."+ 1 month")); 
                    // echo $init." hasta ".$last_date_nm;
                }else {
                    $init   = date('Y').'-'.date('m').'-'.$day_start_billing;
                    $last_date_nm = date('Y-m-d',strtotime($init."+ 1 month")); 
                    // echo $init." hasta ".$last_date_nm;
                }
            }

            $comprobantes = $this->db->prepare("SELECT COUNT(*) total_comprobantes FROM tm_venta WHERE id_tipo_doc != 3 AND (date(fecha_venta) BETWEEN ? AND ?);");
            $comprobantes->execute(array($init,$end)); 
              
            $c{'intervals'} =[
                $init,
                $last_date_nm,
            ];

            $c{'current'} = [
                'total_invoices'    => $comprobantes->fetch(PDO::FETCH_COLUMN),
                'total_users'       => $usuarios->fetch(PDO::FETCH_COLUMN),
            ];

            $c{'limits'} = [
                'total_invoices' => $plan->{'limit_documents'},
                'total_users' => $plan->{'limit_users'},
            ];

            $data = array("data" => $c);
            $json = json_encode($data);
            echo $json;
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }
    public function importarexcel()
    {   
        try {
            error_reporting(0);
            include "libs/class.upload.php";
            if(isset($_FILES["file"])){
                $up = new Upload($_FILES["file"]);
                if($up->uploaded){
                    $up->Process("libs/uploads/");
                    if($up->processed){
                        /// leer el archivo excel
                        // require_once "../libs/PHPExcel/Classes/PHPExcel.php";
                        require_once "libs/PHPExcel/Classes/PHPExcel.php";

                        $archivo = "libs/uploads/".$up->file_dst_name;
                        $inputFileType = PHPExcel_IOFactory::identify($archivo);
                        $objReader = PHPExcel_IOFactory::createReader($inputFileType);
                        $objPHPExcel = $objReader->load($archivo);
                        $sheet = $objPHPExcel->getSheet(0); 
                        $highestRow = $sheet->getHighestRow(); 
                        $highestColumn = $sheet->getHighestColumn();
                        $log_file = dirname(__DIR__) . DIRECTORY_SEPARATOR . 'log_import_productos.log';
                        $log = function($msg) use ($log_file) { @file_put_contents($log_file, date('Y-m-d H:i:s') . ' ' . $msg . "\n", FILE_APPEND); };
                        $log('=== INICIO IMPORT EXCEL PRODUCTOS ===');
                        for ($row = 2; $row <= $highestRow; $row++){ 
                            $categoria      = trim((string)$sheet->getCell("A".$row)->getValue());
                            $x_producto     = trim((string)$sheet->getCell("B".$row)->getValue());
                            $x_cod_pro      = trim((string)$sheet->getCell("C".$row)->getValue());
                            $x_area         = trim((string)$sheet->getCell("D".$row)->getValue());
                            $x_trasformado  = trim((string)$sheet->getCell("E".$row)->getValue());
                            $x_notas        = trim((string)$sheet->getCell("F".$row)->getValue());
                            $x_desc         = trim((string)$sheet->getCell("G".$row)->getValue());
                            $x_delivery     = trim((string)$sheet->getCell("H".$row)->getValue());
                            $cat_orden      = trim((string)$sheet->getCell("I".$row)->getValue());
            
                            if($categoria !== '' && $x_cod_pro !== ''){
                                $x_delivery    = (strtoupper($x_delivery) == 'SI') ? '1': '0';
                                // Reutilizar categoría si ya existe
                                $sql_categoria = $this->db->selectOne("SELECT * FROM tm_producto_catg WHERE descripcion = :descripcion", array('descripcion' => $categoria));
                                if ($sql_categoria) {
                                    $id_catg = $sql_categoria['id_catg'];
                                    $log("Fila $row: categoria '$categoria' EXISTE id_catg=$id_catg");
                                } else {
                                    $insert_categoria = "INSERT INTO tm_producto_catg SET descripcion = ?, delivery = ?, orden = ?";
                                    $this->db->prepare($insert_categoria)->execute(array($categoria, $x_delivery, $cat_orden ?: 0));
                                    $id_catg = $this->db->lastInsertId();
                                    $log("Fila $row: categoria '$categoria' INSERTADA id_catg=$id_catg");
                                }
                                // Reutilizar área si ya existe (no insertar nueva); si no existe usar 0 para evitar NULL en columna NOT NULL
                                $id_areap = 0;
                                if ($x_area !== '') {
                                    $sql_areapro = $this->db->selectOne("SELECT * FROM tm_area_prod WHERE nombre = :nombre", array('nombre' => $x_area));
                                    if ($sql_areapro) {
                                        $id_areap = $sql_areapro['id_areap'];
                                    }
                                }
                                $log("Fila $row: area='$x_area' id_areap=" . ($id_areap ?: '0'));
                                $x_trasformado = (strtoupper($x_trasformado) == 'SI') ? '1': '2';
                                // Solo insertar producto si no existe (por código)
                                $sql_producto1 = $this->db->selectOne("SELECT * FROM tm_producto WHERE cod_pro = :cod_pro", array('cod_pro' => $x_cod_pro));
                                $producto_ya_existe = !empty($sql_producto1);
                                $log("Fila $row: cod_pro='$x_cod_pro' producto_ya_existe=" . ($producto_ya_existe ? 'SI' : 'NO'));
                                if(!$sql_producto1){
                                    $insert_producto = "INSERT INTO tm_producto SET 
                                    id_tipo = ? ,
                                    id_catg = ?, 
                                    id_areap = ?, 
                                    nombre = ?, 
                                    notas = ?, 
                                    descripcion = ?, 
                                    delivery = ?, 
                                    cod_pro  = ?";
                                    try {
                                        $stmt = $this->db->prepare($insert_producto);
                                        $exec = $stmt->execute(array(
                                            $x_trasformado, 
                                            $id_catg, 
                                            $id_areap, 
                                            $x_producto, 
                                            $x_notas, 
                                            $x_desc, 
                                            $x_delivery, 
                                            $x_cod_pro
                                        ));
                                        $log("Fila $row: INSERT producto execute=" . ($exec ? 'OK' : 'FALLO') . " lastInsertId=" . $this->db->lastInsertId() . " | nombre='$x_producto' cod_pro='$x_cod_pro'");
                                        if (!$exec) {
                                            $log("Fila $row: PDO errorInfo=" . print_r($stmt->errorInfo(), true));
                                        }
                                    } catch (Exception $e) {
                                        $log("Fila $row: EXCEPCION al insertar producto: " . $e->getMessage());
                                    }
                                }
                            } else {
                                $log("Fila $row: IGNORADA (categoria o cod_pro vacio) cat='$categoria' cod='$x_cod_pro'");
                            }
                        }
                        $log('=== FIN HOJA PRODUCTOS ===');
                        // presentacion se activa     
                        $sheetpre = $objPHPExcel->getSheet(1); 
                        $highestRowp = $sheetpre->getHighestRow(); 
                        $highestColumn = $sheetpre->getHighestColumn();
                        
                        // Obtener el último id_es de tm_inventario_entsal
                        $stm = $this->db->prepare("SELECT MAX(id_es) AS max_id FROM tm_inventario_entsal");
                        $stm->execute();
                        $result = $stm->fetch(PDO::FETCH_OBJ);
                        $next_id_es = ($result && $result->max_id) ? $result->max_id + 1 : 1;    
                        
                        // Insertar en tm_inventario_entsal UNA SOLA VEZ por importación
                        $insert_tm_inventario_entsal = "INSERT INTO tm_inventario_entsal SET
                            id_es = ?, 
                            id_usu = ?, 
                            id_tipo = ?, 
                            id_responsable = ?, 
                            motivo = ?, 
                            fecha = ?, 
                            estado = ?";
                        $this->db->prepare($insert_tm_inventario_entsal)->execute(array(
                            $next_id_es, 
                            '1', 
                            '3', 
                            '1', 
                            'INVENTARIO INICIAL IMPORT EXCEL', 
                            date("Y-m-d H:i:s"), 
                            'a'
                        ));                        
                        
                        $algun_insert_ok = false;
                        for ($row = 2; $row <= $highestRowp; $row++){ 
                            $p_cod_producto         = trim((string)$sheetpre->getCell("A".$row)->getValue());
                            $p_presentacion         = trim((string)$sheetpre->getCell("B".$row)->getValue());
                            $p_cod_presentacion     = trim((string)$sheetpre->getCell("C".$row)->getValue());
                            $p_descripcion          = trim((string)$sheetpre->getCell("D".$row)->getValue());
                            $p_precio               = $sheetpre->getCell("E".$row)->getValue();
                            $p_precio_delivery      = $sheetpre->getCell("F".$row)->getValue();
                            $p_precio_llevar        = $sheetpre->getCell("G".$row)->getValue();
                            $p_stock_min            = $sheetpre->getCell("H".$row)->getValue();
                            $p_control_stock        = trim((string)$sheetpre->getCell("I".$row)->getValue());
                            $p_igv                  = trim((string)$sheetpre->getCell("J".$row)->getValue());
                            $p_delivery             = trim((string)$sheetpre->getCell("K".$row)->getValue());
                            $p_llevar               = trim((string)$sheetpre->getCell("L".$row)->getValue());
                            $p_costo                = $sheetpre->getCell("M".$row)->getValue();
                            $p_precio_delivery_app  = $sheetpre->getCell("N".$row)->getValue();
                            $p_ordenins             = $sheetpre->getCell("O".$row)->getValue();
                            $inv_inicial            = $sheetpre->getCell("P".$row)->getValue();
                            $p_control_stock    = (strtoupper($p_control_stock) == 'SI') ? '1': '0';
                            $p_igv              = (strtoupper($p_igv) == 'SI') ? '1': '0';
                            $p_delivery         = (strtoupper($p_delivery) == 'SI') ? '1': '0';
                            $p_llevar           = (strtoupper($p_llevar) == 'SI') ? '1': '0';
                            $p_igv_monto        = Session::get('igv');
                            if ($p_cod_producto === '' || $p_cod_presentacion === '') { continue; }
                            // Reutilizar producto existente por código
                            $sql_producto = $this->db->selectOne("SELECT * FROM tm_producto WHERE cod_pro = :cod_pro", array('cod_pro' => $p_cod_producto));
                            if (!$sql_producto) { continue; }
                            $id_p_producto = $sql_producto['id_prod'];
                            $p_descripcion = $p_descripcion !== '' ? $p_descripcion : '';
                            // Reutilizar presentación si ya existe; solo insertar si no existe
                            $sql_presentacion = $this->db->selectOne("SELECT * FROM tm_producto_pres WHERE cod_prod = :cod_prod", array('cod_prod' => $p_cod_presentacion));
                            $presentacion_nueva = false;
                            if(!$sql_presentacion){
                                $insert_presentacion = "INSERT INTO tm_producto_pres SET 
                                    id_prod = ?,
                                    cod_prod = ?,
                                    presentacion = ?,
                                    descripcion = ?,
                                    precio = ?,
                                    precio_delivery = ?,
                                    precio_delivery_app = ?,
                                    precio_llevar = ?,
                                    costo_unitario = ?,
                                    receta = ?,
                                    stock_min = ?,
                                    crt_stock = ?,
                                    impuesto = ?,
                                    delivery = ?,
                                    llevar = ?,
                                    margen = ?,
                                    igv = ?,
                                    ordenins = ?";
                                $this->db->prepare($insert_presentacion)->execute(array(
                                    $id_p_producto, 
                                    $p_cod_presentacion, 
                                    $p_presentacion, 
                                    $p_descripcion, 
                                    $p_precio, 
                                    $p_precio_delivery, 
                                    $p_precio_delivery_app,
                                    $p_precio_llevar, 
                                    $p_costo,
                                    '0',
                                    $p_stock_min,
                                    $p_control_stock,
                                    $p_igv, 
                                    $p_delivery,
                                    $p_llevar,
                                    '0', 
                                    $p_igv_monto,
                                    $p_ordenins ?: 0
                                )); 
                                $presentacion_nueva = true;
                                $algun_insert_ok = true;
                            }
                            // Solo registrar inventario inicial cuando la presentación es nueva y controla stock
                            if ($presentacion_nueva && $p_control_stock === '1') {
                                $stm = $this->db->prepare("SELECT id_pres FROM tm_producto_pres WHERE cod_prod = ? AND crt_stock = '1' LIMIT 1");
                                $stm->execute([$p_cod_presentacion]);
                                $result = $stm->fetch(PDO::FETCH_OBJ);
                                if($result){
                                    $id_pres = $result->id_pres;
                                    $inv_inicial = is_numeric($inv_inicial) ? $inv_inicial : 0;
                                    $this->db->prepare("INSERT INTO tm_inventario SET id_tipo_ope=?, id_ope=?, id_tipo_ins=?, id_ins=?, cos_uni=?, cant=?, fecha_r=?, estado=?")->execute(array(
                                        '3', $next_id_es, '2', $id_pres, $p_costo, $inv_inicial, date("Y-m-d H:i:s"), 'a'
                                    ));
                                }
                            }
                        }
                        unlink($archivo);
                        return '1';
                    }	
                }
            }
            
        } 
        catch (Exception $e) 
        {
            die($e->getMessage());
        }
    }

    public function importarexcelinsumos()
    {   
        try {
            error_reporting(0);
            include "libs/class.upload.php";
            if(isset($_FILES["file"])){
                $up = new Upload($_FILES["file"]);
                if($up->uploaded){
                    $up->Process("libs/uploads/");
                    if($up->processed){
                        /// leer el archivo excel
                        // require_once "../libs/PHPExcel/Classes/PHPExcel.php";
                        require_once "libs/PHPExcel/Classes/PHPExcel.php";

                        $archivo = "libs/uploads/".$up->file_dst_name;
                        $inputFileType = PHPExcel_IOFactory::identify($archivo);
                        $objReader = PHPExcel_IOFactory::createReader($inputFileType);
                        $objPHPExcel = $objReader->load($archivo);
                        $sheet = $objPHPExcel->getSheet(0); 
                        $highestRow = $sheet->getHighestRow(); 
                        $highestColumn = $sheet->getHighestColumn();
                        
                        // Obtener el último id_es de tm_inventario_entsal
                        $stm = $this->db->prepare("SELECT MAX(id_es) AS max_id FROM tm_inventario_entsal");
                        $stm->execute();
                        $result = $stm->fetch(PDO::FETCH_OBJ);
                        $next_id_es = ($result && $result->max_id) ? $result->max_id + 1 : 1;    
                        
                        // Insertar en tm_inventario_entsal UNA SOLA VEZ por importación
                        $insert_tm_inventario_entsal = "INSERT INTO tm_inventario_entsal SET
                            id_es = ?, 
                            id_usu = ?, 
                            id_tipo = ?, 
                            id_responsable = ?, 
                            motivo = ?, 
                            fecha = ?, 
                            estado = ?";
                        $this->db->prepare($insert_tm_inventario_entsal)->execute(array(
                            $next_id_es, 
                            '1', 
                            '3', 
                            '1', 
                            'INVENTARIO INICIAL IMPORT EXCEL', 
                            date("Y-m-d H:i:s"), 
                            'a'
                        ));
                        
                        for ($row = 2; $row <= $highestRow; $row++){ 
                            $categoria   = trim((string)$sheet->getCell("A".$row)->getValue());
                            $x_nombre    = trim((string)$sheet->getCell("B".$row)->getValue());
                            $x_cod       = trim((string)$sheet->getCell("C".$row)->getValue());
                            $x_medida    = trim((string)$sheet->getCell("D".$row)->getValue());
                            $x_stock_min = $sheet->getCell("E".$row)->getValue();
                            $x_costo_und = $sheet->getCell("F".$row)->getValue();
                            $x_stock_ini = $sheet->getCell("G".$row)->getValue();

                            if($categoria === '' || $x_cod === ''){ continue; }

                            // Reutilizar categoría si ya existe
                            $sql_categoria = $this->db->selectOne("SELECT * FROM tm_insumo_catg WHERE descripcion = :descripcion", array('descripcion' => $categoria));
                            if ($sql_categoria) {
                                $id_catg = $sql_categoria['id_catg'];
                            } else {
                                $this->db->prepare("INSERT INTO tm_insumo_catg SET descripcion = ?")->execute(array($categoria));
                                $id_catg = $this->db->lastInsertId();
                            }
                            // Reutilizar medida si ya existe (no insertar nueva)
                            $id_medida = null;
                            if ($x_medida !== '') {
                                $sql_medida = $this->db->selectOne("SELECT * FROM tm_tipo_medida WHERE descripcion = :descripcion", array('descripcion' => $x_medida));
                                if ($sql_medida) {
                                    $id_medida = $sql_medida['id_med'];
                                }
                            }
                            // Solo insertar insumo si no existe (por código)
                            $sql_insumo = $this->db->selectOne("SELECT * FROM tm_insumo WHERE cod_ins = :cod_ins", array('cod_ins' => $x_cod));
                            $insumo_nuevo = false;
                            if(!$sql_insumo){
                                $this->db->prepare("INSERT INTO tm_insumo SET id_catg = ?, id_med = ?, cod_ins = ?, nomb_ins = ?, stock_min = ?, cos_uni = ?")->execute(array(
                                    $id_catg, $id_medida, $x_cod, $x_nombre, $x_stock_min ?: 0, $x_costo_und ?: 0
                                )); 
                                $insumo_nuevo = true;
                            }
                            // Solo registrar inventario inicial cuando el insumo es nuevo
                            if ($insumo_nuevo) {
                                $stm = $this->db->prepare("SELECT id_ins FROM tm_insumo WHERE cod_ins = ? LIMIT 1");
                                $stm->execute([$x_cod]);
                                $row_ins = $stm->fetch(PDO::FETCH_OBJ);
                                if($row_ins){
                                    $x_stock_ini = is_numeric($x_stock_ini) ? $x_stock_ini : 0;
                                    $this->db->prepare("INSERT INTO tm_inventario SET id_tipo_ope=?, id_ope=?, id_tipo_ins=?, id_ins=?, cos_uni=?, cant=?, fecha_r=?, estado=?")->execute(array(
                                        '3', $next_id_es, '1', $row_ins->id_ins, $x_costo_und ?: 0, $x_stock_ini, date("Y-m-d H:i:s"), 'a'
                                    ));
                                }
                            }
                        }
                        if (file_exists($archivo)) { unlink($archivo); }
                        return '1';
                    }	
                }
            }
        } 
        catch (Exception $e) 
        {
            die($e->getMessage());
        }

    }

    /**
     * Genera y envía al navegador la plantilla Excel para importar productos y presentaciones.
     * Hoja 1: Productos (categoría, nombre, código, área, transformado, notas, descripción, delivery, orden).
     * Hoja 2: Presentaciones (código producto, presentación, código presentación, descripción, precios, stock, etc.).
     */
    public function generarPlantillaImportProductos()
    {
        require_once "libs/PHPExcel/Classes/PHPExcel.php";
        $objPHPExcel = new PHPExcel();
        $objPHPExcel->getProperties()->setTitle("Plantilla importación productos");

        // Hoja 1: Productos
        $sheet = $objPHPExcel->getActiveSheet();
        $sheet->setTitle('Productos');
        $sheet->setCellValue('A1', 'Categoría');
        $sheet->setCellValue('B1', 'Producto');
        $sheet->setCellValue('C1', 'Código');
        $sheet->setCellValue('D1', 'Área');
        $sheet->setCellValue('E1', 'Transformado (SI/NO)');
        $sheet->setCellValue('F1', 'Notas');
        $sheet->setCellValue('G1', 'Descripción');
        $sheet->setCellValue('H1', 'Delivery (SI/NO)');
        $sheet->setCellValue('I1', 'Orden');
        $sheet->setCellValue('A2', 'Bebidas');
        $sheet->setCellValue('B2', 'Gaseosa 500ml');
        $sheet->setCellValue('C2', 'GAS500');
        $sheet->setCellValue('D2', 'Barra');
        $sheet->setCellValue('E2', 'NO');
        $sheet->setCellValue('F2', '');
        $sheet->setCellValue('G2', 'Gaseosa 500 ml');
        $sheet->setCellValue('H2', 'SI');
        $sheet->setCellValue('I2', '1');

        // Hoja 2: Presentaciones
        $sheet2 = $objPHPExcel->createSheet();
        $sheet2->setTitle('Presentaciones');
        $sheet2->setCellValue('A1', 'Código producto');
        $sheet2->setCellValue('B1', 'Presentación');
        $sheet2->setCellValue('C1', 'Código presentación');
        $sheet2->setCellValue('D1', 'Descripción');
        $sheet2->setCellValue('E1', 'Precio');
        $sheet2->setCellValue('F1', 'Precio delivery');
        $sheet2->setCellValue('G1', 'Precio llevar');
        $sheet2->setCellValue('H1', 'Stock mín');
        $sheet2->setCellValue('I1', 'Control stock (SI/NO)');
        $sheet2->setCellValue('J1', 'IGV (SI/NO)');
        $sheet2->setCellValue('K1', 'Delivery (SI/NO)');
        $sheet2->setCellValue('L1', 'Llevar (SI/NO)');
        $sheet2->setCellValue('M1', 'Costo');
        $sheet2->setCellValue('N1', 'Precio delivery app');
        $sheet2->setCellValue('O1', 'Orden');
        $sheet2->setCellValue('P1', 'Inv. inicial');
        $sheet2->setCellValue('A2', 'GAS500');
        $sheet2->setCellValue('B2', 'Unidad');
        $sheet2->setCellValue('C2', 'GAS500-UN');
        $sheet2->setCellValue('D2', '');
        $sheet2->setCellValue('E2', '3.50');
        $sheet2->setCellValue('F2', '4.00');
        $sheet2->setCellValue('G2', '3.50');
        $sheet2->setCellValue('H2', '5');
        $sheet2->setCellValue('I2', 'SI');
        $sheet2->setCellValue('J2', 'SI');
        $sheet2->setCellValue('K2', 'SI');
        $sheet2->setCellValue('L2', 'SI');
        $sheet2->setCellValue('M2', '1.50');
        $sheet2->setCellValue('N2', '4.00');
        $sheet2->setCellValue('O2', '1');
        $sheet2->setCellValue('P2', '20');

        $filename = 'plantilla_import_productos.xlsx';
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="' . $filename . '"');
        header('Cache-Control: max-age=0');
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
        $objWriter->save('php://output');
        exit;
    }

    /**
     * Genera y envía al navegador la plantilla Excel para importar insumos.
     * Columnas: Categoría, Nombre, Código, Medida, Stock mín, Costo unit., Stock inicial.
     */
    public function generarPlantillaImportInsumos()
    {
        require_once "libs/PHPExcel/Classes/PHPExcel.php";
        $objPHPExcel = new PHPExcel();
        $objPHPExcel->getProperties()->setTitle("Plantilla importación insumos");

        $sheet = $objPHPExcel->getActiveSheet();
        $sheet->setTitle('Insumos');
        $sheet->setCellValue('A1', 'Categoría');
        $sheet->setCellValue('B1', 'Nombre');
        $sheet->setCellValue('C1', 'Código');
        $sheet->setCellValue('D1', 'Medida');
        $sheet->setCellValue('E1', 'Stock mín');
        $sheet->setCellValue('F1', 'Costo unit.');
        $sheet->setCellValue('G1', 'Stock inicial');
        $sheet->setCellValue('A2', 'Lácteos');
        $sheet->setCellValue('B2', 'Leche evaporada');
        $sheet->setCellValue('C2', 'INS-LE-001');
        $sheet->setCellValue('D2', 'Unidad');
        $sheet->setCellValue('E2', '10');
        $sheet->setCellValue('F2', '2.50');
        $sheet->setCellValue('G2', '50');

        $filename = 'plantilla_import_insumos.xlsx';
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="' . $filename . '"');
        header('Cache-Control: max-age=0');
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
        $objWriter->save('php://output');
        exit;
    }
    
    public function datoplataforma_data()
    {
        try
        {
            $sql = 'SELECT 
                        plan, 
                        activated_mesa, 
                        activated_llevar, 
                        activated_delivery, 
                        activated_pdv_pos, 
                        activated_mod_compras, 
                        activated_mod_inv, 
                        activated_mod_ins_recet_topp 
                    FROM tm_configuracion';
    
            $stmt = $this->db->prepare($sql);
            $stmt->execute();
    
            $row = $stmt->fetch(PDO::FETCH_ASSOC);
    
            // Decodificar el JSON de la columna 'plan' (evitar null si no existe o está vacío)
            $plan = isset($row['plan']) ? json_decode($row['plan'], true) : null;
            if (!is_array($plan)) {
                $plan = [];
            }
    
            // Asegurar que mostrar_opcion_impresion y no_imprimir_ni_mostrar_opcion existan siempre en el plan
            if (!isset($plan['mostrar_opcion_impresion'])) {
                $plan['mostrar_opcion_impresion'] = '0';
            }
            if (!isset($plan['no_imprimir_ni_mostrar_opcion'])) {
                $plan['no_imprimir_ni_mostrar_opcion'] = '0';
            }
            if (!isset($plan['modulo_estadisticas'])) {
                $plan['modulo_estadisticas'] = '0';
            }
    
            // Combinar el array del plan con las otras columnas
            $config = array_merge($plan, [
                'activated_mesa' => (int)$row['activated_mesa'],
                'activated_llevar' => (int)$row['activated_llevar'],
                'activated_delivery' => (int)$row['activated_delivery'],
                'activated_pdv_pos' => (int)$row['activated_pdv_pos'],
                'activated_mod_compras' => (int)$row['activated_mod_compras'],
                'activated_mod_inv' => (int)$row['activated_mod_inv'],
                'activated_mod_ins_recet_topp' => (int)$row['activated_mod_ins_recet_topp'],
            ]);
    
            return $config;
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    
    public function datoplataforma_crud($data)
    {
        try
        {
            $sql = "UPDATE tm_configuracion SET 
                plan = ?, 
                activated_mesa = ?, 
                activated_llevar = ?, 
                activated_delivery = ?, 
                activated_pdv_pos = ?, 
                activated_mod_compras = ?, 
                activated_mod_inv = ?, 
                activated_mod_ins_recet_topp = ?
            WHERE id_cfg = 1";
    
            $df = array(
                json_encode([
                    'created_at' => $data["created_at"],
                    'limit_users'=> $data["limit_users"],
                    'locked_users' => $data["locked_users"],
                    'limit_documents' =>  $data["limit_documents"],
                    'locked_documents' => $data["locked_documents"],
                    'wsp_token' => $data["wsp_token"],
                    'wsp_number' => $data["wsp_number"],
                    'api_wsp' => $data['api_wsp'],
                    'mostrar_opcion_impresion' => isset($data['mostrar_opcion_impresion']) ? $data['mostrar_opcion_impresion'] : '0',
                    'no_imprimir_ni_mostrar_opcion' => isset($data['no_imprimir_ni_mostrar_opcion']) ? $data['no_imprimir_ni_mostrar_opcion'] : '0',
                    'modulo_estadisticas' => isset($data['modulo_estadisticas']) ? $data['modulo_estadisticas'] : '0'
                ]),
                //desde aqui son los modulos para activar
                $data['activated_mesa'],
                $data['activated_llevar'],
                $data['activated_delivery'],
                $data['activated_pdv_pos'],
                $data['activated_mod_compras'],
                $data['activated_mod_inv'],
                $data['activated_mod_ins_recet_topp']
            );
    
            $st = $this->db->prepare($sql);
            $st->execute($df);
    
            // Si la actualizaci��n tuvo ��xito, actualizar la sesi��n
            if ($st->rowCount()) {
                $ds = $this->db->prepare("SELECT * FROM tm_configuracion WHERE id_cfg = 1");
                $ds->execute();
                $data_s = $ds->fetch(PDO::FETCH_ASSOC);
    
                Session::set('activated_mesa', $data_s['activated_mesa']);
                Session::set('activated_llevar', $data_s['activated_llevar']);
                Session::set('activated_delivery', $data_s['activated_delivery']);
                Session::set('activated_pdv_pos', $data_s['activated_pdv_pos']);
                Session::set('activated_mod_compras', $data_s['activated_mod_compras']);
                Session::set('activated_mod_inv', $data_s['activated_mod_inv']);
                Session::set('activated_mod_ins_recet_topp', $data_s['activated_mod_ins_recet_topp']);
                $plan = json_decode($data_s['plan'], true);
                if ($plan) {
                    if (isset($plan['mostrar_opcion_impresion'])) Session::set('mostrar_opcion_impresion', $plan['mostrar_opcion_impresion']);
                    if (isset($plan['no_imprimir_ni_mostrar_opcion'])) Session::set('no_imprimir_ni_mostrar_opcion', $plan['no_imprimir_ni_mostrar_opcion']);
                    if (isset($plan['modulo_estadisticas'])) Session::set('modulo_estadisticas', $plan['modulo_estadisticas']);
                }
                return '1';
            }
    
            return '0';
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }


    // app delivery
    public function appdelivery_list($data)
    {
        try
        {
           
            $stm = $this->db->prepare("SELECT * FROM tm_repartidor WHERE id_repartidor <> 1 AND id_repartidor <> 9999 AND id_repartidor LIKE ?");
            $stm->execute(array($data['id_repartidor']));
            $c = $stm->fetchAll(PDO::FETCH_OBJ);
            $data = array("data" => $c);
            $json = json_encode($data);
            echo $json; 
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function appdelivery_crud_update($data)
    {
        try 
        {
            $consulta = "UPDATE tm_repartidor SET descripcion = ?, estado = ?, comision = ? WHERE id_repartidor = ?";
            $arrayParam =  array(
                $data['nombre'],
                $data['estado'],
                $data['comision'],
                $data['id_repartidor']
            );
            $st = $this->db->prepare($consulta);
            $st->execute($arrayParam);

            $row = $st->fetch(PDO::FETCH_ASSOC);

            // return '';

            if ( $row == true) {
                return '0';
            }else{
                return '2';
            }

        } catch (Exception $e) 
        {
            die($e->getMessage());
        }
    }

    /**
     * Exportar productos/servicios, combos e insumos a Excel según tipos seleccionados.
     * Formato profesional: cabeceras con color, bordes, formato numérico/fecha, título con fecha.
     * @param array $tipos Ej: ['productos_servicios','combos','insumos']
     */
    public function exportarProductosExcel($tipos)
    {
        if (empty($tipos) || !is_array($tipos)) {
            return;
        }
        require_once "libs/PHPExcel/Classes/PHPExcel.php";
        $objPHPExcel = new PHPExcel();
        $objPHPExcel->getProperties()->setTitle("Reporte de productos")->setSubject("Exportación productos");
        $sheetIndex = 0;

        if (in_array('productos_servicios', $tipos)) {
            $data = $this->getDataProductosServiciosExport();
            $sheet = $sheetIndex === 0 ? $objPHPExcel->getActiveSheet() : $objPHPExcel->createSheet();
            $sheet->setTitle('Productos y Servicios');
            $this->llenarHojaProductos($sheet, $data);
            $sheetIndex++;
        }
        if (in_array('combos', $tipos)) {
            $data = $this->getDataCombosExport();
            $sheet = $sheetIndex === 0 ? $objPHPExcel->getActiveSheet() : $objPHPExcel->createSheet();
            $sheet->setTitle('Combos');
            $this->llenarHojaCombos($sheet, $data);
            $sheetIndex++;
        }
        if (in_array('insumos', $tipos)) {
            $data = $this->getDataInsumosExport();
            $sheet = $sheetIndex === 0 ? $objPHPExcel->getActiveSheet() : $objPHPExcel->createSheet();
            $sheet->setTitle('Insumos');
            $this->llenarHojaInsumos($sheet, $data);
            $sheetIndex++;
        }

        if ($sheetIndex === 0) {
            return;
        }

        $filename = 'reporte_productos_' . date('Y-m-d_His') . '.xlsx';
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="' . $filename . '"');
        header('Cache-Control: max-age=0');
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
        $objWriter->save('php://output');
        exit;
    }

    /**
     * Estilo cabecera profesional: fondo azul oscuro, texto blanco negrita, bordes, centrado.
     */
    private function aplicarEstiloCabecera($sheet, $range)
    {
        $sheet->getStyle($range)->applyFromArray(array(
            'font' => array(
                'bold' => true,
                'color' => array('rgb' => 'FFFFFF'),
                'size' => 11,
                'name' => 'Calibri'
            ),
            'fill' => array(
                'type' => PHPExcel_Style_Fill::FILL_SOLID,
                'startcolor' => array('rgb' => '2E75B6')
            ),
            'alignment' => array(
                'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
                'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER,
                'wrap' => true
            ),
            'borders' => array(
                'allborders' => array(
                    'style' => PHPExcel_Style_Border::BORDER_THIN,
                    'color' => array('rgb' => '1F4E79')
                )
            )
        ));
    }

    /**
     * Estilo fila de título (fecha de reporte).
     */
    private function aplicarEstiloTitulo($sheet, $range)
    {
        $sheet->getStyle($range)->applyFromArray(array(
            'font' => array(
                'bold' => true,
                'size' => 12,
                'name' => 'Calibri',
                'color' => array('rgb' => '2E75B6')
            ),
            'alignment' => array(
                'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_LEFT,
                'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER
            )
        ));
    }

    /**
     * Bordes y alineación para zona de datos. Opcional: formato #,##0.00 en columnas (ej. array('E','F')).
     */
    private function aplicarEstiloDatos($sheet, $range, $columnasNumericas = array())
    {
        $sheet->getStyle($range)->applyFromArray(array(
            'alignment' => array(
                'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER,
                'wrap' => true
            ),
            'borders' => array(
                'allborders' => array(
                    'style' => PHPExcel_Style_Border::BORDER_THIN,
                    'color' => array('rgb' => 'D9E2F3')
                )
            )
        ));
        if (!empty($columnasNumericas) && preg_match('/[A-Z]+\d+:.*?(\d+)$/', $range, $m)) {
            $lastRow = (int)$m[1];
            foreach ($columnasNumericas as $col) {
                $sheet->getStyle($col . '3:' . $col . $lastRow)->getNumberFormat()->setFormatCode('#,##0.00');
            }
        }
    }

    /** Convierte estado a/ i a texto legible */
    private function estadoTexto($estado)
    {
        if ($estado === null || $estado === '') return '';
        return strtolower($estado) === 'a' ? 'Activo' : 'Inactivo';
    }

    /** id_tipo 1 = Transformable, 2 = No transformable */
    private function transformableTexto($id_tipo)
    {
        if ($id_tipo === null || $id_tipo === '') return '';
        return (int)$id_tipo === 1 ? 'Sí' : 'No';
    }

    /** delivery 1 = Sí, 0 = No */
    private function deliveryTexto($delivery)
    {
        if ($delivery === null || $delivery === '') return '';
        return (int)$delivery === 1 ? 'Sí' : 'No';
    }

    private function getDataProductosServiciosExport()
    {
        $stm = $this->db->prepare("SELECT p.id_prod, p.nombre, p.cod_pro, p.descripcion, p.notas, p.id_tipo, p.delivery, p.estado,
            c.descripcion AS categoria, c.orden AS orden_categoria,
            a.nombre AS area_produccion
            FROM tm_producto p
            INNER JOIN tm_producto_catg c ON p.id_catg = c.id_catg
            LEFT JOIN tm_area_prod a ON p.id_areap = a.id_areap
            WHERE c.combos <> 1
            ORDER BY c.orden, p.nombre");
        $stm->execute();
        return $stm->fetchAll(PDO::FETCH_ASSOC);
    }

    private function getDataCombosExport()
    {
        $stm = $this->db->prepare("SELECT p.id_prod, p.nombre, p.cod_pro, p.descripcion, p.notas, p.id_tipo, p.delivery, p.estado,
            c.descripcion AS categoria, c.orden AS orden_categoria
            FROM tm_producto p
            INNER JOIN tm_producto_catg c ON p.id_catg = c.id_catg
            WHERE c.combos = 1
            ORDER BY c.orden, p.nombre");
        $stm->execute();
        return $stm->fetchAll(PDO::FETCH_ASSOC);
    }

    private function getDataInsumosExport()
    {
        $stm = $this->db->prepare("SELECT i.id_ins, i.cod_ins, i.nomb_ins AS nombre, i.stock_min, i.cos_uni, i.estado,
            c.descripcion AS categoria,
            m.descripcion AS unidad_medida
            FROM tm_insumo i
            LEFT JOIN tm_insumo_catg c ON i.id_catg = c.id_catg
            LEFT JOIN tm_tipo_medida m ON i.id_med = m.id_med
            ORDER BY c.descripcion, i.nomb_ins");
        $stm->execute();
        return $stm->fetchAll(PDO::FETCH_ASSOC);
    }

    private function llenarHojaProductos($sheet, $data)
    {
        $titulo = 'Reporte Productos y Servicios - Generado: ' . date('d/m/Y H:i');
        $sheet->setCellValue('A1', $titulo);
        $sheet->mergeCells('A1:K1');
        $this->aplicarEstiloTitulo($sheet, 'A1');
        $sheet->getRowDimension(1)->setRowHeight(22);

        $headers = array('ID', 'Nombre', 'Código', 'Descripción', 'Notas', 'Categoría', 'Orden cat.', 'Área producción', 'Transformable', 'Delivery', 'Estado');
        $col = 'A';
        foreach ($headers as $h) {
            $sheet->setCellValue($col . '2', $h);
            $col++;
        }
        $this->aplicarEstiloCabecera($sheet, 'A2:K2');
        $sheet->getRowDimension(2)->setRowHeight(20);

        $row = 3;
        foreach ($data as $r) {
            $sheet->setCellValue('A' . $row, $r['id_prod']);
            $sheet->setCellValue('B' . $row, $r['nombre']);
            $sheet->setCellValue('C' . $row, $r['cod_pro']);
            $sheet->setCellValue('D' . $row, $r['descripcion']);
            $sheet->setCellValue('E' . $row, $r['notas']);
            $sheet->setCellValue('F' . $row, $r['categoria']);
            $sheet->setCellValue('G' . $row, isset($r['orden_categoria']) ? $r['orden_categoria'] : '');
            $sheet->setCellValue('H' . $row, $r['area_produccion']);
            $sheet->setCellValue('I' . $row, $this->transformableTexto($r['id_tipo']));
            $sheet->setCellValue('J' . $row, $this->deliveryTexto($r['delivery']));
            $sheet->setCellValue('K' . $row, $this->estadoTexto($r['estado']));
            $row++;
        }
        $lastRow = $row - 1;
        if ($lastRow >= 3) {
            $this->aplicarEstiloDatos($sheet, 'A3:K' . $lastRow, array());
        }
        $sheet->freezePane('A3');
        foreach (range('A', 'K') as $c) {
            $sheet->getColumnDimension($c)->setAutoSize(true);
        }
    }

    private function llenarHojaCombos($sheet, $data)
    {
        $titulo = 'Reporte Combos - Generado: ' . date('d/m/Y H:i');
        $sheet->setCellValue('A1', $titulo);
        $sheet->mergeCells('A1:J1');
        $this->aplicarEstiloTitulo($sheet, 'A1');
        $sheet->getRowDimension(1)->setRowHeight(22);

        $headers = array('ID', 'Nombre', 'Código', 'Descripción', 'Notas', 'Categoría', 'Orden cat.', 'Transformable', 'Delivery', 'Estado');
        $col = 'A';
        foreach ($headers as $h) {
            $sheet->setCellValue($col . '2', $h);
            $col++;
        }
        $this->aplicarEstiloCabecera($sheet, 'A2:J2');
        $sheet->getRowDimension(2)->setRowHeight(20);

        $row = 3;
        foreach ($data as $r) {
            $sheet->setCellValue('A' . $row, $r['id_prod']);
            $sheet->setCellValue('B' . $row, $r['nombre']);
            $sheet->setCellValue('C' . $row, $r['cod_pro']);
            $sheet->setCellValue('D' . $row, $r['descripcion']);
            $sheet->setCellValue('E' . $row, $r['notas']);
            $sheet->setCellValue('F' . $row, $r['categoria']);
            $sheet->setCellValue('G' . $row, isset($r['orden_categoria']) ? $r['orden_categoria'] : '');
            $sheet->setCellValue('H' . $row, $this->transformableTexto($r['id_tipo']));
            $sheet->setCellValue('I' . $row, $this->deliveryTexto($r['delivery']));
            $sheet->setCellValue('J' . $row, $this->estadoTexto($r['estado']));
            $row++;
        }
        $lastRow = $row - 1;
        if ($lastRow >= 3) {
            $this->aplicarEstiloDatos($sheet, 'A3:J' . $lastRow, array());
        }
        $sheet->freezePane('A3');
        foreach (range('A', 'J') as $c) {
            $sheet->getColumnDimension($c)->setAutoSize(true);
        }
    }

    private function llenarHojaInsumos($sheet, $data)
    {
        $titulo = 'Reporte Insumos - Generado: ' . date('d/m/Y H:i');
        $sheet->setCellValue('A1', $titulo);
        $sheet->mergeCells('A1:H1');
        $this->aplicarEstiloTitulo($sheet, 'A1');
        $sheet->getRowDimension(1)->setRowHeight(22);

        $headers = array('ID', 'Código', 'Nombre', 'Categoría', 'Unidad medida', 'Stock mín.', 'Costo unit.', 'Estado');
        $col = 'A';
        foreach ($headers as $h) {
            $sheet->setCellValue($col . '2', $h);
            $col++;
        }
        $this->aplicarEstiloCabecera($sheet, 'A2:H2');
        $sheet->getRowDimension(2)->setRowHeight(20);

        $row = 3;
        foreach ($data as $r) {
            $sheet->setCellValue('A' . $row, $r['id_ins']);
            $sheet->setCellValue('B' . $row, $r['cod_ins']);
            $sheet->setCellValue('C' . $row, $r['nombre']);
            $sheet->setCellValue('D' . $row, $r['categoria']);
            $sheet->setCellValue('E' . $row, isset($r['unidad_medida']) ? $r['unidad_medida'] : '');
            $sheet->setCellValue('F' . $row, $r['stock_min'] !== null ? $r['stock_min'] : '');
            $sheet->setCellValue('G' . $row, $r['cos_uni'] !== null ? $r['cos_uni'] : '');
            $sheet->setCellValue('H' . $row, $this->estadoTexto(isset($r['estado']) ? $r['estado'] : null));
            $row++;
        }
        $lastRow = $row - 1;
        if ($lastRow >= 3) {
            $this->aplicarEstiloDatos($sheet, 'A3:H' . $lastRow, array('F', 'G'));
        }
        $sheet->freezePane('A3');
        foreach (range('A', 'H') as $c) {
            $sheet->getColumnDimension($c)->setAutoSize(true);
        }
    }

}