# Script para detener procesos MySQL que bloquean el puerto 3306
# Ejecutar como Administrador

Write-Host "Buscando procesos en el puerto 3306..." -ForegroundColor Yellow

# Buscar procesos usando el puerto 3306
$processes = Get-NetTCPConnection -LocalPort 3306 -ErrorAction SilentlyContinue | Select-Object -ExpandProperty OwningProcess -Unique

if ($processes) {
    foreach ($pid in $processes) {
        $process = Get-Process -Id $pid -ErrorAction SilentlyContinue
        if ($process) {
            Write-Host "Proceso encontrado: $($process.Name) (PID: $pid)" -ForegroundColor Cyan
            try {
                Stop-Process -Id $pid -Force
                Write-Host "Proceso $pid terminado exitosamente" -ForegroundColor Green
            } catch {
                Write-Host "Error al terminar proceso $pid : $_" -ForegroundColor Red
            }
        }
    }
} else {
    Write-Host "No se encontraron procesos en el puerto 3306" -ForegroundColor Green
}

# Intentar detener el servicio MySQL95 si existe
Write-Host "`nIntentando detener el servicio MySQL95..." -ForegroundColor Yellow
try {
    Stop-Service -Name "MySQL95" -Force -ErrorAction SilentlyContinue
    Write-Host "Servicio MySQL95 detenido" -ForegroundColor Green
} catch {
    Write-Host "No se pudo detener el servicio MySQL95 (puede que no exista o ya esté detenido)" -ForegroundColor Yellow
}

Write-Host "`nVerificando puerto 3306..." -ForegroundColor Yellow
Start-Sleep -Seconds 2
$remaining = Get-NetTCPConnection -LocalPort 3306 -ErrorAction SilentlyContinue
if ($remaining) {
    Write-Host "ADVERTENCIA: Aún hay procesos usando el puerto 3306" -ForegroundColor Red
    Get-NetTCPConnection -LocalPort 3306 | Format-Table
} else {
    Write-Host "Puerto 3306 liberado exitosamente" -ForegroundColor Green
}

