<?php
/**
 * Diagnóstico: contador de comensales (tm_contador_comensales).
 * Verifica por qué el total puede quedar desincronizado (ej. muestra 4 con solo 2 mesas).
 * Ejecutar: php diagnostico_comensales.php  o  abrir en navegador.
 */
error_reporting(E_ALL);
ini_set('display_errors', 1);

$cli = (php_sapi_name() === 'cli');

if (!$cli) {
    header('Content-Type: text/html; charset=utf-8');
    echo '<pre>';
}

function out($msg) {
    global $cli;
    echo $msg . ($cli ? "\n" : "\n");
}

require_once __DIR__ . '/config.php';
require_once __DIR__ . '/libs/Database.php';

try {
    $db = new Database(DB_TYPE, DB_HOST, DB_NAME, DB_USER, DB_PASS, DB_CHARSET);
} catch (Exception $e) {
    out('Error conexión BD: ' . $e->getMessage());
    exit(1);
}

out('=== DIAGNÓSTICO CONTADOR COMENSALES ===');
out('Base de datos: ' . DB_NAME);
out('');

// 1) Estructura de la tabla (por si acaso)
out('--- 1) Filas en tm_contador_comensales (todas) ---');
$stm = $db->query("SELECT * FROM tm_contador_comensales ORDER BY fecha_inicio DESC");
$rows = $stm->fetchAll(PDO::FETCH_ASSOC);
if (empty($rows)) {
    out('(No hay filas en tm_contador_comensales)');
} else {
    out('Total filas: ' . count($rows));
    foreach ($rows as $r) {
        out(sprintf(
            '  id_pedido=%s  nro_personas=%s  estado=%s  fecha_inicio=%s  fecha_fin=%s',
            $r['id_pedido'] ?? '-',
            $r['nro_personas'] ?? '-',
            $r['estado'] ?? '-',
            $r['fecha_inicio'] ?? '-',
            $r['fecha_fin'] ?? 'NULL'
        ));
    }
}

out('');
out('--- 2) Suma actual (la que usa la app: WHERE estado = "a") ---');
$stm = $db->query("SELECT SUM(nro_personas) AS comensales FROM tm_contador_comensales WHERE estado = 'a'");
$sum = $stm->fetch(PDO::FETCH_ASSOC);
$total = $sum['comensales'] !== null ? (int)$sum['comensales'] : 0;
out('SUM(nro_personas) WHERE estado="a" = ' . $total);

out('');
out('--- 3) Conteo por estado ---');
$stm = $db->query("SELECT estado, COUNT(*) AS cnt, SUM(nro_personas) AS suma FROM tm_contador_comensales GROUP BY estado");
while ($r = $stm->fetch(PDO::FETCH_ASSOC)) {
    out(sprintf('  estado=%s  filas=%s  suma_personas=%s', $r['estado'], $r['cnt'], $r['suma']));
}

// 4) Mesas/pedidos actualmente activos (vista que usa la app)
out('');
out('--- 4) Pedidos/mesas activos (v_listar_mesas con estado i o p) ---');
try {
    $stm = $db->query("SELECT id_pedido, id_mesa, nro_mesa, desc_salon, estado, nro_personas, fecha_pedido FROM v_listar_mesas WHERE estado IN ('i','p') ORDER BY id_pedido");
    $mesas = $stm->fetchAll(PDO::FETCH_ASSOC);
    if (empty($mesas)) {
        out('(Ningún pedido activo en mesas)');
    } else {
        out('Pedidos activos (ocupados o en pago): ' . count($mesas));
        $sumaPersonas = 0;
        foreach ($mesas as $m) {
            $p = (int)($m['nro_personas'] ?? 0);
            $sumaPersonas += $p;
            out(sprintf('  id_pedido=%s  mesa=%s  nro_personas=%s  estado=%s', $m['id_pedido'], $m['nro_mesa'] ?? '-', $p, $m['estado']));
        }
        out('Suma nro_personas en mesas activas: ' . $sumaPersonas);
    }
} catch (Exception $e) {
    out('(No se pudo consultar v_listar_mesas: ' . $e->getMessage() . ')');
}

// 5) Ids en contador con estado 'a' vs ids en mesas activas
out('');
out('--- 5) Comparación: id_pedido en contador (estado a) vs pedidos activos ---');
$stm = $db->query("SELECT id_pedido FROM tm_contador_comensales WHERE estado = 'a'");
$ids_contador = $stm->fetchAll(PDO::FETCH_COLUMN);
$ids_contador = array_map('intval', $ids_contador);
$stm = $db->query("SELECT id_pedido FROM v_listar_mesas WHERE estado IN ('i','p')");
$ids_mesas = $stm->fetchAll(PDO::FETCH_COLUMN);
$ids_mesas = array_map('intval', array_unique($ids_mesas));

$solo_contador = array_diff($ids_contador, $ids_mesas);
$solo_mesas = array_diff($ids_mesas, $ids_contador);

if (!empty($solo_contador)) {
    out('En contador (estado a) pero NO en mesas activas (huérfanos): ' . implode(', ', $solo_contador));
    out('  → Estos hacen que el total se quede alto. Se pueden marcar estado=z o borrar para ese id_pedido.');
    // Sincronizar: marcar huérfanos como cerrados (estado=z) para que el total coincida con mesas reales
    $sync = isset($_GET['sincronizar']) || (isset($argv[1]) && $argv[1] === 'sincronizar');
    if ($sync) {
        out('');
        out('--- Sincronizando: cerrando huérfanos (estado=z) ---');
        $fecha = date('Y-m-d H:i:s');
        $up = $db->prepare("UPDATE tm_contador_comensales SET fecha_fin = ?, estado = 'z' WHERE estado = 'a' AND id_pedido = ?");
        $n = 0;
        foreach ($solo_contador as $id_pedido) {
            $up->execute(array($fecha, $id_pedido));
            $n += $up->rowCount();
        }
        out('Filas actualizadas: ' . $n);
        $stm = $db->query("SELECT SUM(nro_personas) AS comensales FROM tm_contador_comensales WHERE estado = 'a'");
        $sum = $stm->fetch(PDO::FETCH_ASSOC);
        out('Nueva suma (estado=a): ' . ($sum['comensales'] !== null ? (int)$sum['comensales'] : 0));
    } else {
        out('  Para corregir ahora: ejecutar con ?sincronizar=1 (navegador) o php diagnostico_comensales.php sincronizar (CLI).');
    }
}
if (!empty($solo_mesas)) {
    out('En mesas activas pero NO en contador: ' . implode(', ', $solo_mesas));
}
if (empty($solo_contador) && empty($solo_mesas) && empty($ids_contador)) {
    out('Contador vacío y sin mesas activas. Coherente.');
} elseif (empty($solo_contador) && empty($solo_mesas)) {
    out('Contador y mesas activas coinciden en id_pedido.');
}

out('');
out('=== FIN DIAGNÓSTICO ===');

if (!$cli) {
    echo '</pre>';
}
