<?php
/**
 * Endpoint dedicado: Registrar venta con facturación dividida.
 * Crea una tm_venta por cada precuenta (cliente y correlativo distintos).
 *
 * URL: http://localhost/api_registrar_venta_dividida.php (o tu base URL + api_registrar_venta_dividida.php)
 * POST: mismos datos que venta/RegistrarVenta, con dividir_cuenta=2 y nombrePrecuentaItem[].
 *       Solo se incluyen ítems con cantidad > 0 por precuenta.
 * Respuesta JSON: success, data.idventa, data.ventas_por_precuenta[], data.mensaje
 */
error_reporting(E_ALL);
ini_set('display_errors', 0);
header('Content-Type: application/json; charset=utf-8');

require_once __DIR__ . '/config.php';
require_once __DIR__ . '/libs/Database.php';
require_once __DIR__ . '/libs/Session.php';
require_once __DIR__ . '/libs/Model.php';
require_once __DIR__ . '/util/Auth.php';

function autoload_venta_dividida($class) {
    $paths = array('libs/', 'models/');
    foreach ($paths as $p) {
        $f = __DIR__ . '/' . $p . $class . '.php';
        if (file_exists($f)) { require_once $f; return; }
    }
}
spl_autoload_register('autoload_venta_dividida');

session_start();
Session::init();
if (!Session::get('usuid')) {
    echo json_encode(array('success' => false, 'data' => array('mensaje' => 'Sesión requerida', 'idventa' => null)));
    exit;
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(array('success' => false, 'data' => array('mensaje' => 'Método no permitido', 'idventa' => null)));
    exit;
}

$log_file = __DIR__ . '/log_registrar_venta_dividida.log';
$data = $_POST;
$data['dividir_cuenta'] = '2';

if (empty($data['id_pedido'])) {
    file_put_contents($log_file, date('Y-m-d H:i:s') . " id_pedido vacío\n", FILE_APPEND);
    echo json_encode(array('success' => false, 'data' => array('mensaje' => 'ID de pedido no proporcionado', 'idventa' => null)));
    exit;
}

if (empty($data['nombrePrecuentaItem']) || !is_array($data['nombrePrecuentaItem'])) {
    file_put_contents($log_file, date('Y-m-d H:i:s') . " nombrePrecuentaItem vacío o no array\n", FILE_APPEND);
    echo json_encode(array('success' => false, 'data' => array('mensaje' => 'Facturación dividida requiere nombrePrecuentaItem', 'idventa' => null)));
    exit;
}

try {
    require_once __DIR__ . '/models/venta_model.php';
    $venta_model = new Venta_Model();
    $result = $venta_model->RegistrarVenta($data);

    if (is_array($result) && !empty($result['success']) && !empty($result['data'])) {
        file_put_contents($log_file, date('Y-m-d H:i:s') . " OK id_pedido=" . $data['id_pedido'] . " ventas=" . (isset($result['data']['ventas_por_precuenta']) ? count($result['data']['ventas_por_precuenta']) : 1) . "\n", FILE_APPEND);
        echo json_encode($result);
    } else {
        $msg = is_array($result) && isset($result['data']['mensaje']) ? $result['data']['mensaje'] : 'Error al registrar';
        echo json_encode(array('success' => false, 'data' => array('mensaje' => $msg, 'idventa' => null)));
    }
} catch (Throwable $e) {
    file_put_contents($log_file, date('Y-m-d H:i:s') . " Exception: " . $e->getMessage() . " " . $e->getFile() . ":" . $e->getLine() . "\n", FILE_APPEND);
    echo json_encode(array('success' => false, 'data' => array('mensaje' => 'Error: ' . $e->getMessage(), 'idventa' => null)));
}
