# Facturación Electrónica - Documentación

## Descripción General

El sistema de facturación electrónica integra con **facturafacil** (Panamá) para emitir documentos electrónicos válidos según las normativas de la DGI (Dirección General de Ingresos).

## Flujo de Funcionamiento

### 1. Registro de Venta

Cuando se registra una venta:

1. **Registro de la venta**: Se guarda la venta en `tm_venta` mediante el endpoint `venta/RegistrarVenta`
2. **Registro de facturación electrónica**: Después de crear la venta, se llama automáticamente al endpoint `venta/RegistrarFacturacionElectronica` que:
   - Guarda el documento en `tm_facturacion_electronica_documentos`
   - Guarda los items en `tm_facturacion_electronica_items`
   - Guarda los impuestos en `tm_facturacion_electronica_item_taxes`
   - Guarda los pagos en `tm_facturacion_electronica_payments`

### 2. Configuración de Impuestos

El sistema diferencia entre **impuesto incluido** e **impuesto excluido**:

#### Impuesto Incluido
- El precio que ingresa el usuario ya incluye el impuesto
- El sistema calcula:
  - Precio sin impuesto: `precio_con_impuesto / (1 + tasa_impuesto)`
  - Impuesto: `precio_con_impuesto - precio_sin_impuesto`
- Ejemplo: Precio $10.70 con ITBMS 7% incluido → Precio sin impuesto: $10.00, Impuesto: $0.70

#### Impuesto Excluido
- El precio que ingresa el usuario no incluye el impuesto
- El sistema calcula:
  - Precio sin impuesto: precio original
  - Impuesto: `precio * tasa_impuesto`
- Ejemplo: Precio $10.00 con ITBMS 7% excluido → Precio sin impuesto: $10.00, Impuesto: $0.70

### 3. Tipos de Documentos

En Panamá, todos los documentos se emiten como **FAC** (Factura):
- **Boletas** → FAC
- **Facturas** → FAC
- **Notas de Venta** → FAC (no se emiten electrónicamente, solo se guardan localmente)
- **Notas de Crédito** → NTC
- **Notas de Débito** → NTD

El tipo de documento se configura en `tm_tipo_doc` y se envía en el campo `tipo_documento_electronico`.

### 4. Envío a facturafacil

Para enviar un documento a facturafacil:

1. Ir a **Facturación > Documentos FE**
2. Buscar el documento con estado "pending"
3. Hacer clic en el botón **Enviar** (icono de avión)
4. El sistema construye el payload según la documentación de la API
5. Se envía a la API de facturafacil (QA o Producción según configuración)

## Validaciones y Requisitos

### Receptor

- **Consumidor Final (type="02")**: 
  - Solo requiere nombre
  - NO debe incluir RUC, DV ni ubicación
  
- **Contribuyente (type="01")**: 
  - Requiere: nombre, RUC, tipo de RUC, dirección, ubicación (PP-DD-CC)
  
- **Gobierno (type="03")**: 
  - Requiere: nombre, RUC, dirección, ubicación
  - Los items deben incluir código CPBS/GNS

### Punto de Venta (POS)

- Debe tener exactamente **3 dígitos** (000-999)
- Se rellena automáticamente con ceros a la izquierda si es necesario

### Número Fiscal (fd_number)

- Debe ser un entero entre **0 y 9999999999**
- Se obtiene del correlativo configurado en `tm_tipo_doc`

### Impuestos

- **Tipo**: Siempre "01" (ITBMS)
- **Código**: Se mapea automáticamente según la tasa:
  - `00` = Exento (0%)
  - `01` = 7%
  - `02` = 10%
  - `03` = 15%
- **Tasa (rate)**: Se envía como porcentaje (ej: "7.00" para 7%)
- **Monto (amount)**: Se envía como string con 2 decimales (ej: "0.70")

### Montos

- Todos los montos se envían como **strings con 2 decimales**
- Ejemplo: `"100.00"` en lugar de `100` o `100.0`

### Sucursal (Branch)

Si la sucursal no existe en facturafacil, se requiere:
- **Código**: 4 dígitos
- **Dirección**: Máximo 100 caracteres
- **Teléfono**: 8 dígitos sin guiones
- **Ubicación**: Formato PP-DD-CC (8 caracteres)
- **Coordenadas**: Formato latitud,longitud (ej: +08.9539,-79.5343)
- **Email**: Opcional

## Configuración

### Activar Facturación Electrónica

1. Ir a **Ajustes > Facturación Electrónica**
2. Activar la facturación electrónica
3. Configurar:
   - Company UUID
   - API Key
   - Branch (código de sucursal)
   - Datos de la sucursal (dirección, teléfono, ubicación, coordenadas)

### Configurar Tipos de Documento

1. Ir a **Ajustes > Tipos de Documento**
2. Para cada tipo de documento configurar:
   - Serie (ej: BA01)
   - POS (ej: 001)
   - Número inicial y actual
   - Ambiente (1=Producción, 2=Pruebas)
   - Tipo de documento electrónico (FAC, NTC, NTD)

## Respuesta de la API cuando el documento es rechazado

Al enviar un documento, la API devuelve **HTTP 201** tanto si fue autorizado como si fue rechazado por la DGI. Para saber si fue rechazado:

- **rejected**: `true` = rechazado por DGI, `false` = autorizado.
- **messages**: array de mensajes de rechazo (según ficha técnica DGI). Cada elemento tiene:
  - **code**: Código de error (string).
  - **message**: Mensaje de error (string).
  - **field_name** (opcional): Campo con el error.
  - **path** (opcional): Ruta del campo.
  - **type**: `"R"` = Rechazo, `"N"` = Notificación.

El sistema guarda `rejected_messages` en la tabla `tm_facturacion_electronica_documentos` como JSON. En **Facturación > Documentos FE**, los documentos rechazados muestran un enlace **"Ver motivo"** que abre el detalle con la lista de mensajes.

Causas frecuentes de rechazo (códigos DGI):
- **2007** – No informado código de producto en Codificación Panameña (CPBS/GNS). Cada ítem debe llevar el campo **gns** (4 dígitos, ej: 5010 = servicios de restaurante).
- **2152** – Monto del ITBMS del ítem inválido. El monto del impuesto por ítem debe ser `round(subtotal × tasa, 2)`.
- **2514** – Valor total de los ítems inválidos. El **total** y **dVTotItems** deben coincidir con la suma de totales por ítem (redondeo 2 decimales).
- Contribuyente/Gobierno: falta **dv**, **address**, **location** (PP-DD-CC), o **ruc**.
- Sucursal: falta dirección, teléfono (8 dígitos), ubicación o coordenadas.
- Fecha de emisión mayor a 2 días desde la fecha actual.

## Logs y Debugging

Los logs se guardan en:
- `debug_facturacion_electronica.log` - Logs detallados del proceso
- `error_log` - Errores del sistema

Los logs incluyen:
- Datos recibidos en cada endpoint
- Payload completo antes de enviar a la API
- Respuestas de la API
- Errores y excepciones

## Endpoints

- `venta/RegistrarVenta` - Registra la venta
- `venta/RegistrarFacturacionElectronica` - Guarda datos de facturación electrónica
- `facturacion/documentos_enviar` - Envía documento a facturafacil
- `facturacion/documentos_descargar_pdf` - Descarga PDF del documento
- `facturacion/documentos_descargar_xml` - Descarga XML del documento
- `facturacion/documentos_descargar_cafe` - Descarga CUFE del documento

## Notas Importantes

1. **Los datos se guardan correctamente** según la configuración de impuesto incluido/excluido al momento de registrar la venta
2. **Al enviar desde la vista de facturación/documentos**, se usan los datos ya guardados (no se recalculan)
3. **El tipo de documento** se determina desde `tm_tipo_doc` a través del campo `tipo_documento_electronico`
4. **Los impuestos se calculan correctamente** tanto si están incluidos como excluidos en el precio
