$(function() {
    /* NOTA KERLYN: quitar el excluded del form*/
    $('#form-cliente').formValidation({
        framework: 'bootstrap',
        excluded: ':disabled',
        fields: {
            dni: {
                validators: {
                    stringLength: {
                        message: 'El '+$(".c-dni").text()+' debe tener '+$("#dni").attr("maxlength")+' digitos'
                    }
                }
            },
            ruc: {
                validators: {
                    stringLength: {
                        min: 5,
                        max: (function() { return parseInt($("#ruc").attr("maxlength"), 10) || 35; })(),
                        message: (function() {
                            var max = parseInt($("#ruc").attr("maxlength"), 10) || 35;
                            var label = ($(".c-ruc").length && $(".c-ruc").text()) ? $(".c-ruc").text() : 'RUC';
                            if (max > 20) return 'El '+label+' debe tener entre 5 y '+max+' caracteres';
                            return 'El '+label+' debe tener '+max+' dígitos';
                        })()
                    }
                }
            }
        }
    })
    .on('invalid.form.fv', function(e) {
        console.log('[Modal Cliente Aceptar] Validación fallida - el formulario tiene errores');
    })
    .on('success.form.fv', function(e) {
        console.log('[Modal Cliente Aceptar] Validación OK - preparando envío');
        e.preventDefault();
        var $form = $(e.target);
        var fv = $form.data('formValidation');

        /*
        if($('#codcomision').val() == 1){
            var tipo_cliente = $('input:radio[name=tipo_cli]:checked').val();
        }else{
            var tipo_cliente = $('#tipo_cliente').val();
        }
        */

        var id_cliente = $('#id_cliente').val();
        var tipo_cliente = $('#tipo_cliente').val();
        var rucRaw = $('#ruc').val();
        var ruc = rucRaw;
        if (rucRaw && rucRaw.indexOf(' DV:') !== -1) {
            ruc = rucRaw.replace(/\s*DV:\s*\S+$/, '').trim();
        }
        var dv = $('#dv_cliente').val() || '';
        var dni = $('#dni').val();
        var nombres = $('#nombres').val();
        var fecha_nac = $('#fecha_nac').val();
        var telefono = $('#telefono').val();
        var correo = $('#correo').val();
        var razon_social = $('#razon_social').val();
        var direccion = $('#direccion').val();
        var referencia = $('#referencia').val();
        var ubicacion = $('#ubicacion').length ? $('#ubicacion').val() : '';
        var tipo_ruc = $('#tipo_ruc_cliente').length ? $('#tipo_ruc_cliente').val() : '';
        var tipo_contribuyente = ($('#tipo_contribuyente_cliente').length ? $('#tipo_contribuyente_cliente').val() : '') || '02';
        if (['01','02','03'].indexOf(tipo_contribuyente) < 0) tipo_contribuyente = '02';

        var payload = {
            id_cliente: id_cliente,
            tipo_cliente: tipo_cliente,
            ruc: ruc,
            dv: dv,
            dni: dni,
            nombres: nombres,
            fecha_nac: fecha_nac,
            telefono: telefono,
            correo: correo,
            razon_social: razon_social,
            direccion: direccion,
            referencia: referencia,
            ubicacion: ubicacion,
            tipo_ruc: tipo_ruc,
            tipo_contribuyente: tipo_contribuyente
        };
        var urlCrud = $('#url').val() + 'venta/cliente_crud';
        console.log('[Modal Cliente Aceptar] Enviando...', { url: urlCrud, payload: payload });

        $.ajax({
            type: 'POST',
            dataType: 'json',
            data: payload,
            url: urlCrud,
            success: function(data){
                console.log('[Modal Cliente Aceptar] Respuesta success:', data);
                if (data.cod == 1) {
                    data.id_cliente = data.id_cliente || payload.id_cliente;
                }
                if (window.facturacionDivididaClienteRow && window.facturacionDivididaClienteRow.length) {
                    var $row = window.facturacionDivididaClienteRow;
                    $row.find('.id-cliente-precuenta').val(data.id_cliente);
                    $row.find('.nombre-cliente-precuenta').text(tipo_cliente == 1 ? (nombres || '') : (razon_social || ''));
                    window.facturacionDivididaClienteRow = null;
                    $('#modal-cliente').modal('hide');
                    setTimeout(function() { $('#modal-facturacion-dividida').modal('show'); }, 300);
                    return;
                }
                {
                    $('#modal-cliente').modal('hide');
                    $('#cliente_id').val(data.id_cliente);
                    $('#id_cliente').val(data.id_cliente);

                    if($('#codpagina').val() == 1){

                        /////////////////////////////////////////////
                        $('.display-nombre').css('display','block');
                        $('.display-telefono-cliente').css('display','block');
                        $("#nomb_cliente").removeAttr('disabled');
                        $("#telefono_cliente").removeAttr('disabled');
                        /////////////////////////////////////////
                        if($('input:radio[name=tipo_entrega]:checked').val() == 1){
                            $('.display-direccion-cliente').css('display','block');
                            $('.display-referencia-cliente').css('display','block');
                            $('.display-repartidor').css('display','block');
                            $("#direccion_cliente").removeAttr('disabled');
                            $("#referencia_cliente").removeAttr('disabled');
                            $("#id_repartidor").removeAttr('disabled');
                        } else {
                            $('.display-direccion-cliente').css('display','none');
                            $('.display-referencia-cliente').css('display','none');
                            $('.display-repartidor').css('display','none');
                            $("#direccion_cliente").attr('disabled','true');
                            $("#referencia_cliente").attr('disabled','true');
                            $("#id_repartidor").attr('disabled','true');
                        }
                        ////////////////////////////////////////////

                        $('#telefono_cliente').val(telefono);
                        if(tipo_cliente == 1){
                            $("#nomb_cliente").val(nombres);
                        } else if (tipo_cliente == 2){
                            $("#nomb_cliente").val(razon_social);
                        }
                        $('#direccion_cliente').val(direccion);
                        $('#referencia_cliente').val(referencia);
                        $('#form-nuevo-pedido').formValidation('revalidateField', 'telefono_cliente');
                        $('#form-nuevo-pedido').formValidation('revalidateField', 'nomb_cliente');
                        $('#form-nuevo-pedido').formValidation('revalidateField', 'direccion_cliente');
                        $('#form-nuevo-pedido').formValidation('revalidateField', 'referencia_cliente');

                        $('.btn-opc-nuevo-cliente').html('<button class="btn btn-info" onclick="editar_cliente('+data.id_cliente+');" type="button"><i class="fa fa-user"></i></button>');

                    } else if($('#codpagina').val() == 2){

                        $('#modal-facturar').modal('show');
                        if ($('#cliente_tipo').length) $('#cliente_tipo').val(tipo_cliente);
                        if(tipo_cliente == 1){
                            $("#buscar_cliente").val('DNI: '+dni+' | '+nombres);
                        } else if (tipo_cliente == 2){
                            $("#buscar_cliente").val('RUC: '+ruc+' | '+razon_social);
                        }
                        if ($('#receptor_type_fe').length) $('#receptor_type_fe').val(tipo_contribuyente);
                        if (typeof actualizarTipoContribuyenteDisplay === 'function') actualizarTipoContribuyenteDisplay(tipo_contribuyente);
                        $('.opcion-cliente').html('<a class="input-group-prepend" href="javascript:void(0)"'
                            +'onclick="editar_cliente('+data.id_cliente+');" data-original-title="Editar cliente" data-toggle="tooltip"'
                            +'data-placement="top">'
                                +'<span class="input-group-text bg-header">'
                                    +'<small><i class="fas fa-user text-info"></i></small>'
                               +'</span>'
                            +'</a>');

                        //$("#btn-submit-facturar").removeAttr('disabled');
                        //$("#btn-submit-facturar").removeClass('disabled');
                    } else {

                        if ($('#cliente_tipo').length) $('#cliente_tipo').val(tipo_cliente);
                        if(tipo_cliente == 1){
                            $("#buscar_cliente").val('DNI: '+dni+' | '+nombres);
                        } else if (tipo_cliente == 2){
                            $("#buscar_cliente").val('RUC: '+ruc+' | '+razon_social);
                        }
                        if ($('#receptor_type_fe').length) $('#receptor_type_fe').val(tipo_contribuyente);
                        if (typeof actualizarTipoContribuyenteDisplay === 'function') actualizarTipoContribuyenteDisplay(tipo_contribuyente);
                        $('.opcion-cliente').html('<a class="input-group-prepend" href="javascript:void(0)"'
                            +'onclick="editar_cliente('+data.id_cliente+');" data-original-title="Editar cliente" data-toggle="tooltip"'
                            +'data-placement="top">'
                                +'<span class="input-group-text bg-header">'
                                    +'<small><i class="fas fa-user text-info"></i></small>'
                               +'</span>'
                            +'</a>');
                        
                    }

                }
                
            },
            error: function(xhr, status, err) {
                console.error('[Modal Cliente Aceptar] Error AJAX:', { status: status, error: err, xhr: xhr, responseText: xhr && xhr.responseText ? xhr.responseText.substring(0, 500) : '' });
                Swal.fire({ title: 'Error al guardar', html: 'No se pudo guardar el cliente. Revise la consola (F12) para más detalles.', icon: 'error', confirmButtonColor: '#34d16e' });
            },
            complete: function() {
                console.log('[Modal Cliente Aceptar] Petición finalizada');
            }
        });
        return false;
    });
});

var editar_cliente = function(id_cliente){
    $.ajax({
        url: $('#url').val()+'cliente/cliente_datos',
        type: 'POST',
        data: {id_cliente: id_cliente},
        dataType: 'json'
    })
    .done(function(item){
        $.each(item.data, function(i, campo) {
            $('#id_cliente').val(campo.id_cliente);
            $('#tipo_cliente').val(campo.tipo_cliente);
            $('#dni').val(campo.dni);
            $('#ruc').val(campo.dv ? (campo.ruc || '') + ' DV:' + campo.dv : (campo.ruc || ''));
            $('#dv_cliente').val(campo.dv || '');
            $('#nombres').val(campo.nombres);
            $('#fecha_nac').val(moment(campo.fecha_nac).format('DD-MM-Y'));
            $('#telefono').val(campo.telefono);
            $('#correo').val(campo.correo);
            $('#razon_social').val(campo.razon_social);
            $('#direccion').val(campo.direccion);
            $('#referencia').val(campo.referencia);
            if ($('#ubicacion').length) $('#ubicacion').val(campo.ubicacion || '');
            if ($('#tipo_ruc_cliente').length) $('#tipo_ruc_cliente').val(campo.tipo_ruc != null ? campo.tipo_ruc : '');
            var tc = (campo.tipo_contribuyente && ['01','02','03'].indexOf(campo.tipo_contribuyente) >= 0) ? campo.tipo_contribuyente : '02';
            if ($('#tipo_contribuyente_cliente').length) $('#tipo_contribuyente_cliente').val(tc);
            $('input:radio[name="tipo_contribuyente_cliente"]').prop('checked', false);
            $('input:radio[name="tipo_contribuyente_cliente"][value="' + tc + '"]').prop('checked', true);
            $('.btn-tipo-contrib-cliente-01, .btn-tipo-contrib-cliente-02, .btn-tipo-contrib-cliente-03').removeClass('active');
            if ($('.btn-tipo-contrib-cliente-' + tc).length) $('.btn-tipo-contrib-cliente-' + tc).addClass('active');
            $('.modal-title-cliente').text('Editar Cliente');
            if(campo.tipo_cliente == 1){
                $("#td_dni").attr('checked', true);
                $("#td_ruc").attr('checked', false);
                $(".dni").prop('disabled', false);
                $(".ruc").prop('disabled', true);
                $(".block01").css("display","block");
                $(".block02").css("display","none");
                $(".block03").css("display","block");
                $(".block04").css("display","block");
                $(".block05").css("display","block");
                $(".block06").css("display","block");
                $(".block07").css("display","none");
            } else if(campo.tipo_cliente == 2){
                $("#td_ruc").attr('checked', true);
                $("#td_dni").attr('checked', false);
                $(".dni").prop('disabled', true);
                $(".ruc").prop('disabled', false);
                $(".block01").css("display","none");
                $(".block02").css("display","block");
                $(".block03").css("display","none");
                $(".block04").css("display","none");
                $(".block05").css("display","none");
                $(".block06").css("display","block");
                $(".block07").css("display","block");
            }
        });
        $('#modal-cliente').modal('show');
    })
    .fail(function(){
        swal('Oops...', 'Problemas con la conexión a internet!', 'error');
    });
}

var nuevo = function(){
    if($('#codcomision').val() == 1){
        $("#td_dni").attr('checked', false);
        $("#td_ruc").attr('checked', false);
        $(".block01").css("display","none");
        $(".block02").css("display","none");
        $(".block03").css("display","none");
        $(".block04").css("display","none");
        $(".block05").css("display","none");
        $(".block06").css("display","none");
        $(".block07").css("display","none");
        $(".block08").css("display","none");
    } 
    
    if($('#cliente_tipo').val() != ''){
        $('.modal-title-cliente').text('Nuevo Cliente');
        if($('#cliente_tipo').val() == 1){
            $('#tipo_cliente').val(1);
            $("#td_dni").attr('checked', true);
            $("#td_ruc").attr('checked', false);
            $("#td_ce").attr('checked', false);
            $(".block_ce").css("display","none");
            $(".block01").css("display","block");
            $(".block02").css("display","none");
            $(".block03").css("display","block");
            $(".block04").css("display","block");
            $(".block05").css("display","block");
            $(".block06").css("display","block");
            $(".block07").css("display","none");
            $(".dni").prop('disabled', false);
            $(".ruc").prop('disabled', true);
            $('#form-cliente').formValidation('resetForm', true);
            $('#modal-cliente').modal('show');
        } else if($('#cliente_tipo').val() == 2){
            $('#tipo_cliente').val(2);
            $("#td_dni").attr('checked', false);
            $("#td_ruc").attr('checked', true);
            $("#td_ce").attr('checked', false);
            $(".block_ce").css("display","none");
            $(".block01").css("display","none");
            $(".block02").css("display","block");
            $(".block03").css("display","none");
            $(".block04").css("display","none");
            $(".block05").css("display","none");
            $(".block06").css("display","block");
            $(".block07").css("display","block");
            $(".dni").prop('disabled', true);
            $(".ruc").prop('disabled', false);
            $('#form-cliente').formValidation('resetForm', true);
            $('#modal-cliente').modal('show');
        } else if($('#cliente_tipo').val() == 3){
            $('#tipo_cliente').val(1);
            $("#td_dni").attr('checked', true);
            $("#td_ruc").attr('checked', false);
            $("#td_ce").attr('checked', false);
            $(".block_ce").css("display","none");
            $(".block01").css("display","block");
            $(".block02").css("display","none");
            $(".block03").css("display","block");
            $(".block04").css("display","block");
            $(".block05").css("display","block");
            $(".block06").css("display","block");
            $(".block07").css("display","none");
            $(".dni").prop('disabled', false);
            $(".ruc").prop('disabled', true);
            $('#form-cliente').formValidation('resetForm', true);
            $('#modal-cliente').modal('show');
        }else {
            //$('#modal-cliente').modal('show');
        }
    }
}

/* Nuevo Cliente: abrir siempre en sección RUC / Contribuyente por defecto */
var nuevoCliente = function(){
    $('#id_cliente').val('');
    $('#cliente_tipo').val(2);
    $('#tipo_cliente').val(2);
    $('.modal-title-cliente').text('Nuevo Cliente');
    $("#td_ruc").attr('checked', true);
    if ($("#td_dni").length) $("#td_dni").attr('checked', false);
    if ($("#td_ce").length) $("#td_ce").attr('checked', false);
    $(".block_ce").css("display","none");
    $(".block01").css("display","none");
    $(".block02").css("display","block");
    $(".block03").css("display","block");
    $(".block04").css("display","block");
    $(".block05").css("display","block");
    $(".block06").css("display","block");
    $(".block07").css("display","block");
    if ($(".block08").length) $(".block08").css("display","block");
    $(".dni").prop('disabled', true);
    $(".ruc").prop('disabled', false);
    if ($('input[name="tipo_contribuyente_cliente"]').length) {
        $('input:radio[name="tipo_contribuyente_cliente"][value="02"]').prop('checked', true);
        $('.btn-tipo-contrib-cliente-01, .btn-tipo-contrib-cliente-03').removeClass('active');
        $('.btn-tipo-contrib-cliente-02').addClass('active');
        if ($('#tipo_contribuyente_cliente').length) $('#tipo_contribuyente_cliente').val('02');
    }
    $('#form-cliente').formValidation('resetForm', true);
    $('#modal-cliente').modal('show');
}

var nuevo_cliente = function() {
    $('#id_cliente').val('');
    $('#tipo_cliente').val(2);
    $('#telefono').val($('#telefono_cliente').val());
    $('.modal-title-cliente').text('Nuevo Cliente');
    $('#modal-cliente').modal('show');
    $("#td_ruc").attr('checked', true);
    if ($("#td_dni").length) $("#td_dni").attr('checked', false);
    if ($("#td_ce").length) $("#td_ce").attr('checked', false);
    $(".block_ce").css("display","none");
    $(".block01").css("display","none");
    $(".block02").css("display","block");
    $(".block03").css("display","block");
    $(".block04").css("display","block");
    $(".block05").css("display","block");
    $(".block06").css("display","block");
    $(".block07").css("display","block");
    $(".dni").prop('disabled', true);
    $(".ruc").prop('disabled', false);
    if ($('input[name="tipo_contribuyente_cliente"]').length) {
        $('input:radio[name="tipo_contribuyente_cliente"][value="02"]').prop('checked', true);
        if ($('#tipo_contribuyente_cliente').length) $('#tipo_contribuyente_cliente').val('02');
    }
};

/* INICIO SRTA KERLYN */
$('input:radio[id=td_dni]').on('click', function(event){
    $('#tipo_cliente').val(1);
    $("#td_dni").attr('checked', true);
    $("#td_ruc").attr('checked', false);
    $("#td_ce").attr('checked', false);
    $(".block_ce").css("display","none");
    $(".block01").css("display","block");
    $(".block02").css("display","none");
    $(".block03").css("display","block");
    $(".block04").css("display","block");
    $(".block05").css("display","block");
    $(".block06").css("display","block");
    $(".block07").css("display","none");
    $(".block08").css("display","block");
    $(".dni").prop('disabled', false);
    $(".ruc").prop('disabled', true);
    $('#form-cliente').formValidation('resetForm', true);
});

$('input:radio[id=td_ruc]').on('click', function(event){
    $('#tipo_cliente').val(2);
    $("#td_dni").attr('checked', false);
    $("#td_ruc").attr('checked', true);
    $("#td_ce").attr('checked', false);
    $(".block_ce").css("display","none");
    $(".block01").css("display","none");
    $(".block02").css("display","block");
    $(".block03").css("display","none");
    $(".block04").css("display","none");
    $(".block05").css("display","none");
    $(".block06").css("display","block");
    $(".block07").css("display","block");
    $(".block08").css("display","block");
    $(".dni").prop('disabled', true);
    $(".ruc").prop('disabled', false);
    $('#form-cliente').formValidation('resetForm', true);
});

/* FIN SRTA KERLYN */

/* Sincronizar tipo contribuyente (modal Nuevo Cliente) con el hidden */
$(document).on('change', 'input[name="tipo_contribuyente_cliente"]', function() {
    var v = $(this).val();
    if ($('#tipo_contribuyente_cliente').length) $('#tipo_contribuyente_cliente').val(v);
    $('.btn-tipo-contrib-cliente-01, .btn-tipo-contrib-cliente-02, .btn-tipo-contrib-cliente-03').removeClass('active');
    if ($('.btn-tipo-contrib-cliente-' + v).length) $('.btn-tipo-contrib-cliente-' + v).addClass('active');
});

/* Consultar DNI del nuevo cliente: primero en DB, si no existe usar API */
$("#dni").keyup(function(event) {
    var that = this,
    value = $(this).val().trim();
    if (value.length == $("#dni").attr("maxlength")) {
        var dniNum = value.replace(/\D/g, '');
        // 1) Buscar primero en la base de datos
        $.ajax({
            url: $('#url').val() + 'cliente/cliente_por_dni',
            type: 'POST',
            data: { dni: dniNum },
            dataType: 'json'
        })
        .done(function(response) {
            if (response && response.success && response.data) {
                var c = response.data;
                $('#id_cliente').val(c.id_cliente || '');
                $('#tipo_cliente').val(c.tipo_cliente != null ? c.tipo_cliente : 1);
                $("#dni").val(c.dni || '');
                $("#nombres").val(c.nombres || '');
                $("#fecha_nac").val(c.fecha_nac ? String(c.fecha_nac).substr(0, 10) : '');
                $("#telefono").val(c.telefono || '');
                $("#correo").val(c.correo || '');
                $("#direccion").val(c.direccion || '');
                $("#referencia").val(c.referencia || '');
                if ($('#ubicacion').length) $('#ubicacion').val(c.ubicacion || '');
                $('#form-cliente').formValidation('revalidateField', 'nombres');
                $('#form-cliente').formValidation('revalidateField', 'dni');
                Swal.fire({ title: 'Cliente encontrado', html: 'Se cargaron los datos desde la base de datos. Puede actualizar correo, dirección, ubicación, referencia y fecha de nacimiento antes de Aceptar.', icon: 'success', confirmButtonColor: '#34d16e', timer: 3000, showConfirmButton: true });
                return;
            }
            // 2) No existe en DB: consultar API externa
            $.getJSON($('#url').val() + "api/dni/" + encodeURIComponent(dniNum), { format: "json" })
            .done(function(data) {
                if (data == null || data.success == false) {
                    Swal.fire({ title: 'Advertencia', html: 'El número ingresado no existe', icon: "warning", confirmButtonColor: "#34d16e", confirmButtonText: "Aceptar" });
                    return;
                }
                $("#dni").val(data.dni);
                $("#nombres").val((data.nombres || '') + ' ' + (data.apellidoPaterno || '') + ' ' + (data.apellidoMaterno || ''));
                $("#fecha_nac").val(data.fechaNacimiento || '');
                $("#direccion").val(data.direccion || '');
                $('#form-cliente').formValidation('revalidateField', 'nombres');
                $('#form-cliente').formValidation('revalidateField', 'ape_paterno');
                $('#form-cliente').formValidation('revalidateField', 'ape_materno');
            })
            .fail(function() {
                Swal.fire({ title: 'Advertencia', html: 'El número ingresado no existe o no se pudo consultar.', icon: "warning", confirmButtonColor: "#34d16e", confirmButtonText: "Aceptar" });
            });
        })
        .fail(function() {
            $.getJSON($('#url').val() + "api/dni/" + encodeURIComponent(dniNum), { format: "json" })
            .done(function(data) {
                if (data == null || data.success == false) {
                    Swal.fire({ title: 'Advertencia', html: 'El número ingresado no existe', icon: "warning", confirmButtonColor: "#34d16e", confirmButtonText: "Aceptar" });
                    return;
                }
                $("#dni").val(data.dni);
                $("#nombres").val((data.nombres || '') + ' ' + (data.apellidoPaterno || '') + ' ' + (data.apellidoMaterno || ''));
                $("#fecha_nac").val(data.fechaNacimiento || '');
                $("#direccion").val(data.direccion || '');
                $('#form-cliente').formValidation('revalidateField', 'nombres');
            });
        });
    } else if($("#dni").val() == "") {
        $('#dni').val("");
        $('#ruc').val("");
        $('#dv_cliente').val("");
        $('#nombres').val("");
        $('#fecha_nac').val("");
        $('#telefono').val("");
        $('#correo').val("");
        $('#razon_social').val("");
        $('#direccion').val("");
        $('#referencia').val("");
        if ($('#ubicacion').length) $('#ubicacion').val("");
        if ($('#tipo_ruc_cliente').length) $('#tipo_ruc_cliente').val("");
        $('#form-cliente').formValidation('resetForm', true);
    }
});

/* Consultar RUC del nuevo cliente: solo con botón Buscar (no automático) */
$("#ruc").keyup(function() {
    var value = $(this).val();
    if (value == "") {
        $('#dni').val("");
        $('#ruc').val("");
        $('#dv_cliente').val("");
        $('#nombres').val("");
        $('#fecha_nac').val("");
        $('#telefono').val("");
        $('#correo').val("");
        $('#razon_social').val("");
        $('#direccion').val("");
        $('#referencia').val("");
        if ($('#ubicacion').length) $('#ubicacion').val("");
        if ($('#tipo_ruc_cliente').length) $('#tipo_ruc_cliente').val("");
        $('#form-cliente').formValidation('resetForm', true);
    }
});
$("#ruc").on("keypress", function(event) {
    if (event.which === 13) {
        event.preventDefault();
        $("#btn_buscar_ruc").click();
    }
});
$("#btn_buscar_ruc").on("click", function() {
    var value = $("#ruc").val().trim();
    if (!value || value.length < 5) {
        Swal.fire({
            title: 'Atención',
            html: 'Ingrese al menos 5 caracteres en el campo ' + $(".c-ruc").text() + ' para buscar.',
            icon: 'warning',
            confirmButtonColor: '#34d16e',
            confirmButtonText: 'Aceptar'
        });
        return;
    }
    // RUC limpio (sin " DV:xx") para buscar en DB
    var rucLimpio = value.indexOf(' DV:') !== -1 ? value.replace(/\s*DV:\s*\S+$/, '').trim() : value;
    buscarRucPanama(value, rucLimpio);
});

/* Función para buscar RUC: primero en DB; si no existe, consultar API externa */
function buscarRucPanama(rucDisplay, rucLimpio) {
    if (typeof rucLimpio === 'undefined') rucLimpio = rucDisplay.replace(/\s*DV:\s*\S+$/, '').trim();
    $("#razon_social").attr('placeholder', 'Buscando...');

    // 1) Buscar primero en la base de datos (enviamos RUC normalizado para coincidir con 8-829-2193 o 88292193)
    var rucParaDb = (rucLimpio || '').replace(/\s*DV:\s*\S+$/, '').trim().replace(/[^\d]/g, '');
    if (!rucParaDb) rucParaDb = rucLimpio;
    $.ajax({
        url: $('#url').val() + 'cliente/cliente_por_ruc',
        type: 'POST',
        data: { ruc: rucParaDb },
        dataType: 'json'
    })
    .done(function(response) {
        if (response && response.success && response.data) {
            $("#razon_social").attr('placeholder', '');
            var c = response.data;
            $('#id_cliente').val(c.id_cliente || '');
            $('#tipo_cliente').val(c.tipo_cliente != null ? c.tipo_cliente : 2);
            $('#dni').val(c.dni || '');
            var rucVal = c.ruc || '';
            if (c.dv) {
                rucVal = (rucVal + ' DV:' + c.dv).trim();
                $('#dv_cliente').val(c.dv);
            } else {
                $('#dv_cliente').val('');
            }
            $('#ruc').val(rucVal);
            $('#nombres').val(c.nombres || '');
            $('#razon_social').val(c.razon_social || '');
            $('#telefono').val(c.telefono || '');
            $('#correo').val(c.correo || '');
            $('#direccion').val(c.direccion || '');
            $('#referencia').val(c.referencia || '');
            if (c.fecha_nac) {
                var f = String(c.fecha_nac).substr(0, 10);
                $('#fecha_nac').val(f);
            } else {
                $('#fecha_nac').val('');
            }
            if ($('#ubicacion').length) $('#ubicacion').val(c.ubicacion || '');
            if ($('#tipo_ruc_cliente').length) $('#tipo_ruc_cliente').val(c.tipo_ruc != null ? c.tipo_ruc : '');
            var tc = (c.tipo_contribuyente && ['01','02','03'].indexOf(c.tipo_contribuyente) >= 0) ? c.tipo_contribuyente : '02';
            if ($('#tipo_contribuyente_cliente').length) $('#tipo_contribuyente_cliente').val(tc);
            $('input:radio[name="tipo_contribuyente_cliente"]').prop('checked', false);
            $('input:radio[name="tipo_contribuyente_cliente"][value="' + tc + '"]').prop('checked', true);
            $('.btn-tipo-contrib-cliente-01, .btn-tipo-contrib-cliente-02, .btn-tipo-contrib-cliente-03').removeClass('active');
            if ($('.btn-tipo-contrib-cliente-' + tc).length) $('.btn-tipo-contrib-cliente-' + tc).addClass('active');
            $('#form-cliente').formValidation('revalidateField', 'razon_social');
            $('#form-cliente').formValidation('revalidateField', 'direccion');
            $('#form-cliente').formValidation('revalidateField', 'ruc');
            $('#form-cliente').formValidation('revalidateField', 'correo');
            Swal.fire({ title: 'Cliente encontrado', html: 'Se cargaron los datos desde la base de datos.', icon: 'success', confirmButtonColor: '#34d16e', timer: 2000, showConfirmButton: false });
            return;
        }
        // 2) No existe en DB: consultar API externa
        consultarApiRuc(rucDisplay);
    })
    .fail(function() {
        consultarApiRuc(rucDisplay);
    });
}

function consultarApiRuc(ruc) {
    $.getJSON($('#url').val() + "api/ruc/" + encodeURIComponent(ruc), { format: "json" })
    .done(function(data) {
        $("#razon_social").attr('placeholder', '');
        console.log('Respuesta API RUC:', data);
        if (data == null || data.success == false) {
            Swal.fire({ title: 'Advertencia', html: 'El número ingresado no existe', icon: "warning", confirmButtonColor: "#34d16e", confirmButtonText: "Aceptar" });
            return;
        }
        $('#id_cliente').val(''); // Cliente no está en DB: Aceptar creará uno nuevo
        if (data.ruc) {
            var rucCompleto = data.ruc;
            if (data.dv) {
                rucCompleto = data.ruc + ' DV:' + data.dv;
                $("#dv_cliente").val(data.dv);
            } else {
                $("#dv_cliente").val('');
            }
            $("#ruc").val(rucCompleto);
        }
        if (data.razonSocial) $("#razon_social").val(data.razonSocial);
        if (data.direccion) $("#direccion").val(data.direccion);
        if (data.correo) $("#correo").val(data.correo);
        if (data.telefono) $("#telefono").val(data.telefono);
        if ($("#tipo_ruc_cliente").length && data.tipoRuc != null) $("#tipo_ruc_cliente").val(data.tipoRuc);
        $('#form-cliente').formValidation('revalidateField', 'razon_social');
        $('#form-cliente').formValidation('revalidateField', 'direccion');
        $('#form-cliente').formValidation('revalidateField', 'ruc');
        Swal.fire({ title: 'Datos desde API', html: 'Complete correo, dirección, ubicación y demás datos de contacto si lo desea. Al hacer clic en Aceptar se guardará el cliente.', icon: 'info', confirmButtonColor: '#34d16e', confirmButtonText: 'Entendido' });
    })
    .fail(function(jqXHR, textStatus, errorThrown) {
        $("#razon_social").attr('placeholder', '');
        Swal.fire({ title: 'Error', html: 'Error al consultar el RUC. Intente nuevamente.', icon: "error", confirmButtonColor: "#34d16e", confirmButtonText: "Aceptar" });
    });
}

$('#modal-cliente').on('hidden.bs.modal', function() {
    $(this).find('#form-cliente')[0].reset();
    $('#form-cliente').formValidation('resetForm', true);
    //$('#modal-facturar').modal('show');
});

/* Boton limpiar datos del cliente (modal) */
$("#btnClienteLimpiar").click(function() {
    $("#cliente_id").val('');
    $('#id_cliente').val('');
    $("#buscar_cliente").val('');
    $("#buscar_cliente").focus();
    $('.opcion-cliente').html('<a class="input-group-prepend" href="javascript:void(0)"'
        +'onclick="nuevoCliente();" data-original-title="Registrar nuevo cliente" data-toggle="tooltip"'
        +'data-placement="top">'
            +'<span class="input-group-text bg-header">'
                +'<small><i class="fas fa-user-plus"></i></small>'
           +'</span>'
        +'</a>');
    
    if ($('#receptor_type_fe').length) $('#receptor_type_fe').val('02');
    if (typeof actualizarTipoContribuyenteDisplay === 'function') actualizarTipoContribuyenteDisplay('02');
});