<?php
// /venta/impresion_comanda/
require_once ('public/lib/print/num_letras.php');
require_once ('public/lib/pdf/cellfit.php');

class FPDF_CellFiti extends FPDF_CellFit
{
	function AutoPrint($dialog=false)
	{
		//Open the print dialog or start printing immediately on the standard printer
		$param=($dialog ? 'true' : 'false');
		$script="print($param);";
		$this->IncludeJS($script);
	}

	function AutoPrintToPrinter($server, $printer, $dialog=false)
	{
		//Print on a shared printer (requires at least Acrobat 6)
		$script = "var pp = getPrintParams();";
		if($dialog)
			$script .= "pp.interactive = pp.constants.interactionLevel.full;";
		else
			$script .= "pp.interactive = pp.constants.interactionLevel.automatic;";
		$script .= "pp.printerName = '\\\\\\\\".$server."\\\\".$printer."';";
		$script .= "print(pp);";
		$this->IncludeJS($script);
	}
}


// Array ( [pedido_tipo] => 1 [pedido_numero] => SALON 01 [pedido_cliente] => MESA: 3B [pedido_mozo] => CINTHYA ELISA CHAVEZ [correlativo_imp] => 000046 [nombre_imp] => COCINA [nombre_pc] => DESKTOP-F1QI6FD [codigo_anulacion] => 0 [items] => Array ( [0] => Array ( [producto_id] => 8 [area_id] => 1 [nombre_imp] => COCINA [producto] => CHULETA A LO POBRE [presentacion] => PLATO [comentario] => PALTA, ARROZ, ENSALADA FRESCA [cantidad] => 1 [precio] => 18.00 [total] => 18 [id] => 0 ) ) )



date_default_timezone_set('America/Lima');
setlocale(LC_ALL,"es_ES@euro","es_ES","esp");
$hora = date("g:i:s A");
$fecha = date("d/m/y");

$data = json_decode($_GET['data'],true);

define('EURO', chr(128));
$pdf = new FPDF_CellFiti('P', 'mm', array(72, 200));
$pdf->AddPage();
$pdf->SetMargins(2, 0, 2, 0);

// 🔹 Encabezado impresora
$pdf->SetFont('Helvetica','',9);
$pdf->Cell(68, 4, 'Impresora: '.$data['nombre_imp'], 0, 1, 'L');
$pdf->Ln(2);

// 🔹 Separador
$pdf->SetFont('Helvetica', '', 6);
$pdf->Cell(68, 0, str_repeat('_ ', 33), 0, 1, 'L');
$pdf->Ln(2);

// 🔹 Tipo de pedido (centrado)
$pdf->SetFont('Helvetica','B',12);
if($data['pedido_tipo'] == 1){
    $pdf->Cell(68, 5, 'ZONA MESA', 0, 1, 'C');
}elseif($data['pedido_tipo'] == 2){
    $pdf->Cell(68, 5, 'MOSTRADOR', 0, 1, 'C');
}elseif($data['pedido_tipo'] == 3){
    $pdf->Cell(68, 5, 'DELIVERY', 0, 1, 'C');
}

// 🔹 Comanda (centrada)
if($data['codigo_anulacion'] <> 1){
    $pdf->Ln(1);
    $pdf->SetFont('Helvetica','',11);
    $pdf->Cell(68, 5, 'Comanda #'.$data['correlativo_imp'], 0, 1, 'C');
    $pdf->Ln(1);
    $pdf->SetFont('Helvetica', '', 6);
    $pdf->Cell(68, 0, str_repeat('_ ', 33), 0, 1, 'L');
    $pdf->Ln(2);
}

// 🔹 Fecha y hora (izquierda)
$pdf->SetFont('Helvetica','',9);
$pdf->Cell(68, 5, $fecha." - ".$hora, 0, 1, 'L');
$pdf->Ln(1);

// 🔹 Datos del pedido
if($data['pedido_tipo'] == 1){
    $pdf->SetFont('Helvetica','',10);
    $pdf->Cell(68, 5, "Zona: ".$data['pedido_numero'], 0, 1, 'L');
    $pdf->Cell(68, 5, "".$data['pedido_cliente'], 0, 1, 'L');
    $pdf->Cell(68, 5, "Vendedor: ".$data['pedido_mozo'], 0, 1, 'L');
}elseif($data['pedido_tipo'] == 2){
    $pdf->SetFont('Helvetica','',10);
    $pdf->Cell(68, 5, "LLEVAR #".$data['pedido_numero'], 0, 1, 'L');
    $pdf->Cell(68, 5, "Cliente: ".$data['pedido_cliente'], 0, 1, 'L');
}elseif($data['pedido_tipo'] == 3){
    $pdf->SetFont('Helvetica','',10);
    $pdf->Cell(68, 5, "DELIVERY #".$data['pedido_numero'], 0, 1, 'L');
    $pdf->Cell(68, 5, "Cliente: ".$data['pedido_cliente'], 0, 1, 'L');
}

// 🔹 Línea final
$pdf->Ln(2);
$pdf->SetFont('Helvetica', '', 6);
$pdf->Cell(68, 0, str_repeat('_ ', 33), 0, 1, 'L');
$pdf->Ln(2);

// PRODUCTOS

foreach($data['items'] as $value){
    // Imprime el producto principal
    $pdf->SetFont('Helvetica', 'B', 11);
    $pdf->MultiCell(68, 6, utf8_decode($value['cantidad']) . ' ' . utf8_decode($value['producto']) . ' | ' . utf8_decode($value['presentacion']), 0, 'L');
    
    // Imprime el comentario del producto (si existe)
    if (!empty($value['comentario'])) {
				$pdf->Cell(0,4,'NOTAS:',0,1,'L');
        $pdf->SetFont('Helvetica', 'B', 11);
        $pdf->MultiCell(0, 4, utf8_decode($value['comentario']), 0, 'L');
    }

    // Imprime los toppings (si existen)
    if (!empty($value['toppings_descripcion'])) {
				$pdf->Cell(0,4,'TOPPINGS:',0,1,'L');
        $toppings = explode('=', $value['toppings_descripcion']); // Divide los toppings si están separados por "="
        $pdf->SetFont('Helvetica', '', 9);
        foreach ($toppings as $topping) {
            $pdf->MultiCell(68, 4, "- " . utf8_decode($topping), 0, 'L'); // Imprime cada topping con un guion
        }
    }

    $pdf->Ln(1); // Espaciado entre productos
}
$pdf->SetFont('Helvetica', '', 6);
$pdf->Cell(68, 0, '_ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _', '');
$pdf->Ln(2);
$pdf->Ln(4);
$pdf->SetFont('Helvetica', 'B', 12);
$pdf->Cell(68, 0, '* * * * * * * * * * * * * * * *', 0, 1, 'C');
$pdf->Ln(2);
// PIE DE PAGINA
$pdf->Ln(10);
$pdf->Output('ticket.pdf','i');

?>

