var moneda = $("#moneda").val();
$(function() {
    moment.locale('es');
    $('#caja').addClass("active");
    $('#c-mon').addClass("active");
    mesas_list();
    ventas_list(); //esto es para que las vesta se inicialicen priemro
    $('#start').bootstrapMaterialDatePicker({
        time: ($("#fecha_report").val() == '0')? false : true,
        format: ($("#fecha_report").val() == '0')? 'DD-MM-YYYY' : 'DD-MM-YYYY LT',
        shortTime: ($("#fecha_report").val() == '0')? false : true,
        lang: 'es-do',
        cancelText: 'Cancelar',
        okText: 'Aceptar'
    });

    $('#end').bootstrapMaterialDatePicker({
        time: ($("#fecha_report").val() == '0')? false : true,
        format: ($("#fecha_report").val() == '0')? 'DD-MM-YYYY' : 'DD-MM-YYYY LT',
        shortTime: ($("#fecha_report").val() == '0')? false : true,
        lang: 'es-do',
        cancelText: 'Cancelar',
        okText: 'Aceptar'
    });
    
    $('#start, #end, #tipo_ped, #tipo_doc').change( function() {
        ventas_list();
    });


    $('#form-editar-pago')
    .formValidation({
        framework: 'bootstrap',
        excluded: ':disabled',
        fields: {
        }
    })
    .on('success.form.fv', function(e) {

    e.preventDefault();
    var $form = $(e.target),
    fv = $form.data('formValidation');
    
    id_venta = $('#id_venta').val();
    pago_tipo = $("input[name='pago_tipo[]']").map(function(){return $(this).val();}).get();
    pago_monto = $("input[name='pago[]']").map(function(){return $(this).val();}).get();

    $.ajax({
        dataType: 'JSON',
        type: 'POST',
        url: $('#url').val()+'venta/venta_edit_pago',
        data: {
            id_venta: id_venta,
            pago_tipo: pago_tipo,
            pago_monto: pago_monto
        },
        success: function (cod) {
            $('#modal-editar-pago').modal('hide');
            Swal.fire({   
                title:'Proceso Terminado',   
                text: 'Datos actualizados correctamente',
                icon: "success", 
                confirmButtonColor: "#34d16e",   
                confirmButtonText: "Aceptar",
                allowOutsideClick: false,
                showCancelButton: false,
                showConfirmButton: true
            }, function() {
                return false
            });
            mesas_list();
            ventas_list();        
        },
        error: function(jqXHR, textStatus, errorThrown){
            console.log(errorThrown + ' ' + textStatus);
        }    
    });
        return false;
    });

    $('#form-editar-documento')
    .formValidation({
        framework: 'bootstrap',
        excluded: ':disabled',
        fields: {
        }
    })
    .on('success.form.fv', function(e) {

    e.preventDefault();
    var $form = $(e.target),
    fv = $form.data('formValidation');
    var current_invoices = parseInt($("#current_invoices").val());
    var limits_invoices  = parseInt($("#limits_invoices").val());

    if ( (current_invoices >= limits_invoices)  && $("input[name=tipo_doc]:checked").val() !== '3'  && $("#locked_invoices").val() == '1'   ){ 
        Swal.fire({   
            title:'Alcanzó el límite',   
            text: 'Alcanzó el límite permitido para la emisión de comprobantes',
            icon: "error", 
            confirmButtonColor: "#34d16e",   
            confirmButtonText: "Aceptar",
            allowOutsideClick: false,
            showCancelButton: false,
            showConfirmButton: true
        }, function() {
            return false
        });

    }else{
        if ($("#cliente_id").val() == ''){
            Swal.fire({   
                title:'Advertencia',   
                text: 'Ingrese un cliente para el comprobante de pago',
                icon: "warning", 
                confirmButtonColor: "#34d16e",   
                confirmButtonText: "Aceptar",
                allowOutsideClick: false,
                showCancelButton: false,
                showConfirmButton: true
            }, function() {
                return false
            });
        } else {
            id_venta = $('#id_venta').val();
            id_tipo_documento = $('input:radio[name="tipo_doc"]:checked').val();
            id_cliente = $('#cliente_id').val();

            $.ajax({
                dataType: 'JSON',
                type: 'POST',
                url: $('#url').val()+'venta/venta_edit_documento',
                data: {
                    id_venta: id_venta,
                    id_tipo_documento: id_tipo_documento,
                    id_cliente: id_cliente
                },
                success: function (cod) {
                    console.log(cod);
                    $('#modal-editar-documento').modal('hide');
                    Swal.fire({   
                        title:'Proceso Terminado',   
                        text: 'Datos actualizados correctamente',
                        icon: "success", 
                        confirmButtonColor: "#34d16e",   
                        confirmButtonText: "Aceptar",
                        allowOutsideClick: false,
                        showCancelButton: false,
                        showConfirmButton: true
                    }, function() {
                        return false
                    });
                    mesas_list();
                    ventas_list();       
                },
                error: function(jqXHR, textStatus, errorThrown){
                    console.log(errorThrown + ' ' + textStatus);
                }    
            });
        }
        return false;        
    }
    return false;



    });
    
    $("#buscar_cliente").autocomplete({
        delay: 1,
        autoFocus: true,
        source: function (request, response) {
            $.ajax({
                url: $('#url').val()+'venta/buscar_cliente',
                type: "post",
                dataType: "json",
                data: {
                    cadena: request.term,
                    tipo_cliente: $('#cliente_tipo').val()
                },
                success: function (data) {
                    response($.map(data, function (item) {
                        tipo_cli = (item.tipo_cliente == 1) ? $("#diAcr").val() : $("#tribAcr").val();
                        return {
                            id: item.id_cliente,
                            dni: item.dni,
                            ruc: item.ruc,
                            tipo: item.tipo_cliente,
                            nombres: item.nombre,
                            fecha_n: item.fecha_nac,
                            label: tipo_cli+': '+item.dni+''+item.ruc+' | '+item.nombre,
                            value: tipo_cli+': '+item.dni+''+item.ruc+' | '+item.nombre
                        }
                    }))
                }
            })
        },
        select: function (e, ui) {
            $("#cliente_id").val(ui.item.id);
            $(this).blur();
            $("#btn-submit-editar-documento").removeAttr('disabled');
            $("#btn-submit-editar-documento").removeClass('disabled');
            $('.opcion-cliente').html('<a class="input-group-prepend" href="javascript:void(0)"'
                +'onclick="editar_cliente('+ui.item.id+');" data-original-title="Editar cliente" data-toggle="tooltip"'
                +'data-placement="top">'
                    +'<span class="input-group-text bg-header">'
                        +'<small><i class="fas fa-user text-info"></i></small>'
                   +'</span>'
                +'</a>');
        }
    });
    $("#buscar_cliente").autocomplete("option", "appendTo", ".form-editar-documento");
});


var listar = function(){

    function filterGlobal () {
        $('#table').DataTable().search( 
            $('#global_filter').val()
        ).draw();
    }

    var table = $('#table')
    .DataTable({
        "destroy": true,
        "dom": "tip",
        "bSort": true,
        "ajax":{
            "method": "POST",
            "url": $('#url').val()+"caja/monitor_list"
        },
        "columns":[
	        {"data":"fecha_aper","render": function ( data, type, row ) {
	            return '<i class="ti-calendar"></i> '+moment(data).format('DD-MM-Y')
	            +'<br><span class="font-12"><i class="ti-time"></i> '+moment(data).format('h:mm A')+'</span>';
	        }},
	        {"data":null,"render": function ( data, type, row ) {
	            return '<h6><a href="javascript::void(0)" class="link" onclick="datalist('+data.id_apc+',\''+data.desc_per+'\');">'+data.desc_per+'</a></h6>';
	        }},
	        {"data": "desc_caja"},
	        {"data": "desc_turno"}
        ]
    });
    
    $('input.global_filter').on( 'keyup click', function () {
        filterGlobal();
    });
};

var datalist = function(id_apc,nombre_cajero){
    $('.display-one').css('display','none');
    $('.display-two').css('display','block');
    ventas_list(id_apc);
    mesas_list(id_apc);
    $('#id_apc').val(id_apc);
    $('.cajero-nombre').text(nombre_cajero);
}

var ventas_list = function(id_apc){
    var count = 1;
    ifecha = $("#start").val();
    ffecha = $("#end").val();
    tped = $("#tipo_ped").selectpicker('val');
    tdoc = $("#tipo_doc").selectpicker('val');
    activated_fechas = $("#activated_fechas").val();
    console.log(activated_fechas);

    var total_ope = 0,
    total_del = 0,
    total_tar = 0,
    total_total = 0,
    total_rc = 0,
    total_total2 = 0;


    $.ajax({
        type: "POST",
        url: $('#url').val()+"caja/monitor_ventas_list",
        data: {
            ifecha: ifecha,
            ffecha: ffecha,
            tped: tped,
            tdoc: tdoc,
            activated_fechas: activated_fechas            
        },
        dataType: "json",
        success: function(item){
            
            if (item.data.length != 0) {
                $.each(item.data, function(i, campo) {
                    total_ope++;
                    total_del  = total_del + parseFloat(campo.comis_del);
                    total_tar  = total_tar + parseFloat(campo.comis_tar2);
                    total_total  = total_total + parseFloat(campo.monto_total);
                    total_total2  = total_total2 + parseFloat(campo.monto_total2);
                    total_rc  = total_rc + parseFloat(campo.comis_rc);
                   
                });
            }
            $('.ventas-operaciones').text(total_ope);
            $('.ventas-comis_del').text((total_del).toFixed(2));
            $('.ventas-comis_tar').text((total_tar).toFixed(2));
            $('.ventas-total').text((total_total).toFixed(2));
            $('.ventas-total2').text((total_total2).toFixed(2));
            $('.ventas-rc').text((total_rc).toFixed(2));
        }
    });



    function filterGlobal () {
            $('#table-ventas').DataTable().search( 
                $('#global_filter').val()
            ).draw();
        }
    var table = $('#table-ventas')
    .DataTable({
        "destroy": true,
        "dom": "tp",
        "bSort": true,
        "order": [[0,"desc"]],
        "ajax":{
            "method": "POST",
            "url": $('#url').val()+"caja/monitor_ventas_list",
            "data": {
                ifecha: ifecha,
                ffecha: ffecha,
                tped: tped,
                tdoc: tdoc,
                activated_fechas: activated_fechas  
            }
        },
        "columns":[
        	{"data":"fec_ven","render": function ( data, type, row ) {
                return '<i class="ti-calendar"></i> '+moment(data).format('DD-MM-Y')
                +'<br><span class="font-12"><i class="ti-time"></i> '+moment(data).format('h:mm A')+'</span>';
            }},
            {"data":null,"render": function ( data, type, row ) {
                var tachado = (data.state_type_id == '11' || data.state_type_id == '09') ? 'line-through' : '';
                return '<div style="text-decoration: '+tachado+';">'+data.desc_td
                +'<br><span class="font-12">'+data.ser_doc+'-'+data.nro_doc+'</span></div>';
            }},
            {"data":"Cliente.nombre","render": function ( data, type, row ) {
                return '<div class="mayus">'+data+'</div>';
            }},
            {"data":null,"render": function ( data, type, row ) {
                if(data.id_tped == 1){
                    return 'SALON'
                    +'<br><span class="font-12">'+data.Pedido.desc_salon+' - Mesa: '+data.Pedido.nro_mesa+'</span>';
                } else if(data.id_tped == 2){
                   return 'MOSTRADOR';
                } else {
                    return 'DELIVERY';
                }
            }},
            {"data": null, "render": function(data, type, row){
                if(data.desc_tipo == 1){
                    var tooltip = "<span class='label label-success' style='background: #ff951b'>Cortesia</span>";
                } else if(data.desc_tipo == 3){
                    var tooltip = "<span class='label label-success' style='background: #a51bff'>Credito Personal</span>";
                } else {
                    var tooltip = '';
                }
                var blkstr = []; 
                $.each(data['Tipopago'], function(i,dato) { 
                    var str = "<span class='label label-success' style='background: "+dato.color+"'>" + dato.nombre + "</span>"; 
                    blkstr.push(str); 
                });
                return blkstr + tooltip;
            }},
            {"data":"comis_del","render": function ( data, type, row ) {
                return '<div class="text-right">'+formatNumber(data)+'</div>';
            }},
            {"data":"comis_tar2","render": function ( data, type, row ) {
                return '<div class="text-right">'+formatNumber(data)+'</div>';
            }},
            {"data":"comis_rc","render": function ( data, type, row ) {
                return '<div class="text-right">'+formatNumber(data)+'</div>';
            }},
            {"data":"monto_total","render": function ( data, type, row ) {
                return '<div class="text-right">'+formatNumber(data)+'</div>';
            }},
            {"data":"monto_total2","render": function ( data, type, row ) {
                return '<div class="text-right">'+formatNumber(data)+'</div>';
            }},           
            {"data":null,"render": function ( data, type, row ) {
                if(data.state_type_id == '11'){
                    return '<div class="text-right"><span class="label label-danger">ANULADO</span></div>';
                }else if(data.state_type_id == '09'){
                    return '<div class="text-right"><span class="label label-inverse">RECHAZADO</span></div>';
                }
                else{

                    if(data.id_tdoc == 3 && ($('#esta_sunat').val() == 'prod' || $('#esta_sunat').val() == 'beta' )){
                        var opcion1 = 'block';
                    } else {
                        var opcion1 = 'none'; 
                    }
                    var opanular = (data.id_tdoc == 3) ? 'block' : 'none';             

                    return '<div class="dropdown-action text-right"><div class="dropdown todo-action-dropdown">'
                            +'<a href="javascript::void(0)" class="btn btn-outline-primary dropdown-toggle text-decoration-none todo-action-dropdown custom-rounded" id="new" data-toggle="dropdown" aria-expanded="false"><i class="icon-options-vertical"></i></a>'
                                +'<div class="dropdown-menu dropdown-menu-right" aria-labelledby="more-action-3" style="">'
                                    +'<a class="dropdown-item" style="display: '+opcion1+'" href="javascript:void(0);" onclick="editar_documento('+data.id_ven+');"><i data-feather="file-text" class="feather-sm fill-white"></i> Editar tipo documento</a>'
                                    +'<a class="dropdown-item" href="javascript:void(0);" onclick="editar_pago('+data.id_ven+');"><i data-feather="dollar-sign" class="feather-sm fill-white"></i> Editar pago</a>'
                                    +'<a class="dropdown-item" href="'+$("#url").val()+'informe/venta_all_imp/'+data.id_ven+'" target="_blank"><i data-feather="printer" class="feather-sm fill-white"></i> Imprimir</a>'
                                    +'<div class="dropdown-divider" style="display: '+opanular+'"></div>'
                                    +'<a class="dropdown-item text-danger" style="display: '+opanular+'" href="javascript:void(0);" onclick="anular_venta('+data.id_ped+',\''+data.ser_doc+'-'+data.nro_doc+'\','+data.id_ven+');"><i data-feather="alert-circle" class="feather-sm fill-white"></i> Anular venta</a>'
                                +'</div>'
                            +'</div></div>';
                }
            }}
        ],
        "columnDefs": [
            {
                "targets": [ 5 ],
                "visible": false
            },
            {
                "targets": [ 6 ],
                "visible": false
            },
            {
                "targets": [ 7 ],
                "visible": false
            },
            {
                "targets": [ 8 ],
                "visible": false
            }
        ]
    });
    
    $('input.global_filter').on( 'keyup click', function () {
        filterGlobal();
    });
    $('.dataTables_wrapper').addClass('p-0');
    $('#table-ventas').DataTable().on("draw", function(){
        feather.replace();
    });
    $('a.toggle-vis').on( 'click', function (e) {
        e.preventDefault();
        // Get the column API object
        var column = table.column( $(this).attr('data-column') );
        // Toggle the visibility
        column.visible( ! column.visible() );
    } );

}

var mesas_list = function(id_apc){
    var count = 1;
    var table = $('#table-mesas')
    .DataTable({
        "destroy": true,
        "dom": "tp",
        "bSort": true,
        "ajax":{
            "method": "POST",
            "url": $('#url').val()+"caja/monitor_mesas_list"
        },
        "columns":[
            {"data":null,"render": function ( data, type, row ) {
                return count++;
            }},
            {"data":null,"render": function ( data, type, row ) {
                return data.desc_salon+' - Mesa: '+data.nro_mesa;
            }},
            {"data":"Total.total","render": function ( data, type, row ) {
                return '<div class="text-right">'+formatNumber(data)+'</div>';
            }}
        ],
        "footerCallback": function ( row, data, start, end, display ) {
            var api = this.api(), data;

            var intVal = function ( i ) {
                return typeof i === 'string' ?
                    i.replace(/[\$,]/g, '')*1 :
                    typeof i === 'number' ?
                        i : 0;
            };
 
            total = api
                .column( 2 /*, { search: 'applied', page: 'current'} */)
                .data()
                .reduce( function (a, b) {
                    return intVal(a) + intVal(b);
                }, 0 );

            operaciones = api
                .rows()
                .data()
                .count();

            $('.mesas-total').text(moneda+' '+formatNumber(total));
            $('.mesas-operaciones').text(operaciones);
        }
    });
    $('.dataTables_wrapper').addClass('p-0');
}

$('.list-mesas').click( function() {
    mesas_list($('#id_apc').val());
});

$('.list-ventas').click( function() {
    ventas_list($('#id_apc').val());
});

var editar_pago = function(id_venta){
    $('#modal-editar-pago').modal('show');
    $('[name="pago[]"]').val('');
    $.ajax({
      type: "post",
      dataType: "json",
      data: {
          id_venta: id_venta
      },
      url: $('#url').val()+'venta/venta_edit',
        success: function (item){
            $.each(item.data, function(i, campo) {
                $('.btn-pago').attr('disabled', true); 
                $('#id_venta').val(campo.id_venta);                             
                $('#pago'+campo.id_pago).val(campo.monto);
                $('.totalPedido').text(formatNumber(parseFloat(campo.total) + parseFloat(campo.comision_delivery)));
                $('.totalPedido').val(parseFloat(campo.total) + parseFloat(campo.comision_delivery));
                $('.totalPedidoDelivery').text(formatNumber(campo.comision_delivery));
                console.log(parseFloat(campo.total, 2));
            });
            sumar_pagos();
        }
    });
}

var editar_documento = function(id_venta){
    $('.id_venta').val(id_venta);
    $('#cliente_id').val(1);
    $('#cliente_tipo').val(1);
    $('#modal-editar-documento').modal('show');
    $('.btn-tipo-doc-1').addClass('active');
    $('.btn-tipo-doc-2').removeClass('active');
    $("input[name=tipo_doc][value='1']").attr("checked",true);
    $('.opcion-cliente').html('<a class="input-group-prepend" href="javascript:void(0)"'
        +'onclick="nuevoCliente();" data-original-title="Registrar nuevo cliente" data-toggle="tooltip"'
        +'data-placement="top">'
            +'<span class="input-group-text bg-header">'
                +'<small><i class="fas fa-user-plus"></i></small>'
           +'</span>'
        +'</a>');
}

var anular_venta = function(id_pedido,nro_pedido,id_venta){
    var html_confirm = '<div>Se procederá a anular la siguiente venta:</div>\
    <div class="font-18 font-bold">Nota de Venta N°'+nro_pedido+'</div><br>\
    Ingrese código de seguridad</div><br>\
    <form>\
    <input class="form-control text-center" type="password" id="codigo_anular_venta_" autocomplete="off"/>\
    <div class="text-left">\
    <label class="m-t-10">Motivo</label>\
    <textarea id="motivo" class="form-control" rows="2" required="required"></textarea>\
    </div>\
    </form><br>\
    <div><span class="text-success" style="font-size: 17px;">¿Está Usted de Acuerdo?</span></div>';
    // disable = true;
    Swal.fire({
        // customClass: {
        //     confirmButton: 'c-disabled',
        // },
        title: 'Necesitamos de tu Confirmación',
        html: html_confirm,
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#34d16e',
        confirmButtonText: 'Si, Adelante!',
        cancelButtonText: "No!",
        showLoaderOnConfirm: true,
        preConfirm: function() {
            return new Promise(function(resolve) {
                if($('#codigo_anular_venta').val() == $('#codigo_anular_venta_').val()){
                    $.ajax({
                        url: $('#url').val()+'venta/anular_venta',
                        type: 'POST',
                        data: {
                            id_venta : id_venta,
                            id_pedido : id_pedido,
                            motivo : $('#motivo').val()
                        },
                        dataType: 'json'
                    })
                    .done(function(response){
                        Swal.fire({   
                            title:'Proceso Terminado',   
                            text: 'Datos actualizados correctamente',
                            icon: "success", 
                            confirmButtonColor: "#34d16e",   
                            confirmButtonText: "Aceptar",
                            allowOutsideClick: false,
                            showCancelButton: false,
                            showConfirmButton: true
                        }, function() {
                            return false
                        });
                        ventas_list();
                    })
                    .fail(function(){
                        Swal.fire('Oops...', 'Problemas con la conexión a internet!', 'error');
                    });
                } else {
                    Swal.fire({
                        title: 'Proceso No Culminado',
                        text: 'El código ingresado es incorrecto',
                        icon: 'error',
                        confirmButtonColor: '#34d16e',
                        confirmButtonText: "Aceptar"
                    });
                }
            });
        }            
    });
    // $('.c-disabled').attr('disabled', disable);
    // $('#codigo_anular_venta').on('keyup click', function () {
    //     console.log('dsdfdsfjo');
    //     disableboton();
    // });    
}

var disableboton = function(){
    if ($("#codigo_anular_venta").val() == $('#codigo_seguridad_').val() || $("#codigo_anular_venta").val() == $('#codigo_seguridad').val()) {
        $("#password_respuesta").text('Contraseña Correcta');
        $("#password_respuesta").addClass('text-success');
        $("#password_respuesta").removeClass('text-danger');
        $('.c-disabled').attr('disabled', false);  
    }else{
        $("#password_respuesta").addClass('text-danger');
        $("#password_respuesta").removeClass('text-success');
        $("#password_respuesta").text('Contraseña Incorrecta');
        $('.c-disabled').attr('disabled', true);
    }
}

$('#modal-editar-documento').on('hidden.bs.modal', function() {
    $(this).find('#form-editar-documento')[0].reset();
    $('#form-editar-documento').formValidation('resetForm', true);
});

$('input[name="tipo_doc"]').on('change', function(){
    value = $('input:radio[name="tipo_doc"]:checked').val();
    $('#cliente_tipo').val(value);
    $('#tipo_cliente').val(value);
    $('#id_cliente').val('');
    if(value == 3){
        //$('#cliente_id').val(1);
        //$('#buscar_cliente').val('PUBLICO EN GENERAL');
    }else{
        $('#cliente_id').val('');
        $('#buscar_cliente').val('');
    }
    $('.opcion-cliente').html('<a class="input-group-prepend" href="javascript:void(0)"'
        +'onclick="nuevoCliente();" data-original-title="Registrar nuevo cliente" data-toggle="tooltip"'
        +'data-placement="top">'
            +'<span class="input-group-text bg-header">'
                +'<small><i class="fas fa-user-plus"></i></small>'
           +'</span>'
        +'</a>');
});


var sumar_pagos = function(){
    var totalInp = $('[name="pago[]"]'); 
    var total = 0;

    totalInp.each(function(){
        var valor = $(this).val();
        if(valor == ""){ valor = 0;};
        total += parseFloat(valor);
    });
    var font = 'font-18';
    if($('.totalPedido').val() == total){
        $('.mensajePago').html('<span class="text-success '+font+' animated fadeIn">¡Pago Completo!</span>');
        $('.btn-pago').attr('disabled', false);
    } else if(total < $('.totalPedido').val()){
        $('.mensajePago').html('<span class="text-danger '+font+' animated fadeIn">¡Pago Incompleto!</span>');
        $('.btn-pago').attr('disabled', true);
    } else if(total > $('.totalPedido').val()){

        
        $('.mensajePago').html('<span class="text-danger '+font+' animated fadeIn">¡El monto es mayor!</span>');
        $('.btn-pago').attr('disabled', true);
    }
}