$(function() {
    var table;
    
    // Inicializar DataTable
    table = $('#table-series').DataTable({
        "language": {
            "url": "//cdn.datatables.net/plug-ins/1.10.24/i18n/Spanish.json"
        },
        "ajax": {
            "url": $('#url').val() + "ajuste/series_documentos_list",
            "type": "POST"
        },
        "columns": [
            { "data": "tipo_documento" },
            { "data": "serie" },
            { "data": "pos" },
            { 
                "data": "numero_inicial",
                "render": function(data) {
                    return formatNumber(data);
                }
            },
            { 
                "data": "numero_actual",
                "render": function(data) {
                    return formatNumber(data);
                }
            },
            { 
                "data": "numero_final",
                "render": function(data) {
                    return formatNumber(data);
                }
            },
            { 
                "data": "ambiente",
                "render": function(data) {
                    return data == '1' ? '<span class="label label-success">Producción</span>' : '<span class="label label-info">Pruebas</span>';
                }
            },
            { 
                "data": "activo",
                "render": function(data) {
                    return data == '1' ? '<span class="label label-success">Activo</span>' : '<span class="label label-danger">Inactivo</span>';
                }
            },
            {
                "data": null,
                "render": function(data, type, row) {
                    return '<button class="btn btn-sm btn-primary btn-editar" data-id="' + row.id_serie + '"><i class="ti-pencil"></i></button> ' +
                           '<button class="btn btn-sm btn-danger btn-eliminar" data-id="' + row.id_serie + '"><i class="ti-trash"></i></button>';
                },
                "orderable": false
            }
        ],
        "order": [[0, "asc"]]
    });

    // Formatear número con ceros a la izquierda (10 dígitos)
    function formatNumber(num) {
        return String(num).padStart(10, '0');
    }

    // Validar POS (3 dígitos)
    $('#pos').on('input', function() {
        var value = $(this).val().replace(/\D/g, '');
        if (value.length > 3) {
            value = value.substring(0, 3);
        }
        $(this).val(value.padStart(3, '0'));
    });

    // Manejar checkbox activo
    $('#activo').on('change', function() {
        $('#activo_hidden').val($(this).prop('checked') ? '1' : '0');
    });

    // Botón nueva serie
    $('#btn-nueva-serie').on('click', function() {
        resetForm();
        $('#modal-serie-label').text('Nueva Serie de Documento');
        $('#modal-serie').modal('show');
    });

    // Editar serie
    $(document).on('click', '.btn-editar', function() {
        var id = $(this).data('id');
        $.ajax({
            url: $('#url').val() + 'ajuste/series_documentos_data',
            type: 'POST',
            data: { id_serie: id },
            dataType: 'json',
            success: function(response) {
                if (response.success) {
                    var data = response.data;
                    $('#id_serie').val(data.id_serie);
                    $('#tipo_documento').val(data.tipo_documento);
                    $('#serie').val(data.serie);
                    $('#pos').val(data.pos);
                    $('#numero_inicial').val(data.numero_inicial);
                    $('#numero_actual').val(data.numero_actual);
                    $('#numero_final').val(data.numero_final);
                    $('#ambiente').val(data.ambiente);
                    $('#activo').prop('checked', data.activo == '1');
                    $('#activo_hidden').val(data.activo);
                    $('#modal-serie-label').text('Editar Serie de Documento');
                    $('#modal-serie').modal('show');
                } else {
                    swal('Error', response.message || 'No se pudo cargar la información', 'error');
                }
            }
        });
    });

    // Eliminar serie
    $(document).on('click', '.btn-eliminar', function() {
        var id = $(this).data('id');
        swal({
            title: "¿Está seguro?",
            text: "Esta acción no se puede deshacer",
            type: "warning",
            showCancelButton: true,
            confirmButtonColor: "#DD6B55",
            confirmButtonText: "Sí, eliminar",
            cancelButtonText: "Cancelar",
            closeOnConfirm: false
        }, function() {
            $.ajax({
                url: $('#url').val() + 'ajuste/series_documentos_delete',
                type: 'POST',
                data: { id_serie: id },
                dataType: 'json',
                success: function(response) {
                    if (response.success) {
                        swal("Eliminado", "La serie ha sido eliminada", "success");
                        table.ajax.reload();
                    } else {
                        swal("Error", response.message || "No se pudo eliminar la serie", "error");
                    }
                }
            });
        });
    });

    // Guardar serie
    $('#form-serie').on('submit', function(e) {
        e.preventDefault();
        
        // Validar POS
        var pos = $('#pos').val();
        if (pos.length != 3 || !/^\d{3}$/.test(pos)) {
            swal('Error', 'El POS debe ser exactamente 3 dígitos numéricos (000-999)', 'error');
            return;
        }

        // Validar números
        var numInicial = parseInt($('#numero_inicial').val());
        var numActual = parseInt($('#numero_actual').val());
        var numFinal = parseInt($('#numero_final').val());

        if (numInicial < 1 || numInicial > 9999999999) {
            swal('Error', 'El número inicial debe estar entre 1 y 9999999999', 'error');
            return;
        }

        if (numActual < numInicial) {
            swal('Error', 'El número actual no puede ser menor al número inicial', 'error');
            return;
        }

        if (numFinal < numActual) {
            swal('Error', 'El número final no puede ser menor al número actual', 'error');
            return;
        }

        var formData = new FormData($(this)[0]);
        
        $.ajax({
            url: $('#url').val() + 'ajuste/series_documentos_crud',
            type: 'POST',
            data: formData,
            dataType: 'json',
            contentType: false,
            processData: false,
            success: function(response) {
                if (response.success) {
                    swal("Éxito", response.message || "Serie guardada correctamente", "success");
                    $('#modal-serie').modal('hide');
                    table.ajax.reload();
                    resetForm();
                } else {
                    swal("Error", response.message || "No se pudo guardar la serie", "error");
                }
            },
            error: function() {
                swal("Error", "Problemas con la conexión", "error");
            }
        });
    });

    function resetForm() {
        $('#form-serie')[0].reset();
        $('#id_serie').val('');
        $('#activo').prop('checked', true);
        $('#activo_hidden').val('1');
        $('#numero_inicial').val('1');
        $('#numero_actual').val('1');
        $('#numero_final').val('9999999999');
        $('#pos').val('001');
        $('#ambiente').val('2');
    }
});

