$(function() {
    $('#config').addClass("active");
    DatosGrles();
    comboAreaProd();
    // initUsuMesasSection(); // OCULTA TEMPORALMENTE - Sección Áreas y mesas

    if($('#hidden_perm_edit_price').val() == '1'){$('#perm_edit_price').prop('checked', true);}
    if($('#hidden_anular_ped_preparado').val() == '1'){$('#anular_ped_preparado').prop('checked', true);}
    if($('#hidden_sonido_llevar').val() == '1'){$('#sonido_llevar').prop('checked', true);}; 
    if($('#hidden_active_prod').val() == '1'){$('#active_prod').prop('checked', true);};
    if($('#hidden_active_inventario').val() == '1'){$('#active_inventario').prop('checked', true);};
    if($('#hidden_active_ent_sal').val() == '1'){$('#active_ent_sal').prop('checked', true);};
    if($('#hidden_activated_clave_desc').val() == '1'){$('#activated_clave_desc').prop('checked', true);};
    if($('#hidden_activated_informes').val() == '1'){$('#activated_informes').prop('checked', true);};
    if($('#hidden_activated_fechas').val() == '1'){$('#activated_fechas').prop('checked', true);};
    if($('#hidden_activate_contable').val() == '1'){$('#activate_contable').prop('checked', true);};
    if($('#horario').val() == '1'){$('#horario_s').prop('checked', true);};
    
    
    $('#start').bootstrapMaterialDatePicker({
        format: 'LT',
        date: false,
        lang: 'es-do',
        cancelText: 'Cancelar',
        okText: 'Aceptar'
    });

    $('#end').bootstrapMaterialDatePicker({
        format: 'LT',
        date: false,
        lang: 'es-do',
        cancelText: 'Cancelar',
        okText: 'Aceptar'
    });
    $('#horario').val('0');

    $('#form').formValidation({
        framework: 'bootstrap',
        excluded: ':disabled',
        fields: {
            dni: {
                validators: {
                    stringLength: {
                        message: 'El '+$(".c-dni").text()+' debe tener '+$("#dni").attr("maxlength")+' digitos'
                    }
                }
            }
        }
    }).on('success.form.fv', function(e) {
        // Prevent form submission
        e.preventDefault();
        var $form = $(e.target),
        fv = $form.data('formValidation');
        var form = $(this);

        var parametros = new FormData($('#form')[0]);

        $.ajax({
            type: 'POST',
            dataType: 'JSON',
            data: parametros,
            url: $('#url').val()+'ajuste/usuario_crud',
            contentType: false,
            processData: false,
        })
        .done(function(response){
        console.log("Respuesta del servidor:", response);
            if(response == 1 || response == 2){
                if(response==1){
                    var text = 'registrados';
                } else if(response == 2){
                    var text = 'actualizados';
                }
                var html_terminado = '<div>Datos '+text+' correctamente</div>\
                    <br><a href="'+$("#url").val()+'ajuste/usuario" class="btn btn-success">Aceptar</button>'
                Swal.fire({
                    title: 'Proceso Terminado',
                    html: html_terminado,
                    icon: 'success',
                    showConfirmButton: false
                });
            } else{
                Swal.fire({
                    title: 'Proceso No Culminado',
                    html: 'Datos duplicados',
                    icon: 'error',
                    showConfirmButton: true
                });
            }
        })
        .fail(function(){
            Swal.fire('Oops...', 'Problemas con la conexión a internet!', 'error');
        });
    });
});

var DatosGrles = function(){
    $('#id_rol').selectpicker('refresh');
    $('#id_rol').selectpicker('val', $('#cod_rol').val());
    $('#id_areap').selectpicker('refresh');
    $('#id_areap').selectpicker('val', $('#cod_area').val());
}

/* Combo area de produccion */
var comboAreaProd = function(){
    if($("#id_rol").selectpicker('val') == 4){
        $('#col-areap').css('display','block');
        $("#id_areap").prop('disabled', false);
    }else{
        $('#col-areap').css('display','none');
        $("#id_areap").prop('disabled', true);
    }

    if($("#id_rol").selectpicker('val') == 3 || $("#id_rol").selectpicker('val') == 2){
        $('#anular_ped').css('display','block');
        $('#prod_active').css('display','block');
        $('.ajus_cajero').css('display','block'); 
        // $("#id_areap").prop('disabled', false);
    }else{
        $('#anular_ped').css('display','none');
        $('#prod_active').css('display','none');
        $('.ajus_cajero').css('display','none'); 
        // $("#id_areap").prop('disabled', true);
    }

}

/* Combinacion del combo rol - area produccion */
$('#id_rol').change( function() {
    if($("#id_rol").selectpicker('val') == 4){
        $('#col-areap').css('display','block');
        $("#id_areap").prop('disabled', false);
        $('#form').formValidation('revalidateField', 'id_areap');
    }else{
        $('#col-areap').css('display','none');
        $("#id_areap").val('').selectpicker('refresh');
        $("#id_areap").prop('disabled', true);
    }

    if($("#id_rol").selectpicker('val') == 3 || $("#id_rol").selectpicker('val') == 5){
        $('#anular_ped').css('display','block'); 
        $('#prod_active').css('display','block'); 
        $('.ajus_cajero').css('display','block');        
        $('#horario_s').css('display','block');
    }else{
        $('#anular_ped').css('display','none');
        $('#hidden_anular_ped_preparado').val(0);

        $('#prod_active').css('display','none'); 
        $('.ajus_cajero').css('display','none');       
        $('#hidden_active_prod').val(0);
        $('#hidden_active_inventario').val(0);
        $('#hidden_active_ent_sal').val(0);
        $('#hidden_activated_clave_desc').val(0);
        $('#hidden_activated_informes').val(0);
        $('#hidden_activate_contable').val(0);
        $('#hidden_activated_fechas').val(0);
        $('#horario_s').css('display','none');
    }
});

$("#dni").keyup(function(event) {
    var that = this,
    value = $(this).val();
    if (value.length == $("#dni").attr("maxlength")) {
        $.getJSON($('#url').val()+"api/dni/"+$("#dni").val(), {
            format: "json"
        })
        .done(function(data) {
            $("#dni").val(data.dni);
            $("#nombres").val(data.nombres);
            $("#ape_paterno").val(data.apellidoPaterno);
            $("#ape_materno").val(data.apellidoMaterno);
            $('#form').formValidation('revalidateField', 'nombres');
            $('#form').formValidation('revalidateField', 'ape_paterno');
            $('#form').formValidation('revalidateField', 'ape_materno');
        });
    } else if($("#dni").val() == "") {
        $('#dni').val("");
        $('#nombres').val("");
        $('#ape_paterno').val("");
        $('#ape_materno').val("");
        $('#form').formValidation('resetForm', true);
    }
});

$('#perm_edit_price').on('click', function(event){
    if($('#perm_edit_price').is(':checked')){
        $('#hidden_perm_edit_price').val(1);
    }else{
        $('#hidden_perm_edit_price').val(0);
    }
});

$('#anular_ped_preparado').on('click', function(event){
    if($('#anular_ped_preparado').is(':checked')){
        $('#hidden_anular_ped_preparado').val(1);
    }else{
        $('#hidden_anular_ped_preparado').val(0);
    }
});

$('#sonido_llevar').on('click', function(event){
    if($('#sonido_llevar').is(':checked')){
        $('#hidden_sonido_llevar').val(1);
    }else{
        $('#hidden_sonido_llevar').val(0);
    }
});

$('#active_prod').on('click', function(event){
    if($('#active_prod').is(':checked')){
        $('#hidden_active_prod').val(1);
    }else{
        $('#hidden_active_prod').val(0);
    }
});

$('#active_inventario').on('click', function(event){
    if($('#active_inventario').is(':checked')){
        $('#hidden_active_inventario').val(1);
    }else{
        $('#hidden_active_inventario').val(0);
    }
});

$('#active_ent_sal').on('click', function(event){
    if($('#active_ent_sal').is(':checked')){
        $('#hidden_active_ent_sal').val(1);
    }else{
        $('#hidden_active_ent_sal').val(0);
    }
});

$('#activated_clave_desc').on('click', function(event){
    if($('#activated_clave_desc').is(':checked')){
        $('#hidden_activated_clave_desc').val(1);
    }else{
        $('#hidden_activated_clave_desc').val(0);
    }
});

$('#activated_informes').on('click', function(event){
    if($('#activated_informes').is(':checked')){
        $('#hidden_activated_informes').val(1);
    }else{
        $('#hidden_activated_informes').val(0);
    }
});

$('#activated_fechas').on('click', function(event){
    if($('#activated_fechas').is(':checked')){
        $('#hidden_activated_fechas').val(1);
    }else{
        $('#hidden_activated_fechas').val(0);
    }
});

$('#activate_contable').on('click', function(event){
    if($('#activate_contable').is(':checked')){
        $('#hidden_activate_contable').val(1);
    }else{
        $('#hidden_activate_contable').val(0);
    }
});

$('.horario').on('click', function(event){
    if( $(this).is(':checked') ) {
        $('#horario').val('1');
        $('.display_horario').css('display','block');
        $("#start").prop('disabled', false);
        $("#end").prop('disabled', false);
    } else {
        $('#horario').val('0');
        $('.display_horario').css('display','none');
        $("#start").prop('disabled', true);
        $("#end").prop('disabled', true);
    }
});

const togglePasswordUser = document.querySelector('#togglePasswordUser');
const contrasena = document.querySelector('#contrasena');
togglePasswordUser.addEventListener('click', function() {
    const type = contrasena.getAttribute('type') === 'password' ? 'text' : 'password';
    contrasena.setAttribute('type', type);
    if (type === 'password') {
        this.classList.remove('fa-eye');
        this.classList.add('fa-eye-slash');
    } else {
        this.classList.remove('fa-eye-slash');
        this.classList.add('fa-eye');
    }
});

/* ========== Áreas y Mesas (pestañas + cards con selección) ========== */
var usuMesasSelected = {}; // { id_mesa: true, ... }

function getBaseUrl() {
    var base = ($('#url').val() || '').trim();
    if (base && base.charAt(base.length - 1) !== '/') base += '/';
    if (base) return base;
    // Fallback: si no hay #url, derivar desde la ruta actual (ej: /xampp7433/htdocs/ajuste/... -> /xampp7433/htdocs/)
    var path = window.location.pathname || '';
    var match = path.match(/^(.*\/)ajuste\/?/);
    if (match) return window.location.origin + match[1];
    return '/';
}

function initUsuMesasSection() {
    var $tabs = $('#usu-mesas-tabs');
    var $content = $('#usu-mesas-content');
    var $placeholder = $('#usu-mesas-placeholder');
    var urlSalon = getBaseUrl() + 'ajuste/salon_list';

    $.ajax({
        url: urlSalon,
        type: 'POST',
        dataType: 'json',
        timeout: 15000
    }).done(function(res) {
        var salones = (res && res.data) ? res.data : [];
        var salonesActivos = salones.filter(function(s) { return s.estado === 'a'; });
        if (salonesActivos.length === 0) {
            $placeholder.html('<p class="text-muted mb-0">No hay áreas configuradas.</p>').show();
            return;
        }
        $placeholder.hide();
        $tabs.empty();
        $content.empty();
        salonesActivos.forEach(function(s, i) {
            var tabId = 'tab-salon-' + s.id_salon;
            var active = i === 0 ? ' active' : '';
            $tabs.append(
                '<li class="nav-item">' +
                '<a class="nav-link' + active + '" data-id_salon="' + s.id_salon + '" data-toggle="tab" href="#' + tabId + '" role="tab">' +
                (s.descripcion || 'Área ' + s.id_salon) +
                '</a></li>'
            );
            var paneActive = i === 0 ? ' active' : '';
            $content.append('<div class="tab-pane usu-mesas-pane' + paneActive + '" id="' + tabId + '" role="tabpanel"><div class="usu-mesas-cards-wrap"></div></div>');
        });
        $tabs.find('.nav-link').on('show.bs.tab', function() {
            var idSalon = $(this).data('id_salon');
            var $wrap = $('#tab-salon-' + idSalon + ' .usu-mesas-cards-wrap');
            if ($wrap.length && !$wrap.data('loaded')) loadMesasBySalon(idSalon, $wrap);
        });
        var firstId = salonesActivos[0].id_salon;
        loadMesasBySalon(firstId, $('#tab-salon-' + firstId + ' .usu-mesas-cards-wrap'));
    }).fail(function(jqXHR, textStatus, errorThrown) {
        var msg = 'Error al cargar áreas.';
        if (jqXHR.status === 404) msg = 'URL no encontrada. Compruebe que la ruta ajuste/salon_list exista.';
        else if (jqXHR.status) msg += ' (HTTP ' + jqXHR.status + ')';
        if (textStatus === 'parsererror') msg += ' La respuesta no es JSON válido.';
        $placeholder.html('<p class="text-danger mb-0">' + msg + '</p>').show();
        if (typeof console !== 'undefined' && console.error) {
            console.error('salon_list error', jqXHR.status, jqXHR.responseText, textStatus, errorThrown);
        }
    });
}

function loadMesasBySalon(idSalon, $container) {
    $container.html('<div class="text-center py-4"><i class="fa fa-spinner fa-spin"></i> Cargando mesas...</div>');
    $.ajax({
        url: getBaseUrl() + 'ajuste/mesa_list',
        type: 'POST',
        data: { id_salon: idSalon },
        dataType: 'json',
        timeout: 10000
    }).done(function(res) {
        var mesas = (res && res.data) ? res.data : [];
        $container.data('loaded', true);
        renderMesasCards($container, mesas);
    }).fail(function(jqXHR) {
        var msg = jqXHR.status === 404 ? 'Ruta no encontrada.' : 'Error al cargar mesas.';
        if (jqXHR.status) msg += ' (HTTP ' + jqXHR.status + ')';
        $container.html('<p class="text-danger">' + msg + '</p>');
    });
}

function renderMesasCards($container, mesas) {
    var html = '<div class="row">';
    mesas.forEach(function(m) {
        var isSelected = !!usuMesasSelected[m.id_mesa];
        var cardClass = 'card usu-mesa-card m-1 shadow-sm';
        if (isSelected) cardClass += ' border-success border-2';
        html += '<div class="col-4 col-sm-3 col-md-2 col-lg-2 p-1">' +
            '<div class="' + cardClass + '" data-id_mesa="' + m.id_mesa + '" style="cursor:pointer;min-height:48px;transition:all .2s ease;">' +
            '<div class="card-body usu-mesa-card-body d-flex align-items-center justify-content-center py-1 px-2">' +
            '<span class="font-weight-bold small">' + (m.nro_mesa || 'Mesa ' + m.id_mesa) + '</span>' +
            (isSelected ? ' <i class="fas fa-check-circle text-success ml-1" style="font-size:0.7rem;"></i>' : '') +
            '</div></div></div>';
    });
    html += '</div>';
    $container.html(html);
    $container.find('.usu-mesa-card').on('click', function() {
        var $card = $(this);
        var idMesa = $card.data('id_mesa');
        usuMesasSelected[idMesa] = !usuMesasSelected[idMesa];
        $card.toggleClass('border-success border-2', !!usuMesasSelected[idMesa]);
        if (usuMesasSelected[idMesa]) {
            $card.find('.card-body').append(' <i class="fas fa-check-circle text-success ml-1" style="font-size:0.7rem;"></i>');
        } else {
            $card.find('.fa-check-circle').remove();
        }
        updateMesasAsignadasInput();
    });
}

function updateMesasAsignadasInput() {
    var ids = Object.keys(usuMesasSelected).filter(function(id) { return usuMesasSelected[id]; });
    $('#mesas_asignadas_ids').val(ids.join(','));
}