<input type="hidden" id="url" value="<?php echo URL; ?>"/>
<div class="row page-titles">
    <div class="col-md-5 col-8 align-self-center">
        <h4 class="m-b-0 m-t-0">Ajustes</h4>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="<?php echo URL; ?>ajuste" class="link">Inicio</a></li>
            <li class="breadcrumb-item"><a href="<?php echo URL; ?>ajuste" class="link">Empresa</a></li>
            <li class="breadcrumb-item active">Datos de la Empresa</li>
        </ol>
    </div>
</div>

<form id="form" method="post" enctype="multipart/form-data">
<input type="hidden" name="usuid" id="usuid" value="<?php echo Session::get('usuid'); ?>"/>
<div class="row">
    <div class="col-md-9">
        <div class="card">
            <div class="card-body">
                <h4 class="card-title">Datos generales</h4>
                <h6 class="card-subtitle">Informaci&oacute;n de tu empresa</h6>
                <div class="row floating-labels m-t-40">
                    <div class="col-md-8">
                        <div class="form-group m-b-40">
                            <input type="text" name="nombre_comercial" id="nombre_comercial" class="form-control input-mayus" autocomplete="off">
                            <span class="bar"></span>
                            <label for="nomb_com">Nombre comercial</label>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group m-b-40">
                            <input type="text" name="celular" id="celular" class="form-control" autocomplete="off">
                            <span class="bar"></span>
                            <label for="celular">Tel&eacute;fono</label>
                        </div>
                    </div>
                    <div class="col-md-12">
                        <div class="form-group m-b-40">
                            <input type="text" name="direccion_comercial" id="direccion_comercial" class="form-control input-mayus" autocomplete="off" required>
                            <span class="bar"></span>
                            <label for="direccion_comercial">Direcci&oacute;n comercial</label>
                        </div>
                    </div>                 
                </div>
                <div class="row">
                    <div class="col-8">
                        <ul class="list-group list-group-flush" style="font-size: 13px;">
                            <li class="list-group-item py-1">                 
                                <div class="form-check form-check-inline">
                                    <input type="hidden" name="hidden_pdf_logo" id="hidden_pdf_logo"/>
                                    <input class="chk-col-green" type="checkbox" name="pdf_logo" id="pdf_logo">
                                    <label class="m-0" for="pdf_logo">Logo</label>
                                </div>  
                            </li>
                            <li class="list-group-item py-1">
                                <div class="form-check form-check-inline">
                                    <input type="hidden" name="hidden_pdf_rz" id="hidden_pdf_rz"/>
                                    <input type="checkbox" name="pdf_rz" id="pdf_rz" class="chk-col-green"/>
                                    <label class="m-0" for="pdf_rz">Razón Social</label>
                                </div>  
                            </li>
                            <li class="list-group-item py-1">
                                <div class="form-check form-check-inline">
                                    <input type="hidden" name="hidden_pdf_nc" id="hidden_pdf_nc"/>
                                    <input class="chk-col-green" type="checkbox" name="pdf_nc" id="pdf_nc">
                                    <label class="m-0" for="pdf_nc">Nombre Comercial</label>
                                </div>  
                            </li>
                            <li class="list-group-item py-1">
                                <div class="form-check form-check-inline">
                                    <input type="hidden" name="hidden_pdf_dc" id="hidden_pdf_dc"/>
                                    <input class="chk-col-green" type="checkbox" name="pdf_dc" id="pdf_dc">
                                    <label class="m-0" for="pdf_dc">direccion Comercial</label>
                                </div>  
                            </li>
                            <li class="list-group-item py-1">
                                <div class="form-check form-check-inline">
                                    <input type="hidden" name="hidden_pdf_ruc" id="hidden_pdf_ruc"/>
                                    <input class="chk-col-green" type="checkbox" name="pdf_ruc" id="pdf_ruc">
                                    <label class="m-0" for="pdf_ruc">RUC</label>
                                </div>  
                            </li>
                            <li class="list-group-item py-1">
                                <div class="form-check form-check-inline">
                                    <input type="hidden" name="hidden_pdf_tel" id="hidden_pdf_tel"/>
                                    <input class="chk-col-green" type="checkbox" name="pdf_tel" id="pdf_tel">
                                    <label class="m-0" for="pdf_tel">Telefono</label>
                                </div>  
                            </li>
                        </ul>

                    </div>   
                    <div class="col-md-4">
                        <ul class="list-group border rounded text-center" style="font-size: 13.5px;">
                            <li class="list-group-item border-0 py-2">logo</li>
                            <li class="list-group-item border-0 py-2 font-weight-bold"><?php print(($this->datosempresa->razon_social == '')? 'Sin Razon Social' : $this->datosempresa->razon_social); ?></li>
                            <li class="list-group-item border-0 py-2 font-weight-bold"><?php print(($this->datosempresa->nombre_comercial == '')? 'Sin Nombre Comercial' : $this->datosempresa->nombre_comercial); ?></li>
                            <li class="list-group-item border-0 py-2"><?php print(($this->datosempresa->direccion_comercial == '')? 'Sin Direccion Comercial' : $this->datosempresa->direccion_comercial); ?></li>
                            <li class="list-group-item border-0 py-2"><?php print(($this->datosempresa->ruc == '')? 'Sin RUC' : $this->datosempresa->ruc); ?></li>
                            <li class="list-group-item border-0 py-2"><?php print(($this->datosempresa->celular == '')? 'Sin Telefono' : $this->datosempresa->celular); ?></li>
                        </ul>
                    </div>                    
                </div>
            </div>
            <div class="card-body sunat b-t">
                <div class="m-t-20">
                    <h4 class="card-title">Facturaci&oacute;n electr&oacute;nica (Panam&aacute;)</h4>
                    <h6 class="card-subtitle">Informaci&oacute;n DGI</h6>
                    <div class="row">
                        <div class="col-md-4 text-center">
                        <a href="javascript:void(0)" class="text-danger delete ms-2" onclick="anularlogo();"><i data-feather="trash-2" class="feather-sm fill-white"></i></a>
                            <div class="ct-wizard-azzure" id="wizardProfile">
                                <div class="picture-container">
                                    <div class="picture" style="width: 150px; height:150px">
                                        <img src="<?php echo URL; ?>public/images/productos/default.png" class="picture-src" id="wizardPicturePreview-2"/>
                                        <input type="hidden" name="imagen" id="imagen" value="default.png" />
                                        <input type="file" name="imagen" id="wizard-picture-2">
                                    </div>      
                                    <h6>Cambiar Imagen</h6>
                                    <!-- <a href="javascript:void(0)" class="text-danger delete ms-2" onclick="anular();"><i data-feather="trash-2" class="feather-sm fill-white"></i></a> -->
                                </div>
                            </div>
                        </div>
                        <div class="col-md-8">
                            <div class="table-responsive">
                                <table class="table table-condensed table-hover" width="100%">
                                    <tbody>
                                        <tr>
                                            <td style="width:50px;">
                                                <span class="round round-warning"><i class="ti-ticket"></i></span>
                                            </td>
                                            <td>
                                                <h5 class="m-t-5 m-b-0">Conectar con DGI</h5><h6 class="text-muted">Activar la conexi&oacute;n con DGI.</h6>
                                            </td>
                                            <td class="text-right p-r-0" style="vertical-align: middle;">
                                                <div class="switch">
                                                    <label><input type="checkbox" id="sunat"><span class="lever switch-col-light-green"></span></label>
                                                </div>
                                                <input type="hidden" name="sunat" id="sunat_hidden">
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="width:50px;">
                                                <span class="round round-warning"><i class="ti-receipt"></i></span>
                                            </td>
                                            <td>
                                                <h5 class="m-t-5 m-b-0">Producci&oacute;n *</h5><h6 class="text-muted">Empezar a enviar los documentos a DGI.</h6>
                                                <h6 class="text-muted">* Si esta opci&oacute;n se encuentra desactivado, estar&iacute;a en modo Beta.</h6>
                                            </td>
                                            <td class="text-right p-r-0" style="vertical-align: middle;">
                                                <div class="switch">
                                                    <label><input type="checkbox" id="modo"><span class="lever switch-col-light-green"></span></label>
                                                </div>
                                                <input type="hidden" name="modo" id="modo_hidden">
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                            <div class="row">
                                <div class="col-auto">
                                    <div class="" style="display: block;float: left;">
                                        <input type="hidden" name="hidden_ose" id="hidden_ose"/>
                                        <input type="checkbox" name="ose" id="ose" class="chk-col-green"/>
                                        <label for="ose">OSE</label>
                                    </div>
                                </div>    
                                <div class="col-auto">
                                    <div class="" style="display: block;float: left;">
                                        <input type="hidden" name="hidden_pse" id="hidden_pse"/>
                                        <input type="checkbox" name="pse" id="pse" class="chk-col-green"/>
                                        <label for="pse">PSE</label>
                                    </div>
                                </div>                                                              
                            </div>    
                            
                            <div class="row">
                                <div class="col-12">
                                    <div class="form-group display-flex ose_url" style="display:none;">
                                        <input class="form-control input-lg" type="text" autocomplete="off" placeholder="url OSE" name="ose_url" id="ose_url"/>
                                        <span class="ose_url"></span>
                                    </div>
                                </div>
                                <div class="col-6">
                                    <div class="form-group display-flex pse_activo" style="display:none;">
                                        <input class="form-control input-lg" type="text" autocomplete="off" placeholder="Usuario Pse" name="usuario_pse" id="usuario_pse"/>
                                        <span class="usuario_pse"></span>
                                    </div>
                                </div>
                                <div class="col-6">
                                    <div class="form-group display-flex pse_activo" style="display:none;">
                                        <input class="form-control input-lg" type="text" autocomplete="off" placeholder="Contraseña" name="contra_pse" id="contra_pse"/>
                                        <span class="contra_pse"></span>
                                    </div>
                                </div>
                                <div class="col-12">
                                    <div class="form-group display-flex pse_activo" style="display:none;">
                                        <input class="form-control input-lg" type="text" autocomplete="off" placeholder="Url autenticación" name="url_pse" id="url_pse"/>
                                        <span class="url_pse"></span>
                                    </div>
                                </div>
                                <div class="col-12">
                                    <div class="form-group display-flex pse_activo" style="display:none;">
                                        <input class="form-control input-lg" type="text" autocomplete="off" placeholder="Url firma digital del documento" name="xml_pse" id="xml_pse"/>
                                        <span class="xml_pse"></span>
                                    </div>
                                </div>
                                <div class="col-12">
                                    <div class="form-group display-flex pse_activo" style="display:none;">
                                        <input class="form-control input-lg" type="text" autocomplete="off" placeholder="Url envio CDR" name="cdr_pse" id="cdr_pse"/>
                                        <span class="cdr_pse"></span>
                                    </div>
                                </div>
                            </div>




                        </div>
                    </div>
                    <div class="row floating-labels m-t-20">
                        <div class="col-md-4">
                            <div class="form-group m-b-40 ent">
                                <input type="text" name="ruc" id="ruc" value="" class="form-control" maxlength="<?php echo Session::get('tribCar'); ?>" autocomplete="off" required>
                                <span class="bar"></span>
                                <label for="ruc" class="lblruc"><?php echo Session::get('tribAcr'); ?></label>
                            </div>
                        </div>
                        <div class="col-md-8">
                            <div class="form-group m-b-40">
                                <input type="text" name="razon_social" id="razon_social" class="form-control input-mayus" autocomplete="off" required>
                                <span class="bar"></span>
                                <label for="razon_social">Raz&oacute;n social</label>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group m-b-40">
                                <input type="text" name="direccion_fiscal" id="direccion_fiscal" class="form-control input-mayus" autocomplete="off" required>
                                <span class="bar"></span>
                                <label for="direccion_fiscal">Direcci&oacute;n fiscal</label>
                            </div>
                        </div>
                        <div class="col-lg-12">
                            <div class="row m-t-40">
                                <div class="col-md-12">
                                    <div class="form-group m-b-40 ent">
                                        <input type="text" name="ubigeo" id="ubigeo" value="" class="form-control sunat" autocomplete="off" required>
                                        <span class="bar"></span>
                                        <label for="ubigeo">Ubigeo</label>
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="form-group m-b-40">
                                        <input type="text" name="departamento" id="departamento" value="" class="form-control input-mayus sunat" autocomplete="off" required>
                                        <span class="bar"></span>
                                        <label for="departamento">Departamento</label>
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="form-group m-b-40">
                                        <input type="text" name="provincia" id="provincia" value="" class="form-control input-mayus sunat" autocomplete="off" required>
                                        <span class="bar"></span>
                                        <label for="provincia">Provincia</label>
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="form-group m-b-40">
                                        <input type="text" name="distrito" id="distrito" value="" class="form-control input-mayus sunat" autocomplete="off" required>
                                        <span class="bar"></span>
                                        <label for="distrito">Distrito</label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- Ocultado: Campos de APISPERU (Perú) - No aplica para Panamá
                        <div class="col-lg-6">
                            <div class="row floating-labels m-t-40">
                                <div class="col-md-6">
                                    <div class="form-group m-b-40">
                                        <input type="text" name="usuariosol" id="usuariosol" value="" class="form-control sunat" autocomplete="off" required>
                                        <span class="bar"></span>
                                        <label for="usuariosol">Usuario SOL (ruc+usuario)</label>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group m-b-40">
                                        <input type="text" name="clavesol" id="clavesol" value="" class="form-control sunat" autocomplete="off" required>
                                        <span class="bar"></span>
                                        <label for="clavesol">Clave SOL</label>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group m-b-40">
                                        <input type="text" name="clavecertificado" id="clavecertificado" value="" class="form-control sunat" autocomplete="off">
                                        <span class="bar"></span>
                                        <label for="clavecertificado">Contrase&ntilde;a certificado</label>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group m-b-40">
                                        <span class="btn btn-outline-info btn-block btn-file">
                                            Subir archivo <input type="file" name="file_certificado" id="file_certificado" accept=".pfx,.PFX,.p12,.P12">
                                        </span>
                                        <span class="bar"></span>
                                        <label for="file_certificado">Subir Certificado</label>
                                    </div>
                                </div>
                                <div class="col-md-12 mt-2 m-b-40">
                                    <h6 class="border-bottom">Consulta integrada de CPE - Validador de documentos <i class="fas fa-info-circle" data-toggle="tooltip" data-placement="top" title="Validador en producción"></i></h6>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group m-b-40">
                                        <input type="text" name="client_id" id="client_id" value="" class="form-control sunat" autocomplete="off" >
                                        <span class="bar"></span>
                                        <label for="clavecertificado">Client ID</label>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group m-b-40">
                                        <input type="text" name="client_secret" id="client_secret" value="" class="form-control sunat" autocomplete="off" >
                                        <span class="bar"></span>
                                        <label for="clavecertificado">Client Secret (Clave)</label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        -->
                        
                    </div>
                </div>
            </div>
            <div class="card-body sunat b-t">
                <div class="m-t-20">
                    <h4 class="card-title"><i class="ti-receipt font-18"></i> Configuración de Facturación Electrónica</h4>
                    <h6 class="card-subtitle">Configuración para integración con FacturaFacil de Panamá</h6><br>
                    <div class="row pt-4">
                        <!-- Activar Facturación -->
                        <div class="col-md-12">
                            <div class="form-group m-b-40">
                                <span class="bar"></span>
                                <label for="facturacion_activa">Activar Facturación Electrónica</label>
                                <div class="row">
                                    <div class="col-8">
                                        <h6 class="text-muted mt-3">Habilita la emisión de facturas electrónicas a través de FacturaFacil</h6>
                                    </div>
                                    <div class="col-4 text-right">
                                        <div class="switch">
                                            <label style="position: inherit;"><input type="checkbox" id="facturacion_activa"><span class="lever switch-col-light-green"></span></label>
                                            <input type="hidden" name="facturacion_activa" id="facturacion_activa_hidden">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Columna 1: Credenciales de API -->
                        <div class="col-md-6">
                            <h5 class="m-t-20 m-b-20"><i class="ti-key"></i> Credenciales de API</h5>
                            <hr>
                            
                            <div class="form-group m-b-40">
                                <input type="text" name="ff_company_uuid" id="ff_company_uuid" class="form-control" autocomplete="off">
                                <span class="bar"></span>
                                <label for="ff_company_uuid">UUID de Empresa (X-FF-Company)</label>
                                <small class="form-text text-muted">Ingrese el UUID de su empresa proporcionado por Factura Facil</small>
                            </div>
                            
                            <div class="form-group m-b-40">
                                <input type="password" name="ff_api_key" id="ff_api_key" class="form-control" autocomplete="off">
                                <i class="fas fa-eye-slash" id="togglePasswordApiKey" style="position:absolute;margin-top:-27px;right:0;font-size: 18px;cursor:pointer"></i>
                                <span class="bar"></span>
                                <label for="ff_api_key">API Key (X-FF-API-Key)</label>
                                <small class="form-text text-muted">Ingrese su API Key de Factura Facil</small>
                            </div>
                            
                            <div class="form-group m-b-40">
                                <input type="text" name="ff_branch" id="ff_branch" class="form-control" autocomplete="off" placeholder="0001 o UUID">
                                <span class="bar"></span>
                                <label for="ff_branch">Branch (X-FF-Branch)</label>
                                <small class="form-text text-muted">Código o UUID de sucursal según Factura Facil</small>
                            </div>
                        </div>
                        
                        <!-- Columna 2: Datos de la Sucursal -->
                        <div class="col-md-6">
                            <h5 class="m-t-20 m-b-20"><i class="ti-location-pin"></i> Datos de la Sucursal</h5>
                            <hr>
                            
                            <div class="form-group m-b-40">
                                <input type="text" name="branch_address" id="branch_address" class="form-control input-mayus" autocomplete="off" maxlength="100">
                                <span class="bar"></span>
                                <label for="branch_address">Dirección de la Sucursal</label>
                                <small class="form-text text-muted">Dirección completa de la sucursal que emite la factura</small>
                            </div>
                            
                            <div class="form-group m-b-40">
                                <input type="text" name="branch_phone" id="branch_phone" class="form-control" autocomplete="off" maxlength="8" placeholder="99999999">
                                <span class="bar"></span>
                                <label for="branch_phone">Teléfono de la Sucursal</label>
                                <small class="form-text text-muted">8 dígitos sin guiones (ej: 99999999)</small>
                            </div>
                        </div>
                        
                        <!-- Sección Ubigeo: selects + código, coordenadas, email (como Información de Headers) -->
                        <div class="col-md-12">
                            <div class="alert alert-light border">
                                <h5 class="m-b-15"><i class="ti-location-pin"></i> Ubicación (Ubigeo)</h5>
                                <p class="text-muted small m-b-20">Seleccione Provincia, Distrito y Corregimiento. El código PP-DD-CC se completará automáticamente.</p>
                                <div class="row m-b-20">
                                    <div class="col-md-4">
                                        <div class="form-group m-b-20">
                                            <label for="ubicacion_provincia">Provincia</label>
                                            <select class="form-control" id="ubicacion_provincia" name="ubicacion_provincia" title="Provincia">
                                                <option value="">Seleccione provincia</option>
                                                <?php if (!empty($this->provincias_panama)): foreach ($this->provincias_panama as $p): ?>
                                                <option value="<?php echo (int)$p->id; ?>" data-codigo="<?php echo htmlspecialchars($p->codigo); ?>"><?php echo htmlspecialchars($p->nombre); ?></option>
                                                <?php endforeach; endif; ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group m-b-20">
                                            <label for="ubicacion_distrito">Distrito</label>
                                            <select class="form-control" id="ubicacion_distrito" name="ubicacion_distrito" title="Distrito" disabled>
                                                <option value="">Seleccione distrito</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group m-b-20">
                                            <label for="ubicacion_corregimiento">Corregimiento</label>
                                            <select class="form-control" id="ubicacion_corregimiento" name="ubicacion_corregimiento" title="Corregimiento" disabled>
                                                <option value="">Seleccione corregimiento</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="form-group m-b-40">
                                            <input type="text" name="branch_location" id="branch_location" class="form-control" autocomplete="off" maxlength="8" placeholder="08-01-01" readonly>
                                            <span class="bar"></span>
                                            <label for="branch_location">Código (PP-DD-CC)</label>
                                            <small class="form-text text-muted">Código de ubicación: Provincia-Distrito-Corregimiento (ej: 08-01-01)</small>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group m-b-40">
                                            <div class="input-group">
                                                <input type="text" name="branch_coordinates" id="branch_coordinates" class="form-control" autocomplete="off" maxlength="20" placeholder="+08.9539,-79.5343">
                                                <div class="input-group-append">
                                                    <button type="button" class="btn btn-info" id="btn-seleccionar-coordenadas" title="Seleccionar en mapa" onclick="abrirModalCoordenadas()">
                                                        <i class="ti-location-pin"></i> Mapa
                                                    </button>
                                                </div>
                                            </div>
                                            <span class="bar"></span>
                                            <label for="branch_coordinates">Coordenadas (Latitud,Longitud)</label>
                                            <small class="form-text text-muted">Formato: +08.9539,-79.5343. Use el botón "Mapa" para seleccionar.</small>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group m-b-40">
                                            <input type="email" name="branch_email" id="branch_email" class="form-control" autocomplete="off" maxlength="100">
                                            <span class="bar"></span>
                                            <label for="branch_email">Email de la Sucursal (Opcional)</label>
                                            <small class="form-text text-muted">Correo electrónico de contacto de la sucursal</small>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-12">
                            <div class="alert alert-info">
                                <h5><i class="ti-info-alt"></i> Información de Headers</h5>
                                <p>Los siguientes headers se configurarán automáticamente al realizar las peticiones a la API:</p>
                                <ul class="mb-0">
                                    <li><strong>X-FF-Company:</strong> UUID de la empresa</li>
                                    <li><strong>X-FF-API-Key:</strong> API Key de autenticación</li>
                                    <li><strong>X-FF-Branch:</strong> Código de sucursal</li>
                                    <li><strong>Content-Type:</strong> application/json</li>
                                    <li><strong>Accept:</strong> application/json</li>
                                </ul>
                                <hr>
                                <p class="mb-0"><strong>Nota:</strong> Si la sucursal no existe en Factura Facil, se enviarán automáticamente los datos de dirección, teléfono, ubicación y coordenadas configurados arriba.</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="card-footer">
                <div class="text-right">
                    <a href="<?php echo URL; ?>ajuste" class="btn btn-secondary">Cancelar</a>
                    <button class="btn btn-success" type="submit">Aceptar</button>
                </div>
            </div>
        </div>
    </div>
</div>
</form>

<!-- Modal para seleccionar coordenadas en mapa -->
<div class="modal fade" id="modal-seleccionar-coordenadas" tabindex="-1" role="dialog" aria-hidden="true" data-backdrop="static">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title"><i class="ti-location-pin"></i> Seleccionar Ubicación en el Mapa</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="alert alert-info">
                    <i class="ti-info-alt"></i> <strong>Instrucciones:</strong> Haga clic en el mapa para seleccionar la ubicación de la sucursal. Puede arrastrar el marcador para ajustar la posición.
                </div>
                <div id="map-coordenadas" style="height: 500px; width: 100%; border: 1px solid #ddd; border-radius: 4px;"></div>
                <div class="m-t-20">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Latitud:</label>
                                <input type="text" id="map-latitud" class="form-control" readonly>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Longitud:</label>
                                <input type="text" id="map-longitud" class="form-control" readonly>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
                <button type="button" class="btn btn-success" id="btn-confirmar-coordenadas">Confirmar Coordenadas</button>
            </div>
        </div>
    </div>
</div>

<!-- Leaflet CSS -->
<link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css" integrity="sha256-p4NxAoJBhIIN+hmNHrzRCf9tD/miZyoHS5obTRR9BMY=" crossorigin=""/>
<!-- Leaflet JS -->
<script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js" integrity="sha256-20nQCchB9co0qIjJZRGuk2/Z9VM+kNiyxNV1lvTlZBo=" crossorigin=""></script>

<script>
// Función global para abrir el modal de coordenadas
function abrirModalCoordenadas() {
    var modal = $('#modal-seleccionar-coordenadas');
    if (modal.length === 0) {
        Swal.fire('Error', 'El modal de selección de coordenadas no se encontró. Por favor recargue la página.', 'error');
        return;
    }
    modal.modal('show');
}
</script>
