<?php Session::init(); ?>
<?php

class Venta_Model extends Model
{
    public function __construct()
    {
        parent::__construct();
    }
    
    public function Salon()
    {
        try
        {
            return $this->db->selectAll('SELECT * FROM tm_salon WHERE estado <> "i"');
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function Mozo()
    {
        try
        {   
            return $this->db->selectAll('SELECT id_usu,nombres,ape_paterno,ape_materno, defaultid FROM v_usuarios WHERE id_rol = 5 AND estado = "a"');
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function Repartidor()
    {
        try
        {   
            return $this->db->selectAll('SELECT * FROM tm_usuario WHERE id_rol = 6 AND estado = "a"');
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function RepartidorApp()
    {
        try
        {   
            return $this->db->selectAll('SELECT * FROM tm_repartidor WHERE estado = "a"');
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }    
    public function RepartidorApp_list()
    {
        try
        {   
            return $this->db->selectAll("SELECT * FROM tm_repartidor WHERE id_repartidor <> 1 AND id_repartidor <> 9999 AND estado = 'a' ");
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }  

    public function TipoDocumento($id = false)
    {
        try
        {   
            if ($id) {
                return $this->db->selectOne('SELECT * FROM tm_tipo_doc WHERE id_tipo_doc = "'.$id.'" and estado = "a"');            
            } else {
                return $this->db->selectAll('SELECT * FROM tm_tipo_doc WHERE estado = "a"');
            }      
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function TipoPago()
    {
        try
        {   
            return $this->db->selectAll('SELECT p.id_pago, p.id_tipo_pago, p.descripcion AS descripcion, p.color, tp.descripcion AS pago_tipo, p.delivery FROM tm_tipo_pago AS p INNER JOIN tm_pago AS tp ON p.id_pago = tp.id_pago WHERE p.estado ="a"');    
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function Personal()
    {
        try
        {      
            return $this->db->selectAll("SELECT * FROM tm_usuario WHERE id_usu <> 1 AND estado = 'a' GROUP BY dni");
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function mesa_list()
    {
        try
        {   
            $mesa = $this->db->prepare("SELECT * FROM v_listar_mesas ORDER BY id_mesa ASC");
            $mesa->execute();
            $m = $mesa->fetchAll(PDO::FETCH_OBJ);

            foreach($m as $k => $d)
            {
                // $c[$k]->{'Total'} 
                if($d->id_pedido){
                    $id_usu = $this->db->query("SELECT id_mozo FROM tm_pedido_mesa WHERE id_pedido =" . $d->id_pedido)->fetch(PDO::FETCH_COLUMN);
                    $m[$k]->{'Mozo'} =$this->db->query("SELECT nombres as nombre_mozo FROM v_usuarios WHERE id_usu =" . $id_usu)->fetch(PDO::FETCH_OBJ);
                    $m[$k]->{'PedidoTotal'} =$this->db->query("SELECT SUM(cantidad*precio) as total FROM `tm_detalle_pedido` WHERE estado <> 'z' AND id_pedido = ".$d->id_pedido)->fetch(PDO::FETCH_OBJ);


                    // SELECT SUM(cantidad*precio) FROM `tm_detalle_pedido` WHERE id_pedido = 50;
                }

            }     

            $data = array("mesa" => $m);
            return $data;
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function mostrador_list($data)
    {
        try
        {   
            date_default_timezone_set($_SESSION["zona_horaria"]);
            setlocale(LC_ALL,"es_ES@euro","es_ES","esp");
            $fecha = date('Y-m-d');

            if($data['estado'] == 'd'){
                $filtro_fecha = " AND DATE_FORMAT(p.fecha_pedido,'%Y-%m-%d') = '".$fecha."' ORDER BY p.fecha_pedido DESC";
            }else{
                $filtro_fecha = "";
            }

            $stm = $this->db->prepare("SELECT tp.*,p.fecha_pedido,p.estado,DATE(p.fecha_pedido) AS fecha FROM tm_pedido AS p INNER JOIN tm_pedido_llevar AS tp ON p.id_pedido = tp.id_pedido WHERE p.estado = ? ".$filtro_fecha);
            $stm->execute(array($data['estado']));
            $c = $stm->fetchAll(PDO::FETCH_OBJ);
            foreach($c as $k => $d)
            {
                $c[$k]->{'Total'} = $this->db->query("SELECT IFNULL(SUM(precio*cantidad),0) AS total FROM v_det_llevar WHERE estado <> 'z' AND id_pedido = " . $d->id_pedido)->fetch(PDO::FETCH_OBJ);
            }            
            $data = array("data" => $c);
            $json = json_encode($data);
            echo $json;
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function mostrador_list_c($data)
    {
        try
        {   
            date_default_timezone_set($_SESSION["zona_horaria"]);
            setlocale(LC_ALL,"es_ES@euro","es_ES","esp");
            $fecha = date('Y-m-d');

            if($data['estado'] == 'd'){
                $filtro_fecha = " AND DATE_FORMAT(p.fecha_pedido,'%Y-%m-%d') = '".$fecha."' ORDER BY p.fecha_pedido DESC";
            }else{
                $filtro_fecha = "";
            }

            if(Session::get('rol') == 5){

                $stm = $this->db->prepare("SELECT tp.*,p.fecha_pedido,p.estado,DATE(p.fecha_pedido) AS fecha, v.id_venta, v.id_tipo_pago, IFNULL((v.total+v.comision_delivery-v.descuento_monto),0) AS total FROM tm_pedido AS p INNER JOIN tm_pedido_llevar AS tp ON p.id_pedido = tp.id_pedido INNER JOIN tm_venta AS v ON p.id_pedido = v.id_pedido WHERE p.estado = ? ".$filtro_fecha);
                $stm->execute(array($data['estado']));
                $c = $stm->fetchAll(PDO::FETCH_OBJ);

            } else {

                $stm = $this->db->prepare("SELECT tp.*,p.fecha_pedido,p.estado,DATE(p.fecha_pedido) AS fecha, v.id_venta, v.id_tipo_pago, IFNULL((v.total+v.comision_delivery-v.descuento_monto),0) AS total FROM tm_pedido AS p INNER JOIN tm_pedido_llevar AS tp ON p.id_pedido = tp.id_pedido INNER JOIN tm_venta AS v ON p.id_pedido = v.id_pedido WHERE v.id_apc = ? AND p.estado = ? ".$filtro_fecha);
                $stm->execute(array(Session::get('apcid'),$data['estado']));
                $c = $stm->fetchAll(PDO::FETCH_OBJ);

            }

            foreach($c as $k => $d)
            {
                $c[$k]->{'Tipopago'} = $this->db->query("SELECT tp.descripcion as nombre, tp.color AS color FROM tm_venta_pago AS vp INNER JOIN tm_venta AS v ON v.id_venta = vp.id_venta INNER JOIN tm_tipo_pago AS tp ON vp.id_pago = tp.id_tipo_pago WHERE vp.monto > 0 AND vp.id_venta = " . $d->id_venta)
                ->fetchAll(PDO::FETCH_OBJ);                    
            }
      
            $data = array("data" => $c);
            $json = json_encode($data);
            echo $json;
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function delivery_list($data)
    {
        try
        {   
            date_default_timezone_set($_SESSION["zona_horaria"]);
            setlocale(LC_ALL,"es_ES@euro","es_ES","esp");
            $fecha = date('Y-m-d');

            if($data['estado'] == 'd'){
                $filtro_fecha = " AND DATE_FORMAT(p.fecha_pedido,'%Y-%m-%d') = '".$fecha."' ORDER BY p.fecha_pedido DESC";
            }else{
                $filtro_fecha = "";
            }

            $stm = $this->db->prepare("SELECT tp.*,p.fecha_pedido,p.estado,DATE(p.fecha_pedido) AS fecha FROM tm_pedido AS p INNER JOIN tm_pedido_delivery AS tp ON p.id_pedido = tp.id_pedido WHERE p.estado = ? ".$filtro_fecha);
            $stm->execute(array($data['estado']));
            $c = $stm->fetchAll(PDO::FETCH_OBJ);

            foreach($c as $k => $d)
            {
                $c[$k]->{'NombreRepartidor'} = $this->db->query("SELECT desc_repartidor FROM v_pedido_delivery WHERE id_pedido = ".$d->id_pedido." and id_repartidor = " .$d->id_repartidor)
                    ->fetch(PDO::FETCH_OBJ);
            }


            foreach($c as $k => $d)
            {
                $c[$k]->{'Tipopago'} = $this->db->query("SELECT descripcion AS nombre FROM tm_tipo_pago WHERE id_tipo_pago = " . $d->tipo_pago)
                    ->fetch(PDO::FETCH_OBJ);               
            }
            foreach($c as $k => $d)
            {
                // suma si hay delivery 
                // SELECT comision_delivery FROM `tm_pedido_delivery` WHERE `id_pedido` = 4
                $comisiondelivery   = $this->db->query("SELECT comision_delivery FROM `tm_pedido_delivery` WHERE `id_pedido` =" . $d->id_pedido)->fetch();
                // $row = $result->fetch(PDO::FETCH_ASSOC);
                $ventatotal         = $this->db->query("SELECT IFNULL(SUM(precio*cantidad),0) AS total FROM v_det_delivery WHERE estado <> 'z' AND id_pedido = " . $d->id_pedido)->fetch();

                $c[$k]->{'Total'} =  $ventatotal;
            }            
            $data = array("data" => $c);
            $json = json_encode($data);
            echo $json; 
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }
    
    public function delivery_list_c($data)
    {
        try
        {   
            date_default_timezone_set($_SESSION["zona_horaria"]);
            setlocale(LC_ALL,"es_ES@euro","es_ES","esp");
            $fecha = date('Y-m-d');


            if($data['estado'] == 'd'){
                $filtro_fecha = " AND DATE_FORMAT(p.fecha_pedido,'%Y-%m-%d') = '".$fecha."' ORDER BY p.fecha_pedido DESC";
            }else{
                $filtro_fecha = "";
            }

            
            $rolesPermitidos = ['1', '2'];

            $id_apc = (in_array(Session::get('rol'), $rolesPermitidos)) ? '%' :  Session::get('apcid');
            // if (in_array(Session::get('rol'), $rolesPermitidos)) {
            //     // El rol está permitido
            //     // Tu código aquí
            // }

            $stm = $this->db->prepare("SELECT v.id_venta,tp.*,p.fecha_pedido,p.estado,DATE(p.fecha_pedido) AS fecha, v.id_tipo_pago AS tipo_pago_new, IFNULL((v.total+v.comision_delivery-v.descuento_monto),0) AS total FROM tm_pedido AS p INNER JOIN tm_pedido_delivery AS tp ON p.id_pedido = tp.id_pedido INNER JOIN tm_venta AS v ON p.id_pedido = v.id_pedido WHERE v.id_apc like ? AND p.estado = ? ".$filtro_fecha);
            $stm->execute(array($id_apc,$data['estado']));
            $c = $stm->fetchAll(PDO::FETCH_OBJ);
            foreach($c as $k => $d)
            {
                // $c[$k]->{'Tipopago'} = $this->db->query("SELECT descripcion AS nombre FROM tm_tipo_pago WHERE id_tipo_pago = " . $d->tipo_pago_new)
                //     ->fetch(PDO::FETCH_OBJ);


                $c[$k]->{'Tipopago'} = $this->db->query("SELECT tp.descripcion as nombre, tp.color AS color FROM tm_venta_pago AS vp INNER JOIN tm_venta AS v ON v.id_venta = vp.id_venta INNER JOIN tm_tipo_pago AS tp ON vp.id_pago = tp.id_tipo_pago WHERE vp.monto > 0 AND vp.id_venta = " . $d->id_venta)
                ->fetchAll(PDO::FETCH_OBJ);                         
            }
            foreach($c as $k => $d)
            {
                $c[$k]->{'NombreRepartidor'} = $this->db->query("SELECT desc_repartidor FROM v_pedido_delivery WHERE id_pedido = ".$d->id_pedido." and id_repartidor = " .$d->id_repartidor)
                    ->fetch(PDO::FETCH_OBJ);
            }

            $data = array("data" => $c);
            $json = json_encode($data);
            echo $json; 
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function listarPedidos($data)
    {
        try
        {   
            $grpPrecuenta = ", COALESCE(dp.nombre_precuenta,'')";
            if($data['codpagina'] == '1'){
                $stm = $this->db->prepare("SELECT dp.id_pedido, dp.id_pres, SUM(dp.cantidad) AS cantidad, dp.precio, dp.comentario, dp.estado, p.nombre_mozo, dp.toppings, COALESCE(MAX(dp.nombre_precuenta),'') AS nombre_precuenta FROM tm_detalle_pedido AS dp INNER JOIN v_pedido_mesa AS p ON p.id_pedido = dp.id_pedido WHERE dp.id_pedido = ? AND dp.estado <> 'z' AND dp.cantidad > 0 GROUP BY dp.id_pres, dp.precio".$grpPrecuenta." ORDER BY dp.fecha_pedido DESC");
            } else {
                $stm = $this->db->prepare("SELECT dp.id_pedido, dp.id_pres, SUM(dp.cantidad) AS cantidad, dp.precio, dp.comentario, dp.estado, dp.toppings, COALESCE(MAX(dp.nombre_precuenta),'') AS nombre_precuenta FROM tm_detalle_pedido AS dp WHERE dp.id_pedido = ? AND dp.estado <> 'z' AND dp.cantidad > 0 GROUP BY dp.id_pres, dp.precio".$grpPrecuenta." ORDER BY dp.fecha_pedido DESC");
            }
            $stm->execute(array($data['id_pedido']));
            $c = $stm->fetchAll(PDO::FETCH_OBJ);  
            foreach($c as $k => $d)
            {
                $c[$k]->{'Producto'} = $this->db->query("SELECT pro_nom,pro_pre FROM v_productos WHERE id_pres = ". $d->id_pres)->fetch(PDO::FETCH_OBJ);
                $c[$k]->{'toppings'} = json_decode($d->toppings, true);
            }
            return $c;
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function listarPedidosDetalle($data)
    {
        try
        {   
            if($data['cod_atencion'] == 2) { $tabla = 'v_pedido_llevar'; } elseif($data['cod_atencion'] == 3) { $tabla = 'v_pedido_delivery'; }
            $stm = $this->db->prepare("SELECT * FROM ".$tabla." WHERE id_pedido = ?");
            $stm->execute(array($data['id_pedido']));
            $c = $stm->fetch(PDO::FETCH_OBJ);
            /* Traemos el detalle */


            if($data['cod_atencion'] == 3) {
            $c->{'Tipopago'} = $this->db->query("SELECT descripcion AS nombre FROM tm_tipo_pago WHERE id_tipo_pago = " . $c->tipo_pago)
            ->fetch(PDO::FETCH_OBJ);

            $userid = $this->db->query("SELECT * FROM tm_pedido WHERE id_pedido = " . $data['id_pedido'])
            ->fetch(PDO::FETCH_OBJ);

            $c->{'User'} = $this->db->query("SELECT CONCAT(nombres,' ',ape_paterno,' ',ape_materno) AS nombre FROM tm_usuario WHERE id_usu =  " . $userid->id_usu)
            ->fetch(PDO::FETCH_OBJ);

            }else{

                $c->{'User'} = $this->db->query("SELECT CONCAT(nombres,' ',ape_paterno,' ',ape_materno) AS nombre FROM tm_usuario WHERE id_usu =  " . $c->id_usu)
                ->fetch(PDO::FETCH_OBJ);

            }

            $c->{'Detalle'} = $this->db->query("SELECT id_pedido,id_pres,SUM(cant) AS cant, precio, comentario, estado FROM tm_detalle_pedido WHERE id_pedido = ".$c->id_pedido." AND estado <> 'z' AND cant > 0 GROUP BY id_pres, precio ORDER BY fecha_pedido DESC")
                ->fetchAll(PDO::FETCH_OBJ);
            foreach($c->Detalle as $k => $d)
            {
                $c->Detalle[$k]->{'Producto'} = $this->db->query("SELECT pro_cat, pro_nom,pro_pre FROM v_productos WHERE id_pres = " . $d->id_pres)
                    ->fetch(PDO::FETCH_OBJ);
            }
            return $c;
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function listarUpdatePedidos($data)
    {
        try
        {   
            date_default_timezone_set($_SESSION["zona_horaria"]);
            setlocale(LC_ALL,"es_ES@euro","es_ES","esp");
            $fecha = date("Y-m-d H:i:s");

            $stm = $this->db->prepare("SELECT p.pro_cat AS categoria,p.id_pres AS producto_id, p.pro_nom AS producto, p.pro_pre AS presentacion, SUM(d.cant) AS cantidad, d.precio, d.comentario, d.toppings, a.id_areap, i.nombre AS nombre_imp, a.nombre AS nombre_area FROM tm_detalle_pedido AS d INNER JOIN v_productos AS p ON d.id_pres = p.id_pres INNER JOIN tm_area_prod AS a ON a.id_areap = p.id_areap INNER JOIN tm_impresora AS i ON i.id_imp = a.id_imp WHERE d.id_pedido = ? AND d.cant > 0 AND d.estado <> 'z' GROUP BY d.id_pres ORDER BY d.fecha_pedido DESC");
            $stm->execute(array($data['id_pedido']));
            $c = $stm->fetchAll(PDO::FETCH_OBJ); 
            
            
            foreach($c as $k => $d)
            {
                $c[$k]->{'toppings'} = json_decode($d->toppings, true);
            }

            $sql2 = "UPDATE tm_detalle_pedido SET estado = 'a', fecha_pedido = ? WHERE id_pedido = ? AND estado = 'y'";
            $this->db->prepare($sql2)->execute(array($fecha,$data['id_pedido']));

            if($data['estado_pedido'] == 'a'){

                $sql3 = "UPDATE tm_pedido SET id_apc = ?, id_usu = ?, estado = 'b' WHERE id_pedido = ?";
                $this->db->prepare($sql3)->execute(array(Session::get('apcid'),Session::get('usuid'),$data['id_pedido']));

                $sql4 = "UPDATE tm_pedido_delivery SET fecha_preparacion = ? WHERE id_pedido = ?";
                $this->db->prepare($sql4)->execute(array($fecha,$data['id_pedido']));
                /*
                UPDATE tm_pedido SET id_apc = _id_apc, id_usu = _id_usu, estado = 'b' WHERE id_pedido = _id_pedido;
                UPDATE tm_pedido_delivery SET fecha_preparacion = _fecha_venta WHERE id_pedido = _id_pedido;
                */
            }
            if($data['estado_pedido'] == 'anularmesa'){

                // $sql5 = "UPDATE tm_detalle_pedido SET estado = 'z' WHERE id_pedido = ? AND estado = 'a'";
                // $this->db->prepare($sql5)->execute(array($data['id_pedido']));                
            
            }

            return $c;
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function reimpresion_comanda($data)
    {
        try
        {   

            $stmkey = $this->db->prepare("SELECT * FROM tm_comandas WHERE id_key = '{$data['id_key']}'");
            $stmkey->execute();
            $ckey = $stmkey->fetch(PDO::FETCH_OBJ);  

            $stm = $this->db->prepare("SELECT p.pro_cat AS categoria,p.id_pres AS producto_id, p.pro_nom AS producto, p.pro_pre AS presentacion, SUM(d.cant) AS cantidad, d.precio, d.comentario, a.id_areap, i.nombre AS nombre_imp FROM tm_detalle_pedido AS d INNER JOIN v_productos AS p ON d.id_pres = p.id_pres INNER JOIN tm_area_prod AS a ON a.id_areap = p.id_areap INNER JOIN tm_impresora AS i ON i.id_imp = a.id_imp WHERE d.id_pedido = ? AND d.fecha_pedido = ?  AND d.cant > 0 GROUP BY d.id_pres ORDER BY d.fecha_pedido DESC");
            $stm->execute(array($ckey->id_pedido,$ckey->fecha_pedido));
            $c = $stm->fetchAll(PDO::FETCH_OBJ); 
    

            return $c;
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }
    public function listarPedidosTicket($data)
    {
        try
        {   
            date_default_timezone_set($_SESSION["zona_horaria"]);
            setlocale(LC_ALL,"es_ES@euro","es_ES","esp");
            $fecha = date("Y-m-d H:i:s");

            $stm = $this->db->prepare("SELECT p.pro_cat AS categoria , p.pro_nom AS producto, p.pro_pre AS presentacion, SUM(d.cant) AS cantidad, d.precio, d.comentario, 1 AS id_areap, 'CAJA' AS nombre_imp FROM tm_detalle_pedido AS d INNER JOIN v_productos AS p ON d.id_pres = p.id_pres WHERE d.id_pedido = ? AND d.estado = 'a' AND d.cant > 0 GROUP BY d.id_pres ORDER BY d.fecha_pedido DESC");
            $stm->execute(array($data['id_pedido']));
            $c = $stm->fetchAll(PDO::FETCH_OBJ); 
    
            return $c;
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function pedidoAccion($data)
    {
        try
        {
            date_default_timezone_set($_SESSION["zona_horaria"]);
            setlocale(LC_ALL,"es_ES@euro","es_ES","esp");
            $fecha = date("Y-m-d H:i:s");

            if($data['cod_accion'] == 1){
                $estado = 'c';
                $tabla = 'tm_pedido_delivery';
                $fecha_campo = 'fecha_envio';
            }else if($data['cod_accion'] == 2){
                $estado = 'd';
                $tabla = 'tm_pedido_delivery';
                $fecha_campo = 'fecha_entrega';
            }else if($data['cod_accion'] == 3){
                $estado = 'd';
                $tabla = 'tm_pedido_llevar';
                $fecha_campo = 'fecha_entrega';
            }

            $sql = "UPDATE tm_pedido SET estado = '".$estado."' WHERE id_pedido = ?";
            $this->db->prepare($sql)->execute(array($data['id_pedido']));
            $sql2 = "UPDATE ".$tabla." SET ".$fecha_campo." = ? WHERE id_pedido = ?";
            $this->db->prepare($sql2)->execute(array($fecha,$data['id_pedido']));
            $sql3 = "UPDATE tm_venta SET codigo_operacion = ? WHERE id_pedido = ?";
            $this->db->prepare($sql3)->execute(array($data['codigo_operacion'],$data['id_pedido']));

        } catch (Exception $e) 
        {
            die($e->getMessage());
        }
    }

    public function ComboMesaOri($data)
    {
        try
        {   
            $stmm = $this->db->prepare("SELECT * FROM tm_mesa WHERE id_salon = ? AND estado = 'i' ORDER BY nro_mesa ASC");
            $stmm->execute(array($data['cod_salon_origen']));
            $var = $stmm->fetchAll(PDO::FETCH_ASSOC);
            foreach($var as $v){
                echo '<option value="'.$v['id_mesa'].'">'.$v['nro_mesa'].'</option>';
            }
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function ComboMesaDes($data)
    {
        try
        {   
            $stmm = $this->db->prepare("SELECT * FROM tm_mesa WHERE id_salon = ? AND estado = ? ORDER BY nro_mesa ASC");
            $stmm->execute(array($data['cod_salon_destino'],$data['estado']));
            $var = $stmm->fetchAll(PDO::FETCH_ASSOC);
            foreach($var as $v){
                echo '<option value="'.$v['id_mesa'].'">'.$v['nro_mesa'].'</option>';
            }
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }
    
    public function CambiarMesa($data)
    {
        try
        {
            $consulta = "call usp_restOpcionesMesa( :flag, :cod_mesa_origen, :cod_mesa_destino);";
            $arrayParam =  array(
                ':flag' => 1,
                ':cod_mesa_origen' =>  $data['cod_mesa_origen_opc01'],
                ':cod_mesa_destino' => $data['cod_mesa_destino_opc01']
            );
            $st = $this->db->prepare($consulta);
            $st->execute($arrayParam);
            $row = $st->fetch(PDO::FETCH_ASSOC);
            return $row;
        } catch (Exception $e) 
        {
            die($e->getMessage());
        }
    }

    public function MoverPedidos($data)
    {
        try
        {
            $consulta = "call usp_restOpcionesMesa( :flag, :cod_mesa_origen, :cod_mesa_destino);";
            $arrayParam =  array(
                ':flag' => 2,
                ':cod_mesa_origen' =>  $data['cod_mesa_origen_opc02'],
                ':cod_mesa_destino' => $data['cod_mesa_destino_opc02']
            );
            $st = $this->db->prepare($consulta);
            $st->execute($arrayParam);
            $row = $st->fetch(PDO::FETCH_ASSOC);
            return $row;
        } catch (Exception $e) 
        {
            die($e->getMessage());
        }
    }

    public function subPedido($data)
    {
        try
        {   
            if($data['tipo_pedido'] == 1){ $tabla = 'v_pedido_mesa'; } elseif($data['tipo_pedido'] == 2) { $tabla = 'v_pedido_llevar'; } elseif($data['tipo_pedido'] == 3) { $tabla = 'v_pedido_delivery'; }
            $stm = $this->db->prepare("SELECT id_pedido, id_tipo_pedido, estado_pedido FROM ".$tabla." WHERE id_pedido = ?");
            $stm->execute(array($data['id_pedido']));
            $c = $stm->fetch(PDO::FETCH_OBJ);
            /* Traemos el detalle */
            $c->{'Detalle'} = $this->db->query("SELECT id_pres, cantidad, cant, precio, estado, fecha_pedido FROM tm_detalle_pedido WHERE id_pedido = ".$c->id_pedido." AND id_pres = ".$data['id_pres']." AND precio = ".$data['precio']." ORDER BY fecha_pedido DESC")
                ->fetchAll(PDO::FETCH_OBJ);
            foreach($c->Detalle as $k => $d)
            {
                $c->Detalle[$k]->{'Producto'} = $this->db->query("SELECT pro_nom,pro_pre FROM v_productos WHERE id_pres = " . $d->id_pres)
                    ->fetch(PDO::FETCH_OBJ);
            }
            return $c;
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function refrescar_mesas()
    {
        try {
            $stm = $this->db->prepare("UPDATE tm_mesa AS m INNER JOIN v_listar_mesas AS v ON m.id_mesa = v.id_mesa SET m.estado = 'a' WHERE v.estado <> 'a' AND v.estado <> 'm' AND v.id_pedido IS NULL");
            $stm->execute();
            $c = $stm->fetchAll(PDO::FETCH_OBJ);
            return $c;
        } catch (Exception $e) {
            return false;
        }
    }

    public function ValidarEstadoPedido($id_pedido)
    {
        try {


            $ped = $this->db->query("SELECT * FROM tm_pedido WHERE id_pedido = ".$id_pedido)->fetch(PDO::FETCH_OBJ);

            $resp = 0;
            if ($ped->id_tipo_pedido == 1) {
                $resp = ($ped->estado == 'a') ? '1' : '0' ;
            }
            else if ($ped->id_tipo_pedido == 2){
                $resp = ($ped->estado == 'a') ? '1' : '0' ;
            }
            else if ($ped->id_tipo_pedido == 3 ){
                $resp = ($ped->estado == "a" || $ped->estado == "b" ) ? '1' : '0' ;
            }
            $rest = [
                "cod" => $resp,
                "tipo_pedido" => $ped->id_tipo_pedido
            ];


            return $rest;

        } catch (Exception $e) {
            return false;
        }
    }

    public function pc1($data)
    {
        try
        {
            date_default_timezone_set($_SESSION["zona_horaria"]);
            setlocale(LC_ALL,"es_ES@euro","es_ES","esp");
            $fecha = date("Y-m-d H:i:s");
            
            // Log para debug
            error_log("=== pc1 DEBUG ===");
            error_log("Data recibida: " . print_r($data, true));
            error_log("Rol: " . Session::get('rol'));
            error_log("Usuid: " . Session::get('usuid'));
            
            if(Session::get('rol') == 5){ 
                $id_usu = Session::get('usuid');
                $id_mozo = $id_usu; 
            } else { 
                $id_usu = isset($data['id_mozo']) ? $data['id_mozo'] : Session::get('usuid');
                $id_mozo = isset($data['id_mozo']) ? $data['id_mozo'] : Session::get('usuid'); 
            };
            
            // Validar datos requeridos
            if(empty($data['id_mesa']) || $data['id_mesa'] == '' || $data['id_mesa'] == '0'){
                error_log("ERROR: id_mesa vacío o inválido");
                return array('fil' => 0, 'error' => 'Debe seleccionar una mesa', 'message' => 'id_mesa no válido');
            }
            
            // Valores por defecto si no están presentes
            $nomb_cliente = isset($data['nomb_cliente']) && !empty($data['nomb_cliente']) ? $data['nomb_cliente'] : 'Mesa: ' . $data['id_mesa'];
            $nro_personas = isset($data['nro_personas']) && !empty($data['nro_personas']) ? $data['nro_personas'] : 1;
            
            error_log("Parámetros finales:");
            error_log("  id_mesa: " . $data['id_mesa']);
            error_log("  id_mozo: " . $id_mozo);
            error_log("  id_usu: " . $id_usu);
            error_log("  nomb_cliente: " . $nomb_cliente);
            error_log("  nro_personas: " . $nro_personas);
            error_log("  id_apc: " . Session::get('apcid'));
            
            $consulta = "call usp_restRegMesa( :flag, :id_tipo_pedido, :id_apc, :id_usu, :fecha_pedido, :id_mesa, :id_mozo, :nomb_cliente, :nro_personas);";
            $arrayParam =  array(
                ':flag' => 1,
                ':id_tipo_pedido' => 1,
                ':id_apc' => Session::get('apcid'),
                ':id_usu' => $id_usu,
                ':fecha_pedido' => $fecha,
                ':id_mesa' => $data['id_mesa'],
                ':id_mozo' => $id_mozo,
                ':nomb_cliente' => $nomb_cliente,
                ':nro_personas' => $nro_personas
            );
            
            error_log("Ejecutando stored procedure con parámetros: " . print_r($arrayParam, true));
            
            $st = $this->db->prepare($consulta);
            
            // Ejecutar y capturar errores
            $execResult = $st->execute($arrayParam);
            error_log("Execute result: " . ($execResult ? 'true' : 'false'));
            
            if(!$execResult) {
                $errorInfo = $st->errorInfo();
                error_log("PDO Error: " . print_r($errorInfo, true));
                return array('fil' => 0, 'error' => 'Error al ejecutar stored procedure', 'message' => $errorInfo[2]);
            }
            
            // Obtener todos los resultados (puede haber múltiples result sets)
            // Primero intentar con fetchAll para ver todos los resultados
            $allResults = $st->fetchAll(PDO::FETCH_ASSOC);
            error_log("Todos los resultados (fetchAll): " . print_r($allResults, true));
            error_log("Número de resultados: " . count($allResults));
            
            // Si hay resultados, tomar el primero
            if(!empty($allResults) && count($allResults) > 0) {
                $row = $allResults[0];
                error_log("Primer resultado de fetchAll: " . print_r($row, true));
            } else {
                // Si no hay resultados con fetchAll, intentar con fetch individual
                $row = $st->fetch(PDO::FETCH_ASSOC);
                error_log("Resultado de fetch individual: " . print_r($row, true));
                
                // Si aún no hay resultado, intentar obtener más rowsets
                if(empty($row) || $row === false) {
                    // Cerrar el statement actual y preparar uno nuevo
                    $st->closeCursor();
                    
                    // Intentar con nextRowset si está disponible
                    try {
                        if($st->nextRowset()) {
                            $row = $st->fetch(PDO::FETCH_ASSOC);
                            error_log("Resultado después de nextRowset: " . print_r($row, true));
                        }
                    } catch(Exception $e) {
                        error_log("Error en nextRowset: " . $e->getMessage());
                    }
                }
            }
            
            // Si aún no hay resultado, verificar si hay más rowsets
            if(empty($row) || $row === false) {
                error_log("ADVERTENCIA: No se obtuvo ningún resultado del stored procedure");
                // Intentar obtener información de error
                $errorInfo = $st->errorInfo();
                error_log("PDO Error Info: " . print_r($errorInfo, true));
                if($errorInfo[0] != '00000' && $errorInfo[0] != '') {
                    return array('fil' => 0, 'error' => 'Error en stored procedure', 'message' => $errorInfo[2]);
                }
                // Si no hay error de PDO, el stored procedure puede no estar retornando datos
                return array('fil' => 0, 'error' => 'El stored procedure no retornó datos', 'message' => 'El stored procedure se ejecutó pero no retornó ningún resultado. Verifique que el stored procedure retorne un SELECT con los campos fil e id_pedido.');
            }
            
            error_log("Resultado final del stored procedure: " . print_r($row, true));
            
            // Si el resultado está vacío, retornar error
            if(empty($row) || !isset($row['fil'])) {
                error_log("ERROR: Resultado vacío o sin campo 'fil'. Campos disponibles: " . (is_array($row) ? implode(', ', array_keys($row)) : 'no es array'));
                return array('fil' => 0, 'error' => 'El stored procedure no retornó datos válidos', 'message' => 'El resultado no contiene el campo "fil" requerido');
            }

            // Si el SP retornó fil=0 (mesa no existe, ya tiene pedido activo o flag inválido), devolver mensaje claro
            if (isset($row['fil']) && (int)$row['fil'] === 0) {
                error_log("pc1: SP retornó fil=0. id_pedido=" . (isset($row['id_pedido']) ? $row['id_pedido'] : 'NULL'));
                return array(
                    'fil' => 0,
                    'error' => 'No se pudo crear el pedido',
                    'message' => 'La mesa no está disponible o ya tiene un pedido activo. Elija otra mesa o cierre el pedido actual.',
                    'id_pedido' => isset($row['id_pedido']) ? $row['id_pedido'] : null
                );
            }

            return $row;

        } catch (Exception $e) 
        {
            error_log("EXCEPCIÓN en pc1: " . $e->getMessage());
            error_log("Stack trace: " . $e->getTraceAsString());
            return array('fil' => 0, 'error' => 'Error en el servidor', 'message' => $e->getMessage());
        }
    }
    public function pc2($data)
    {
        try
        {
            date_default_timezone_set($_SESSION["zona_horaria"]);
            setlocale(LC_ALL,"es_ES@euro","es_ES","esp");
            $fecha = date("Y-m-d H:i:s");
            $id_usu = Session::get('usuid');
            $consulta = "call usp_restRegMostrador( :flag, :id_tipo_pedido, :id_apc, :id_usu, :fecha_pedido, :nomb_cliente);";
            $arrayParam =  array(
                ':flag' => 1,
                ':id_tipo_pedido' => 2,
                ':id_apc' => Session::get('apcid'),
                ':id_usu' =>  $id_usu,
                ':fecha_pedido' => $fecha,
                ':nomb_cliente' => $data['nomb_cliente']
            );
            
            error_log("pc2 - Ejecutando stored procedure con parámetros: " . print_r($arrayParam, true));
            
            $st = $this->db->prepare($consulta);
            
            // Ejecutar y capturar errores
            $execResult = $st->execute($arrayParam);
            error_log("pc2 - Execute result: " . ($execResult ? 'true' : 'false'));
            
            if(!$execResult) {
                $errorInfo = $st->errorInfo();
                error_log("pc2 - PDO Error: " . print_r($errorInfo, true));
                return array('fil' => 0, 'error' => 'Error al ejecutar stored procedure', 'message' => $errorInfo[2]);
            }
            
            // Obtener todos los resultados (puede haber múltiples result sets)
            $allResults = $st->fetchAll(PDO::FETCH_ASSOC);
            error_log("pc2 - Todos los resultados (fetchAll): " . print_r($allResults, true));
            error_log("pc2 - Número de resultados: " . count($allResults));
            
            // Si hay resultados, tomar el primero
            if(!empty($allResults) && count($allResults) > 0) {
                $row = $allResults[0];
                error_log("pc2 - Primer resultado de fetchAll: " . print_r($row, true));
            } else {
                // Si no hay resultados con fetchAll, intentar con fetch individual
                $row = $st->fetch(PDO::FETCH_ASSOC);
                error_log("pc2 - Resultado de fetch individual: " . print_r($row, true));
            }
            
            error_log("pc2 - Resultado final del stored procedure: " . print_r($row, true));
            
            // Si el resultado está vacío, retornar error
            if(empty($row) || !isset($row['fil'])) {
                error_log("pc2 - ERROR: Resultado vacío o sin campo 'fil'. Campos disponibles: " . (is_array($row) ? implode(', ', array_keys($row)) : 'no es array'));
                return array('fil' => 0, 'error' => 'El stored procedure no retornó datos válidos', 'message' => 'El resultado no contiene el campo "fil" requerido');
            }

            return $row;
        } catch (Exception $e) 
        {
            error_log("pc2 - EXCEPCIÓN: " . $e->getMessage());
            error_log("pc2 - Stack trace: " . $e->getTraceAsString());
            return array('fil' => 0, 'error' => 'Error en el servidor', 'message' => $e->getMessage());
        }
    }

    public function pc3($data)
    {
        try
        {
            date_default_timezone_set($_SESSION["zona_horaria"]);
            setlocale(LC_ALL,"es_ES@euro","es_ES","esp");
            $fecha = date("Y-m-d H:i:s");
            $id_usu = Session::get('usuid');
            if($data['tipo_entrega'] == 1){ 
                // $id_repartidor = $data['id_repartidor'];
                $id_repartidor = '9999';
                $direccion_cliente = $data['direccion_cliente'];
                $referencia_cliente = $data['referencia_cliente'];
            } else { 
                $id_repartidor = 1;
                $direccion_cliente = '';
                $referencia_cliente = '';
            };
            $consulta = "call usp_restRegDelivery( :flag, :tipo_canal, :id_tipo_pedido, :id_apc, :id_usu, :fecha_pedido, :id_cliente, :id_repartidor, :tipo_entrega, :tipo_pago, :pedido_programado, :hora_entrega, :nombre_cliente, :telefono_cliente, :direccion_cliente, :referencia_cliente, :email_cliente);";
            $arrayParam =  array(
                ':flag' => 1,
                ':tipo_canal' => 1,
                ':id_tipo_pedido' => 3,
                ':id_apc' => Session::get('apcid'),
                ':id_usu' =>  $id_usu,
                ':fecha_pedido' => $fecha,
                ':id_cliente' => $data['cliente_id'],
                ':id_repartidor' => $id_repartidor,
                ':tipo_entrega' => $data['tipo_entrega'],
                ':tipo_pago' => 1,
                ':pedido_programado' => $data['pedido_programado'],
                ':hora_entrega' => $data['hora_entrega'],
                ':nombre_cliente' => $data['nomb_cliente'],
                ':telefono_cliente' => $data['telefono_cliente'],
                ':direccion_cliente' => $direccion_cliente,
                ':referencia_cliente' => $referencia_cliente,
                ':email_cliente' => 'example@email.com'
            );
            $st = $this->db->prepare($consulta);
            $st->execute($arrayParam);
            $row = $st->fetch(PDO::FETCH_ASSOC);
            return $row;
        } catch (Exception $e) 
        {
            die($e->getMessage());
        }
    }

    public function pc4($data)
    {
        try
        {
            date_default_timezone_set($_SESSION["zona_horaria"]);
            setlocale(LC_ALL,"es_ES@euro","es_ES","esp");
            $fecha = date("Y-m-d H:i:s");
            $id_usu = Session::get('usuid');

            $tipo_entrega       = '1';
            
            // Esto es necesario descomentar cuando sea un cliente antiguo en base al $cliente_id que se tiene en la db de tm_cliente
            /*
            if($data['app_delivery'] == 1){ // Rappi

                $id_repartidor      = '2222'; // rappi
                $tipo_pago          = '1'; // Rappi
                $nomb_cliente       = 'CLIENTE RAPPI';
                $cliente_id         = '10000';
                $direccion_cliente  = 'S/DIRECCION';
                $referencia_cliente = '';
                $telefono_cliente   = '0';

            }
            else if ($data['app_delivery'] == 2) { // Pedidos Ya

                $id_repartidor      = '5555';
                $tipo_pago          = '1'; // PediidosYa
                $cliente_id         = '10001';
                $nomb_cliente       = 'CLIENTE PEDIDOS YA';
                $direccion_cliente  = 'S/DIRECCION';
                $referencia_cliente = '';
                $telefono_cliente   = '0';

            }
            else if ($data['app_delivery'] == 3) { // Llama FOOD

                $id_repartidor      = '1995';
                $tipo_pago          = '1'; // Llama FOOD
                $cliente_id         = '10002';
                $nomb_cliente       = 'CLIENTE LLAMA FOOD';
                $direccion_cliente  = 'S/DIRECCION';
                $referencia_cliente = '';
                $telefono_cliente   = '0';

            } 
            else if ($data['app_delivery'] == 3) { // UBER

                $id_repartidor      = '3333';
                $tipo_pago          = '1'; // UBER
                $cliente_id         = '10003';
                $nomb_cliente       = 'CLIENTE UBER';
                $direccion_cliente  = 'S/DIRECCION';
                $referencia_cliente = '';
                $telefono_cliente   = '0';

            } 
            else if ($data['app_delivery'] == 3) { // GLOVO

                $id_repartidor      = '4444';
                $tipo_pago          = '1'; // GLOVO
                $cliente_id         = '10004';
                $nomb_cliente       = 'CLIENTE GLOVO';
                $direccion_cliente  = 'S/DIRECCION';
                $referencia_cliente = '';
                $telefono_cliente   = '0';

            } 
            */
            
            if($data['app_delivery'] == 1){ // Rappi

                $id_repartidor      = '2222'; // rappi
                $tipo_pago          = '1'; // Rappi
                $nomb_cliente       = 'CLIENTE RAPPI';
                $cliente_id         = '2';
                $direccion_cliente  = 'S/DIRECCION';
                $referencia_cliente = '';
                $telefono_cliente   = '0';

            }
            else if ($data['app_delivery'] == 2) { // Pedidos Ya

                $id_repartidor      = '5555';
                $tipo_pago          = '1'; // PediidosYa
                $cliente_id         = '3';
                $nomb_cliente       = 'CLIENTE PEDIDOS YA';
                $direccion_cliente  = 'S/DIRECCION';
                $referencia_cliente = '';
                $telefono_cliente   = '0';

            }
            else if ($data['app_delivery'] == 3) { // Llama FOOD

                $id_repartidor      = '1995';
                $tipo_pago          = '1'; // Llama FOOD
                $cliente_id         = '4';
                $nomb_cliente       = 'CLIENTE LLAMA FOOD';
                $direccion_cliente  = 'S/DIRECCION';
                $referencia_cliente = '';
                $telefono_cliente   = '0';

            } 
            else if ($data['app_delivery'] == 4) { // UBER

                $id_repartidor      = '3333';
                $tipo_pago          = '1'; // UBER
                $cliente_id         = '5';
                $nomb_cliente       = 'CLIENTE UBER';
                $direccion_cliente  = 'S/DIRECCION';
                $referencia_cliente = '';
                $telefono_cliente   = '0';

            } 
            else if ($data['app_delivery'] == 5) { // GLOVO

                $id_repartidor      = '4444';
                $tipo_pago          = '1'; // GLOVO
                $cliente_id         = '6';
                $nomb_cliente       = 'CLIENTE GLOVO';
                $direccion_cliente  = 'S/DIRECCION';
                $referencia_cliente = '';
                $telefono_cliente   = '0';

            }             

            $consulta = "call usp_restRegDelivery( :flag, :tipo_canal, :id_tipo_pedido, :id_apc, :id_usu, :fecha_pedido, :id_cliente, :id_repartidor, :tipo_entrega, :tipo_pago, :pedido_programado, :hora_entrega, :nombre_cliente, :telefono_cliente, :direccion_cliente, :referencia_cliente, :email_cliente);";
            $arrayParam =  array(
                ':flag' => 1,
                ':tipo_canal' => 1,
                ':id_tipo_pedido' => 3,
                ':id_apc' => Session::get('apcid'),
                ':id_usu' =>  $id_usu,
                ':fecha_pedido' => $fecha,
                ':id_cliente' => $cliente_id,
                ':id_repartidor' => $id_repartidor,
                ':tipo_entrega' => $tipo_entrega,
                ':tipo_pago' => $tipo_pago,
                ':pedido_programado' => '',
                ':hora_entrega' => '',
                ':nombre_cliente' => $nomb_cliente,
                ':telefono_cliente' => $telefono_cliente,
                ':direccion_cliente' => $direccion_cliente,
                ':referencia_cliente' => $referencia_cliente,
                ':email_cliente' => 'example@email.com'
            );
            $st = $this->db->prepare($consulta);
            $st->execute($arrayParam);
            $row = $st->fetch(PDO::FETCH_ASSOC);
            return $row;
        } catch (Exception $e) 
        {
            die($e->getMessage());
        }
    }


     public function defaultdata($data)
    {
        try
        {   
            if($data['tipo_pedido'] == 1)
            { $tabla = 'v_pedido_mesa'; } 
            elseif($data['tipo_pedido'] == 2) 
            { $tabla = 'v_pedido_llevar'; } 
            elseif($data['tipo_pedido'] == 3) 
            { $tabla = 'v_pedido_delivery'; }
            
            $stm = $this->db->prepare("SELECT * FROM ".$tabla." WHERE id_pedido = ?");
            $stm->execute(array($data['id_pedido']));
            $c = $stm->fetch(PDO::FETCH_OBJ);
            if (isset($c->id_cliente) && $c->id_cliente) {
                try {
                    $stc = $this->db->prepare("SELECT tipo_contribuyente FROM tm_cliente WHERE id_cliente = ?");
                    $stc->execute(array($c->id_cliente));
                    $row = $stc->fetch(PDO::FETCH_OBJ);
                    $c->tipo_contribuyente = ($row && isset($row->tipo_contribuyente) && in_array($row->tipo_contribuyente, array('01','02','03'), true)) ? $row->tipo_contribuyente : '02';
                } catch (Exception $e) {
                    $c->tipo_contribuyente = '02';
                }
            }
            /* Traemos el detalle */
            $c->{'Detalle'} = $this->db->query("SELECT SUM(cantidad) AS cantidad, precio, comentario, estado FROM tm_detalle_pedido WHERE id_pedido = ".$c->id_pedido." AND estado <> 'z' GROUP BY id_pres,precio ORDER BY fecha_pedido DESC")
                ->fetchAll(PDO::FETCH_OBJ);
            return $c;
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function listarCategorias($data)
    {
        try
        {   
            if ($data['codtipoped'] == 3){
                $variable = ' ORDER BY orden ASC';
                //$variable = 'AND delivery = 1';
            } else {
                $variable = ' ORDER BY orden ASC';
            }
            $stm = $this->db->prepare("SELECT * FROM tm_producto_catg WHERE estado = 'a' ".$variable);
            $stm->execute();
            $c = $stm->fetchAll(PDO::FETCH_OBJ);
            return $c;
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }
    
    public function listarProductos($data)
    {
        try
        {   
            if ($data['codtipoped'] == 3){
                if($data['codrepartidor'] == 1){
                    $campo = ',pro_cos';
                    $variable = 'ORDER BY ordenins asc';
                }else{
                    if ($data['codprecioapp'] == 1) {
                        $campo = ',pro_cos_del_app AS pro_cos';
                        $variable = ' AND pro_cos_del_app >= 0 ORDER BY ordenins asc';
                    }else {
                        $campo = ',pro_cos_del AS pro_cos';
                        $variable = ' AND pro_cos_del >= 0 ORDER BY ordenins asc';
    
                    }
                }
            } elseif($data['codtipoped'] == 2){
                // echo 'sss';
                $campo = ', IF(pro_cos_lle > 0, pro_cos_lle, pro_cos) AS pro_cos';
                $variable = 'ORDER BY ordenins asc';
            } else {
                $campo = ',pro_cos';
                $variable = 'ORDER BY ordenins asc';
            }
            $stm = $this->db->prepare("SELECT id_areap,id_pres,pro_cat,pro_nom,pro_pre".$campo.",pro_img,pro_toppings FROM v_productos WHERE id_catg = ? AND est_a = 'a'  AND est_b = 'a' AND est_c = 'a' ".$variable);
            $stm->execute(array($data['id_catg']));
            $c = $stm->fetchAll(PDO::FETCH_OBJ);
            foreach($c as $k => $d)
            {
                $c[$k]->{'Impresora'} = $this->db->query("SELECT i.nombre, ap.nombre as area FROM tm_area_prod AS ap INNER JOIN tm_impresora AS i ON ap.id_imp = i.id_imp WHERE ap.id_areap = " . $d->id_areap)
                ->fetch(PDO::FETCH_OBJ);
            }
            return $c;
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function listarProdsMasVend($data)
    {
        try
        {   
            if ($data['codtipoped'] == 3){
                if($data['codrepartidor'] == 1){
                    $campo = ',p.pro_cos';
                    $variable = 'GROUP BY dv.id_prod ORDER BY SUM(cantidad) DESC';
                } else{
                    if ($data['codprecioapp'] == 1) {
                        $campo = ',pro_cos_del_app AS pro_cos';
                        $variable = ' AND p.pro_cos_del >= 0 GROUP BY dv.id_prod ORDER BY SUM(cantidad) DESC';
                    }else {
                        $campo = ',p.pro_cos_del AS pro_cos';
                        $variable = ' AND p.pro_cos_del >= 0 GROUP BY dv.id_prod ORDER BY SUM(cantidad) DESC';
                    }
                }
            } elseif($data['codtipoped'] == 2){
                // echo 'sss';
                $campo = ', IF(pro_cos_lle > 0, pro_cos_lle, pro_cos) AS pro_cos';
                $variable = 'GROUP BY dv.id_prod ORDER BY SUM(cantidad) DESC';
            } else {
                $campo = ',p.pro_cos';
                $variable = 'GROUP BY dv.id_prod ORDER BY SUM(cantidad) DESC';
            }
            $stm = $this->db->prepare("SELECT p.id_areap,p.id_pres,p.pro_cat,p.pro_nom,p.pro_pre".$campo.",p.pro_img,p.pro_toppings FROM tm_detalle_venta AS dv INNER JOIN v_productos AS p ON dv.id_prod = p.id_pres WHERE p.est_a = 'a' AND p.est_b = 'a' AND p.est_c = 'a' ".$variable);
            $stm->execute();
            $c = $stm->fetchAll(PDO::FETCH_OBJ);
            foreach($c as $k => $d)
            {
                $c[$k]->{'Impresora'} = $this->db->query("SELECT i.nombre,ap.nombre as area FROM tm_area_prod AS ap INNER JOIN tm_impresora AS i ON ap.id_imp = i.id_imp WHERE ap.id_areap = " . $d->id_areap)
                ->fetch(PDO::FETCH_OBJ);
            }
            return $c;
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function RegistrarPedido($data)
    {
        try 
        {
            date_default_timezone_set($_SESSION["zona_horaria"]);
            setlocale(LC_ALL,"es_ES@euro","es_ES","esp");
            $fecha = date("Y-m-d H:i:s");
            $id_usu = Session::get('usuid');
            $key = md5(uniqid(rand(), true));
            if($data['codtipoped'] == 3){ 
                $estado = 'y';
            } else {
                $estado = 'a';
            } 
            foreach($data['items'] as $d)
            {

                $toppings = '';

                if ($d['toppings'] == 1 && isset($d['toppings_descripcion']) && !empty($d['toppings_descripcion'])) {
                        
                    $desc_array = explode("=", $d['toppings_descripcion']);
                    $precio_array = explode("=", $d['toppings_precio']);
                    $todas_las_toppings = array();  
                    for ($i = 0; $i < count($desc_array); $i++) {
                        $todas_las_toppings[$desc_array[$i]] = $precio_array[$i];
                    }    
                    $toppings = json_encode($todas_las_toppings);
                }
                $sql = "INSERT INTO tm_detalle_pedido (id_pedido, id_usu, id_pres, cantidad, cant, precio, comentario, fecha_pedido, toppings, estado) VALUES (?,?,?,?,?,?,?,?,?,?);";

                $this->db->prepare($sql)->execute(array($data['cod_ped'],$id_usu,$d['producto_id'],$d['cantidad'],$d['cantidad'],$d['precio'],$d['comentario'],$fecha,$toppings,$estado));                                

            }
            $sql2 = "INSERT INTO tm_comandas (id_pedido, fecha_pedido, id_key) VALUES (?,?,?) ;";
            $this->db->prepare($sql2)->execute(array($data['cod_ped'],$fecha,$key));
        }
        catch (Exception $e) 
        {
            return false;
        }
    }

    public function buscar_producto($data)
    {
        try
        {   
            // if ($data['codtipoped'] == 3){
            //     if($data['codrepartidor'] == 1){
            //         $campo = ',pro_cos';
            //     } else{
            //         $campo = ',pro_cos_del AS pro_cos';
            //     }
            //     $variable = 'AND del_a = 1 AND del_b = 1 AND del_c = 1';

            if ($data['codtipoped'] == 3){
                if($data['codrepartidor'] == 1){
                    $campo = ',pro_cos';
                    $variable = 'AND del_a = 1 AND del_b = 1 AND del_c = 1 ORDER BY ordenins asc';
                }else{
                    if ($data['codprecioapp'] == 1) {
                        $campo = ',pro_cos_del_app AS pro_cos';
                        $variable = 'AND del_a = 1 AND del_b = 1 AND del_c = 1 AND pro_cos_del_app > 0 ORDER BY ordenins asc';
                    }else {
                        $campo = ',pro_cos_del AS pro_cos';
                        $variable = 'AND del_a = 1 AND del_b = 1 AND del_c = 1 AND pro_cos_del > 0 ORDER BY ordenins asc';
    
                    }
                }
              
                



            } elseif($data['codtipoped'] == 2){
                // echo 'sss';
                $campo = ', IF(pro_cos_lle > 0, pro_cos_lle, pro_cos) AS pro_cos';
                $variable = '';
            } else {
                $variable = '';
                $campo = ',pro_cos';
            }
            $cadena = $data['cadena'];

            $stm = $this->db->prepare("SELECT id_areap,id_pres,pro_cat,pro_nom,pro_pre".$campo.",pro_img,pro_toppings FROM v_productos WHERE (pro_cod LIKE '%$cadena%' OR pro_nom LIKE '%$cadena%' OR pro_cat LIKE '%$cadena%'  OR pro_pre LIKE '%$cadena%') AND est_a = 'a' AND est_b = 'a' AND est_c = 'a' ".$variable);
            $stm->execute();
            $c = $stm->fetchAll(PDO::FETCH_OBJ);
            foreach($c as $k => $d)
            {
                $c[$k]->{'Impresora'} = $this->db->query("SELECT i.nombre, ap.nombre as area FROM tm_area_prod AS ap INNER JOIN tm_impresora AS i ON ap.id_imp = i.id_imp WHERE ap.id_areap = " . $d->id_areap)
                ->fetch(PDO::FETCH_OBJ);
            }
            return $c;
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function ListarDetallePed($data)
    {
        try
        {   
            if($data['tipo_pedido'] == 1){ $tabla = 'v_pedido_mesa'; } elseif($data['tipo_pedido'] == 2) { $tabla = 'v_pedido_llevar'; } elseif($data['tipo_pedido'] == 3) { $tabla = 'v_pedido_delivery'; }
            $stm = $this->db->prepare("SELECT id_pedido FROM ".$tabla." WHERE id_pedido = ?");
            $stm->execute(array($data['id_pedido']));
            $c = $stm->fetch(PDO::FETCH_OBJ);

            // $c->{'Detalle'} = $this->db->query("SELECT dp.id_pres,SUM(dp.cantidad) AS cantidad, dp.precio, pp.costo_unitario, dp.estado FROM tm_detalle_pedido AS dp INNER JOIN tm_producto_pres AS pp ON dp.id_pres = pp.id_pres WHERE dp.id_pedido = ".$c->id_pedido." AND dp.estado <> 'z' GROUP BY dp.id_pres, dp.precio")

            try {
                $c->{'Detalle'} = $this->db->query("SELECT dp.id_pres, SUM(dp.cantidad) AS cantidad, dp.precio, pp.costo_unitario, dp.estado, dp.toppings, COALESCE(MAX(dp.nombre_precuenta),'') AS nombre_precuenta FROM tm_detalle_pedido AS dp INNER JOIN tm_producto_pres AS pp ON dp.id_pres = pp.id_pres WHERE dp.id_pedido = ".$c->id_pedido." AND dp.estado <> 'z' GROUP BY dp.id_pres, dp.precio, CASE WHEN dp.toppings IS NOT NULL THEN dp.toppings ELSE '' END, COALESCE(dp.nombre_precuenta,'')")->fetchAll(PDO::FETCH_OBJ);
            } catch (Exception $e) {
                $c->{'Detalle'} = $this->db->query("SELECT dp.id_pres, SUM(dp.cantidad) AS cantidad, dp.precio, pp.costo_unitario, dp.estado, dp.toppings FROM tm_detalle_pedido AS dp INNER JOIN tm_producto_pres AS pp ON dp.id_pres = pp.id_pres WHERE dp.id_pedido = ".$c->id_pedido." AND dp.estado <> 'z' GROUP BY dp.id_pres, dp.precio, CASE WHEN dp.toppings IS NOT NULL THEN dp.toppings ELSE '' END")->fetchAll(PDO::FETCH_OBJ);
                foreach ($c->Detalle as $k => $d) { $c->Detalle[$k]->{'nombre_precuenta'} = ''; }
            }
            foreach($c->Detalle as $k => $d)
            {
                $c->Detalle[$k]->{'toppings'} = json_decode($d->toppings, true);
                $c->Detalle[$k]->{'Producto'} = $this->db->query("SELECT pro_nom, pro_pre FROM v_productos WHERE id_pres = " . $d->id_pres)
                    ->fetch(PDO::FETCH_OBJ);
                if (!isset($c->Detalle[$k]->{'nombre_precuenta'})) $c->Detalle[$k]->{'nombre_precuenta'} = '';
            }
            try {
                $c->{'FacturacionDividida'} = $this->getFacturacionDivididaData($c->id_pedido);
            } catch (Exception $e) {
                $c->{'FacturacionDividida'} = (object)array();
            }
            return $c;
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    /**
     * Datos de facturación por precuenta (cliente, tipo doc, serie) para mostrar en cabeceras.
     * Retorna objeto keyed por nombre_precuenta: { nombre_cliente, id_tipo_doc, tipo_doc_nombre, serie }
     */
    public function getFacturacionDivididaData($id_pedido)
    {
        try {
            $stm = $this->db->prepare("SELECT f.nombre_precuenta, f.id_cliente, f.id_tipo_doc, c.nombre AS nombre_cliente, td.descripcion AS tipo_doc_nombre, td.serie FROM tm_pedido_precuenta_facturacion f LEFT JOIN v_clientes c ON f.id_cliente = c.id_cliente LEFT JOIN tm_tipo_doc td ON f.id_tipo_doc = td.id_tipo_doc WHERE f.id_pedido = ?");
            $stm->execute(array($id_pedido));
            $rows = $stm->fetchAll(PDO::FETCH_OBJ);
            $out = (object)array();
            foreach ($rows as $r) {
                $out->{$r->nombre_precuenta} = array(
                    'id_cliente' => (int)$r->id_cliente,
                    'id_tipo_doc' => (int)$r->id_tipo_doc,
                    'nombre_cliente' => $r->nombre_cliente ? $r->nombre_cliente : '',
                    'tipo_doc_nombre' => $r->tipo_doc_nombre ? $r->tipo_doc_nombre : '',
                    'serie' => $r->serie ? $r->serie : ''
                );
            }
            return $out;
        } catch (Exception $e) {
            return (object)array();
        }
    }

    /**
     * Lista de facturación por precuenta para el modal (id_cliente, id_tipo_doc, nombre_cliente, tipo_doc_nombre, serie).
     */
    public function getFacturacionDividida($id_pedido)
    {
        try {
            $stm = $this->db->prepare("SELECT f.nombre_precuenta, f.id_cliente, f.id_tipo_doc, c.nombre AS nombre_cliente, td.descripcion AS tipo_doc_nombre, td.serie FROM tm_pedido_precuenta_facturacion f LEFT JOIN v_clientes c ON f.id_cliente = c.id_cliente LEFT JOIN tm_tipo_doc td ON f.id_tipo_doc = td.id_tipo_doc WHERE f.id_pedido = ? ORDER BY f.nombre_precuenta");
            $stm->execute(array($id_pedido));
            return $stm->fetchAll(PDO::FETCH_OBJ);
        } catch (Exception $e) {
            return array();
        }
    }

    /**
     * Guardar asignación cliente + tipo doc por precuenta. $items = array( array('nombre_precuenta'=>'Mesa A','id_cliente'=>1,'id_tipo_doc'=>1) )
     */
    public function guardarFacturacionDividida($id_pedido, $items)
    {
        try {
            $this->db->prepare("DELETE FROM tm_pedido_precuenta_facturacion WHERE id_pedido = ?")->execute(array($id_pedido));
            $stm = $this->db->prepare("INSERT INTO tm_pedido_precuenta_facturacion (id_pedido, nombre_precuenta, id_cliente, id_tipo_doc) VALUES (?, ?, ?, ?)");
            foreach ($items as $it) {
                $nombre = isset($it['nombre_precuenta']) ? trim($it['nombre_precuenta']) : '';
                $id_cliente = isset($it['id_cliente']) ? (int)$it['id_cliente'] : 1;
                $id_tipo_doc = isset($it['id_tipo_doc']) ? (int)$it['id_tipo_doc'] : 0;
                if ($nombre === '' || $id_tipo_doc <= 0) continue;
                $stm->execute(array($id_pedido, $nombre, $id_cliente, $id_tipo_doc));
            }
            return true;
        } catch (Exception $e) {
            return false;
        }
    }

    /**
     * Detalle del pedido para el modal dividir precuenta (id_pres, cantidad, precio, toppings, Producto).
     * Misma lógica que ListarDetallePed: cantidad y GROUP BY id_pres, precio, toppings.
     */
    public function getDetalleParaDividirPrecuenta($id_pedido)
    {
        try {
            $sql = "SELECT dp.id_pres, SUM(dp.cantidad) AS cantidad, dp.precio, dp.toppings
                    FROM tm_detalle_pedido dp
                    WHERE dp.id_pedido = ? AND dp.estado <> 'z'
                    GROUP BY dp.id_pres, dp.precio, CASE WHEN dp.toppings IS NOT NULL THEN dp.toppings ELSE '' END
                    ORDER BY dp.fecha_pedido DESC";
            $stm = $this->db->prepare($sql);
            $stm->execute(array($id_pedido));
            $rows = $stm->fetchAll(PDO::FETCH_OBJ);
            foreach ($rows as $k => $d) {
                $rows[$k]->{'Producto'} = $this->db->query("SELECT pro_nom, pro_pre FROM v_productos WHERE id_pres = " . (int)$d->id_pres)->fetch(PDO::FETCH_OBJ);
                $rows[$k]->{'toppings_raw'} = $d->toppings === null ? '' : $d->toppings;
                $rows[$k]->{'toppings'} = json_decode($d->toppings, true);
            }
            return $rows;
        } catch (Exception $e) {
            return array();
        }
    }

    /**
     * Guardar división de precuenta: asigna nombre_precuenta a ítems por (id_pedido, id_pres, precio, toppings).
     * $grupos = array( array('nombre'=>'Mesa A', 'items'=>array(array('id_pres'=>1,'precio'=>10,'toppings'=>''))) )
     */
    public function guardarDividirPrecuenta($id_pedido, $grupos)
    {
        $log_file = __DIR__ . '/../log_guardar_precuenta.log';
        @file_put_contents($log_file, date('Y-m-d H:i:s') . " guardarDividirPrecuenta INICIO id_pedido=" . $id_pedido . " grupos=" . json_encode($grupos) . "\n", FILE_APPEND);
        try {
            // Limpiar todas las asignaciones primero
            $this->db->prepare("UPDATE tm_detalle_pedido SET nombre_precuenta = NULL WHERE id_pedido = ?")
                ->execute(array($id_pedido));
            
            $total_items_asignados = 0;
            foreach ($grupos as $grupo) {
                $nombre = isset($grupo['nombre']) ? trim($grupo['nombre']) : '';
                if ($nombre === '') {
                    @file_put_contents($log_file, date('Y-m-d H:i:s') . " guardarDividirPrecuenta: grupo sin nombre, saltando\n", FILE_APPEND);
                    continue;
                }
                $items = isset($grupo['items']) ? $grupo['items'] : array();
                @file_put_contents($log_file, date('Y-m-d H:i:s') . " guardarDividirPrecuenta: procesando grupo nombre=" . $nombre . " items=" . count($items) . "\n", FILE_APPEND);
                
                foreach ($items as $it) {
                    $id_pres = (int)(isset($it['id_pres']) ? $it['id_pres'] : 0);
                    $precio_raw = isset($it['precio']) ? $it['precio'] : '0';
                    // Normalizar precio: convertir a float y luego a string con punto decimal
                    $precio = str_replace(',', '.', $precio_raw);
                    $precio = is_numeric($precio) ? (string)floatval($precio) : '0';
                    $toppings = isset($it['toppings']) ? trim($it['toppings']) : '';
                    $toppings_normalized = ($toppings === null || $toppings === '') ? '' : $toppings;
                    
                    if ($id_pres <= 0) {
                        @file_put_contents($log_file, date('Y-m-d H:i:s') . " guardarDividirPrecuenta: item con id_pres inválido, saltando\n", FILE_APPEND);
                        continue;
                    }
                    
                    @file_put_contents($log_file, date('Y-m-d H:i:s') . " guardarDividirPrecuenta: asignando item id_pres=" . $id_pres . " precio=" . $precio . " toppings=" . $toppings_normalized . " a precuenta=" . $nombre . "\n", FILE_APPEND);
                    
                    // Usar UPDATE con condición más flexible para manejar variaciones en precio/toppings
                    $stm = $this->db->prepare("UPDATE tm_detalle_pedido SET nombre_precuenta = ? WHERE id_pedido = ? AND id_pres = ? AND ABS(CAST(precio AS DECIMAL(10,2)) - CAST(? AS DECIMAL(10,2))) < 0.01 AND (COALESCE(toppings,'') = ? OR (toppings IS NULL AND ? = ''))");
                    $result = $stm->execute(array($nombre, $id_pedido, $id_pres, $precio, $toppings_normalized, $toppings_normalized));
                    $rows_affected = $stm->rowCount();
                    
                    if ($rows_affected > 0) {
                        $total_items_asignados += $rows_affected;
                        @file_put_contents($log_file, date('Y-m-d H:i:s') . " guardarDividirPrecuenta: item asignado correctamente (rows=" . $rows_affected . ")\n", FILE_APPEND);
                    } else {
                        @file_put_contents($log_file, date('Y-m-d H:i:s') . " guardarDividirPrecuenta: WARNING - ningún registro actualizado para id_pres=" . $id_pres . " precio=" . $precio . "\n", FILE_APPEND);
                    }
                }
            }
            
            @file_put_contents($log_file, date('Y-m-d H:i:s') . " guardarDividirPrecuenta FIN: total_items_asignados=" . $total_items_asignados . "\n", FILE_APPEND);
            return true;
        } catch (Exception $e) {
            @file_put_contents($log_file, date('Y-m-d H:i:s') . " guardarDividirPrecuenta ERROR: " . $e->getMessage() . "\n", FILE_APPEND);
            return false;
        }
    }

    /**
     * Asignar o quitar un item individual a/de una precuenta.
     * Si nombre_precuenta es null o vacío, se quita la asignación.
     */
    public function asignarItemPrecuenta($id_pedido, $id_pres, $precio, $toppings, $nombre_precuenta)
    {
        try {
            $precio = str_replace(',', '.', $precio);
            $toppings = ($toppings === null || $toppings === '') ? '' : $toppings;
            $nombre_precuenta = ($nombre_precuenta === null || trim($nombre_precuenta) === '') ? null : trim($nombre_precuenta);
            
            $stm = $this->db->prepare("UPDATE tm_detalle_pedido SET nombre_precuenta = ? WHERE id_pedido = ? AND id_pres = ? AND precio = ? AND (COALESCE(toppings,'') = ?)");
            $stm->execute(array($nombre_precuenta, $id_pedido, $id_pres, $precio, $toppings));
            
            return true;
        } catch (Exception $e) {
            return false;
        }
    }

    /** Indica si el pedido tiene precuenta dividida (algún ítem con nombre_precuenta). */
    public function tienePrecuentaDividida($id_pedido)
    {
        try {
            $stm = $this->db->prepare("SELECT 1 FROM tm_detalle_pedido WHERE id_pedido = ? AND estado <> 'z' AND nombre_precuenta IS NOT NULL AND TRIM(nombre_precuenta) <> '' LIMIT 1");
            $stm->execute(array($id_pedido));
            return $stm->fetch() !== false;
        } catch (Exception $e) {
            return false;
        }
    }

    /** Lista de nombres de grupos (precuentas) del pedido para imprimir dividida. */
    public function getGruposPrecuenta($id_pedido)
    {
        try {
            $stm = $this->db->prepare("SELECT DISTINCT nombre_precuenta FROM tm_detalle_pedido WHERE id_pedido = ? AND estado <> 'z' AND nombre_precuenta IS NOT NULL AND TRIM(nombre_precuenta) <> '' ORDER BY nombre_precuenta");
            $stm->execute(array($id_pedido));
            return $stm->fetchAll(PDO::FETCH_COLUMN);
        } catch (Exception $e) {
            return array();
        }
    }

    /** División actual: ítems sin asignar y precuentas con sus ítems (para VER DIVISIÓN). */
    public function getDivisionPrecuenta($id_pedido)
    {
        try {
            $sql = "SELECT dp.id_pres, SUM(dp.cantidad) AS cantidad, dp.precio, dp.toppings, COALESCE(MAX(dp.nombre_precuenta),'') AS nombre_precuenta
                    FROM tm_detalle_pedido dp
                    WHERE dp.id_pedido = ? AND dp.estado <> 'z'
                    GROUP BY dp.id_pres, dp.precio, CASE WHEN dp.toppings IS NOT NULL THEN dp.toppings ELSE '' END, COALESCE(dp.nombre_precuenta,'')
                    ORDER BY dp.fecha_pedido DESC";
            $stm = $this->db->prepare($sql);
            $stm->execute(array($id_pedido));
            $rows = $stm->fetchAll(PDO::FETCH_OBJ);
            $items_sin_asignar = array();
            $by_precuenta = array();
            foreach ($rows as $d) {
                $d->{'Producto'} = $this->db->query("SELECT pro_nom, pro_pre FROM v_productos WHERE id_pres = " . (int)$d->id_pres)->fetch(PDO::FETCH_OBJ);
                $d->{'toppings_raw'} = $d->toppings === null ? '' : $d->toppings;
                $d->{'toppings'} = json_decode($d->toppings, true);
                if ($d->nombre_precuenta === '') {
                    $items_sin_asignar[] = $d;
                } else {
                    if (!isset($by_precuenta[$d->nombre_precuenta])) $by_precuenta[$d->nombre_precuenta] = array('nombre' => $d->nombre_precuenta, 'items' => array());
                    $by_precuenta[$d->nombre_precuenta]['items'][] = $d;
                }
            }
            return array('items_sin_asignar' => $items_sin_asignar, 'precuentas' => array_values($by_precuenta));
        } catch (Exception $e) {
            return array('items_sin_asignar' => array(), 'precuentas' => array());
        }
    }

    public function cliente_crud_create($data)
    {
        try 
        {
            $fechaNac = isset($data['fecha_nac']) && trim($data['fecha_nac']) !== ''
                ? date('Y-m-d', strtotime($data['fecha_nac']))
                : null;
            // SP con 13 parámetros (incluye tipo_contribuyente). Si tu SP tiene 12, usa database/usp_restRegCliente_con_tipo_contribuyente.sql
            $tc = $this->normalizarTipoContribuyente(isset($data['tipo_contribuyente']) ? $data['tipo_contribuyente'] : '');
            $consulta = "call usp_restRegCliente( :flag, @a, :tipo_cliente, :dni, :ruc, :nombres, :razon_social, :telefono, :fecha_nac, :correo, :direccion, :referencia, :tipo_contribuyente);";
                $arrayParam =  array(
                    ':flag' => 1,
                    ':tipo_cliente' => $data['tipo_cliente'],
                    ':dni' => isset($data['dni']) ? $data['dni'] : '',
                    ':ruc' => isset($data['ruc']) ? $data['ruc'] : '',
                    ':nombres' => isset($data['nombres']) ? $data['nombres'] : '',
                    ':razon_social' => isset($data['razon_social']) ? $data['razon_social'] : '',
                    ':telefono' => isset($data['telefono']) ? $data['telefono'] : '',
                    ':fecha_nac' => $fechaNac,
                    ':correo' => isset($data['correo']) ? $data['correo'] : '',
                    ':direccion' => isset($data['direccion']) ? $data['direccion'] : '',
                    ':referencia' => isset($data['referencia']) ? $data['referencia'] : '',
                    ':tipo_contribuyente' => $tc
                  );
                $st = $this->db->prepare($consulta);
                $st->execute($arrayParam);
                $c = $st->fetch(PDO::FETCH_OBJ);
                if ($c === false && $st->rowCount() === 0) {
                    $c = (object) array('id_cliente' => $this->db->lastInsertId(), 'cod' => 0);
                }
                $idCliente = isset($c->id_cliente) ? (int)$c->id_cliente : 0;
                // Si el SP devolvió id_cliente 0 pero tenemos RUC, puede ser UPDATE por RUC que no devolvió el id: buscar por RUC
                if ($idCliente <= 0 && !empty($data['ruc'])) {
                    $rucNorm = preg_replace('/\D/', '', trim($data['ruc']));
                    if (strlen($rucNorm) >= 5) {
                        $st2 = $this->db->prepare("SELECT id_cliente FROM tm_cliente WHERE id_cliente != 1 AND REPLACE(REPLACE(REPLACE(TRIM(IFNULL(ruc,'')), '-', ''), ' ', ''), '.', '') = ? LIMIT 1");
                        $st2->execute(array($rucNorm));
                        $row = $st2->fetch(PDO::FETCH_OBJ);
                        if ($row && !empty($row->id_cliente)) {
                            $idCliente = (int)$row->id_cliente;
                            $c->id_cliente = (string)$idCliente;
                        }
                    }
                }
                if ($idCliente <= 0) {
                    $lid = $this->db->lastInsertId();
                    if ($lid) {
                        $idCliente = (int)$lid;
                        if (is_object($c)) $c->id_cliente = (string)$idCliente; else $c = (object) array('id_cliente' => (string)$idCliente, 'cod' => 0);
                    }
                }
                $this->actualizarTipoContribuyenteCliente($idCliente ? $idCliente : null, $data);
                return $c;
            } catch (Exception $e) 
            {
                die($e->getMessage());
            }
    }

    /** Normaliza tipo_contribuyente a 01, 02 o 03 (string). */
    private function normalizarTipoContribuyente($raw)
    {
        if ($raw === '' || $raw === null) return '02';
        $v = is_string($raw) ? $raw : (string)(int)$raw;
        if (strlen($v) === 1 && $v >= '1' && $v <= '3') $v = '0' . $v;
        return in_array($v, array('01','02','03'), true) ? $v : '02';
    }

    /**
     * Actualiza tipo_contribuyente en tm_cliente (FE: 01=Contribuyente, 02=Consumidor Final, 03=Gobierno).
     * Se usa como respaldo si el SP no tiene el parámetro tipo_contribuyente.
     */
    private function actualizarTipoContribuyenteCliente($idCliente, $data)
    {
        if (!$idCliente) return;
        $tc = $this->normalizarTipoContribuyente(isset($data['tipo_contribuyente']) ? $data['tipo_contribuyente'] : '');
        try {
            $st = $this->db->prepare("UPDATE tm_cliente SET tipo_contribuyente = ? WHERE id_cliente = ?");
            $st->execute(array($tc, $idCliente));
            @file_put_contents(__DIR__ . '/../log_guardar_cliente.log', date('Y-m-d H:i:s') . " tipo_contribuyente actualizado: id_cliente=$idCliente, valor=$tc\n", FILE_APPEND);
        } catch (Exception $e) {
            @file_put_contents(__DIR__ . '/../log_guardar_cliente.log', date('Y-m-d H:i:s') . " tipo_contribuyente ERROR: " . $e->getMessage() . "\n", FILE_APPEND);
        }
    }

    public function cliente_crud_update($data)
    {
        try 
        {
            $fechaNac = isset($data['fecha_nac']) && trim($data['fecha_nac']) !== ''
                ? date('Y-m-d', strtotime($data['fecha_nac']))
                : null;
            $tc = $this->normalizarTipoContribuyente(isset($data['tipo_contribuyente']) ? $data['tipo_contribuyente'] : '');
            $consulta = "call usp_restRegCliente( :flag, :id_cliente, :tipo_cliente, :dni, :ruc, :nombres, :razon_social, :telefono, :fecha_nac, :correo, :direccion, :referencia, :tipo_contribuyente);";
                $arrayParam =  array(
                    ':flag' => 2,
                    ':id_cliente' => $data['id_cliente'],
                    ':tipo_cliente' => $data['tipo_cliente'],
                    ':dni' => isset($data['dni']) ? $data['dni'] : '',
                    ':ruc' => isset($data['ruc']) ? $data['ruc'] : '',
                    ':nombres' => isset($data['nombres']) ? $data['nombres'] : '',
                    ':razon_social' => isset($data['razon_social']) ? $data['razon_social'] : '',
                    ':telefono' => isset($data['telefono']) ? $data['telefono'] : '',
                    ':fecha_nac' => $fechaNac,
                    ':correo' => isset($data['correo']) ? $data['correo'] : '',
                    ':direccion' => isset($data['direccion']) ? $data['direccion'] : '',
                    ':referencia' => isset($data['referencia']) ? $data['referencia'] : '',
                    ':tipo_contribuyente' => $tc
                );
            $st = $this->db->prepare($consulta);
            $st->execute($arrayParam);
            $c = $st->fetch(PDO::FETCH_OBJ);
            if ($c === false) {
                $c = (object) array('id_cliente' => $data['id_cliente'], 'cod' => 0);
            }
            $this->actualizarTipoContribuyenteCliente(isset($data['id_cliente']) ? $data['id_cliente'] : null, $data);
            return $c;
        } catch (Exception $e) {
            die($e->getMessage());
        }
    }

    public function buscar_cliente($data)
    {
        try
        {
            $cadena = isset($data['cadena']) ? trim($data['cadena']) : '';
            if ($cadena === '') {
                return array();
            }
            $like = '%' . $cadena . '%';
            // Incluir tipo_contribuyente desde tm_cliente (por si v_clientes no lo tiene)
            $sql = "SELECT v.id_cliente, v.tipo_cliente, v.dni, v.ruc, v.dv, v.nombre, v.razon_social, v.telefono, v.fecha_nac, v.correo, v.direccion, v.referencia, v.ubicacion, v.tipo_ruc, COALESCE(NULLIF(TRIM(t.tipo_contribuyente), ''), '02') AS tipo_contribuyente, v.estado
                FROM v_clientes v
                LEFT JOIN tm_cliente t ON t.id_cliente = v.id_cliente
                WHERE v.estado <> 'i' AND (v.dni LIKE ? OR v.ruc LIKE ? OR v.nombre LIKE ?)
                ORDER BY v.nombre
                LIMIT 20";
            $stm = $this->db->prepare($sql);
            $stm->execute(array($like, $like, $like));
            return $stm->fetchAll(PDO::FETCH_OBJ);
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function buscar_cliente_telefono($data)
    {
        try
        {        
            /*nota: para kerlyn quitar el tipo_cliente de la consulta*/
            $stm = $this->db->prepare("SELECT * FROM v_clientes WHERE estado <> 'i' AND (dni LIKE '%".$data['cadena']."%' OR ruc LIKE '%".$data['cadena']."%' OR telefono LIKE '%".$data['cadena']."%') ORDER BY dni LIMIT 5");
            $stm->execute();
            return $stm->fetchAll(PDO::FETCH_OBJ); 
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function toppings_list($data)
    {
        try
        {
            $stm = $this->db->prepare("SELECT * FROM tm_producto_toppings WHERE id_pres = ?");
            $stm->execute(array($data['id_pres']));
            $c = $stm->fetchAll(PDO::FETCH_OBJ);
            foreach($c as $k => $d)
            {
                $c[$k]->{'Insumo'} = $this->db->query("SELECT ins_med,ins_nom,ins_cat FROM v_insprod WHERE id_tipo_ins = ".$d->id_tipo_ins." AND id_ins = ".$d->id_ins)
                ->fetch(PDO::FETCH_OBJ);
            }
            foreach($c as $k => $d)
            {
                $c[$k]->{'Medida'} = $this->db->query("SELECT descripcion FROM tm_tipo_medida WHERE id_med = ".$d->id_med)
                ->fetch(PDO::FETCH_OBJ);
            }
            return $c;
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }  

    }    

    public function tags_list($data)
    {
        try
        {        
            // $stm = $this->db->prepare("SELECT p.id_prod,p.notas FROM tm_producto AS p INNER JOIN tm_producto_pres AS pp ON p.id_prod = pp.id_prod WHERE pp.id_pres = ?");
            
            $stm = $this->db->prepare("SELECT p.id_prod, CASE WHEN pp.nota = 1 THEN pp.notas ELSE p.notas END AS notas FROM tm_producto AS p INNER JOIN tm_producto_pres AS pp ON p.id_prod = pp.id_prod WHERE pp.id_pres = ?");
            $stm->execute(array($data['id_pres']));
            return $stm->fetch(PDO::FETCH_OBJ); 
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function tags_crud($data)
    {
        try 
        {
            $sql = "UPDATE tm_producto SET notas = ? WHERE id_prod = ?";
            $this->db->prepare($sql)->execute(array($data['notas'],$data['id_prod']));
        }
        catch (Exception $e) 
        {
            return false;
        }
    }

    public function restEmitirVenta($data)
    {
        $log_file = __DIR__ . '/../log_registrar_venta.log';
        @file_put_contents($log_file, date('Y-m-d H:i:s') . " restEmitirVenta INICIO id_pedido=" . (isset($data['id_pedido']) ? $data['id_pedido'] : '?') . "\n", FILE_APPEND);
        try {

            date_default_timezone_set($_SESSION["zona_horaria"]);
            setlocale(LC_ALL,"es_ES@euro","es_ES","esp");
            $fecha = date("Y-m-d H:i:s");

            $tipoDocumento =  $this->TipoDocumento($data['tipo_doc']);
            $conn  = new Database(DB_TYPE, DB_HOST, DB_NAME, DB_USER, DB_PASS, DB_CHARSET);
            
            // Obtener correlativo: usar SELECT FOR UPDATE para evitar que dos ventas obtengan el mismo número
            // Esto asegura que cada venta obtenga un correlativo único incluso si se crean en paralelo
            $conn->beginTransaction();
            try {
                $stm_td = $conn->prepare("SELECT serie, numero AS correlativo FROM tm_tipo_doc WHERE id_tipo_doc = ? FOR UPDATE");
                $stm_td->execute(array($data['tipo_doc']));
                $s_c = $stm_td->fetch(PDO::FETCH_OBJ);
                if (!$s_c) {
                    // Fallback: usar newNumber si no hay registro en tm_tipo_doc
                    $funcions = new Functions();
                    $s_c = $funcions->newNumber($data['tipo_doc'], '#', $tipoDocumento['serie']);
                }
                // Usar el correlativo actual para esta venta
                $correlativo_actual = is_numeric($s_c->correlativo) ? intval($s_c->correlativo) : $s_c->correlativo;
                // Actualizar inmediatamente el siguiente número para que la siguiente venta obtenga el siguiente
                $siguiente = is_numeric($s_c->correlativo) ? (intval($s_c->correlativo) + 1) : $s_c->correlativo;
                $upd_pre = $conn->prepare("UPDATE tm_tipo_doc SET numero = ? WHERE id_tipo_doc = ?");
                $upd_pre->execute(array($siguiente, $data['tipo_doc']));
                $conn->commit();
                @file_put_contents($log_file, date('Y-m-d H:i:s') . " restEmitirVenta correlativo obtenido=" . $correlativo_actual . " siguiente=" . $siguiente . " id_tipo_doc=" . $data['tipo_doc'] . "\n", FILE_APPEND);
                // Usar el correlativo actual (antes del incremento)
                $s_c->correlativo = $correlativo_actual;
            } catch (Exception $e) {
                $conn->rollBack();
                @file_put_contents($log_file, date('Y-m-d H:i:s') . " restEmitirVenta error transacción correlativo: " . $e->getMessage() . "\n", FILE_APPEND);
                // Fallback sin transacción
                $stm_td = $conn->prepare("SELECT serie, numero AS correlativo FROM tm_tipo_doc WHERE id_tipo_doc = ?");
                $stm_td->execute(array($data['tipo_doc']));
                $s_c = $stm_td->fetch(PDO::FETCH_OBJ);
                if (!$s_c) {
                    $funcions = new Functions();
                    $s_c = $funcions->newNumber($data['tipo_doc'], '#', $tipoDocumento['serie']);
                }
            }
        
            $flag = 1;
            $dividir_cuenta = $data['dividir_cuenta'];
            $id_pedido = $data['id_pedido'];
            $tipo_pedido = $data['tipo_pedido'];
            $tipo_entrega = $data['tipo_entrega'];
            $id_cliente = isset($data['cliente_id']) ? intval($data['cliente_id']) : 1;
            $id_tipo_doc = (isset($data['tipo_doc']) && $data['tipo_doc'] !== '' && $data['tipo_doc'] !== null) ? $data['tipo_doc'] : '1';
            $id_usu = Session::get('usuid');
            $id_apc = Session::get('apcid');
            $pago_efe_none = $data['paga_con'];
            $pago_efe_vuelto = $data['pago_vuelto'];
            $descuento_tipo = $data['descuento_tipo'];
            $descuento_personal = $data['descuento_personal'];
            $descuento_monto =  floatval($data['descuento_monto']);
            $descuento_motivo = $data['descuento_motivo'];
            
            // Descuento Jubilado Panamá (Ley 6)
            $es_venta_jubilado = isset($data['es_venta_jubilado']) ? $data['es_venta_jubilado'] : '0';
            $descuento_jubilado_total = isset($data['descuento_jubilado_total']) ? floatval($data['descuento_jubilado_total']) : 0;
            
            if ($es_venta_jubilado == '1' && $descuento_jubilado_total > 0) {
                // Sumar el descuento de jubilado al descuento total
                $descuento_monto += $descuento_jubilado_total;
                
                // Actualizar el motivo para incluir el descuento de jubilado
                if (!empty($descuento_motivo)) {
                    $descuento_motivo .= ' + DESCUENTO JUBILADO LEY 6 (25%)';
                } else {
                    $descuento_motivo = 'DESCUENTO JUBILADO LEY 6 (25%)';
                }
                
                // Establecer tipo de descuento como "Descuento" (tipo 2)
                if (empty($descuento_tipo) || $descuento_tipo == '0') {
                    $descuento_tipo = '2';
                }
            }
            $comision_tarjeta = $data['comision_tarjeta'];
            $comision_delivery = $data['comision_delivery'];
            $igv = Session::get('igv');
            $rc = (Session::get('com_rc')/100);
            $total = $data['total'];
            $fecha_venta = $fecha;
            $serie = $s_c->serie;
            $correlativo = is_numeric($s_c->correlativo) ? intval($s_c->correlativo) : $s_c->correlativo;
            $state_type = '01';
            @file_put_contents($log_file, date('Y-m-d H:i:s') . " restEmitirVenta cliente_id=" . $id_cliente . " correlativo=" . $correlativo . " serie=" . $serie . "\n", FILE_APPEND);
        
            if ($flag == 1) {
                $stmt = $conn->prepare("
                    INSERT INTO tm_venta (id_pedido, id_tipo_pedido, id_cliente, id_tipo_doc, id_usu, id_apc, serie_doc, nro_doc, pago_efe_none, pago_efe_vuelto, descuento_tipo, descuento_personal, descuento_monto, descuento_motivo, comision_tarjeta, comision_delivery, igv, rc, total, fecha_venta, state_type_id)
                    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);
                ");
        
                $stmt->bindParam(1, $id_pedido, PDO::PARAM_INT);
                $stmt->bindParam(2, $tipo_pedido, PDO::PARAM_INT);
                @file_put_contents($log_file, date('Y-m-d H:i:s') . " restEmitirVenta INSERT tm_venta: id_cliente=" . $id_cliente . " correlativo=" . $correlativo . " serie=" . $serie . "\n", FILE_APPEND);
                $stmt->bindParam(3, $id_cliente, PDO::PARAM_INT);
                $stmt->bindParam(4, $id_tipo_doc, PDO::PARAM_INT);
                $stmt->bindParam(5, $id_usu, PDO::PARAM_INT);
                $stmt->bindParam(6, $id_apc, PDO::PARAM_INT);
                $stmt->bindParam(7, $serie, PDO::PARAM_STR);
                $stmt->bindParam(8, $correlativo, PDO::PARAM_INT);
                $stmt->bindParam(9, $pago_efe_none, PDO::PARAM_STR);
                $stmt->bindParam(10, $pago_efe_vuelto, PDO::PARAM_STR);
                $stmt->bindParam(11, $descuento_tipo, PDO::PARAM_STR);
                $stmt->bindParam(12, $descuento_personal, PDO::PARAM_INT);
                $stmt->bindParam(13, $descuento_monto, PDO::PARAM_STR);
                $stmt->bindParam(14, $descuento_motivo, PDO::PARAM_STR);
                $stmt->bindParam(15, $comision_tarjeta, PDO::PARAM_STR);
                $stmt->bindParam(16, $comision_delivery, PDO::PARAM_STR);
                $stmt->bindParam(17, $igv, PDO::PARAM_STR);
                $stmt->bindParam(18, $rc, PDO::PARAM_STR);
                $stmt->bindParam(19, $total, PDO::PARAM_STR);
                $stmt->bindParam(20, $fecha_venta, PDO::PARAM_STR);
                $stmt->bindParam(21, $state_type, PDO::PARAM_STR);
        
                $stmt->execute();
        
                $id = $conn->lastInsertId();
                $rowCount = $stmt->rowCount();
                @file_put_contents($log_file, date('Y-m-d H:i:s') . " restEmitirVenta INSERT ejecutado lastInsertId=" . var_export($id, true) . " (rowCount=" . $rowCount . ")\n", FILE_APPEND);
                if ($rowCount === 0) {
                    $err = $stmt->errorInfo();
                    @file_put_contents($log_file, date('Y-m-d H:i:s') . " restEmitirVenta ERROR PDO (rowCount=0): " . ($err[0] ?? '') . " " . ($err[1] ?? '') . " " . ($err[2] ?? '') . "\n", FILE_APPEND);
                } else {
                    // Ya actualizamos el número antes de insertar (en la transacción), solo logueamos
                    @file_put_contents($log_file, date('Y-m-d H:i:s') . " restEmitirVenta INSERT exitoso con correlativo=" . $correlativo . " id_tipo_doc=" . $id_tipo_doc . "\n", FILE_APPEND);
                }
        
                $actualizar_estado_pedido = !isset($data['actualizar_estado_pedido']) || $data['actualizar_estado_pedido'] !== false;
                if ($dividir_cuenta == 1 && $actualizar_estado_pedido) {
                    if ($tipo_pedido == 1) {
                        $stmt = $conn->prepare("SELECT id_mesa FROM tm_pedido_mesa WHERE id_pedido = ?");
                        $stmt->bindParam(1, $id_pedido, PDO::PARAM_INT);
                        $stmt->execute();
                        $idMesaResult = $stmt->fetch();
                        $idMesa = $idMesaResult['id_mesa'];
        
                        $stmt = $conn->prepare("UPDATE tm_mesa SET estado = 'a' WHERE id_mesa = ?");
                        $stmt->bindParam(1, $idMesa, PDO::PARAM_INT);
                        $stmt->execute();
        
                        $stmt = $conn->prepare("UPDATE tm_pedido SET id_apc = ?, estado = 'd' WHERE id_pedido = ?");
                        $stmt->bindParam(1, $id_apc, PDO::PARAM_INT);
                        $stmt->bindParam(2, $id_pedido, PDO::PARAM_INT);
                        $stmt->execute();
                    } elseif ($tipo_pedido == 2) {
                        $stmt = $conn->prepare("UPDATE tm_pedido SET id_apc = ?, estado = 'b' WHERE id_pedido = ?");
                        $stmt->bindParam(1, $id_apc, PDO::PARAM_INT);
                        $stmt->bindParam(2, $id_pedido, PDO::PARAM_INT);
                        $stmt->execute();
        
                        $stmt = $conn->prepare("UPDATE tm_pedido_llevar SET fecha_entrega = ? WHERE id_pedido = ?");
                        $stmt->bindParam(1, $fecha_venta, PDO::PARAM_STR);
                        $stmt->bindParam(2, $id_pedido, PDO::PARAM_INT);
                        $stmt->execute();
                    } elseif ($tipo_pedido == 3) {
                        $stmt = $conn->prepare("UPDATE tm_pedido SET id_apc = ?, id_usu = ?, estado = ? WHERE id_pedido = ?");
                        $stmt->bindParam(1, $id_apc, PDO::PARAM_INT);
                        $stmt->bindParam(2, $id_usu, PDO::PARAM_INT);
                        $stmt->bindParam(3, $tipo_entrega, PDO::PARAM_STR);
                        $stmt->bindParam(4, $id_pedido, PDO::PARAM_INT);
                        $stmt->execute();
        
                        if ($tipo_entrega == 'c') {
                            $stmt = $conn->prepare("UPDATE tm_pedido_delivery SET fecha_envio = ? WHERE id_pedido = ?");
                        } elseif ($tipo_entrega == 'd') {
                            $stmt = $conn->prepare("UPDATE tm_pedido_delivery SET fecha_entrega = ? WHERE id_pedido = ?");
                        }
                        $stmt->bindParam(1, $fecha_venta, PDO::PARAM_STR);
                        $stmt->bindParam(2, $id_pedido, PDO::PARAM_INT);
                        $stmt->execute();
                    } elseif ($tipo_pedido == 4) {
                        $stmt = $conn->prepare("UPDATE tm_pedido SET id_apc = ?, estado = 'b' WHERE id_pedido = ?");
                        $stmt->bindParam(1, $id_apc, PDO::PARAM_INT);
                        $stmt->bindParam(2, $id_pedido, PDO::PARAM_INT);
                        $stmt->execute();
        
                        $stmt = $conn->prepare("UPDATE tm_pedido_pos SET fecha_entrega = ? WHERE id_pedido = ?");
                        $stmt->bindParam(1, $fecha_venta, PDO::PARAM_STR);
                        $stmt->bindParam(2, $id_pedido, PDO::PARAM_INT);
                        $stmt->execute();
                    }
                }
        
                return $id;
            }
        
        } catch (PDOException $e) {
            $log_file = __DIR__ . '/../log_registrar_venta.log';
            $msg = date('Y-m-d H:i:s') . " restEmitirVenta PDOException: " . $e->getMessage() . "\n";
            $msg .= "  id_pedido=" . (isset($data['id_pedido']) ? $data['id_pedido'] : '?') . " code=" . $e->getCode() . "\n";
            @file_put_contents($log_file, $msg, FILE_APPEND);
            return null;
        } catch (Exception $e) {
            $msg = date('Y-m-d H:i:s') . " restEmitirVenta Exception: " . $e->getMessage() . "\n";
            $msg .= "  id_pedido=" . (isset($data['id_pedido']) ? $data['id_pedido'] : '?') . " file=" . $e->getFile() . " line=" . $e->getLine() . "\n";
            @file_put_contents($log_file, $msg, FILE_APPEND);
            return null;
        } catch (Throwable $e) {
            $msg = date('Y-m-d H:i:s') . " restEmitirVenta Throwable: " . $e->getMessage() . "\n";
            $msg .= "  id_pedido=" . (isset($data['id_pedido']) ? $data['id_pedido'] : '?') . " file=" . $e->getFile() . " line=" . $e->getLine() . "\n";
            @file_put_contents($log_file, $msg, FILE_APPEND);
            return null;
        }
        
        @file_put_contents($log_file, date('Y-m-d H:i:s') . " restEmitirVenta FIN sin return (flag!=1 o salida inesperada)\n", FILE_APPEND);
        $conn = null;    


    } 

    public function RegistrarVenta($data)
    {
        try
        {
            date_default_timezone_set($_SESSION["zona_horaria"]);
            setlocale(LC_ALL,"es_ES@euro","es_ES","esp");
            $fecha = date("Y-m-d H:i:s");


            $conteo = $this->db->query("SELECT COUNT(*) as conteo FROM tm_detalle_pedido WHERE id_pedido = ".$data['id_pedido'])->fetch(PDO::FETCH_OBJ);

            // if( ($conteo->conteo > 0) &&  $data['total'] > 0){  
            if( ($conteo->conteo > 0)){                              

                $status = false;
                $id_venta = null;
                $mensaje = '';
                $ventas_por_precuenta = array();
                $dividir_cuenta = isset($data['dividir_cuenta']) ? $data['dividir_cuenta'] : 1;
                $nombrePrecuentaItem = isset($data['nombrePrecuentaItem']) && is_array($data['nombrePrecuentaItem']) ? $data['nombrePrecuentaItem'] : array();
                $log_file = __DIR__ . '/../log_registrar_venta.log';
                @file_put_contents($log_file, date('Y-m-d H:i:s') . " RegistrarVenta dividir_cuenta=" . var_export($dividir_cuenta, true) . " nombrePrecuentaItem.count=" . count($nombrePrecuentaItem) . " condicion=" . ((string)$dividir_cuenta === '2' && count($nombrePrecuentaItem) > 0 ? 'SI' : 'NO') . "\n", FILE_APPEND);

                // Si dividir_cuenta=2 pero nombrePrecuentaItem está vacío, intentar obtener precuentas desde tm_pedido_precuenta_facturacion
                if ((string)$dividir_cuenta === '2' && count($nombrePrecuentaItem) === 0) {
                    try {
                        $stm_prec_check = $this->db->prepare("SELECT DISTINCT nombre_precuenta FROM tm_pedido_precuenta_facturacion WHERE id_pedido = ?");
                        $stm_prec_check->execute(array($data['id_pedido']));
                        $precuentas_db = $stm_prec_check->fetchAll(PDO::FETCH_COLUMN);
                        if (count($precuentas_db) > 0) {
                            @file_put_contents($log_file, date('Y-m-d H:i:s') . " RegistrarVenta dividida: nombrePrecuentaItem vacío, pero encontradas " . count($precuentas_db) . " precuentas en BD: " . implode(',', $precuentas_db) . "\n", FILE_APPEND);
                            // Construir nombrePrecuentaItem desde los items del pedido agrupados por precuenta
                            $stm_items = $this->db->prepare("SELECT id_pres, cantidad, precio, toppings, nombre_precuenta FROM tm_detalle_pedido WHERE id_pedido = ? AND estado <> 'z' AND nombre_precuenta IS NOT NULL AND TRIM(nombre_precuenta) <> ''");
                            $stm_items->execute(array($data['id_pedido']));
                            $items_db = $stm_items->fetchAll(PDO::FETCH_OBJ);
                            if (count($items_db) > 0) {
                                // Reconstruir arrays desde la BD
                                $nombrePrecuentaItem = array();
                                $idProd_rebuild = isset($data['idProd']) ? $data['idProd'] : array();
                                $cantProd_rebuild = isset($data['cantProd']) ? $data['cantProd'] : array();
                                $precProd_rebuild = isset($data['precProd']) ? $data['precProd'] : array();
                                $costoProd_rebuild = isset($data['costoProd']) ? $data['costoProd'] : array();
                                $toppingsProd_rebuild = isset($data['toppingsProd']) ? $data['toppingsProd'] : array();
                                $desc_prod_rebuild = isset($data['descuentoProd']) ? $data['descuentoProd'] : array();
                                
                                foreach ($items_db as $item_db) {
                                    $nombrePrecuentaItem[] = $item_db->nombre_precuenta;
                                    $idProd_rebuild[] = $item_db->id_pres;
                                    $cantProd_rebuild[] = $item_db->cantidad;
                                    $precProd_rebuild[] = $item_db->precio;
                                    $costoProd_rebuild[] = 0; // No disponible en tm_detalle_pedido
                                    $toppingsProd_rebuild[] = $item_db->toppings;
                                    $desc_prod_rebuild[] = 0; // No disponible en tm_detalle_pedido
                                }
                                $data['idProd'] = $idProd_rebuild;
                                $data['cantProd'] = $cantProd_rebuild;
                                $data['precProd'] = $precProd_rebuild;
                                $data['costoProd'] = $costoProd_rebuild;
                                $data['toppingsProd'] = $toppingsProd_rebuild;
                                $data['descuentoProd'] = $desc_prod_rebuild;
                                @file_put_contents($log_file, date('Y-m-d H:i:s') . " RegistrarVenta dividida: reconstruido nombrePrecuentaItem.count=" . count($nombrePrecuentaItem) . " desde BD\n", FILE_APPEND);
                            }
                        }
                    } catch (Exception $e) {
                        @file_put_contents($log_file, date('Y-m-d H:i:s') . " RegistrarVenta dividida: ERROR al obtener precuentas desde BD: " . $e->getMessage() . "\n", FILE_APPEND);
                    }
                }

                if ((string)$dividir_cuenta === '2' && count($nombrePrecuentaItem) > 0) {
                    $sunat_global = Session::get('sunat');
                    @file_put_contents($log_file, date('Y-m-d H:i:s') . " RegistrarVenta dividida: INICIANDO proceso dividido. sunat_global=" . var_export($sunat_global, true) . " precuentas=" . count($nombrePrecuentaItem) . "\n", FILE_APPEND);
                    
                    $precuentas_unicas = array();
                    foreach ($nombrePrecuentaItem as $np) {
                        $np = trim((string)$np);
                        if ($np !== '' && !in_array($np, $precuentas_unicas, true)) $precuentas_unicas[] = $np;
                    }
                    $factDiv = $this->getFacturacionDivididaData($data['id_pedido']);
                    $factDivArr = is_object($factDiv) ? (array)$factDiv : $factDiv;
                    @file_put_contents($log_file, date('Y-m-d H:i:s') . " RegistrarVenta dividida: precuentas_unicas=" . implode(',', $precuentas_unicas) . " factDivArr keys=" . implode(',', array_keys($factDivArr)) . "\n", FILE_APPEND);
                    if (count($precuentas_unicas) > 0) {
                        $idx_last = count($precuentas_unicas) - 1;
                        foreach ($precuentas_unicas as $idx_prec => $nombre_precuenta) {
                            $fd = isset($factDivArr[$nombre_precuenta]) ? $factDivArr[$nombre_precuenta] : (is_object($factDiv) && isset($factDiv->$nombre_precuenta) ? $factDiv->$nombre_precuenta : null);
                            $tiene_doc_electronico = ($fd && isset($fd['id_tipo_doc']));
                            if (!$tiene_doc_electronico) {
                                $fd = array('id_tipo_doc' => 3, 'id_cliente' => 1);
                                @file_put_contents($log_file, date('Y-m-d H:i:s') . " RegistrarVenta dividida precuenta=" . $nombre_precuenta . " sin documento → ticket regular (tipo_doc=3, cliente=1)\n", FILE_APPEND);
                            } else {
                                @file_put_contents($log_file, date('Y-m-d H:i:s') . " RegistrarVenta dividida precuenta=" . $nombre_precuenta . " fd=" . json_encode($fd) . "\n", FILE_APPEND);
                            }
                            $indices = array();
                            foreach ($nombrePrecuentaItem as $i => $np) {
                                if (trim((string)$np) !== $nombre_precuenta) continue;
                                $cant = isset($data['cantProd'][$i]) ? floatval($data['cantProd'][$i]) : 0;
                                if ($cant <= 0) continue;
                                $indices[] = $i;
                            }
                            if (count($indices) === 0) continue;
                            $idProd_p = array(); $cantProd_p = array(); $precProd_p = array(); $costoProd_p = array(); $toppingsProd_p = array(); $desc_prod_p = array();
                            $total_p = 0;
                            foreach ($indices as $i) {
                                $cant = floatval(isset($data['cantProd'][$i]) ? $data['cantProd'][$i] : 0);
                                $precio = floatval(isset($data['precProd'][$i]) ? $data['precProd'][$i] : 0);
                                if ($cant <= 0) continue;
                                $idProd_p[] = isset($data['idProd'][$i]) ? $data['idProd'][$i] : 0;
                                $cantProd_p[] = $cant;
                                $precProd_p[] = $precio;
                                $costoProd_p[] = isset($data['costoProd'][$i]) ? $data['costoProd'][$i] : 0;
                                $toppingsProd_p[] = isset($data['toppingsProd'][$i]) ? $data['toppingsProd'][$i] : null;
                                $desc_prod_p[] = isset($data['descuentoProd'][$i]) ? floatval($data['descuentoProd'][$i]) : 0;
                                $total_p += $cant * $precio;
                            }
                            if (count($idProd_p) === 0) continue;
                            $total_p = round($total_p, 2);
                            if ($total_p <= 0) continue;
                            $data_p = $data;
                            $data_p['cliente_id'] = isset($fd['id_cliente']) ? intval($fd['id_cliente']) : 1;
                            $data_p['tipo_doc'] = (string)$fd['id_tipo_doc'];
                            @file_put_contents($log_file, date('Y-m-d H:i:s') . " RegistrarVenta dividida precuenta=" . $nombre_precuenta . " cliente_id=" . $data_p['cliente_id'] . " tipo_doc=" . $data_p['tipo_doc'] . "\n", FILE_APPEND);
                            $data_p['idProd'] = $idProd_p;
                            $data_p['cantProd'] = $cantProd_p;
                            $data_p['precProd'] = $precProd_p;
                            $data_p['costoProd'] = $costoProd_p;
                            $data_p['toppingsProd'] = $toppingsProd_p;
                            $data_p['descuentoProd'] = $desc_prod_p;
                            $data_p['total'] = $total_p;
                            $data_p['pago_efe'] = $total_p;
                            $data_p['paga_con'] = isset($data['paga_con']) ? $data['paga_con'] : $total_p;
                            $data_p['pago_vuelto'] = isset($data['pago_vuelto']) ? $data['pago_vuelto'] : 0;
                            $data_p['pago_tipo'] = array(1);
                            $data_p['pago_monto'] = array($total_p);
                            $data_p['pago_codigo'] = array('');
                            $data_p['propina_tipo'] = array(1);
                            $data_p['propina_monto'] = array(0);
                            $data_p['dividir_cuenta'] = 1;
                            $data_p['actualizar_estado_pedido'] = ($idx_prec === $idx_last);
                            $id_venta_p = $this->restEmitirVenta($data_p);
                            if (!$id_venta_p) break;
                            $status = true;
                            
                            // Insertar items en tm_detalle_venta (restEmitirVenta solo crea tm_venta, no los items)
                            try {
                                $this->db_det_venta = new Database(DB_TYPE, DB_HOST, DB_NAME, DB_USER, DB_PASS, DB_CHARSET);
                                $a = $idProd_p;
                                $b = $cantProd_p;
                                $c = $precProd_p;
                                $d = $costoProd_p;
                                $e = $toppingsProd_p;
                                $desc_prod = $desc_prod_p;
                                
                                for($x=0; $x < sizeof($a); ++$x){
                                    if ($b[$x] > 0){
                                        $desc_item = isset($desc_prod[$x]) ? floatval($desc_prod[$x]) : 0;
                                        $sql_det_venta = "INSERT INTO tm_detalle_venta (id_venta,id_prod,cantidad,precio,costo,toppings,desc_monto) VALUES (?,?,?,?,?,?,?)";
                                        $this->db_det_venta->prepare($sql_det_venta)->execute(array($id_venta_p,$a[$x],$b[$x],$c[$x],$d[$x],$e[$x],$desc_item));
                                    }
                                }
                                @file_put_contents($log_file, date('Y-m-d H:i:s') . " RegistrarVenta dividida: insertados " . count($a) . " items en tm_detalle_venta para id_venta=" . $id_venta_p . " precuenta=" . $nombre_precuenta . "\n", FILE_APPEND);
                            } catch (Exception $e) {
                                @file_put_contents($log_file, date('Y-m-d H:i:s') . " RegistrarVenta dividida: ERROR al insertar items en tm_detalle_venta: " . $e->getMessage() . "\n", FILE_APPEND);
                            }
                            
                            // Insertar pagos efectivo
                            try {
                                $this->db_pagos_efe = new Database(DB_TYPE, DB_HOST, DB_NAME, DB_USER, DB_PASS, DB_CHARSET);
                                if($data_p['pago_efe'] > 0){
                                    $sql_pagos_efe = "INSERT INTO tm_venta_pago (id_venta,id_pago,monto) VALUES (?,?,?);";
                                    $this->db_pagos_efe->prepare($sql_pagos_efe)->execute(array($id_venta_p,1,$data_p['pago_efe'])); 
                                }
                                @file_put_contents($log_file, date('Y-m-d H:i:s') . " RegistrarVenta dividida: insertado pago efectivo=" . $data_p['pago_efe'] . " para id_venta=" . $id_venta_p . "\n", FILE_APPEND);
                            } catch (Exception $e) {
                                @file_put_contents($log_file, date('Y-m-d H:i:s') . " RegistrarVenta dividida: ERROR al insertar pago: " . $e->getMessage() . "\n", FILE_APPEND);
                            }
                            
                            // Actualizar comisión/observación
                            $this->db_comi = new Database(DB_TYPE, DB_HOST, DB_NAME, DB_USER, DB_PASS, DB_CHARSET);
                            $this->db_comi->prepare("UPDATE tm_venta SET comision_rc = 0, consumo = 0, consumo_desc = '', propina = 0, observacion = ? WHERE id_venta = ?")->execute(array(isset($data['observacion']) ? $data['observacion'] : '', $id_venta_p));
                            
                            // Obtener el correlativo de la venta recién creada
                            $correlativo_p = null;
                            try {
                                $stm_corr = $this->db_comi->prepare("SELECT nro_doc, serie_doc FROM tm_venta WHERE id_venta = ?");
                                $stm_corr->execute(array($id_venta_p));
                                $corr_result = $stm_corr->fetch(PDO::FETCH_OBJ);
                                if ($corr_result) {
                                    $correlativo_p = $corr_result->nro_doc;
                                    @file_put_contents($log_file, date('Y-m-d H:i:s') . " RegistrarVenta dividida: id_venta=" . $id_venta_p . " correlativo obtenido de tm_venta=" . $correlativo_p . " serie=" . $corr_result->serie_doc . " para precuenta=" . $nombre_precuenta . "\n", FILE_APPEND);
                                } else {
                                    @file_put_contents($log_file, date('Y-m-d H:i:s') . " RegistrarVenta dividida: WARNING - No se encontró correlativo para id_venta=" . $id_venta_p . "\n", FILE_APPEND);
                                }
                            } catch (Exception $e) {
                                @file_put_contents($log_file, date('Y-m-d H:i:s') . " RegistrarVenta dividida: ERROR al obtener correlativo: " . $e->getMessage() . "\n", FILE_APPEND);
                            }
                            
                            // Guardar id_venta, correlativo e ids_items en tm_pedido_precuenta_facturacion para consulta posterior del PDF
                            $ids_items_json = json_encode($idProd_p);
                            $descuentos_items_obj = array();
                            foreach ($idProd_p as $idx => $id_prod) {
                                if (isset($desc_prod_p[$idx]) && floatval($desc_prod_p[$idx]) > 0) {
                                    $descuentos_items_obj[$id_prod] = floatval($desc_prod_p[$idx]);
                                }
                            }
                            $descuentos_items_json = json_encode($descuentos_items_obj);
                            try {
                                $this->db_precuenta = new Database(DB_TYPE, DB_HOST, DB_NAME, DB_USER, DB_PASS, DB_CHARSET);
                                $stm_prec = $this->db_precuenta->prepare("UPDATE tm_pedido_precuenta_facturacion SET id_venta = ?, correlativo = ?, ids_items = ?, descuentos_items = ? WHERE id_pedido = ? AND nombre_precuenta = ?");
                                $stm_prec->execute(array($id_venta_p, $correlativo_p, $ids_items_json, $descuentos_items_json, $data['id_pedido'], $nombre_precuenta));
                                @file_put_contents($log_file, date('Y-m-d H:i:s') . " RegistrarVenta dividida: guardado id_venta=" . $id_venta_p . " correlativo=" . $correlativo_p . " ids_items=" . $ids_items_json . " para precuenta=" . $nombre_precuenta . "\n", FILE_APPEND);
                            } catch (Exception $e) {
                                @file_put_contents($log_file, date('Y-m-d H:i:s') . " RegistrarVenta dividida: ERROR al guardar en tm_pedido_precuenta_facturacion: " . $e->getMessage() . "\n", FILE_APPEND);
                            }
                            
                            // Registrar facturación electrónica para esta venta si está activada
                            $sunat_activo = Session::get('sunat');
                            $tipo_doc_val = isset($data_p['tipo_doc']) ? $data_p['tipo_doc'] : null;
                            @file_put_contents($log_file, date('Y-m-d H:i:s') . " RegistrarVenta dividida: Verificando FE para id_venta=" . $id_venta_p . " precuenta=" . $nombre_precuenta . " sunat=" . var_export($sunat_activo, true) . " tipo_doc=" . var_export($tipo_doc_val, true) . " condicion=" . (($sunat_activo == 1 && $tipo_doc_val <> 3) ? 'SI' : 'NO') . "\n", FILE_APPEND);
                            
                            if ($sunat_activo == 1 && $tipo_doc_val <> 3) {
                                try {
                                    @file_put_contents($log_file, date('Y-m-d H:i:s') . " RegistrarVenta dividida: INICIANDO registro FE para id_venta=" . $id_venta_p . " precuenta=" . $nombre_precuenta . "\n", FILE_APPEND);
                                    
                                    // Preparar datos para facturación electrónica de esta precuenta específica
                                    $fe_data_p = array(
                                        'id_venta' => $id_venta_p,
                                        'id_pedido' => $data['id_pedido'],
                                        'cliente_id' => $data_p['cliente_id'],
                                        'tipo_doc' => $data_p['tipo_doc'],
                                        'total' => $total_p,
                                        'observacion' => isset($data['observacion']) ? $data['observacion'] : null,
                                        'id_serie_electronica' => isset($data['id_serie_electronica']) ? $data['id_serie_electronica'] : null,
                                        'serie_electronica' => isset($data['serie_electronica']) ? $data['serie_electronica'] : null,
                                        'correlativo_electronico' => $correlativo_p,
                                        'pos_electronico' => isset($data['pos_electronico']) ? $data['pos_electronico'] : null,
                                        'tipo_documento_electronico' => isset($data['tipo_documento_electronico']) ? $data['tipo_documento_electronico'] : null,
                                        'facturacion_dividida' => true, // Marcar como facturación dividida
                                        // Items específicos de esta precuenta
                                        'idProd' => $idProd_p,
                                        'cantProd' => $cantProd_p,
                                        'precProd' => $precProd_p,
                                        'costoProd' => $costoProd_p,
                                        'toppingsProd' => $toppingsProd_p,
                                        'descuentoProd' => $desc_prod_p,
                                        // Pagos específicos de esta precuenta
                                        'pago_efe' => $data_p['pago_efe'],
                                        'pago_tipo' => $data_p['pago_tipo'],
                                        'pago_monto' => $data_p['pago_monto'],
                                        'pago_codigo' => $data_p['pago_codigo'],
                                        'propina_tipo' => $data_p['propina_tipo'],
                                        'propina_monto' => $data_p['propina_monto']
                                    );
                                    
                                    @file_put_contents($log_file, date('Y-m-d H:i:s') . " RegistrarVenta dividida: Datos FE preparados para id_venta=" . $id_venta_p . " cliente_id=" . $fe_data_p['cliente_id'] . " tipo_doc=" . $fe_data_p['tipo_doc'] . " total=" . $fe_data_p['total'] . " items=" . count($idProd_p) . "\n", FILE_APPEND);
                                    
                                    $result_fe_p = $this->RegistrarFacturacionElectronica($fe_data_p);
                                    
                                    @file_put_contents($log_file, date('Y-m-d H:i:s') . " RegistrarVenta dividida: Resultado FE para id_venta=" . $id_venta_p . " success=" . var_export($result_fe_p['success'] ?? false, true) . " message=" . ($result_fe_p['message'] ?? 'N/A') . "\n", FILE_APPEND);
                                    
                                    if ($result_fe_p['success']) {
                                        @file_put_contents($log_file, date('Y-m-d H:i:s') . " RegistrarVenta dividida: ✅ Documento FE guardado para id_venta=" . $id_venta_p . " precuenta=" . $nombre_precuenta . " id_documento_fe=" . ($result_fe_p['id_documento_fe'] ?? 'N/A') . "\n", FILE_APPEND);
                                    } else {
                                        @file_put_contents($log_file, date('Y-m-d H:i:s') . " RegistrarVenta dividida: ❌ ERROR al guardar FE para id_venta=" . $id_venta_p . " precuenta=" . $nombre_precuenta . " error=" . ($result_fe_p['message'] ?? 'Desconocido') . "\n", FILE_APPEND);
                                    }
                                } catch (Exception $e) {
                                    @file_put_contents($log_file, date('Y-m-d H:i:s') . " RegistrarVenta dividida: ❌ EXCEPCIÓN al guardar FE para id_venta=" . $id_venta_p . " precuenta=" . $nombre_precuenta . " error=" . $e->getMessage() . " trace=" . $e->getTraceAsString() . "\n", FILE_APPEND);
                                }
                            } else {
                                @file_put_contents($log_file, date('Y-m-d H:i:s') . " RegistrarVenta dividida: ⚠️ FE NO se registrará para id_venta=" . $id_venta_p . " precuenta=" . $nombre_precuenta . " (sunat=" . var_export($sunat_activo, true) . " tipo_doc=" . var_export($tipo_doc_val, true) . ")\n", FILE_APPEND);
                            }
                            
                            $ventas_por_precuenta[] = array('nombre_precuenta' => $nombre_precuenta, 'id_venta' => $id_venta_p);
                        }
                        if (count($ventas_por_precuenta) > 0) {
                            // Actualizar estado del pedido después de procesar todas las precuentas
                            // Esto asegura que la mesa/orden se libere incluso si la última precuenta falló
                            try {
                                $this->db_estado = new Database(DB_TYPE, DB_HOST, DB_NAME, DB_USER, DB_PASS, DB_CHARSET);
                                $tipo_pedido = isset($data['tipo_pedido']) ? intval($data['tipo_pedido']) : 1;
                                $id_apc = Session::get('apcid');
                                $id_usu = Session::get('usuid');
                                $fecha_venta = date("Y-m-d H:i:s");
                                
                                if ($tipo_pedido == 1) {
                                    // Mesa: liberar mesa y marcar pedido como pagado
                                    $stm_mesa = $this->db_estado->prepare("SELECT id_mesa FROM tm_pedido_mesa WHERE id_pedido = ?");
                                    $stm_mesa->execute(array($data['id_pedido']));
                                    $mesa_result = $stm_mesa->fetch(PDO::FETCH_ASSOC);
                                    if ($mesa_result && isset($mesa_result['id_mesa'])) {
                                        $stm_liberar_mesa = $this->db_estado->prepare("UPDATE tm_mesa SET estado = 'a' WHERE id_mesa = ?");
                                        $stm_liberar_mesa->execute(array($mesa_result['id_mesa']));
                                        @file_put_contents($log_file, date('Y-m-d H:i:s') . " RegistrarVenta dividida: Mesa " . $mesa_result['id_mesa'] . " liberada\n", FILE_APPEND);
                                    }
                                    $stm_pedido = $this->db_estado->prepare("UPDATE tm_pedido SET id_apc = ?, estado = 'd' WHERE id_pedido = ?");
                                    $stm_pedido->execute(array($id_apc, $data['id_pedido']));
                                    @file_put_contents($log_file, date('Y-m-d H:i:s') . " RegistrarVenta dividida: Pedido " . $data['id_pedido'] . " marcado como pagado (estado='d')\n", FILE_APPEND);
                                } elseif ($tipo_pedido == 2) {
                                    // Para llevar: marcar como entregado
                                    $stm_pedido = $this->db_estado->prepare("UPDATE tm_pedido SET id_apc = ?, estado = 'b' WHERE id_pedido = ?");
                                    $stm_pedido->execute(array($id_apc, $data['id_pedido']));
                                    $stm_llevar = $this->db_estado->prepare("UPDATE tm_pedido_llevar SET fecha_entrega = ? WHERE id_pedido = ?");
                                    $stm_llevar->execute(array($fecha_venta, $data['id_pedido']));
                                    @file_put_contents($log_file, date('Y-m-d H:i:s') . " RegistrarVenta dividida: Pedido para llevar " . $data['id_pedido'] . " marcado como entregado\n", FILE_APPEND);
                                } elseif ($tipo_pedido == 3) {
                                    // Delivery: marcar según tipo de entrega
                                    $tipo_entrega = isset($data['tipo_entrega']) ? $data['tipo_entrega'] : 'c';
                                    $stm_pedido = $this->db_estado->prepare("UPDATE tm_pedido SET id_apc = ?, id_usu = ?, estado = ? WHERE id_pedido = ?");
                                    $stm_pedido->execute(array($id_apc, $id_usu, $tipo_entrega, $data['id_pedido']));
                                    if ($tipo_entrega == 'c') {
                                        $stm_delivery = $this->db_estado->prepare("UPDATE tm_pedido_delivery SET fecha_envio = ? WHERE id_pedido = ?");
                                    } else {
                                        $stm_delivery = $this->db_estado->prepare("UPDATE tm_pedido_delivery SET fecha_entrega = ? WHERE id_pedido = ?");
                                    }
                                    $stm_delivery->execute(array($fecha_venta, $data['id_pedido']));
                                    @file_put_contents($log_file, date('Y-m-d H:i:s') . " RegistrarVenta dividida: Pedido delivery " . $data['id_pedido'] . " actualizado\n", FILE_APPEND);
                                } elseif ($tipo_pedido == 4) {
                                    // POS: marcar como entregado
                                    $stm_pedido = $this->db_estado->prepare("UPDATE tm_pedido SET id_apc = ?, estado = 'b' WHERE id_pedido = ?");
                                    $stm_pedido->execute(array($id_apc, $data['id_pedido']));
                                    $stm_pos = $this->db_estado->prepare("UPDATE tm_pedido_pos SET fecha_entrega = ? WHERE id_pedido = ?");
                                    $stm_pos->execute(array($fecha_venta, $data['id_pedido']));
                                    @file_put_contents($log_file, date('Y-m-d H:i:s') . " RegistrarVenta dividida: Pedido POS " . $data['id_pedido'] . " marcado como entregado\n", FILE_APPEND);
                                }
                            } catch (Exception $e) {
                                @file_put_contents($log_file, date('Y-m-d H:i:s') . " RegistrarVenta dividida: ERROR al actualizar estado del pedido: " . $e->getMessage() . "\n", FILE_APPEND);
                            }
                            
                            $id_venta = $ventas_por_precuenta[0]['id_venta'];
                            return array('success' => true, 'data' => array('mensaje' => 'Registrado correctamente (facturación dividida)', 'idventa' => $id_venta, 'ventas_por_precuenta' => $ventas_por_precuenta));
                        }
                    }
                }

                $id_venta = $this->restEmitirVenta($data);
                if ($id_venta) {
                    $status = true;
                    // database comision insert
                    $this->db_comi = new Database(DB_TYPE, DB_HOST, DB_NAME, DB_USER, DB_PASS, DB_CHARSET);
                    $sqlcomi = "UPDATE tm_venta SET comision_rc = ?, consumo = ?, consumo_desc = ?, propina = ?, observacion = ? WHERE id_venta = ? ";
                    $this->db_comi->prepare($sqlcomi)->execute(array($data['comision_rc'],$data['venta_por_consumo'],$data['venta_por_consumo_concepto'], $data['total_propia'],$data['observacion'],$id_venta));

                    // tm_detalle_venta (con desc_monto por ítem si existe columna)
                    $this->db_det_venta = new Database(DB_TYPE, DB_HOST, DB_NAME, DB_USER, DB_PASS, DB_CHARSET);
                    $a = $data['idProd'];
                    $b = $data['cantProd'];
                    $c = $data['precProd'];
                    $d = $data['costoProd'];
                    $e = $data['toppingsProd'];
                    $desc_prod = isset($data['descuentoProd']) && is_array($data['descuentoProd']) ? $data['descuentoProd'] : array();

                    for($x=0; $x < sizeof($a); ++$x){
                        if ($b[$x] > 0){
                            $desc_item = isset($desc_prod[$x]) ? floatval($desc_prod[$x]) : 0;
                            $sql_det_venta = "INSERT INTO tm_detalle_venta (id_venta,id_prod,cantidad,precio,costo,toppings,desc_monto) VALUES (?,?,?,?,?,?,?)";
                            $this->db_det_venta->prepare($sql_det_venta)->execute(array($id_venta,$a[$x],$b[$x],$c[$x],$d[$x],$e[$x],$desc_item));
                        }
                    }

                    // insert pagos efectivo
                    $this->db_pagos_efe = new Database(DB_TYPE, DB_HOST, DB_NAME, DB_USER, DB_PASS, DB_CHARSET);
                    if($data['pago_efe'] > 0){
                        $sql_pagos_efe = "INSERT INTO tm_venta_pago (id_venta,id_pago,monto) VALUES (?,?,?);";
                        $this->db_pagos_efe->prepare($sql_pagos_efe)->execute(array($id_venta,1,$data['pago_efe'])); 
                    }   

                    // insert pagos mixtos
                    $this->db_pagos_mixt = new Database(DB_TYPE, DB_HOST, DB_NAME, DB_USER, DB_PASS, DB_CHARSET);
                    $e = $data['pago_tipo'];
                    $f = $data['pago_monto'];
                    $g = $data['pago_codigo'];

                    for($y=0; $y < sizeof($e); ++$y){
                        if ($f[$y] > 0){
                            $sql_pagos_mixt = "INSERT INTO tm_venta_pago (id_venta,id_pago,monto,codigo) VALUES (?,?,?,?);";
                            $this->db_pagos_mixt->prepare($sql_pagos_mixt)->execute(array($id_venta,$e[$y],$f[$y],$g[$y]));
                        }
                    } 

                    // se agrega pagos propina :D
                    $this->db_propina = new Database(DB_TYPE, DB_HOST, DB_NAME, DB_USER, DB_PASS, DB_CHARSET);

                    $p_pa_ti = $data['propina_tipo'];
                    $p_pa_mo = $data['propina_monto'];

                    for($z=0; $z < sizeof($p_pa_ti); ++$z){
                        if ($p_pa_mo[$z] > 0){
                            $sql_pago_propina = "INSERT INTO tm_venta_propina (id_venta,id_pago,monto) VALUES (?,?,?);";
                            $this->db_propina->prepare($sql_pago_propina)->execute(array($id_venta,$p_pa_ti[$z],$p_pa_mo[$z]));
                        }
                    } 

                    // fin pagos propina 

                    // inventario
                    $this->db_invent = new Database(DB_TYPE, DB_HOST, DB_NAME, DB_USER, DB_PASS, DB_CHARSET);
                    $cons = "call usp_restEmitirVentaDet( :flag, :id_venta, :id_pedido, :fecha );";
                    $arrayParam_invent = array(
                        ':flag' => 1,
                        ':id_venta' =>  $id_venta,
                        ':id_pedido' =>  $data['id_pedido'],
                        ':fecha' =>  $fecha
                    );
                    $stm = $this->db_invent->prepare($cons);
                    $stm->execute($arrayParam_invent);

                    foreach ($data['toppingsProd'] as $item) {
                        if ($item !== null) {
                            $item = str_replace("'", '"', $item);
                            $itemArray = json_decode($item, true);
    
                            if (is_array($itemArray)) {
                                foreach($itemArray as $toppingName => $toppingPrice) {
    
                                    $db_toppings  = new Database(DB_TYPE, DB_HOST, DB_NAME, DB_USER, DB_PASS, DB_CHARSET);
    
                                    $tm_prod_toppings = $db_toppings->query("SELECT i.id_tipo_ins,i.id_ins,i.cant,v.ins_cos FROM tm_producto_toppings AS i INNER JOIN v_insprod AS v ON i.id_ins = v.id_ins AND i.id_tipo_ins = v.id_tipo_ins WHERE i.descripcion LIKE '".$toppingName."'")->fetch(PDO::FETCH_OBJ);
        
                                    $sql_toppings = $db_toppings->prepare("INSERT INTO tm_inventario (id_tipo_ope,id_ope,id_tipo_ins,id_ins,cos_uni,cant,fecha_r) VALUES (?,?,?,?,?,?,?);");
                                    $sql_toppings->execute(array(2,$id_venta,$tm_prod_toppings->id_tipo_ins,$tm_prod_toppings->id_ins,$tm_prod_toppings->ins_cos,$tm_prod_toppings->cant,$fecha));
        
                                }
                            }
        
                        }  
                    } 

                    $mensaje = 'Registrado correctamente - sin envio';

                    if(Session::get('sunat') == 1){
                        if($data['tipo_doc'] <> 3){
                            require_once 'api_fact/controller/api.php';
                            $invoice = new ApiSunat();
                            $data = $invoice->sendDocSunaht($id_venta,2);  
                            
                            $dataObj = json_decode($data);

                            $mensaje = $dataObj->mensaje;
                        }  
                    }

                } else {
                    $mensaje = 'Error al registrar la venta. No se pudo crear el registro.';
                }
                
                if ($status && $id_venta) {
                    $rpta = [
                        'success' => true,
                        'data' => [
                            'mensaje' => $mensaje,
                            'idventa' => $id_venta,
                        ],
                    ];
                } else {
                    $rpta = [
                        'success' => false,
                        'data' => [
                            'mensaje' => $mensaje ? $mensaje : 'Error al registrar la venta',
                            'idventa' => null,
                        ],
                    ];
                }
                return $rpta;
            
            }else{
                $rpta = [
                    'success' => false,
                    'data' => [
                        'mensaje' => 'No hay productos en el pedido',
                        'idventa' => null,
                    ],
                ];
                return $rpta;
            }

        } catch (Exception $e) 
        {
            $msg = $e->getMessage();
            @file_put_contents(__DIR__ . '/../log_registrar_venta.log', date('Y-m-d H:i:s') . " RegistrarVenta Exception: " . $msg . " " . $e->getFile() . ":" . $e->getLine() . "\n", FILE_APPEND);
            return [
                'success' => false,
                'data' => [
                    'mensaje' => 'Error al registrar la venta: ' . $msg,
                    'idventa' => null,
                ],
            ];
        }
    }

    /**
     * Preparar items para facturación electrónica
     */
    private function preparar_items_fe($data)
    {
        $items = array();
        $descuento_prod = isset($data['descuentoProd']) && is_array($data['descuentoProd']) ? $data['descuentoProd'] : array();
        
        if (isset($data['idProd']) && is_array($data['idProd'])) {
            for ($i = 0; $i < count($data['idProd']); $i++) {
                if (isset($data['cantProd'][$i]) && floatval($data['cantProd'][$i]) > 0) {
                    // Obtener nombre del producto
                    $id_prod = $data['idProd'][$i];
                    $producto = $this->db->query("SELECT pro_nom FROM v_productos WHERE id_pres = " . intval($id_prod))
                        ->fetch(PDO::FETCH_ASSOC);
                    // Descuento por ítem (para que Factura Fácil calcule el monto correcto)
                    $descuento_item = isset($descuento_prod[$i]) ? floatval($descuento_prod[$i]) : 0;
                    
                    $items[] = array(
                        'id_producto' => $id_prod,
                        'cantidad' => floatval($data['cantProd'][$i]),
                        'precio' => floatval($data['precProd'][$i]),
                        'descripcion' => $producto ? $producto['pro_nom'] : 'Producto',
                        'codigo' => $id_prod,
                        'descuento' => $descuento_item
                    );
                }
            }
        }
        
        return $items;
    }
    
    /**
     * Preparar pagos para facturación electrónica
     */
    private function preparar_payments_fe($data)
    {
        $payments = array();
        
        error_log("preparar_payments_fe: Iniciando preparación de pagos");
        error_log("preparar_payments_fe: pago_efe = " . (isset($data['pago_efe']) ? $data['pago_efe'] : 'no definido'));
        error_log("preparar_payments_fe: pago_tipo = " . (isset($data['pago_tipo']) ? print_r($data['pago_tipo'], true) : 'no definido'));
        error_log("preparar_payments_fe: pago_monto = " . (isset($data['pago_monto']) ? print_r($data['pago_monto'], true) : 'no definido'));
        
        // Pago en efectivo
        if (isset($data['pago_efe']) && floatval($data['pago_efe']) > 0) {
            $payments[] = array(
                'tipo' => '1', // Efectivo
                'monto' => floatval($data['pago_efe']),
                'descripcion' => 'Efectivo'
            );
            error_log("preparar_payments_fe: Agregado pago en efectivo: " . floatval($data['pago_efe']));
        }
        
        // Pagos mixtos
        if (isset($data['pago_tipo']) && is_array($data['pago_tipo']) && count($data['pago_tipo']) > 0) {
            error_log("preparar_payments_fe: Procesando " . count($data['pago_tipo']) . " pagos mixtos");
            for ($i = 0; $i < count($data['pago_tipo']); $i++) {
                if (isset($data['pago_monto'][$i]) && floatval($data['pago_monto'][$i]) > 0) {
                    $payment_item = array(
                        'tipo' => $data['pago_tipo'][$i],
                        'monto' => floatval($data['pago_monto'][$i]),
                        'codigo' => isset($data['pago_codigo'][$i]) ? $data['pago_codigo'][$i] : null,
                        'descripcion' => $this->obtener_descripcion_pago($data['pago_tipo'][$i])
                    );
                    $payments[] = $payment_item;
                    error_log("preparar_payments_fe: Agregado pago mixto - Tipo: " . $data['pago_tipo'][$i] . ", Monto: " . floatval($data['pago_monto'][$i]));
                }
            }
        }
        
        error_log("preparar_payments_fe: Total de pagos preparados: " . count($payments));
        return $payments;
    }
    
    /**
     * Obtener descripción del tipo de pago
     */
    private function obtener_descripcion_pago($tipo_pago)
    {
        $descripciones = array(
            '1' => 'Efectivo',
            '2' => 'Tarjeta de crédito',
            '3' => 'Tarjeta de débito',
            '4' => 'Transferencia bancaria',
            '5' => 'Cheque',
            '6' => 'POS',
            '7' => 'Crédito',
            '8' => 'Otro'
        );
        
        return isset($descripciones[$tipo_pago]) ? $descripciones[$tipo_pago] : 'Otro';
    }

    public function anular_pedido($data)
    {
        try
        {
            $cod_seg = Session::get('cod_seg');
            $codigo_ingresado = isset($data['codigo_seguridad']) ? trim($data['codigo_seguridad']) : '';

            // Log para depuración (revisar log_anular_pedido_debug.log)
            $logFile = dirname(dirname(__FILE__)) . DIRECTORY_SEPARATOR . 'log_anular_pedido_debug.log';
            $log = array(
                'fecha' => date('Y-m-d H:i:s'),
                'cod_seg_session' => array(
                    'valor' => $cod_seg === null ? 'NULL' : (string)$cod_seg,
                    'longitud' => $cod_seg === null ? 0 : strlen((string)$cod_seg),
                    'tipo' => gettype($cod_seg),
                    'hex' => $cod_seg === null ? '-' : bin2hex((string)$cod_seg),
                ),
                'codigo_ingresado' => array(
                    'valor' => $codigo_ingresado,
                    'longitud' => strlen($codigo_ingresado),
                    'hex' => bin2hex($codigo_ingresado),
                ),
                'comparacion_estricta' => $codigo_ingresado === (string)$cod_seg,
                'comparacion_igual' => $codigo_ingresado == $cod_seg,
            );
            @file_put_contents($logFile, date('Y-m-d H:i:s') . ' ' . json_encode($log, JSON_UNESCAPED_UNICODE) . "\n", FILE_APPEND | LOCK_EX);

            if ($cod_seg === null || $cod_seg === '' || $codigo_ingresado === '' || $codigo_ingresado !== (string)$cod_seg) {
                return array('success' => false, 'message' => 'Código de seguridad incorrecto.');
            }

            date_default_timezone_set($_SESSION["zona_horaria"]);
            setlocale(LC_ALL,"es_ES@euro","es_ES","esp");

            $fecha_envio = date("Y-m-d H:i:s");
            $user = Session::get('usuid');


            $logFile = dirname(dirname(__FILE__)) . DIRECTORY_SEPARATOR . 'log_anular_pedido_debug.log';

            $sqlproducto = "UPDATE tm_detalle_pedido SET estado = 'z', id_usu = ?, fecha_envio = ? WHERE id_pedido = ?";
            $this->db->prepare($sqlproducto)->execute(array($user, $fecha_envio, $data['id_pedido']));

            $tipo_pedido = isset($data['tipo_pedido']) ? $data['tipo_pedido'] : 'NO_ENVIADO';
            $entro_rama_mesa = ($tipo_pedido == 1 || $tipo_pedido === '1');
            $logMesa = array(
                'fecha' => date('Y-m-d H:i:s'),
                'paso' => 'liberar_mesa',
                'id_pedido' => isset($data['id_pedido']) ? $data['id_pedido'] : null,
                'tipo_pedido_raw' => $tipo_pedido,
                'tipo_pedido_tipo' => gettype($tipo_pedido),
                'tipo_pedido_equals_1' => ($tipo_pedido == 1),
                'entro_rama_mesa' => $entro_rama_mesa,
            );

            if($data['tipo_pedido'] == 1){

                $logMesa['accion'] = 'call usp_restDesocuparMesa';
                $logMesa['motivo'] = isset($data['motivo']) ? $data['motivo'] : '';
                @file_put_contents($logFile, date('Y-m-d H:i:s') . ' MESA ' . json_encode($logMesa, JSON_UNESCAPED_UNICODE) . "\n", FILE_APPEND | LOCK_EX);

                try {
                    $consulta = "call usp_restDesocuparMesa( :flag, :id_pedido, :motivo);";
                    $arrayParam =  array(
                        ':flag' => 1,
                        ':id_pedido' =>  $data['id_pedido'],
                        ':motivo' =>  $data['motivo']
                    );
                    $st = $this->db->prepare($consulta);
                    $st->execute($arrayParam);
                    $logMesa['usp_ejecutado'] = true;
                    $logMesa['usp_error'] = null;
                } catch (Exception $eMesa) {
                    $logMesa['usp_ejecutado'] = false;
                    $logMesa['usp_error'] = $eMesa->getMessage();
                }
                @file_put_contents($logFile, date('Y-m-d H:i:s') . ' MESA_RESULT ' . json_encode($logMesa, JSON_UNESCAPED_UNICODE) . "\n", FILE_APPEND | LOCK_EX);

            } elseif($data['tipo_pedido'] == 2 OR $data['tipo_pedido'] == 3){

                $logMesa['accion'] = 'update tm_pedido (llevar/delivery)';
                @file_put_contents($logFile, date('Y-m-d H:i:s') . ' MESA ' . json_encode($logMesa, JSON_UNESCAPED_UNICODE) . "\n", FILE_APPEND | LOCK_EX);

                $sql = "UPDATE tm_pedido SET estado = 'z', motivo = ? WHERE id_pedido = ?";
                $this->db->prepare($sql)->execute(array($data['motivo'], $data['id_pedido']));
            } else {
                $logMesa['accion'] = 'ninguna_rama (tipo_pedido no es 1, 2 ni 3)';
                @file_put_contents($logFile, date('Y-m-d H:i:s') . ' MESA ' . json_encode($logMesa, JSON_UNESCAPED_UNICODE) . "\n", FILE_APPEND | LOCK_EX);
            }

            return array('success' => true);
        } catch (Exception $e) 
        {
            return array('success' => false, 'message' => $e->getMessage());
        }
    }

    public function anular_venta($data)
    {
        try
        {   
            $sql2 = "UPDATE tm_venta SET estado = 'i', state_type_id = '11', motivo_anulacion = ? WHERE id_venta = ?";
            $rest = $this->db->prepare($sql2)->execute(array($data['motivo'], $data['id_venta']));

            $sql1 = "UPDATE tm_inventario SET estado = 'i' WHERE id_tipo_ope = 2 AND id_ope = ?";
            $this->db->prepare($sql1)->execute(array($data['id_venta']));
            $sql3 = "UPDATE tm_pedido SET estado = 'z', motivo='anulacion cpe' WHERE id_pedido = ?";
            $this->db->prepare($sql3)->execute(array($data['id_pedido']));

            $this->db->query("UPDATE tm_detalle_pedido SET estado = 'z', comentario='anulacion cpe' WHERE id_pedido ='".$data['id_pedido']."'");
        } 
            catch (Exception $e) 
        {
            die($e->getMessage());
        }
    }

    public function pedido_edit($data)
    {
        try 
        {
            $stm = $this->db->prepare("SELECT * FROM tm_pedido_delivery WHERE id_pedido = ?");
            $stm->execute(array($data['id_pedido']));
            $c = $stm->fetchAll(PDO::FETCH_OBJ);
            $data = array("data" => $c);
            $json = json_encode($data);
            echo $json;
        } catch (Exception $e) 
        {
            die($e->getMessage());
        }
    }

    public function pedido_delete($data)
    {
        try 
        {
            //Seleccionar producto
            $stm = $this->db->prepare("SELECT p.pro_nom AS producto, p.pro_pre AS presentacion, d.cant AS cantidad, d.precio, d.comentario, i.nombre AS nombre_imp FROM tm_detalle_pedido AS d INNER JOIN v_productos AS p ON d.id_pres = p.id_pres INNER JOIN tm_area_prod AS a ON a.id_areap = p.id_areap INNER JOIN tm_impresora AS i ON i.id_imp = a.id_imp WHERE d.id_pedido = ? AND d.id_pres = ? AND d.estado <> 'z' AND d.cant > 0 GROUP BY d.id_pres ORDER BY d.fecha_pedido DESC");
            $stm->execute(array($data['id_pedido'],$data['id_pres']));
            $data_producto = $stm->fetchAll(PDO::FETCH_OBJ);

            //Cancelar pedido
            date_default_timezone_set($_SESSION["zona_horaria"]);
            setlocale(LC_ALL,"es_ES@euro","es_ES","esp");

            $filtro_seguridad = Session::get('cod_seg');
            $anular_ped_preparado = Session::get('anular_ped_preparado');
            $fecha_envio = date("Y-m-d H:i:s");
            $consulta = "call usp_restCancelarPedido( :flag, :id_usu, :id_pres, :id_pedido, :estado_pedido, :fecha_pedido, :fecha_envio, :codigo_seguridad, :filtro_seguridad, :anular_ped_preparado, :motivo);";
            $arrayParam =  array(
                ':flag' => 1,
                ':id_usu' => Session::get('usuid'),
                ':id_pres' => $data['id_pres'],
                ':id_pedido' =>  $data['id_pedido'],
                ':estado_pedido' =>  $data['estado_pedido'],
                ':fecha_pedido' => $data['fecha_pedido'],
                ':fecha_envio' => $fecha_envio,
                ':codigo_seguridad' => $data['codigo_seguridad'],
                ':filtro_seguridad' => $filtro_seguridad,
                ':anular_ped_preparado' => $anular_ped_preparado,
                ':motivo' =>$data['motivo']
            );
            $st = $this->db->prepare($consulta);
            $st->execute($arrayParam);
            $codigo_respuesta = $st->fetchAll(PDO::FETCH_OBJ);

            $datos = array("Producto" => $data_producto,"Codigo" => $codigo_respuesta);
            $c = json_encode($datos);
            echo $c;

        } catch (Exception $e) 
        {
            die($e->getMessage());
        }
    }

    public function pedido_crud_update($data)
    {
        try 
        {
            $sql = "UPDATE tm_pedido_delivery SET id_repartidor = ?, hora_entrega = ?, amortizacion = ?, tipo_pago = ?, paga_con = ?, comision_delivery = ? WHERE id_pedido = ?";
            $this->db->prepare($sql)->execute(array($data['id_repartidor'],$data['hora_entrega'],$data['amortizacion'],
                $data['tipo_pago'],$data['paga_con'],$data['comision_delivery'],$data['id_pedido']));
        } catch (Exception $e) 
        {
            die($e->getMessage());
        }
    }

    public function venta_edit($data)
    {
        try 
        {
            $stm = $this->db->prepare("SELECT v.id_venta, vp.id_pago, vp.monto, vp.codigo, v.id_pedido,v.total , v.comision_delivery FROM tm_venta AS v LEFT JOIN tm_venta_pago AS vp ON vp.id_venta = v.id_venta WHERE v.id_venta = ?");
            $stm->execute(array($data['id_venta']));
            $c = $stm->fetchAll(PDO::FETCH_OBJ);
            $data = array("data" => $c);
            $json = json_encode($data);
            echo $json;
        } catch (Exception $e) 
        {
            die($e->getMessage());
        }
    }

    public function venta_edit_pago($data)
    {
        try 
        {
            $stm = $this->db->prepare("DELETE FROM tm_venta_pago WHERE id_venta = ?");          
            $stm->execute(array($data['id_venta']));

            $this->db = new Database(DB_TYPE, DB_HOST, DB_NAME, DB_USER, DB_PASS, DB_CHARSET);
            $e = $data['pago_tipo'];
            $f = $data['pago_monto'];

            for($y=0; $y < sizeof($e); ++$y){
                if ($f[$y] > 0){
                    $sql = "INSERT INTO tm_venta_pago (id_venta,id_pago,monto) VALUES (?,?,?);";
                    $this->db->prepare($sql)->execute(array($data['id_venta'],$e[$y],$f[$y]));
                }
            }
        } catch (Exception $e) 
        {
            die($e->getMessage());
        }
    }

    public function venta_edit_documento($data)
    {
        try 
        {
            $tipoDocumento =  $this->TipoDocumento($data['id_tipo_documento']);
            $funcions = new Functions();
            $s_c =  $funcions->newNumber($data['id_tipo_documento'], '#', $tipoDocumento['serie']);

            $conn = new Database(DB_TYPE, DB_HOST, DB_NAME, DB_USER, DB_PASS, DB_CHARSET);
            
            $flag = 1;
            $id_venta = $data['id_venta'];
            $id_cliente = $data['id_cliente'];
            $id_tipo_documento = $data['id_tipo_documento'];
            $serie = $s_c->serie;
            $correlativo = $s_c->correlativo;
        
            $sql = "UPDATE tm_venta SET id_cliente = :id_cliente, id_tipo_doc = :id_tipo_documento, serie_doc = :serie, nro_doc = :correlativo WHERE id_venta = :id_venta";
            $stmt = $conn->prepare($sql);
            $stmt->bindParam(':id_cliente', $id_cliente, PDO::PARAM_INT);
            $stmt->bindParam(':id_tipo_documento', $id_tipo_documento, PDO::PARAM_INT);
            $stmt->bindParam(':serie', $serie, PDO::PARAM_STR);
            $stmt->bindParam(':correlativo', $correlativo, PDO::PARAM_STR);
            $stmt->bindParam(':id_venta', $id_venta, PDO::PARAM_INT);
        
            $stmt->execute();
        
            return "Consulta ejecutada exitosamente";

        } catch (Exception $e) 
        {
            die($e->getMessage());
        }
    }

    /* INICIO PEDIDOS PREPARADOS */

    public function contadorPedidosPreparados()
    {
        try
        {      
            if(Session::get('rol') == 1 OR Session::get('rol') == 2 OR Session::get('rol') == 3){
                $stm = $this->db->prepare("SELECT COUNT(id_pedido) AS cantidad FROM v_cocina_me WHERE id_tipo = 1 AND cantidad > 0 AND estado = 'c'");
                $stm->execute();   
            } elseif(Session::get('rol') == 5){
                $stm = $this->db->prepare("SELECT COUNT(id_pedido) AS cantidad FROM v_cocina_me WHERE id_tipo = 1 AND id_mozo = ? AND cantidad > 0 AND estado = 'c'");
                $stm->execute(array(Session::get('usuid')));   
            }
            $stm->execute();            
            $c = $stm->fetchAll(PDO::FETCH_OBJ);
            return $c;
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function listarPedidosPreparados()
    {
        try
        {      
            if(Session::get('rol') == 1 OR Session::get('rol') == 2 OR Session::get('rol') == 3){
                $stm = $this->db->prepare("SELECT * FROM v_cocina_me WHERE id_tipo = 1 AND cantidad > 0 AND estado = 'c'");
                $stm->execute();   
            } elseif(Session::get('rol') == 5){
                $stm = $this->db->prepare("SELECT * FROM v_cocina_me WHERE id_tipo = 1 AND id_mozo = ? AND cantidad > 0 AND estado = 'c'");
                $stm->execute(array(Session::get('usuid')));   
            } 
            $c = $stm->fetchAll(PDO::FETCH_OBJ);
            $data = array("data" => $c);
            $json = json_encode($data);
            echo $json;
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function pedidoEntregado($data)
    {
        try
        {   
            $sql = "UPDATE tm_detalle_pedido SET estado = 'd' WHERE id_pedido = ? AND id_pres = ? AND fecha_pedido = ?";
            $this->db->prepare($sql)
              ->execute(array(
                $data['id_pedido'],
                $data['id_pres'],
                $data['fecha_pedido']
                ));
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

   public function pedido_estado_update($data)
{
    try 
    {
        // Solo permitimos estados válidos
        $estado_permitido = ['a', 'p', 'i'];

        // Si el estado recibido es válido, lo usamos; si no, ponemos 'a' por defecto
        $estado = in_array($data['estado'], $estado_permitido) ? $data['estado'] : 'a';

        $sql = "UPDATE tm_mesa SET estado = ? WHERE id_mesa = ?";
        $this->db->prepare($sql)->execute(array($estado, $data['id_mesa']));

        return true;
    }
    catch (Exception $e) 
    {
        return false;
    }
}


    /* FIN PEDIDOS PREPARADOS */

    public function menu_categoria_list()
    {
        try
        {
            $stm = $this->db->prepare("SELECT * FROM tm_producto_catg WHERE delivery = 1");
            $stm->execute();
            $c = $stm->fetchAll(PDO::FETCH_OBJ);
            $data = array("data" => $c);
            $json = json_encode($data);
            echo $json; 
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function menu_plato_list($data)
    {
        try
        {
            $stm = $this->db->prepare("SELECT * FROM v_productos WHERE del_a = 1 AND del_b = 1 AND del_c = 1 AND id_catg = ?");
            $stm->execute(array($data['id_catg']));
            $c = $stm->fetchAll(PDO::FETCH_OBJ);
            $data = array("data" => $c);
            $json = json_encode($data);
            echo $json; 
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function menu_plato_estado($data)
    {
        try 
        {
            if($data['estado']=='a'){$estado='i';}elseif($data['estado']=='i'){$estado='a';};
            $sql = "UPDATE tm_producto_pres SET estado = ? WHERE id_pres = ?";
            $this->db->prepare($sql)->execute(array($estado,$data['id_pres']));
        }
        catch (Exception $e) 
        {
            return false;
        }
    }

    /* INICIO IMPRESION */

    public function impresion_precuenta($id_pedido, $pr, $grupo = null)
    {
        try
        {
            $condGrupo = '';
            $paramsDetalle = array();
            if ($grupo !== null && $grupo !== '') {
                $condGrupo = " AND (COALESCE(nombre_precuenta,'') = ?)";
                $paramsDetalle[] = $grupo;
            }
            if ($pr == 'pc1') {

                $stm = $this->db->prepare("SELECT * FROM v_pedido_mesa WHERE id_pedido = ?");
                $stm->execute(array($id_pedido));
                $c = $stm->fetch(PDO::FETCH_OBJ);
                $c->{'pr'} = $pr;
                $c->{'grupo_nombre'} = $grupo;
                $sqlDet = "SELECT id_pres, cantidad, precio FROM tm_detalle_pedido WHERE id_pedido = " . (int)$c->id_pedido . " AND estado <> 'z'" . $condGrupo;
                $stmDet = $this->db->prepare($sqlDet);
                $stmDet->execute(array_merge(array(), $paramsDetalle));
                $c->{'Detalle'} = $stmDet->fetchAll(PDO::FETCH_OBJ);
                foreach($c->Detalle as $k => $d)
                {
                    $c->Detalle[$k]->{'Producto'} = $this->db->query("SELECT pro_nom, pro_pre FROM v_productos WHERE id_pres = " . $d->id_pres)
                        ->fetch(PDO::FETCH_OBJ);
    
                }
                $c->{'mozo'} = $this->db->query("SELECT * FROM tm_usuario WHERE id_usu = " . $c->id_usu."")->fetch(PDO::FETCH_OBJ);
                $c->{'host_pc'} = Session::get('host_pc');
                $c->{'nombre_pc'} = Session::get('pc_name');
                $c->{'rol_sa'} = Session::get('rol');
                $c->{'ip_pc_set'} = $c->desc_salon;
                $c->{'activated_pres'} = Session::get('activated_pres');

                return $c;            

            } elseif ($pr == 'pc2') {

                $stm = $this->db->prepare("SELECT * FROM v_pedido_llevar WHERE id_pedido = ?");
                $stm->execute(array($id_pedido));
                $c = $stm->fetch(PDO::FETCH_OBJ);
                $c->{'pr'} = $pr;
                $c->{'grupo_nombre'} = $grupo;
                $sqlDet2 = "SELECT id_pres, SUM(cantidad) AS cantidad, precio FROM tm_detalle_pedido WHERE id_pedido = " . (int)$c->id_pedido . " AND estado <> 'z'" . $condGrupo . " GROUP BY id_pres, precio";
                $stmDet2 = $this->db->prepare($sqlDet2);
                $stmDet2->execute($paramsDetalle);
                $c->{'Detalle'} = $stmDet2->fetchAll(PDO::FETCH_OBJ);
                foreach($c->Detalle as $k => $d)
                {
                    $c->Detalle[$k]->{'Producto'} = $this->db->query("SELECT pro_nom, pro_pre FROM v_productos WHERE id_pres = " . $d->id_pres)
                        ->fetch(PDO::FETCH_OBJ);
    
                }
                $c->{'mozo'} = $this->db->query("SELECT * FROM tm_usuario WHERE id_usu = " . $c->id_usu."")->fetch(PDO::FETCH_OBJ);
                $c->{'host_pc'} = Session::get('host_pc');
                $c->{'nombre_pc'} = Session::get('pc_name');
                $c->{'rol_sa'} = Session::get('rol');
                $c->{'ip_pc_set'} = "0";
                $c->{'activated_pres'} = Session::get('activated_pres');
                
                return $c;   

            }
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function impresion_reparto($id_venta)
    {
        try
        {      
            $stm = $this->db->prepare("SELECT v.id_ven, v.id_apc,v.comis_del,  v.id_ped, d.id_cliente, v.fec_ven, v.pago_efe_none, v.pago_efe_vuelto, IFNULL((v.total),0) AS total, d.nro_pedido FROM v_ventas_con AS v INNER JOIN tm_pedido_delivery AS d ON v.id_ped = d.id_pedido WHERE id_ven = ?");
            $stm->execute(array($id_venta));
            $c = $stm->fetch(PDO::FETCH_OBJ);

            // Traemos los datos del repartidor, @Braintechperu
            $c->{'Repartidor'} = $this->db->query("SELECT desc_repartidor FROM v_pedido_delivery WHERE id_pedido = " . $c->id_ped)
                ->fetch(PDO::FETCH_OBJ);
            $c->{'Cliente'} = $this->db->query("SELECT * FROM v_clientes WHERE id_cliente = " . $c->id_cliente)
                ->fetch(PDO::FETCH_OBJ);
            $c->{'Pagos'} = $this->db->query("SELECT tp.descripcion AS nombre, COUNT(*) AS cantidad, SUM(vp.monto) AS monto FROM tm_venta_pago AS vp INNER JOIN tm_venta AS v ON v.id_venta = vp.id_venta INNER JOIN tm_tipo_pago AS tp ON vp.id_pago = tp.id_tipo_pago WHERE v.id_venta = ".$c->id_ven." AND vp.monto > 0 AND v.estado = 'a' GROUP BY tp.descripcion")
                ->fetchAll(PDO::FETCH_OBJ);                
            /* Traemos el detalle */
            $c->{'Detalle'} = $this->db->query("SELECT id_prod,SUM(cantidad) AS cantidad, precio, toppings FROM tm_detalle_venta WHERE id_venta = " . $c->id_ven." GROUP BY id_prod, precio, toppings")
                ->fetchAll(PDO::FETCH_OBJ);
            foreach($c->Detalle as $k => $d)
            {
                $c->Detalle[$k]->{'Producto'} = $this->db->query("SELECT pro_nom, pro_pre FROM v_productos WHERE id_pres = " . $d->id_prod)
                    ->fetch(PDO::FETCH_OBJ);
                    
                /* Traemos el detalle de los toppings*/
                $c->Detalle[$k]->{'Toppings'} = !empty($d->toppings) ? json_decode($d->toppings, true) : [];
            }
            
            $c->{'activated_pres'} = Session::get('activated_pres');
            
            return $c;
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function contador_comanda()
    {
        try
        {   
            $stm = $this->db->prepare("SELECT COUNT(*) AS correlativo FROM tm_detalle_pedido GROUP BY id_pedido,fecha_pedido");
            $stm->execute();
            $c = $stm->fetchAll(PDO::FETCH_OBJ);
            return $c;
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }
    public function listarComandas($data)
    {
        try
        {   
            $stm = $this->db->prepare("SELECT * FROM tm_comandas WHERE id_pedido = {$data['id_pedido']};");
            $stm->execute();
            $c = $stm->fetchAll(PDO::FETCH_OBJ);
            return $c;
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function alert_pedidos_programados()
    {
        try
        {   
            $stm = $this->db->prepare("SELECT MIN(pd.hora_entrega) AS hora_entrega, pd.id_pedido, pd.nombre_cliente, pd.nro_pedido FROM tm_pedido_delivery AS pd INNER JOIN tm_pedido AS p ON pd.id_pedido = p.id_pedido WHERE pd.pedido_programado = 1 AND p.estado = 'a'");
            $stm->execute();
            $c = $stm->fetch(PDO::FETCH_OBJ);
            return $c;
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }
    /* FIN IMPRESION */
    
    public function control_stock_pedido($data)
    {
        try {
            $data['id_pres'];
            $consulta = "SELECT * FROM `v_stock_pedido` WHERE `id_ins` = :id_pedido";
            $result = $this->db->prepare($consulta);
            $result->bindParam(':id_pedido',$data['id_pres'],PDO::PARAM_INT);
            $result->execute();
            $row = $result->fetch(PDO::FETCH_OBJ);
            if($row){
                return $row;
            }else{
                return 0;
            }
            // return $row;
        } catch (Exception $e) {
            return false;
        }
    }
    public function contador_comensales($data)
    {
        try {
            date_default_timezone_set($_SESSION["zona_horaria"]);
            setlocale(LC_ALL,"es_ES@euro","es_ES","esp");
            $fecha = date("Y-m-d H:i:s");

            if($data['est'] == 'insert'){

                $stm = $this->db->prepare("SELECT * FROM v_listar_mesas WHERE id_pedido = ?");
                $stm->execute(array($data['id_pedido']));            
                $c = $stm->fetch(PDO::FETCH_OBJ);
                $sql = "INSERT INTO tm_contador_comensales (nro_personas, id_pedido, fecha_inicio, estado) VALUES (?,?,?,?);";
                $this->db->prepare($sql)->execute(array($c->nro_personas, $c->id_pedido, $c->fecha_pedido, 'a'));
            }elseif($data['est'] == 'update'){

                $sql = "UPDATE tm_contador_comensales SET fecha_fin = ?, estado = ? WHERE id_pedido = ?";
                $this->db->prepare($sql)->execute(array($fecha, 'z', $data['id_pedido']));  
            }elseif ($data['est'] == 'contador') {
                // Sincronizar: cerrar registros huérfanos (estado 'a' cuyo id_pedido ya no está en mesas activas)
                try {
                    $stm = $this->db->query("SELECT id_pedido FROM v_listar_mesas WHERE estado IN ('i','p')");
                    $ids_activos = $stm->fetchAll(PDO::FETCH_COLUMN);
                    if (!empty($ids_activos)) {
                        $placeholders = implode(',', array_fill(0, count($ids_activos), '?'));
                        $up = $this->db->prepare("UPDATE tm_contador_comensales SET fecha_fin = ?, estado = 'z' WHERE estado = 'a' AND id_pedido NOT IN ($placeholders)");
                        $params = array_merge(array($fecha), $ids_activos);
                        $up->execute($params);
                    } else {
                        $this->db->prepare("UPDATE tm_contador_comensales SET fecha_fin = ?, estado = 'z' WHERE estado = 'a'")->execute(array($fecha));
                    }
                } catch (Exception $e) {
                    // No bloquear el conteo si falla la sincronización
                }
                // SELECT * FROM `tm_contador_comensales` WHERE `estado` LIKE 'a'
                $stm = $this->db->prepare("SELECT SUM(nro_personas) AS comensales FROM tm_contador_comensales WHERE estado = 'a';");
                $stm->execute();
                $c = $stm->fetchAll(PDO::FETCH_OBJ);
                return $c;
            }elseif ($data['est'] == 'delete') {
                # code...
                $sql = "DELETE FROM tm_contador_comensales WHERE id_pedido = ?";
                $this->db->prepare($sql)->execute(array($data['id_pedido']));
            }


        } catch (Exception $e) {
            die($e->getMessage());
        }
    }
    //     
    public function repartidor_update($data)
    {
        try 
        {
            // UPDATE tm_pedido_delivery SET id_repartidor = '12' WHERE id_pedido = '4';
            $sql = "UPDATE tm_pedido_delivery SET id_repartidor = ? WHERE id_pedido = ?";
            $this->db->prepare($sql)->execute(array($data['id_repartidor'],$data['id_pedido']));
        } catch (Exception $e) 
        {
            die($e->getMessage());
        }
    }

    public function listarproductosstock()
    {
        try
        {
            $config->{'Configuracion'} = $this->db->query("SELECT * FROM tm_configuracion")->fetch(PDO::FETCH_OBJ);
            
            $stm = $this->db->prepare("SELECT * FROM v_stock WHERE id_tipo_ins LIKE '%'");
            $stm->execute();
            $c = $stm->fetchAll(PDO::FETCH_OBJ);
            
            if ($config->{'Configuracion'}->activated_pres == '1'){
                foreach($c as $k => $d)
                {
                    $c[$k]->{'Producto'} = $this->db->query("SELECT *,  ins_nom AS nom_ins, pro_pre AS nom_pro_pre FROM v_insprod WHERE id_tipo_ins = ".$d->id_tipo_ins." AND id_ins = ".$d->id_ins)
                        ->fetch(PDO::FETCH_OBJ);
                }                
            }else{
                foreach($c as $k => $d)
                {
                    $c[$k]->{'Producto'} = $this->db->query("SELECT *, ins_nom AS nom_ins, CONCAT(pro_nom, ' ' , pro_pre) AS nom_pro_pre FROM v_insprod WHERE id_tipo_ins = ".$d->id_tipo_ins." AND id_ins = ".$d->id_ins)
                        ->fetch(PDO::FETCH_OBJ);
                }                
            }

            $data = array("data" => $c);
            $json = json_encode($data);
            echo $json; 
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }
    // IMPRESION COMBO INDEPENDIENTE
    public function combo_productos($data)
    {
        try
        {   

            $validar =  $this->db->selectAll('SELECT * FROM v_productos WHERE id_pres = '.$data['id_prod'].' AND combos = 1');

            if ($validar) {

                return $prod_combo =  $this->db->selectAll("SELECT p.pro_nom AS producto, p.pro_pre AS presentacion, ROUND(SUM(d.cant*".$data['cant']."), 0) AS cantidad, '0' AS precio, '".$data['comentario']."' AS comentario, a.id_areap, i.nombre AS nombre_imp FROM tm_producto_ingr AS d INNER JOIN v_productos AS p ON d.id_ins = p.id_pres INNER JOIN tm_area_prod AS a ON a.id_areap = p.id_areap INNER JOIN tm_impresora AS i ON i.id_imp = a.id_imp WHERE d.id_pres = ".$data['id_prod']." AND d.cant > 0 GROUP BY d.id_ins;");
            }else{
                return ;
            }
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }
    /* FIN IMPRESION */    

    public function mozo_edit($data)
    {
        try 
        {

            $this->db->update('tm_pedido', array('id_usu' => $data['id_mozo']), 'id_pedido = '.$data['id_pedido']);
            $this->db->update('tm_pedido_mesa', array('id_mozo' => $data['id_mozo']), 'id_pedido = '.$data['id_pedido']);
            
            $data = array("data" => 'true');
            $json = json_encode($data);
            echo $json;
        } catch (Exception $e) 
        {
            die($e->getMessage());
        }
    }   

    public function editarClientePedido($data)
    {
        try 
        {

            $this->db->update('tm_pedido_llevar', array('nomb_cliente' => $data['nombreCliente']), 'id_pedido = '.$data['idPedido']);
            
            $data = array("data" => 'true');
            $json = json_encode($data);
            echo $json;
        } catch (Exception $e) 
        {
            die($e->getMessage());
        }
    }  

    /* INICIO COMPROBANTE SIN ENVIAR SUNAT */

    public function contadorSunatSinEnviar()
    {
        try
        {   
            

            $ds = $this->db->prepare("SELECT bloqueo FROM tm_configuracion");
			$ds->execute();
			$data_s = $ds->fetch();

            if(Session::get('rol') == 1){
				Session::set('bloqueo', '0');
				Session::set('bloqueo_id', $data_s['bloqueo']);
                $status = '';
			}else{
				Session::set('bloqueo', $data_s['bloqueo']); 
				Session::set('bloqueo_id', $data_s['bloqueo']); 
                $status = 'bloqueo';
			}            
        
            $stm = $this->db->prepare("SELECT COUNT(v.id_ven) AS total FROM v_ventas_con AS v INNER JOIN v_caja_aper AS c ON v.id_apc = c.id_apc INNER JOIN tm_tipo_doc AS d ON v.id_tdoc = d.id_tipo_doc WHERE v.ser_doc = d.serie AND v.id_tdoc <> 3 AND (v.state_type_id = '01' OR v.state_type_id = '03')");
            $stm->execute();        
            $c = $stm->fetch(PDO::FETCH_OBJ);

            if($data_s['bloqueo'] == 0 ){
                $c->{'status'} = '';
            }else{
                $c->{'status'} = $status;
            }  
            return $c;
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    /* FIN COMPROBANTE SIN ENVIAR SUNAT */

    /**
     * Registrar facturación electrónica para una venta específica
     */
    public function RegistrarFacturacionElectronica($data)
    {
        $log_file = __DIR__ . '/../debug_facturacion_electronica.log';
        $log_message = date('Y-m-d H:i:s') . " === MODELO RegistrarFacturacionElectronica ===\n";
        $log_message .= "Datos recibidos:\n" . print_r($data, true) . "\n";
        file_put_contents($log_file, $log_message, FILE_APPEND);
        error_log($log_message);
        
        try {
            require_once 'models/facturacion_electronica_model.php';
            $fe_model = new Facturacion_Electronica_Model();
            
            // Total del documento: importe a pagar. En facturación dividida se envía el total por precuenta y no se sobrescribe.
            $total_doc = isset($data['total']) ? floatval($data['total']) : 0;
            $es_facturacion_dividida = !empty($data['facturacion_dividida']);
            if (!$es_facturacion_dividida && isset($data['id_venta']) && $data['id_venta']) {
                $stm_v = $this->db->prepare("SELECT total, comision_delivery, comision_tarjeta FROM tm_venta WHERE id_venta = ?");
                $stm_v->execute(array($data['id_venta']));
                $v = $stm_v->fetch(PDO::FETCH_OBJ);
                if ($v) {
                    $total_doc = floatval($v->total) + floatval($v->comision_delivery) + floatval($v->comision_tarjeta);
                }
            }
            
            // Preparar datos para guardar
            $fe_data = array(
                'id_venta' => $data['id_venta'],
                'id_pedido' => isset($data['id_pedido']) ? $data['id_pedido'] : null,
                'cliente_id' => isset($data['cliente_id']) ? $data['cliente_id'] : null,
                'tipo_doc' => isset($data['tipo_doc']) ? $data['tipo_doc'] : null,
                'total' => $total_doc,
                'observacion' => isset($data['observacion']) ? $data['observacion'] : null,
                'id_serie_electronica' => isset($data['id_serie_electronica']) ? $data['id_serie_electronica'] : null,
                'serie_electronica' => isset($data['serie_electronica']) ? $data['serie_electronica'] : null,
                'correlativo_electronico' => isset($data['correlativo_electronico']) ? $data['correlativo_electronico'] : null,
                'pos_electronico' => isset($data['pos_electronico']) ? $data['pos_electronico'] : null,
                'tipo_documento_electronico' => isset($data['tipo_documento_electronico']) ? $data['tipo_documento_electronico'] : null,
                'impuesto_incluido' => Session::get('impuesto_incluido') ? Session::get('impuesto_incluido') : '0',
                'igv' => Session::get('igv') ? Session::get('igv') : 0.07,
                'items' => $this->preparar_items_fe($data),
                'payments' => $this->preparar_payments_fe($data)
            );
            
            $log_message = date('Y-m-d H:i:s') . " Datos preparados para FE:\n";
            $log_message .= "  - id_venta: " . $fe_data['id_venta'] . "\n";
            $log_message .= "  - id_serie_electronica: " . ($fe_data['id_serie_electronica'] ?? 'NULL') . "\n";
            $log_message .= "  - Items: " . count($fe_data['items']) . "\n";
            $log_message .= "  - Payments: " . count($fe_data['payments']) . "\n";
            file_put_contents($log_file, $log_message, FILE_APPEND);
            error_log($log_message);
            
            $result_fe = $fe_model->guardar_documento_fe($fe_data);
            
            if (!$result_fe['success']) {
                $log_message = date('Y-m-d H:i:s') . " ❌ ERROR al guardar facturación electrónica: " . (isset($result_fe['message']) ? $result_fe['message'] : 'Error desconocido') . "\n";
                file_put_contents($log_file, $log_message, FILE_APPEND);
                error_log($log_message);
                return array('success' => false, 'message' => $result_fe['message']);
            } else {
                $log_message = date('Y-m-d H:i:s') . " ✅ Facturación electrónica guardada exitosamente. ID documento FE: " . (isset($result_fe['id_documento_fe']) ? $result_fe['id_documento_fe'] : 'NO DISPONIBLE') . "\n";
                file_put_contents($log_file, $log_message, FILE_APPEND);
                error_log($log_message);
                return array('success' => true, 'id_documento_fe' => $result_fe['id_documento_fe']);
            }
        } catch (Exception $e) {
            $log_message = date('Y-m-d H:i:s') . " ❌ EXCEPCIÓN al guardar facturación electrónica: " . $e->getMessage() . "\n";
            file_put_contents($log_file, $log_message, FILE_APPEND);
            error_log($log_message);
            return array('success' => false, 'message' => $e->getMessage());
        }
    }
}

