<?php Session::init(); ?>
<?php

class Contable_Model extends Model
{
    public function __construct()
    {
        parent::__construct();
    }
    public function TipoDocumento()
    {
        try
        {   
            return $this->db->selectAll('SELECT * FROM tm_tipo_doc WHERE id_tipo_doc != "3" AND estado = "a"');
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }
    public function Empresa()
    {
        try
        {      
            return $this->db->selectOne("SELECT * FROM tm_empresa");
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function StateType($id)
    {
        try
        {  
            return $this->db->selectOne('SELECT * FROM `tm_state_type` WHERE id LIKE "'.$id.'"');        
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function venta_all_list($data)
    {
        try
        {
            $ifecha = date('Y-m-d',strtotime($data['start']));
            $ffecha = date('Y-m-d',strtotime($data['end']));

            if (isset($data['filter']) && $data['filter'] == 2) {
                $periodo = $data['p_anio']."-".$data['p_mes'];

                $ifecha = date('Y-m-01', strtotime($periodo));
                // Obtener el último día del mes
                $ffecha = date('Y-m-t', strtotime($periodo));
            }
            
            $stm = $this->db->prepare("SELECT v.id_ven,v.id_ped,v.id_tped,v.desc_monto,v.comis_tar,v.igv,v.rc, v.comis_del,v.total AS stotal, v.comis_rc, v.fec_ven,v.desc_td,v.ser_doc,v.nro_doc,v.state_type_id as estado, v.enviado_sunat,IF((v.desc_tipo = 1),0,v.total) AS total, v.id_cli,v.igv,v.id_usu,v.desc_tipo,v.desc_personal,c.desc_caja, c.id_apc FROM v_ventas_con AS v INNER JOIN v_caja_aper AS c ON v.id_apc = c.id_apc WHERE  (DATE_FORMAT(v.fec_ven,'%Y-%m-%d') >= ? AND DATE_FORMAT(v.fec_ven,'%Y-%m-%d') <= ?) AND v.id_tped like '%' AND v.id_tdoc <> '3' AND v.id_cli like '%' GROUP BY v.id_ven");

            $stm->execute(array($ifecha,$ffecha));
            $c = $stm->fetchAll(PDO::FETCH_OBJ);
                       
            foreach($c as $k => $d)
            {
                $c[$k]->{'Pedido'} = $this->db->query("SELECT vm.desc_salon, vm.nro_mesa FROM tm_pedido_mesa AS pm INNER JOIN v_mesas AS vm ON pm.id_mesa = vm.id_mesa WHERE pm.id_pedido = ".$d->id_ped)->fetch(PDO::FETCH_OBJ);

                $c[$k]->{'Detalle'} = $this->db->query("SELECT v_productos.pro_cod AS codigo_producto, 
                CONCAT(v_productos.pro_nom,' ',v_productos.pro_pre) AS nombre_producto, 
                IF(v_productos.pro_imp='1','10','20') AS codigo_afectacion, 
                CAST(tm_detalle_venta.cantidad AS DECIMAL(7,2)) AS cantidad, 
                IF(v_productos.pro_imp='1',ROUND((tm_detalle_venta.precio/(1 + {$d->igv})),2),tm_detalle_venta.precio) AS valor_unitario,
                tm_detalle_venta.precio AS precio_unitario,
                IF(v_productos.pro_imp='1',ROUND((tm_detalle_venta.precio/(1 + {$d->igv}))*tm_detalle_venta.cantidad,2),
                ROUND(tm_detalle_venta.precio*tm_detalle_venta.cantidad,2)) AS valor_venta,
                IF(v_productos.pro_imp='1',ROUND((tm_detalle_venta.precio/(1 + {$d->igv})*tm_detalle_venta.cantidad)*{$d->igv},2),0) AS total_igv 
                FROM tm_detalle_venta 
                INNER JOIN tm_venta ON tm_detalle_venta.id_venta = tm_venta.id_venta 
                INNER JOIN v_productos ON tm_detalle_venta.id_prod = v_productos.id_pres 
                WHERE tm_venta.id_tipo_doc  IN ('1','2','3') AND tm_detalle_venta.precio > 0 AND tm_detalle_venta.id_venta = ".$d->id_ven)->fetchAll(PDO::FETCH_OBJ);

                $c[$k]->{'Cliente'} = $this->db->query("SELECT * FROM v_clientes WHERE id_cliente = ".$d->id_cli)->fetch(PDO::FETCH_OBJ);

            }

            return $c;      
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }

    public function validador_list($data)
    {
        try
        {
            $empresa = $this->Empresa();

            $token   = $this->api_validador();   // valido por 1 hora

            $ifecha = date('Y-m-d',strtotime($data['ifecha']));
            $ffecha = date('Y-m-d',strtotime($data['ffecha']));
            $desde     = $data['desde'];
            $hasta     = $data['hasta'];
            $tbusqueda = $data['tbusqueda'];

            if ($tbusqueda == '0') {            

                if($data['tdoc'] == '%'):
                    $estado = "v.id_tdoc <> 3";
                else: 
                    $estado = "v.id_tdoc = ".$data['tdoc'];
                endif;
                
                $stm = $this->db->prepare("SELECT v.*, IFNULL((v.total+v.comis_del-v.desc_monto),0) AS total FROM v_ventas_con AS v INNER JOIN v_caja_aper AS c ON v.id_apc = c.id_apc WHERE (DATE_FORMAT(v.fec_ven,'%Y-%m-%d') >= ? AND DATE_FORMAT(v.fec_ven,'%Y-%m-%d') <= ?) AND v.id_tdoc like ? AND ".$estado." GROUP BY v.id_ven");
                $stm->execute(array($ifecha,$ffecha,$_POST['tdoc']));

            
            }else{
                if ($hasta) {
                    $stm = $this->db->prepare("SELECT v.*, IFNULL((v.total+v.comis_del-v.desc_monto),0) AS total FROM v_ventas_con AS v WHERE v.id_tdoc = ".$data['tdoc']." AND v.nro_doc BETWEEN ? AND ?  GROUP BY v.id_ven");
                    $stm->execute(array($desde,$hasta));
                }else{
                    $stm = $this->db->prepare("SELECT v.*, IFNULL((v.total+v.comis_del-v.desc_monto),0) AS total FROM v_ventas_con AS v FROM v_ventas_con AS v WHERE v.id_tdoc = ".$data['tdoc']." AND v.nro_doc = ? GROUP BY v.id_ven");
                    $stm->execute(array($desde));
                }
            }
            
            $c = $stm->fetchAll(PDO::FETCH_OBJ);  

            foreach($c as $k => $d)
            {
                $c[$k]->{'State'} = $this->StateType($d->state_type_id);
                $c[$k]->{'Cliente'} = $this->db->query("SELECT dni,ruc,nombre FROM v_clientes WHERE id_cliente = ".$d->id_cli)
                    ->fetch(PDO::FETCH_OBJ);
            }
            foreach($c as $k => $d)
            {
                $codComp = array('BOLETA DE VENTA'=> "03", "FACTURA" => '01');
                $form_params = [
                    'numRuc' => $empresa['ruc'],
                    'codComp' => $codComp[$d->desc_td],
                    'numeroSerie' => $d->ser_doc,
                    'numero' => $d->nro_doc,
                    'fechaEmision' => date('d/m/Y',strtotime($d->fec_ven)),
                    'monto' => $d->total,
                    'token' =>$token['data']['access_token']
                ];
                $c[$k]->{'Estado_Sunat'} = $this->search($form_params);
            }
            $data = array("data" => $c);
            $json = json_encode($data);
            echo $json;       
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }
    /* funcion consulta key para el validador   */
    public function api_validador()
    {
        $empresa = $this->Empresa();
		$GRANT_TYPE = 'client_credentials';
		$SCOPE = 'https://api.sunat.gob.pe/v1/contribuyente/contribuyentes';

		$curl = curl_init();
            
		$form_params = [
			'grant_type' => $GRANT_TYPE,
			'scope' => $SCOPE,
			'client_id' => $empresa['client_id'] ,
			'client_secret' => $empresa['client_secret'], 
		];

		curl_setopt_array($curl, array(
			CURLOPT_URL => "https://api-seguridad.sunat.gob.pe/v1/clientesextranet/".$empresa['client_id']."/oauth2/token",
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => '',
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 0,
			CURLOPT_FOLLOWLOCATION => true,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => 'POST',
			CURLOPT_POSTFIELDS => http_build_query($form_params),
			CURLOPT_HTTPHEADER => array(
				'Content-Type: application/x-www-form-urlencoded',
			),
		));

		$response = curl_exec($curl);

		curl_close($curl);
		$data = json_decode($response, true);

		if(array_key_exists('access_token', $data)){
			
			return [
				'success' => true,
				'data' => [
					'access_token' => $data['access_token'],
					'token_type' => $data['token_type'],
					'expires_in' => $data['expires_in'],
				],
			];
		}

		$error_description = $data['error_description'] ?? '';
		$error = $data['error'] ?? '';
		
		return [
			'success' => false,
			'message' => 'Error al obtener token - error_description: '.$error_description.' error: '.$error
		];
    }
    /*  VALIDARA POR COMPROBANTE INDIVIDUAL */
    public function validar_cpe()
    {
        // datos y config de empresa
        $empresa = $this->Empresa();
        $rptSunat = '';
        //extramos datos del cpe
        $stm = $this->db->prepare("SELECT v.ser_doc,v.nro_doc,v.fec_ven,v.desc_td,IFNULL((v.total+v.comis_del-v.desc_monto),0) AS total 
            FROM v_ventas_con AS v 
            WHERE v.id_ven = ? AND  v.id_tdoc <> 3 GROUP BY v.id_ven");
        $stm->execute(array($_POST['id_venta']));
        $d = $stm->fetch(PDO::FETCH_OBJ);


        $codComp = array('BOLETA DE VENTA'=> "03", "FACTURA" => '01');
        $form_params = [
            'numRuc' => $empresa['ruc'],
            'codComp' => $codComp[$d->desc_td],
            'numeroSerie' => $d->ser_doc,
            'numero' => $d->nro_doc,
            'fechaEmision' => date('d/m/Y',strtotime($d->fec_ven)),
            'monto' => $d->total,
        ];

        $rptSunat = $this->search($form_params, true);

        if($rptSunat['status'] == 401){
            $response = [
                'success' => false,
                'message' => 'No autorizado, debe configurar en el modulo empresa.'
            ];
            echo json_encode($response);
            return;
        }else{
            if ($rptSunat['success'] == false) {
                $response = [
                    'success'   => $rptSunat['success'],
                    'message'   => $rptSunat['message'],
                    'errorCode' => $rptSunat['errorCode']
                ];
                echo json_encode($response);
                return;
            }
            $response = [
                'success' => true,
                'message' => 'Consultado con exito.',
                'sunat'   => $rptSunat
                // 'sistema' => $d
            ];
            echo json_encode($response);
            return;
        }
    }
    
    public function search($parametros, $cpe = false)
    {
        try {
            $BASE_URL = 'https://api.sunat.gob.pe/v1/contribuyente/contribuyentes';
            $empresa = $this->Empresa();
            $token   = $this->api_validador();

            $form_params = [
                'numRuc' => $parametros['numRuc'],
                'codComp' => $parametros['codComp'],
                'numeroSerie' => $parametros['numeroSerie'],
                'numero' => $parametros['numero'],
                'fechaEmision' => $parametros['fechaEmision'],
                'monto' => $parametros['monto'],
            ];


            $curl = curl_init();
            
            curl_setopt_array($curl, array(
                CURLOPT_URL => $BASE_URL."/".$empresa['ruc']."/validarcomprobante",
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_POSTFIELDS => json_encode($form_params),
                CURLOPT_HTTPHEADER => array(
                    "Authorization: Bearer ".$token['data']['access_token'],
                    'Content-Type: application/json'
                ),
            ));
            
            $response = curl_exec($curl);
            
            curl_close($curl);

            $res = json_decode($response, true);
            if($res['success']){
                if ($cpe == true) {
                    return [
                        'success'        => $res['success'],
                        'estadoCp_id'    => $res['data']['estadoCp'],
                        'estadoCp'       => $this->estadoCp($res['data']['estadoCp']),
                        'condDomiRuc_id' => $res['data']['condDomiRuc'],
                        'condDomiRuc'    => $this->condDomiRuc($res['data']['condDomiRuc']),
                        'estadoRuc_id'   => $res['data']['estadoRuc'],
                        'estadoRuc'      => $this->estadoRuc($res['data']['estadoRuc']),
                        'observaciones'  => $res['data']['observaciones']
                    ];
                }else{
                    return $res['data']['estadoCp'] ?? null;
                }
            }

            return $res;

        } catch (Exception $e) {

            die($e->getMessage());

        }

    }

    public function getShortDocumentType($document_type_id)
    {

        $document_type = "";

        switch ($document_type_id) {
            case 'FACTURA':
                $document_type = 'FT';
                break;
            case 'BOLETA DE VENTA':
                $document_type = 'BV';
                break;
        }

        return $document_type;

    }
    
    public function estadoCp($estado)
    {
        $document_state = [
            '0' => 'NO EXISTE', //'NO EXISTE' custom code
            '1' => 'ACEPTADO', //'ACEPTADO'
            '2' => 'ANULADO', //'ANULADO'
        ];
        return $document_state[$estado];
    }
    public function estadoRuc($estado)
    {
        $company_state = [
            '-'  => '-',
            '00' => 'ACTIVO',
            '01' => 'BAJA PROVISIONAL',
            '02' => 'BAJA PROV. POR OFICIO',
            '03' => 'SUSPENSION TEMPORAL',
            '10' => 'BAJA DEFINITIVA',
            '11' => 'BAJA DE OFICIO',
            '12' => 'BAJA MULT.INSCR. Y OTROS ',
            '20' => 'NUM. INTERNO IDENTIF.',
            '21' => 'OTROS OBLIGADOS',
            '22' => 'INHABILITADO-VENT.UNICA',
            '30' => 'ANULACION - ERROR SUNAT   '
        ];
        return $company_state[$estado];
    }
    public function condDomiRuc($condicion)
    {
        $company_condition = [
            '-'  => '-',
            '00' => 'HABIDO',
            '01' => 'NO HALLADO SE MUDO DE DOMICILIO',
            '02' => 'NO HALLADO FALLECIO',
            '03' => 'NO HALLADO NO EXISTE DOMICILIO',
            '04' => 'NO HALLADO CERRADO',
            '05' => 'NO HALLADO NRO.PUERTA NO EXISTE',
            '06' => 'NO HALLADO DESTINATARIO DESCONOCIDO',
            '07' => 'NO HALLADO RECHAZADO',
            '08' => 'NO HALLADO OTROS MOTIVOS',
            '09' => 'PENDIENTE',
            '10' => 'NO APLICABLE',
            '11' => 'POR VERIFICAR',
            '12' => 'NO HABIDO',
            '20' => 'NO HALLADO',
            '21' => 'NO EXISTE LA DIRECCION DECLARADA',
            '22' => 'DOMICILIO CERRADO',
            '23' => 'NEGATIVA RECEPCION X PERSONA CAPAZ',
            '24' => 'AUSENCIA DE PERSONA CAPAZ',
            '25' => 'NO APLICABLE X TRAMITE DE REVERSION',
            '40' => 'DEVUELTO'
        ];
        return $company_condition[$condicion];
    }
    
    public function tipo_cambio()
    {

        try {

            $curl = curl_init();

            curl_setopt_array($curl, array(
                CURLOPT_URL => 'https://www.sunat.gob.pe/a/txt/tipoCambio.txt',
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 15,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'GET',
            ));

            $response = curl_exec($curl);

            curl_close($curl);


            if ($response != "") {
                $html = $response;

                $explode = explode('|', $html);

                return $explode[2];

            }

        } catch (Exception $e) {

            die($e->getMessage());

        }
    }

    public function ExcelConcar($data)
    {

        try {
            error_reporting(0);
            require_once "libs/PHPExcel/Classes/PHPExcel.php";
            $objPHPExcel = new PHPExcel();
            $objPHPExcel->setActiveSheetIndex(0)
            ->SetCellValue('A1','Sub Diario')
            ->SetCellValue('B1','Número de Comprobante')
            ->SetCellValue('C1','Fecha de Comprobante')
            ->SetCellValue('D1','Código de Moneda')
            ->SetCellValue('E1','Glosa Principal')
            ->SetCellValue('F1','Tipo de Cambio')
            ->SetCellValue('G1','Tipo de Conversión')
            ->SetCellValue('H1','Flag de Conversión de Moneda')
            ->SetCellValue('I1','Fecha Tipo de Cambio')
            ->SetCellValue('J1','Cuenta Contable')
            ->SetCellValue('K1','Código de Anexo')
            ->SetCellValue('L1','Código de Centro de Costo')
            ->SetCellValue('M1','Debe / Haber')
            ->SetCellValue('N1','Importe Original')
            ->SetCellValue('O1','Importe en Dólares')
            ->SetCellValue('P1',' Importe en Soles')
            ->SetCellValue('Q1','Tipo de Documento')
            ->SetCellValue('R1','Número de Documento')
            ->SetCellValue('S1','Fecha de Documento')
            ->SetCellValue('T1','Fecha de Vencimiento')
            ->SetCellValue('U1','Código de Area')
            ->SetCellValue('V1','Glosa Detalle')
            ->SetCellValue('W1','Código de Anexo Auxiliar')
            ->SetCellValue('X1','Medio de Pago')
            ->SetCellValue('Y1','Tipo de Documento de Referencia')
            ->SetCellValue('Z1','Número de Documento Referencia')
            ->SetCellValue('AA1','Fecha Documento Referencia')
            ->SetCellValue('AB1','Nro Máq. Registradora Tipo Doc. Ref.')
            ->SetCellValue('AC1','Base Imponible Documento Referencia')
            ->SetCellValue('AD1','IGV Documento Provisión')
            ->SetCellValue('AE1','Tipo Referencia en estado MQ')
            ->SetCellValue('AF1','Número Serie Caja Registradora')
            ->SetCellValue('AG1','Fecha de Operación')
            ->SetCellValue('AH1','Tipo de Tasa')
            ->SetCellValue('AI1','Tasa Detracción/Percepción')
            ->SetCellValue('AJ1','Importe Base Detracción/Percepción Dólares')
            ->SetCellValue('AK1','Importe Base Detracción/Percepción Soles')
            ->SetCellValue('AL1','Tipo Cambio para "F"')
            ->SetCellValue('AM1','Importe de IGV sin derecho crédito fiscal');

            $datos = $this->venta_all_list($data);
            $i      = 2;
            $ii     = 3;
            $iii    = 4;
            foreach( $datos as $id => $row) {

                $date_of_issue = date('d-m-Y',strtotime($row->fec_ven));
                $main_gloss = 'VENTAS DEL DIA '.date('dmY',strtotime($row->fec_ven));
                $tipo_cambio = $this->tipo_cambio();
                $document_type_id = $this->getShortDocumentType($row->desc_td);

                $number_full = $row->ser_doc."-".$row->nro_doc;

                $number_index = date('m',strtotime($row->fec_ven)).str_pad($id + 1, 4, "0", STR_PAD_LEFT);
                $total_ope_gravadas = 0;
                $total_igv_gravadas = 0;
                $total_ope_exoneradas = 0;
                $total_igv_exoneradas = 0;

                if($row->Cliente->tipo_cliente == '2'){
                    $customer_identity_document_type_id = '6';
                    $customer_number = $row->Cliente->ruc;
                }else{
                    $customer_identity_document_type_id = $row->Cliente->tipo_cliente;
                    $customer_number = $row->Cliente->dni;
                }
                $total = $row->total;

                foreach($row->Detalle as $d){
                    if ($row->estado == '11'|| $row->estado == '09') : 
                        $valor_venta    = '0';
                        $total_igv      = '0';
                        $totales        = '0';
                    else : 
                        $valor_venta    = $d->valor_venta;
                        $total_igv      = $d->total_igv;
                        $totales =$d->valor_venta + $d->total_igv;
                    endif; 

                    $objPHPExcel->getActiveSheet()->SetCellValue('A'.$i,'05');
                    $objPHPExcel->getActiveSheet()->SetCellValue('B'.$i,$number_index);
                    $objPHPExcel->getActiveSheet()->SetCellValue('C'.$i,$date_of_issue);
                    $objPHPExcel->getActiveSheet()->SetCellValue('D'.$i,'MN');
                    $objPHPExcel->getActiveSheet()->SetCellValue('E'.$i,$main_gloss);
                    $objPHPExcel->getActiveSheet()->SetCellValue('F'.$i,$tipo_cambio);
                    $objPHPExcel->getActiveSheet()->SetCellValue('G'.$i,'V');
                    $objPHPExcel->getActiveSheet()->SetCellValue('H'.$i,'S');
                    $objPHPExcel->getActiveSheet()->SetCellValue('I'.$i,'');
                    $objPHPExcel->getActiveSheet()->SetCellValue('J'.$i,'12121');
                    $objPHPExcel->getActiveSheet()->SetCellValue('K'.$i,$customer_number);
                    $objPHPExcel->getActiveSheet()->SetCellValue('L'.$i,'');
                    $objPHPExcel->getActiveSheet()->SetCellValue('M'.$i,'D');
                    $objPHPExcel->getActiveSheet()->SetCellValue('N'.$i,$totales);
                    $objPHPExcel->getActiveSheet()->SetCellValue('O'.$i,number_format($totales / $tipo_cambio, 2, ".", ""));
                    $objPHPExcel->getActiveSheet()->SetCellValue('P'.$i,$totales);
                    $objPHPExcel->getActiveSheet()->SetCellValue('Q'.$i,$document_type_id);
                    $objPHPExcel->getActiveSheet()->SetCellValue('R'.$i,$number_full);
                    $objPHPExcel->getActiveSheet()->SetCellValue('S'.$i,$date_of_issue);
                    $objPHPExcel->getActiveSheet()->SetCellValue('T'.$i,$date_of_issue);
                    $objPHPExcel->getActiveSheet()->SetCellValue('U'.$i,'');
                    $objPHPExcel->getActiveSheet()->SetCellValue('V'.$i,$document_type_id.'-'.$number_full);
                    $objPHPExcel->getActiveSheet()->SetCellValue('W'.$i,'');
                    $objPHPExcel->getActiveSheet()->SetCellValue('X'.$i,'');
                    $objPHPExcel->getActiveSheet()->SetCellValue('Y'.$i,'');
                    $objPHPExcel->getActiveSheet()->SetCellValue('Z'.$i,'');
                    $objPHPExcel->getActiveSheet()->SetCellValue('AA'.$i,'');
                    $objPHPExcel->getActiveSheet()->SetCellValue('AB'.$i,'');
                    $objPHPExcel->getActiveSheet()->SetCellValue('AC'.$i,'');
                    $objPHPExcel->getActiveSheet()->SetCellValue('AD'.$i,'');
                    $objPHPExcel->getActiveSheet()->SetCellValue('AE'.$i,'');
                    $objPHPExcel->getActiveSheet()->SetCellValue('AF'.$i,'');
                    $objPHPExcel->getActiveSheet()->SetCellValue('AG'.$i,'');
                    $objPHPExcel->getActiveSheet()->SetCellValue('AH'.$i,'');
                    $objPHPExcel->getActiveSheet()->SetCellValue('AI'.$i,'');
                    $objPHPExcel->getActiveSheet()->SetCellValue('AJ'.$i,'');
                    $objPHPExcel->getActiveSheet()->SetCellValue('AK'.$i,'');
                    $objPHPExcel->getActiveSheet()->SetCellValue('AL'.$i,'');
                    $objPHPExcel->getActiveSheet()->SetCellValue('AM'.$i,'');
                        // 2da fila 
                    $objPHPExcel->getActiveSheet()->SetCellValue('A'.$ii,'05');
                    $objPHPExcel->getActiveSheet()->SetCellValue('B'.$ii,$number_index);
                    $objPHPExcel->getActiveSheet()->SetCellValue('C'.$ii,$date_of_issue);
                    $objPHPExcel->getActiveSheet()->SetCellValue('D'.$ii,'MN');
                    $objPHPExcel->getActiveSheet()->SetCellValue('E'.$ii,$main_gloss);
                    $objPHPExcel->getActiveSheet()->SetCellValue('F'.$ii,$tipo_cambio);
                    $objPHPExcel->getActiveSheet()->SetCellValue('G'.$ii,'V');
                    $objPHPExcel->getActiveSheet()->SetCellValue('H'.$ii,'S');
                    $objPHPExcel->getActiveSheet()->SetCellValue('I'.$ii,'');
                    $objPHPExcel->getActiveSheet()->SetCellValue('J'.$ii,'40111');
                    $objPHPExcel->getActiveSheet()->SetCellValue('K'.$ii,$customer_number);
                    $objPHPExcel->getActiveSheet()->SetCellValue('L'.$ii,'');
                    $objPHPExcel->getActiveSheet()->SetCellValue('M'.$ii,'H');
                    $objPHPExcel->getActiveSheet()->SetCellValue('N'.$ii,number_format(($total_igv), 2, ".", ""));
                    $objPHPExcel->getActiveSheet()->SetCellValue('O'.$ii,number_format((($total_igv) / $tipo_cambio), 2, ".", ""));
                    $objPHPExcel->getActiveSheet()->SetCellValue('P'.$ii,number_format(($total_igv), 2, ".", ""));
                    $objPHPExcel->getActiveSheet()->SetCellValue('Q'.$ii,$document_type_id);
                    $objPHPExcel->getActiveSheet()->SetCellValue('R'.$ii,$number_full);
                    $objPHPExcel->getActiveSheet()->SetCellValue('S'.$ii,$date_of_issue);
                    $objPHPExcel->getActiveSheet()->SetCellValue('T'.$ii,$date_of_issue);
                    $objPHPExcel->getActiveSheet()->SetCellValue('U'.$ii,'');
                    $objPHPExcel->getActiveSheet()->SetCellValue('V'.$ii,$document_type_id.'-'.$number_full);
                    $objPHPExcel->getActiveSheet()->SetCellValue('W'.$ii,'');
                    $objPHPExcel->getActiveSheet()->SetCellValue('X'.$ii,'');
                    $objPHPExcel->getActiveSheet()->SetCellValue('Y'.$ii,'');
                    $objPHPExcel->getActiveSheet()->SetCellValue('Z'.$ii,'');
                    $objPHPExcel->getActiveSheet()->SetCellValue('AA'.$ii,'');
                    $objPHPExcel->getActiveSheet()->SetCellValue('AB'.$ii,'');
                    $objPHPExcel->getActiveSheet()->SetCellValue('AC'.$ii,'');
                    $objPHPExcel->getActiveSheet()->SetCellValue('AD'.$ii,'');
                    $objPHPExcel->getActiveSheet()->SetCellValue('AE'.$ii,'');
                    $objPHPExcel->getActiveSheet()->SetCellValue('AF'.$ii,'');
                    $objPHPExcel->getActiveSheet()->SetCellValue('AG'.$ii,'');
                    $objPHPExcel->getActiveSheet()->SetCellValue('AH'.$ii,'');
                    $objPHPExcel->getActiveSheet()->SetCellValue('AI'.$ii,'');
                    $objPHPExcel->getActiveSheet()->SetCellValue('AJ'.$ii,'');
                    $objPHPExcel->getActiveSheet()->SetCellValue('AK'.$ii,'');
                    $objPHPExcel->getActiveSheet()->SetCellValue('AL'.$ii,'');
                    $objPHPExcel->getActiveSheet()->SetCellValue('AM'.$ii,'');
                        // 3ra fila
                    $objPHPExcel->getActiveSheet()->SetCellValue('A'.$iii,'05');
                    $objPHPExcel->getActiveSheet()->SetCellValue('B'.$iii,$number_index);
                    $objPHPExcel->getActiveSheet()->SetCellValue('C'.$iii,$date_of_issue);
                    $objPHPExcel->getActiveSheet()->SetCellValue('D'.$iii,'MN');
                    $objPHPExcel->getActiveSheet()->SetCellValue('E'.$iii,$main_gloss);
                    $objPHPExcel->getActiveSheet()->SetCellValue('F'.$iii,$tipo_cambio);
                    $objPHPExcel->getActiveSheet()->SetCellValue('G'.$iii,'V');
                    $objPHPExcel->getActiveSheet()->SetCellValue('H'.$iii,'S');
                    $objPHPExcel->getActiveSheet()->SetCellValue('I'.$iii,'');
                    $objPHPExcel->getActiveSheet()->SetCellValue('J'.$iii,'70111');
                    $objPHPExcel->getActiveSheet()->SetCellValue('K'.$iii,$customer_number);
                    $objPHPExcel->getActiveSheet()->SetCellValue('L'.$iii,'');
                    $objPHPExcel->getActiveSheet()->SetCellValue('M'.$iii,'H');
                    $objPHPExcel->getActiveSheet()->SetCellValue('N'.$iii,$valor_venta);
                    $objPHPExcel->getActiveSheet()->SetCellValue('O'.$iii,number_format($valor_venta / $tipo_cambio, 2, ".", ""));
                    $objPHPExcel->getActiveSheet()->SetCellValue('P'.$iii,$valor_venta);
                    $objPHPExcel->getActiveSheet()->SetCellValue('Q'.$iii,$document_type_id);
                    $objPHPExcel->getActiveSheet()->SetCellValue('R'.$iii,$number_full);
                    $objPHPExcel->getActiveSheet()->SetCellValue('S'.$iii,$date_of_issue);
                    $objPHPExcel->getActiveSheet()->SetCellValue('T'.$iii,$date_of_issue);
                    $objPHPExcel->getActiveSheet()->SetCellValue('U'.$iii,'');
                    $objPHPExcel->getActiveSheet()->SetCellValue('V'.$iii,$document_type_id.'-'.$number_full);
                    $objPHPExcel->getActiveSheet()->SetCellValue('W'.$iii,'');
                    $objPHPExcel->getActiveSheet()->SetCellValue('X'.$iii,'');
                    $objPHPExcel->getActiveSheet()->SetCellValue('Y'.$iii,'');
                    $objPHPExcel->getActiveSheet()->SetCellValue('Z'.$iii,'');
                    $objPHPExcel->getActiveSheet()->SetCellValue('AA'.$iii,'');
                    $objPHPExcel->getActiveSheet()->SetCellValue('AB'.$iii,'');
                    $objPHPExcel->getActiveSheet()->SetCellValue('AC'.$iii,'');
                    $objPHPExcel->getActiveSheet()->SetCellValue('AD'.$iii,'');
                    $objPHPExcel->getActiveSheet()->SetCellValue('AE'.$iii,'');
                    $objPHPExcel->getActiveSheet()->SetCellValue('AF'.$iii,'');
                    $objPHPExcel->getActiveSheet()->SetCellValue('AG'.$iii,'');
                    $objPHPExcel->getActiveSheet()->SetCellValue('AH'.$iii,'');
                    $objPHPExcel->getActiveSheet()->SetCellValue('AI'.$iii,'');
                    $objPHPExcel->getActiveSheet()->SetCellValue('AJ'.$iii,'');
                    $objPHPExcel->getActiveSheet()->SetCellValue('AK'.$iii,'');
                    $objPHPExcel->getActiveSheet()->SetCellValue('AL'.$iii,'');
                    $objPHPExcel->getActiveSheet()->SetCellValue('AM'.$iii,'');
                    $i+=3;
                    $ii+=3;
                    $iii+=3;
               }
            }
            $objPHPExcel->setActiveSheetIndex(0);
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            $filename = "Reporte_Concar_Ventas_".date("Ymdhis").".xlsx";
            header('Content-Disposition: attachment;filename='.$filename.'');
            header('Cache-Control: max-age=0');
            $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
            $objWriter->save('php://output');
            exit;

        } catch (Exception $e) {

            die($e->getMessage());

        }

    } 


    public function ExcelRepVentas($data)
    {

        try {
            error_reporting(0);
            require_once "libs/PHPExcel/Classes/PHPExcel.php";

            $objPHPExcel = new PHPExcel();
            $objPHPExcel->getDefaultStyle()->getAlignment()->setWrapText(true);

            $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(20.5);
            $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(20.5);
            $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(45);
            $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(12);
            $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(10);
            $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(23);
            $objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(15);
            $objPHPExcel->getActiveSheet()->getColumnDimension('L')->setWidth(13);
            $objPHPExcel->getActiveSheet()->getColumnDimension('M')->setWidth(12);
            $objPHPExcel->getActiveSheet()->getColumnDimension('N')->setWidth(10);
            $objPHPExcel->getActiveSheet()->getColumnDimension('P')->setWidth(15);
            $objPHPExcel->getActiveSheet()->getColumnDimension('R')->setWidth(10);
            $objPHPExcel->getActiveSheet()->getColumnDimension('S')->setWidth(10);
            $objPHPExcel->getActiveSheet()->getColumnDimension('T')->setWidth(15);
            $objPHPExcel->getActiveSheet()->getColumnDimension('U')->setWidth(10);
            $objPHPExcel->getActiveSheet()->getColumnDimension('Y')->setWidth(12);
            $objPHPExcel->getActiveSheet()->getColumnDimension('Z')->setWidth(14);

            $objPHPExcel->getActiveSheet()->mergeCells('A1:Z1');
            $objPHPExcel->getActiveSheet()->mergeCells('A2:Z2');
            $objPHPExcel->getActiveSheet()->mergeCells('A3:Z3');
            $objPHPExcel->getActiveSheet()->mergeCells('A4:B6');
            $objPHPExcel->getActiveSheet()->mergeCells('A4:B6');
            $objPHPExcel->getActiveSheet()->mergeCells('C4:C6');
            $objPHPExcel->getActiveSheet()->mergeCells('D4:D6');
            $objPHPExcel->getActiveSheet()->mergeCells('E4:G6');
            $objPHPExcel->getActiveSheet()->mergeCells('H4:J6');
            $objPHPExcel->getActiveSheet()->mergeCells('M4:N6');
            $objPHPExcel->getActiveSheet()->mergeCells('O4:O6');
            $objPHPExcel->getActiveSheet()->mergeCells('P4:P6');
            $objPHPExcel->getActiveSheet()->mergeCells('S4:S6');
            $objPHPExcel->getActiveSheet()->mergeCells('T4:T6');
            $objPHPExcel->getActiveSheet()->mergeCells('V4:V6');
            $objPHPExcel->getActiveSheet()->mergeCells('W4:Z4');
            $objPHPExcel->getActiveSheet()->mergeCells('W5:Z5');
            $objPHPExcel->getActiveSheet()->mergeCells('W6:Z6');
            $objPHPExcel->getActiveSheet()->mergeCells('A7:B7');

            

            $empresa = $this->Empresa();
            // $datos = $this->venta_all_list($data);

            $periodo = date('Y-m',strtotime($data['start']));
            if ($data['filter'] == 2) {
                $periodo = $data['p_anio']."-".$data['p_mes'];
            }
            $objPHPExcel->setActiveSheetIndex(0)
            ->SetCellValue('A1', 'RAZON SOCIAL: ' . utf8_decode($empresa['razon_social']))
            ->SetCellValue('A2', 'RUC: ' . utf8_decode($empresa['ruc']))
            ->SetCellValue('A3','FORMATO 14.1 : "REGISTRO DE VENTAS E INGRESOS DEL PERIODO '.$periodo.'"')
            ->SetCellValue('A4','NUMERO CORRELATIVO DEL REGISTRO O CUO.')
            ->SetCellValue('C4','FECHA DE EMISION DEL COMPROBANTE DE PAGO O EMISION DEL DOCUMENTO')
            ->SetCellValue('D4','FECHA VENC.')
            ->SetCellValue('E4','COMPROBANTE DE PAGO')
            ->SetCellValue('H4','INFORMACON DE CLIENTE')
            ->SetCellValue('K4','VALOR')
            ->SetCellValue('K5','FACTURADO')
            ->SetCellValue('K6','EXPORTACION')
            ->SetCellValue('L4','BASE')
            ->SetCellValue('L5','IMPONIBLE')
            ->SetCellValue('L6','GRAVADA')
            ->SetCellValue('M4','IMPORTE TOTAL')
            ->SetCellValue('O4','ISC')
            ->SetCellValue('P4','VENTA DIFERIDA')
            ->SetCellValue('Q4','IGV Y/O')
            ->SetCellValue('Q5','IMP.')
            ->SetCellValue('R4','OTROS')
            ->SetCellValue('R5','TRIBUTOS')
            ->SetCellValue('S4','R.C')
            ->SetCellValue('T4','IMPORTE TOTAL')
            ->SetCellValue('U4','TIPO DE')
            ->SetCellValue('U5','CAMBIO')
            ->SetCellValue('V4','MONEDA')
            ->SetCellValue('W4','REFERENCIA DEL COMPROBANTE O')
            ->SetCellValue('W5','DOC. ORIGINAL QUE SE MODIFICA')
            ->SetCellValue('E7','TIPO')
            ->SetCellValue('F7','SERIE')
            ->SetCellValue('G7','NUMERO')
            ->SetCellValue('H7','TIPO')
            ->SetCellValue('I7','R.U.C')
            ->SetCellValue('J7','APELLIDOS Y NOMBRES')
            ->SetCellValue('M7','EXONERADA')
            ->SetCellValue('N7','INAFECTA')
            ->SetCellValue('W7','FECHA')
            ->SetCellValue('X7','TIPO')
            ->SetCellValue('Z7','SERIE')
            ->SetCellValue('Y7','Nro.COMP.');
            if($data['estado_cpe'] == 'on'){
            $objPHPExcel->setActiveSheetIndex(0)
            ->SetCellValue('Z7','ESTADO');    
            }
           
            $datos = $this->venta_all_list($data);

            $loop = 1;
            $i      = 8;
            
            // Inicializar acumuladores antes del bucle
            $totalBaseImponibleGravada = 0;
            $totalExonerada = 0;
            $totalInafecta = 0;
            $totalISC = 0;
            $totalIGV = 0;
            $totalRC = 0;
            $totalImporteTotal = 0;
            
            foreach($datos as $id => $row) {

                $date_of_issue = date('d-m-Y',strtotime($row->fec_ven));

                $tipo = array('BOLETA DE VENTA'=>"03","FACTURA" =>'01');
                $document_type_id = $tipo[$row->desc_td];
                
                $total_ope_gravadas = 0;
                $total_igv_gravadas = 0;
                $total_ope_exoneradas = 0;
                $total_igv_exoneradas = 0;
    
                foreach($row->Detalle as $d){
    
                    if($d->codigo_afectacion == '10'){
                        $total_ope_gravadas = $total_ope_gravadas + $d->valor_venta;
                        $total_igv_gravadas = $total_igv_gravadas + $d->total_igv;
                        $total_ope_exoneradas = $total_ope_exoneradas + 0;
                        $total_igv_exoneradas = $total_igv_exoneradas + 0;
                    } else{
                        $total_ope_gravadas = $total_ope_gravadas + 0;
                        $total_igv_gravadas = $total_igv_gravadas + 0;
                        $total_ope_exoneradas = $total_ope_exoneradas + $d->valor_venta;
                        $total_igv_exoneradas = $total_igv_exoneradas + $d->total_igv;
                    }
                }
    
                $series = $row->ser_doc;
                $number = $row->nro_doc;
    
                if($row->Cliente->tipo_cliente == '2'){
                    $customer_identity_document_type_id = '6';
                    $customer_number = $row->Cliente->ruc;
                }else{
                    $customer_identity_document_type_id = $row->Cliente->tipo_cliente;
                    $customer_number = $row->Cliente->dni;
                }
                $customer_name = $row->Cliente->nombre;
                $exchange_rate_sale = '';
                $currency_type_symbol = 'S/';  
                if($row->comis_rc > 0 ){
                    $por_comis = ($row->rc > 0 )? ($row->rc) : ((Session::get('com_rc')) / 100); // 10

                }else{
                    $por_comis = '0';
                }

                $comis_rc = $row->comis_rc;

                $comis_del = $row->comis_del;
                $comis_del_op = ($row->comis_del > 0)? ($row->comis_del / (1+ $row->igv)) : $row->comis_del;
                $comis_del_igv = ($row->comis_del > 0)? ($row->comis_del - ($row->comis_del / (1+ $row->igv))) : $row->comis_del;

                $desc_monto = $row->desc_monto;
                $desc_monto_op = ($row->desc_monto> 0 )? ($row->desc_monto/ (1+ $row->igv)) : $row->desc_monto;
                $desc_monto_igv = ($row->desc_monto> 0 )? ($row->desc_monto - ($row->desc_monto/ (1+ $row->igv))) : $row->desc_monto;

                // desc_monto
                if ($row->estado == '11' || $row->estado == '09') : 
                    $total_exportation = '0';
                    $total_taxed = '0';
                    $total_exonerated = '0';
                    $total_unaffected = '0';
                    $total_plastic_bag_taxes = '0';
                    $total_igv = '0';
                    $total = '0';
                    $new_op_g = '0';
                    $new_igv = '0';
                    $comis_rc = '0' ;
                else : 
                    $total_exportation = '0';
                    $total_taxed = ($total_ope_gravadas + $comis_del_op - $desc_monto_op);
                    $total_exonerated = $total_ope_exoneradas;
                    $total_unaffected = '0';
                    $total_plastic_bag_taxes = '0';
                    $total_igv = ($total_igv_gravadas + $comis_del_igv - $desc_monto_igv);
                    $total = $total_taxed + $total_igv + $total_exonerated; // temporal 
                    // $total = $row->total;
                    $new_op_g = $total / (1 + ($row->igv + $por_comis));
                    $new_igv = $new_op_g * ($row->igv);
                endif;  
                
                    $estado_cpe = $this->StateType($row->estado);

                    $objPHPExcel->getActiveSheet()->SetCellValue('A'.$i, '06');
                    $objPHPExcel->getActiveSheet()->SetCellValue('B'.$i, $loop++);
                    $objPHPExcel->getActiveSheet()->SetCellValue('C'.$i, $date_of_issue);
                    $objPHPExcel->getActiveSheet()->SetCellValue('D'.$i, '');
                    $objPHPExcel->getActiveSheet()->SetCellValue('E'.$i, $document_type_id);
                    $objPHPExcel->getActiveSheet()->SetCellValue('F'.$i, $series);
                    $objPHPExcel->getActiveSheet()->SetCellValue('G'.$i, $number);
                    $objPHPExcel->getActiveSheet()->SetCellValue('H'.$i, $customer_identity_document_type_id);
                    $objPHPExcel->getActiveSheet()->SetCellValue('I'.$i, $customer_number);
                    $objPHPExcel->getActiveSheet()->SetCellValue('J'.$i, $customer_name);
                    $objPHPExcel->getActiveSheet()->SetCellValue('K'.$i, number_format($total_exportation, 2, '.', ''));
                    $objPHPExcel->getActiveSheet()->SetCellValue('L'.$i, number_format($new_op_g, 2, '.', ''));
                    $objPHPExcel->getActiveSheet()->SetCellValue('M'.$i, number_format($total_exonerated, 2, '.', ''));
                    $objPHPExcel->getActiveSheet()->SetCellValue('N'.$i, number_format($total_unaffected, 2, '.', ''));
                    $objPHPExcel->getActiveSheet()->SetCellValue('O'.$i, number_format($total_plastic_bag_taxes, 2, '.', ''));
                    $objPHPExcel->getActiveSheet()->SetCellValue('P'.$i, '');
                    $objPHPExcel->getActiveSheet()->SetCellValue('Q'.$i, number_format($new_igv, 2, '.', ''));
                    $objPHPExcel->getActiveSheet()->SetCellValue('R'.$i, '');
                    $objPHPExcel->getActiveSheet()->SetCellValue('S'.$i, $comis_rc);                    
                    $objPHPExcel->getActiveSheet()->SetCellValue('T'.$i, number_format($total, 2, '.', ''));
                    $objPHPExcel->getActiveSheet()->SetCellValue('U'.$i, number_format($exchange_rate_sale, 2, '.', ''));
                    $objPHPExcel->getActiveSheet()->SetCellValue('V'.$i, $currency_type_symbol);
                    $objPHPExcel->getActiveSheet()->SetCellValue('W'.$i, '');
                    $objPHPExcel->getActiveSheet()->SetCellValue('X'.$i, '');
                    $objPHPExcel->getActiveSheet()->SetCellValue('Y'.$i, '');
                    if($data['estado_cpe'] == 'on'){
                    $objPHPExcel->getActiveSheet()->SetCellValue('Z'.$i, $estado_cpe['descripcion']);
                    }
                    $i++;
                
                    // Sumar los valores correspondientes a las columnas deseadas
                    $totalBaseImponibleGravada += $new_op_g;
                    $totalExonerada += $total_exonerated;
                    $totalInafecta += $total_unaffected;
                    $totalISC += $total_plastic_bag_taxes;
                    $totalIGV += $new_igv;
                    $totalRC += $comis_rc;
                    $totalImporteTotal += $total;
                    
            }
            
            // Agregar texto "TOTALES" y las sumatorias al final
            $objPHPExcel->getActiveSheet()->SetCellValue('K'.$i, 'TOTALES');
            $objPHPExcel->getActiveSheet()->SetCellValue('L'.$i, number_format($totalBaseImponibleGravada, 2, '.', ''));
            $objPHPExcel->getActiveSheet()->SetCellValue('M'.$i, number_format($totalExonerada, 2, '.', ''));
            $objPHPExcel->getActiveSheet()->SetCellValue('N'.$i, number_format($totalInafecta, 2, '.', ''));
            $objPHPExcel->getActiveSheet()->SetCellValue('O'.$i, number_format($totalISC, 2, '.', ''));
            $objPHPExcel->getActiveSheet()->SetCellValue('Q'.$i, number_format($totalIGV, 2, '.', ''));
            $objPHPExcel->getActiveSheet()->SetCellValue('S'.$i, number_format($totalRC, 2, '.', ''));
            $objPHPExcel->getActiveSheet()->SetCellValue('T'.$i, number_format($totalImporteTotal, 2, '.', ''));

            // Definir el estilo de borde
            $borderStyle = [
                'borders' => [
                    'allborders' => [
                        'style' => PHPExcel_Style_Border::BORDER_THIN,
                        'color' => ['rgb' => '000000'],
                    ],
                ],
            ];
            
            // Calcular rango utilizado
            $lastRow = $i - 1; // Última fila con datos
            $lastColumn = 'Z'; // Ajusta si usas más columnas
            $sheet = $objPHPExcel->getActiveSheet();
            
            // Aplicar bordes al rango utilizado
            $sheet->getStyle("A1:{$lastColumn}{$lastRow}")->applyFromArray($borderStyle);
            
            // Aplicar estilo de borde a la fila de totales
            $sheet->getStyle("A{$i}:{$lastColumn}{$i}")->applyFromArray($borderStyle);

            $objPHPExcel->setActiveSheetIndex(0);
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            $filename = "Reporte_Ventas_".date("Ymdhis").".xlsx";
            header('Content-Disposition: attachment;filename='.$filename.'');
            header('Cache-Control: max-age=0');
            $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
            $objWriter->save('php://output');
            exit;

        } catch (Exception $e) {

            die($e->getMessage());

        }

    } 


}