<?php Session::init(); ?>
<?php

class Api_Model extends Model
{
	public function __construct()
	{
		parent::__construct();
	}

    public function dni($token,$dni)
    {
        try
        {
        if (API_SERVER=="apiperu.dev") {
            $url = 'https://apiperu.dev/api/dni/'.$dni.'?api_token='.$token;
            $curl = curl_init();
            curl_setopt_array($curl, array(
                CURLOPT_URL => $url,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_CUSTOMREQUEST => "GET",
                CURLOPT_SSL_VERIFYPEER => false
            ));
            $response = curl_exec($curl);
            $err = curl_error($curl);
            curl_close($curl);
            
            $res = json_decode($response, true);

        }
        if (API_SERVER=="apiperu.net.pe") {
            $url = 'https://apiperu.net.pe/api/dni/'.$dni;
            $curl = curl_init();
            curl_setopt_array($curl, array(
                CURLOPT_URL => $url,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_CUSTOMREQUEST => "GET",
                CURLOPT_SSL_VERIFYPEER => false,
                CURLOPT_HTTPHEADER => array(
                    'Authorization: Bearer '.$token
                ),
            ));
            $response = curl_exec($curl);
            $err = curl_error($curl);
            curl_close($curl);
            
            $res = json_decode($response, true);

        }
        if (API_SERVER=="server.consultaperu.xyz") {
            $url = 'http://server.consultaperu.xyz/api/dni/'.$dni;
            $curl = curl_init();
            curl_setopt_array($curl, array(
                CURLOPT_URL => $url,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_CUSTOMREQUEST => "GET",
                CURLOPT_SSL_VERIFYPEER => false,
                CURLOPT_HTTPHEADER => array(
                    'Authorization: Bearer '.$token
                ),
            ));
            $response = curl_exec($curl);
            $err = curl_error($curl);
            curl_close($curl);
            
            $res = json_decode($response, true);

        }
            if($res['success']){
                return [
                        'dni'               => $res['data']['numero'] ?? null,
                        'nombres'           => $res['data']['nombres'] ?? null,
                        'apellidoPaterno'   => $res['data']['apellido_paterno'] ?? null,
                        'apellidoMaterno'   => $res['data']['apellido_materno'] ?? null,
                        'codVerifica'       => $res['data']['codigo_verificacion'] ?? null,
                        'direccion'         => $res['data']['direccion_completa'] ?? null,
                        'fechaNacimiento'   => $res['data']['fecha_nacimiento'] ?? null,
                ];
            }
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }
    public function ruc($token,$ruc)
    {
        // Usar directamente API FacturaFacil Panamá
        return $this->rucPanama($ruc);
    }
    
    /**
     * Consulta RUC en API FacturaFacil Panamá
     * URL: https://backend-qa-api.facturafacil.com.pa/api/gateway/wp/test/checkRUC/{apikey}/{ruc}/{tipo}
     * @param string $ruc - RUC de Panamá (ej: 155723374-2-2022)
     * @param string $tipo - N=Natural, J=Juridico, 0=Desconocido (consulta ambos)
     * @return array
     */
    public function rucPanama($ruc, $tipo = '0')
    {
        try
        {
            $apiKey = API_KEY_FACTURAFACIL_RUCPANAMA;
            $baseUrl = API_URL_FACTURAFACIL_RUCPANAMA;
            
            // Construir URL: {baseUrl}{apikey}/{ruc}/{tipo}
            $url = $baseUrl . $apiKey . '/' . $ruc . '/' . $tipo;
            
            $curl = curl_init();
            curl_setopt_array($curl, array(
                CURLOPT_URL => $url,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_CUSTOMREQUEST => "GET",
                CURLOPT_SSL_VERIFYPEER => false,
                CURLOPT_TIMEOUT => 30,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTPHEADER => array(
                    'Content-Type: application/json',
                    'Accept: application/json'
                ),
            ));
            
            $response = curl_exec($curl);
            $err = curl_error($curl);
            curl_close($curl);
            
            if ($err) {
                return ['success' => false, 'message' => 'Error de conexión'];
            }
            
            $res = json_decode($response, true);
            
            // La API de FacturaFacil devuelve los datos directamente en la raíz
            // Estructura: {"valido":1,"ruc":"8-829-2193","dv":"7","tipoRuc":1,"razonSocial":"NOMBRE",...}
            // Nota: valido puede ser 1 (int) o true (bool), usamos == para comparación flexible
            if ($res && isset($res['valido']) && $res['valido'] == true) {
                
                // Determinar razón social
                $razonSocial = $res['razonSocial'] ?? $res['nombre'] ?? $res['nombreCompleto'] ?? '';
                
                // Determinar tipo de contribuyente basado en tipoRuc
                $tipoContribuyente = '';
                if (isset($res['tipoRuc'])) {
                    $tipoContribuyente = ($res['tipoRuc'] == 1) ? 'Natural' : 'Jurídico';
                }
                
                return [
                    'success'           => true,
                    'ruc'               => $res['ruc'] ?? $ruc,
                    'dv'                => $res['dv'] ?? '',
                    'razonSocial'       => $razonSocial,
                    'nombreComercial'   => $res['nombreComercial'] ?? null,
                    'estado'            => 'ACTIVO',
                    'condicion'         => null,
                    'direccion'         => $res['direccion'] ?? '',
                    'tipoContribuyente' => $tipoContribuyente,
                    'tipoReceptor'      => $res['tipoReceptor'] ?? '01',
                    'pais'              => 'PA'
                ];
            }
            
            // Si valido es false o no existe
            return ['success' => false, 'message' => $res['mensaje'] ?? 'RUC no encontrado'];
        }
        catch(Exception $e)
        {
            error_log("Exception consultando RUC Panamá: " . $e->getMessage());
            return ['success' => false, 'message' => $e->getMessage()];
        }
    }
    public function liberarbloqueo()
    {
        try
        {    

            $ds = $this->db->prepare("SELECT bloqueo FROM tm_configuracion");
			$ds->execute();
			$data_s = $ds->fetch();

            if(Session::get('rol') == 1){
				Session::set('bloqueo', '0');
				Session::set('bloqueo_id', $data_s['bloqueo']);
			}else{
				Session::set('bloqueo', $data_s['bloqueo']); 
				Session::set('bloqueo_id', $data_s['bloqueo']); 
			}
            if($data_s['bloqueo'] == 0 ){
                return ["status" => "liberado"];
            }else{
                return ["status" => "bloqueado"];
            }

        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }
    public function comanda($data)
    {
        try
        {    
            // Session::get('pc_ip')
            // http://'+$('#pc_ip').val()+'/imprimir/comanda.php?data='+JSON.stringify(nuevopedido)+'','_blank');


            $url = 'http://'.Session::get('pc_ip').'/imprimir/comanda.php';
            $proxy = Session::get('pc_ip');

            // $d =  json_encode(file_get_contents('php://input'));
           
            // print_r($data);

            $ch = curl_init($url);
            curl_setopt( $ch, CURLOPT_POSTFIELDS, $data );
            curl_setopt( $ch, CURLOPT_PROXY, $proxy);
            curl_setopt( $ch, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));
            curl_setopt( $ch, CURLOPT_RETURNTRANSFER, true );
            curl_setopt( $ch, CURLOPT_FOLLOWLOCATION, 1);
            $result = curl_exec($ch);
            curl_close($ch);
            # Print response.
            return $result;




            // $url = 'http://dynupdate.no-ip.com/ip.php';
            // $proxy = '127.0.0.1:8888'; //put your proxy here
            // //$proxyauth = 'user:password';
            
            // $ch = curl_init();
            // curl_setopt($ch, CURLOPT_URL,$url);
            // curl_setopt($ch, CURLOPT_PROXY, $proxy);
            // //curl_setopt($ch, CURLOPT_PROXYUSERPWD, $proxyauth);
            // curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
            // curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            // $result = curl_exec($ch);
            // curl_close($ch);
            
            // echo $result;



            // $url = 'http://'.Session::get('pc_ip').'/'.$dni.'?api_token='.$token;
            // $curl = curl_init();
            // curl_setopt_array($curl, array(
            //     CURLOPT_URL => $url,
            //     CURLOPT_RETURNTRANSFER => true,
            //     CURLOPT_CUSTOMREQUEST => "GET",
            //     CURLOPT_SSL_VERIFYPEER => false
            // ));
            // $response = curl_exec($curl);
            // $err = curl_error($curl);
            // curl_close($curl);
            
        }
        catch(Exception $e)
        {
            die($e->getMessage());
        }
    }
}