<?php 
    Session::init(); 
    
    $ver = (Session::get('rol') == 1 OR Session::get('rol') == 2 OR Session::get('rol') == 3 OR Session::get('rol') == 5 OR Session::get('rol') == 7 ) ? '' :  header('location: ' . URL . 'err/danger'); 
    $ver = (Session::get('bloqueo') == 0 OR Session::get('bloqueo') == null) ? '' :  header('location: ' . URL . 'err/bloqueo');
?>
<?php
require_once 'public/lib/print/num_letras.php';
require_once 'models/ajuste_model.php';
class Venta extends Controller {

	function __construct() {
		parent::__construct();
	}
	
	function index() 
	{	
        $this->view->title_page = 'Punto De Venta';
		$this->view->Salon = $this->model->Salon();
        $this->view->Mozo = $this->model->Mozo();
        $this->view->Repartidor = $this->model->Repartidor();
        $this->view->RepartidorApp = $this->model->RepartidorApp();
        $this->view->RepartidorAppList = $this->model->RepartidorApp_list();
		$this->view->TipoPago = $this->model->TipoPago();
		
        //$ajuste = new Ajuste_Model();
        //$this->view->bloqueo_pos = $ajuste->limit('bloqueo_pos');
		
        $this->view->js = array('venta/js/jquery-ui.min.js','venta/js/venta_index.js','venta/js/venta_all.js','venta/js/venta_cliente.js');
		$this->view->render('venta/index',false);
		

        
	}
		
	function mesa_list(){
        print_r(json_encode($this->model->mesa_list($_POST)));
    }

    function mostrador_list(){
        $this->model->mostrador_list($_POST);
    }

    function mostrador_list_c(){
        $this->model->mostrador_list_c($_POST);
    }

    function delivery_list(){
        $this->model->delivery_list($_POST);
    }

    function delivery_list_c(){
        $this->model->delivery_list_c($_POST);
    }

    function pedidoAccion(){
        print_r(json_encode($this->model->pedidoAccion($_POST)));
    }

    function listarPedidos(){
        print_r(json_encode($this->model->listarPedidos($_POST)));
    }
	
    function listarPedidosDetalle(){
        print_r(json_encode($this->model->listarPedidosDetalle($_POST)));
    }

    function listarUpdatePedidos(){
        print_r(json_encode($this->model->listarUpdatePedidos($_POST)));
    }  
    
    function reimpresion_comanda(){
        print_r(json_encode($this->model->reimpresion_comanda($_POST)));
        // print_r(($this->model->reimpresion_comanda($_GET)));
    }

    function listarPedidosTicket(){
        print_r(json_encode($this->model->listarPedidosTicket($_POST)));
    }

	function ComboMesaOri()
    {
        $this->model->ComboMesaOri($_POST);
    }

    function ComboMesaDes()
    {
        $this->model->ComboMesaDes($_POST);
    }

    function subPedido(){
        print_r(json_encode($this->model->subPedido($_POST)));
    }

    function CambiarMesa(){        
        $row = $this->model->CambiarMesa($_POST);
        if ($row['cod'] == 1){
            header('location: ' . URL . 'venta');
        } else {
            header('location: ' . URL . 'venta');
        }
    }

    function MoverPedidos(){        
        $row = $this->model->MoverPedidos($_POST);
        if ($row['cod'] == 1){
            header('location: ' . URL . 'venta');
        } else {
            header('location: ' . URL . 'venta');
        }
    }

    function refrescar_mesas(){        
        $this->model->refrescar_mesas();
        header('location: ' . URL . 'venta');
    }

    function pedido_create($id){   
        // Log para debug - INICIO
       
        // Detectar si es una petición AJAX (múltiples formas de detección)
        $isAjax = !empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest';
        $isAjax = $isAjax || (!empty($_SERVER['HTTP_ACCEPT']) && strpos($_SERVER['HTTP_ACCEPT'], 'application/json') !== false);
        $isAjax = $isAjax || (!empty($_SERVER['CONTENT_TYPE']) && strpos($_SERVER['CONTENT_TYPE'], 'application/json') !== false);
        
        // Si se solicita explícitamente JSON en la URL o es pc2 (siempre AJAX para POS)
        if($id == 'pc2') {
            $isAjax = true;
            $log_msg = "FORZANDO isAjax = true porque id == 'pc2'\n";
            file_put_contents($log_file, $log_msg, FILE_APPEND);
            error_log($log_msg);
        }
        
        $log_msg = "isAjax detectado: " . ($isAjax ? 'true' : 'false') . "\n";
        file_put_contents($log_file, $log_msg, FILE_APPEND);
        error_log($log_msg);
        
        try {
            $log_msg = "Llamando a modelo->" . $id . "()\n";
            file_put_contents($log_file, $log_msg, FILE_APPEND);
            error_log($log_msg);
            
            $data = $this->model->$id($_POST);
            
            $log_msg = "Modelo retornó datos\n";
            file_put_contents($log_file, $log_msg, FILE_APPEND);
            error_log($log_msg);
        } catch (Exception $e) {
            $log_msg = "EXCEPCIÓN en pedido_create: " . $e->getMessage() . "\n";
            $log_msg .= "Stack trace: " . $e->getTraceAsString() . "\n";
            file_put_contents($log_file, $log_msg, FILE_APPEND);
            error_log($log_msg);
            $data = array('fil' => 0, 'error' => 'Error al procesar la solicitud', 'message' => $e->getMessage());
        }
        
        // Log del resultado
        $log_msg = "Result data completo: " . print_r($data, true) . "\n";
        $log_msg .= "fil value: " . (isset($data['fil']) ? $data['fil'] : 'NOT SET') . "\n";
        $log_msg .= "id_pedido: " . (isset($data['id_pedido']) ? $data['id_pedido'] : 'NOT SET') . "\n";
        file_put_contents($log_file, $log_msg, FILE_APPEND);
        error_log($log_msg);

        if(isset($data['fil']) && $data['fil'] == 1){
            $log_msg = "ÉXITO: fil == 1, id_pedido = " . $data['id_pedido'] . "\n";
            file_put_contents($log_file, $log_msg, FILE_APPEND);
            error_log($log_msg);
            
            $datos = array('id_pedido' =>$data['id_pedido'], 'est' => 'insert');
            if ($id == 'pc1'){
                  ($this->model->contador_comensales($datos));
            }
            Session::set('codped', $data['id_pedido']);
            
            // Si es AJAX o rol 5, retornar JSON
            if($isAjax || (Session::get('rol') == 5 && $id == 'pc1')){
                $log_msg = "RETORNANDO JSON (isAjax=" . ($isAjax ? 'true' : 'false') . ", rol=" . Session::get('rol') . ")\n";
                $log_msg .= "JSON a retornar: " . json_encode($data) . "\n";
                file_put_contents($log_file, $log_msg, FILE_APPEND);
                error_log($log_msg);
                
                header('Content-Type: application/json');
                echo json_encode($data);
                
                $log_msg = "JSON enviado, saliendo con exit()\n";
                file_put_contents($log_file, $log_msg, FILE_APPEND);
                error_log($log_msg);
                exit;
            } else{
                $log_msg = "REDIRIGIENDO a: " . URL . 'venta/orden/'.$data['id_pedido'] . "\n";
                $log_msg .= "Razón: isAjax=" . ($isAjax ? 'true' : 'false') . ", rol=" . Session::get('rol') . ", id=" . $id . "\n";
                file_put_contents($log_file, $log_msg, FILE_APPEND);
                error_log($log_msg);
                
                header('location: ' . URL . 'venta/orden/'.$data['id_pedido']);
                exit;
            }                     
        } else {
            $log_msg = "ERROR: fil != 1 o no está set. fil=" . (isset($data['fil']) ? $data['fil'] : 'NOT SET') . "\n";
            $log_msg .= "Datos completos: " . print_r($data, true) . "\n";
            file_put_contents($log_file, $log_msg, FILE_APPEND);
            error_log($log_msg);
            
            // Si es AJAX o rol 5, retornar JSON con error
            if($isAjax || Session::get('rol') == 5){
                $errorResponse = array(
                    'fil' => 0, 
                    'error' => 'No se pudo crear el pedido', 
                    'message' => isset($data['message']) ? $data['message'] : (isset($data['error']) ? $data['error'] : 'Error desconocido')
                );
                
                $log_msg = "RETORNANDO JSON ERROR (isAjax=" . ($isAjax ? 'true' : 'false') . ")\n";
                $log_msg .= "JSON error: " . json_encode($errorResponse) . "\n";
                file_put_contents($log_file, $log_msg, FILE_APPEND);
                error_log($log_msg);
                
                header('Content-Type: application/json');
                echo json_encode($errorResponse);
                exit;
            } else{
                $log_msg = "REDIRIGIENDO a venta (error)\n";
                file_put_contents($log_file, $log_msg, FILE_APPEND);
                error_log($log_msg);
                
                header('location: ' . URL . 'venta');
                exit;
            }            
        }        
    }

    function orden($id_pedido){
        $this->view->title_page = 'Pedido N° '.$id_pedido;
        $this->view->TipoDocumento = $this->model->TipoDocumento();
        
        $ajuste = new Ajuste_Model();
        $this->view->Invoice = $ajuste->limit('invoices');

        $this->view->TipoPago = $this->model->TipoPago();


        // ($data = $this->model->ValidarEstadoPedido($id_pedido));
        // print_r($data);
        $data = $this->model->ValidarEstadoPedido($id_pedido);



        if ($data['cod'] == 1){
            $this->view->js = array('venta/js/jquery-ui.min.js','venta/js/js-render.js','venta/js/venta_orden.js','venta/js/venta_all.js','venta/js/venta_cliente.js');
            Session::set('codped', $id_pedido);
            Session::set('codtipoped', $data['tipo_pedido']);
            $this->view->render('venta/orden',false);
        } else {
            header('location: ' . URL . 'venta');
        }
    }

    function RegistrarPedido()
    {
        $data = $this->model->ValidarEstadoPedido($_POST['cod_ped']);
        if ($data['cod'] == 1){
            $this->model->RegistrarPedido($_POST);
            print_r(json_encode(1));
        } else  {
            print_r(json_encode(2));
        }
    }

    /* validad que el pedido siga activo  */
    function ValidarEstadoPedido()
    {
        $data = $this->model->ValidarEstadoPedido($_POST['cod_ped']);
        if ($data['cod'] == 1){
            print_r(json_encode(1));
        } else  {
            print_r(json_encode(2));
        }
    }


    function RegistrarVenta(){
        header('Content-Type: application/json');
        $log_file = __DIR__ . '/../log_registrar_venta.log';
        $log = date('Y-m-d H:i:s') . " === RegistrarVenta INICIO ===\n";
        $log .= "POST id_pedido: " . (isset($_POST['id_pedido']) ? $_POST['id_pedido'] : 'NO') . "\n";
        $log .= "POST dividir_cuenta: " . (isset($_POST['dividir_cuenta']) ? $_POST['dividir_cuenta'] : 'NO') . "\n";
        $log .= "POST nombrePrecuentaItem: " . (isset($_POST['nombrePrecuentaItem']) && is_array($_POST['nombrePrecuentaItem']) ? count($_POST['nombrePrecuentaItem']) : 'NO/NO_ARRAY') . "\n";

        try {
            if (empty($_POST['id_pedido'])){
                $log .= "Error: id_pedido vacío.\n";
                @file_put_contents($log_file, $log, FILE_APPEND);
                echo json_encode(array('success' => false, 'data' => array('mensaje' => 'ID de pedido no proporcionado', 'idventa' => null)));
                return;
            }

            $id_venta = $this->model->RegistrarVenta($_POST);
            $log .= "Modelo retornó: " . (is_array($id_venta) ? json_encode($id_venta) : gettype($id_venta)) . "\n";

            try {
                $datos = array('id_pedido' => $_POST['id_pedido'], 'est' => 'update');
                $this->model->contador_comensales($datos);
            } catch (Exception $e) {
                $log .= "contador_comensales error (no bloqueante): " . $e->getMessage() . "\n";
            }

            $log .= "Enviando respuesta JSON al cliente.\n";
            @file_put_contents($log_file, $log, FILE_APPEND);
            echo json_encode($id_venta);
        } catch (Throwable $e) {
            $log .= "RegistrarVenta Throwable: " . $e->getMessage() . " " . $e->getFile() . ":" . $e->getLine() . "\n";
            @file_put_contents($log_file, $log, FILE_APPEND);
            echo json_encode(array('success' => false, 'data' => array('mensaje' => 'Error: ' . $e->getMessage(), 'idventa' => null)));
        }
    }

    /**
     * Endpoint específico para guardar datos de facturación electrónica
     */
    function RegistrarFacturacionElectronica(){
        $log_file = __DIR__ . '/../debug_facturacion_electronica.log';
        $log_message = date('Y-m-d H:i:s') . " === CONTROLADOR RegistrarFacturacionElectronica ===\n";
        $log_message .= "POST completo:\n" . print_r($_POST, true) . "\n";
        file_put_contents($log_file, $log_message, FILE_APPEND);
        error_log($log_message);
        
        if(isset($_POST['id_venta']) && !empty($_POST['id_venta'])){
            $result = $this->model->RegistrarFacturacionElectronica($_POST);
            print_r(json_encode($result));
        } else {
            $error = array('success' => false, 'message' => 'ID de venta no proporcionado');
            print_r(json_encode($error));
        }
    }

    function anular_pedido(){
        $result = $this->model->anular_pedido($_POST);
        if (!empty($result['success'])) {
            $datos = array('id_pedido' => $_POST['id_pedido'], 'est' => 'delete');
            $this->model->contador_comensales($datos);
        }
        print_r(json_encode($result));
    }

    function anular_venta(){
        print_r(json_encode($this->model->anular_venta($_POST)));
    }

    function defaultdata(){
        print_r(json_encode($this->model->defaultdata($_POST)));
    }

    function listarCategorias(){
        print_r(json_encode($this->model->listarCategorias($_POST)));
    }
    
    function listarProdsMasVend(){
        print_r(json_encode($this->model->listarProdsMasVend($_POST)));
    }

    function listarProductos(){
        print_r(json_encode($this->model->listarProductos($_POST)));
    }

    function buscar_producto(){
        print_r(json_encode($this->model->buscar_producto($_POST)));
    }

    function ListarDetallePed(){
        print_r(json_encode($this->model->ListarDetallePed($_POST)));
    }

    /**
     * Verifica si el pedido tiene facturación dividida (precuentas).
     * GET o POST: id_pedido
     * Respuesta JSON: success, tiene_precuenta_dividida, grupos_precuenta[], dividir_cuenta_sugerido (1 o 2)
     */
    function verificarFacturacionDividida(){
        header('Content-Type: application/json');
        $id_pedido = isset($_REQUEST['id_pedido']) ? (int)$_REQUEST['id_pedido'] : 0;
        if ($id_pedido <= 0) {
            echo json_encode(array(
                'success' => false,
                'tiene_precuenta_dividida' => false,
                'grupos_precuenta' => array(),
                'dividir_cuenta_sugerido' => 1,
                'mensaje' => 'id_pedido no válido'
            ));
            return;
        }
        $tiene = $this->model->tienePrecuentaDividida($id_pedido);
        $grupos = $this->model->getGruposPrecuenta($id_pedido);
        echo json_encode(array(
            'success' => true,
            'tiene_precuenta_dividida' => $tiene,
            'grupos_precuenta' => is_array($grupos) ? $grupos : array(),
            'dividir_cuenta_sugerido' => ($tiene && count($grupos) > 0) ? 2 : 1
        ));
    }

    /** JSON: ítems del pedido para modal dividir precuenta */
    function getDetallePrecuenta(){
        $id = isset($_POST['id_pedido']) ? (int)$_POST['id_pedido'] : 0;
        if ($id <= 0) { print_r(json_encode(array())); return; }
        $items = $this->model->getDetalleParaDividirPrecuenta($id);
        print_r(json_encode($items));
    }

    /** HTML: filas de la tabla para dividir precuenta (render desde PHP) */
    function contenidoFilasDividirPrecuenta(){
        $id = isset($_POST['id_pedido']) ? (int)$_POST['id_pedido'] : 0;
        if ($id <= 0) { echo ''; return; }
        $this->view->items = $this->model->getDetalleParaDividirPrecuenta($id);
        $this->view->render('venta/partials/filas_dividir_precuenta', true);
    }

    /** Guardar asignación individual de item a precuenta (en tiempo real) */
    function asignarItemPrecuenta(){
        $id_pedido = isset($_POST['id_pedido']) ? (int)$_POST['id_pedido'] : 0;
        $id_pres = isset($_POST['id_pres']) ? (int)$_POST['id_pres'] : 0;
        $precio = isset($_POST['precio']) ? $_POST['precio'] : '0';
        $toppings = isset($_POST['toppings']) ? $_POST['toppings'] : '';
        $nombre_precuenta = isset($_POST['nombre_precuenta']) ? trim($_POST['nombre_precuenta']) : null;
        
        if ($id_pedido <= 0 || $id_pres <= 0) {
            print_r(json_encode(array('ok' => 0, 'msg' => 'Datos inválidos'))); return;
        }
        
        $ok = $this->model->asignarItemPrecuenta($id_pedido, $id_pres, $precio, $toppings, $nombre_precuenta);
        print_r(json_encode(array('ok' => $ok ? 1 : 0, 'msg' => $ok ? 'Guardado.' : 'Error al guardar.')));
    }

    /** Guardar división de precuenta (grupos con nombre e ítems) */
    function guardarDividirPrecuenta(){
        $id = isset($_POST['id_pedido']) ? (int)$_POST['id_pedido'] : 0;
        $grupos = isset($_POST['grupos']) ? $_POST['grupos'] : array();
        if (is_string($grupos)) $grupos = json_decode($grupos, true);
        if ($id <= 0 || !is_array($grupos)) {
            print_r(json_encode(array('ok' => 0, 'msg' => 'Datos inválidos'))); return;
        }
        $ok = $this->model->guardarDividirPrecuenta($id, $grupos);
        print_r(json_encode(array('ok' => $ok ? 1 : 0, 'msg' => $ok ? 'Guardado.' : 'Error al guardar.')));
    }
    
    function cliente_crud(){
        $logFile = __DIR__ . '/../log_guardar_cliente.log';
        $log = function($msg) use ($logFile) {
            @file_put_contents($logFile, date('Y-m-d H:i:s') . ' ' . $msg . "\n", FILE_APPEND);
        };
        $log('=== cliente_crud INICIO ===');
        $log('POST keys: ' . implode(', ', array_keys($_POST)));
        $postLog = array_diff_key($_POST, array_flip(array('password','pass','pwd')));
        $log('POST enviado (raw): ' . json_encode($postLog, JSON_UNESCAPED_UNICODE));
        foreach ($postLog as $k => $v) {
            $log('  ' . $k . ' = ' . (is_string($v) ? substr($v, 0, 200) : json_encode($v)));
        }

        $ruc = isset($_POST['ruc']) ? trim(preg_replace('/\s*DV:\s*\S+$/', '', trim($_POST['ruc']))) : '';
        $rucNorm = $ruc !== '' ? preg_replace('/\D/', '', $ruc) : '';
        $tieneRuc = $rucNorm !== '' && strlen($rucNorm) >= 5;
        $idCliente = isset($_POST['id_cliente']) ? trim($_POST['id_cliente']) : '';

        $log('ruc=' . var_export($ruc, true) . ', rucNorm=' . var_export($rucNorm, true) . ', tieneRuc=' . ($tieneRuc ? '1' : '0') . ', id_cliente=' . var_export($idCliente, true));

        // Si tiene RUC: siempre usar create (flag=1) para que el SP busque por RUC y ACTUALICE contacto o inserte nuevo
        if ($tieneRuc) {
            $log('Ruta: cliente_crud_create (tiene RUC)');
            $result = $this->model->cliente_crud_create($_POST);
            $log('Result create: ' . (is_object($result) ? json_encode($result) : (is_array($result) ? json_encode($result) : var_export($result, true))));
            if ($result === false || $result === null) {
                $log('Respuesta: error (id_cliente=0, cod=1)');
                $out = array('id_cliente' => 0, 'cod' => 1);
                $log('Respuesta enviada: ' . json_encode($out));
                print_r(json_encode($out));
            } else {
                $out = is_object($result) ? (array)$result : (array)$result;
                $log('Respuesta: ok. Respuesta enviada: ' . json_encode($out));
                print_r(json_encode($result));
            }
            $log('=== cliente_crud FIN ===');
            return;
        }
        // Sin RUC (cliente DNI): actualizar por id_cliente
        if ($idCliente !== '') {
            $log('Ruta: cliente_crud_update (id_cliente presente)');
            $result = $this->model->cliente_crud_update($_POST);
            $out = is_object($result) ? (array)$result : (is_array($result) ? $result : array());
            if (empty($out['id_cliente'])) $out['id_cliente'] = $idCliente;
            $log('Result update: ' . json_encode($out));
            $log('Respuesta enviada: ' . json_encode($out));
            print_r(json_encode($out));
        } else {
            $log('Ruta: cliente_crud_create (sin RUC, sin id_cliente)');
            $result = $this->model->cliente_crud_create($_POST);
            $log('Result create: ' . (is_object($result) ? json_encode($result) : (is_array($result) ? json_encode($result) : var_export($result, true))));
            if ($result === false || $result === null) {
                $log('Respuesta: error (id_cliente=0, cod=1)');
                $out = array('id_cliente' => 0, 'cod' => 1);
                $log('Respuesta enviada: ' . json_encode($out));
                print_r(json_encode($out));
            } else {
                $out = is_object($result) ? (array)$result : (array)$result;
                $log('Respuesta: ok. Respuesta enviada: ' . json_encode($out));
                print_r(json_encode($result));
            }
        }
        $log('=== cliente_crud FIN ===');
    }

    function buscar_cliente()
    {
        print_r(json_encode($this->model->buscar_cliente($_POST)));
    }

    function buscar_cliente_telefono()
    {
        print_r(json_encode($this->model->buscar_cliente_telefono($_POST)));
    }

    function pedido_edit(){
        $this->model->pedido_edit($_POST);
    }

    function repartidor_crud(){
        print_r(json_encode($this->model->repartidor_update($_POST)));
    }
    function pedido_crud(){
        print_r(json_encode($this->model->pedido_crud_update($_POST)));
    }
    function pedido_delete()
    {
        $this->model->pedido_delete($_POST);
    }

    function venta_edit(){
        $this->model->venta_edit($_POST);
    }

    function venta_edit_pago(){
        print_r(json_encode($this->model->venta_edit_pago($_POST)));
    }

    function venta_edit_documento(){
        print_r(json_encode($this->model->venta_edit_documento($_POST)));
        if(Session::get('sunat') == 1){
           if($_POST['id_tipo_documento'] <> 3){
                require_once 'api_fact/controller/api.php';
                $invoice = new ApiSunat();
                $data = $invoice->sendDocSunaht($_POST['id_venta'],2);  
            }  
        }
    }

    function tags_list()
    {
        print_r(json_encode($this->model->tags_list($_POST)));
    }

    function tags_crud()
    {
        print_r(json_encode($this->model->tags_crud($_POST)));
    }

    /* INICIO COMPROBANTE SIN ENVIAR SUNAT */

    function contadorSunatSinEnviar(){
        print_r(json_encode($this->model->contadorSunatSinEnviar()));
    }

    /* FIN COMPROBANTE SIN ENVIAR SUNAT */
	
    /* INICIO PEDIDOS PREPARADOS */

    function contadorPedidosPreparados(){
        print_r(json_encode($this->model->contadorPedidosPreparados()));
    }

    function listarPedidosPreparados(){
        $this->model->listarPedidosPreparados();
    }

    function pedidoEntregado(){
        print_r(json_encode($this->model->pedidoEntregado($_POST)));
    }

    function pedido_estado_update(){
        print_r(json_encode($this->model->pedido_estado_update($_POST)));
    }

    function menu_categoria_list()
    {
        $this->model->menu_categoria_list($_POST);
    }

    function menu_plato_list(){
        $this->model->menu_plato_list($_POST);
    }

    function menu_plato_estado(){
        print_r(json_encode($this->model->menu_plato_estado($_POST)));
    }

    function impresion_precuenta($id_pedido)
    {
        $pr = isset($_GET['pr']) ? $_GET['pr'] : 'pc2';
        $grupo = isset($_GET['grupo']) ? trim($_GET['grupo']) : null;
        if ($grupo === '') $grupo = null;
        if(Session::get('print_pre') == 1){
            $dato = $this->model->impresion_precuenta($id_pedido, $pr, $grupo);
            header('location: http://'.Session::get('pc_ip').'/imprimir/pre_cuenta.php?data='.urlencode(json_encode($dato)));
        } else {
            $this->view->dato = $this->model->impresion_precuenta($id_pedido, $pr, $grupo);
            $this->view->render('venta/imprimir/precuenta', true);
        }
    }

    function tienePrecuentaDividida(){
        $id = isset($_POST['id_pedido']) ? (int)$_POST['id_pedido'] : 0;
        $dividida = $id > 0 ? $this->model->tienePrecuentaDividida($id) : false;
        print_r(json_encode(array('dividida' => $dividida)));
    }

    function getGruposPrecuenta(){
        $id = isset($_POST['id_pedido']) ? (int)$_POST['id_pedido'] : 0;
        $grupos = $id > 0 ? $this->model->getGruposPrecuenta($id) : array();
        print_r(json_encode($grupos));
    }

    function getDivisionPrecuenta(){
        $id = isset($_POST['id_pedido']) ? (int)$_POST['id_pedido'] : 0;
        $data = $id > 0 ? $this->model->getDivisionPrecuenta($id) : array('items_sin_asignar' => array(), 'precuentas' => array());
        print_r(json_encode($data));
    }

    function getFacturacionDividida(){
        $id = isset($_POST['id_pedido']) ? (int)$_POST['id_pedido'] : 0;
        $data = $id > 0 ? $this->model->getFacturacionDividida($id) : array();
        print_r(json_encode($data));
    }

    function guardarFacturacionDividida(){
        $id_pedido = isset($_POST['id_pedido']) ? (int)$_POST['id_pedido'] : 0;
        $items = isset($_POST['items']) && is_array($_POST['items']) ? $_POST['items'] : array();
        if ($id_pedido <= 0) { print_r(json_encode(array('ok' => 0, 'msg' => 'Pedido inválido'))); return; }
        $ok = $this->model->guardarFacturacionDividida($id_pedido, $items);
        print_r(json_encode(array('ok' => $ok ? 1 : 0)));
    }

    // pdf reparto 
    function impresion_reparto($id_venta)
    {
        if(Session::get('print_cpe') == 1){
            $dato = $this->model->impresion_reparto($id_venta);
            header('location: http://'.Session::get('pc_ip').'/imprimir/ticket_reparto.php?data='.json_encode($dato));            
        } else {
            $this->view->dato = $this->model->impresion_reparto($id_venta);
            $this->view->render('venta/imprimir/ticketreparto', true);
        }
    }

    function impresion_comanda()
    {
        error_log('impresion_comanda');
        error_log($_GET['data']);
        $this->view->render('venta/imprimir/comanda', true);
    }


    function contador_comanda(){
        print_r(json_encode($this->model->contador_comanda($_POST)));
    }

    function Personal()
    {
        print_r(json_encode($this->model->Personal()));
    }

    function alert_pedidos_programados(){
        print_r(json_encode($this->model->alert_pedidos_programados()));
    }
    function control_stock_pedido(){
        print_r(json_encode($this->model->control_stock_pedido($_POST)));
    }
    /* FIN PEDIDOS PREPARADOS */
    function contador_comensales(){
        print_r(json_encode($this->model->contador_comanda($_POST)));
    }
    function comensal(){
        $datos = array('est' => 'contador');
        print_r(json_encode($this->model->contador_comensales($datos)));
    }
    
    function combo_productos(){
        print_r(json_encode($this->model->combo_productos($_POST)));
    }
	
    function listarproductosstock(){
        $this->model->listarproductosstock();
    }

    function listarComandas()
    {
        print_r(json_encode($this->model->listarComandas($_POST)));
    }

    function toppings_list()
    {
        print_r(json_encode($this->model->toppings_list($_POST)));
    }

    function mozo_edit(){
        $this->model->mozo_edit($_POST);
    }

    function editarClientePedido(){
        $this->model->editarClientePedido($_POST);
    }

}