<?php 
    Session::init(); 
    $ver = (Session::get('bloqueo') == 0 OR Session::get('bloqueo') == null) ? '' :  header('location: ' . URL . 'err/bloqueo');
?>
<?php
require_once 'public/lib/print/num_letras.php';
require_once 'api_fact/controller/api.php';
require_once 'mailer/send.php';

require_once 'api_fact/UBL21/controllers/pse.php';

class Facturacion extends Controller {

	function __construct() {
		parent::__construct();
		Auth::handleLogin();
	}

	function Index(){
        $this->view->title_page = 'Facturación Electrónica';
        $this->view->Estado =  $this->model->StateType('%');
        $this->view->js = array('facturacion/js/facturacion.js');
		$this->view->render('facturacion/index', false);
    }

    function Datos1(){
        $this->model->Datos1($_POST);
    }

    function Datos2(){
        $this->model->Datos2($_POST);
    }

    function Datos3(){
        $this->model->Datos3($_POST);
    }

    function Datos4(){
        $this->model->Datos4($_POST);
    }

    function Datos5(){
        $this->model->Datos5($_POST);
    }

    function Detalle(){
        $this->model->Detalle($_POST);
    }

    function Invoice(){
        $cod_ven = $_POST['cod_ven'];
        $invoice = new ApiSunat();
        $data = $invoice->sendDocSunaht($cod_ven,1);    
    }

    function ComunicacionBaja(){
        $api = new ApiSunat();
        $api->postComunicacionBaja($_POST);
    }

    function reenvio(){
        $this->model->reenvio($_POST);
        print_r(json_encode(1));
    }
    
    function cambioFecha(){
        $this->model->cambioFecha($_POST);
        print_r(json_encode(1));
    }    

    function Resumen_boletas(){
        $api = new ApiSunat();
        $api->postResumenDiario($_POST);
    }  

    function Consultaticket(){
        $api = new ApiSunat();
        // print 'hola';
        $api->postConsultaticket($_POST);
    }    

    function send_mailer() {
        // Obtener los datos de la factura, que ya incluyen la empresa
        $datos_factura = $this->model->pdf_factura($_POST['id_venta']);
    
        // Acceder al nombre comercial de la empresa
        $negocio = isset($datos_factura->Empresa->nombre_comercial) ? $datos_factura->Empresa->nombre_comercial : NAME_NEGOCIO;
    
        // Instancia de la clase de env��o de correo
        $api = new Email();
        $api->sendEmail($_POST['correo_cliente'], $_POST['documento_cliente'], json_encode($datos_factura), $negocio);
    }

    /*Contador de bajas de facturas sunat pendientes*/
    function contadorBajasFacturaSunatPendint(){
        print_r(json_encode($this->model->contadorBajasFacturaSunatPendint()));
    }
    /*Contador de bajas de boletas sunat pendientes*/
    function contadorBajasBoletaSunatPendint(){
        print_r(json_encode($this->model->contadorBajasBoletaSunatPendint()));
    }
    /*Contador de bajas de resumen sunat pendientes*/
    function contadorResumenSunatPendint(){
        print_r(json_encode($this->model->contadorResumenSunatPendint()));
    }
    
    // ========== FACTURACIÓN ELECTRÓNICA facturafacil Panamá ==========
    
    /**
     * Vista de listado de documentos electrónicos
     */
    function documentos(){
        $this->view->title_page = 'Documentos Electrónicos';
        $this->view->js = array('venta/js/jquery-ui.min.js', 'venta/js/venta_cliente.js', 'facturacion/js/documentos_fe.js');
        $this->view->render('facturacion/documentos_fe', false);
    }
    
    /**
     * Listar documentos electrónicos para DataTable
     */
    function documentos_list(){
        while (ob_get_level()) {
            ob_end_clean();
        }
        if (!headers_sent()) {
            header('Content-Type: application/json; charset=utf-8');
        }
        try {
            require_once 'models/facturacion_electronica_model.php';
            $fe_model = new Facturacion_Electronica_Model();
            $result = $fe_model->documentos_list($_POST);
            echo json_encode($result);
        } catch (Exception $e) {
            error_log("documentos_list: " . $e->getMessage());
            echo json_encode(array(
                "draw" => isset($_POST['draw']) ? intval($_POST['draw']) : 1,
                "recordsTotal" => 0,
                "recordsFiltered" => 0,
                "data" => array(),
                "error" => $e->getMessage()
            ));
        }
        exit;
    }
    
    /**
     * Obtener datos de un documento específico
     */
    function documentos_data(){
        require_once 'models/facturacion_electronica_model.php';
        $fe_model = new Facturacion_Electronica_Model();
        print_r(json_encode($fe_model->documentos_data($_POST)));
    }
    
    /**
     * Enviar documento a facturafacil
     */
    function documentos_enviar(){
        require_once 'models/facturacion_electronica_model.php';
        $fe_model = new Facturacion_Electronica_Model();
        print_r(json_encode($fe_model->enviar_documento_fe($_POST)));
    }
    
    /**
     * Descargar PDF del documento (redirige a FacturaFacil o muestra mensaje)
     */
    function documentos_descargar_pdf(){
        require_once 'models/facturacion_electronica_model.php';
        $fe_model = new Facturacion_Electronica_Model();
        $fe_model->descargar_pdf($_GET);
    }
    
    /**
     * Comprobante/ticket usando el mismo diseño de imp_venta_all.php
     */
    function documentos_comprobante_panama(){
        $id_documento_fe = isset($_GET['id']) ? intval($_GET['id']) : (isset($_GET['id_documento_fe']) ? intval($_GET['id_documento_fe']) : 0);
        if ($id_documento_fe <= 0) {
            header('HTTP/1.0 400 Bad Request');
            echo 'ID de documento requerido';
            return;
        }
        
        // Obtener id_venta del documento FE
        require_once 'models/facturacion_electronica_model.php';
        $fe_model = new Facturacion_Electronica_Model();
        $stm = $fe_model->db->prepare("SELECT id_venta FROM tm_facturacion_electronica_documentos WHERE id_documento_fe = ? LIMIT 1");
        $stm->execute(array($id_documento_fe));
        $doc_fe = $stm->fetch(PDO::FETCH_ASSOC);
        
        if (!$doc_fe || empty($doc_fe['id_venta'])) {
            header('HTTP/1.0 404 Not Found');
            echo 'Venta no encontrada para este documento';
            return;
        }
        
        // Redirigir a informe/venta_all_imp que usa imp_venta_all.php
        header('Location: ' . URL . 'informe/venta_all_imp/' . $doc_fe['id_venta']);
        exit;
    }
    
    /**
     * Descargar XML del documento
     */
    function documentos_descargar_xml(){
        require_once 'models/facturacion_electronica_model.php';
        $fe_model = new Facturacion_Electronica_Model();
        // Usar $_GET porque las descargas se hacen mediante GET (window.open con parámetros en URL)
        $fe_model->descargar_xml($_GET);
    }
    
    /**
     * Descargar CAFE del documento
     */
    function documentos_descargar_cafe(){
        require_once 'models/facturacion_electronica_model.php';
        $fe_model = new Facturacion_Electronica_Model();
        // Usar $_GET porque es una petición GET
        $fe_model->descargar_cafe($_GET);
    }
    
    /**
     * Enviar documento por correo
     */
    function documentos_enviar_email(){
        require_once 'models/facturacion_electronica_model.php';
        $fe_model = new Facturacion_Electronica_Model();
        print_r(json_encode($fe_model->enviar_email($_POST)));
    }
    
    /**
     * Convertir Nota de Venta a Boleta o Factura
     */
    function convertir_documento(){
        require_once 'models/facturacion_electronica_model.php';
        $fe_model = new Facturacion_Electronica_Model();
        print_r(json_encode($fe_model->convertir_documento($_POST)));
    }
    
    /**
     * Emitir Nota de Crédito para una factura
     */
    function emitir_nota_credito(){
        header('Content-Type: application/json');
        require_once 'models/facturacion_electronica_model.php';
        $fe_model = new Facturacion_Electronica_Model();
        echo json_encode($fe_model->emitir_nota_credito($_POST));
    }
    
    /**
     * Obtener configuración de envío automático (para la vista de documentos)
     */
    function documentos_config_envio(){
        require_once 'models/ajuste_model.php';
        $ajuste = new Ajuste_Model();
        $c = $ajuste->facturacion_electronica_data();
        header('Content-Type: application/json');
        echo json_encode(array(
            'success' => true,
            'envio_automatico' => isset($c->envio_automatico) ? (int)$c->envio_automatico : 0
        ));
    }
    
    /**
     * Guardar configuración de envío automático (solo actualiza el flag, no el resto de la config)
     */
    function documentos_guardar_envio_automatico(){
        require_once 'models/ajuste_model.php';
        $ajuste = new Ajuste_Model();
        $valor = isset($_POST['envio_automatico']) ? (int)$_POST['envio_automatico'] : 0;
        $result = $ajuste->facturacion_electronica_envio_automatico($valor);
        header('Content-Type: application/json');
        echo json_encode($result);
    }
    
    /**
     * Procesar envío automático de documentos pendientes (llamado desde el header cada 20 seg).
     * Solo procesa si envio_automatico está activado. Envía hasta 5 documentos por petición.
     * Log en: log_envio_automatico_fe.txt
     */
    function documentos_procesar_automatico(){
        // Limpiar cualquier output previo y asegurar que no hay headers enviados
        while (ob_get_level()) {
            ob_end_clean();
        }
        
     
        
        // Establecer headers antes de cualquier output
        if (!headers_sent()) {
            header('Content-Type: application/json');
        }
        
        try {
            require_once 'models/facturacion_electronica_model.php';
            $fe_model = new Facturacion_Electronica_Model();
            $log('documentos_procesar_automatico llamado');
            $envio_activo = $fe_model->envio_automatico_activo();
            $log('envio_automatico_activo = ' . ($envio_activo ? '1' : '0'));
            if (!$envio_activo) {
                $log('Salida: envío automático desactivado');
                echo json_encode(array('success' => true, 'enviados' => 0, 'errores' => 0, 'message' => 'Envío automático desactivado'));
                exit;
            }
            $ids = $fe_model->get_documentos_pendientes_envio(5);
            $log('documentos pendientes (ids) = ' . (empty($ids) ? '0' : implode(',', $ids)));
            if (empty($ids)) {
                $log('Salida: sin documentos pendientes');
                echo json_encode(array('success' => true, 'enviados' => 0, 'errores' => 0, 'message' => 'Sin documentos pendientes'));
                exit;
            }
            $enviados = 0;
            $errores = 0;
            foreach ($ids as $id_doc) {
                $res = $fe_model->enviar_documento_fe(array('id_documento_fe' => $id_doc));
                $ok = !empty($res['success']);
                if ($ok) $enviados++; else $errores++;
                $log("id_documento_fe=$id_doc " . ($ok ? 'OK' : 'ERROR') . ' ' . (isset($res['message']) ? $res['message'] : ''));
            }
            $log("Fin: enviados=$enviados errores=$errores");
            echo json_encode(array(
                'success' => true,
                'enviados' => $enviados,
                'errores' => $errores,
                'message' => $enviados ? "Enviados: $enviados" . ($errores ? ", errores: $errores" : '') : ($errores ? "Errores: $errores" : 'Sin pendientes')
            ));
            exit;
        } catch (Exception $e) {
            $log('ERROR EXCEPCIÓN: ' . $e->getMessage());
            if (!headers_sent()) {
                header('Content-Type: application/json');
            }
            echo json_encode(array(
                'success' => false,
                'enviados' => 0,
                'errores' => 0,
                'message' => 'Error: ' . $e->getMessage()
            ));
            exit;
        }
    }
}