<?php Session::init(); $ver = (Session::get('rol') == 1 OR Session::get('rol') == 2 OR Session::get('rol') == 3 OR Session::get('rol') == 7 ) ? '' :  header('location: ' . URL . 'err/danger'); ?>
<?php
require_once 'api_fact/config/config.php';
require_once 'api_fact/model/api.php';

class ApiSunat
{
    public function __construct() {
        $this->db = new Database(DB_TYPE, DB_HOST, DB_NAME, DB_USER, DB_PASS, DB_CHARSET);
    }

    public function sendDocSunaht($cod_ven,$num) {

        $api = new ApiModel();
        $documento = $api->getCabecera($cod_ven);
        $empresa = $api->getEmpresa();
        $documento_igv = $documento->igv; //0.18 0.08
        $rc = $documento->rc;
        if ($documento->enviado_sunat == '1'):
            $respuesta = array('enviado_sunat' => '0', 'mensaje' => 'El documento N°'.$documento->serie_doc.'-'.$documento->nro_doc.' ya ha sido enviado a SUNAT');
        else:

            $item = 0;
            $total_ope_gravadas = 0;
            $total_igv_gravadas = 0;
            $total_ope_exoneradas = 0;
            $total_igv_exoneradas = 0;
            $productos = array();

            $deco = json_decode(json_encode($documento->Detalle), true);
            $resultado_detalle = array();
            if($documento->comision_delivery > 0){
                $dely_pr = array("codigo_producto" => "DELIV001",
                    "nombre_producto" => "DELIVERY",
                    "codigo_afectacion" => ($deco[0]['codigo_afectacion'] == 10)? "10": "20",
                    "cantidad" => "1.00" ,
                    "valor_unitario" => ($deco[0]['codigo_afectacion'] == 10)? number_format(($documento->comision_delivery/(1+ $documento_igv)), 6, '.', '') : number_format(($documento->comision_delivery), 6, '.', ''),
                    "precio_unitario" => number_format($documento->comision_delivery, 2, '.', '') ,
                    "valor_venta" => ($deco[0]['codigo_afectacion'] == 10)? number_format(($documento->comision_delivery/(1+ $documento_igv)), 2, '.', '') : number_format(($documento->comision_delivery), 2, '.', ''),
                    "total_igv" => ($deco[0]['codigo_afectacion'] == 10)? number_format($documento->comision_delivery-($documento->comision_delivery/(1 + $documento_igv)), 2, '.', '') : "0");

                $resultado_detalle = array_merge($deco, array($dely_pr));
            }else{
                $resultado_detalle = $deco;
            }
           
            foreach ($resultado_detalle as $detalle ){
                $item = $item + 1;

                if($detalle['codigo_afectacion'] == '10'){
                    $total_ope_gravadas = $total_ope_gravadas + $detalle['valor_venta'];
                    $total_igv_gravadas = $total_igv_gravadas + $detalle['total_igv'];
                    $total_ope_exoneradas = $total_ope_exoneradas + 0;
                    $total_igv_exoneradas = $total_igv_exoneradas + 0;
                } else{
                    $total_ope_gravadas = $total_ope_gravadas + 0;
                    $total_igv_gravadas = $total_igv_gravadas + 0;
                    $total_ope_exoneradas = $total_ope_exoneradas + $detalle['valor_venta'];
                    $total_igv_exoneradas = $total_igv_exoneradas + $detalle['total_igv'];
                }
                if ($documento->consumo == '0') {
                    if ($rc > 0 ) {
                        $desc_preub= ($documento->descuento_monto) / ($documento->total+ $documento->descuento_monto + $documento->comision_delivery) ;
                        $productos[] = [
                            "txtITEM" => $item,
                            //"CODIGO_PRODUCTO_SUNAT" => $value['cod_sunat'], #codigo clase de producto
                            "txtUNIDAD_MEDIDA_DET" => "NIU", #dejarlo en NIU la Unidad de Medida
                            "txtCANTIDAD_DET" => $detalle['cantidad'],
                            "txtPRECIO_DET" => number_format((($detalle['precio_unitario'] ) /((1+ $documento_igv)+ ($documento->rc)))+((($detalle['precio_unitario']  )/((1+ $documento_igv)+ ($documento->rc)))*$documento_igv), 2, '.', ''), #TOTAL DEL PRODUCTO
                            "txtPRECIO_TIPO_CODIGO" => "01", #Dejarlo como esta
                            "txtIGV" => number_format((((($detalle['valor_venta'])*(1 + $documento_igv)))/((1+ $documento_igv)+ ($documento->rc))*$documento_igv), 2, '.', ''),
                            "txtISC" => "0",  #Dejarlo como esta
                            "txtIMPORTE_DET" => number_format(((($detalle['valor_venta'])*(1 + $documento_igv)))/((1+ $documento_igv)+ ($documento->rc)), 2, '.', ''),
                            "txtCOD_TIPO_OPERACION" => $detalle['codigo_afectacion'], #Dejarlo como esta
                            "txtCODIGO_DET" => $detalle['codigo_producto'],
                            "txtDESCRIPCION_DET" => $detalle['nombre_producto'],
                            // "txtPRECIO_SIN_IGV_DET" => number_format(((($detalle['valor_unitario'])*1.18)/ ((1+ 0.18)+ ($documento->rc/100))), 6, '.', '')
                            "txtPRECIO_SIN_IGV_DET" => number_format((((($detalle['valor_unitario'])*(1+ $documento_igv)))/ ((1+ $documento_igv)+ ($documento->rc))), 6, '.', '')
                        ];
                    } else {
                        $productos[] = [
                            "txtITEM" => $item,
                            //"CODIGO_PRODUCTO_SUNAT" => $value['cod_sunat'], #codigo clase de producto
                            "txtUNIDAD_MEDIDA_DET" => "NIU", #dejarlo en NIU la Unidad de Medida
                            "txtCANTIDAD_DET" => $detalle['cantidad'],
                            "txtPRECIO_DET" => number_format($detalle['precio_unitario'], 6, '.', ''), #TOTAL DEL PRODUCTO
                            "txtPRECIO_TIPO_CODIGO" => "01", #Dejarlo como esta
                            "txtIGV" => number_format($detalle['total_igv'], 2, '.', ''),
                            "txtISC" => "0",  #Dejarlo como esta
                            "txtIMPORTE_DET" => number_format($detalle['valor_venta'], 2, '.', ''),
                            "txtCOD_TIPO_OPERACION" => $detalle['codigo_afectacion'], #Dejarlo como esta
                            "txtCODIGO_DET" => $detalle['codigo_producto'],
                            "txtDESCRIPCION_DET" => $detalle['nombre_producto'],
                            "txtPRECIO_SIN_IGV_DET" => number_format($detalle['valor_unitario'], 6, '.', '')
                        ];
                    }
                }
            }
            if($documento->consumo == '1'){
                $productos[] = [
                    "txtITEM" => '1',
                    "txtUNIDAD_MEDIDA_DET" => "NIU", #dejarlo en NIU la Unidad de Medidarmat(($documento->total / ()), 6, '.', ''), #TOTAL DEL 
                    "txtCANTIDAD_DET" => "1",
                    "txtPRECIO_DET" => number_format((($documento->total +$documento->descuento_monto + $documento->comision_delivery) / ((1+ $documento->rc))), 6, '.', ''), #TOTAL DEL PRODUCTO
                    "txtPRECIO_TIPO_CODIGO" => "01", #Dejarlo como esta
                    // "txtIGV" => number_format(($documento->total - ($documento->total / ((1+ $documento_igv)))), 2, '.', ''), // total - base
                    "txtIGV" => number_format(((($documento->total +$documento->descuento_monto + $documento->comision_delivery) / ((1+ $documento_igv)+ ($documento->rc)))* $documento_igv), 2, '.', ''), 
                    "txtISC" => "0",  #Dejarlo como esta
                    "txtIMPORTE_DET" => number_format((($documento->total+$documento->descuento_monto + $documento->comision_delivery) / ((1+ $documento_igv)+ ($documento->rc))), 2, '.', ''),
                    "txtCOD_TIPO_OPERACION" => "10", #Dejarlo como esta
                    "txtCODIGO_DET" => "CON0001",
                    "txtDESCRIPCION_DET" => $documento->consumo_desc,
                    "txtPRECIO_SIN_IGV_DET" => number_format((($documento->total+$documento->descuento_monto + $documento->comision_delivery) / ((1+ $documento_igv)+ ($documento->rc))), 6, '.', '') // precio /igv
                ];
            }            


            $doc = ($documento->tipo_comprobante == '01') ? 'factura' : 'boleta';

            $ruta = ROOT_WS_SUNAT . "${doc}.php";

            if($total_ope_gravadas > 0){

                $total_gravadas = (($documento->total + $documento->comision_delivery) ) /  ((1+ $documento_igv) + ($documento->rc)); // nuevo sub total
                $total_gravadas_descuento  = (($documento->total+ $documento->descuento_monto + $documento->comision_delivery) ) /  (1 + $documento_igv);
                $total_exoneradas = "0";

                 $sub_tot = ($documento->descuento_monto > 0)? number_format(((($total_gravadas_descuento) - ( $documento->descuento_monto/(1+ $documento_igv)))*$documento_igv), 2, '.', '')  : number_format((($total_gravadas * $documento_igv)), 2, '.', ''); // igv 

                 $sub_tot1 =  ($documento->descuento_monto > 0)? number_format(((($total_gravadas_descuento) - ( $documento->descuento_monto/(1+ $documento_igv)))/(1 + ($documento->rc))  ), 2, '.', '') : number_format((($total_gravadas)), 2, '.', ''); 


                 $totales = ($documento->descuento_monto > 0)? number_format((($sub_tot1 + $sub_tot)), 2, '.', '') : number_format((($total_gravadas + $sub_tot)), 2, '.', '');

                 $totales_2 = number_format($totales + $documento->comision_rc, 2, '.', '');
                 $dscto_global = number_format(($documento->descuento_monto / (1+$documento_igv)), 2, '.', '');
                 $total_descuento = "0";
             } else {

                 $sub_tot = number_format(0, 2, '.', '');
                 $sub_tot1 = number_format(((($documento->total + $documento->comision_delivery))), 0, '.', '');
                 $totales = number_format((($documento->total + $documento->comision_delivery) ), 0, '.', '');
                 $totales_2 = number_format((($documento->total + $documento->comision_delivery)- $documento->descuento_monto), 0, '.', '');
                 $total_gravadas = "0";
                 $total_exoneradas = ($documento->total + $documento->comision_delivery);
                 $dscto_global = number_format(($documento->descuento_monto), 2, '.', '');
                 $total_descuento = number_format(($documento->descuento_monto), 0, '.', '');
             }

             $sub_total = ($total_ope_gravadas > 0) ? $total_gravadas : $total_exoneradas;

             $sub_total_descuento  = ($total_ope_gravadas > 0) ? ($total_gravadas_descuento - ($documento->descuento_monto /(1 + $documento_igv)) ) : $total_exoneradas;
             $dscto_subtotal = ($sub_total_descuento / (1 + ($documento->rc))); // 95.76 // 70.00
             $dscto_porcentaje = $dscto_global / $dscto_subtotal; // 0.26% // 1.00

             $rc_porcentaje = number_format(($documento->comision_rc / $sub_total), 2, '.', '');
             $rc_global = number_format(($documento->comision_rc), 2, '.', '');
             $rc_subglobal =($documento->descuento_monto > 0)? $sub_tot1 :  $sub_total;  

            //CALCULOS FIN
            $data = [
                //Cabecera del documento
                "tipo_proceso" => FAE_ENTORNO,
                "pass_firma" => $empresa->clavecertificado,
                "tipo_operacion" => "0101",
                "total_gravadas" => ($documento->descuento_monto > 0)? number_format($sub_tot1, 2, '.', '') : number_format($total_gravadas, 2, '.', ''), #subtotal
                "total_inafecta" => 0,
                "total_exoneradas" => number_format($total_exoneradas, 2, '.', ''),
                "total_gratuitas" => 0,
                "total_exportacion" => "0",
                //
                "total_descuento" => $total_descuento,
                "dscto_global" => number_format($dscto_global, 2, '.', ''),
                "dscto_porcentaje" => number_format($dscto_porcentaje, 5, '.', ''),// dscto_global / dscto_subtotal
                "dscto_subtotal" =>  number_format($dscto_subtotal, 2, '.', ''),// sub_total + dscto_global
                //
                "sub_total" => $sub_tot1, #subtotal

                "porcentaje_igv" => $documento->impuesto, #El IGV debe ser 18, si lo tienes en 0.18, conviértelo a 18
                "total_igv" =>  $sub_tot,
                "total_isc" => "0",
                "total_otr_imp" => "0",
                "total" => $totales,
                "total_2" => $totales_2,
                
                "rc_porcentaje" => $rc_porcentaje,
                "rc_global" => number_format($rc_global, 2, '.', ''),
                "rc_subglobal" => number_format($rc_subglobal, 2, '.', ''),
                
                "total_letras" => "",
                "nro_guia_remision" => "",
                "cod_guia_remision" => "",
                "nro_otr_comprobante" => "",
                "serie_comprobante" => $documento->serie_doc, //Para boletas la serie debe comenzar por la letra B, seguido de tres dígitos
                "numero_comprobante" => $documento->nro_doc,
                "fecha_comprobante" => $documento->fecha,
                "fecha_vto_comprobante" => $documento->fecha,
                "cod_tipo_documento" => $documento->tipo_comprobante, #codigo de tipodocumento de sunat
                "cod_moneda" => "PEN", #sigla de la moneda
                //Datos del cliente
                "cliente_numerodocumento" => $documento->numero_documento,
                "cliente_nombre" => $documento->razon_social,
                "cliente_tipodocumento" => $documento->tipo_documento, //1: DNI codigo de tipodocumento de sunat
                "cliente_direccion" => $documento->direccion,
                "cliente_pais" => "PE",
                "cliente_ciudad" => "Lima",
                "cliente_codigoubigeo" => "",
                "cliente_departamento" => "",
                "cliente_provincia" => "",
                "cliente_distrito" => "",
                //data de la empresa emisora o contribuyente que entrega el documento electrónico.
                "emisor" => [
                    "ruc" => $empresa->ruc,
                    "tipo_doc" => "6",
                    "nom_comercial" => $empresa->nombre_comercial,
                    "razon_social" => $empresa->razon_social,
                    "codigo_ubigeo" => $empresa->ubigeo,
                    "direccion" => $empresa->direccion_fiscal,
                    "direccion_departamento" => $empresa->departamento,
                    "direccion_provincia" => $empresa->provincia,
                    "direccion_distrito" => $empresa->distrito,
                    "direccion_codigopais" => "PE",
                    "usuariosol" => $empresa->usuariosol,
                    "clavesol" => $empresa->clavesol
                ],
                //items del documento
                "detalle" => $productos,
                // OSE
                "ose" => [
                    "ose" => OSE,
                    "ose_url" => OSE_URL
                ],
                "pse" => SEND_DOCUMENT_TO_PSE,
                "pse_company" => $empresa
            ];

            //Invocamos el servicio
            $token = ''; //en caso quieras utilizar algún token generado desde tu sistema
            //codificamos la data

            $data_json = json_encode($data);

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $ruta);
            curl_setopt(
                    $ch, CURLOPT_HTTPHEADER, array(
                'Authorization: Token token="' . $token . '"',
                'Content-Type: application/json',
                    )
            );
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $data_json);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            $rs = json_decode(curl_exec($ch));
            curl_close($ch);
                        
            $enviado_sunat = (@$rs->respuesta == 'OK') ? '1' : '0';
            $code_respuesta_sunat = @$rs->cod_sunat;
            $descripcion_sunat_cdr = @$rs->msj_sunat;
            $name_file_sunat = @$rs->file;
            $hash_cdr = @$rs->hash_cdr;
            $hash_cpe = @$rs->hash_cpe;
            $msj_pse = @$rs->msj_pse;
            $msj_pse_cdr = @$rs->msj_pse_cdr;
            $state_typeid = @$rs->state_type;

            if ($enviado_sunat == 1) {
                $stm = $this->db->prepare("UPDATE tm_venta SET enviado_sunat =  '".$enviado_sunat."', code_respuesta_sunat = '".$code_respuesta_sunat."', descripcion_sunat_cdr = '".$descripcion_sunat_cdr."', name_file_sunat = '".$name_file_sunat."', hash_cdr = '".$hash_cdr."', hash_cpe = '".$hash_cpe."' , xml_pse = '".$msj_pse."' , cdr_pse = '".$msj_pse_cdr."', state_type_id = '".$state_typeid."' WHERE id_venta = ?");
            
                $stm->execute(array($cod_ven));
            }

            $respuesta = array('enviado_sunat' => $enviado_sunat, 'mensaje' => $descripcion_sunat_cdr);
            // $respuesta = array('enviado_sunat' => $enviado_sunat, 'mensaje' => var_dump($rs));
        endif;   

        if($num == 1){
            echo json_encode($respuesta);
        }else{
            return json_encode($respuesta);
        }  
    }

    public function postComunicacionBaja($post) {

        date_default_timezone_set($_SESSION["zona_horaria"]);
        setlocale(LC_ALL,"es_ES@euro","es_ES","esp");
        $cod_ven = $post['cod_ven'];
        $tipo_doc = $post['tipo_doc'];
        
        $api = new ApiModel();
        $empresa = $api->getEmpresa();
        $comunicacion = $api->generar_numero_baja($tipo_doc);
        if (empty($comunicacion->numero)) {
            throw new Exception("El Nro de la Comunicación de baja no existe", 1);
        }

        $documento = $api->buscar_documento($cod_ven);

        $fecha_referencia = date('Y-m-d',strtotime($documento->fecha_venta));
        $fecha_baja = date('Y-m-d');

        $cabecera = array();
        $cabecera['fecha_registro'] = date('Y-m-d H:i:s');
        $cabecera['fecha_baja'] = $fecha_baja;
        $cabecera['fecha_referencia'] = $fecha_referencia;
        $cabecera['tipo_doc'] = $documento->tipo_comprobante;
        $cabecera['serie_doc'] = $documento->serie_doc;
        $cabecera['num_doc'] = $documento->nro_doc;
        if($tipo_doc == 1){
            $cabecera['nombre_baja'] = 'ERROR DE CLIENTE';
        }
        $cabecera['correlativo'] = $comunicacion->numero;
        $cabecera['estado'] = 'a';
        // $cabecera['state_type_id'] = '03';

        $fecha_baja_limit = date("Y-m-d",strtotime($fecha_baja."- ".DIAS_ANULACION." days")); 

        if ($fecha_baja_limit >  $fecha_referencia) { 
            $respuesta = array('enviado_sunat' => '0', 'mensaje' => 'El documento excede los '.DIAS_ANULACION.' días válidos para ser anulado.');
        }else{

            if ($documento->estado == 'i'):
                $respuesta = array('enviado_sunat' => '0', 'mensaje' => 'El documento N°'.$documento->serie_doc.'-'.$documento->nro_doc.' ya ha sido enviado a SUNAT');
            else:
    
                $detalle = array();
                if($tipo_doc == 1){
                    $ruta = ROOT_WS_SUNAT . "baja.php";
                    $codigo = "RA";
                    $fecha_text_opc = "fecha_baja";
                    $detalle[] = [
                        "ITEM" => "1",
                        "TIPO_COMPROBANTE" => $documento->tipo_comprobante,
                        "SERIE" => $documento->serie_doc,
                        "NUMERO" => $documento->nro_doc,
                        "MOTIVO" => "ERROR DE CLIENTE" #Motivo baja
                    ];
                }
    
                if($tipo_doc == 3){
                    $ruta = ROOT_WS_SUNAT . "resumen_boletas.php";
                    $codigo = "RC";
                    $fecha_text_opc = "fecha_documento";
                    $detalle[] = [
                        "ITEM" => "1",
                        "TIPO_COMPROBANTE" => $documento->tipo_comprobante,
                        "NRO_COMPROBANTE" => $documento->serie_doc."-".$documento->nro_doc,
                        "NRO_DOCUMENTO" => $documento->dni,
                        "TIPO_DOCUMENTO" => $documento->tipo_documento,
                        "NRO_COMPROBANTE_REF" => "0",
                        "TIPO_COMPROBANTE_REF" => "0",
                        "STATUS" => "3",// 3 ANULADOS- 1:NUEVOS
                        "COD_MONEDA" => $documento->tipo_moneda,
                        "TOTAL" => number_format($documento->total_facturado, 2, '.', ''),
                        "GRAVADA" => number_format($documento->total_gravadas, 2, '.', ''),
                        "IGV" => number_format($documento->total_igv, 2, '.', ''),
                        "EXONERADO" => "0",
                        "INAFECTO" => "0",
                        "EXPORTACION" => "0",
                        "GRATUITAS" => "0",
                        "MONTO_CARGO_X_ASIG" => "0",
                        "CARGO_X_ASIGNACION" => "0",
                        "ISC" => "0",
                        "OTROS" => "0"
                    ];
                }
    
                $data = [
                    "status_r" => 'voided',
                    "tipo_proceso" => FAE_ENTORNO,
                    "pass_firma" => $empresa->clavecertificado,
                    //Cabecera del documento
                    "codigo" => $codigo,
                    "serie" => date('Ymd'),
                    "secuencia" => $comunicacion->numero,
                    "fecha_referencia" => $fecha_referencia,
                    $fecha_text_opc => $fecha_baja,
                    //data de la empresa emisora o contribuyente que entrega el documento electrónico.
                    "emisor" => [
                        "ruc" => $empresa->ruc,
                        "tipo_doc" => "6",
                        "nom_comercial" => $empresa->nombre_comercial,
                        "razon_social" => $empresa->razon_social,
                        "codigo_ubigeo" => $empresa->ubigeo,
                        "direccion" => $empresa->direccion_fiscal,
                        "direccion_departamento" => $empresa->departamento,
                        "direccion_provincia" => $empresa->provincia,
                        "direccion_distrito" => $empresa->distrito,
                        "direccion_codigopais" => "PE",
                        "usuariosol" => $empresa->usuariosol,
                        "clavesol" => $empresa->clavesol
                    ],
                    //items
                    "detalle" => $detalle,
                    //OSE 
                    "ose" => [
                        "ose" => OSE,
                        "ose_url" => OSE_URL
                    ],
                    "pse" => SEND_DOCUMENT_TO_PSE,
                    "pse_company" => $empresa,
                    "pse_status" => 'anu'
                ];
    
                $token = '';
                $data_json = json_encode($data);
    
                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL, $ruta);
                curl_setopt(
                        $ch, CURLOPT_HTTPHEADER, array(
                    'Authorization: Token token="' . $token . '"',
                    'Content-Type: application/json',
                        )
                );
                curl_setopt($ch, CURLOPT_POST, 1);
                curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
                curl_setopt($ch, CURLOPT_POSTFIELDS, $data_json);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                $rsp = json_decode(curl_exec($ch));
                curl_close($ch);
    
                $enviado_sunat                      = (@$rsp->respuesta == 'OK') ? '1' : '0';
                $enviado_sunat_request              = (@$rsp->resp_envio_respuesta == 'OK') ? '1' : '0';
                // $enviado_sunat_ticket               = (@$rsp->resp_ticket_respuesta == 'OK') ? '1' : '0';

                $resp_envio_state_type              = @$rsp->resp_envio_state_type;
                $resp_envio_ticket                  = @$rsp->resp_envio_ticket;
                // $resp_ticket_state_type             = @$rsp->resp_ticket_state;
                // $resp_ticket_code_respuesta_sunat   = @$rsp->resp_ticket_cod_sunat;
                // $resp_ticket_descripcion_sunat_cdr  = @$rsp->resp_ticket_msj_sunat;
                // $resp_ticket_hash_cdr               = @$rsp->resp_ticket_hash_cdr;

                $hash_cpe                           = @$rsp->hash_cpe;
                $name_file_sunat                    = @$rsp->file;
                
                $respuesta_descp                    = '';
                if ($enviado_sunat == 1 && $enviado_sunat_request == 1) {
                    $cabecera['state_type_id'] = '03';
                    $cabecera['ticket'] = $resp_envio_ticket;
                
                    $rpta = $api->registrar_baja($cabecera, $cod_ven, $resp_envio_state_type);
                    $respuesta_descp = 'Baja pendiente';
                
                    // if ($rpta && $enviado_sunat_ticket == 1) {
                    //     $dato = [
                    //         'id_comunicacion' => $rpta->idcomunicacion,
                    //         'hash_cpe' => $hash_cpe,
                    //         'hash_cdr' => $resp_ticket_hash_cdr,
                    //         'code_respuesta_sunat' => $resp_ticket_code_respuesta_sunat,
                    //         'descripcion_sunat_cdr' => $resp_ticket_descripcion_sunat_cdr,
                    //         'name_file_sunat' => $name_file_sunat
                    //     ];
                        
                    //     $rpta = $api->actualizar_cdr_baja($dato, $rpta->idcomunicacion, $cod_ven, $resp_ticket_state_type);
                
                    //     $respuesta_descp = $resp_ticket_descripcion_sunat_cdr;
                    // }
                }
    
                $respuesta = array('enviado_sunat' => $enviado_sunat, 'mensaje' => $respuesta_descp);
                // $respuesta = array('enviado_sunat' => '', 'mensaje' => var_dump($rsp));
            endif;        
        
        }

        echo json_encode($respuesta);
            
    }

    public function postResumenDiario($post) {

        date_default_timezone_set($_SESSION["zona_horaria"]);
        setlocale(LC_ALL,"es_ES@euro","es_ES","esp");
        
        $api = new ApiModel();
        $empresa = $api->getEmpresa();
        $resumen = $api->generar_numero_resumen();
        if (empty($resumen->numero)) {
            throw new Exception("El Nro de Resumen no existe", 1);
        }

        $fecha_referencia = date('Y-m-d',strtotime($post['fecha']));
        $fecha_resumen = date('Y-m-d');
        $fecha = date('Y-m-d',strtotime($post['fecha']));

        $boletas = $api->buscar_boletas($fecha);

        if (empty($boletas)):
            $respuesta = array('enviado_sunat' => '0', 'mensaje' => 'No existe boletas en la fecha consultada');
        else:

            $cabecera = array();
            $cabecera['fecha_registro'] = date('Y-m-d H:i:s');
            $cabecera['fecha_resumen'] = $fecha_resumen;
            $cabecera['fecha_referencia'] = $fecha_referencia;
            $cabecera['correlativo'] = $resumen->numero;
            $cabecera['estado'] = 'a';

            $detalleResumen = array();
            foreach ($boletas as $boleta)
            {
                $detalleResumen[] = array(
                    'id_resumen' => '',
                    'id_venta' => $boleta->id_venta,
                    'status_code' => $boleta->status_code
                );
            }

            $ruta = ROOT_WS_SUNAT . "resumen_boletas.php";

            $contador = 1;
            $detalle = [];
            foreach ($boletas as $boleta){
                $detalle[] = [
                    "ITEM" => $contador,
                    "TIPO_COMPROBANTE" => $boleta->tipo_comprobante,
                    "NRO_COMPROBANTE" => $boleta->serie_doc."-".$boleta->nro_doc,
                    "NRO_DOCUMENTO" => $boleta->dni,
                    "TIPO_DOCUMENTO" => $boleta->tipo_documento,
                    "NRO_COMPROBANTE_REF" => "0",
                    "TIPO_COMPROBANTE_REF" => "0",
                    "STATUS" => "1",//3-resumen dirio de boletas
                    "COD_MONEDA" => $boleta->tipo_moneda,
                    "TOTAL" => number_format($boleta->total_facturado, 2, '.', ''),
                    "GRAVADA" => number_format($boleta->total_gravadas, 2, '.', ''),
                    "IGV" => number_format($boleta->total_igv, 2, '.', ''),
                    "EXONERADO" => "0",
                    "INAFECTO" => "0",
                    "EXPORTACION" => "0",
                    "GRATUITAS" => "0",
                    "MONTO_CARGO_X_ASIG" => "0",
                    "CARGO_X_ASIGNACION" => "0",
                    "ISC" => "0",
                    "OTROS" => "0"
                ];
                $contador++;
            }

            $data = array(
                "status_r" => 'summary',
                "tipo_proceso" => FAE_ENTORNO,
                "pass_firma" => $empresa->clavecertificado,
                //Cabecera del documento
                "codigo" => "RC",
                "serie" => date('Ymd'),
                "secuencia" => $resumen->numero,
                "fecha_referencia" => $fecha_referencia,
                "fecha_documento" => $fecha_resumen,
                //data de la empresa emisora o contribuyente que entrega el documento electrónico.
                "emisor" => array(
                    "ruc" => $empresa->ruc,
                    "tipo_doc" => "6",
                    "nom_comercial" => $empresa->nombre_comercial,
                    "razon_social" => $empresa->razon_social,
                    "codigo_ubigeo" => $empresa->ubigeo,
                    "direccion" => $empresa->direccion_fiscal,
                    "direccion_departamento" => $empresa->departamento,
                    "direccion_provincia" => $empresa->provincia,
                    "direccion_distrito" => $empresa->distrito,
                    "direccion_codigopais" => "PE",
                    "usuariosol" => $empresa->usuariosol,
                    "clavesol" => $empresa->clavesol
                ),
                "detalle" => $detalle,
                //OSE 
                "ose" => [
                    "ose" => OSE,
                    "ose_url" => OSE_URL
                ],
                "pse" => SEND_DOCUMENT_TO_PSE,
                "pse_company" => $empresa,
                "pse_status" => 'resu'
            );

            $token = ''; 
            $data_json = json_encode($data);

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $ruta);
            curl_setopt(
                    $ch, CURLOPT_HTTPHEADER, array(
                'Authorization: Token token="' . $token . '"',
                'Content-Type: application/json',
                    )
            );

            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $data_json);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            $rsp = json_decode(curl_exec($ch));
            curl_close($ch);

            $enviado_sunat                      = (@$rsp->respuesta == 'OK') ? '1' : '0';
            $enviado_sunat_request              = (@$rsp->resp_envio_respuesta == 'OK') ? '1' : '0';
            // $enviado_sunat_ticket               = (@$rsp->resp_ticket_respuesta == 'OK') ? '1' : '0';

            $resp_envio_state_type              = @$rsp->resp_envio_state_type;
            $resp_envio_ticket                  = @$rsp->resp_envio_ticket;
            // $resp_ticket_state_type             = @$rsp->resp_ticket_state;
            // $resp_ticket_code_respuesta_sunat   = @$rsp->resp_ticket_cod_sunat;
            // $resp_ticket_descripcion_sunat_cdr  = @$rsp->resp_ticket_msj_sunat;
            // $resp_ticket_hash_cdr               = @$rsp->resp_ticket_hash_cdr;

            $hash_cpe                           = @$rsp->hash_cpe;
            $name_file_sunat                    = @$rsp->file;
             
            $respuesta_descp                    = '';
            if ($enviado_sunat == 1 && $enviado_sunat_request == 1) {
                $cabecera['state_type_id'] = '03';
                $cabecera['ticket'] = $resp_envio_ticket;
                $rpta = $api->registrar_resumen($cabecera,$detalleResumen, $resp_envio_state_type);   
                $respuesta_descp = 'Resumen pendiente';
                // if ($rpta && $enviado_sunat_ticket == 1) {
                //     $dato = [
                //         'id_resumen' => $rpta->idresumen,
                //         'hash_cpe' => $hash_cpe,
                //         'hash_cdr' => $resp_ticket_hash_cdr,
                //         'code_respuesta_sunat' => $resp_ticket_code_respuesta_sunat,
                //         'descripcion_sunat_cdr' => $resp_ticket_descripcion_sunat_cdr,
                //         'name_file_sunat' => $name_file_sunat
                //     ];
                //     $rpta = $api->actualizar_cdr_resumen($dato, $rpta->idresumen, $detalleResumen, $resp_ticket_state_type);
                //     $respuesta_descp = $resp_ticket_descripcion_sunat_cdr;
                // }
                
            }

            $respuesta = array('enviado_sunat' => $enviado_sunat, 'mensaje' => $respuesta_descp);

        endif; 

        echo json_encode($respuesta);

    }

    public function postConsultaticket($post,$num = false) {

        date_default_timezone_set($_SESSION["zona_horaria"]);
        setlocale(LC_ALL,"es_ES@euro","es_ES","esp");

        $cod_ticket = $post['cod_ticket'];
 
        $tipo_ticket = (isset($post['tipo_ticket']))? $post['tipo_ticket'] : 'baja';

        $api = new ApiModel();
        $empresa = $api->getEmpresa();

        if ($tipo_ticket == 'resum_bol') {
            $documento = $api->buscar_resumen($cod_ticket);
            $fecha_baja = date('Ymd',strtotime($documento->fecha_resumen));
            // var_dump($cod_ven);
   
        }else{
            $documento = $api->buscar_baja($cod_ticket);
            $cod_ven = $api->buscar_baja_documento($documento->serie_doc,$documento->num_doc);
    
            $fecha_baja = date('Ymd',strtotime($documento->fecha_baja));
            // var_dump($cod_ven);
        }

        $ruta = ROOT_WS_SUNAT . "consulta_ticket.php";
        
        $codigo = isset($documento->tipo_doc) ? ($documento->tipo_doc == '01' ? "RA" : "RC") : "RC";

        // factura 01
        // boleta 03

        $data = [
            "tipo_proceso" => FAE_ENTORNO,
            "pass_firma" => $empresa->clavecertificado,
            "ticket" => $cod_ticket,
            //Cabecera del documento
            "codigo" => $codigo,
            "serie" => $fecha_baja,
            "secuencia" => $documento->correlativo,
            //data de la empresa emisora o contribuyente que entrega el documento electrónico.
            "emisor" => [
                "ruc" => $empresa->ruc,
                "tipo_doc" => "6",
                "nom_comercial" => $empresa->nombre_comercial,
                "razon_social" => $empresa->razon_social,
                "codigo_ubigeo" => $empresa->ubigeo,
                "direccion" => $empresa->direccion_fiscal,
                "direccion_departamento" => $empresa->departamento,
                "direccion_provincia" => $empresa->provincia,
                "direccion_distrito" => $empresa->distrito,
                "direccion_codigopais" => "PE",
                "usuariosol" => $empresa->usuariosol,
                "clavesol" => $empresa->clavesol
            ],
            //OSE 
            "ose" => [
                "ose" => OSE,
                "ose_url" => OSE_URL
            ],
            "pse" => SEND_DOCUMENT_TO_PSE,
            "pse_company" => $empresa,
            "pse_status" => 'anu'
        ];

        $token = '';
        $data_json = json_encode($data);

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $ruta);
        curl_setopt(
                $ch, CURLOPT_HTTPHEADER, array(
            'Authorization: Token token="' . $token . '"',
            'Content-Type: application/json',
                )
        );
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data_json);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $rsp = json_decode(curl_exec($ch));
        curl_close($ch);

        // var_dump($rsp);

        $enviado_sunat                      = (@$rsp->respuesta == 'OK') ? '1' : '0';
        $enviado_sunat_ticket               = (@$rsp->resp_ticket_respuesta == 'OK') ? '1' : '0';

        $resp_ticket_state_type             = @$rsp->resp_ticket_state;
        $resp_ticket_code_respuesta_sunat   = @$rsp->resp_ticket_cod_sunat;
        $resp_ticket_descripcion_sunat_cdr  = @$rsp->resp_ticket_msj_sunat;
        $resp_ticket_hash_cdr               = @$rsp->resp_ticket_hash_cdr;

        // $hash_cpe                           = @$rsp->hash_cpe;
        $name_file_sunat                    = @$rsp->file;
        
        $respuesta_descp                    = '';
        if ($enviado_sunat == 1 && $enviado_sunat_ticket == 1) {
           
            if ($tipo_ticket == 'resum_bol') {

                $dato = [
                    'id_resumen' => $documento->id_resumen,
                    'hash_cpe' => '0',
                    'hash_cdr' => $resp_ticket_hash_cdr,
                    'code_respuesta_sunat' => $resp_ticket_code_respuesta_sunat,
                    'descripcion_sunat_cdr' => $resp_ticket_descripcion_sunat_cdr,
                    'name_file_sunat' => $name_file_sunat
                ];
                
                $rpta = $api->actualizar_cdr_resumen($dato, $documento->id_resumen, $resp_ticket_state_type);

            }else{

                $dato = [
                    'id_comunicacion' => $documento->id_comunicacion,
                    'hash_cpe' => '0',
                    'hash_cdr' => $resp_ticket_hash_cdr,
                    'code_respuesta_sunat' => $resp_ticket_code_respuesta_sunat,
                    'descripcion_sunat_cdr' => $resp_ticket_descripcion_sunat_cdr,
                    'name_file_sunat' => $name_file_sunat
                ];
                    
                $rpta = $api->actualizar_cdr_baja($dato, $documento->id_comunicacion, $cod_ven->id_venta, $resp_ticket_state_type);
        
            }
        
                $respuesta_descp = $resp_ticket_descripcion_sunat_cdr;
            }
        

            $respuesta = array('enviado_sunat' => $enviado_sunat_ticket, 'mensaje' => $respuesta_descp);
            // $respuesta = array('enviado_sunat' => '0', 'mensaje' => var_dump($rpta));


            if($num == 2){
                return json_encode($respuesta);
            }else{
                echo json_encode($respuesta);
            }   
            
        }

}
?>
